﻿-- Author      : Apoco
-- Create Date : 4/23/2008 2:02:15 PM
local bb = LibStub("LibBabble-Boss-3.0"):GetLookupTable()
local module = RBM:NewBossModule(bb["High King Maulgar"])
module:SetZones(LibStub("LibBabble-Zone-3.0"):GetLookupTable()["Gruul's Lair"])
local mageName = bb["Krosh Firehand"]
local lockName = bb["Olm the Summoner"]
local priestName = bb["Blindeye the Seer"]
local shamanName = bb["Kiggler the Crazed"]

local L = module:GetTranslations(true)
module:RegisterTranslations("enUS",
	"Spell Shield", true,
	"Shield", true,
	"Summon Felhunter", true,
	"Whirlwind", true,
	"Arcing Smash", true,
	"Felhunter", true,
	"Flurry", true,
	"Prayer of Healing", true,
	"YellEngage", "Gronn are the real power in Outland!"
)
module:RegisterTranslations("zhTW",
	"Spell Shield", "法術護盾",
	"Shield", "護盾",
	"Summon Felhunter", "召喚惡魔獵犬",
	"Whirlwind", "旋風斬",
	"Arcing Smash", "圓弧斬",
	"Felhunter", "惡魔獵犬",
	"Flurry", "亂舞",
	"Prayer of Healing", "治療禱言",
	"YellEngage", "戈魯爾才是外域的主宰!"
)
module:RegisterTranslations("zhCN",
	"Spell Shield", "法术护盾",
	"Shield", "护盾",
	"Summon Felhunter", "召喚惡魔獵犬",
	"Whirlwind", "召唤地狱犬",
	"Arcing Smash", "圆弧斩",
	"Felhunter", "地狱犬",
	"Flurry", "乱舞",
	"Prayer of Healing", "治疗祷言",
	"YellEngage", "戈隆才是外域的主宰！"
)
module:RegisterTranslations("koKR",
	"Spell Shield", "주문 보호막",
	"Shield", "보호막",
	"Summon Felhunter", "지옥사냥개 소환",
	"Whirlwind", "소용돌이",
	"Arcing Smash", "회전베기",
	"Felhunter", "지옥사냥개",
	"Flurry", "질풍",
	"Prayer of Healing", "치유 시전",
	"YellEngage", "그론이 아웃랜드의 진정한 강자다!"
)

local playerclass = select(2, UnitClass("player"))
function module:OnInitialize()
	self:RegisterToggles(L["Heals"], true,
						 L["Spell Shield"], true,
						 L["Shield"], true,
						 L["Summon Felhunter"], true,
						 L["Whirlwind"], true,
						 L["Flurry"], true,
						 L["Arcing Smash"], true
						)
	self:RegisterStartEvents("CHAT_MSG_MONSTER_YELL")
	self.SpellShieldLabel = L["Next %s"]:format(L["Spell Shield"])
	self.NextWhirlwindLabel = L["Next %s"]:format(L["Whirlwind"])
	self.FelhunterCastLabel = L["%s Casting"]:format(L["Summon Felhunter"])
	self.FelhunterLabel = L["Next %s"]:format(L["Felhunter"])
	self.PoHLabel = L["%s Casting"]:format(L["Prayer of Healing"])
	self.HealLabel = L["%s Casting"]:format(L["Heal"])
end

function module:CheckStart(event, msg)
	return msg == L["YellEngage"]
end

function module:OnStart()
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	if self:CheckToggle(L["Whirlwind"]) then
		self:Sync("Whirlwind", true)
	end
	if self:CheckToggle(L["Spell Shield"]) then
		self:Sync("SpellShield", true)
	end
end

function module:COMBAT_LOG_EVENT_UNFILTERED(_, _, event, _, _, _, _, name, _, id, spell)
	if event == "SPELL_AURA_APPLIED" then
		if id == 33147 then
			self:Sync("Shield")
			
		elseif id == 33054 and name == mageName then
			self:Sync("SpellShield")
		
		elseif id == 33238 then
			self:Sync("Whirlwind")
		end
	
	elseif event == "SPELL_CAST_START" then
		if id == 33131 then
			self:Sync("Felguard")
		
		elseif id == 33152 or id == 33144 then
			self:Sync("Heal", id)
		end
	
	elseif event == "SPELL_CAST_SUCCESS" then
		if id == 39144 then
			self:Sync("Smash")
		
		elseif id == 33232 then
			self:Sync("Flurry")
		end
	end
end

function module:OnSync(msg, name)
	if msg == "Shield" and self:CheckToggle(L["Shield"]) then
		self:Announce("High", L["%s: %s"], L["Shield"], priestName, 33147)
	
	elseif msg == "SpellShield" and self:CheckToggle(L["Spell Shield"]) then
		if not name then
			self:Announce("High", L["Spell Shield"], 33054)
			if playerclass == "MAGE" and UnitName("target") == mageName then
				self:Alert("High", L["Spellsteal!"], 33054)
				self:FullPlayerAlert()
			end
		end
		self:BossBar(self.SpellShieldLabel, "Cooldown", 30, 33054)
	
	elseif msg == "Whirlwind" and self:CheckToggle(L["Whirlwind"])  then
		if not name then
			self:Announce("Normal", L["Whirlwind"], 33238)
			self:BossBar(L["Whirlwind"], "Buff", 15, 33238)
		end
		self:BossBar(self.NextWhirlwindLabel, "Cooldown", 50, 33238)
		self:ScheduleAnnounce(45, "Normal", L["%s: ~%d Seconds"], L["Whirlwind"], 5, 33238)
	
	elseif msg == "Felguard" and self:CheckToggle(L["Summon Felhunter"]) then
		self:Announce("High", L["%s Incoming"], L["Felhunter"], 33131)
		self:BossBar(self.FelhunterCastLabel, "Cast", 3, 33131)
		self:BossBar(self.FelhunterLabel, "Cooldown", 50, 33131)
	
	elseif msg == "Heal"  and self:CheckToggle(L["Heals"]) then
		self:Announce("High", L["%s Incoming"], L["Heal"], name)
		local label, dur = self.PoHLabel, 4
		if name == 33144 then
			label = self.HealLabel; dur = 1.5
		end
		self:BossBar(label, "Cast", dur, name)
	
	elseif msg == "Smash"  and self:CheckToggle(L["Arcing Smash"]) then
		self:Announce("Low", string.upper(L["Arcing Smash"]), 39144)
		self:BossBar(L["Arcing Smash"], "Cooldown", 10, 39144)
	
	elseif msg == "Flurry"  and self:CheckToggle(L["Flurry"]) then
		self:Announce("Normal", L["Flurry"], 33232)
	end
end
