﻿-- Author      : Apoco
-- Create Date : 4/23/2008 2:02:23 PM

local module = RBM:NewBossModule(LibStub("LibBabble-Boss-3.0"):GetLookupTable()["Gruul the Dragonkiller"])
module:SetZones(LibStub("LibBabble-Zone-3.0"):GetLookupTable()["Gruul's Lair"])

local L = module:GetTranslations(true)
module:RegisterTranslations("enUS",
	"Grow", true,
	"Grasp", true,
	"Ground Slam", true,
	"Cave In", true,
	"Shatter", true,
	"Silence", true,
	"Grow: #%d", true,
	"Next Grow: #%d", true,
	"YellEngage", "Come.... and die.",
	"MsgCaveIn", "Your in a Cave In! MOVE!!"
)
module:RegisterTranslations("zhTW",
	"Grow", "成長",
	"Grasp", "破碎",
	"Ground Slam", "大地猛擊",
	"Cave In", "塌下",
	"Shatter", "破碎",
	"Silence", "沉默",
	"Grow: #%d", "成長: #%d",
	"Next Grow: #%d", "下一次成長: #%d",
	"YellEngage", "來……受死吧。",
	"MsgCaveIn", "塌下!快散開!"
)
module:RegisterTranslations("zhCN",
	"Grow", "成长",
	"Grasp", "碎裂",
	"Ground Slam", "大地冲击",
	"Cave In", "洞穴震颤",
	"Shatter", "碎裂",
	"Silence", "沉默",
	"Grow: #%d", "成长: #%d",
	"Next Grow: #%d", "下一次成长: #%d",
	"YellEngage", "来了……就得死。",
	"MsgCaveIn", "洞穴震颤！快跑！"
)
module:RegisterTranslations("koKR",
	"Grow", "성장",
	"Grasp", "손아귀",
	"Ground Slam", "땅 울리기",
	"Cave In", "함몰",
	"Shatter", "산산조각",
	"Silence", "침묵",
	"Grow: #%d", "성장: #%d",
	"Next Grow: #%d", "다음 성장: #%d",
	"YellEngage", "와서... 죽어라.",
	"MsgCaveIn", "당신은 함몰! 이동하세요!"
)

local player = UnitName("player")
function module:OnInitialize()
	self:RegisterToggles(L["Grow"], true,
						 L["Grasp"], true,
						 L["Cave In"], true,
						 L["Silence"], true,
						 L["Proximity Frame"], true)
	self:RegisterStartEvents("CHAT_MSG_MONSTER_YELL")
	RBM:DistanceFrameCreate(10)
	self.GraspLabel = L["Next %s"]:format(L["Grasp"])
	self.ShatterLabel = L["%s Casting"]:format(L["Shatter"])
	self.SilenceLabel = L["Next %s"]:format(L["Silence"])
end

function module:CheckStart(event, msg)
	return msg == L["YellEngage"]
end

function module:OnStart()
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	if self:CheckToggle(L["Proximity Frame"]) then
		RBM:DistanceFrameShow(10)
	end
	
	self.Grow = 0	
	if self:CheckToggle(L["Grasp"]) then
		self:ScheduleAnnounce(30, "Normal", L["%s Soon"], L["Ground Slam"], 33525)
		self:BossBar(self.GraspLabel, "Cooldown", 33, 33525, true)
	end
	if self:CheckToggle(L["Silence"]) then
		self:ScheduleAnnounce(97, "High", L["%s Soon"], L["Silence"], 36297)
		self:BossBar(self.SilenceLabel, "Cooldown", 102, 36297, true)
	end
	if self:CheckToggle(L["Grow"]) then
		self:BossBar(L["Next Grow: #%d"]:format(self.Grow+1), "Cooldown", 30, 36300, true)
	end
end

function module:COMBAT_LOG_EVENT_UNFILTERED(_, _, event, _, _, _, _, name, _, id, spell)
	if event == "SPELL_AURA_APPLIED" then
		if id == 36240 and name == player and self:CheckToggle(L["Cave In"]) then
			self:Alert("High", L["MsgCaveIn"], 36240)
			self:FullPlayerAlert()
		end
		
	elseif event == "SPELL_CAST_START" then
		if id == 33654 then
			self:Sync("Grasp", id)
		
		elseif id == 33525 then
			self:Sync("Slam", id)
		end
		
	elseif event == "SPELL_CAST_SUCCESS" then
		if id == 36300 then
			self:Sync("Grow", id)
		
		elseif id == 36297 then
			self:Sync("Silence", id)
		end
	end
end

function module:OnSync(msg, id)
	if msg == "Grasp" and self:CheckToggle(L["Grasp"]) then
		self:Announce("High", string.upper(L["Shatter"]), 33654)
		self:ScheduleAnnounce(56, "Normal", L["%s Soon"], L["Ground Slam"], 33525)
		self:BossBar(self.GraspLabel, "Cooldown", 62, id, true)
	
	elseif msg == "Slam" and self:CheckToggle(L["Grasp"]) then
		self:Announce("High", L["%s: ~%d Seconds"], L["Shatter"], 10, 33525)
		self:BossBar(self.ShatterLabel, "Cast", 10, id)
	
	elseif msg == "Grow" and self:CheckToggle(L["Grow"]) then
		self.Grow = self.Grow + 1
		self:Announce("High", L["Grow: #%d"], self.Grow, 36300)
		self:BossBar(L["Next Grow: #%d"]:format(self.Grow+1), "Cooldown", 30, id, true)
		
	elseif msg == "Silence" and self:CheckToggle(L["Silence"]) then
		self:Announce("High", string.upper(L["Silence"]), 36297)
		self:ScheduleAnnounce(28, "Normal", L["%s Soon"], L["Silence"], 36297)
		self:BossBar(self.SilenceLabel, "Cooldown", 31, id, true)
	end
end
