local GetNumAddOns = GetNumAddOns
local IsAddOnLoadOnDemand = IsAddOnLoadOnDemand
local IsAddOnLoaded = IsAddOnLoaded
local GetAddOnInfo = GetAddOnInfo
local GetAddOnMetadata = GetAddOnMetadata
local GetRealZoneText = GetRealZoneText
local unpack = unpack
local pairs = pairs
local select = select
local next = next
local LoadAddOn = LoadAddOn
local RBM = RBM
local PlaySoundFile = PlaySoundFile
setfenv(1, RBM.FunctionEnviroment)
ConfigLoaded = true
local Core = Core
local MediaHandler = MediaHandler

local function StripName(name)
	return name:gsub("[%c \127]", "_")
end

local function UnstripName(name)
	return name:gsub("_", " ")
end

local function ReturnTrue()
	return true
end

local reservedFrames = {
	NewBarFrame = true,
	ForceShow = true,
	FrameOnClick = true,
	BarOnClick = true,
	ColorTables = true,
}

local function SetProfileOpt(info, value, value2, value3, value4)
	local key = info[#info]
	if key == "FadeDur" or key == "TimeVis" or key == "MsgFont" or key == "MsgFontSize" or key == "MsgJustify" or key == "MsgWidth" or key == "MsgHeight" or key == "MsgShadowColor" or key == "MsgShadowOffsetX" or key == "MsgShadowOffsetY" or key == "MsgOutline" or key == "MsgUseShadowColor" then
		if key == "MsgShadowColor" then
			Profile.MsgFrame.MsgShadowColor = {
				["r"] = value,
				["g"] = value2,
				["b"] = value3,
				["a"] = value4,
			}
		else
			Profile["MsgFrame"][key] = value
		end
		Core:UpdateMsgFrameSettings()
	else
		if key == "BossSound" or key == "PluginSound" then
			if value == Profile[key] then
				value = nil
			end
			if value then
				PlaySoundFile(MediaHandler:Fetch("sound", value))
			end
		end
		Profile[key] = value
	end
end

local function GetProfileOpt(info)
	local key = info[#info]
	if key == "FadeDur" or key == "TimeVis" or key == "MsgFont" or key == "MsgFontSize" or key == "MsgJustify" or key == "MsgWidth" or key == "MsgHeight" or key == "MsgShadowOffsetX" or key == "MsgShadowOffsetY" or key == "MsgOutline" or key == "MsgUseShadowColor" then
		return Profile["MsgFrame"][key]
	end
	if key == "MsgShadowColor" then
		local c = Profile.MsgFrame.MsgShadowColor
		return c.r, c.g, c.b, c.a
	end
	return Profile[key]
end

local function MediaList(type, val)
	local dict = {}
	local anum
	if type == "statusbar" and val then
		anum = #MediaHandler:List(type) / 2
	end
	
	for i, name in pairs(MediaHandler:List(type)) do
		if anum and val and val == "a" and i <= anum then
			dict[name] = name
		elseif anum and val and val == "b" and i >= anum then
			dict[name] = name
		elseif not anum and not val then
			dict[name] = name
		end
	end
	return dict
end

local function MediaListBorder()
	return MediaList("border")
end
local function MediaListBackground()
	return MediaList("background")
end
local function MediaListStatus()
	return MediaList("statusbar")
end
local function MediaListFont()
	return MediaList("font")
end
local function MediaListSpark()
	return MediaList("spark")
end
local function MediaListSound()
	return MediaList("sound")
end

local function isShakeScreen()
	return not Profile.AllowScreenShake 
end

local function isShowAlerts()
	return not Profile.ShowAlerts
end

local function isFlashFrame()
	return not Profile.AllowFlashFrame
end

local function hasBossModules()
	for i=1, GetNumAddOns() do
		if IsAddOnLoadOnDemand(i) then
			local enabled, loadable = select(4, GetAddOnInfo(i))
			if enabled and GetAddOnMetadata(i, "X-RBMLoadIn") then
				return false
			end
		end
	end
	return true
end

local options = {
	type = "group",
	name = "RBM",
	handler = Core,
	childGroups = "tree",
	get = GetProfileOpt,
	set = SetProfileOpt,
	args = {
		RBM = {
			type = "group",
			name = "RBM",
			order = 1,
			args = {
				general = {
					type = "group",
					name = L["General options"],
					desc = L["General options"],
					order = 1,
					guiInline = true,
					args = {
						ShowWelcomeFrame = {
							type = "execute",
							name = L["Show welcome screen"],
							desc = L["Shows the welcome you are intitially greeted with.\rThe error message after clicking this is NOT an RBM bug!"],
							width = "full",
							func = "ShowWelcomeFrame",
							order = 20,
						},	
						AllowAnySender = {
							type = "toggle",
							name = L["Allow any sender"],
							desc = L["Allow bars from any sender (within your party or raid), otherwise only raid leaders or officers will be able to send you bars."],
							order = 30,
						},	
						TooltipSameZone = {
							type = "toggle",
							name = L["Tooltip same zone"],
							desc = L["Only shows boss modules in the FuBar tooltip that match your current zone."],
							order = 40,
						},
						PlaySoundOnBossDeath = {
							type = "toggle",
							name = L["Play sound on boss death"],
							desc = L["Plays a short sound clip whenever a boss is defeated."],
							width = "double",
							order = 43,
						},
						Break1 = {type = "header", order = 45, name = "",},
						AllowScreenShake = {
							type = "toggle",
							name = L["Allow screen shake"],
							desc = L["Allows the screen to shake briefly to alert you of critical events."],
							order = 50,
						},
						TestShake = {
							type = "execute",
							name = L["Test screen shaking"],
							desc = L["Shakes the screen using the settings provided above."],
							hidden = isShakeScreen,
							func = function() Core:ShakeScreen() end,
							order = 60,
						},				
						ShakeDuration = {
							type = "range",
							name = L["Shake duration"],
							desc = L["How long the screen should shake in seconds."],
							hidden = isShakeScreen,
							min = .01,
							max = 5,
							bigStep = .01,
							order = 70,
						},
						ShakeIntensity = {
							type = "range",
							name = L["Shake intensity"],
							desc = L["How intense the screen shake will be."],
							hidden = isShakeScreen,
							min = 1,
							max = 100,
							order = 80,
						},
						Break2 = {type = "header", order = 85, name = "",},
						AllowFlashFrame = {
							type = "toggle",
							name = L["Allow screen flash"],
							desc = L["Allows the screen to flash briefly to alert you of critical events."],
							order = 90,
						},
						TestFlash = {
							type = "execute",
							name = L["Test screen flash"],
							desc = L["Flashes the screen using the settings provided above."],
							hidden = isFlashFrame,
							func = function() Core:WarningFlash() end,
							order = 100,
						},
						FlashDuration = {
							type = "range",
							name = L["Flash duration"],
							desc = L["How long, in seconds, it should take for the screen should flash."],
							hidden = isFlashFrame,
							min = .01,
							max = 5,
							bigStep = .01,
							order = 110,
						},
					},
				},
				alert = {
					type = "group",
					name = L["Alert options"],
					desc = L["Alert options"],
					order = 2,
					args = {
						SendChatWarnings = {
							type = "toggle",
							name = L["Send Chat Warnings"],
							desc = L["Send warnings through raid chat."],
							order = 1,
						},
						ShowAlerts = {
							type = "toggle",
							name = L["Show Alerts"],
							desc = L["Displays messages in the center of the screen for important events."],
							order = 2,
						},
						SendRaidWarnings = {
							type = "toggle",
							name = L["Send Raid Warnings"],
							desc = L["Send warnings through raid warnings."],
							order = 3,
						},
						UseSkull = {
							type = "toggle",
							name = L["Use Skulls"],
							desc = L["Replaces all *** with Skulls"],
							hidden = isShowAlerts,
							order = 4,
						},
						ShowIcons = {
							type = "toggle",
							name = L["Show Icons"],
							desc = L["Show spell icon's when applicable."],
							hidden = isShowAlerts,
							order = 5,
						},
						PlayAlertSounds = {
							type = "toggle",
							name = L["Alert Sounds"],
							desc = L["Plays a sound when you get alerted."],
							hidden = isShowAlerts,
							order = 6,
						},
						AlertIconSize = {
							type = "range",
							name = L["Icon Size"],
							desc = L["Adjust the size of icons that are sent through the alert system."],
							--hidden = isShowAlerts,
							hidden = function() return not Profile.ShowAlerts or not Profile.ShowIcons end,
							min = 1,
							max = 50,
							step = 0.1,
							bigStep = 0.5,
							order = 7,
						},
						TestWarning = {
							type = "execute",
							name = L["Test Warnings"],
							desc = L["Test your current alert settings."],
							func = function() Core:ShowAlert("High", "Test Warning", 7) end,
							hidden = isShowAlerts,
							order = 8,
						},
						AlertColors = {
							type = "group",
							inline = true,
							name = L["Alert colors"],
							desc = L["Sets the color of RBM alerts that show up in the center of the screen."],
							hidden = isShowAlerts,
							order = 10,
							args = {
								Low = {
									type = "color",
									name = L["Low"],
									desc = L["Sets the color of the alert."],
									set = function(info, r, g, b)
										local a = Profile.AlertColors[info[#info]]
										a.r, a.g, a.b = r, g, b
									end,
									get = function(info)
										local a = Profile.AlertColors[info[#info]]
										return a.r, a.g, a.b
									end,
									order = 10,
								},
								Normal = {
									type = "color",
									name = L["Medium"],
									desc = L["Sets the color of the alert."],
									set = function(info, r, g, b)
										local a = Profile.AlertColors[info[#info]]
										a.r, a.g, a.b = r, g, b
									end,
									get = function(info)
										local a = Profile.AlertColors[info[#info]]
										return a.r, a.g, a.b
									end,
									order = 20,
								},
								High = {
									type = "color",
									name = L["High"],
									desc = L["Sets the color of the alert."],
									set = function(info, r, g, b)
										local a = Profile.AlertColors[info[#info]]
										a.r, a.g, a.b = r, g, b
									end,
									get = function(info)
										local a = Profile.AlertColors[info[#info]]
										return a.r, a.g, a.b
									end,
									order = 30,
								},
								UseClassColors = {
									type = "toggle",
									name = L["Class Colors"],
									desc = L["Color player names in alert messages with their class color."],
									order = 40,
								},
							},
						},
						Sounds = {
							type = "group",
							name = L["Sounds"],
							inline = true,
							hidden = function() return not Profile.PlayAlertSounds or not Profile.ShowAlerts end,
							order = 30,
							args = {
								BossSound = {
									type = "select",
									name = L["Boss Sound"],
									desc = L["Sound to play when a bossmod alerts you."],
									order = 1,
									dialogControl = "LSM30_Sound",
									values = MediaListSound,
								},
								PluginSound = {
									type = "select",
									name = L["Plugin Sound"],
									desc = L["Sound to play when a plugin alerts you."],
									order = 2,
									dialogControl = "LSM30_Sound",
									values = MediaListSound,
								},
							},
						},
					},
				},
				WarningFrameOpts = {
					type = "group",
					name = L["Alert Frame Options"],
					desc = L["Custom Alert Frame Options"],
					order = 70,
					args = {
						ShowAnchor = {
							type = "execute",
							name = L["Toggle Anchor"],
							desc = L["Toggle the custom message frame anchor."],
							func = function() if _G.RBMMessageFrameAnchor:IsShown() then _G.RBMMessageFrameAnchor:Hide() else _G.RBMMessageFrameAnchor:Show() end end,
							width = "full",
							order = 1,
						},
						FadeDur = {
							type = "range",
							name = L["Fade Duration"],
							desc = L["Set the custom frame fade duration.\rDefault is: 2"],
							min = 0,
							max = 25,
							order = 10,
						},
						TimeVis = {
							type = "range",
							name = L["Time Visible"],
							desc = L["Set the custom frame time visible duration.\rDefault is: 2"],
							min = 1,
							max = 25,
							order = 20,
						},
						MsgFont = {
							type = "select",
							name = L["Font"],
							desc = L["Select the font you wish to use."],
							values = MediaListFont,
							dialogControl = "LSM30_Font",
							order = 30,
						},
						MsgFontSize = {
							type = "range",
							name = L["Font Size"],
							desc = L["Select the font size you wish to use.\rDefault is: 16"],
							min = 4,
							max = 24,
							bigStep = 0.5,
							step = 0.1,
							order = 40,
						},
						MsgUseShadowColor = {
							type = "toggle",
							name = L["Use Shadow Color"],
							desc = L["Toggle using shadow colors."],
							order = 49,
						},
						MsgShadowColor = {
							type = "color",
							name = L["Shadow Color"],
							desc = L["Sets the shadow color used on the label text."],
							hasAlpha = true,
							order = 50,
							disabled = function() return not Profile.MsgFrame.MsgUseShadowColor end,
						},
						MsgShadowOffsetX = {
							type = "range",
							name = L["Shadow Offset-X"],
							desc = L["Sets the X-Value of the shadow offset."],
							min = -10,
							max = 10,
							bigStep = 1,
							order = 51,
							disabled = function() return not Profile.MsgFrame.MsgUseShadowColor end,
						},
						MsgShadowOffsetY = {
							type = "range",
							name = L["Shadow Offset-Y"],
							desc = L["Sets the Y-Value of the shadow offset."],
							min = -10,
							max = 10,
							bigStep = 1,
							order = 52,
							disabled = function() return not Profile.MsgFrame.MsgUseShadowColor end,
						},
						MsgOutline = {
							type = "select",
							name = L["Outline"],
							desc = L["Select the outline you wish to use."],
							values = {[""] = L["None"], ["OUTLINE"] = L["Outline"], ["THICKOUTLINE"] = L["Thick Outline"]},
							order = 53,
						},
						MsgJustify = {
							type = "select",
							name = L["Font Justify"],
							desc = L["Select the justification you wish to use.\rDefault is: Center"],
							values = function()
								local t={}
								t["CENTER"] = L["Center"]
								t["LEFT"] = L["Left"]
								t["RIGHT"] = L["Right"]
								return t
							end,
							order = 60,
						},
						MsgWidth = {
							type = "range",
							name = L["Frame Width"],
							desc = L["Set the width of your custom message frame.\rDefault is: 512"],
							min = 100,
							max = 1000,
							step = 0.1,
							bigStep = 10,
							order = 70,
						},
						MsgHeight = {
							type = "range",
							name = L["Frame Height"],
							desc = L["Set the height of your custom message frame.\rDefault is: 100"],
							min = 16,
							max = 500,
							step = 0.1,
							bigStep = 10,
							order = 80,
						},
					},
				},
				Output = Core:GetSinkAce3OptionsDataTable(),
				fubar = {	-- jacked from Omen
					type = "group",
					name = L["FuBar options"],
					desc = L["FuBar options"],
					order = -1,
					disabled = function() return RBM.IsFuBarMinimapAttached == nil end,
					args = {
						attachMinimap = {
							type = "toggle",
							name = L["Attach to minimap"],
							desc = L["Attach to minimap"],
							get = function(info)
								return RBM:IsFuBarMinimapAttached()
							end,
							set = function(info, v)
								RBM:ToggleFuBarMinimapAttached()
								Profile["FuBar.AttachMinimap"] = RBM:IsFuBarMinimapAttached()
							end
						},
						hideIcon = {
							type = "toggle",
							name = L["Hide minimap/FuBar icon"],
							desc = L["Hide minimap/FuBar icon"],
							get = function(info) 
								return Profile["FuBar.HideMinimapButton"] 
							end,
							set = function(info, v)
								Profile["FuBar.HideMinimapButton"] = v
								if v then
									RBM:Hide()
								else
									RBM:Show()
								end
							end
						},
						showIcon = {
							type = "toggle",
							name = L["Show icon"],
							desc = L["Show icon"],
							get = function(info) return RBM:IsFuBarIconShown() end,
							set = function(info, v) RBM:ToggleFuBarIconShown() end
						},
						showText = {
							type = "toggle",
							name = L["Show text"],
							desc = L["Show text"],
							get = function(info) return RBM:IsFuBarTextShown() end,
							set = function(info, v) RBM:ToggleFuBarTextShown() end
						},
						position = {
							type = "select",
							name = L["Position"],
							desc = L["Position"],
							values = {LEFT = L["Left"], CENTER = L["Center"], RIGHT = L["Right"]},
							get = function() 
								return RBM:GetPanel() and RBM:GetPanel():GetPluginSide(RBM) 
							end,
							set = function(info, val)
								if RBM:GetPanel() then
									RBM:GetPanel():SetPluginSide(RBM, val)
								end
							end
						}
					}
				},
			},
		},
		BossModules = {
			type = "group",
			name = L["BossModule options"],
			desc = L["Configure boss module Options."],
			order = 5,
			hidden = hasBossModules,
			args = {
				LoDModules = {
					type = "multiselect",
					name = L["LoD Modules"],
					desc = L["Lists all unloaded LoD modules, and optionally allows you to load them early."],
					set = function(info, addon)
						if not IsAddOnLoaded("LibBabble-Boss-3.0") then
							LoadAddOn("LibBabble-Boss-3.0")
							LoadAddOn("LibBabble-Zone-3.0")
						end
						LoadAddOn(addon)
					end,
					get = false,
					values = function()
						local list = {}
						for i=1, GetNumAddOns() do
							if IsAddOnLoadOnDemand(i) and not IsAddOnLoaded(i) then
								local enabled, loadable = select(4, GetAddOnInfo(i))
								local zones = GetAddOnMetadata(i, "X-RBMLoadIn")
								if zones and enabled and loadable then
									local name = GetAddOnInfo(i)
									list[name] = name
								end
							end
						end
						return list
					end,
					order = 10,
				},
				ActivateModulesZone = {
					type = "toggle",
					name = L["Activate modules on zone match"],
					desc = L["Automatically enables boss modules when you enter a zone they belong in."],
					width = "full",
					order = 20,
				},
				ActivateModulesMouseover = {
					type = "toggle",
					name = L["Activate modules on mouseover"],
					desc = L["Automatically enables boss modules with the same name as your mouseover target."],
					width = "full",
					order = 30,
				},
			},
		},
		Plugins = {
			type = "group",
			name = L["Plugin options"],
			desc = L["Configure plugin Options."],
			args = {},
			order = 10,
			
		},
	},
}

local function GetHandler(info)
	local opts = options.args
	local handler = Core
	for i=1, #info - 1 do
		opts = opts[info[i]]
		handler = opts.handler or handler
		opts = opts.args
	end
	return handler
end

local rightClickChoices = {
	TestBar = L["Show a test bar"],
	ShowMenu = L["Open the configuration menu"],
	CancelAll = L["Cancel all bars"],
	Nothing = L["Do nothing"],
}

local barClickChoices = {
	Cancel = L["Cancels the bar"],
	ShowMenu = L["Opens the configuration menu to bar options"],
	Pause = L["Pause/unpause bar"],
	Filter = L["Filter bar"],
	Color = L["Recolor bar"],
	Nothing = L["Do nothing"],
}


do
	local currentCategory, currentSubcategory
	local tonumber = _G.tonumber
	local function isGradientHidden(info)
		local num = tonumber((info[#info]:gsub(L["Gradient"], "")))
		if Profile.ColorTables[currentCategory][currentSubcategory].GradientNum and Profile.ColorTables[currentCategory][currentSubcategory].GradientNum >= num then
			return
		end
		return true
	end
	local function setGradient(info, r, g, b)
		local ct = Profile.ColorTables[currentCategory][currentSubcategory]["Gradient"..info[#info]:gsub(L["Gradient"], "")]
		ct["r"], ct["g"], ct["b"] = r, g, b
	end

	local function getGradient(info)
		local num = info[#info]:gsub(L["Gradient"], "")
		if currentCategory and currentSubcategory then
			local ct = Profile.ColorTables[currentCategory][currentSubcategory]["Gradient"..num]
			if not ct then 
				Profile.ColorTables[currentCategory][currentSubcategory]["Gradient"..num] = {
					["r"] = 0, 
					["g"] = 0, 
					["b"] = 0,
				}
				return 0, 0, 0
			end
			return ct.r, ct.g, ct.b
		end
	end
	--[[	Disabled until I can force an update of the config menu in real time.
	function CreateGradientTable()
		if currentCategory and currentSubcategory then
			local opts = options.args.Frames.args.ColorTables.args
			local max = Profile.ColorTables[currentCategory][currentSubcategory].GradientNum
			if max == 0 or not max then return end
			for i=1, max do
				if not opts["Gradient"..i] then
					opts["Gradient"..i] = {
						type = "color",
						name = L["Color #"]..i+1,
						desc = L["Color #"]..i+1,
						set = setGradient,
						get = getGradient,
						order = 39+i,
						hidden = isGradientHidden,
					}
				end
			end
		end
	end
	]]
	options.args.Frames = {
		type = "group",
		name = L["Frame options"],
		desc = L["Configure frame options."],
		order = 20,
		args = {
			NewBarFrame = {
				type = "input",
				name = L["New frame"],
				desc = L["Creates a new frame with the specified name."],
				get = false,
				set = function(info, name)
					Core:NewBarFrame(name)
				end,
				order = 10,
				validate = function(info, name)
					if name == "" then
						return L["The frame name cannot be empty."]
					elseif Core:HasBarFrame(name) then
						return L["A frame with that name already exists."]
					elseif reservedFrames[name] then
						return L["This name is reserved."]
					end
					return true
				end,
				usage = L["Enter the name of the frame you wish to create and press enter."],
			},
			ForceShow = {
				type = "keybinding",
				name = L["Force show"],
				desc = L["Sets a keybinding that forces all frames to be shown regardless of their settings."],
				set = function(bind)
					local oldBind = _G.GetBindingKey("RBM_FORCE_SHOW")
					if oldBind then
						_G.SetBinding(oldBind, nil)
					end
					_G.SetBinding(bind, "RBM_FORCE_SHOW")
					_G.SaveBindings(_G.GetCurrentBindingSet())
				end,
				get = function() return _G.GetBindingKey("RBM_FORCE_SHOW") end,
				order = 20,
			},
			ColorTables = {
				type = "group",
				name = L["Bar colors"],
				desc = L["All bars obey these colors (unless they've been custom colored)."],
				order = 30,
				inline = true,
				args = {
					CurrentCategory = {
						type = "select",
						name = L["Category"],
						desc = L["Select one of the categories from the dropdown to recolor it."],
						get = function()
							if not currentCategory then
								currentCategory = "Boss Abilities"--#NO_LOCALIZE
								currentSubcategory = "Cast"--#NO_LOCALIZE
							end
							return currentCategory
						end,
						set = function(info, category)
							currentCategory = category
							if currentCategory == "Boss Abilities" then--#NO_LOCALIZE
								currentSubcategory = next(Profile.ColorTables[currentCategory])
							else
								currentSubcategory = next(Core:GetModule("Plugin", currentCategory):GetCategories())
							end
						end,
						order = 10,
						values = function()
							local dict = {}
							dict["Boss Abilities"]--#NO_LOCALIZE
								= L["Boss Abilities"]
							for name, module in Core:IterateModules("Plugin") do
								if module:GetCategories() then
									dict[name] = name
								end
							end
							return dict
						end,
					},
					CurrentSubCategory = {
						type = "select",
						name = L["Sub-category"],
						desc = L["Select one of the sub-categories from the dropdown to recolor it."],
						get = function()
							return currentSubcategory
						end,
						set = function(info, subCategory)
							currentSubcategory = subCategory
						end,
						order = 20,
						values = function()
							local dict = {}
							if currentCategory == "Boss Abilities" then--#NO_LOCALIZE
								for subCat in pairs(Profile.ColorTables[currentCategory]) do
									dict[subCat] = L[subCat]
								end
							else
								local module = Core:GetModule("Plugin", currentCategory)
								for subCat in pairs(module:GetCategories()) do
									dict[subCat] = subCat
								end
							end
							return dict
						end,
					},
					Color = {
						type = "color",
						name = L["Color"],
						desc = L["Sets the color of bars that belong to the above selections."],
						set = function(info, r, g, b)
							local ct = Profile.ColorTables[currentCategory][currentSubcategory]
							ct["r"], ct["g"], ct["b"] = r, g, b
						end,
						get = function()
							if currentCategory and currentSubcategory then
								local ct = Profile.ColorTables[currentCategory][currentSubcategory]
								return ct.r, ct.g, ct.b
							end
						end,
						order = 30,
					},
					GradientNum = {
						type = "range",
						name = L["Number of Gradients"],
						desc = L["Select the number of colors to use in the gradient.\r0=none"],
						min = 0,
						max = 10,
						step = 1,
						bigStep = 1,
						order = 31,
						get = function()
							return Profile.ColorTables[currentCategory][currentSubcategory].GradientNum or 0
						end,
						set = function(info, num)
							Profile.ColorTables[currentCategory][currentSubcategory].GradientNum = num
						end,
					},
					Gradient1 = {
						type = "color",
						name = L["Color #2"],
						desc = L["Second fade color"],
						set = setGradient,
						get = getGradient,
						order = 40,
						hidden = isGradientHidden,
					},
					Gradient2 = {
						type = "color",
						name = L["Color #3"],
						desc = L["Third fade color"],
						set = setGradient,
						get = getGradient,
						order = 41,
						hidden = isGradientHidden,
					},
					Gradient3 = {
						type = "color",
						name = L["Color #4"],
						desc = L["Fourth fade color"],
						set = setGradient,
						get = getGradient,
						order = 43,
						hidden = isGradientHidden,
					},
					Gradient4 = {
						type = "color",
						name = L["Color #5"],
						desc = L["Fifth fade color"],
						set = setGradient,
						get = getGradient,
						order = 44,
						hidden = isGradientHidden,
					},
					Gradient5 = {
						type = "color",
						name = L["Color #6"],
						desc = L["Sixth fade color"],
						set = setGradient,
						get = getGradient,
						order = 45,
						hidden = isGradientHidden,
					},
					Gradient6 = {
						type = "color",
						name = L["Color #7"],
						desc = L["Seventh fade color"],
						set = setGradient,
						get = getGradient,
						order = 46,
						hidden = isGradientHidden,
					},
					Gradient7 = {
						type = "color",
						name = L["Color #8"],
						desc = L["Eighth fade color"],
						set = setGradient,
						get = getGradient,
						order = 47,
						hidden = isGradientHidden,
					},
					Gradient8 = {
						type = "color",
						name = L["Color #9"],
						desc = L["Ninth fade color"],
						set = setGradient,
						get = getGradient,
						order = 48,
						hidden = isGradientHidden,
					},
					Gradient9 = {
						type = "color",
						name = L["Color #10"],
						desc = L["Tenth fade color"],
						set = setGradient,
						get = getGradient,
						order = 49,
						hidden = isGradientHidden,
					},
					Gradient10 = {
						type = "color",
						name = L["Color #11"],
						desc = L["Eleventh fade color"],
						set = setGradient,
						get = getGradient,
						order = 50,
						hidden = isGradientHidden,
					},
				},
			},
			FrameOnClick = {
				type = "group",
				name = L["Frame right-click events"],
				desc = L["Determines what happens when frames are right-clicked on."],
				order = 40,
				inline = true,
				args = {
					FrameRightClick = {
						type = "select",
						name = L["Right-click"],
						desc = L["Determines what happens when a frame is right-clicked on."],
						values = rightClickChoices,
						order = 10,
					},
					FrameControlRightClick = {
						type = "select",
						name = L["Control + Right-click"],
						desc = L["What happens when a frame is Control + Right-clicked."],
						values = rightClickChoices,
						order = 20,
					},
					FrameShiftRightClick = {
						type = "select",
						name = L["Shift + Right-click"],
						desc = L["What happens when a frame is Shift + Right-clicked."],
						values = rightClickChoices,
						order = 30,
					},
				},
			},
			BarOnClick = {
				type = "group",
				name = L["Bar click events"],
				desc = L["Determines what happens when a bar is clicked on."],
				order = 50,
				inline = true,
				args = {
					BarLeftClick = {
						type = "select",
						name = L["Left-click"],
						desc = L["What happens when a bar is left-clicked."],
						values = barClickChoices,
						order = 10,
					},
					BarRightClick = {
						type = "select",
						name = L["Right-click"],
						desc = L["What happens when a bar is right-clicked."],
						values = barClickChoices,
						order = 20,
					},
					BarMiddleClick = {
						type = "select",
						name = L["Middle-click"],
						desc = L["What happens when a frame is shift right-clicked."],
						values = barClickChoices,
						order = 30,
					},
				},
			},
		},
	}
end

local FrameOptionsTable

local AddToggles, AddExecutes
do
	local function isHidden(info)
		return info.handler:GetHideQuickCommands()
	end
	function AddToggles(module, toggles)
		local opts = module:GetOptionsTable().args
		for toggle in pairs(toggles) do
			if not opts[StripName(toggle)] then
				opts[StripName(toggle)] = {
					handler = module,
					type = "toggle",
					name = toggle,
					desc = toggle,
					width = "full",
					get = function(info)
						return info.handler:CheckToggle(toggle)
					end,
					set = function(info, value)
						info.handler:SetToggle(toggle, value)
					end,
					hidden = isHidden,
					order = function(info) return toggle == L["Announce"] and info.handler:IsBossMod() and .0002 or 1000 end,
				}
			end
			
		end
	end
	function AddExecutes(module, executes)
		local opts = module:GetOptionsTable().args
		for execute, func in pairs(executes) do
			if not opts[StripName(execute)] then
				opts[StripName(execute)] = {
					handler = module,
					type = "execute",
					name = execute,
					desc = execute,
					func = function()
						func(module)
					end,
					hidden = isHidden,
					order = 2000,
				}
				if execute == L["Force Start"] then
					opts[StripName(execute)].disabled = function() return not module:CanStart() end
				elseif execute == L["Force Stop"] then
					opts[StripName(execute)].disabled = function() return not module:CanStop() end
				end
			end
			
		end
	end
end


local LoDModules = LoDModules
local loadedLst = {}
local loadedLstPlugin = {}

Core:RegisterEvent("ADDON_LOADED", function(_, addon)
	local function RefreshPlugins(name)
		loadedLstPlugin[name] = true
		_G.LibStub("AceConfigRegistry-3.0"):NotifyChange("RBM")
	end

	local function RefreshBoss(zone)
		loadedLst[zone] = true
		_G.LibStub("AceConfigRegistry-3.0"):NotifyChange("RBM")
	end
	
	local plugin = GetAddOnMetadata(addon, "X-RBMPlugin")
	local zones = GetAddOnMetadata(addon, "X-RBMLoadIn")
	
	if not plugin and not zones then return end	-- clear break	
	if plugin and LoDModules then
		LoDModules[plugin] = nil
		options.args.Plugins.args[StripName(plugin)] = nil
		local module = Core:GetModule("Plugin", plugin)
		Profile.ModuleStates[module:GetPrefixedName()] = true
		if not next(LoDModules) then
			LoDModules = nil
		end
		Core:ScheduleTimer(RefreshPlugins, 0.3, plugin)
	end
	
	if zones then
		Core:ScheduleTimer(RefreshBoss, 0.3, zones)
	end
end)

function Core:RefreshAndReturnConfig()
	local plugins = options.args.Plugins.args
	for name, module in self:IterateModules("Plugin") do
		if LoDModules and LoDModules[name] then
			LoDModules[name] = nil
			plugins[StripName(name)] = nil
		end
		
		if not plugins[StripName(name)] then
			local toggles = module:GetToggles()
			if toggles then
				AddToggles(module, toggles)
			end
			local executes = module:GetExecutes()
			if executes then
				AddExecutes(module, executes)
			end
			plugins[StripName(name)] = module:GetOptionsTable(true)
		end
		if loadedLstPlugin[name] then
			loadedLstPlugin[name] = nil
			plugins[StripName(name)] = module:GetOptionsTable(true)
		end
	end
	if LoDModules then
		for name, addon in pairs(LoDModules) do
			if not plugins[StripName(name)] then
				if not ToggleActiveArgs then
					ToggleActiveArgs = {
						args = {
							type = "toggle",
							name = L["Enabled"],
							desc = L["This module is Load on Demand and currently unloaded because it's disabled, enable this module to automatically load it."],
							set = function()
								LoadAddOn(addon)
							end,
							get = false,
						}
					}
				end
				plugins[StripName(name)] = {
					type = "group",
					name = name,
					desc = name,
					args = ToggleActiveArgs,
				}
				ToggleActiveArgs = nil
			end
		end
	end
	local zones = options.args.BossModules.args
	for name, module in self:IterateModules("BossModule") do
		if module.ConfigLoaded then
			local zone = module:GetDisplayZone()
			if not zones[StripName(zone)] or loadedLst[zone] then
				zones[StripName(zone)] = {
					type = "group",
					name = zone,
					desc = L["Options for modules in this zone."],
					args = {
						AnnounceAll = {
							type = "toggle",
							name = L["Announce all"],
							desc = L["Sets all modules that belong to this zone to announce to the raid."],
							width = "full",
							set = function(info)
								local announce = true
								for name, module in self:IterateModules("BossModule") do
									if module:HasZone(zone) then
										if not module:CheckToggle(L["Announce"]) then
											announce = false
											break
										end
									end
								end
								for name, module in self:IterateModules("BossModule") do
									if module:HasZone(zone) then
										module:SetToggle(L["Announce"], not announce)
									end
								end
							end,
							get = function(info)
								local announce = false
								for name, module in self:IterateModules("BossModule") do
									if module:HasZone(zone) then
										if not module:CheckToggle(L["Announce"]) then
											if announce then
												return
											end
										else
											announce = true
										end
									end
								end
								return announce
							end,
							tristate = true,
							order = 10,
						},
						EnableAll = {
							type = "execute",
							name = L["Enable all"],
							desc = L["Enables all modules that belong to this zone."],
							func = function(info)
								for name, module in self:IterateModules("BossModule") do
									if module:HasZone(zone) then
										module:Enable()
									end
								end
							end,
							order = 20,
						},
						DisableAll = {
							type = "execute",
							name = L["Disable all"],
							desc = L["Disable all modules that belong to this zone."],
							func = function(info)
								for name, module in self:IterateModules("BossModule") do
									if module:HasZone(zone) then
										module:Disable()
									end
								end
							end,
							order = 30,
						},
					},
				}
			end
			local args = zones[StripName(zone)].args
			if not args[StripName(name)] then
				local toggles = module:GetToggles()
				if toggles then
					AddToggles(module, toggles)
				end
				local executes = module:GetExecutes()
				if executes then
					AddExecutes(module, executes)
				end
				args[StripName(name)] = module:GetOptionsTable(true)
			end
			if loadedLst[zone] and args[StripName(name)] then
				local executes = module:GetExecutes()
				if executes then
					AddExecutes(module, executes)
				end
				args[StripName(name)] = module:GetOptionsTable(true)
				loadedLst[zone] = nil
			end
		end
	end
	local frames = options.args.Frames.args
	for k, table in pairs(frames) do
		if not reservedFrames[k] and not self:HasBarFrame(table.name) then --remove deleted frames
			frames[k] = nil
		end
	end
	for name, frame in self:IterateBarFrames() do
		if not frames[StripName(name)] then
			frames[StripName(name)] = {
				type = "group",
				desc = L["Configures this frame."],
				name = name,
				handler = frame,
				set = "SetOption",
				get = "GetOption",
				childGroups = "tree",
				args = FrameOptionsTable,
			}
		end
	end
	return options
end

local blendModes = {
	DISABLE		= L["Opaque texture"],
	BLEND		= L["Normal painting on top of the background with alpha"],
	ALPHAKEY	= L["One-bit alpha"],
	ADD			= L["Additive blend (Default)"],
	MOD			= L["Modulating blend"],
}

local transferAnimations = {
	None				=	L["No animation"],
	CurveDownConstant	=	L["Curve down, constant speed"],
	CurveUpConstant		=	L["Curve up, constant speed"],
	CurveUpPower		=	L["Curve up, starts fast then slows"],
	CurveDownPower		=	L["Curve down, starts fast then slows"],
	XThenY				=	L["Right-angle, finishing X movement first"],
	YThenX				=	L["Right-angle, finishing Y movement first"],
	SlidePower			=	L["Slide, starts fast then slows"],
	SlideConstant		=	L["Slide, constant speed"],
}

local themeOpts = {
	Sound = true,
	Filters = true,
	Transfer = false,
	Elements = true,
}
local function SetThemeOption(info, value)
	themeOpts[info[#info]] = value
end
local function GetThemeOption(info)
	return themeOpts[info[#info]]
end

local moduleCategories = {
	Categories = {
		type = "toggle",
		name = L["Filter by category"],
		desc = L["Whether or not this frame should filter bars that don't meet the selected categories."],
		get = "GetOption",
		set = "SetOption",
		order = 10,
	},
	BossAbilities = {
		type = "group",
		desc = L["Rejects bars that aren't part of an allowed category."],
		name = L["Boss Abilities"],
		args = {
			BossAbilities = {
				type = "multiselect",
				name = L["Boss Abilities"],
				desc = L["A checkmark signifies that the category should be allowed, otherwise the category is rejected."],
				values = {
					Cast = L["Cast"],
					Cooldown = L["Cooldown"],
					Buff = L["Buff"],
					Debuff = L["Debuff"],
					Timeless = L["Timeless"],
					Count = L["Count"],
				},
			},
		},
	},
}
local function RefreshConfigModuleCategories()
	for name, module in Core:IterateModules("Plugin") do
		if not moduleCategories[StripName(name)] then
			local cats = module:GetCategories()
			if cats then
				moduleCategories[StripName(name)] = {
					type = "group",
					desc = L["Rejects bars that aren't part of an allowed category."],
					name = name,
					args = {
						[StripName(name).."selectall"] = {
							type = "toggle",
							name = L["Select All"],
							desc = L["Select/deselect all of the below categories."],
							order = 1,
						},
						[StripName(name)] = {
							type = "multiselect",
							name = name,
							desc = L["A checkmark signifies that the category should be allowed, otherwise the category is rejected."],
							order = -1,
							values = function()
								local dict = {}
								for category in pairs(cats) do
									dict[category] = category
								end
								return dict
							end,
						},
					},
				}
			end
		end
	end
end

local customLabels = {
	CustomLabelDesc = {
		type = "description",
		name = L["Custom labels allows you to take special actions when a bar matches a label."],
		order = -1,
	},
	UseCustomLabels = {
		type = "toggle",
		name = L["Custom filtering"],
		desc = L["Whether or not the frame should use custom labels defined here."],
		order = -2,
	},
	NewCustomLabel = {
		type = "input",
		name = L["New custom label"],
		desc = L["todo."],
		get = function(info)
		end,
		set = function(info)
		end,
	},
}
local BuildCustomLabels
do
	local labelsArgs = {
		Filtered = {
			type = "toggle",
			name = L["Filter"],
			desc = L["If this label should be filtered."],
			order = 10,
		},
		CustomSound = {
			type = "toggle",
			name = L["Sound"],
			desc = L["If this label should play a different sound than usual."],
			order = 20,
		},
		CustomSoundToPlay = {
			type = "select",
			name = "Sound to play",
			dialogControl = "LSM30_Sound",
			values = MediaListSound,
			order = 30,
		},
		CustomColor = {
			type = "toggle",
			name = L["Color"],
			desc = L["If this label should use a custom color instead of category coloring."],
			order = 50,
		},
		SetColor = {
			type = "color",
			name = "Custom color",
			desc = "The color this label will use.",
			order = 60,
			disabled = function(info)
				local label = customLabels[info[#info - 1]].name
				return not GetHandler(info).db.profile.CustomLabels[label].CustomColor
			end,
		},
		CustomColor = {
			type = "toggle",
			name = L["Color"],
			desc = L["If this label should use a custom color instead of category coloring."],
			order = 70,
		},
		Partial = {
			type = "toggle",
			name = L["Partial match"],
			desc = L["If this label should be matched partially instead of exactly. Lua expressions are also supported."],
			order = 80,
		},
		Exception = {
			type = "toggle",
			name = L["Exception"],
			desc = L["If only labels that match this label should be allowed. Partial matching must be enabled for this to work."],
			order = 90,
			disabled = function(info)
				local label = customLabels[info[#info - 1]].name
				return not GetHandler(info).db.profile.CustomLabels[label].Partial
			end,
		},
	}
	local function Get(info)
		local label = customLabels[info[#info - 1]].name
		local key = info[#info]
		if key == "SetColor" then
			local custom = GetHandler(info).db.profile.CustomLabels[label]
			return custom.r, custom.g, custom.b
		else
			return GetHandler(info).db.profile.CustomLabels[label][key]
		end
	end
	local function Set(info, value, g, b)
		local label = customLabels[info[#info - 1]].name
		local key = info[#info]
		if key == "SetColor" then
			local custom = GetHandler(info).db.profile.CustomLabels[label]
			custom.r = value
			custom.g = g
			custom.b = b
		else
			GetHandler(info).db.profile.CustomLabels[label][key] = value
		end
		
	end
	function BuildCustomLabels(self)
		for k in pairs(customLabels) do
			if k ~= "CustomLabelDesc" and k ~= "UseCustomLabels" and k ~= "NewCustomLabel" then
				customLabels[k] = nil
			end
		end
		local labels = self.db.profile.CustomLabels
		for label, data in pairs(labels) do
			customLabels[StripName(label)] = {
				type = "group",
				name = label,
				args = labelsArgs,
				get = Get,
				set = Set,
			}
		end
	end
end

local lastFrame
FrameOptionsTable = {
	FrameControl = {
		type = "group",
		name = L["General"],
		order = 10,
		inline = true,
		args = {
			Destroy = {
				type = "execute",
				name = L["Destroy frame"],
				desc = L["Destroys the frame, removing all of its settings permanently."],
				func = "GUIDestroy",
				confirm = true,
				confirmText = L["Are you sure? This will destroy the frame, removing all of its settings permanently."],
				order = 10,
			},
			Reset = {
				type = "execute",
				name = L["Reset frame"],
				desc = L["Resets the frame, setting all of its options back to default."],
				func = "Reset",
				confirm = true,
				confirmText = L["Are you sure? This will reset all the frame's options to default."],
				order = 20,
			},
			ResetAnchor = {
				type = "execute",
				name = L["Reset frame anchor"],
				desc = L["Resets just the frame's anchor, placing it in the center of the screen."],
				func = "ResetAnchor",
				order = 30,
			},
			Visible = {
				type = "toggle",
				name = L["Show frame background"],
				desc = L["If not checked the frame will be hidden, but the bars will still display."],
				order = 40,
			},
			Locked = {
				type = "toggle",
				name = L["Lock frame"],
				desc = L["The frame will not be draggable."],
				order = 50,
			},
			ShowTitle = {
				type = "toggle",
				name = L["Show title"],
				desc = L["The title of the frame will be shown."],
				order = 60,
			},
			DynamicResize = {
				type = "toggle",
				name = L["Dynamic resize"],
				desc = L["The frame will automatically adjust it's size to fit the bars on the frame, up to the maximum size defined by dragging the resize handle."],
				order = 70,
			},
			HideWhenEmpty = {
				type = "toggle",
				name = L["Hide when empty"],
				desc = L["Hides the frame when it's empty, you can force it to be displayed by setting a keybind in 'Frame Options' or by unchecking this."],
				order = 80,
			},
			Alpha = {
				type = "range",
				name = L["Frame transparency"],
				desc = L["Sets the overall transparency of the frame, including all bars and text belonging to the frame."],
				bigStep = .05,
				isPercent = true,
				min = 0,
				max = 1,
				order = 90,
			},
			Width = {
				type = "range",
				name = L["Frame Width"],
				desc = L["Sets the frames width"],
				step = 0.1,
				bigStep = 5,
				min = 100,
				max = 1000,
				order = 100,
			},
			Height = {
				type = "range",
				name = L["Frame Height"],
				desc = L["Sets the frame height"],
				step = 0.1,
				bigStep = 5,
				min = 15,
				max = 1000,
				order = 101,
			},
			NormalizeTime = {
				type = "range",
				name = L["Normalize Bar Times"],
				desc = L["Sets all bars max time to desired length.\r0 = Disabled"],
				min = 0,
				max = 1000,
				step = 0.01,
				bigStep = 5,
				order = 110,
			},
		},
	},
	Backdrop = {
		type = "group",
		name = L["Backdrop"],
		order = 20,
		inline = true,
		args = {
			BackdropColor = {
				type = "color",
				name = L["Backdrop"],
				desc = L["Sets the color of the backdrop for this frame."],
				hasAlpha = true,
				order = 10,
			},
			BackdropBorderColor = {
				type = "color",
				name = L["Border"],
				desc = L["Sets the color of the backdrop border for this frame."],
				hasAlpha = true,
				order = 20,
			},
			bgFile = {
				type = "select",
				name = L["Background texture"],
				desc = L["Sets the background texture for this frame to use."],
				dialogControl = "LSM30_Background",
				values = MediaListBackground,
				order = 30,
			},
			edgeFile = {
				type = "select",
				name = L["Border texture"],
				desc = L["Sets the border texture for this frame to use."],
				dialogControl = "LSM30_Border",
				values = MediaListBorder,
				order = 40,
			},
			edgeSize = {
				type = "range",
				name = L["Border size"],
				desc = L["Sets the size of the border texture for this frame."],
				bigStep = 5,
				min = 1,
				max = 50,
				order = 50,
			},
			tile = {
				type = "toggle",
				name = L["Tile background"],
				desc = L["Whether or not the background should tile instead of stretching."],
				order = 60,
			},
			insets = {
				type = "group",
				name = L["Insets"],
				desc = L["Stretches or shrinks the background texture."],
				inline = true,
				order = 70,
				args = {
					left = {
						type = "range",
						name = L["Left"],
						desc = L["Stretches or shrinks the background texture."],
						bigStep = 5,
						min = -50,
						max = 50,
						order = 10,
					},
					right = {
						type = "range",
						name = L["Right"],
						desc = L["Stretches or shrinks the background texture."],
						
						bigStep = 5,
						min = -50,
						max = 50,
						order = 20,
					},
					top = {
						type = "range",
						name = L["Top"],
						desc = L["Stretches or shrinks the background texture."],
						bigStep = 5,
						min = -50,
						max = 50,
						order = 30,
					},
					bottom = {
						type = "range",
						name = L["Bottom"],
						desc = L["Stretches or shrinks the background texture."],
						bigStep = 5,
						min = -50,
						max = 50,
						order = 40,
					},
				},
			},
			
		},
	},
	BarControl = {
		type = "group",
		name = L["Bar control"],
		order = 20,
		childGroups = "tree",
		args = {
			DisplayTest = {
				type = "execute",
				name = L["Display a test bar"],
				desc = L["Creates and displays a test bar on this frame."],
				func = "TestBar",
				order = 10,
			},
			DisplayMaxTest = {
				type = "execute",
				name = L["Display max test bars"],
				desc = L["Creates and displays multiple test bars."],
				func = "MaxTestBars",
				order = 20,
			},
			CancelAll = {
				type = "execute",
				name = L["Cancel all bars"],
				desc = L["Cancels all bars currently running on this frame."],
				func = "CancelAllBars",
				width = "double",
				order = 30,
			},
			TestIgnoresFilter = {
				type = "toggle",
				name = L["Test bars should ignore filters"],
				desc = L["When testing bars they're still appear even if they don't pass filters."],
				width = "double",
				order = 60,
			},
			EnableMouse = {
				type = "toggle",
				name = L["Clickable bars"],
				desc = L["If checked then bars will be clickable, otherwise mouse clicks will pass through them."],
				width = "double",
				order = 80,
			},
			BarSorting = {
				type = "group",
				name = L["Sorting"],
				order = 90,
				args = {
					SortBars = {
						type = "toggle",
						name = L["Enabled"],
						desc = L["If checked then bar sorting will be active."],
						order = 10,
					},
					SortBarsOrder = {
						type = "select",
						name = L["Order"],
						desc = L["The order in which bars are sorted."],
						values = {
							Up = L["Up"], 
							Down = L["Down"],
						},
						disabled = "GetDisabledOption",
						order = 20,
					},
					SortBarsMethod = {
						type = "select",
						name = L["Method"],
						desc = L["The method in which the bars are sorted by."],
						values = {
							["Time Left"]--#NO_LOCALIZE
								= L["Time: Current Left"],
							["Time Total Length"]--#NO_LOCALIZE
								= L["Time: Total Length"],
							["Label"]--#NO_LOCALIZE
								= L["Label: Text"],
							["Category"]--#NO_LOCALIZE
								= L["Category"],
							["SubCategory"]	--#NO_LOCALIZE
								= L["SubCategory"]
						},
						disabled = "GetDisabledOption",
						order = 30,
					},
				},
			},
			BarTransferring = {
				type = "group",
				name = L["Transferring"],
				order = 100,
				args = {
					TransferCountBars = {
						type = "toggle",
						name = L["Transfer Counting Bars"],
						desc = L["Enables transfering of counting bars on this frame."],
						order = 1,
					},
					Above = {
						type = "group",
						name = L["Above a threshold"],
						order = 10,
						inline = true,
						args = {
							TransferAboveTo = {
								type = "select",
								name = L["Transfer to"],
								values = function(info)
									local frameName = GetHandler(info).Name
									local dict = {[""] = L["None"], ["parent"] = L["Parent Frame"]} --should be called infrequently enough that the table construction will be insignificant
									for name in Core:IterateBarFrames() do
										if name ~= frameName then
											dict[name] = name
											end
										end
									return dict
								end,
								order = 10,
							},
							TransferAboveByPercent = {
								type = "toggle",
								name = L["Transfer by percent"],
								desc = L["Enables bar transfers when bars are above a certain percentage in time. For example, if this is set to 50% and a 2 minute bar goes above 1 minute left the bar will be transferred."],
								order = 20,
							},
							TransferAbovePercent = {
								type = "range",
								name = L["Transfer percentage"],
								desc = L["If the bar time goes above this percentage of time it'll be transferred."],
								isPercent = true,
								bigStep = .05,
								min = 0,
								max = 1,
								order = 30,
								disabled = "GetDisabledOption",
							},
							TransferAboveByTime = {
								type = "toggle",
								name = L["Transfer by absolute time"],
								desc = L["Enables bar transfers when bars are above a certain amount of seconds. If transfer by percent is also enabled whichever criteria is met first will trigger the transfer."],
								order = 40,
							},
							TransferAboveTime = {
								type = "range",
								name = L["Transfer time"],
								desc = L["If the bar's time left goes above this time in seconds it'll be transferred."],
								bigStep = 5,
								min = 0,
								max = 600,
								order = 50,
								disabled = "GetDisabledOption",
							},
							TransferAboveAnimate = {
								type = "select",
								name = L["Transfer animation"],
								desc = L["Selects the animation used when transferring bars."],
								order = 60,
								values = transferAnimations,
							},
							TransferAboveRate = {
								type = "range",
								name = L["Animation speed"],
								desc = L["How quickly the bar will transfer to the other frame if an animation is selected. Speed effects each animation differently: 100% is always very fast, or instant, and 1% is very slow."],
								bigStep = .01,
								min = .01,
								max = 1,
								isPercent = true,
								order = 70,
							},
						},
					},
					Below = {
						type = "group",
						name = L["Below a threshold"],
						order = 20,
						inline = true,
						args = {
							TransferBelowTo = {
								type = "select",
								name = L["Transfer to"],
								desc = L["Sets the frame to which the bars will be transferred if the meet the criteria described below."],
								values = function(info)
									local frameName = GetHandler(info).Name
									local dict = {[""] = L["None"], ["parent"] = L["Parent Frame"]} --should be called infrequently enough that the table construction will be insignificant
									for name in Core:IterateBarFrames() do
										if name ~= frameName then
											dict[name] = name
											end
										end
									return dict
								end,
								order = 10,
							},
							TransferBelowByPercent = {
								type = "toggle",
								name = L["Transfer by percent"],
								desc = L["Enables bar transfers when bars are below a certain percentage in time. For example, if this is set to 50% and a 2 minute bar goes below 1 minute left the bar will be transferred."],
								order = 20,
							},
							TransferBelowPercent = {
								type = "range",
								name = L["Transfer percentage"],
								desc = L["If the bar time goes below this percentage of time it'll be transferred."],
								isPercent = true,
								bigStep = .05,
								min = 0,
								max = 1,
								order = 30,
								disabled = "GetDisabledOption",
							},
							TransferBelowByTime = {
								type = "toggle",
								name = L["Transfer by absolute time"],
								desc = L["Enables bar transfers when bars are below a certain amount of seconds. If transfer by percent is also enabled whichever criteria is met first will trigger the transfer."],
								order = 40,
							},
							TransferBelowTime = {
								type = "range",
								name = L["Transfer time"],
								desc = L["If the bar's time left goes below this time in seconds it'll be transferred."],
								bigStep = 5,
								min = 0,
								max = 600,
								order = 50,
								disabled = "GetDisabledOption",
							},
							TransferBelowAnimate = {
								type = "select",
								name = L["Transfer animation"],
								desc = L["Selects the animation used when transferring bars."],
								order = 60,
								values = transferAnimations,
							},
							TransferBelowRate = {
								type = "range",
								name = L["Animation speed"],
								desc = L["How quickly the bar will transfer to the other frame if an animation is selected. Speed effects each animation differently: 100% is always very fast, or instant, and 1% is very slow."],
								bigStep = .01,
								min = .01,
								max = 1,
								isPercent = true,
								order = 70,
							},
						},
					},
				},
			},
			BarBlinking = {
				type = "group",
				name = L["Blinking"],
				order = 110,
				args = {
					BlinkByPercent = {
						type = "toggle",
						name = L["Blink by percent"],
						desc = L["Enables bar blinking when bars are under a certain percentage in time. For example, if this is set to 50% and a 2 minute bar goes under 1 minute left the bar will start blinking."],
						order = 10,
					},
					BlinkPercent = {
						type = "range",
						name = L["Blink percentage"],
						desc = L["If the bar time goes under this percentage of time it'll start blinking."],
						isPercent = true,
						bigStep = .05,
						min = 0,
						max = 1,
						order = 20,
						disabled = "GetDisabledOption",
					},
					BlinkByTime = {
						type = "toggle",
						name = L["Blink by absolute time"],
						desc = L["Enables bar blinking when bars are under a certain amount of seconds. If blink by percent is also enabled whichever criteria is met first will trigger the blinking."],
						order = 30,
					},
					BlinkTime = {
						type = "range",
						name = L["Blink time"],
						desc = L["If the bar time goes under this time in seconds it'll start blinking."],
						bigStep = 5,
						min = 0,
						max = 600,
						order = 40,
						disabled = "GetDisabledOption",
					},
				},
			},
			BarPulsing = {
				type = "group",
				name = L["Pulsing"],
				order = 120,
				args = {
					PulseByPercent = {
						type = "toggle",
						name = L["Pulse by percent"],
						desc = L["Enables bar pulsing when bars are under a certain percentage in time. For example, if this is set to 50% and a 2 minute bar goes under 1 minute left the bar will start pulsing."],
						order = 10,
					},
					PulsePercent = {
						type = "range",
						name = L["Pulse percentage"],
						desc = L["If the bar time goes under this percentage of time it'll start pulsing."],
						isPercent = true,
						bigStep = .05,
						min = 0,
						max = 1,
						order = 20,
						disabled = "GetDisabledOption",
					},
					PulseByTime = {
						type = "toggle",
						name = L["Pulse by absolute time"],
						desc = L["Enables bar pulsing when bars are under a certain amount of seconds. If pulse by percent is also enabled whichever criteria is met first will trigger the pulsing."],
						order = 30,
					},
					PulseTime = {
						type = "range",
						name = L["Pulse time"],
						desc = L["If the bar time goes under this time in seconds it'll start pulsing."],
						bigStep = 5,
						min = 0,
						max = 600,
						order = 540,
						disabled = "GetDisabledOption",
					},
				},
			},
			BarFading = {
				type = "group",
				name = L["Fading"],
				order = 130,
				args = {
					FadeWhenComplete = {
						type = "toggle",
						name = L["Fade when complete"],
						desc = L["Enables the bar to fade once the bar's timer is complete."],
						order = 50,
					},
					FadeComplete = {
						type = "range",
						name = L["Fade complete time"],
						desc = L["How long the bar will take to fade out once completed."],
						bigStep = 5,
						step = 1,
						min = 1,
						max = 200,
						order = 60,
						disabled = "GetDisabledOption",
					},

				},
			},
		},
	},
	BarOptions = {
		type = "group",
		name = L["Bar options"],
		order = 70,
		args = {
			General = {
				type = "group",
				name = L["General"],
				order = 10,
				inline = true,
				args = {
					FrameAnchor = {
						type = "select",
						name = L["Bar growth"],
						desc = L["Controls which direction bars grow from."],
						order = 10,
						values = {
							BOTTOM = L["From the bottom"],
							TOP = L["From the top"],
						},
					},
					BarWidth = {
						type = "range",
						name = L["Width"],
						desc = L["Sets the width of a bar relative to the width of the frame it belongs to. 100% means the bar would be the entire width of the frame, 50% means the bar would be half the width of the frame."],
						bigStep = .05,
						min = .3,
						max = 1,
						isPercent = true,
						order = 20,
					},
					BarHeight = _G.setmetatable({
						type = "range",
						name = function(info) lastFrame = GetHandler(info) return L["Height"] end,
						desc = L["Sets the absolute height of a bar. The bar cannot be larger than the half the height of the frame."],
						bigStep = 5,
						min = 5,
						order = 30,
					}, {__index = function(self, key) 
						if key == "max" and lastFrame then 
							return lastFrame:GetMaxBarHeight() 
						end
					end}),
					Spacing = {
						type = "range",
						name = L["Spacing"],
						desc = L["Sets the absolute amount of space between bars."],
						bigStep = 2,
						min = -10,
						max = 10,
						order = 40,
					},
				},
			},
			BarBackdrop = {
				type = "group",
				name = L["Bar backdrop"],
				order = 20,
				inline = true,
				args = {
					BarBackdropColor = {
						type = "color",
						name = L["Backdrop"],
						desc = L["Sets the color of the backdrop for bars belonging to this frame."],
						hasAlpha = true,
						order = 10,
					},
					BarBackdropBorderColor = {
						type = "color",
						name = L["Border"],
						desc = L["Sets the color of the backdrop border for bars belonging to this frame."],
						hasAlpha = true,
						order = 20,
					},
					bgFile = {
						type = "select",
						name = L["Background texture"],
						desc = L["Sets the background texture for bars to use."],
						dialogControl = "LSM30_Background",
						values = MediaListBackground,
						order = 30,
					},
					edgeFile = {
						type = "select",
						name = L["Border texture"],
						desc = L["Sets the border texture for bars to use."],
						dialogControl = "LSM30_Border",
						values = MediaListBorder,
						order = 40,
					},
					edgeSize = {
						type = "range",
						name = L["Border size"],
						desc = L["Sets the size of the border texture for bars belonging to this frame."],
						bigStep = 5,
						min = 1,
						max = 50,
						order = 50,
					},
					tile = {
						type = "toggle",
						name = L["Tile background"],
						desc = L["Whether or not the background should tile instead of stretching."],
						order = 40,
					},
					insets = {
						type = "group",
						name = L["Insets"],
						desc = L["Stretches or shrinks the background texture."],
						inline = true,
						order = 60,
						args = {
							left = {
								type = "range",
								name = L["Left"],
								desc = L["Stretches or shrinks the background texture."],
								bigStep = 5,
								min = -50,
								max = 50,
								order = 10,
							},
							right = {
								type = "range",
								name = L["Right"],
								desc = L["Stretches or shrinks the background texture."],
								bigStep = 5,
								min = -50,
								max = 50,
								order = 20,
							},
							top = {
								type = "range",
								name = L["Top"],
								desc = L["Stretches or shrinks the background texture."],
								bigStep = 5,
								min = -50,
								max = 50,
								order = 30,
							},
							bottom = {
								type = "range",
								name = L["Bottom"],
								desc = L["Stretches or shrinks the background texture."],
								bigStep = 5,
								min = -50,
								max = 50,
								order = 40,
							},
						},
					},
				},
			},
			Status = {
				type = "group",
				desc = L["Configures the statusbar options."],
				name = L["Statusbar"],
				order = 10,
				args = {
					StatusTexture = {
						type = "select",
						name = L["Texture"],
						desc = L["Sets the statusbar texture."],
						values = MediaListStatus,
						width = "full",
						dialogControl = "LSM30_Statusbar",
						order = 10,
					},
					StatusLeftSpacing = {
						type = "range",
						name = L["Left Spacing"],
						desc = L["Sets the spacing between the statusbar texture and the edge of the bar."],
						min = -5,
						max = 5,
						bigStep = 1,
						order = 20,
					},
					StatusRightSpacing = {
						type = "range",
						name = L["Right Spacing"],
						desc = L["Sets the spacing between the statusbar texture and the edge of the bar."],
						min = -5,
						max = 5,
						bigStep = 1,
						order = 30,
					},
					StatusTopSpacing = {
						type = "range",
						name = L["Top Spacing"],
						desc = L["Sets the spacing between the statusbar texture and the edge of the bar."],
						min = -5,
						max = 5,
						bigStep = 1,
						order = 40,
					},
					StatusBottomSpacing = {
						type = "range",
						name = L["Bottom Spacing"],
						desc = L["Sets the spacing between the statusbar texture and the edge of the bar."],
						min = -5,
						max = 5,
						bigStep = 1,
						order = 50,
					},
					StatusBarDirection = {
						type = "select",
						name = L["Bar Direction"],
						desc = L["Force all bars to go a certain direction, or use default for default settings."],
						values = function()
							local t = {}
							t["reverse"] = L["Left to Right"]
							t["notreverse"] = L["Right to Left"]
							t["default"] = L["Default"]
							return t
						end,
						order = 100,
					},
				},
			},
			Icon = {
				type = "group",
				desc = L["Configures icon options."],
				name = L["Icon"],
				order = 30,
				args = {
					IconVisible = {
						type = "toggle",
						name = L["Visible"],
						desc = L["Sets the visibilty of the bar icon."],
						order = 10,
					},
					IconLocation = {
						type = "select",
						name = L["Location"],
						desc = L["Sets the anchor location of the bar icon."],
						values = {
							LEFT = L["Left"],
							RIGHT = L["Right"],
						},
						order = 20,
						disabled = "GetDisabledOption",
					},
					IconWidth = {
						type = "range",
						name = L["Icon Width"],
						desc = L["Sets the width of the bar icon.\rAuto-Size: 0"],
						min = 0,
						max = 100,
						step = 1,
						bigStep = 1,
						order = 21,
					},
					IconHeight = {
						type = "range",
						name = L["Icon Height"],
						desc = L["Sets the height of the bar icon.\rAuto-Size: 0"],
						min = 0,
						max = 100,
						step = 1,
						bigStep = 1,
						order = 22,
					},
					IconOffsetX = {
						type = "range",
						name = L["Icon Offset X"],
						desc = L["Sets the X offset of the bar icon.\rAuto-Position: 0"],
						min = -1000,
						max = 1000,
						step = 0.01,
						bigStep = 5,
						order = 23,
					},
					IconOffsetY = {
						type = "range",
						name = L["Icon Offset Y"],
						desc = L["Sets the Y offset of the bar icon.\rAuto-Position: 0"],
						min = -100,
						max = 100,
						step = 0.01,
						bigStep = 2,
						order = 24,
					},
					IconColorUsed = {
						type = "toggle",
						name = L["Use Icon Color"],
						desc = L["Toggle using a custom color for the bar icon."],
						order = 30,
						disabled = "GetDisabledOption",
					},
					IconColor = {
						type = "color",
						name = L["Icon Color"],
						desc = L["Sets the color of the bar icon."],
						order = 40,
						disabled = "GetDisabledOption",
						hasAlpha = true,
					},
				},
			},
			Label = {
				type = "group",
				desc = L["Configures icon options."],
				name = L["Label"],
				order = 40,
				args = {
					LabelFont = {
						type = "select",
						name = L["Font"],
						desc = L["Sets the label font."],
						dialogControl = "LSM30_Font",
						values = MediaListFont,
						order = 10,
					},
					LabelFontSize = {
						type = "range",
						name = L["Font Size"],
						desc = L["Sets the size of the label font."],
						min = 9,
						max = 24,
						bigStep = 1,
						order = 20,
					},
					LabelJustifyH = {
						type = "select",
						name = L["Horizontal justify"],
						desc = L["Justifies the label position."],
						values = {
							LEFT = L["Left"],
							CENTER = L["Center"],
							RIGHT = L["Right"],
						},
						order = 30,
					},
					LabelJustifyV = {
						type = "select",
						name = L["Vertical justify"],
						desc = L["Justifies the label position."],
						values = {
							TOP = L["Top"],
							CENTER = L["Center"],
							BOTTOM = L["Bottom"],
						},
						order = 40,
					},
					LabelAdjust = {
						type = "range",
						name = L["Horizontal adjust"],
						desc = L["Slightly adjusts the horizontal positioning of the label text."],
						min = -50,
						max = 50,
						bigStep = 5,
						order = 50,
					},
					LabelColor = {
						type = "color",
						name = L["Color"],
						desc = L["Sets the coloring used on the label text."],
						hasAlpha = true,
						order = 60,
					},
					LabelUseShadowColor = {
						type = "toggle",
						name = L["Use Shadow Color"],
						desc = L["Toggle's using shadow colors on this label."],
						order = 79,
					},
					LabelShadowColor = {
						type = "color",
						name = L["Shadow Color"],
						desc = L["Sets the shadow color used on the label text."],
						hasAlpha = true,
						order = 70,
						disabled = "GetDisabledOption",
					},
					LabelShadowOffsetX = {
						type = "range",
						name = L["Shadow Offset-X"],
						desc = L["Sets the X-Value of the shadow offset."],
						min = -10,
						max = 10,
						bigStep = 1,
						order = 80,
						disabled = "GetDisabledOption",
					},
					LabelShadowOffsetY = {
						type = "range",
						name = L["Shadow Offset-Y"],
						desc = L["Sets the Y-Value of the shadow offset."],
						min = -10,
						max = 10,
						bigStep = 1,
						order = 90,
						disabled = "GetDisabledOption",
					},
					LabelOutline = {
						type = "select",
						name = L["Outline"],
						desc = L["Select the outline you wish to use."],
						values = {[""] = L["None"], ["OUTLINE"] = L["Outline"], ["THICKOUTLINE"] = L["Thick Outline"]},
						order = 100,
					},
				},
			},
			Timer = {
				type = "group",
				desc = L["Configures icon options."],
				name = L["Timer"],
				order = 50,
				args = {
					TimerFont = {
						type = "select",
						name = L["Font"],
						desc = L["Sets the timer font."],
						dialogControl = "LSM30_Font", 
						values = MediaListFont,
						order = 10,
					},
					TimerFontSize = {
						type = "range",
						name = L["Font Size"],
						desc = L["Sets the size of the timer font."],
						min = 9,
						max = 24,
						bigStep = 1,
						order = 20,
					},
					TimerJustifyH = {
						type = "select",
						name = L["Horizontal justify"],
						desc = L["Justifies the timer position."],
						values = {
							LEFT = L["Left"],
							CENTER = L["Center"],
							RIGHT = L["Right"],
						},
						order = 30,
					},
					TimerJustifyV = {
						type = "select",
						name = L["Vertical justify"],
						desc = L["Justifies the timer position."],
						values = {
							TOP = L["Top"],
							CENTER = L["Center"],
							BOTTOM = L["Bottom"],
						},
						order = 40,
					},
					TimerAdjust = {
						type = "range",
						name = L["Horizontal adjust"],
						desc = L["Slightly adjusts the horizontal positioning of the timer text."],
						min = -50,
						max = 50,
						bigStep = 5,
						order = 50,
					},
					TimerColor = {
						type = "color",
						name = L["Color"],
						desc = L["Sets the coloring used on the timer text."],
						hasAlpha = true,
						order = 60,
					},
					TimerFormat = {
						type = "range",
						name = L["Timer Format"],
						desc = L["Set the number of miliseconds to show on the timer text."],
						min = 0,
						max = 3,
						step = 1,
						bigStep = 1,
						order = -1,
					},
				},
			},
			Spark = {
				type = "group",
				desc = L["Configures spark options."],
				name = L["Spark"],
				order = 60,
				args = {
					SparkVisible = {
						type = "toggle",
						name = L["Visible"],
						desc = L["Sets the visibilty of the bar spark."],
						order = 10,
					},
					SparkTexture = {
						type = "select",
						name = L["Texture"],
						desc = L["Sets the spark texture for bars to use."],
						values = MediaListSpark,
						order = 20,
						disabled = "GetDisabledOption",
					},
					SparkBlend = {
						type = "select",
						name = L["Blend"],
						desc = L["Sets the blending used to render the spark texture."],
						values = blendModes,
						order = 30,
						disabled = "GetDisabledOption",
					},
					SparkHeight = {
						type = "range",
						name = L["Height"],
						desc = L["Sets the height scale used on the spark texture."],
						isPercent = true,
						min = .1,
						max = 3,
						bigStep = .1,
						order = 40,
						disabled = "GetDisabledOption",
					},
					SparkWidth = {
						type = "range",
						name = L["Width"],
						desc = L["Sets the width scale used on the spark texture."],
						isPercent = true,
						min = .1,
						max = 3,
						bigStep = .1,
						order = 50,
						disabled = "GetDisabledOption",
					},
					SparkColor = {
						type = "color",
						name = L["Color"],
						desc = L["Sets the coloring used on the spark texture."],
						hasAlpha = true,
						order = 60,
						disabled = "GetDisabledOption",
					},
				},
			},
		},
	},
	FilterOptions = {
		type = "group",
		desc = L["Controls which bars should be rejected from this frame."],
		name = L["Filtering options"],
		order = 90,
		childGroups = "tab",
		args = {
			CategoryList = {
				type = "group",
				desc = L["Rejects bars that aren't part of an allowed category."],
				name = function() RefreshConfigModuleCategories() return L["Categories"] end,
				order = 10,
				childGroups = "select",
				get = function(info, key)
					if info[#info]:find("selectall") then
						info[#info] = info[#info]:gsub("selectall", "")
						debug(GetHandler(info).db.profile.CategoriesList[moduleCategories[info[#info]].name][key])
						local num, maxnum = 0, 0
						for _, value in pairs(GetHandler(info).db.profile.CategoriesList[moduleCategories[info[#info]].name]) do
							if value then
								num = num + 1
							end
							maxnum = maxnum + 1
						end
						return num == maxnum and true or false
					end
					return GetHandler(info).db.profile.CategoriesList[moduleCategories[info[#info]].name][key]
				end,
				set = function(info, key, value)
					if info[#info]:find("selectall") then
						info[#info] = info[#info]:gsub("selectall", "")
						for name, _ in pairs(GetHandler(info).db.profile.CategoriesList[moduleCategories[info[#info]].name]) do
							GetHandler(info).db.profile.CategoriesList[moduleCategories[info[#info]].name][name] = key
						end
						return
					end
					GetHandler(info).db.profile.CategoriesList[moduleCategories[info[#info]].name][key] = value
				end,
				args = moduleCategories,
			},
			Length = {
				type = "group",
				desc = L["Rejects bars that are over or under a certain length."],
				name = L["Length"],
				order = 20,
				args = {
					ByMaxLength = {
						type = "toggle",
						name = L["Filter By Max Length"],
						desc = L["Whether or not this frame should reject bars over a certain amount of time."],
						order = 10,
					},
					MaxLength = {
						type = "range",
						name = L["Max Length"],
						desc = L["The maximum amount of time, in seconds, before a bar will be rejected."],
						bigStep = 10,
						min = 0,
						max = 600,
						order = 20,
						disabled = "GetDisabledOption",
					},
					Break1 = {type = "header", name = "", order = 25},
					ByMinLength = {
						type = "toggle",
						name = L["Filter By Min Length"],
						desc = L["Whether or not this frame should reject bars under a certain amount of time."],
						order = 30,
					},
					MinLength = {
						type = "range",
						name = L["Min Length"],
						desc = L["The minimum amount of time, in seconds, before a bar will be rejected."],
						bigStep = 10,
						min = 0,
						max = 600,
						order = 40,
						disabled = "GetDisabledOption",
					},
				},
			},
		},
	},
	Custom = {
		type = "group",
		name = function(info) BuildCustomLabels(GetHandler(info)) return L["Custom labels"] end,
		order = 93,
		childGroups = "select",
		args = customLabels,
	},
	Messages = {
		type = "group",
		name = L["Message options"],
		desc = L["Customize Messages sent by clicking this bar."],
		order = 94,
		args = {
			CustomTimeMessage = {
				type = "input",
				name = L["Time Message"],
				desc = L["Customize the message displayed when clicking timed bars."],
				usage = L["<Message>"],
				width = "full",
				validate = function(_, msg)
					if msg == "" then
						return L["Error: The message must exist!"]
					elseif msg == " " then
						return L["Error: The message must contain more than a space!"]
					elseif msg:match("^%s%s+") then
						return L["Error: The message must not start with a multiple spaces (or be all spaces)!"]
					end
					return true
				end,
				order = 10,	
			},
			ResetTimedMessage = {
				type = "execute",
				name = L["Reset Timed Message"],
				desc = L["Resets the timed message."],
				order = 11,
				func = "ResetCustomMessages",
			},
			CustomCountMessage = {
				type = "input",
				name = L["Count Message"],
				desc = L["Customize the message displayed when clicking counting bars."],
				usage = L["<Message>"],
				width = "full",
				validate = function(_, msg)
					if msg == "" then
						return L["Error: The message must exist!"]
					elseif msg == " " then
						return L["Error: The message must contain more than a space!"]
					elseif msg:match("^%s%s+") then
						return L["Error: The message must not start with a multiple spaces (or be all spaces)!"]
					end
					return true
				end,
				order = 20,
			},
			ResetCountMessage = {
				type = "execute",
				name = L["Reset Count Message"],
				desc = L["Resets the count message."],
				order = 21,
				func = "ResetCustomMessages",
			},
			Help = {
				type = "group",
				name = " ",
				order = -1,
				inline = true,
				args = {
					help = {
						type = "description", 
						name = L["|cff82e6ffAll:|r\r|cff51c5dd<label>|r--Label of the bar\r\r|cff82e6ffTimed Bars:|r\r|cff51c5dd<curtime>|r--Current time expired on bar with text\r\r|cff51c5dd<curtimetrue>|r--Current time expired on bar without text\r\r|cff51c5dd<maxtime>|r--Max time on bar with text\r\r|cff51c5dd<maxtimetrue>|r--Max time on bar without text\r\r|cff51c5dd<remaintime>|r--Current time remaining on bar with text\r\r|cff51c5dd<remaintimetrue>|r--Current time remaining on bar without text\r\r|cff51c5dd<perctime>|r--Percentage of time spent on bar with \"%\"\r\r|cff51c5dd<perctimetrue>|r--Percentage of time spent on bar without \"%\"\r\r\r|cff71d5ffCounting Bars:|r\r|cff51c5dd<count>|r--Current count of counting bar\r\r|cff51c5dd<maxcount>|r--Max count of counting bar\r\r|cff51c5dd<remaincount>|r--Remaining count of counting bar"],
					},
				},
			},
		},
	},
	SoundOptions = {
		type = "group",
		name = L["Sound options"],
		order = 95,
		set = "SetSoundOption",
		get = "GetSoundOption",
		args = {
			DisableAllSounds = {
				type = "execute",
				name = L["Disable all sounds"],
				desc = L["Disables sounds for all categories and subcategories."],
				func = function(info)
					GetHandler(info):SetAllSounds(false)
				end,
				order = 2,
			},
			EnableAllSounds = {
				type = "execute",
				name = L["Enable all sounds"],
				desc = L["Enables sounds for all categories and subcategories."],
				func = function(info)
					GetHandler(info):SetAllSounds(true)
				end,
				order = 3,
			},
			CurrentCategory = {
				type = "select",
				name = L["Select category"],
				desc = L["Selects the category to configure sound options for."],
				set = "SetCurrentSoundCategory",
				get = "GetCurrentSoundCategory",
				values = function()
					local dict = {}
					dict["Boss Abilities"]--#NO_LOCALIZE
						= L["Boss Abilities"]
					for name, module in Core:IterateModules("Plugin") do
						if module:GetCategories() then
							dict[name] = name
						end
					end
					return dict
				end,
				order = 8,
			},
			CurrentSubCategory = {
				type = "select",
				name = L["Select subcategory"],
				desc = L["Selects the subcategory to configure sound options for."],
				set = "SetCurrentSoundSubCategory",
				get = "GetCurrentSoundSubCategory",
				values = "GetSoundSubCategoryChoices",
				order = 9,
			},
			SoundByPercent = {
				type = "toggle",
				name = L["Sound alert by percent"],
				desc = L["Enables an alert when bars are under a certain percentage in time. For example, if this is set to 50% and a 2 minute bar goes under 1 minute left a sound will be played."],
				order = 10,
			},
			SoundPercent = {
				type = "range",
				name = L["Alert percentage"],
				desc = L["If the bar time goes under this percentage of time a sound will be played."],
				isPercent = true,
				bigStep = .05,
				min = 0,
				max = 1,
				order = 20,
				disabled = "GetSoundDisabledSetting",
			},
			SoundByTime = {
				type = "toggle",
				name = L["Sound alert by absolute time"],
				desc = L["Enables an alert when bars are under a certain amount of seconds. If sound alert by percent is also enabled whichever criteria is met first will trigger the sound."],
				order = 30,
			},
			SoundTime = {
				type = "range",
				name = L["Alert time"],
				desc = L["If the bar time goes under this time in seconds a sound will be played."],
				bigStep = 5,
				min = 0,
				max = 600,
				order = 40,
				disabled = "GetSoundDisabledSetting",
			},
			SoundToPlay = {
				type = "select",
				name = L["Sound to play"],
				desc = L["Sets the sound that will be played when the criteria above is met."],
				values = MediaListSound,
				dialogControl = "LSM30_Sound",
				order = 50,
			},
		},
	},
	ThemeOptions = {
		type = "group",
		desc = L["Themes allow you to save all the settings from a frame and apply them to other frames."],
		name = L["Theme options"],
		order = 100,
		args = {
			SaveTheme = {
				type = "group",
				desc = L["Sets up options that allow you to save the current frame settings as a theme so they can be easily re-applied to this or another frame later."],
				name = L["Save theme options"],
				order = 10,
				set = SetThemeOption,
				get = GetThemeOption,
				args = {
					Filters = {
						type = "toggle",
						name = L["Save filter settings"],
						desc = L["Saves filter settings from this frame into the theme.\n\nThis option is not saved between sessions."],
						order = 10,	
					},
					Elements = {
						type = "toggle",
						name = L["Save bar element settings"],
						desc = L["Saves bar element settings (such as icon, font, and so on) from this frame into the theme.\n\nThis option is not saved between sessions."],
						order = 20,
					},
					Transfer = {
						type = "toggle",
						name = L["Save transfer options"],
						desc = L["Saves frame transfer settings from this frame into the theme.\n\nThis option is not saved between sessions."],
						order = 30,
					},
					Sound = {
						type = "toggle",
						name = L["Save sound options"],
						desc = L["Saves sound options from this frame into the theme.\n\nThis option is not saved between sessions."],
						order = 40,
					},
					SaveTheme = {
						type = "input",
						name = L["Save current as:"],
						desc = L["Saves the current settings from this frame as a theme using the options set above."],
						get = false,
						set = function(info, name)
							GetHandler(info):SaveTheme(themeOpts, name)
						end,
						order = 50,
						usage = L["Enter the name of the theme you wish to save the frame as and press enter."],
					},
				},
			},				
			ApplyTheme = {
				type = "select",
				name = L["Apply theme"],
				desc = L["Applies all the settings saved in a theme to this frame. WARNING: CURRENT SETTINGS WILL BE LOST."],
				get = Noop,
				--set = "ApplyTheme",
				set = function(info, value)
					Core:ApplyTheme(info.handler.Name, value)
				end,
				values = function()
					local list = {}
					for name in pairs(ThemeList) do
						list[name] = name
					end
					return list
				end,
				order = 20,
			},
			KeepAnchorPoints = {
				type = "toggle",
				name = L["Keep anchor points"],
				desc = L["Keeps the current frame's anchor points when applying a theme."],
				order = 30,
			},
			MergeWithExisting = {
				type = "toggle",
				name = L["Merge theme with existing settings"],
				desc = L["Merges the current frame settings with the applying theme, otherwise the frame will be reset to defaults before the theme is applied."],
				width = "double",
				order = 40,
			},
			SaveFilters = {
				type = "toggle",
				name = L["Save filters"],
				desc = L["When applying a theme the current frame filters will be saved, instead using filters saved in the theme."],
				order = 50,
			},
		},
	},
}
options.args.profile = _G.LibStub("AceDBOptions-3.0"):GetOptionsTable(RBM.db)