do return end
local module = RBM:NewPlugin("Version Query")
local player = UnitName("player")

local L = module:GetTranslations()

module:RegisterTranslations("enUS", -- translation automatically generated
	"No response", true,
	"Offline", true,
	"RBM Group Versions", true,
	"RBM not found", true,
	"Refresh", true,
	"Request version info", true,
	"Requests version information about RBM from other raid members. (Must be in a group)", true
)

module:RegisterTranslations("zhCN", -- translation automatically generated
	"No response", "没有回应",
	"Offline", "离线",
	"RBM Group Versions", "RBM队伍版本",
	"RBM not found", "RBM未找到",
	"Refresh", "刷新",
	"Request version info", "刷新版本信息",
	"Requests version information about RBM from other raid members. (Must be in a group)", "查询团队成员的RBM版本信息。（需要在团队中）"
)

module:RegisterTranslations("zhTW", -- translation automatically generated
	"No response", "沒有回應",
	"Offline", "離線",
	"RBM Group Versions", "RBM隊伍版本",
	"RBM not found", "RBM未找到",
	"Refresh", "刷新",
	"Request version info", "刷新版本資訊",
	"Requests version information about RBM from other raid members. (Must be in a group)", "查詢團隊成員的RBM版本資訊。（需要在團隊中）"
)

module:RegisterTranslations("koKR", -- translation automatically generated
	"No response", "응답 없음",
	"Offline", "오프라인",
	"RBM Group Versions", "RBM 그룹 버전",
	"RBM not found", "RBM을 찾을 수 없음",
	"Refresh", "새로고침",
	"Request version info", "버전 정보 요청",
	"Requests version information about RBM from other raid members. (Must be in a group)", "RBM으로부터 다른 공대원의 버전 정보를 요청합니다. (이 그룹에 있어야 합니다)"
)

function module:OnInitialize()
	self:GetFreshOptionsTable().args.RequestVersions = {
		type = "execute",
		name = L["Request version info"],
		desc = L["Requests version information about RBM from other raid members. (Must be in a group)"],
		func = "RequestInfo",
		disabled = function()
			if not UnitInRaid("player") and GetNumPartyMembers() == 0 then
				return true
			end
		end,
	}
end

local Frame
local function CreateVersionFrame()
	local f = CreateFrame("Frame", nil, Frame)
	f:SetHeight(10)

	f.text = f:CreateFontString()
	f.text:SetFontObject("GameFontNormal")
	f.text:SetAllPoints(f)
	f.text:SetJustifyH("LEFT")

	f.version = f:CreateFontString()
	f.version:SetAllPoints(f)
	f.version:SetFontObject("GameFontNormal")
	f.version:SetJustifyH("RIGHT")

	f.icon = f:CreateTexture()
	f.icon:SetPoint("TOPRIGHT", f, "TOPLEFT")
	f.icon:SetPoint("BOTTOMRIGHT", f, "BOTTOMLEFT")
	f.icon:SetWidth(10)

	f:SetPoint("LEFT", 20, 0)
	f:SetPoint("RIGHT", -10, 0)
	
	return f
end

local function GetVersion(vers)
	if vers == "hidden" then--#NO_LOCALIZE
		return -4
	elseif vers == L["Offline"] then
		return -3
	elseif vers == L["RBM not found"] then
		return -2
	elseif vers == L["No response"] then
		return -1
	end
	local major, minor = vers:match("(%d+)%.(%d+)")--#NO_LOCALIZE
	if major then
		return major * 10000 + minor
	end
	return 0
end

local players
local function Sort()
	table.sort(players, function(a, b)
		return GetVersion(a.vers) > GetVersion(b.vers)
	end)

	for i, f in ipairs(players) do
		if i == 1 then
			f:SetPoint("TOP", Frame, "TOP", 5, -10)
		else
			f:SetPoint("TOP", players[i-1], "BOTTOM")
		end
	end
	
end

function module:RequestInfo()
	if not Frame then
		players = {}
		local f = CreateFrame("Frame", nil, UIParent)
		f:SetFrameStrata("DIALOG")
		f:SetWidth(250)
		f:SetHeight(500)
		f:EnableMouse(true)
		f:SetMovable(true)
		f:SetScript("OnMouseDown", f.StartMoving)
		f:SetScript("OnMouseUp", f.StopMovingOrSizing)

		f:SetBackdrop{
			bgFile = [[Interface/Tooltips/UI-Tooltip-Background]],
			edgeFile = [[Interface/DialogFrame/UI-DialogBox-Gold-Border]],
			edgeSize = 16,
			insets = {left = 4, right = 4, top = 4, bottom = 4},
		}

		f:SetBackdropColor(0, 0, 0)



		local t = f:CreateFontString()
		t:SetFontObject("GameFontNormal")
		t:SetPoint("TOP", f, "TOP", 0, 5)
		t:SetText(L["RBM Group Versions"])

		local r = CreateFrame("Button", nil, f, "UIPanelButtonTemplate")
		r:SetText(L["Refresh"])
		r:SetWidth(250/2 - 17)
		r:SetHeight(25)
		r:SetPoint("BOTTOMLEFT", f, "BOTTOMLEFT", 15, 15)
		r:SetScript("OnClick", function() self:RequestInfo() end)

		local c = CreateFrame("Button", nil, f, "UIPanelButtonTemplate")
		c:SetText(L["Close"])
		c:SetWidth(250/2 - 17)
		c:SetHeight(25)
		c:SetPoint("LEFT", r, "RIGHT", 5, 0)
		c:SetScript("OnClick", function() f:Hide() end)

		Rock("LibRockComm-1.0"):AddAddonVersionReceptor(function(name, addon, version)
			if addon == "RBM" and f:IsShown() then--#NO_LOCALIZE
				local frame
				for i, f in ipairs(players) do
					if f.name == name then
						frame = f
						break
					end
				end
				if not frame or not frame:IsVisible() then return end
				if not version then
					frame.vers = L["RBM not found"]
					frame.text:SetTextColor(1, .1, .1)
					frame.version:SetTextColor(1, .1, .1)
					frame.icon:SetTexture[[Interface/DialogFrame/DialogAlertIcon]]
				else
					frame.vers = version
					local version = GetVersion(version)
					local ours = GetVersion(RBM.version)
					if version == ours then
						frame.version:SetTextColor(.5, .9, .5)
						frame.text:SetTextColor(.5, .9, .5)
						frame.icon:SetTexture[[Interface/Icons/Inv_Misc_SummerFest_BrazierGreen]]
					elseif version < ours then
						frame.version:SetTextColor(.9, .5, .5)
						frame.text:SetTextColor(.9, .5, .5)
						frame.icon:SetTexture[[Interface/DialogFrame/DialogAlertIcon]]
					elseif version > ours then
						frame.version:SetTextColor(.5, .5, .9)
						frame.text:SetTextColor(.5, .5, .9)
						frame.icon:SetTexture[[Interface/Icons/INV_Misc_MissileLargeCluster_Blue]]
					end
				end
				frame.version:SetText(frame.vers)
				Sort()
			end
		end)

		f:SetPoint("CENTER", 0, 0)

		Frame = f

	else
		Frame:Show()
		for k, frame in pairs(players) do
			frame:Hide()
			frame.vers = "hidden"--#NO_LOCALIZE
		end
	end
	local inRaid = UnitInRaid("player")
	local num = (inRaid and GetNumRaidMembers() or GetNumPartyMembers())

	Frame:SetHeight(10 * num + 60)

	local function AddUnit(i, unit) --how many times does someone check versions per session? i think this is acceptable garbage + saves memory and cleaner code
		local name, online = UnitName(unit), UnitIsConnected(unit)

		local frame

		if not players[i] then
			frame = CreateVersionFrame()
			players[i] = frame
		else
			frame = players[i]
		end

		frame.text:SetText(name)
		frame.name = name

		frame:Show()

		if UnitIsUnit(unit, "player") then
			frame.text:SetTextColor(.6, 1, .6)
			frame.version:SetTextColor(.6, 1, .6)
			frame.vers = tostring(RBM.version)
		elseif not online then
			frame.text:SetTextColor(.5, .5, .5)
			frame.version:SetTextColor(.5, .5, .5)
			frame.vers = L["Offline"]
		else
			frame.text:SetTextColor(1, 0, 0)
			frame.version:SetTextColor(1, 0, 0)
			frame.vers = L["No response"]
		end
		frame.version:SetText(frame.vers)

		frame.icon:SetTexture(name == player and [[Interface/Icons/Inv_Misc_SummerFest_BrazierGreen]] or [[Interface/Icons/INV_Misc_QuestionMark]])
	end
	local unit = inRaid and "raid" or "party"--#NO_LOCALIZE
	for i=1, num do
		AddUnit(i, unit..i)
	end
	if not inRaid then
		AddUnit(num + 1, "player")
	end

	Sort()

	Rock("LibRockComm-1.0"):QueryAddonVersion("RBM", "GROUP")

	if _G["LibRockConfig-1.0_Frame"] then
		_G["LibRockConfig-1.0_Frame"]:Hide()
	end
end