local UnitInRaid = UnitInRaid
local GetNumRaidMembers = GetNumRaidMembers
local GetRaidRosterInfo = GetRaidRosterInfo
local GetNumPartyMembers = GetNumPartyMembers
local UnitName = UnitName
local UnitExists = UnitExists
local IsRaidOfficer = IsRaidOfficer
local IsRaidLeader = IsRaidLeader
local SendChatMessage = SendChatMessage
local UnitAffectingCombat = UnitAffectingCombat
local GetTime = GetTime
local UnitIsDead = UnitIsDead
local GetRealZoneText = GetRealZoneText
local GetNumAddOns = GetNumAddOns
local IsAddOnLoadOnDemand = IsAddOnLoadOnDemand
local IsAddOnLoaded = IsAddOnLoaded
local GetAddOnInfo = GetAddOnInfo
local UnitBuff = UnitBuff
local GetAddOnMetadata = GetAddOnMetadata
local GetRealZoneText = GetRealZoneText
local LoadAddOn = LoadAddOn
local PlaySoundFile = PlaySoundFile
local SetRaidTarget = SetRaidTarget
local RequestRaidInfo = RequestRaidInfo
local UnitClass = UnitClass
local UnitPowerType = UnitPowerType
local UnitIsEnemy = UnitIsEnemy
local UnitCanAttack = UnitCanAttack
local pairs, ipairs = pairs, ipairs
local gsub = string.gsub
local isLoaded = false
local LibStub = LibStub
local date = date
local pairs = pairs
local unpack = unpack
local select = select
local next = next
local type = type

local format = string.format
local GetNumSavedInstances, GetSavedInstanceInfo = GetNumSavedInstances, GetSavedInstanceInfo

setfenv(1, RBM.FunctionEnviroment)
local bossNameLst
local BossModuleClass = BossModuleClass
local MediaHandler = MediaHandler
--BossModuleClasss inherits from the Base class
BaseClass:Embed(BossModuleClass)
--#AUTODOC_NAMESPACE BossModuleClass

local Super = BaseClass
local AddBossDeathToQueue

local syncs = {}
local throttles = {}
local new, del
do
	local cache = {}
	function new()
		if #cache > 0 then
			local t = cache[#cache]
			cache[#cache] = nil
			return t
			
		end
		return {}
	end

	function del(t)
		for k in pairs(t) do
			t[k] = nil
		end
		cache[#cache + 1] = t
	end
end

--[[=================================================================]]--
--[[======================Object State Control=======================]]--
--[[=================================================================]]--
local running = {}


--Called when the module starts
BossModuleClass.OnStart = Noop

--Called when the module stops
BossModuleClass.OnStop = Noop

BossModuleClass.OnSync = Noop

--[[
Returns:
	*boolean - True if the module is running, false otherwise
]]	
function BossModuleClass:IsRunning()
	return running[self] ~= nil
end

--[[
Returns:
	*boolean - True if the module is enabled and not currently running, false otherwise
]]
function BossModuleClass:CanStart()
	return self:IsEnabled() and not self:IsRunning()
end

--[[
Returns:
	*boolean - True if the module is enabled and currently running, false otherwise
]]
function BossModuleClass:CanStop()
	return self:IsEnabled() and self:IsRunning()
end

--[[
Notes:
	*Disables a module, causing all bars to be canceled and the object to go into standby
]]
function BossModuleClass:Disable()
	if self:IsEnabled() then
		self:SendMessage("RBM_BossModuleDisabled", self)
		self:Stop()
		Super.Disable(self)
	end
end

--#NODOC
function BossModuleClass:WakingEventHandler(...)
	if running[self] then
		if type(self.CheckStop) ~= "function" or self:CheckStop(...) then
			self:Stop()
		end
	else
		if type(self.CheckStart) ~= "function" or self:CheckStart(...) then
			self:Start()
		end
	end
end

local function HandleWakingEvents(self, events)
	if type(events) == "string" then
		self:RegisterEvent(events, "WakingEventHandler")
	else
		for i, event in ipairs(events) do
			self:RegisterEvent(event, "WakingEventHandler")
		end
	end
end

--[[
Notes:
	*Enables a module, the module will call :OnEnable if available and listen for its waking events
]]
function BossModuleClass:Enable()
	if not self:IsEnabled() then
		Super.Enable(self)
		if self._StartEvents then
			HandleWakingEvents(self, self._StartEvents)
		end
	end
	self:SendMessage("RBM_BossModuleEnabled", self)
end

--#NODOC
function BossModuleClass:Initialize()
	if not self:IsInitialized() then
		self:RegisterToggles(L["Announce"], false)
		self:RegisterExecutes(L["Force Start"], self.Start, L["Force Stop"], self.Stop)
		Super.Initialize(self)
		if not bossNameLst then
			bossNameLst = {}
		end
		if self.DeathName then
			bossNameLst[self.DeathName] = self:GetName()
		end
		if self.DeathName2 then
			bossNameLst[self.DeathName2] = self:GetName()
		end
		if self.StartName then
			bossNameLst[self.StartName] = self:GetName()
		end
		if not self:GetDisplayZone() then
			error("SetZones must be called before or during OnInitialize in module [%q].", self:GetName())
		end
	end
end

do
	local ToggleActive = {
		type = "toggle",
		name = L["Enabled"],
		desc = L["Controls the active state of this module."],
		set = "Toggle",
		get = "IsEnabled",
		disabled = "IsBossDead",
		order = -.001,
	}
	local IsBossDead = {
		type = "execute",
		name = L["Clear boss death"],
		desc = L["Clears the boss death of this module, a module cannot be enabled unless its boss is flagged as alive."],
		func = "RemoveBossDeath",
		hidden = "IsBossAlive",
		confirm = true,
		confirmText = L["Are you sure?"],
		disabled = false,
		order = -.001,
	}
	--#NODOC
	--see BaseClass
	function BossModuleClass:GetFreshOptionsTable(force)
		local t = Super.GetFreshOptionsTable(self, force)
		t.args.ToggleActive = ToggleActive
		t.args.IsBossDead = IsBossDead
		return t
	end
end

--[[
Notes:
	*Stops a module, the module will call :OnStop if available and listen for its waking events
]]
function BossModuleClass:Stop()
	if running[self] then
		self:CancelBars()
		self:CancelAllTimers()
		self:ClearAnnounceTable()
		self:UnregisterAllEvents()
		self:RemoveAllSyncs()
		self:OnStop()
		self.DeathLst = nil
		running[self] = nil
		if self._StartEvents then
			HandleWakingEvents(self, self._StartEvents)
		end
		Core:DistanceFrameRemove()
		Core:HealthFrameRemove()
		self:SendMessage("RBM_BossModuleStopped", self)
	end
end

--[[
Notes:
	*Starts a module, the module will call :OnStart if available and listen for its sleeping events
	*If self.startLate is not true then it will call self:Sync("Start")
]]
function BossModuleClass:Start()
	if self:IsEnabled() and not running[self] then
		running[self] = GetTime()
		self:UnregisterAllEvents()
		self:OnStart()
		self.DeathLst = nil
		self.DeathName = self.DeathName or self:GetName()
		if not self.berserkStartLate and self.berserkTime and self:CheckToggle(L["Berserk"]) or not self.enrageStartLate and self.enrageTime and self:CheckToggle(L["Enrage"]) then
			self:CreateEnrageBars()
		end
		if not self.startLate then
			self:Sync("Start")
		end
		if self._StopEvents then
			HandleWakingEvents(self, self._StopEvents)
		end
		self:Announce("High", L["%s has been engaged!"], self:GetName())
		self:SendMessage("RBM_BossModuleStarted", self)
	end
end

--[[=================================================================]]--
--[[==========================Bar Creation===========================]]--
--[[=================================================================]]--
--never call StartBar directly in a BossModule
BossModuleClass.StartBar = function(self) error("Attempt to call StartBar from a BossModule [%q]", self:GetPrefixedName()) end


--[[
Arguments:
	*none*
Notes:
	*If self.enrageTime or self.berserkTime is set it will automatically create enrage/berserk timers and announces
	*Can be called by plugins themselves if self.enrageStartLate or self.berserkLateStart = true otherwise will be automatically called when the encounter starts
]]

function BossModuleClass:CreateEnrageBars()
	local time = self.enrageTime or self.berserkTime
	local msg = self.enrageTime and L["Enrage: %d secs"] or L["Berserk: %d secs"]
	local val = time / 2
	local val2 = val % 60
	local enrageHalf = (val - val2) / 60
	self:Announce("Low", self.enrageTime and L["Enrage: %d min"] or L["Berserk: %d min"], time / 60)
	self:ScheduleAnnounce(time / 2, "Normal", self.enrageTime and L["Enrage: %d min"] or L["Berserk: %d min"], enrageHalf)
	self:ScheduleAnnounce(time - 60, "High", msg, 60)
	self:ScheduleAnnounce(time - 30, "High", msg, 30)
	self:ScheduleAnnounce(time - 10, "High", msg, 10)
	self:ScheduleAnnounce(time - 5, "High", msg, 5)
	self:BossBar(self:CreateLabel(self:GetName(), self.enrageTime and L["Enrage"] or L["Berserk"]), "Cooldown", time, self.enrageTime and 12880 or 26635, true)
end

--[[==========================Simple Local Creation===========================]]--
--These methods are never announced to the raid

--[[
Arguments:
	string - The label of the bar
	string - The subcategory the bar belongs to, one of "Cast", "Timeless", "Cooldown", "Buff", "Debuff", "Count"
	number - The time, in seconds, that the bar should run
	[optional]string - Path to the icon, or "@random" for a random icon (default: "@random")
	[optional]boolean - True if the bar should empty instead of fill (default: false)
	[optional]number - The number of times the bar should repeat before canceling (default: 0)
	[optional]float[0,1] - The red value of the bar (default: category coloring)
	[optional]float[0,1] - The green value of the bar (default: category coloring)
	[optional]float[0,1] - The blue value of the bar (default: category coloring)
Notes:
	*The icon path can be either be the full path like: "Interface/Icons/Spell_Shadow_ShadowBolt" or just the icon name like: "Spell_Shadow_ShadowBolt"; use the latter when possible
	*Local bars are never announced to the group, only the current player will see them
	*Boss bars are standard bars that continually count down from the initial time
]]
function BossModuleClass:LocalBossBar(label, subCategory, time, icon, reverse, numRepeat, red, green, blue)
	Super.StartBar(self, false, label, "Boss Abilities", subCategory, time, icon, reverse, numRepeat, nil, red, green, blue)
end

--[[
Arguments:
	string - The label of the bar
	string - The subcategory the bar belongs to, one of "Cast", "Timeless", "Cooldown", "Buff", "Debuff", "Count"
	[optional]string - Path to the icon, or "@random" for a random icon (default: "@random")
	[optional]boolean - True if the bar should empty instead of fill (default: false)
	[optional]float[0,1] - The red value of the bar (default: category coloring)
	[optional]float[0,1] - The green value of the bar (default: category coloring)
	[optional]float[0,1] - The blue value of the bar (default: category coloring)
Notes:
	*The icon path can be either be the full path like: "Interface/Icons/Spell_Shadow_ShadowBolt" or just the icon name like: "Spell_Shadow_ShadowBolt"; use the latter when possible
	*Local bars are never announced to the group, only the player will see them
	*Timeless bars are shown until canceled.
]]
function BossModuleClass:LocalTimelessBar(label, subCategory, icon, reverse, red, green, blue)
	Super.StartBar(self, false, label, "Boss Abilities", subCategory, nil, icon, reverse, numRepeat, nil, red, green, blue)
end

--[[
Arguments:
	string - The label of the bar
	string - The subcategory the bar belongs to, one of "Cast", "Timeless", "Cooldown", "Buff", "Debuff", "Count"
	integer - The maximum count of the bar
	[optional]integer - The initial count of the bar (default: 1)
	[optional]string - Path to the icon, or "@random" for a random icon (default: "@random")
	[optional]boolean - True if the bar should empty instead of fill (default: false)
	[optional]float[0,1] - The red value of the bar (default: category coloring)
	[optional]float[0,1] - The green value of the bar (default: category coloring)
	[optional]float[0,1] - The blue value of the bar (default: category coloring)
Notes:
	*The icon path can be either be the full path like: "Interface/Icons/Spell_Shadow_ShadowBolt" or just the icon name like: "Spell_Shadow_ShadowBolt"; use the latter when possible
	*Local bars are never announced to the group, only the player will see them
	*Count bars count from some number to another number, for example a certain amount of adds killed in an encounter may be shown as 2/4
]]
function BossModuleClass:LocalCountBar(label, subCategory, maxCount, count, icon, reverse, red, green, blue)
	Super.StartBar(self, false, label, "Boss Abilities", subCategory, nil, icon, reverse, maxCount, count, red, green, blue)
end

--[[==========================Simple Announced Creation===========================]]--

--[[
Arguments:
	string - The label of the bar
	string - The subcategory the bar belongs to, one of "Cast", "Timeless", "Cooldown", "Buff", "Debuff", "Count"
	number - The time, in seconds, that the bar should run
	[optional]string - Path to the icon, or "@random" for a random icon (default: "@random")
	[optional]boolean - True if the bar should empty instead of fill (default: false)
	[optional]number - The number of times the bar should repeat before canceling (default: 0)
	[optional]float[0,1] - The red value of the bar (default: category coloring)
	[optional]float[0,1] - The green value of the bar (default: category coloring)
	[optional]float[0,1] - The blue value of the bar (default: category coloring)
Notes:
	*The icon path can be either be the full path like: "Interface/Icons/Spell_Shadow_ShadowBolt" or just the icon name like: "Spell_Shadow_ShadowBolt"; use the latter when possible
	*Announced when self:CheckToggle(L["Announce"]) is true and the player is a raid officer or leaded
	*Boss bars are standard bars that continually count down from the initial time
]]
function BossModuleClass:BossBar(label, subCategory, time, icon, reverse, numRepeat, red, green, blue)
	Super.StartBar(self, (IsRaidOfficer() or IsRaidLeader()) and self:CheckToggle(L["Announce"]), label, "Boss Abilities", subCategory, time, icon, reverse, numRepeat, nil, red, green, blue)
end

--[[
Arguments:
	string - The label of the bar
	[optional]string - Path to the icon, or "@random" for a random icon (default: "@random")
	[optional]boolean - True if the bar should empty instead of fill (default: false)
	[optional]float[0,1] - The red value of the bar (default: category coloring)
	[optional]float[0,1] - The green value of the bar (default: category coloring)
	[optional]float[0,1] - The blue value of the bar (default: category coloring)
Notes:
	*The icon path can be either be the full path like: "Interface/Icons/Spell_Shadow_ShadowBolt" or just the icon name like: "Spell_Shadow_ShadowBolt"; use the latter when possible
	*Announced when self:CheckToggle(L["Announce"]) is true and the player is a raid officer or leaded
	*Timeless bars are shown until canceled.
	*Useful for things like abilities with a large variance to display that it could trigger at any time or representing an aura
	*Remember to cancel it when your event happens
	*Always belong to the "Timeless" subcategory under the "Boss Abilities" category
]]
function BossModuleClass:TimelessBar(label, icon, reverse, red, green, blue)
	Super.StartBar(self, (IsRaidOfficer() or IsRaidLeader()) and self:CheckToggle(L["Announce"]), label, "Boss Abilities", "Timeless", nil, icon, reverse, nil, nil, red, green, blue)
end

--[[
Arguments:
	string - The label of the bar
	integer - The maximum count of the bar
	[optional]integer - The initial count of the bar (default: 1)
	[optional]string - Path to the icon, or "@random" for a random icon (default: "@random")
	[optional]boolean - True if the bar should empty instead of fill (default: false)
	[optional]float[0,1] - The red value of the bar (default: category coloring)
	[optional]float[0,1] - The green value of the bar (default: category coloring)
	[optional]float[0,1] - The blue value of the bar (default: category coloring)
Notes:
	*The icon path can be either be the full path like: "Interface/Icons/Spell_Shadow_ShadowBolt" or just the icon name like: "Spell_Shadow_ShadowBolt"; use the latter when possible
	*Announced when self:CheckToggle(L["Announce"]) is true and the player is a raid officer or leaded
	*Count bars count from some number to another number, for example a certain amount of adds killed in an encounter may be shown as 2/4
	*Always belong to the "Count" subcategory under the "Boss Abilities" category
]]
function BossModuleClass:CountBar(label, maxCount, count, icon, reverse, red, green, blue)
	Super.StartBar(self, (IsRaidOfficer() or IsRaidLeader()) and self:CheckToggle(L["Announce"]), label, "Boss Abilities", "Count", nil, icon, reverse, maxCount, count, red, green, blue)
end

--[[=================================================================]]--
--[[============================Utility==============================]]--
--[[=================================================================]]--
--[[
Arguments:
	[optional]tuple - Strings to scan for (default: self:GetName())
Notes:
	*Scans the entire raid's or party's target's target and matches against the arguments
	*Generally used in the :CheckStart method along with the PLAYER_REGEN_DISABLED events to check for boss engages
Returns:
	*boolean - True if a match exists, the match has a target, and the match is in combat
]]
function BossModuleClass:ScanTargets(...)
	if not ... then
		return self:ScanTargets(self:GetName())
	end
	local numTargets = select("#", ...)
	if UnitExists("targettarget") then
		local name = UnitName("target")
		for i=1, numTargets do
			if name == select(i, ...) then
				return true
			end
		end
	end
	if UnitInRaid("player") then
		local raidNum = GetNumRaidMembers()
		for i=1, raidNum do
			local raidtarget = "raid"..i.."target"
			if UnitExists(raidtarget.."target") and UnitAffectingCombat(raidtarget) then
				local name = UnitName(raidtarget)
				for k=1, numTargets do
					if name == select(k, ...) then
						return true
					end
				end
			end
		end
	else
		local partyNum = GetNumPartyMembers()
		for i=1, partyNum do
			local partytarget = "party"..i.."target"
			if UnitExists(partytarget.."target") and UnitAffectingCombat(partytarget) then
				local name = UnitName(partytarget)
				for k=1, numTargets do
					if name == select(k, ...) then
						return true
					end
				end
			end
		end
	end
	return false
end

--[[
Arguments:
	[optional]tuple - Strings to scan for (default: self:GetName())
Notes:
	*Scans the entire raid's or party's targets and matches against the arguments
	*Generall used in the :CheckStart method along with the PLAYER_REGEN_DISABLED events to check for boss engages 
	* - when bosses don't immediately target a player when encountered.  ie: Felmyst
Returns:
	*boolean - True if a match exists and the match is in combat
]]
function BossModuleClass:ScanRealTargets(...)
	if not ... then
		return self:ScanRealTargets(self:GetName())
	end
	local numTargets = select("#", ...)
	if UnitExists("target") then
		local name = UnitName("target")
		for x=1, numTargets do
			if name == select(x, ...) then return true end
		end
	end
	if UnitInRaid("player") then
		local raidNum = GetNumRaidMembers()
		for i=1, raidNum do
			local name = UnitName("raid"..i.."target")
			if name and UnitAffectingCombat("raid"..i.."target") then
				for x=1, numTargets do
					if name == select(x, ...) then return true end
				end
			end
		end
	else
		local partyNum = GetNumPartyMembers()
		for i=1, partyNum do
			local name = UnitName("party"..i.."target")
			if name and UnitAffectingCombat("party"..i.."target") then
				for x=1, numTargets do
					if name == select(x, ...) then return true end
				end
			end
		end
	end
	return false
end

--[[
Arguments:
	string - The name of the raid member to get info on
Returns:
	*number|nil - The group number of the player passed in, nil if the player wasn't found
	*number|nil - The index of the player in the raid (UnitName("raid"..index) == name), nil if the player wasn't found
]]
function BossModuleClass:GetGroup(name)
	for i=1, GetNumRaidMembers() do
		local n, _, group =  GetRaidRosterInfo(i)
		if name == n then
			return group, i
		end
	end
end

--[[
Arguments:
	[optional]string - The name of unit to find the unitid for (default: self:GetName())
Returns:
	*string|nil - The unitID if it's found, otherwise nil
Notes:
	*Works for both hostile units and friendly units
]]
--concatenation is very fast, stop using format is stupid places! (*cough* *bigwigs* *cough* *dbm*)
--it's not garbage if we use it
function BossModuleClass:GetUnit(name)
	name = name or self:GetName()
	if name == UnitName("player") then return "player"
	elseif name == UnitName("target") then return "target"
	elseif name == UnitName("focus") then return "focus"
	end
	if UnitInRaid("player") then
		local raidNum = GetNumRaidMembers()
		for i=1, raidNum do
			local unit = "raid"..i
			if UnitName(unit) == name then return unit
			elseif UnitName(unit.."target") == name then return unit.."target"
			end
		end
	else
		local partyNum = GetNumPartyMembers()
		for i=1, partyNum do
			local unit = "party"..i
			if UnitName(unit) == name then return unit
			elseif UnitName(unit.."target") == name then return unit.."target"
			end
		end
	end
end

--[[
Arguments:
	string - The unitID to place the icon on
	number - The icon index to place on the unit (1-8)
	[optional]number - The delay before removing the icon (default: don't remove the icon later)
Notes:
	*Sets an icon on an unitid and then optionally removes it later
]]
do
	local function RaidTargetWrapper(unit)
		SetRaidTarget(unit, 0)
	end
	function BossModuleClass:SetRaidIcon(unit, icon, delay)
		SetRaidTarget(unit, icon)
		if delay then
			return self:ScheduleTimer(RaidTargetWrapper, delay, unit)
		end
	end
end


--[[
Arguments:
	boolean - if true, it will not use a skull in the index
Returns:
	*number - An icon index, rotates through so the same icon isn't re-used
]]
do
	local icon = 0
	function BossModuleClass:GetNextIconIndex(noskull)
		icon = icon + 1
		if icon > 8 or icon == 8 and noskull then
			icon = 1
		end
		return icon
	end
end

--[[
Returns:
	*string - The current time in a very detailed string
]]
function BossModuleClass:GetDetailedTime()
	return ("%s.%3d"):format(date("%H:%M:%S"), (GetTime() % 1) * 1000)
end

--[[
Returns:
	*number|nil - Seconds since the module was started, nil if the module isn't running
]]
function BossModuleClass:GetSecondsFromStart()
	if running[self] then
		return GetTime() - running[self]
	end
end

--[[
Arguments:
	string - Unit to check for buffs
	tuple - Buffs to check for
Returns:
	*boolean - true if the unit has one of the buffs in the tuple, nil if they have none of these buffs.
]]
function BossModuleClass:UnitHasBuff(unit, ...)
	local num = select("#", ...)
	for i=1, 40 do
		local name = UnitBuff(unit, i)
		if not name then return end
		for i=1, num do
			if name == select(i, ...) then
				return true
			end
		end
	end
end

--[[
Arguments:
	string - Unit to check if it is a tank
Returns:
	*boolean - true if the unit is a tank, false if the unit is not a tank
]]
function BossModuleClass:UnitIsTank(unit)
	local _, class = UnitClass(unit)
	if class == "WARRIOR"  then
		return not self:UnitHasBuff(unit, L["Blessing of Salvation"], L["Greater Blessing of Salvation"])
	elseif class == "DRUID" then return UnitPowerType(unit) == 1
	elseif class == "PALADIN" then 
		if not self:UnitHasBuff(unit, L["Blessing of Salvation"], L["Greater Blessing of Salvation"]) and self:UnitHasBuff(unit, L["Righteous Fury"]) then
			return true
		end
		return false
	end
end

--[[=================================================================]]--
--[[=============================Syncing=============================]]--
--[[=================================================================]]--

--[[
Arguments:
	string|number - The command that will be sent to :OnSync
	[optional]tuple - Arguments to send with the sync
Notes:
	*Syncs a message with other modules
	*:OnSync is called with the command and arguments
	*By default, syncing is throttled so that the same sync cannot be received more than 1.5 seconds apart
Example:
	*function module:PeriodicDamage(msg)
	*	local name, are, skill = msg:match("^(%S+) (%S+) afflicted by (.+)%.$")
	*	if name then
	*		if name == "You" and are == "are" then name = player end
	*		if skill == "Grievous Throw" then
	*			self:Sync("GT", name)
	*		end
	*	end
	*end
	*function module:OnSync(msg, name)
	*	if msg == "GT" then
	*		if self:CheckToggle("Grievous Throw") then
	*			self:Announce("High", "Grievous Throw on %s!", name)
	*		end
	*	end
	*end
]]
function BossModuleClass:Sync(command, ...)
	if command then
		Core:SendMessage("Sync", self:GetName(), command, ...)
		self:OnSyncReceive(command, ...)
	end
end

--[[
Notes:
	*Removes all syncs from a module
	*Automatically called when a module is stopped
]]
function BossModuleClass:RemoveAllSyncs()
	if syncs[self] then
		syncs[self] = del(syncs[self])
	end
	if throttles[self] then
		throttles[self] = del(throttles[self])
	end
end

--[[
Arguments:
	tuple - Pairs of strings and numbers, where the string is the sync and the number is the throttle
Notes:
	*Sets sync throttles
	*MUST be called in :OnStart, before any syncing is done, otherwise it will not work
	*By default each sync is throttled at 1.5 seconds
Example:
	*self:SetSyncThrottles("Throw", 3, "Stun", 10)
]]
function BossModuleClass:SetSyncThrottles(...)
	if not throttles[self] then
		throttles[self] = new()
	end
	local t = throttles[self]
	for i=1, select("#", ...), 2 do
		local key, value = select(i, ...)
		t[key] = value
	end
end


--[[=================================================================]]--
--[[=======================Message Handling==========================]]--
--[[=================================================================]]--

--[[
Arguments:
	string - Alert priority, one of "High", "Normal", "Low
	tuple - Strings to be formatted in to the alert
	
Notes:
	*Announces an alert, if the player has raid officer or leader and Announce toggle is true then it'll be sent to the raid, otherwise it's a personal alert
	*Announced alerts are sent to the raid warning channel along with the RBM message
	*The message will automatically be wrapped in '***'
	*The last arguement of tuple can be a spellid to show a spell icon.
Example:
	*self:Announce("High", "Debuff on %s!", player)
]]
function BossModuleClass:Announce(priority, ...)
	if Profile.AlertColors[priority] and ... then
		local s = "*** "..format(...).." ***"
		local icon
		if Profile.ShowIcons then
			if type(select(-1, ...)) == "number" then
				if s:find("%d") then
					if type(select(-2, ...)) == "number" then
						icon = select(-1, ...)
					end
				else
					icon = select(-1, ...)
				end
			end
		end
		if (IsRaidOfficer() or IsRaidLeader()) and self:CheckToggle(L["Announce"]) then
			Core:SendMessage("CoreMethod", "ShowAlert", priority, s)
			Core:SendAlertMessage(s, icon)
		end
		self:Alert(priority, s, icon)
	end
end

--[[
Arguments:
	number - Time to wait until the announce is fired
	tuple - Strings to be formatted in to the alert, the first arg must always be "High", "Normal", or "Low"
Returns:
	table - To be used with :CancelTimer api from AceTimer-3.0
	
Notes:
	*Announces an alert, if the player has raid officer or leader and Announce toggle is true then it'll be sent to the raid, otherwise it's a personal alert
	*Announced alerts are sent to the raid warning channel along with the RBM message
	*The message will automatically be wrapped in '***'
Example:
	*self:ScheduleAnnounce(30, "High", "Debuffs on %s,%s!", player, player2)
]]
local announceTable = {}
--##NODOC - INTERNAL USE ONLY!
function BossModuleClass:ScheduleAnnounceRecieved(args)
	self:Announce(unpack(args))
end

function BossModuleClass:ScheduleAnnounce(time, ...)
	if not time or type(time) ~= "number" then return end
	local alertcheck = select(1, ...)
	if alertcheck ~= "High" and alertcheck ~= "Normal" and alertcheck ~= "Low" then return end
	
	local tnum = #announceTable+1
	announceTable[tnum] = {}

	local i = 1
	while select(i, ...) do
		announceTable[tnum][i] = select(i, ...)
		i=i+1
	end
	
	return self:ScheduleTimer("ScheduleAnnounceRecieved", time, announceTable[tnum])
end

--[[
Notes:
	*Clears the announce table to save ui memory.
]]
function BossModuleClass:ClearAnnounceTable()
	for i in ipairs(announceTable) do
		announceTable[i] = nil
	end
end

--[[
Arguments:
	tuple - Strings to be formatted in to the alert
Notes:
	*Send an alert to the raid channel if the player has raid officer or leader and Announce toggle is true
	*The message should always be wrapped in '***'
Example:
	*self:AlertRaid("*** Debuff on %s! ***", player)
]]
function BossModuleClass:AlertRaid(...)
	if ... then
		if (IsRaidOfficer() or IsRaidLeader()) and self:CheckToggle(L["Announce"]) then
			SendChatMessage(format(...), "RAID")
		end
	end
end
--[[
Arguments:
	string - The name of the player to send the alert to
	tuple - Strings to be formatted in to the alert
Notes:
	*Send an alert to the person if the player has raid officer or leader and Announce toggle is true
	*The message should always be wrapped in '***'
Example:
	*self:AlertPerson(player, "*** YOU ARE THE BOMB! ***")
]]
function BossModuleClass:AlertPerson(person, ...)
	if person and ... then
		if (IsRaidOfficer() or IsRaidLeader()) and self:CheckToggle(L["Announce"]) then
			SendChatMessage(format(...), "WHISPER", nil, person)
		end
	end
end

--[[
Notes:
	*Signifies that the boss encounter of this module is defeated
	*When a module is "dead" it cannot be enabled without first removing the boss death
	*The module will keep track of the reset of the instance the boss belongs to, but some bosses don't have (reliable) timers and will need custom code or manual removal of boss deaths
	*The auto-enable mouseover method will force a boss death to be removed if it mouseovers and the target is alive
	*When a boss death is added the module is automatically disabled and victory sound is played
]]
function BossModuleClass:AddBossDeath()
	local zone
	local rz = GetRealZoneText()
	if self:HasZone(rz) then
		zone = rz
	else
		zone = self:GetDisplayZone()
	end
	RequestRaidInfo()
	AddBossDeathToQueue(self, zone)
	if self:IsRunning() then
		if Profile.PlaySoundOnBossDeath then
			PlaySoundFile[[Interface\Addons\RBM\Sounds\triforce.mp3]]
		end
		self:Announce("High", L["%s has been defeated!"], self:GetName())
	end
	self:Disable()
end

--[[
Notes:
	*Removes a boss death
]]
function BossModuleClass:RemoveBossDeath()
	if self:IsBossDead() then
		if self.db then
			self.db.char._BossDead = nil
			self.db.char._BossDeadZone = nil
		end
		if self:HasZone(GetRealZoneText()) then
			self:Enable()
		end
	end
end
--[[
Returns:
	*boolean - If true if the plugin is a boss mod, false if its a plugin
]]
function BossModuleClass:IsBossMod() return true end
--[[
Returns:
	*number|nil - The instance ID that the dead boss belongs to, nil if the boss isn't dead
]]
function BossModuleClass:GetBossDeadID()
	return self.db and self.db.char._BossDead
end

--[[
Returns:
	*boolean - True if the boss is dead, false if not
]]
function BossModuleClass:IsBossDead()
	return self.db and self.db.char._BossDead ~= nil
end

--[[
Returns:
	*boolean - True if the boss is alive, false if not
]]
function BossModuleClass:IsBossAlive()
	return not self:IsBossDead()
end

--[[
Arguments:
	string - The zone name to check for
Returns:
	*boolean - True if the module is registered with the zone
]]
function BossModuleClass:HasZone(name)
	if name then
		if type(self._Zones) == "table" then
			return self._Zones[name]
		else
			return self._Zones == name
		end	
	end
end

--[[
Arguments:
	tuple - List of zone names that the module belongs to
Notes:
	*Sets the zones this module belongs to
	*Must be called before :OnInitialize
]]
local cache
function BossModuleClass:SetZones(...)
	if select("#", ...) > 1 then
		local joined = (";"):join(...)
		if cache and cache[joined] then
			self._Zones = cache[joined]
		else
			local t = {...}
			for k, v in ipairs(t) do
				t[v] = true
				t[k] = nil
			end
			self._Zones = t
			if not cache then
				cache = {}
			end
			cache[joined] = t
		end
		if not self:GetDisplayZone() then
			self:SetDisplayZone(...)
		end
	else
		self._Zones = ...
		if not self:GetDisplayZone() then
			self:SetDisplayZone(...)
		end
	end
end

--[[
Returns:
	*string - The display zone of the module
]]
function BossModuleClass:GetDisplayZone()
	return self._DisplayZone
end

--[[
Arguments:
	string - The display zone
Notes:
	*The display zone is used in the GUI so that if the module belongs to multiple zones it's not listed many times
	*By default the display zone is the first (or only) string passed into :SetZones
]]
function BossModuleClass:SetDisplayZone(zone)
	if zone then
		self._DisplayZone = zone
	end
end

--[[
Arguments:
	tuple - Strings of events that should potentially wake the module from standby
Notes:
	*If the :CheckStart method is defined, it is called with the first argument the event and the event's arguments as the rest,
	if :CheckStart returns true then the module is started, otherwise the module will continue to be in standby
	*If the :CheckStart method is not defined then it is assumed any registered event, regardless of its arguments, should wake the module
	*Waking the module calls :Start and as such calls :OnStart if its available
]]
function BossModuleClass:RegisterStartEvents(...)
	if select("#", ...) > 1 then
		self._StartEvents = {...}
	else
		self._StartEvents = ...
	end
	
end

--[[
Arguments:
	tuple - Strings of events that should potentially stop the module and cause it to enter standby
Notes:
	*If the :CheckStop method is defined, it is called with the first argument the event and the event's arguments as the rest,
	if :CheckStop returns true then the module is stopped, otherwise the module will continue to run
	*If the :CheckStop method is not defined then it is assumed any registered event, regardless of its arguments, should stop the module
	*Waking the module calls :Stop and as such calls :OnStop if its available
	*
	*Certain special events are always registered as stopping events
	*RAID_LEFT_COMBAT - Triggered when the entire raid has left combat (a wipe or win is assumed)
	*BOSS_DEATH - Triggered when a mob dies that matches the name of the module
	*PLAYER_ENTERING_WORLD - When the player zones, disables the module, doesn't check agaisnt CheckStop
]]
function BossModuleClass:RegisterStopEvents(...)
	if select("#", ...) > 1 then
		self._StopEvents = {...}
	else
		self._StopEvents = ...
	end
end


--[[
Arguments:
	[optional]float[0,1] - The red value of the flash (default: .9)
	[optional]float[0,1] - The green value of the flash (default: .1)
	[optional]float[0,1] - The blue value of the flash (default: .1)
	[optional]tuple - List of English upper-case classes, and/or the name of players in your group (can be mixed) to have their screen shake (default: all classes)
Notes:
	*Use this command sparingly
	*Briefly flashes the screen, ideal for important information
	*Use the class filter to only flash certain class's screens
	*Use the player filter to only flash people affected by an event's screen
	*The player and class filter can be mixed
	*Announced if self:CheckToggle(L["Announce"]) is true, and the player is a raid officer or leader
Example:
	*self:WarningFlash(.7, .7, .7, "PRIEST", "PALADIN") --if a magic debuff needs dispelling
]]
function BossModuleClass:WarningFlash(r, g, b, ...)
	if IsRaidOfficer() or IsRaidLeader() then
		Super.WarningFlash(self, nil, r, g, b, ...)
	end
end

--[[
Arguments:
	[optional]tuple - List of English upper-case classes, and/or the name of players in your group (can be mixed) to have their screen shake (default: all classes and players)
Notes:
	*Use this command sparingly, if the screen is constantly shaking then the importance is lost
	*Briefly shakes the screen, ideal for important information
	*Use the class filter to only shake certain class's screens
	*Use the player filter to only shake people affected by an event's screen
	*The player and class filter can be mixed
	*Announced if self:CheckToggle(L["Announce"]) is true, and the player is a raid officer or leader
Example:
	*self:ShakeScreen("WARRIOR", "ROGUE", "MAGE") --if a spell needs to be interrupted
	*self:ShakeScreen("Someguy", "Anotherguy", "Thirdguy") --if these people need to take action 
	*self:ShakeScreen("Guywiththebomb", "PALADIN", "PRIEST") --Guywiththebomb needs to move and paladins and priests need to dispel him
]]
function BossModuleClass:ShakeScreen(...)
	if IsRaidOfficer() or IsRaidLeader() then
		Super.ShakeScreen(self, nil, ...)
	end
end

--[[
Notes:
	*Use this command sparingly
	*If the screen is constantly shaking then the importance is lost
	*Briefly shakes the player's screen, ideal for important information
]]
function BossModuleClass:ShakePlayerScreen()
	Super.ShakeScreen(self, false)
end

--[[
Arguments:
	[optional]float[0,1] - The red value of the flash (default: .9)
	[optional]float[0,1] - The green value of the flash (default: .1)
	[optional]float[0,1] - The blue value of the flash (default: .1)
Notes:
	*Use this command sparingly
	*If the screen is constantly flashing then the importance is lost.
	*Briefly flashes the player's screen, ideal for important information
]]
function BossModuleClass:WarningFlashPlayer(r, g, b)
	Super.WarningFlash(self, false, r, g, b)
end

--[[
Arguments:
	[optional]tuple - List of English upper-case classes, and/or the name of players in your group (can be mixed) to have their screen shake (default: all classes and players)
	*If tuple is true then alerts player.
Notes:
	*Use this command sparingly.
	*Flashes and Shakes units screen.
Example:
	self:FullPlayerAlert()	-- Flashes and Shakes player screen.
	self:FullPlayerAlert("MAGE", "HUNTER", "Bob") -- Flashes and Shakes All Mages, Hunters, and player Bob's screen.
]]
function BossModuleClass:FullPlayerAlert(...)
	if ... then
		self:ShakeScreen(...)
		self:WarningFlash(nil, nil, nil, ...)
	else
		self:WarningFlashPlayer()
		self:ShakePlayerScreen()
	end
end


--Internal functions, pay no attention to the man behind the curtain
do
	local function GetID(zone, checkzone)
		for i=1, GetNumSavedInstances() do
			local z, id = GetSavedInstanceInfo(i)
			--if z == zone or checkzone and z == checkzone then
			if ((checkzone and z == checkzone) or z == zone) then
				return id
			end
		end
	end
	
	local queue
	local function UpdateBossDeaths()
		if not queue then return end
		for module, zone in pairs(queue) do
			local id = GetID(zone, module.zoneIDName)
			if id then
				module.db.char._BossDead = id
				module.db.char._BossDeadZone = zone
			end
			queue[module] = nil
		end

		for name, module in Core:IterateModules("BossModule") do
			local id = module:GetBossDeadID()
			if id then
				local zone = module.db.char._BossDeadZone
				if not zone or GetID(zone, module.zoneIDName) ~= id then
					module:RemoveBossDeath()
				end
			end
		end
	end
	
	function AddBossDeathToQueue(module, zone)
		if not queue then
			queue = {}
		end
		queue[module] = zone
		UpdateBossDeaths()
	end
	BossModuleClass:RegisterEvent("UPDATE_INSTANCE_INFO", function()
		BossModuleClass:ScheduleTimer(UpdateBossDeaths, 1)
	end)
end


do
	local combatID
	local function CheckRaidCombat()
		if UnitAffectingCombat("player") then
			return
		end
		for i=1, GetNumRaidMembers() do
			if UnitAffectingCombat("raid"..i) then
				return
			end
		end
		BossModuleClass:CancelTimer(combatID, true)
		for module in pairs(running) do
			if type(module.CheckStop) == "function" then
				if module:CheckStop("RAID_LEFT_COMBAT") then
					module:Stop()
				end
			else
				module:Stop()
			end	
		end
	end
	BossModuleClass:RegisterEvent("PLAYER_REGEN_DISABLED", function()
		combatID = BossModuleClass:ScheduleRepeatingTimer(CheckRaidCombat, 1)
	end)	
end

BossModuleClass:RegisterEvent("UPDATE_MOUSEOVER_UNIT", function()
	if Profile.ActivateModulesMouseover then
		local unit = UnitName("mouseover")
		local module = Core:GetModule("BossModule", unit)
		
		if not module and bossNameLst and bossNameLst[unit] then
			module = Core:GetModule("BossModule", bossNameLst[unit])
		end
		if not module then return end
		
		local isDead = (unit == module:GetName() or unit == module.DeathName or unit == module.DeathName2 or unit == module.StartName) and UnitIsDead("mouseover")
		local isStart = unit == module.StartName and not UnitIsDead(unit)
		if UnitCanAttack("player", "mouseover") or UnitIsEnemy("player", "mouseover") then
			if (not isDead or isStart) then
				if module:IsBossDead() then
					module:RemoveBossDeath()
				end
				module:Enable()
			else
				if not module:IsBossDead() then
					if module.DualDeaths then
						if not module.DeathLst then
							module.DeathLst = {}
						end
						module.DeathLst[unit] = true
						if not module.DeathLst[module.DeathName] or not module.DeathLst[module.DeathName2] then 
							return 
						end
					end
					module:AddBossDeath()
				end
			end
		end
	end
end)

BossModuleClass:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED", function(_, _, event, _, _, _, _, name) --TODO: Optimize for 2.4
	if event == "UNIT_DIED" then
		for module in pairs(running) do
			if name == module:GetName() or name == module.DeathName or name == module.DeathName2 then
				if module.DualDeaths then
					if not module.DeathLst then
						module.DeathLst = {}
					end
					module.DeathLst[name] = true
					if not module.DeathLst[module.DeathName] or not module.DeathLst[module.DeathName2] then return end
				end
				if type(module.CheckStop) ~= "function" or module:CheckStop("BOSS_DEATH") then
					module:AddBossDeath()
				end
				Core:DistanceFrameRemove()
				Core:HealthFrameRemove()
			end
		end
	end
end)

BossModuleClass:RegisterEvent("PLAYER_ENTERING_WORLD", function() --zone switch
	for module in pairs(running) do
		module:Stop()
	end
end)

do
	local BZ = LibStub("LibBabble-Zone-3.0"):GetReverseLookupTable()
	local function LodCheck()
		local rz = GetRealZoneText()
		if rz == nil or rz == "" then
			return
		end
		for i=1, GetNumAddOns() do
			if IsAddOnLoadOnDemand(i) and not IsAddOnLoaded(i) then
				local enabled, loadable = select(4, GetAddOnInfo(i))
				local zones = GetAddOnMetadata(i, "X-RBMLoadIn")
				if zones and enabled and loadable then
					if zones:match(BZ[rz]) and IsAddOnLoaded("RBM") and isLoaded then
						LoadAddOn(i)
					end
				end
			end
		end
		if Profile and Profile.ActivateModulesZone then
			for name, module in Core:IterateModules("BossModule") do
				if module:HasZone(rz) then
					module:Enable()
				end
			end
		end
	end
	BossModuleClass:RegisterEvent("ZONE_CHANGED_NEW_AREA", LodCheck)
	BossModuleClass:RegisterEvent("PLAYER_LOGIN", LodCheck)
end


--internal function, do not overwrite! use :OnSync(...)
--#NODOC
function BossModuleClass:OnSyncReceive(cmd, ...)
	if not syncs[self] then
		syncs[self] = new()
	end
	local time = syncs[self][cmd]
	local now = GetTime()
	if not time or time < now then
		syncs[self][cmd] = now + (throttles[self] and throttles[self][cmd] or 1.5)
		self:OnSync(cmd, ...)
	end
end
isLoaded = true