-- module:RegisterCommonTranslations() - will be available to all plugins/bossmods
-- module:RegisterBossTranslations() - will be available to all boss mods (this is RegisterCommonTranslations() for boss mods!  boss mods DO NOT CALL!)
-- module:RegisterTranslations() - Will only be available to that module
-- module:GetTranslations([boolean]) - if true will return Boss Module and Common-BossModule Translations otherwise just Common Translations

local WelcomeScreenIntro = 
"|cffFFCC11Welcome|r to |cffEE0000RBM|r, this window provides a brief description and an easy way to create two simple frames to get you started with |cffEE0000RBM|r.\n\n\n" ..
"|cff00FFFFSimply close this window if you don't wish to use this guide.|r\n\n" ..
"|cffFFCC11Frames:|r\n\nIn |cffEE0000RBM|r, a frame holds bars used to quickly display information to you. What type of information is allowed on your frames is entirely up to you. " ..
"You may have an infinite number of frames to organize your information, or a single frame if you'd like them all in one spot. " .. 
"It's even possible, in |cffEE0000RBM|r, to set your information to switch frames of your choosing, or emphasize the information as it becomes more or less important to you. " ..
"\n\n" ..
"|cffFFCC11Let's get started:|r\n\nBy clicking the button below you'll create two frames. One titled |cff6B8E23'Short Bars'|r and another titled |cffEE4000'Long Bars'|r in the center of your screen. " ..
"This window will then close (it can later be opened in the options menu) and allow you to reposition your frames. Simply |cffEE1100right-click|r on a frame to bring up its options. " ..
"|cffEE1100Left-click|r and drag to move your frame around, you'll notice that the frame gets larger when you do so, this is because the dynamic resize option is enabled by default " ..
"so that the frames take up the smallest amount of space possible. Bars over 10 seconds will only be shown on the |cffEE4000'Long Bars'|r frame, and eventually, " ..
"when they go under 10 seconds left they will transfer to the |cff6B8E23'Short Bars'|r frame."

local UpgradeFromMsg = "|cffFFCC11Upgrading From: "
local UpgradeMsgMsg = "|cffff3355Upgrading Will Cause You To Reload Your UI!|r"
RBM:RegisterTranslations("enUS",
	"Welcome screen intro", WelcomeScreenIntro,
	"UpgradeFrom", UpgradeFromMsg,
	"UpgradeMsg", UpgradeMsgMsg,
	"Upgrade Now!", true,
	"RBM Upgrade", true,
	"RBM Config could not be loaded because it is disabled.", true,
	"RBM Config could not be loaded because of an unknown error code.", true,
	"RBM Config could not be loaded because it is missing.", true,
	"RBM Config Not Loaded", true,
	"To: ", true,
	"Short Bars", true,
	"Long Bars", true,
	"Get me started with default frames!", true,
	"Welcome to RBM", true,
	"%s dies.", true, --<mob name>
	"RBM Frames", true,
	"RBM Bars", true,
	"Boss Abilities", true,
	"None", true,
	"%q is %s of %s in, with %s remaining (%d%%)", true, --<bar label><current time><end time><remaining time><percent left>
	"%q is %d of %d, with %d remaining", true, --<bar label><current count><max count><remaining count>
	"%q is a timeless bar", true, --<bar label>
	"RBM Config could not be loaded because it is disabled.", true,
	"RBM Config could not be loaded because it is missing.", true,
	"RBM Config could not be loaded because of an unknown error code.", true,
	"The full configuration menu could not be loaded.", true,
	"Config not loaded", true,
	"Running", true,
	"Dead", true,
	"Monitoring", true,
	"Inactive", true,
	"Clear boss death", true,
	"Clears the boss death of this module, a module cannot be enabled unless its boss is flagged as alive.", true,
	"RBM - v%s", true, --<version>
	"Right-click|r to open the options menu", true,
	"You're upgrading from an older version of RBM, it is highly recommended that you reset your database. Do so now?", true,
	"Messages", true,
	"Test", true,
	"Force Stop", true,
	"Force Start", true,
	"{Skull}", true, -- Skull Icon used in raid warnings
	"secs", true,	-- seconds
	"min", true,	-- minutes
	"hr", true,		-- hours
	"days", true,	-- days
	"wks", true		-- weeks
)

-- Buffs
RBM:RegisterTranslations("enUS",
	"Blessing of Salvation", true,
	"Blessing of Protection", true,
	"Greater Blessing of Salvation", true,
	"Divine Shield", true,
	"Righteous Fury", true,
	"Power Word: Shield", true,
	"Frost Ward", true,
	"Fel Blossom", true,
	"Heavy Netherweave Bandage", true, -- figured i'd put this here
	"Error while setting the proximity frame to 15 yards. You must have a Heavy Netherweave Bandage with you.", true
)
RBM:RegisterCommonTranslations("enUS",
	"You", true,
	"are", true,
	"Are you sure?", true,
	"Boss Abilities", true,
	"Announce", true,
	"A frame with a checkmark indicates that categories will be sent to that frame. If a frame has the 'Filter by category' option disabled then bars will always be sent to that frame.", true,
	"Frames", true,
	"Close", true,
	"Enabled", true,
	"Configures this module.", true,
	"Controls the active state of this module.", true,
	"Blade's Edge Arena", true,
	"Nagrand Arena", true,
	"Ruins of Lordaeron", true
)
if not BigWigs then
	RBM:RegisterTranslations("enUS",	-- these are used inside the ModuleClass/Boss.lua file, which means they belong
		"%s has been engaged!", true,	-- to RBM-Core instead of the boss module itself.
		"%s has been defeated!", true,	
		"Enrage", true,
		"Enraged!", true,
		"Enrage: %d secs", true,
		"Enrage: %d min", true,
		"Berserk", true,
		"Berserked!", true,
		"Berserk: %d secs", true,
		"Berserk: %d min", true
	)
	
	RBM:RegisterBossTranslations("enUS", -- general words that are commonly used
		"The Sunwell", true,	-- needed sorry :(
		"The Battle for Mount Hyjal", true, -- needed too, sorry :(
		"Enrage", true,
		"Enraged!", true,
		"Berserk", true,
		"Berserked!", true,
		"Frenzy", true,

		"Proximity Frame", true,
		
		"Heal", true,
		"Heals", true,
		"Flash on Heals", true,
		
		"Health", true,
		"Health Bars", true,
		"Health Frame", true,
		
		"Curse", true,
		"Flash on Decurse", true,
		
		"Dispel", true,
		"Flash on Dispel", true,
		
		"Groups", true,
		"Icon Groups", true,
		
		"Phase", true,
		"Phases", true,

		"Tank", true,
		"DPS", true,
		
		"Dispell", true,
		"Dispell Now", true,
		
		"Icon", true,
		
		"Soon", true,
		"Incoming", true,
		
		"Form", true,
		"Demon Form", true,
		"Normal Form", true,

		"Normal Phase", true,
		"Demon Phase", true,
		
		"Normal", true,
		"Demon", true,

		"Spellsteal!", true
	)
	RBM:RegisterBossTranslations("enUS", -- strings used in labels and announces
		"You have %s!", true,
		"Phase: %d", true,
		"Phase: %d - %s", true, -- "Phase: 2 - Meteors"
		"Phase: %d ~%d seconds", true,
		"Next %s", true,
		"Next %s: ~%d seconds", true,
		"Icon %s Targets", true,
		"Icon %s Targets (Will only use Skull)", true,
		"Icon %s Targets (Will not use Skull)", true,
		"I have %s!", true,
		"Say when %s", true,
		"Group: %d", true,
		"Enrage: %d secs", true,
		"Enrage: %d min", true,
		"Berserk: %d secs", true,
		"Berserk: %d min", true,
		"%s Active", true,
		"%s Casting", true,
		"%s Casting: %s", true,
		"%s Casting %s On: {%s}", true,
		"%s Soon", true,
		"%s Incoming", true,
		"%s Dispelled", true,
		"%s Removed", true,
		"%s Ended", true,
		"%s Ending Soon", true,
		"%s Ending: ~%d secs", true,
		"%s Over", true,
		"%s Over Soon", true,
		"%s Over: ~%d secs", true,
		"%s: ~%d Seconds", true,
		"%s: ~%d Minutes", true,
		"%s: %s", true, -- used for npcs
		"%s: {%s}", true,	-- used for players
		"%s: {%s}!", true,
		"%s on YOU!", true,
		"%s on: {%s}", true,
		"%s on: {%s}!", true,
		"%s stolen by: {%s}", true,
		"%s dispelled by: {%s}", true,
		"%s reflected by: {%s}", true,
		"%s interrupted by: {%s}", true,
		"%s resisted %s", true,
		"{%s} resisted %s", true,
		"{%s} removed %s", true
	)
end
if false then	-- dont use these anymore yo!
	-- boss stuff
	RBM_HEAVY_NW_BANDAGE = "Heavy Netherweave Bandage"
	RBM_HEAVY_NW_BANDAGE_MISSING	= "Error while setting the range check frame to 15 yards. You must have a Heavy Netherweave Bandage with you."

	RBM_RANGE_CHECK_FRAME = "Range Check Frame"
	RBM_HEALTH_FRAME = "Low Health Frame"

	RBM_COOLDOWN = "Cooldown"
	RBM_HEALTH = "Health"
	RBM_ANNOUNCE = "Announce"
	RBM_ICON = "Icon"
	RBM_ENRAGE = "Enrage"
	RBM_ENRAGED = "Enraged!"
	RBM_BERSERK = "Berksek"
	RBM_BERSERKED = "Berserked!"
	RBM_REFLECTED = "Reflected"
	RBM_SAY = "Say"
	RBM_FLASH_DECURSE = "Flash on Decurse"

	RBM_MINUTE = "Minute"
	RBM_MINUTES = "Minutes"

	RBM_SECOND = "Second"
	RBM_SECONDS = "Seconds"

	RBM_YOU = "You"
	RBM_ARE = "are"

	RBM_NEXT = "Next"
	RBM_GROUP = "Group"
	RBM_GROUPS = "Groups"
	RBM_TEAMS = "Teams"
	RBM_TEAM = "Team"

	RBM_PHASE = "Phase"
	RBM_PHASEMSG = "Phase: %d"
	RBM_PHASES = "Phases"

	RBM_NORMAL = "Normal"
	RBM_DEMON = "Demon"
	RBM_FORM = "Form"
	RBM_ENDED = "Ended"
	RBM_KITE = "Kite"
	RBM_TANK = "Tank"
	RBM_TARGET = "Target"
	RBM_NEW = "New"
	RBM_OVER = "Over"
	RBM_SILENCE = "Silence"
	RBM_PLAYERBARS = "Player Bars"

	RBM_INCOMING = "Incoming"
	RBM_SOON = "Soon"

	RBM_CASTING = "Casting"
	RBM_RESISTED = "Resisted"

	RBM_SPELL_PWS = "Power Word: Shield"
	RBM_SPELL_FW = "Frost Ward"
	RBM_SPELL_FB = "Fel Blossom"
	RBM_SPELL_DS = "Divine Shield"
	RBM_CURSE = "Curse"
	RBM_PING = "Ping"
	RBM_FRENZY = "Frenzy"
	RBM_HEAL = "Heal"
	RBM_FLASH_ON_HEAL = "Flash on Heal"
	RBM_FLASH_ON_DISPEL = "Flash on Dispel"
	RBM_HEALS = "Heals"
	RBM_TOTEMS = "Totems"
	RBM_TOTEM = "Totem"
	RBM_STOLENBY = "Stolen By: %s"
	RBM_DISPELLED = "Dispelled"
	RBM_REMOVED = "Removed"
	RBM_YOUHAVE = "You have " -- notice the space
end