local Frame = {
	profile = {
		Backdrop = {bgFile="Blizzard Tooltip", edgeFile="RothSquare",edgeSize=16, tileSize=16, tile=true, insets={left=0, right=0, top=0, bottom=0}},
		BackdropColor = {r = 0, g = 0, b = 0, a = 1},
		BackdropBorderColor = {r = .5, g = .5, b = .5, a = .9},
		Visible = true,

		KeepAnchorPoints = true,
		MergeWithExisting = true,
		SaveFilters = true,

		EnableMouse = true,
		FrameAnchor = "BOTTOM",
		Spacing = 0,

		Alpha = 1,

		Height = 300,
		Width = 250,

		DynamicResize = true,
		HideWhenEmpty = false,
		TransferCountBars = false,
		Locked = false,
		TestIgnoresFilter = true,

		SortBars = true,
		SortBarsMethod = "Time Total Length",
		SortBarsOrder = "Up",

		TransferBelowByPercent = false,
		TransferBelowPercent = .1,
		TransferBelowTo = "",
		TransferBelowByTime = false,
		TransferBelowTime = 10,
		TransferBelowAnimate = "CurveUpPower",
		TransferBelowRate = .15,

		TransferAboveByPercent = false,
		TransferAbovePercent = .9,
		TransferAboveTo = "",
		TransferAboveByTime = false,
		TransferAboveTime = 300,
		TransferAboveAnimate = "CurveDownPower",
		TransferAboveRate = .15,

		BlinkByPercent = true,
		BlinkPercent = .1,
		BlinkByTime = true,
		BlinkTime = 10,

		PulseByPercent = false,
		PulsePercent = .1,
		PulseByTime = false,
		PulseTime = 10,

		FadeWhenComplete = true,
		FadeComplete = 10,

		UseCustomLabels = true,
		CustomLabels = {
			["*"] = {
				Filtered = false,
				CustomSound = false,
				CustomSoundToPlay = "Kachink",
				Exception = false,
				CustomColor = false,
				ColorR = 1,
				ColorG = 1,
				ColorB = 1,
				Partial = false,
			},
		},

		SoundByPercent = {
			["*"] = {
				["*"] = false,
			},
		},
		SoundPercent = {
			["*"] = {
				["*"] = .1,
			},
		},
		SoundByTime = {
			["*"] = {
				["*"] = false,
			},
		},
		SoundTime = {
			["*"] = {
				["*"] = 10,
			},
		},
		SoundToPlay = {
			["*"] = {
				["*"] = "Kachink",
			},
		},

		ShowTitle = true,

		Categories = true,
		CategoriesList = {
			["Boss Abilities"] = {
				Cast = true,
				Cooldown = true,
				Buff = true,
				Debuff = true,
				Timeless = true,
				Count = true,
			},
			["*"] = {
				["*"] = true,
			},
		},

		ByMaxLength = false,
		ByMinLength = false,
		MinLength = 10,
		MaxLength = 300,

		BarBackdrop = {bgFile="Blizzard Tooltip", edgeFile="RothSquare",edgeSize=5, tileSize=16, tile=true, insets={left=0, right=0, top=0, bottom=0}},
		BarBackdropColor = {r = 0, g = 0, b = 0, a = 1},
		BarBackdropBorderColor = {r = 1, g = 1, b = 1, a = .9},

		BarWidth = .95,
		BarHeight = 20,
		NormalizeTime = 0,
		CustomTimeMessage = "<label> is <curtimetrue>/<maxtime> with <remaintime> left.",
		CustomCountMessage = "<label> is <count>/<maxcount>(<remaincount>)",

		SparkTexture = "Blizzard",
		SparkVisible = true,
		SparkBlend = "ADD",
		SparkWidth = 1,
		SparkHeight = 1.2,
		SparkColor = {r = 1, g = 1, b = 1, a = 1},

		TimerFont = "Friz Quadrata TT",
		TimerFontSize = 9,
		TimerAdjust = -3,
		TimerJustifyH = "RIGHT",
		TimerJustifyV = "CENTER",
		TimerColor = {r = 1, g = 1, b = 1, a = 1},
		TimerFormat = 1,

		LabelFont = "Arial Narrow",
		LabelFontSize = 12,
		LabelAdjust = 2,
		LabelJustifyH = "LEFT",
		LabelJustifyV = "CENTER",
		LabelColor = {r = 1, g = 1, b = 1, a = 1},
		LabelUseShadowColor = false,
		LabelShadowColor = {r = 0, g = 0, b = 0, a = 0},
		LabelShadowOffsetX = 0,
		LabelShadowOffsetY = 0,
		LabelOutline = "",

		StatusTexture = "Cloud",
		StatusLeftSpacing = 2,
		StatusRightSpacing = 2,
		StatusTopSpacing = 2,
		StatusBottomSpacing = 2,
		StatusBarDirection = "default",
		ShowTextureBars = false,

		IconLocation = "LEFT",
		IconVisible = true,
		IconColorUsed = false,
		IconWidth = 0,
		IconHeight = 0,
		IconOffsetY = 0,
		IconOffsetX = 0,
		IconColor = { r = 0, g = 0, b = 0, a = 0 },
	},
}

RBM.FunctionEnviroment.FrameDefaults = Frame

function RBM:InitializeDB()
	local db = LibStub("AceDB-3.0"):New("RBM2_DB", {
		profile = {
			AllowAnySender = true,
			ActivateModulesZone = true,
			ActivateModulesMouseover = true,
			TooltipSameZone = true,
			FrameRightClick = "ShowMenu",
			FrameControlRightClick = "TestBar",
			FrameShiftRightClick = "CancelAll",
			
			AllowScreenShake = true,
			ShakeDuration = .15,
			ShakeIntensity = 10,

			AllowFlashFrame = true,
			FlashDuration = .6,

			BarLeftClick = "Cancel",
			BarRightClick = "ShowMenu",
			BarMiddleClick = "Pause",

			PlaySoundOnBossDeath = true,
			UseSkull = true,
			SendRaidWarnings = true,
			SendChatWarnings = true,
			UseClassColors = true,
			AlertIconSize = 15,
			sinkOptions = {
				sink20OutputSink = "Default",
			},
			DistancePos = {
				set = false,
				x = 0,
				y = 0,
				anchor = "none",
			},
			HealthPos = {
				set = false,
				x = 0,
				y = 0,
				anchor = "none",
			},
			MsgFrame = {
				MsgWidth = 512,
				MsgHeight = 100,
				MsgJustify = "CENTER",
				MsgFontSize = 12,
				TimeVis = 2,
				FadeDur = 2,
				MsgUseShadowColor = false,
				MsgShadowColor = {
					r = 0,
					g = 0,
					b = 0,
					a = 0,
				},
				MsgShadowOffsetX = 0,
				MsgShadowOffsetY = 0,
				MsgOutline = "",
			},
			SavedFrames = {},

			ModuleStates = {},

			ColorTables = {
				["Boss Abilities"] = {
					Cast = {r = .5, b = .8, g = .8},
					Cooldown = {r = .2, b = .2, g = .8},
					Buff = {r = .2, b = .8, g = .2},
					Debuff = {r = .8, b = .5, g = .8},
					Timeless = {r = .8, b = .2, g = .2},
					Count = {r = .8, b = .2, g = .9},
				},
			},

			ShowAlerts = true,
			AlertColors = {
				High = {r = 1, g = .3, b = .3},
				Normal = {r = 1, g = .2, b = 1},
				Low = {r = .3, g = 1, b = 1},
			},
		},
		global = {
			Enabled = true,
			FirstRun = true,
			ThemeList = {},
		},
	})
	local function DatabaseCallback(event)
		--HACK: AceDB-3.0 calls callbacks before updating namespaces, thus the wrong settings are applied. This waits until the next frame to update
		self:ScheduleTimer(self.OnProfileChanged, 0, self)
	end
	db:RegisterCallback("OnProfileChanged", DatabaseCallback)
	db:RegisterCallback("OnProfileReset", DatabaseCallback)
	db:RegisterCallback("OnProfileCopied", DatabaseCallback)
	self.db = db
	return db
end