if not RBM then return end
local playerClass = select(2, UnitClass("player"))
local playerName = UnitName("player")

local UnitDebuff = UnitDebuff
local UnitBuff = UnitBuff
local GetItemCount = GetItemCount
local pairs = pairs
local setmetatable = setmetatable
local UnitName = UnitName
local BS
local module = RBM:NewPlugin("De|Buff Watch", "AceBucket-3.0")

if GetLocale() ~= "enUS" then
	for name, _ in LibStub:IterateLibraries() do
		if name == "LibBabble-Spell-3.0" then
			BS = LibStub("LibBabble-Spell-3.0", true):GetLookupTable()
			RBM:print("De|Buff Watch: Using LibBabble-Spell-3.0")
			break
		end
	end
end
if not BS then
	BS = setmetatable({}, {__index =
		function(self, key)
			self[key] = key
			return key
		end
	})
end

local L = module:GetTranslations()

module:RegisterTranslations("enUS", -- translation automatically generated
	"Buff", true,
	"Buffs", true,
	"Buffs that heal over time to keep track of.", true,
	"Buffs that heal over time.", true,
	"Debuff", true,
	"Debuffs", true,
	"Debuffs that deal damage over time to keep track of.", true,
	"Debuffs that deal damage over time.", true,
	"Debuffs that disorient to keep track of.", true,
	"Debuffs that stun to keep track of.", true,
	"Debuffs to keep track of regardless if you cast them or not.", true,
	"Disorient", true,
	"Disorientating debuffs.", true,
	"Disorients", true,
	"DoTs", true,
	"DOT", true,
	"General", true,
	"General Settings", true,
	"Color By Type", true,
	"Automatically color the bars based off of spell type\r(only works for debuffs)", true,
	"Update Speed", true,
	"0 = Fastest, 10 = Slowest\rDefault: 0.2", true,
	"Timeless options", true,
	"Timeless Debuffs", true,
	"Timeless Buffs", true,
	"Buffs to keep track of regardless if you cast them or not.",  true,
	"General buffs to keep track of.", true,
	"General buffs.", true,
	"General debuffs to keep track of.", true,
	"General debuffs.", true,
	"General debuffs(will always show if on target, regardless if you cast it or not)", true,
	"HOT", true,
	"HoTs", true,
	"Party: Party member's auras", true,
	"Player: Auras on yourself", true,
	"Raid: Raid member's auras", true,
	"Recently Bandaged", true,
	"Focus: Auras on your focus target", true,
	"Target: Auras on your target", true,
	"Pet: Auras on your pet", true,
	"Stun", true,
	"Stunning debuffs.", true,
	"Stuns", true,
	"Timeless", true,
	"Track units", true,
	"Units with a checkmark will have their debuffs/buffs watched.", true,
	"Update All Units On Target Change.", true,
	"Track hidden cooldowns", true,
	"Tracks hidden cooldowns on items such as Scarab of the Infinite Cycle or Hourglass of the Unraveller.", true,
	"Update All Units", true,
	"Updates all units when you change targets", true,
	"Friendly", true,
	"Friendly options", true,
	"Hostile", true,
	"Hostile options", true,
	"Sticky Bars", true,
	"Keeps all bars up even when you change targets.", true,
	"Trim Names", true,
	"Trims targets names.\r0 = Untrimmed\r-1 = Abbreviated", true,
	"Trim Auras", true,
	"Trims aura names.\r0 = Untrimmed\r-1 = Abbreviated", true,
	"Hide Buff Names", true,
	"Hide Debuff Names", true,
	"Removes the targets name from buff bars.", true,
	"Removes the targets name from debuff bars.", true
)

module:RegisterTranslations("zhCN", -- translation automatically generated
	"Buff", "增益",
	"Buffs", "增益",
	"Buffs that heal over time to keep track of.", "追踪HOT增益",
	"Buffs that heal over time.", "HOT增益",
	"Debuff", "减益",
	"Debuffs", "减益",
	"Debuffs that deal damage over time to keep track of.", "追踪DOT减益",
	"Debuffs that deal damage over time.", "DOT减益",
	"Debuffs that disorient to keep track of.", "追踪迷惑debuff",
	"Debuffs that stun to keep track of.", "追踪昏迷debuff",
	"Debuffs to keep track of regardless if you cast them or not.", "不论你是否施放都追踪这些debuff",
	"Disorient", "迷惑",
	"Disorientating debuffs.", "迷惑debuff",
	"Disorients", "迷惑",
	"DoTs", "DOT",
	"DOT", "DOT",
	"General", "综合",
	"General Settings", "综合设置",
	"Color By Type", "按类型着色",
	"Automatically color the bars based off of spell type\r(only works for debuffs)", "自动按照法术类型对计时条着色\r（仅对debuff有效）",
	"Update Speed", "更新速度",
	"0 = Fastest, 10 = Slowest\rDefault: 0.2", "0 = 最快，10 = 最慢\r默认值：0.2",
	"Timeless options", "短时间选项",
	"Timeless Debuffs", "短时间debuff",
	"Timeless Buffs", "短时间buff",
	"Buffs to keep track of regardless if you cast them or not.",  "不论是否施放都追踪的buff",
	"General buffs to keep track of.", "追踪综合buff",
	"General buffs.", "综合buff",
	"General debuffs to keep track of.", "追踪综合debuff",
	"General debuffs.", "综合debuff",
	"General debuffs(will always show if on target, regardless if you cast it or not)", "综合debuff（如果存在于你的目标身上就一直显示，不管你是否施放）",
	"HOT", "HOT",
	"HoTs", "HOT",
	"Party: Party member's auras", "小队：小队成员的效果",
	"Player: Auras on yourself", "玩家：自身效果",
	"Raid: Raid member's auras", "团队：团队成员效果",
	"Recently Bandaged", "新近包扎",
	"Focus: Auras on your focus target", "焦点：焦点目标的效果",
	"Target: Auras on your target", "目标：目标身上的效果",
	"Pet: Auras on your pet", "宠物：宠物身上的效果",
	"Stun", "昏迷",
	"Stunning debuffs.", "昏迷debuff",
	"Stuns", "昏迷",
	"Timeless", "短时间",
	"Track units", "追踪单位",
	"Units with a checkmark will have their debuffs/buffs watched.", "监视勾选单位的debuff/buff。",
	"Update All Units On Target Change.", "切换目标时刷新所有单位。",
	"Track hidden cooldowns", "追踪隐藏冷却",
	"Tracks hidden cooldowns on items such as Scarab of the Infinite Cycle or Hourglass of the Unraveller.", "追踪物品的隐藏冷却，例如无尽循环甲虫或分解者的沙漏。",
	"Update All Units", "刷新所有单位",
	"Updates all units when you change targets", "切换目标时刷新所有单位。",
	"Friendly", "友方",
	"Friendly options", "友方单位选项",
	"Hostile", "敌对",
	"Hostile options", "敌对单位选项",
	"Sticky Bars", "粘附计时条",
	"Keeps all bars up even when you change targets.", "即使切换目标也保持计时条",
	"Trim Names", "缩短姓名",
	"Trims targets names.\r0 = Untrimmed\r-1 = Abbreviated", "缩短目标名字。\r0 = 不缩短\r-1 = 缩短",
	"Trim Auras", "缩短效果名",
	"Trims aura names.\r0 = Untrimmed\r-1 = Abbreviated", "缩短效果名字。\r0 = 不缩短\r-1 = 缩短",
	"Hide Buff Names", "隐藏buff名",
	"Hide Debuff Names", "隐藏debuff名",
	"Removes the targets name from buff bars.", "将目标名字从buff条上移除",
	"Removes the targets name from debuff bars.", "将目标名字从debuff条上移除"
)

module:RegisterTranslations("zhTW", -- translation automatically generated
	"Buff", "增益",
	"Buffs", "增益",
	"Buffs that heal over time to keep track of.", "追蹤HOT增益",
	"Buffs that heal over time.", "HOT增益",
	"Debuff", "減益",
	"Debuffs", "減益",
	"Debuffs that deal damage over time to keep track of.", "追蹤DOT減益",
	"Debuffs that deal damage over time.", "DOT減益",
	"Debuffs that disorient to keep track of.", "追蹤迷惑debuff",
	"Debuffs that stun to keep track of.", "追蹤昏迷debuff",
	"Debuffs to keep track of regardless if you cast them or not.", "不論你是否施放都追蹤這些debuff",
	"Disorient", "迷惑",
	"Disorientating debuffs.", "迷惑debuff",
	"Disorients", "迷惑",
	"DoTs", "DOT",
	"DOT", "DOT",
	"General", "綜合",
	"General Settings", "綜合設置",
	"Color By Type", "按類型著色",
	"Automatically color the bars based off of spell type\r(only works for debuffs)", "自動按照法術類型對計時條著色\r（僅對debuff有效）",
	"Update Speed", "更新速度",
	"0 = Fastest, 10 = Slowest\rDefault: 0.2", "0 = 最快，10 = 最慢\r預設值：0.2",
	"Timeless options", "短時間選項",
	"Timeless Debuffs", "短時間debuff",
	"Timeless Buffs", "短時間buff",
	"Buffs to keep track of regardless if you cast them or not.",  "不論是否施放都追蹤的buff",
	"General buffs to keep track of.", "追蹤綜合buff",
	"General buffs.", "綜合buff",
	"General debuffs to keep track of.", "追蹤綜合debuff",
	"General debuffs.", "綜合debuff",
	"General debuffs(will always show if on target, regardless if you cast it or not)", "綜合debuff（如果存在於你的目標身上就一直顯示，不管你是否施放）",
	"HOT", "HOT",
	"HoTs", "HOT",
	"Party: Party member's auras", "小隊：小隊成員的效果",
	"Player: Auras on yourself", "玩家：自身效果",
	"Raid: Raid member's auras", "團隊：團隊成員效果",
	"Recently Bandaged", "新近包紮",
	"Focus: Auras on your focus target", "監控：監控目標的效果",
	"Target: Auras on your target", "目標：目標身上的效果",
	"Pet: Auras on your pet", "寵物：寵物身上的效果",
	"Stun", "昏迷",
	"Stunning debuffs.", "昏迷debuff",
	"Stuns", "昏迷",
	"Timeless", "短時間",
	"Track units", "追蹤單位",
	"Units with a checkmark will have their debuffs/buffs watched.", "監視勾選單位的debuff/buff。",
	"Update All Units On Target Change.", "切換目標時刷新所有單位。",
	"Track hidden cooldowns", "追蹤隱藏冷卻",
	"Tracks hidden cooldowns on items such as Scarab of the Infinite Cycle or Hourglass of the Unraveller.", "追蹤物品的隱藏冷卻，例如無盡迴圈寶石或破壞者沙漏。",
	"Update All Units", "刷新所有單位",
	"Updates all units when you change targets", "切換目標時刷新所有單位。",
	"Friendly", "友方",
	"Friendly options", "友方單位選項",
	"Hostile", "敵對",
	"Hostile options", "敵對單位選項",
	"Sticky Bars", "粘附計時條",
	"Keeps all bars up even when you change targets.", "即使切換目標也保持計時條",
	"Trim Names", "縮短姓名",
	"Trims targets names.\r0 = Untrimmed\r-1 = Abbreviated", "縮短目標名字。\r0 = 不縮短\r-1 = 縮短",
	"Trim Auras", "縮短效果名",
	"Trims aura names.\r0 = Untrimmed\r-1 = Abbreviated", "縮短效果名字。\r0 = 不縮短\r-1 = 縮短",
	"Hide Buff Names", "隱藏buff名稱",
	"Hide Debuff Names", "隱藏debuff名稱",
	"Removes the targets name from buff bars.", "將目標名字從buff條上移除",
	"Removes the targets name from debuff bars.", "將目標名字從debuff條上移除"
)

module:RegisterTranslations("koKR",
	"Buff", "버프",
	"Buffs", "버프",
	"Buffs that heal over time to keep track of.", "추적할 수 있는 지속되는 치유 버프입니다.",
	"Buffs that heal over time.", "지속되는 치유 버프입니다.",
	"Debuff", "디버프",
	"Debuffs", "디버프",
	"Debuffs that deal damage over time to keep track of.", "추적할 수 있는 지속되는 치유 디버프입니다.",
	"Debuffs that deal damage over time.", "지속되는 치유 디버프입니다.",
	"Debuffs that disorient to keep track of.", "추적할 수 있는 방향 감각 상실 디버프입니다.",
	"Debuffs that stun to keep track of.", "추적할 수 있는 기절 디버프입니다.",
	"Debuffs to keep track of regardless if you cast them or not.", "해제가능 여부에 상관없이 디버프를 추적합니다.",
	"Disorient", "방향 감각 상실",
	"Disorientating debuffs.", "방향 감각 상실 디버프",
	"Disorients", "방향 감각 상실",
	"DoTs", "지속 피해",
	"DOT", "지속 피해",
	"General", "일반",
	"General Settings", "일반 설정",
	"Color By Type", "유형별 색상",
	"Automatically color the bars based off of spell type\r(only works for debuffs)", "자동적으로 주문 유형에 따른 바 색상\r(오직 디버프에만 적용)",
	"Update Speed", "업데이트 속도",
	"0 = Fastest, 10 = Slowest\rDefault: 0.2", "0 = 빠름, 10 = 느림\r초기값: 0.2",
	"Timeless options", "지속 옵션",
	"Timeless Debuffs", "지속 디버프",
	"Timeless Buffs", "지속 버프",
	"Buffs to keep track of regardless if you cast them or not.",  "해제가능 여부에 상관없이 대상의 지속적으로 버프를 추적합니다.",
	"General buffs to keep track of.", "추적할 수 있는 일반 버프입니다.",
	"General buffs.", "일반 버프",
	"General debuffs to keep track of.", "추적할 수 있는 일반 디버프입니다.",
	"General debuffs.", "일반 디버프",
	"General debuffs(will always show if on target, regardless if you cast it or not)", "일반 디버프(해제가능 여부에 상관없이 대상은 항상 보기)",
	--"HOT", true,
	--"HoTs", true,
	"Party: Party member's auras", "파티: 파티원의 오라",
	"Player: Auras on yourself", "플레이어: 자신의 오라",
	"Raid: Raid member's auras", "공격대: 공격대원의 오라",
	"Recently Bandaged", "최근 붕대",
	"Focus: Auras on your focus target", "주시 대상: 당신의 주시 대상 오라",
	"Target: Auras on your target", "대상: 당신의 대상 오라",
	"Pet: Auras on your pet", "소환수: 플레이어의 소환수",
	"Stun", "기절",
	"Stunning debuffs.", "기절 디버프",
	"Stuns", "기절",
	"Timeless", "지속",
	"Track units", "추적 유닛",
	"Units with a checkmark will have their debuffs/buffs watched.", "체크된 유닛의 디버프/버프를 봅니다.",
	"Update All Units On Target Change.", "대상을 변경한 모든 유닛을 업데이트합니다.",
	"Track hidden cooldowns", "숨겨진 재사용 대기시간 추적",
	"Tracks hidden cooldowns on items such as Scarab of the Infinite Cycle or Hourglass of the Unraveller.", "무한한 세월의 스카라베 또는 해결사의 모래 시계등의 아이템의 숨겨진 재사용 대기시간을 추적합니다.",
	"Update All Units", "모든 유닛 업데이트",
	"Updates all units when you change targets", "대상 변경시 모든 유닛 업데이트",
	"Friendly", "우호적",
	"Friendly options", "우호적 설정",
	"Hostile", "적대적",
	"Hostile options", "적대적 설정",
	"Sticky Bars", "접착성 바",
	"Keeps all bars up even when you change targets.", "대상 변경시 모든 바를 정렬합니다.",
	"Trim Names", "이름 짧게 생략",
	"Trims targets names.\r0 = Untrimmed\r-1 = Abbreviated", "대상 이름 짧게 생략.\r0 = 생략 않함\r-1 = 짧게 생략",
	"Trim Auras", "오라 짧게 생략",
	"Trims aura names.\r0 = Untrimmed\r-1 = Abbreviated", "오라 이름 짧게 생략.\r0 = 생략 않함\r-1 = 짧게 생략",
	"Hide Buff Names", "버프 이름 숨김",
	"Hide Debuff Names", "디버프 이름 숨김",
	"Removes the targets name from buff bars.", "버프 바에 대상의 이름 제거합니다.",
	"Removes the targets name from debuff bars.", "디버프 바의 대상의 이름 제거합니다."
)

local categories
local db
local UpdateFilteredUnits
function module:OnInitialize()
	self:SetDefaultEnabledState(false)
	self:RegisterCategory(L["DOT"], L["Debuffs that deal damage over time."], .7, .5, .5)
	self:RegisterCategory(L["HOT"], L["Buffs that heal over time."], .8, .8, .8)
	self:RegisterCategory(L["Disorient"], L["Disorientating debuffs."], .2, .2, .2)
	self:RegisterCategory(L["Stun"], L["Stunning debuffs."], .2, .7, .4)
	self:RegisterCategory(L["Buff"], L["General buffs."], .2, .9, .3)
	self:RegisterCategory(L["Debuff"], L["General debuffs."], .2, .2, .9)
	self:RegisterCategory(L["Timeless"], L["General debuffs(will always show if on target, regardless if you cast it or not)"], .2, .2, .9)
	self.db:RegisterDefaults({
		profile = {
			Buffs		=	{},
			Debuffs		=	{},
			Timeless	=	{},
			Raid		=	false,
			Party		=	false,
			Focus		=	true,
			Target		=	true,
			Player		=	true,
			PlayerPet	=	false,
			TrimNames	=	0,
			TrimAuras	=	0,
			HideBuffNames = false,
			HideDebuffNames = false,
			UpdateSpeed =	0.2,
			ColorByType =	false,
		},
	})
	local spellLst = {}
	local function getSpellList(info)
		local cat = info[#info]
		if categories then
			for i in pairs(spellLst) do
				spellLst[i] = nil
			end
			for spell, category in pairs(categories) do
				if category == cat then
					if db.Timeless[spell] and not db.Debuffs[spell] and not db.Buffs[spell] then
						db.Timeless[spell] = nil
					end
					spellLst[spell] = spell
				end
			end
			if cat == "TimelessDebuffs" then
				for spell in pairs(db.Debuffs) do
					spellLst[spell] = spell
				end
			end
			if cat == "TimelessBuffs" then
				for spell in pairs(db.Buffs) do
					spellLst[spell] = spell
				end
			end
			return spellLst
		end
	end
	
	local function isHidden(info)
		if not db or not categories then return true end

		local key, parentkey = info[#info], info[#info-1]

		if key == "Buffs" or key == "Debuffs" or parentkey == "Timeless" then return end
		if parentkey == "Buffs" or parentkey == "Debuffs" then
			for _, category in pairs(categories) do
				if category == key then return end
			end
			return true
		end
	end
	
	local function setOption(info, value, value2)
		local key, parentkey = info[#info], info[#info-1]
		if parentkey == "Buffs" or parentkey == "Debuffs" or parentkey == "Timeless" then
			db[parentkey][value] = value2 or nil; return
		end
		db[key] = value or nil
		if key == "UpdateSpeed" then
			self:UnregisterAllBuckets()
			self:RegisterBucketEvent("UNIT_AURA", value)
		end
	end
	
	local function getOption(info, value)
		local key, parentkey = info[#info], info[#info-1]
		if parentkey == "Buffs" or parentkey == "Debuffs" or parentkey == "Timeless" then
			return db[parentkey][value]
		end
		return db[key]
	end
	
	self:SetOptionsTable{
		args = {
			General = {
				type = "group",
				name = L["General"],
				desc = L["General Settings"],
				get = getOption,
				set = setOption,
				hidden = isHidden,
				guiInline = true,
				order = 1,
				args = {
					UpdateAllUnitsOnChange = {
						type = "toggle",
						name = L["Update All Units"],
						desc = L["Updates all units when you change targets"],
						order = 10,
					},
					StickyBars = {
						type = "toggle",
						name = L["Sticky Bars"],
						desc = L["Keeps all bars up even when you change targets."],
						order = 20,
					},
					ColorByType = {
						type = "toggle",
						name = L["Color By Type"],
						desc = L["Automatically color the bars based off of spell type\r(only works for debuffs)"],
						order = 21,
					},
					HideBuffNames = {
						type = "toggle",
						name = L["Hide Buff Names"],
						desc = L["Removes the targets name from buff bars."],
						order = 22,
					},
					HideDebuffNames = {
						type = "toggle",
						name = L["Hide Debuff Names"],
						desc = L["Removes the targets name from debuff bars."],
						order = 23,
					},
					TrimNames = {
						type = "range",
						name = L["Trim Names"],
						desc = L["Trims targets names.\r0 = Untrimmed\r-1 = Abbreviated"],
						min = -1,
						max = 20,
						step = 1,
						bigStep = 1,
						order = 30,
					},
					TrimAuras = {
						type = "range",
						name = L["Trim Auras"],
						desc = L["Trims aura names.\r0 = Untrimmed\r-1 = Abbreviated"],
						min = -1,
						max = 20,
						step = 1,
						bigStep = 1,
						order = 40,
					},
					UpdateSpeed = {
						type = "range",
						name = L["Update Speed"],
						desc = L["0 = Fastest, 10 = Slowest\rDefault: 0.2"],
						min = 0,
						max = 10,
						step = 0.1,
						bigStep = 0.2,
						order = 50,
					},
					ShowUnits = {
						type = "multiselect",
						name = L["Track units"],
						desc = L["Units with a checkmark will have their debuffs/buffs watched."],
						get = function(_, key) return db[key] end,
						set = function(_, key, value) db[key] = value; UpdateFilteredUnits(); end,
						values = {
							Raid	=	L["Raid: Raid member's auras"],
							Party	=	L["Party: Party member's auras"],
							Focus	=	L["Focus: Auras on your focus target"],
							Target	=	L["Target: Auras on your target"],
							Player	=	L["Player: Auras on yourself"],
							PlayerPet =	L["Pet: Auras on your pet"],
						},
						width = "full",
						order = -1,
					},
				},
			},
			Buffs = {
				type = "group",
				name = L["Friendly"],
				desc = L["Friendly options"],
				hidden = isHidden,
				get = getOption,
				set = setOption,
				order = 20,
				args = {
					Buff = {
						type = "multiselect",
						name = L["Buffs"],
						desc = L["General buffs to keep track of."],
						values = getSpellList,
						order = 10,
					},
					HOT = {
						type = "multiselect",
						name = L["HoTs"],
						desc = L["Buffs that heal over time to keep track of."],
						values = getSpellList,
						order = 30,
					},
				},
			},
			Debuffs = {
				type = "group",
				name = L["Hostile"],
				desc = L["Hostile options"],
				hidden = isHidden,
				get = getOption,
				set = setOption,
				order = 30,
				args = {
					Debuff = {
						type = "multiselect",
						name = L["Debuffs"],
						desc = L["General debuffs to keep track of."],
						values = getSpellList,
						order = 50,
					},
					DOT = {
						type = "multiselect",
						name = L["DoTs"],
						desc = L["Debuffs that deal damage over time to keep track of."],
						values = getSpellList,
						order = 70,
					},
					Disorient = {
						type = "multiselect",
						name = L["Disorients"],
						desc = L["Debuffs that disorient to keep track of."],
						values = getSpellList,
						order = 90,
					},
					Stun = {
						type = "multiselect",
						name = L["Stuns"],
						desc = L["Debuffs that stun to keep track of."],
						values = getSpellList,
						order = 110,
					},
				},
			},
			Timeless = {
				type = "group",
				name = L["Timeless"],
				desc = L["Timeless options"],
				hidden = isHidden,
				get = getOption,
				set = setOption,
				order = 40,
				args = {
					TimelessDebuffs = {
						type = "multiselect",
						name = L["Timeless Debuffs"],
						desc = L["Debuffs to keep track of regardless if you cast them or not."],
						values = getSpellList,
					},
					TimelessBuffs = {
						type = "multiselect",
						name = L["Timeless Buffs"],
						desc = L["Buffs to keep track of regardless if you cast them or not."],
						values = getSpellList,
					},
				},
			},
		},
	}
end

local duplicate, activeAuras, oldAuras, labels, lastChanged, icons, filteredUnits, BuildCategories, trimAuras

function UpdateFilteredUnits() --this metatable caches filtered units depending on database settings
	if filteredUnits then
		for unit in pairs(filteredUnits) do
			filteredUnits[unit] = nil
		end
	else
		filteredUnits = setmetatable({}, {__index = function(self, unit)
			if unit == "target" then
				self[unit] = not db.Target
			elseif unit == "player" then
				self[unit] = not db.Player
			elseif unit == "focus" then
				self[unit] = not db.Focus
			elseif unit:match("^raid") then
				self[unit] = not db.Raid
			elseif unit:match("^party") then
				self[unit] = not db.Party
			elseif unit == "pet" then
				self[unit] = not db.PlayerPet
			else
				self[unit] = true --shouldn't happen, but just incase, otherwise stack overflows
			end
			return self[unit]
		end,})
	end
end

function module:OnEnable()
	db = self.db.profile
	self:UpgradeProfiles()
	do
		local mt = {__index = function(self, k)
			self[k] = {}
			return self[k]
		end,}
		activeAuras = setmetatable({}, mt)
		oldAuras = setmetatable({}, mt)
	end

	duplicate = {}

	lastChanged = {}

	UpdateFilteredUnits()

	do
		--these two metatables create a two-dimensional array of labels that are created dynamically and then stored for fast table access
		--labels["Curse of Agony"]["SomePlayer"] would return "SomePlayer :: Curse of Agony"
		local labelsMT = {__index = function(self, key)
			self[key] = module:CreateLabel(key, self.__Aura)
			return self[key]
		end,}
		labels = setmetatable({}, {__index = function(self, key)
			self[key] = setmetatable({__Aura = key,}, labelsMT)
			return self[key]
		end,})
	end

	icons = setmetatable({}, {__index = function(self, key)
		self[key] = key:match("Interface\\Icons\\(.+)")
		return self[key]
	end,})
	
	if BuildCategories then
		BuildCategories()
		BuildCategories = nil --no need to ever rebuild these
	end
	self:RegisterBucketEvent("UNIT_AURA", db.UpdateSpeed or 0.2)
	self:RegisterEvent("PLAYER_FOCUS_CHANGED", "UnitChanged", "focus")
	self:RegisterEvent("PLAYER_TARGET_CHANGED", "UnitChanged", "target")
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA")
	self:UpdateUnit(playerName, "player", activeAuras.player, oldAuras.player)
end

--if it's being disabled there's a good chance they don't care about these tables any more
function module:OnDisable()
	self:UnregisterAllEvents()
	self:UnregisterAllBuckets()
	db = nil
	activeAuras = nil
	oldAuras = nil
	duplicate = nil
	labels = nil
	icons = nil
	lastChanged = nil
	filteredUnits = nil
end

local allunits = {
	["player"] = true,
	["focus"] = true,
	["target"] = true,
	["pet"] = true,
	["party1"] = true,
	["party2"] = true,
	["party3"] = true,
	["party4"] = true,
	["party5"] = true,
}

function module:UpdateAllUnits()
	if not allunits["raid"..GetNumRaidMembers()] then
		for i=1,GetNumRaidMembers() do
			allunits["raid"..i] = true
		end
	end
	
	for unit in pairs(allunits) do
		if not filteredUnits[unit] then
			local name = UnitName(unit)
			if name then
				if not duplicate[name] then
					self:UpdateUnit(name, unit, activeAuras[unit], oldAuras[unit])
					duplicate[name] = true
				end
			end
		end
	end
	for name in pairs(duplicate) do
		duplicate[name] = nil
	end
end

function module:UnitChanged(unit)
	local name = UnitName(unit)
	local lastName
	lastName, lastChanged[unit] = lastChanged[unit], name --get the last name, and set the last name with the new name or nil if we don't have them
	if lastName and not db.StickyBars then --cancel old auras if we have them
		local aa = activeAuras[unit]
		lastName = db.TrimNames == -1 and self:TrimString(lastName) or db.TrimNames > 0 and lastName:sub(1, db.TrimNames) or lastName
		for aura in pairs(aa) do
		
			local label = labels[aura][lastName]
			if self:IsBarActive(label) then
				self:CancelBar(label, false)
			end
			if self:IsBarActive(aura) then
				self:CancelBar(aura, false)
			end
			aa[aura] = nil
		end
	end
	if name then --if we have a unit then update it
		self:UpdateUnit(name, unit, activeAuras[unit], oldAuras[unit])
	end
	if db.UpdateAllUnitsOnChange then
		UpdateFilteredUnits()
		self:UpdateAllUnits(unit)
	end
end

function module:UNIT_AURA(units)
	for unit in pairs(units) do
		if not filteredUnits[unit] then
			local name = UnitName(unit)
			if name then
				if not duplicate[name] then
					self:UpdateUnit(name, unit, activeAuras[unit], oldAuras[unit])
					duplicate[name] = true
				end
			end
		end
	end
	for name in pairs(duplicate) do
		duplicate[name] = nil
	end
end


function module:UpdateUnit(name, unit, activeAuras, oldAuras)
	for aura in pairs(activeAuras) do
		activeAuras[aura] = nil
		oldAuras[aura] = true
	end
	name = db.TrimNames == -1 and self:TrimString(name) or db.TrimNames > 0 and name:sub(1, db.TrimNames) or name
	
	local i = 1
	while UnitBuff(unit, i) do
		local aura, _, texture, count, duration, remaining = UnitBuff(unit, i)
		if (duration and db.Buffs[aura]) or db.Timeless[aura] then
			local label
			do
				local aura = db.TrimAuras == -1 and self:TrimString(aura) or db.TrimAuras > 0 and aura:sub(1, db.TrimAuras) or aura
				label = db.HideBuffNames and (count > 0 and aura.." ("..count..")" or aura) or labels[count > 0 and aura.." ("..count..")" or aura][name]
			end
			if not self:IsBarActive(label) then
				if duration then
					self:LocalTimedBar(label, categories[aura], duration, icons[texture], true)
					if remaining + .1 < duration then
						self:SetBarCurrentTime(label, remaining, false)
					end
				else
					self:LocalTimelessBar(label, L["Timeless"], icons[texture])
				end
			else
				if duration then
					if not self:GetBarTimeLeft(label) then
						self:CancelBar(label)
						self:LocalTimedBar(label, categories[aura], duration, icons[texture], true)
					end
					if self:GetBarTimeLeft(label) + .1 < remaining then
						self:SetBarCurrentTime(label, remaining, false)
					end
				end
			end
			if db.HideBuffNames then
				self:CancelBar(count > 1 and aura.." ("..(count - 1)..")" or "")
			else
				self:CancelBar(count > 1 and labels[aura.." ("..(count - 1)..")"][name] or "")
			end

			aura = count > 0 and aura.." ("..count..")" or aura
			activeAuras[aura] = true
			oldAuras[aura] = nil
		end
		i = i + 1
	end
		
	i = 1	-- reset
	while UnitDebuff(unit, i) do
		local aura, _, texture, count, dispelType, duration, remaining = UnitDebuff(unit, i)
		if (duration and db.Debuffs[aura]) or db.Timeless[aura] then
			dispelType = dispelType or "none"
			
			local label
			do
				local aura = db.TrimAuras == -1 and self:TrimString(aura) or db.TrimAuras > 0 and aura:sub(1, db.TrimAuras) or aura
				label = db.HideDebuffNames and (count > 0 and aura.." ("..count..")" or aura) or labels[count > 0 and aura.." ("..count..")" or aura][name]
			end
			if not self:IsBarActive(label) then
				if duration then	
					self:LocalTimedBar(label, categories[aura], duration, icons[texture], true, nil, db.ColorByType and DebuffTypeColor[dispelType].r or nil, db.ColorByType and DebuffTypeColor[dispelType].g or nil, db.ColorByType and DebuffTypeColor[dispelType].b or nil)
					if remaining + .1 < duration then
						self:SetBarCurrentTime(label, remaining, false)
					end
				else
					self:LocalTimelessBar(label, L["Timeless"], icons[texture], nil, db.ColorByType and DebuffTypeColor[dispelType].r or nil, db.ColorByType and DebuffTypeColor[dispelType].g or nil, db.ColorByType and DebuffTypeColor[dispelType].b or nil)
				end
			else
				if duration then
					if not self:GetBarTimeLeft(label) then
						self:CancelBar(label)
						self:LocalTimedBar(label, categories[aura], duration, icons[texture], true, nil, self:LocalTimedBar(label, categories[aura], duration, icons[texture], true, nil, db.ColorByType and DebuffTypeColor[dispelType].r or nil, db.ColorByType and DebuffTypeColor[dispelType].g or nil, db.ColorByType and DebuffTypeColor[dispelType].b or nil))
					end
					if self:GetBarTimeLeft(label) + .1 < remaining then
						self:SetBarCurrentTime(label, remaining, false)
					end
				end
			end
			if db.HideDebuffNames then
				self:CancelBar(count > 1 and aura.." ("..(count - 1)..")" or "")
			else
				self:CancelBar(count > 1 and labels[aura.." ("..(count - 1)..")"][name] or "")
			end

			aura = count > 0 and aura.." ("..count..")" or aura
			activeAuras[aura] = true
			oldAuras[aura] = nil
		end
		i = i + 1
	end
	
	for aura in pairs(oldAuras) do
		oldAuras[aura] = nil
		local label = labels[aura][name]
		if self:IsBarActive(label) and not db.StickyBars then
			self:CancelBar(label, false)
		end
		if self:IsBarActive(aura) and not db.StickyBars then
			self:CancelBar(aura, false)
		end
	end
end

do
	local inArena
	function module:ZONE_CHANGED_NEW_AREA()
		local zone = GetRealZoneText()
		if zone == L["Blade's Edge Arena"] or zone == L["Nagrand Arena"] or zone == L["Ruins of Lordaeron"] then
			self:CancelBars(true)
			inArena = true
			return
		end
		if inArena then
			self:CancelBars(true)
			inArena = false
		end
	end
end

function BuildCategories()
	if playerClass == "WARRIOR" then
		categories = {
			[BS["Battle Shout"]] = L["Buff"],
			[BS["Berserker Rage"]] = L["Buff"],
			[BS["Bloodthirst"]] = L["Buff"],
			[BS["Commanding Shout"]] = L["Buff"],
			[BS["Death Wish"]] = L["Buff"],
			[BS["Rampage"]] = L["Buff"],
			[BS["Recklessness"]] = L["Buff"],
			[BS["Retaliation"]] = L["Buff"],
			[BS["Second Wind"]] = L["Buff"],
			[BS["Shield Block"]] = L["Buff"],
			[BS["Shield Wall"]] = L["Buff"],
			[BS["Bloodrage"]] = L["Buff"],

			[BS["Challenging Shout"]] = L["Debuff"],
			[BS["Disarm"]] = L["Debuff"],
			[BS["Intimidating Shout"]] = L["Debuff"],
			[BS["Mocking Blow"]] = L["Debuff"],
			[BS["Piercing Howl"]] = L["Debuff"],
			[BS["Demoralizing Shout"]] = L["Debuff"],
			[BS["Hamstring"]] = L["Debuff"],
			[BS["Mortal Strike"]] = L["Debuff"],
			[BS["Shield Bash - Silenced"]] = L["Debuff"],
			[BS["Sunder Armor"]] = L["Debuff"],
			[BS["Thunder Clap"]] = L["Debuff"],

			[BS["Rend"]] = L["DOT"],
			[BS["Deep Wound"]] = L["DOT"],

			[BS["Charge Stun"]] = L["Stun"],
			[BS["Concussion Blow"]] = L["Stun"],
			[BS["Intercept Stun"]] = L["Stun"],
			[BS["Mace Stun Effect"]] = L["Stun"],
			[BS["Revenge Stun"]] = L["Stun"],
		}
	
	elseif playerClass == "DRUID" then
		categories = {
			[BS["Abolish Poison"]] = L["Buff"],
			[BS["Barkskin"]] = L["Buff"],
			[BS["Clearcasting"]] = L["Buff"],
			[BS["Innervate"]] = L["Buff"],
			[BS["Dash"]] = L["Buff"],
			[BS["Frenzied Regeneration"]] = L["Buff"],
			[BS["Enrage"]] = L["Buff"],
			[BS["Tiger's Fury"]] = L["Buff"],
			[BS["Nature's Grasp"]] = L["Buff"],

			[BS["Lifebloom"]] = L["HOT"],
			[BS["Regrowth"]] = L["HOT"],
			[BS["Rejuvenation"]] = L["HOT"],

			[BS["Entangling Roots"]] = L["DOT"],
			[BS["Hibernate"]] = L["DOT"],
			[BS["Insect Swarm"]] = L["DOT"],
			[BS["Moonfire"]] = L["DOT"],
			[BS["Pounce Bleed"]] = L["DOT"],
			[BS["Rake"]] = L["DOT"],
			[BS["Rip"]] = L["DOT"],
			[BS["Lacerate"]] = L["DOT"],

			[BS["Bash"]] = L["Stun"],
			[BS["Starfire Stun"]] = L["Stun"],
			[BS["Cyclone"]] = L["Stun"],
			[BS["Pounce"]] = L["Stun"],

			[BS["Maim"]] = L["Disorient"],
			
			[BS["Demoralizing Roar"]] = L["Debuff"],
			[BS["Faerie Fire (Feral)"]] = L["Debuff"],
			[BS["Feral Charge"]] = L["Debuff"],
			[BS["Mangle (Bear)"]] = L["Debuff"],
			[BS["Mangle (Cat)"]] = L["Debuff"],
			[BS["Faerie Fire"]] = L["Debuff"],
			[BS["Hibernate"]] = L["Debuff"],
			[BS["Soothe Animal"]] = L["Debuff"],
		}
	
	elseif playerClass == "HUNTER" then
		categories = {
			[BS["Entrapment"]] = L["Debuff"],
			[BS["Scorpid Sting"]] = L["Debuff"],
			[BS["Concussive Barrage"]] = L["Debuff"],
			[BS["Concussive Shot"]] = L["Debuff"],
			[BS["Viper Sting"]] = L["Debuff"],
			[BS["Wyvern Sting"]] = L["Debuff"],
			[BS["Counterattack"]] = L["Debuff"], 
			[BS["Scare Beast"]] = L["Debuff"],  
			[BS["Silencing Shot"]] = L["Debuff"], 
			[BS["Freezing Trap Effect"]] = L["Debuff"], 
			[BS["Frost Trap Aura"]] = L["Debuff"], 
			[BS["Expose Weakness"]] = L["Debuff"], 
			[BS["Flare"]] = L["Debuff"],  
			[BS["Hunter's Mark"]] = L["Debuff"], 
			[BS["Improved Wing Clip"]] = L["Debuff"],
			[BS["Wing Clip"]] = L["Debuff"],
			[BS["Aimed Shot"]] = L["Debuff"],

			[BS["Serpent Sting"]] = L["DOT"],
			[BS["Explosive Trap Effect"]] = L["DOT"], 
			[BS["Immolation Trap Effect"]] = L["DOT"], 

			[BS["Boar Charge"]] = L["Stun"],
			[BS["Improved Concussive Shot"]] = L["Stun"],
			[BS["Intimidation"]] = L["Stun"], 

			[BS["Bestial Wrath"]] = L["Buff"], 
			[BS["Ferocious Inspiration"]] = L["Buff"], 
			[BS["Frenzy Effect"]] = L["Buff"], 
			[BS["Rapid Killing"]] = L["Buff"], 
			[BS["The Beast Within"]] = L["Buff"], 
			[BS["Feed Pet Effect"]] = L["Buff"], 
			[BS["Deterrence"]] = L["Buff"], 
			[BS["Master Tactician"]] = L["Buff"], 
			[BS["Quick Shots"]] = L["Buff"],
			[BS["Rapid Fire"]] = L["Buff"],
			
			[BS["Mend Pet"]] = L["HOT"],

			[BS["Scatter Shot"]] = L["Disorient"], 
		}
			
	elseif playerClass == "MAGE" then
		categories = {
			[BS["Fire Vulnerability"]] = L["Debuff"],
			[BS["Winter's Chill"]] = L["Debuff"],
			[BS["Blast Wave"]] = L["Debuff"],
			[BS["Cone of Cold"]] = L["Debuff"],
			[BS["Frost Armor"]] = L["Debuff"],
			[BS["Frost Nova"]] = L["Debuff"],
			[BS["Frostbite"]] = L["Debuff"],
			[BS["Frostbolt"]] = L["Debuff"],
			[BS["Improved Counterspell"]] = L["Debuff"],
			[BS["Improved Blizzard"]] = L["Debuff"],
			[BS["Polymorph"]] = L["Debuff"],
			[BS["Polymorph: Pig"]] = L["Debuff"],
			[BS["Polymorph: Turtle"]] = L["Debuff"],
			[BS["Scorch"]] = L["Debuff"],
			[BS["Impact"]] = L["Stun"],
			
			[BS["Fireball"]] = L["DOT"],
			[BS["Flamestrike"]] = L["DOT"],
			[BS["Ignite"]] = L["DOT"],
			[BS["Pyroblast"]] = L["DOT"],

			[BS["Dragon's Breath"]] = L["Disorient"],

			[BS["Hypothermia"]] = L["Debuff"],
			[BS["Arcane Power"]] = L["Buff"],
			[BS["Blazing Speed"]] = L["Buff"],
			[BS["Ice Barrier"]] = L["Buff"],
			[BS["Ice Block"]] = L["Buff"],
			[BS["Slow Fall"]] = L["Buff"],
		}
	
	elseif playerClass == "PALADIN" then
		categories = {
			[BS["Blessing of Freedom"]] = L["Buff"],
			[BS["Blessing of Kings"]] = L["Buff"],
			[BS["Blessing of Light"]] = L["Buff"],
			[BS["Blessing of Might"]] = L["Buff"],
			[BS["Blessing of Protection"]] = L["Buff"],
			[BS["Blessing of Sacrifice"]] = L["Buff"],
			[BS["Blessing of Salvation"]] = L["Buff"],
			[BS["Blessing of Sanctuary"]] = L["Buff"],
			[BS["Blessing of Wisdom"]] = L["Buff"],
			[BS["Greater Blessing of Kings"]] = L["Buff"],
			[BS["Greater Blessing of Light"]] = L["Buff"],
			[BS["Greater Blessing of Might"]] = L["Buff"],
			[BS["Greater Blessing of Salvation"]] = L["Buff"],
			[BS["Greater Blessing of Sanctuary"]] = L["Buff"],
			[BS["Greater Blessing of Wisdom"]] = L["Buff"],
			[BS["Avenging Wrath"]] = L["Buff"],
			[BS["Divine Protection"]] = L["Buff"],
			[BS["Divine Shield"]] = L["Buff"],
			[BS["Reckoning"]] = L["Buff"],
			[BS["Righteous Fury"]] = L["Buff"],
			[BS["Holy Shield"]] = L["Buff"],
			[BS["Seal of Blood"]] = L["Buff"],
			[BS["Seal of Command"]] = L["Buff"],
			[BS["Seal of Justice"]] = L["Buff"],
			[BS["Seal of Light"]] = L["Buff"],
			[BS["Seal of Righteousness"]] = L["Buff"],
			[BS["Seal of the Crusader"]] = L["Buff"],
			[BS["Seal of Vengeance"]] = L["Buff"],
			[BS["Seal of Wisdom"]] = L["Buff"],
			[BS["Divine Illumination"]] = L["Buff"],
			[BS["Light's Grace"]] = L["Buff"],
			[BS["Redoubt"]] = L["Buff"],

			[BS["Avenger's Shield"]] = L["Debuff"],
			[BS["Judgement of Justice"]] = L["Debuff"],
			[BS["Judgement of Light"]] = L["Debuff"],
			[BS["Judgement of the Crusader"]] = L["Debuff"],
			[BS["Judgement of Wisdom"]] = L["Debuff"],
			[BS["Turn Evil"]] = L["Debuff"],
			[BS["Vindication"]] = L["Debuff"],
			[BS["Holy Vengeance"]] = L["Debuff"],

			[BS["Hammer of Justice"]] = L["Stun"],
			[BS["Stun"]] = L["Stun"],

			[BS["Repentance"]] = L["Disorient"],

			[BS["Consecration"]] = L["DOT"],
		}
	
	elseif playerClass == "PRIEST" then
		categories = {
			[BS["Blessed Recovery"]] = L["Buff"], 
			[BS["Elune's Grace"]] = L["Buff"],
			[BS["Feedback"]] = L["Buff"],
			[BS["Inspiration"]] = L["Buff"],
			[BS["Martyrdom"]] = L["Buff"],
			[BS["Pain Suppression"]] = L["Buff"],
			[BS["Power Infusion"]] = L["Buff"],
			[BS["Renew"]] = L["HOT"], 
			[BS["Spirit Tap"]] = L["Buff"],
			[BS["Surge of Light"]] = L["Buff"],

			[BS["Devouring Plague"]] = L["DOT"],
			[BS["Hex of Weakness"]] = L["Debuff"], 
			[BS["Prayer of Mending"]] = L["Buff"],
			[BS["Shadow Word: Pain"]] = L["DOT"], 
			[BS["Silence"]] = L["Debuff"],
			[BS["Touch of Weakness"]] = L["Debuff"], 
			[BS["Vampiric Embrace"]] = L["Debuff"],
			[BS["Vampiric Touch"]] = L["DOT"],

			[BS["Abolish Disease"]] = L["Buff"], 
			[BS["Blackout"]] = L["Stun"],
			[BS["Fade"]] = L["Buff"], 
			[BS["Levitate"]] = L["Buff"], 
			[BS["Mind Soothe"]] = L["Debuff"], 
			[BS["Power Word: Shield"]] = L["Buff"],
			[BS["Psychic Scream"]] = L["Debuff"], 
			[BS["Shackle Undead"]] = L["Debuff"], 
			[BS["Shadow Vulnerability"]] = L["Debuff"],
			[BS["Spirit of Redemption"]] = L["Buff"],
			[BS["Weakened Soul"]] = L["Debuff"],
		}
	
	elseif playerClass == "ROGUE" then
		categories = {
			[BS["Adrenaline Rush"]] = L["Buff"],
			[BS["Blade Flurry"]] = L["Buff"],
			[BS["Cloak of Shadows"]] = L["Buff"],
			[BS["Evasion"]] = L["Buff"],
			[BS["Find Weakness"]] = L["Buff"],
			[BS["Ghostly Strike"]] = L["Buff"],
			[BS["Remorseless"]] = L["Buff"],
			[BS["Shadowstep"]] = L["Buff"],
			[BS["Slice and Dice"]] = L["Buff"],
			[BS["Sprint"]] = L["Buff"],
			[BS["Vanish"]] = L["Buff"],

			[BS["Garrote"]] = L["DOT"],
			[BS["Rupture"]] = L["DOT"],
			[BS["Deadly Poison"]] = L["DOT"],
			[BS["Deadly Poison II"]] = L["DOT"],
			[BS["Deadly Poison III"]] = L["DOT"],
			[BS["Deadly Poison IV"]] = L["DOT"],
			[BS["Deadly Poison V"]] = L["DOT"],
			[BS["Deadly Poison VI"]] = L["DOT"],
			[BS["Deadly Poison VII"]] = L["DOT"],

			[BS["Crippling Poison"]] = L["Debuff"],
			[BS["Expose Armor"]] = L["Debuff"],
			[BS["Mind-numbing Poison"]] = L["Debuff"],
			[BS["Mind-numbing Poison II"]] = L["Debuff"],
			[BS["Mind-numbing Poison III"]] = L["Debuff"],
			[BS["Wound Poison"]] = L["Debuff"],
			[BS["Wound Poison II"]] = L["Debuff"],
			[BS["Wound Poison III"]] = L["Debuff"],
			[BS["Wound Poison IV"]] = L["Debuff"],
			[BS["Wound Poison V"]] = L["Debuff"],
			[BS["Garrote - Silence"]] = L["Debuff"],
			[BS["Kick - Silenced"]] = L["Debuff"],
			[BS["Deadly Throw"]] = L["Debuff"],
			[BS["Riposte"]] = L["Debuff"],
			[BS["Blade Twisting"]] = L["Debuff"],

			[BS["Blind"]] = L["Disorient"],
			[BS["Gouge"]] = L["Disorient"],
			[BS["Sap"]] = L["Disorient"],

			[BS["Cheap Shot"]] = L["Stun"],
			[BS["Kidney Shot"]] = L["Stun"],
			[BS["Mace Stun Effect"]] = L["Stun"],
		}
	
	elseif playerClass == "SHAMAN" then
		categories = {
			[BS["Ancestral Healing"]] = L["Buff"],
			[BS["Elemental Devastation"]] = L["Buff"],
			[BS["Eye of the Storm"]] = L["Buff"],
			[BS["Healing Way"]] = L["Buff"],
			[BS["Shamanistic Rage"]] = L["Buff"],
			[BS["Unleashed Rage"]] = L["Buff"],
			[BS["Earth Shield"]] = L["Buff"],

			[BS["Frostbrand Attack"]] = L["Debuff"],
			[BS["Frost Shock"]] = L["Debuff"],
			[BS["Stormstrike"]] = L["Debuff"],

			[BS["Flame Shock"]] = L["DOT"],
		}
	
	elseif playerClass == "WARLOCK" then
		categories = {
			[BS["Backlash"]] = L["Buff"],
			[BS["Nether Protection"]] = L["Buff"],
			[BS["Shadow Trance"]] = L["Buff"],
			[BS["Soulstone Resurrection"]] = L["Buff"],
			[BS["Amplify Curse"]] = L["Buff"],
			[BS["Unending Breath"]] = L["Buff"],
			[BS["Detect Invisibility"]] = L["Buff"],

			[BS["Shadow Vulnerability"]] = L["Debuff"],
			[BS["Enslave Demon"]] = L["Debuff"],
			[BS["Curse of Exhaustion"]] = L["Debuff"], 
			[BS["Curse of Recklessness"]] = L["Debuff"],
			[BS["Curse of Shadow"]] = L["Debuff"],
			[BS["Curse of the Elements"]] = L["Debuff"],
			[BS["Curse of Tongues"]] = L["Debuff"],
			[BS["Curse of Weakness"]] = L["Debuff"],
			[BS["Banish"]] = L["Debuff"],
			[BS["Death Coil"]] = L["Debuff"],
			[BS["Fear"]] = L["Debuff"],
			[BS["Howl of Terror"]] = L["Debuff"],
			[BS["Seduction"]] = L["Debuff"],
			[BS["Shadowburn"]] = L["Debuff"],

			[BS["Curse of Agony"]] = L["DOT"],
			[BS["Curse of Doom"]] = L["DOT"],
			[BS["Corruption"]] = L["DOT"],
			[BS["Immolate"]] = L["DOT"],
			[BS["Siphon Life"]] = L["DOT"],
			[BS["Unstable Affliction"]] = L["DOT"],
		}
	end
	local _, race = UnitRace("player")
	if race == "Scourge" then
		categories[BS["Cannibalize"]] = L["Buff"]
		categories[BS["Will of the Forsaken"]] = L["Buff"]
	
	elseif race == "Orc" then
		categories[BS["Blood Fury"]] = L["Buff"]
	
	elseif race == "Tauren" then
		categories[BS["War Stomp"]] = L["Buff"]
	
	elseif race == "Troll" then
		categories[BS["Berserking"]] = L["Buff"]
	
	elseif race == "Blood Elf" then
		categories[BS["Arcane Torrent"]] = L["Debuff"]
		categories[BS["Mana Tap"]] = L["Debuff"]
	
	elseif race == "Dwarf" then
		categories[BS["Stoneform"]] = L["Buff"]
	
	elseif race == "Draenei" then
		categories[BS["Gift of the Naaru"]] = L["HOT"]
	
	elseif race == "Human" then
		categories[BS["Perception"]] = L["Buff"]
	end
		-- Items
	if GetItemCount(31856, true) > 0 then
		categories["Aura of the Crusader"] = L["Buff"]
	end
	if GetItemCount(31857, true) > 0 then
		categories["Aura of Wrath"] = L["Buff"]
	end
	if GetItemCount(19288, true) > 0 then
		categories["Aura of the Blue Dragon"] = L["Buff"]
	end
	if GetItemCount(32487, true) > 0 then	-- Hunter BlackTemple Trinket
		categories["Deadly Aim"] = L["Buff"]
	end
	if GetItemCount(32492, true) > 0 then	-- Rogue BT Trinket
		categories["Exploit Weakness"] = L["Buff"]
	end
	if GetItemCount(9224, true) > 0 then
		categories["Elixir of Demonslaying"] = L["Buff"]
	end
		-- misc stuff
	categories[BS["Forbearance"]] = L["Debuff"]
	categories[L["Recently Bandaged"]] = L["Debuff"]
	categories[BS["Well Fed"]] = L["Buff"]
end