local GetAddOnMetadata = GetAddOnMetadata
local getmetatable = getmetatable
local setmetatable = setmetatable
local AceAddon = LibStub("AceAddon-3.0")
local LibStub = LibStub
local next = next
local ipairs = ipairs
local pairs = pairs
local type = type
local select = select
local format = string.format
local remove = table.remove
local GetRealZoneText = GetRealZoneText
local playerClass = select(2, UnitClass("player"))
local playerName = UnitName("player")
local GetTime = GetTime
local LoadAddOn = LoadAddOn
local IsAddOnLoadOnDemand = IsAddOnLoadOnDemand
local GetNumAddOns = GetNumAddOns 
local GetAddOnInfo = GetAddOnInfo
local IsAddOnLoaded = IsAddOnLoaded
 
setfenv(1, RBM.FunctionEnviroment)
local L = L

Core.version = "2.0.8"
Core.revision = _G.tonumber(("$Rev: 80601 $"):match("%d+"))

local db
local WakeAllModules, StandByAllModules, InitializeModules
function Core:OnInitialize()
	IsInitialized = true
	db = self:InitializeDB()
	Profile = db.profile
	ThemeList = db.global.ThemeList
	if db.global.LastVersion and db.global.LastVersion ~= self.version then
		if db.global.LastVersion then
			self:OnVersionUpgrade(db.global.LastVersion, self.version)
		end
	end
	if not db.global.LastVersion and not db.global.FirstRun then
		self:OnVersionUpgrade("unknown", self.version)
	end
	self:SetEnabledState(db.global.Enabled)
	for i=1, GetNumAddOns() do
		if IsAddOnLoadOnDemand(i) and not IsAddOnLoaded(i) then
			local name, title, notes, enabled, loadable = GetAddOnInfo(i)
			local plugin = GetAddOnMetadata(i, "X-RBMPlugin")
			if plugin and enabled and loadable then
				if not LoDModules then
					LoDModules = {}
				end
				LoDModules[plugin] = name
			end
			local bossmod = GetAddOnMetadata(i, "X-RBMLoadIn")
			if bossmod and enabled and loadable then
				if not _G.BigWigs then	-- only load these when bigwigs isn't enabled.
					if not IsAddOnLoaded("LibBabble-Zone-3.0") then
						LoadAddOn("LibBabble-Zone-3.0")
					end
					if not IsAddOnLoaded("LibBabble-Boss-3.0") then
						LoadAddOn("LibBabble-Boss-3.0")
					end
				end
			end
		end
	end
	db.global.LastVersion = self.version
	InitializeModules(self)
	self.OnInitialize = nil
	self.InitializeDB = nil
	self.OnVersionUpgrade = nil
	LibStub("AceConfigDialog-3.0"):AddToBlizOptions("RBM", "RBM")
	self:SetSinkStorage(Profile.sinkOptions)
	self:RegisterSink("RBM", "RBM", "RBM Custom Frame", "MsgFrameAddMessage", nil, nil)	

	if LibStub:GetLibrary("LibFuBarPlugin-Mod-3.0", true) then
		self:SetFuBarOption("tooltipType", "GameTooltip")
		self:SetFuBarOption("hasNoColor", true)
		self:SetFuBarOption("cannotDetachTooltip", true)
		self:SetFuBarOption("hideWithoutStandby", true)
		self:SetFuBarOption("configType", "AceConfigDialog-3.0")
		self:SetFuBarOption("defaultPosition", "RIGHT")
		--self:SetFuBarOption("independentProfile", true)
		self:SetFuBarOption("iconPath", [[Interface/Icons/Inv_Misc_SummerFest_BrazierGreen]])
	end
end


function Core:OnVersionUpgrade(oldVersion, newVersion)
	if oldVersion == "unknown" then
		self:ShowUpgradeFrame("unknown", newVersion, "In this version there are numerious bug fixes.  One of them requires that the color tables be reset.  Click below to reset the tables.", function() self.db.profile.ColorTables = nil; self:print("Upgraded!") end)
	end
end

function Core:print(...)
	  _G["ChatFrame1"]:AddMessage("<RBM> "..format(...), 1, 0, 0)
end

function Core:ShowUpgradeFrame(oldver, curver, msg, func)
	local f = CreateFrame("Frame", "RBM_Upgrade", _G.UIParent)
	f:EnableMouse(true)
	f:SetMovable(true)
	f:SetScript("OnMouseDown", f.StartMoving)
	f:SetScript("OnMouseUp", f.StopMovingOrSizing)

	local close = CreateFrame("Button", nil, f, "UIPanelCloseButton")
	close:SetPoint("TOPRIGHT", f, "TOPRIGHT")
	close:SetScript("OnClick", function() f:Hide() end)

	local title = f:CreateFontString()
	title:SetFontObject("GameFontNormal")
	title:SetPoint("TOP", f, "TOP", 0, 5)
	title:SetText(L["RBM Upgrade"])

	local fs = f:CreateFontString()
	fs:SetFontObject("GameFontHighlight")
	fs:SetPoint("TOPLEFT", f, "TOPLEFT", 16, -32)
	fs:SetPoint("BOTTOMRIGHT", f, "BOTTOMRIGHT", -16, 16)
	fs:SetJustifyV("TOP")

	fs:SetText(L["UpgradeFrom"]..oldver.." "..L["To: "]..curver.."|r\r\r"..msg.."\r\r\r\r\r"..L["UpgradeMsg"])

	f:SetHeight(500)
	f:SetWidth(400)
	f:SetPoint("CENTER", 0, 0)
	f:SetBackdrop{bgFile = MediaHandler:Fetch("background", "Blizzard Tooltip"), edgeFile = MediaHandler:Fetch("border", "RothSquare"), edgeSize=16}
	f:SetBackdropColor(0, 0, 0)

	local b = CreateFrame("Button", nil, f, "UIPanelButtonTemplate2")
	b:SetScript("OnMouseDown", nil)
	b:SetScript("OnMouseUp", nil)
	b:SetScript("OnClick", function() func(); _G.ReloadUI() end)
	b:SetPoint("BOTTOM", 0, 10)
	b:SetText(L["Upgrade Now!"])
	b:SetWidth(b:GetFontString():GetWidth() + 25)
	b:SetHeight(30)
end
do
	local function Embed(self, other)
		if getmetatable(other) then
			for k, v in pairs(self) do
				other[k] = v
			end
		else
			setmetatable(other, {__index = self})
		end
		return other
	end

	--create our classes
	BaseClass, PluginClass, 
	BossModuleClass,
	BarClass, FrameClass = {Embed = Embed}, {Embed = Embed}, {Embed = Embed}, {Embed = Embed}, {Embed = Embed}

end

local FrameClass, BossModuleClass, PluginClass = FrameClass, BossModuleClass, PluginClass

do
	local frames = {}
	local cache, list
	--local list
	function Core:GetFramesList()
		if not list then
			list = {}
			for name in pairs(frames) do
				list[#list + 1] = name
			end
		end
		return list
	end

	function Core:NewBarFrame(name)
		if type(name) ~= "string" or frames[name] then return end
		local frame = cache and remove(cache)
		if frame then
			frame:Initialize(name)
		else
			frame = FrameClass:New(name)
		end
		frames[name] = frame
		Profile.SavedFrames[name] = true
		if cache and #cache == 0 then
			cache = nil
		end
		if list then
			list[#list + 1] = name
		end
		return frame
	end
	function Core:GetBarFrame(name)
		return frames[name]
	end
	function Core:HasBarFrame(name)
		return frames[name] ~= nil
	end
	function Core:IterateBarFrames()
		return pairs(frames)
	end
	function Core:DestroyBarFrame(name, saveSettings)
		if frames[name] then
			local frame = frames[name]
			frames[name] = nil
			frame:Destroy(saveSettings)
			if not cache then
				cache = {}
			end
			cache[#cache + 1] = frame
			if list then
				for i, n in ipairs(list) do
					remove(list, i)
					break
				end
			end
			if not saveSettings then
				Profile.SavedFrames[name] = nil
			end
		end
	end
	function Core:ExecuteFrameMethod(method, ...)
		if not FrameClass[method] then return end
		for name, frame in pairs(frames) do
			frame[method](frame, ...)
		end
	end
end

function Core:ForceShowFrames()
	self:ExecuteFrameMethod("ForceShow")
end

function Core:ResetForceShowFrames()
	self:ExecuteFrameMethod("ResetForceShow")
end

do
	local plugins, bossMods = {}, {}
	WakeAllModules = function(self)
		local states = Profile.ModuleStates
		for name, module in pairs(plugins) do
			local state = states[module:GetPrefixedName()]
			if state == true then
				module:Enable()
			elseif state == false then
				module:Disable()
			elseif state == nil then
				local defaultState = module:GetDefaultEnabledState()
				if defaultState == true or defaultState == nil then
					module:Enable()
				else
					module:Disable()
				end
			end
		end
		local checkZone = Profile.ActivateModulesZone
		for name, module in pairs(bossMods) do
			if checkZone then
				if not module:IsBossDead() and module:HasZone(GetRealZoneText()) then
					module:Enable()
				else
					module:Disable()
				end
			else
				local state = states[module:GetPrefixedName()]
				if state and not module:IsBossDead() then
					module:Enable()
				else
					module:Disable()
				end
			end
		end
		if LoDModules then
			for plugin, addon in pairs(LoDModules) do
				local state = states["Plugin"..plugin]
				if state or state == nil and GetAddOnMetadata(addon, "X-RBMDefaultDisabled") ~= "1" then
					LoadAddOn(addon)
					LoDModules[plugin] = nil
				end
			end
			if not next(LoDModules) then
				LoDModules = nil
			end
		end
	end
	InitializeModules = function(self)
		for name, module in pairs(plugins) do
			module.db = db:RegisterNamespace(module:GetPrefixedName())
			module:Initialize()
		end
		for name, module in pairs(bossMods) do
			module.db = db:RegisterNamespace(module:GetPrefixedName())
			module:Initialize()
		end
	end
	StandByAllModules = function(self)
		for name, module in pairs(plugins) do
			module:Disable(true)
		end
		for name, module in pairs(bossMods) do
			module:Disable(true)
		end
	end
	do
		local initQueue
		local function UpdateQueue()
			if not initQueue then
				return
			end
			local states = Profile.ModuleStates
			local checkZone = Profile.ActivateModulesZone
			for module in pairs(initQueue) do
				initQueue[module] = nil
				module:Initialize()
				if IsEnabled then
					if module:IsType("Plugin") then
						local state = states[module:GetPrefixedName()]
						if state == true then
							module:Enable()
						elseif state == false then
							module:Disable()
						elseif state == nil then
							local defaultState = module:GetDefaultEnabledState()
							if defaultState == true or defaultState == nil then
								module:Enable()
							else
								module:Disable()
							end
						end
					elseif module:IsType("BossModule") then
						if checkZone then
							if not module:IsBossDead() and module:HasZone(GetRealZoneText()) then
								module:Enable()
							else
								module:Disable()
							end
						else
							local state = states[module:GetPrefixedName()]
							if state and not module:IsBossDead() then
								module:Enable()
							else
								module:Disable()
							end
						end
					end
				end
			end
			initQueue = nil
		end
		function Core:NewPlugin(name, ...)
			local module = PluginClass:Embed{Name = name, Type = "Plugin", name = name}
			AceAddon:EmbedLibraries(module, ...)
			if IsInitialized then
				if not initQueue then
					initQueue = {}
				end
				initQueue[module] = true
				module.db = db:RegisterNamespace(module:GetPrefixedName())
				self:ScheduleTimer(UpdateQueue, 0)
			end
			plugins[name] = module
			return module
		end
		function Core:NewBossModule(name, ...)
			local module = BossModuleClass:Embed{Name = name, Type = "BossModule", name = name}
			AceAddon:EmbedLibraries(module, ...)
			if IsInitialized then
				if not initQueue then
					initQueue = {}
				end
				initQueue[module] = true
				module.db = db:RegisterNamespace(module:GetPrefixedName())
				self:ScheduleTimer(UpdateQueue, 0)
			end
			bossMods[name] = module
			return module
		end
	end
	function Core:GetModule(type, name)
		if not type or not name then return end
		if type == "Plugin" then
			return plugins[name]
		elseif type == "BossModule" then
			return bossMods[name]
		end
	end
	local allIterate
	do
		local current
		function allIterate(table, last)
			local k, v = next(current, last)
			if not k then
				if current == table then
					return
				else
					current = table
					return next(current)
				end
			end
			return k, v
		end
	end
	function Core:IterateModules(type)
		if type == "Plugin" then
			return pairs(plugins)
		elseif type == "BossModule" then
			return pairs(bossMods)
		else
			if not allIterate then
				
			end
			current = bossMods
			return allIterate, plugins
		end
	end
end

function Core:OnProfileChanged()
	for name in self:IterateBarFrames() do
		self:DestroyBarFrame(name, true)
	end
	
	StandByAllModules(self)

	Profile = db.profile
	self:UpdateModuleCategoryColors()
	
	for name in pairs(Profile.SavedFrames) do
		self:NewBarFrame(name)
	end
	
	WakeAllModules(self)
	LibStub("AceConfigRegistry-3.0"):NotifyChange("RBM")
	self:CreateMessageFrame()
end

function Core:OnEnable()
	IsEnabled = true
	db.global.Enabled = true
	Profile = db.profile
	self:UpdateModuleCategoryColors()

	if db.global.FirstRun then
		self:ShowWelcomeFrame()
		db.global.FirstRun = false
	end
	
	for name in pairs(Profile.SavedFrames) do
		self:NewBarFrame(name)
	end

	self:RegisterComm("RBM")

	WakeAllModules(self)
	self:CreateMessageFrame()
end

function Core:OnDisable()
	db.global.Enabled = false
	StandByAllModules(self)
	for name in self:IterateBarFrames() do
		self:DestroyBarFrame(name, true)
	end
end

local function Strip(from, defaults)
	for k, v in pairs(defaults) do
		if type(v) == "table" then
			if type(from[k]) == "table" then
				Strip(from[k], v)
				if not next(from[k]) then
					from[k] = nil
				end
			end
		else
			if v == from[k] then
				from[k] = nil
			end
		end
	end
	if next(from) then
		return from
	end
end

function Core:AddTheme(name, theme, themeOpts)
	if not ThemeList then
		error("`AddTheme' cannot be called until RBM is fully enabled.")
	end
	if type(name) ~= "string" then
		error("bad argument #2 to `AddTheme' (string expected, got %s)", type(name))
	end
	if type(theme) ~= "table" then
		error("bad argument #3 to `AddTheme' (table expected, got %s)", type(theme))
	end
	theme = Strip(theme, FrameDefaults)
	if theme then --TODO: Fix themes
		if themeOpts then
			if not themeOpts.Sound then
				theme.SoundByPercent = nil
				theme.SoundPercent = nil
				theme.SoundByTime = nil
				theme.SoundTime = nil
				theme.SoundToPlay = nil
				theme.SoundToPlayLabels = nil
			end
			if not themeOpts.Filters then
				theme.Categories = nil
				theme.CategoriesList = nil
				theme.Custom = nil
				theme.CustomList = nil
				theme.CustomException = nil
				theme.CustomExceptionList = nil
				theme.Labels = nil
				theme.LabelsList = nil
				theme.ByMaxLength = nil
				theme.ByMinLength = nil
				theme.MinLength = nil
				theme.MaxLength = nil
			end
			if not themeOpts.Transfer then
				theme.TransferBelowByPercent = nil
				theme.TransferBelowPercent = nil
				theme.TransferBelowTo = nil
				theme.TransferBelowByTime = nil
				theme.TransferBelowTime = nil
				theme.TransferBelowAnimate = nil
				theme.TransferBelowRate = nil

				theme.TransferAboveByPercent = nil
				theme.TransferAbovePercent = nil
				theme.TransferAboveTo = nil
				theme.TransferAboveByTime = nil
				theme.TransferAboveTime = nil
				theme.TransferAboveAnimate = nil
				theme.TransferAboveRate = nil
			end
			if not themeOpts.Elements then
				theme.BarBackdrop = nil
				theme.BarBackdropColor = nil
				theme.BarBackdropBorderColor = nil

				theme.BarWidth = nil
				theme.BarHeight = nil

				theme.SparkTexture = nil
				theme.SparkVisible = nil
				theme.SparkBlend = nil
				theme.SparkWidth = nil
				theme.SparkHeight = nil
				theme.SparkColor = nil

				theme.TimerFont = nil
				theme.TimerFontSize = nil
				theme.TimerAdjust = nil
				theme.TimerJustifyH = nil
				theme.TimerJustifyV = nil
				theme.TimerColor = nil

				theme.LabelFont = nil
				theme.LabelFontSize = nil
				theme.LabelAdjust = nil
				theme.LabelJustifyH = nil
				theme.LabelJustifyV = nil
				theme.LabelColor = nil

				theme.StatusTexture = nil
				theme.StatusLeftSpacing = nil
				theme.StatusRightSpacing = nil
				theme.StatusTopSpacing = nil
				theme.StatusBottomSpacing = nil

				theme.IconLocation = nil
				theme.IconVisible = nil
			end
		end
		theme.Xoffset, theme.Yoffset = nil, nil
		theme.KeepAnchorPoints, theme.MergeWithExisting = nil, nil
		theme.SaveFilters = nil
		ThemeList[name] = theme
		
	end
end

function Core:RemoveTheme(name)
	if type(name) == "string" then
		ThemeList[name] = nil
	end
end

function Core:GetTheme(name)
	if type(name) == "string" then
		return ThemeList[name]
	end
end

function Core:ApplyTheme(frameName, themeName)
	if type(frameName) == "string" and type(themeName) == "string" then
		local frame = self:GetBarFrame(frameName)
		if frame and self:GetTheme(themeName) then
			frame:ApplyTheme(themeName)
		end
	end
end

function Core:GetThemes()
	return ThemeList
end

function Core:UpdateModuleCategoryColors()
	local mt = Profile.ColorTables
	for name, module in self:IterateModules("Plugin") do
		local cats = module:GetCategories()
		if cats then
			if not mt[name] then
				mt[name] = {}	
			end
			for cat in pairs(cats) do
				if not mt[name][cat] or not mt[name][cat].r then
					local colors = module:GetCategoryColors(cat) --can't share tables or one profile might affect another
					mt[name][cat] = { ["r"] = colors.r, ["g"] = colors.g, ["b"] = colors.b }
				end
			end
			
		end
	end
end

Core.UpdateModuleCategories = Core.UpdateModuleCategoryColors

do
	local RaidNotice_AddMessage = _G.RaidNotice_AddMessage
	local RaidWarningFrame = _G.RaidWarningFrame
	local DEFAULT_CHAT_FRAME = _G.DEFAULT_CHAT_FRAME
	local format = _G.format
	local lastMsg, lastTime = "", GetTime()
	local SendChatMessage = _G.SendChatMessage
	local IsAddOnLoaded = _G.IsAddOnLoaded
	local ICON_TAG_LIST = _G.ICON_TAG_LIST
	local ICON_LIST = _G.ICON_LIST
	local ParseClasses
	do
		local RAID_CLASS_COLORS = _G.RAID_CLASS_COLORS
		local UnitClass = _G.UnitClass
		local classLst
		ParseClasses = function(arg)
			if not classLst then
				classLst = {}
			end
			for name in arg:gmatch("{(.-)}") do
				local class = classLst[name] or select(2, UnitClass(name))	-- only get the class once
				if class then
					if not classLst[name] then classLst[name] = class end
					
					if RAID_CLASS_COLORS[class] and RAID_CLASS_COLORS[class].hex then
						arg = arg:gsub(name, RAID_CLASS_COLORS[class].hex..name.."|r")
					end
				end
			end
			return arg
		end
	end
	
	function Core:ShowAlert(priority, ...)
		if Profile.ShowAlerts and Profile.AlertColors[priority] and ... then
			local msg = format(...)
			local now = GetTime()
			local icon
			local num = select(-1, ...)
			if Profile.ShowIcons and type(num) == "number" then
				icon = Icons[num]
				msg = "|T"..icon..":"..Profile.AlertIconSize..":"..Profile.AlertIconSize..":-5|t"..msg
			end
			if msg:find("{(.-)}") then
				if Profile.UseClassColors then
					msg = ParseClasses(msg)
				end
				msg = msg:gsub("{", ""):gsub("}", "")
			end
			if Profile.UseSkull and msg:find("*") then
				msg = msg:gsub("*", L["{Skull}"])
				for tag in msg:gmatch("%b{}") do
					local term = tag:gsub("[{}]", ""):lower()
					if ICON_TAG_LIST[term] and ICON_LIST[ICON_TAG_LIST[term]] then	-- this was poorly written blizz.  I am ashamed.
						msg = msg:gsub(tag, ICON_LIST[ICON_TAG_LIST[term]].."0|t")
					end
				end
			end

			if lastMsg ~= msg or lastTime < now then
				-- Send to Sink
				local ct = Profile.AlertColors[priority]
				self:Pour(msg, ct.r, ct.g, ct.b, nil, nil, "OUTLINE", true)
				lastMsg = msg
				lastTime = now + 1
			end
		end
	end

	function Core:SendAlertMessage(msg, icon)
		if Profile.SendRaidWarnings then
			SendChatMessage(msg, "RAID_WARNING")
		end
		if Profile.SendChatWarnings then
			if _G.UnitInRaid("player") then
				SendChatMessage(msg, "RAID")
			else
				SendChatMessage(msg, "PARTY")
			end
		end
	end
end
do		-- Credits for this goes to BigWigs.
	local anchor
	function Core:CreateMessageFrame()
		if rbmMsgFrame then return end
		rbmMsgFrame = CreateFrame("MessageFrame", "rbmMsgFrame", UIParent)
		rbmMsgFrame:SetWidth(Profile.MsgFrame.MsgWidth)
		rbmMsgFrame:SetHeight(Profile.MsgFrame.MsgHeight)

		if not anchor then self:SetupMessageFrame() end
		rbmMsgFrame:SetPoint("TOP", anchor, "BOTTOM", 0, 0)
		rbmMsgFrame:SetScale(1)
		rbmMsgFrame:SetInsertMode("TOP")
		rbmMsgFrame:SetFrameStrata("HIGH")
		rbmMsgFrame:SetToplevel(true)
		rbmMsgFrame:SetJustifyH(Profile.MsgFrame.MsgJustify)
		if Profile.MsgFrame.MsgFont then
			rbmMsgFrame:SetFont(MediaHandler:Fetch("font", Profile.MsgFrame.MsgFont), Profile.MsgFrame.MsgFontSize, Profile.MsgFrame.MsgOutline)
		else
			rbmMsgFrame:SetFontObject("GameFontNormalLarge")
		end
		if Profile.MsgFrame.MsgUseShadowColor then
			local c = Profile.MsgFrame.MsgShadowColor
			rbmMsgFrame:SetShadowColor(c.r, c.g, c.b, c.a)
			rbmMsgFrame:SetShadowOffset(Profile.MsgFrame.MsgShadowOffsetX, Profile.MsgFrame.MsgShadowOffsetY)
		end
		rbmMsgFrame:SetTimeVisible(Profile.MsgFrame.TimeVis)
		rbmMsgFrame:SetFadeDuration(Profile.MsgFrame.FadeDur)
		rbmMsgFrame:Show()
	end

	function Core:MsgFrameAddMessage(_, msg, color, g, b)
		if _G.type(color) == "table" then
			rbmMsgFrame:AddMessage(msg, color.r, color.g, color.b)
		else
			rbmMsgFrame:AddMessage(msg, color, g, b)
		end
	end
	--/script RBM:RegisterSink("RBM", "RBM", "RBM Custom Frame", function(...) RBM:MsgFrameAddMessage(...) end, nil, nil)	
	--/script RBM:RegisterSink("RBM", "RBM", "RBM Custom Frame", "MsgFrameAddMessage", nil, nil)	
	function Core:UpdateMsgFrameSettings()
		rbmMsgFrame:SetTimeVisible(Profile.MsgFrame.TimeVis)
		rbmMsgFrame:SetFadeDuration(Profile.MsgFrame.FadeDur)
		if Profile.MsgFrame.MsgFont then
			rbmMsgFrame:SetFont(MediaHandler:Fetch("font", Profile.MsgFrame.MsgFont), Profile.MsgFrame.MsgFontSize, Profile.MsgFrame.MsgOutline)
		else
			rbmMsgFrame:SetFontObject("GameFontNormalLarge")
		end
		rbmMsgFrame:SetJustifyH(Profile.MsgFrame.MsgJustify)
		rbmMsgFrame:SetWidth(Profile.MsgFrame.MsgWidth)
		rbmMsgFrame:SetHeight(Profile.MsgFrame.MsgHeight)
		if Profile.MsgFrame.MsgUseShadowColor then
			local c = Profile.MsgFrame.MsgShadowColor
			rbmMsgFrame:SetShadowColor(c.r, c.g, c.b, c.a)
			rbmMsgFrame:SetShadowOffset(Profile.MsgFrame.MsgShadowOffsetX, Profile.MsgFrame.MsgShadowOffsetY)
		end
		--rbmMsgFrame:SetBackdropColor(unpack(Profile.MsgFrame.MsgHeight))
		anchor:SetWidth(Profile.MsgFrame.MsgWidth)
	end	
	
	function Core:SetupMessageFrame()
		if anchor then return end

		anchor = CreateFrame("Frame", "RBMMessageFrameAnchor", UIParent)
		anchor:Hide()

		anchor:SetWidth(Profile.MsgFrame.MsgWidth or 512)
		anchor:SetHeight(40)
		
		anchor:SetBackdrop({
					bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
					edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
					tile = true,
					tileSize = 8,
					edgeSize = 8,
					insets = { left = 2, right = 2, top = 2, bottom = 2 }
					})

		anchor:SetBackdropColor(24/255, 24/255, 24/255)
		anchor:ClearAllPoints()
		anchor:SetPoint("TOP", UIParent, "TOP", 0, -150)
		anchor:EnableMouse(true)
		anchor:SetClampedToScreen()
		anchor:RegisterForDrag("LeftButton")
		anchor:SetMovable(true)
		anchor:SetScript("OnDragStart", function(self) self:StartMoving() end)
		anchor:SetScript("OnDragStop", function(self)
			self:StopMovingOrSizing()
			Core:SetMessageAnchorPosition()
		end)

		local cheader = anchor:CreateFontString(nil,"OVERLAY")
		cheader:ClearAllPoints()
		cheader:SetWidth(110)
		cheader:SetHeight(15)
		cheader:SetPoint("TOP", anchor, "TOP")
		cheader:SetFontObject("GameFontNormalSmall")
		cheader:SetJustifyH("CENTER")
		cheader:SetText(L["Messages"])
		cheader:SetShadowOffset(.8, -.8)
		cheader:SetShadowColor(0, 0, 0, 1)

		local closebutton = CreateFrame("Button", nil, anchor, "UIPanelCloseButton")
		closebutton:SetWidth(16)
		closebutton:SetHeight(16)
		closebutton:SetPoint("TOPRIGHT", anchor, "TOPRIGHT")
		closebutton:SetScript("OnClick", function() anchor:Hide() end)

		local testbutton = CreateFrame("Button", nil, anchor, "UIPanelButtonTemplate")
		testbutton:SetWidth(35)
		testbutton:SetHeight(16)
		testbutton:SetText(L["Test"])
		testbutton:SetPoint("BOTTOM", anchor, "BOTTOM", 0, 2)
		testbutton:SetScript("OnClick", function()  
			local num = _G.math.random(1,5)
			local msg
			if num == 1 then
				msg = "Test Message"
			elseif num == 2 then
				msg = "*** Test Raid Warning ***"
			elseif num == 3 then
				msg = "OMG ITS A TRAP!"
			elseif num == 4 then
				msg = "This is a very long test warning don't you think?"
			elseif num == 5 then
				msg = "*** PORTAL IN: ~5 SECONDS! ***"
			end
			rbmMsgFrame:AddMessage(msg) 
		end)

		self:RestoreMessageFramePos()
	end
	
	function Core:SetMessageAnchorPosition()
		if not anchor then self:SetupMessageFrame() end

		local s = anchor:GetEffectiveScale()

		Profile.MsgFrame.PosX = anchor:GetLeft() * s
		Profile.MsgFrame.PosY = anchor:GetTop() * s
	end
	
	function Core:ResetMessageFrame()
		if not anchor then self:SetupMessageFrame() end

		anchor:ClearAllPoints()
		anchor:SetPoint("TOP", UIParent, "TOP", 0, -150)
		Profile.MsgFrame.PosX = nil
		Profile.MsgFrame.PosY = -150
	end
	
	function Core:RestoreMessageFramePos()
		if not anchor then self:SetupMessageFrame() end

		local x = Profile.MsgFrame.PosX
		local y = Profile.MsgFrame.PosY

		if x and y then
			local s = anchor:GetEffectiveScale()
			anchor:ClearAllPoints()
			anchor:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", x/s, y/s)
		else
			self:ResetMessageFrame()
		end
	end
end

do
	local WorldFrame = _G.WorldFrame
	local anchors
	local shaking, flashing
	local flashFrame, shakeFrame
	function Core:ShakeScreen(...)
		if shaking or not Profile.AllowScreenShake then
			return
		end
		if ... then
			local match = false
			for i=1, select("#", ...) do
				local filter = select(i, ...)
				if filter == playerClass or filter == playerName then
					match = true
					break
				end
			end
			if not match then
				return
			end
		end
		if not shakeFrame then
			shakeFrame = CreateFrame("Frame")
			local random = _G.math.random
			local update = .015
			shakeFrame:SetScript("OnUpdate", function(this, delta)
				update = update - delta
				if update < 0 then
					update = .015
				else
					return
				end
				shaking = shaking - delta
				local xOff, yOff = 0, 0
				if shaking < 0 then
					shaking = nil
					this:Hide()
				else
					local intensity = Profile.ShakeIntensity
					xOff, yOff = random(-intensity, intensity), random(-intensity, intensity)
				end
				WorldFrame:ClearAllPoints()
				for i, anchor in ipairs(anchors) do
					WorldFrame:SetPoint(anchor.anchor, anchor.relativeTo, anchor.relativeAnchor, anchor.xOffset + xOff, anchor.yOffset + yOff)
				end
			end)
		end
		if not anchors then
			anchors = {}
		end

		local numPoints = WorldFrame:GetNumPoints()
		for i=1, numPoints do
			local anchor = anchors[i]
			if not anchor then
				anchor = {}
				anchors[i] = anchor
			end
			anchor.anchor, anchor.relativeTo, anchor.relativeAnchor, anchor.xOffset, anchor.yOffset = WorldFrame:GetPoint(i)
		end
		for i=numPoints + 1, #anchors do --it's unlikely that the points on the frame will differ between shakes, so i don't feel bad about not recycling the tables
			anchors[i] = nil
		end

		shaking = Profile.ShakeDuration
		shakeFrame:Show()
	end
	function Core:WarningFlash(r, g, b, ...)
		if flashing or not Profile.AllowFlashFrame then
			return
		end
		if ... then
			local match = false
			for i=1, select("#", ...) do
				local filter = select(i, ...)
				if filter == playerClass or filter == playerName then
					match = true
					break
				end
			end
			if not match then
				return
			end
		end
		if not flashFrame then
			local f = CreateFrame("Frame")
			f:SetScript("OnUpdate", function(this, delta)
				flashing = flashing - delta
				if flashing < 0 then
					flashing = nil
					this:Hide()
				else
					local percentComplete = (Profile.FlashDuration - flashing) / Profile.FlashDuration
					if percentComplete < .25 then
						flashFrame:SetAlpha(percentComplete)
					else
						flashFrame:SetAlpha(1 - percentComplete)
					end
				end
			end)
			f:SetFrameStrata("BACKGROUND")
			f:SetBackdrop{bgFile = [[Interface/Tooltips/UI-Tooltip-Background]]}
			f:SetAllPoints(_G.UIParent)
			flashFrame = f
		end
		flashFrame:SetBackdropColor(r or .9, g or .1, b or .1)
		flashing = Profile.FlashDuration
		flashFrame:Show()
	end
end



function Core:ShowWelcomeFrame()
	LibStub("AceConfigDialog-3.0"):Close("RBM")
	local f = CreateFrame("Frame", "RBM_FirstRun", _G.UIParent)
	f:EnableMouse(true)
	f:SetMovable(true)
	f:SetScript("OnMouseDown", f.StartMoving)
	f:SetScript("OnMouseUp", f.StopMovingOrSizing)

	local close = CreateFrame("Button", nil, f, "UIPanelCloseButton")
	close:SetPoint("TOPRIGHT", f, "TOPRIGHT")
	close:SetScript("OnClick", function() f:Hide() end)

	local title = f:CreateFontString()
	title:SetFontObject("GameFontNormal")
	title:SetPoint("TOP", f, "TOP", 0, 5)
	title:SetText(L["Welcome to RBM"])

	local fs = f:CreateFontString()
	fs:SetFontObject("GameFontHighlight")
	fs:SetPoint("TOPLEFT", f, "TOPLEFT", 16, -32)
	fs:SetPoint("BOTTOMRIGHT", f, "BOTTOMRIGHT", -16, 16)
	fs:SetJustifyV("TOP")

	fs:SetText(L["Welcome screen intro"])

	f:SetHeight(500)
	f:SetWidth(400)
	f:SetPoint("CENTER", 0, 0)
	f:SetBackdrop{bgFile = MediaHandler:Fetch("background", "Blizzard Tooltip"), edgeFile = MediaHandler:Fetch("border", "RothSquare"), edgeSize=16}
	f:SetBackdropColor(0, 0, 0)

	local b = CreateFrame("Button", nil, f, "UIPanelButtonTemplate2")
	b:SetScript("OnMouseDown", nil)
	b:SetScript("OnMouseUp", nil)
	b:SetScript("OnClick", function()
		f:Hide()
		self:CreateDefaultFrames()
		LibStub("AceConfigDialog-3.0"):Open("RBM")
	end)
	b:SetPoint("BOTTOM", 0, 10)
	b:SetText(L["Get me started with default frames!"])
	b:SetWidth(b:GetFontString():GetWidth() + 25)
	b:SetHeight(30)
end

function Core:CreateDefaultFrames()
	local short = self:NewBarFrame(L["Short Bars"])
	if short then
		local db = short.db.profile
		db.Xoffset = _G.GetScreenWidth() / 2 + db.Width
		short:UpdateAnchor()
		db.ByMaxLength = true
		db.MaxLength = 15
		db.TransferAboveTo = L["Long Bars"]
		db.TransferAboveByTime = true
		db.TransferAboveTime = 15

		db.CategoriesList["Boss Abilities"].Buff = true
		db.CategoriesList["Boss Abilities"].Cast = true
		db.CategoriesList["Boss Abilities"].Cooldown = true
		db.CategoriesList["Boss Abilities"].Debuff = true
		db.CategoriesList["Boss Abilities"].Count = false
		db.CategoriesList["Boss Abilities"].Timeless = false
	end
	local long = self:NewBarFrame(L["Long Bars"])
	if long then
		local db = long.db.profile
		db.Xoffset = _G.GetScreenWidth() / 2 - db.Width
		long:UpdateAnchor()
		db.ByMinLength = true
		db.MinLength = 15
		db.TransferBelowTo = L["Short Bars"]
		db.TransferBelowByTime = true
		db.TransferBelowTime = 15
	end
end
do
	local GetNumRaidMembers = _G.GetNumRaidMembers
	local CheckInteractDistance = _G.CheckInteractDistance
	local UnitIsDeadOrGhost = _G.UnitIsDeadOrGhost
	local UnitName = _G.UnitName
	local UnitHealth = _G.UnitHealth
	local UnitHealthMax = _G.UnitHealthMax
	local UnitExists = _G.UnitExists
	local UnitBuff = _G.UnitBuff
	local HealthFrame_HP = 1000
	local healthDragFrame, healthMainFrame, healthFramePlayer, healthUpdateTimer

	local function GetBuff(unit, buff)
		if not UnitExists(unit) then return nil end

		local i = 1
		while UnitBuff(unit, i) ~= nil do
			if UnitBuff(unit, i) == buff then
				return i
			end
			i = i + 1
		end
	end
	
	local function updateHealthFrame()
		local x = 1
		for i=1, GetNumRaidMembers(), 1 do
			if x <= 6 and UnitHealth("raid"..i) and UnitHealth("raid"..i) <= HealthFrame_HP  and not UnitIsDeadOrGhost("raid"..i) then
				local shield = "|cffff2020"
				if GetBuff("raid"..i, L["Power Word: Shield"]) or GetBuff("raid"..i, L["Frost Ward"]) or GetBuff("raid"..i, L["Fel Blossom"]) or GetBuff("raid"..i, L["Divine Shield"]) then
					shield = "|cff20ff20"
				end
				if healthFramePlayer[x] then
					healthFramePlayer[x]:SetText(shield..UnitName("raid"..i)..": -"..(HealthFrame_HP - UnitHealth("raid"..i)).."|r")
				end
				x = x + 1
			end
		end
		
		if (x <= 6) then
			for i=x, 6, 1 do
				if healthFramePlayer[i] then
					healthFramePlayer[i]:SetText("")
				end
			end
		end
	end

	--[[
	Arguments:
		number - How much missing hp to check for
	Notes:
		*Creates a frame that shows players under a certain health
	]]--
	function Core:HealthFrameCreate(health)
		if health then
			HealthFrame_HP = health
		end
		if healthDragFrame then return end
		
		healthDragFrame = CreateFrame("Frame", nil, UIParent)
		healthDragFrame:SetWidth(110)
		healthDragFrame:SetHeight(13)
		healthDragFrame:SetBackdrop({
			bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
			edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
				tile = true,
				tileSize = 8,
				edgeSize = 8,
				insets = { left = 2, right = 2, top = 2, bottom = 2 }
			})
		healthDragFrame:SetBackdropColor(0, 0, 0)
		healthDragFrame:SetMovable()
		healthDragFrame:EnableMouse()
		healthDragFrame:RegisterForDrag("LeftButton")
		healthDragFrame:SetClampedToScreen()
		if Profile.HealthPos.set then
			healthDragFrame:SetPoint(Profile.HealthPos.anchor, nil, Profile.HealthPos.anchor, Profile.HealthPos.x, Profile.HealthPos.y)
		else
			healthDragFrame:SetPoint("CENTER")
		end
		healthDragFrame.text = healthDragFrame:CreateFontString(nil, "OVERLAY")
		healthDragFrame.text:SetPoint("CENTER")
		healthDragFrame.text:SetFont("Fonts\\FRIZQT__.TTF", 8, "OUTLINE")
		healthDragFrame.text:SetText("Health(-"..HealthFrame_HP..")")
		healthDragFrame.text:SetTextColor(1, 1, 1)
		-- dragging
		healthDragFrame:SetScript("OnDragStart", function(self)
			self:StartMoving()
		end)
		healthDragFrame:SetScript("OnDragStop", function(self)
		  self:StopMovingOrSizing()
		  self:SetUserPlaced(true)
		  local point, relativeTo, relativePoint, xOfs, yOfs = self:GetPoint()
		  Profile.HealthPos.set = true
		  Profile.HealthPos.x = xOfs
		  Profile.HealthPos.y = yOfs
		  Profile.HealthPos.anchor = point
		end)

		healthMainFrame = CreateFrame("Frame", nil, UIParent)
		healthMainFrame:SetHeight(65)
		healthMainFrame:SetWidth(110)
		healthMainFrame:SetPoint("TOPLEFT", healthDragFrame, 0, -13)
		healthMainFrame:SetBackdrop({
				bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
				edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
				tile = true,
				tileSize = 8,
				edgeSize = 8,
				insets = { left = 2, right = 2, top = 2, bottom = 2 }
				})
		healthMainFrame:SetClampedToScreen()
		healthMainFrame:EnableMouse()
		healthMainFrame:SetMovable()
		healthMainFrame:SetBackdropColor(.5, .5, .5)
		healthFramePlayer = {}
		for i=1,6,1 do
			healthFramePlayer[i] = healthMainFrame:CreateFontString(nil, "OVERLAY")
			if i == 1 then
				healthFramePlayer[i]:SetPoint("TOP", 0, -2)
			else
				healthFramePlayer[i]:SetPoint("TOP", 0, ((i-1) * -10)-2)
			end
			healthFramePlayer[i]:SetFontObject("GameFontNormal")
			healthFramePlayer[i]:SetText("")
			healthFramePlayer[i]:SetTextColor(1, 1, 1)
		end
		healthMainFrame:Hide()
		healthDragFrame:Hide()
	end

	--[[
	Arguments:
		none
	Notes:
		*Hides the health frame
	]]--
	function Core:HealthFrameHide()
		if healthDragFrame then
			healthDragFrame:Hide()
			healthMainFrame:Hide()
		end
		if healthUpdateTimer then
			self:CancelTimer(healthUpdateTimer)
			healthUpdateTimer = nil
		end
	end
	--[[
	Arguments:
		number = Health to set the checking too. (optional)
	Notes:
		*Shows the health frame
	]]--
	function Core:HealthFrameShow(health)
		if health then
			HealthFrame_HP = health
			healthDragFrame.text:SetText("Health(-"..HealthFrame_HP..")")
		end
		healthDragFrame:Show()
		healthMainFrame:Show()
		healthUpdateTimer = self:ScheduleRepeatingTimer(updateHealthFrame, 0.5)
	end

	--[[
	Arguments:
		none
	Notes:
		*Removes the health frame
	]]--
	function Core:HealthFrameRemove()
		self:HealthFrameHide()
	end


	------------------------ Proximity Frame
	----------------------------------------
	
	local rangeDragFrame, rangeMainFrame, rangeFramePlayer, rangeUpdateTimer
	local RangeFrame_Distance = 10
	local RangeFrame_BandageAlert = true
	local function DistanceFrameGetRange(unit)
		if RangeFrame_Distance == 10 then return CheckInteractDistance(unit, 3)
		elseif RangeFrame_Distance == 11 then return CheckInteractDistance(unit, 2)
		elseif RangeFrame_Distance == 30 then return CheckInteractDistance(unit, 1)
		elseif RangeFrame_Distance == 15 then 
			if IsItemInRange(L["Heavy Neatherweave Bandage"], unit) == 1 then
				return true
			end
		end
		return false
	end
	
	local function updateRangeFrame()
		local x = 1
		for i=1, GetNumRaidMembers(), 1 do
			if (x <= 5 and DistanceFrameGetRange("raid"..i) and not UnitIsDeadOrGhost("raid"..i) and UnitName("raid"..i) ~= UnitName("player")) then
				if rangeFramePlayer[x] then
					rangeFramePlayer[x]:SetText(UnitName("raid"..i))
				end
				x = x + 1
			end
		end
		
		if x <= 5 then
			for i=x, 5, 1 do
				if rangeFramePlayer[i] then
					rangeFramePlayer[i]:SetText("")
				end
			end
		end
	end
	--[[
	Arguments:
		number - 10, 11, 30, 15 (all in yards)
	Notes:
		*Creates a frame that shows players within a certain distance
	]]--
	function Core:DistanceFrameCreate(distance)
		if distance then
			RangeFrame_Distance = distance
		end
		if rangeDragFrame then return end
		
		rangeDragFrame = CreateFrame("Frame", nil, UIParent)
		rangeDragFrame:SetWidth(110)
		rangeDragFrame:SetHeight(13)
		rangeDragFrame:SetBackdrop({
			bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
			edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
				tile = true,
				tileSize = 8,
				edgeSize = 8,
				insets = { left = 2, right = 2, top = 2, bottom = 2 }
			})
		rangeDragFrame:SetBackdropColor(0, 0, 0)
		rangeDragFrame:SetMovable()
		rangeDragFrame:EnableMouse()
		rangeDragFrame:RegisterForDrag("LeftButton")
		rangeDragFrame:SetClampedToScreen()
		if Profile.DistancePos.set then
			rangeDragFrame:SetPoint(Profile.DistancePos.anchor, nil, Profile.DistancePos.anchor, Profile.DistancePos.x, Profile.DistancePos.y)
		else
			rangeDragFrame:SetPoint("CENTER")
		end
		rangeDragFrame.text = rangeDragFrame:CreateFontString(nil, "OVERLAY")
		rangeDragFrame.text:SetPoint("CENTER")
		rangeDragFrame.text:SetFontObject("GameFontNormalSmall")
		rangeDragFrame.text:SetText("Range("..RangeFrame_Distance.." yards)")
		rangeDragFrame.text:SetTextColor(1, 1, 1)
		-- dragging
		rangeDragFrame:SetScript("OnDragStart", function(self)
			self:StartMoving()
		end)
		rangeDragFrame:SetScript("OnDragStop", function(self)
		  self:StopMovingOrSizing()
		  self:SetUserPlaced(true)
		  local point, relativeTo, relativePoint, xOfs, yOfs = self:GetPoint()
		  Profile.DistancePos.set = true
		  Profile.DistancePos.x = xOfs
		  Profile.DistancePos.y = yOfs
		  Profile.DistancePos.anchor = point
		end)
		rangeMainFrame = CreateFrame("Frame", nil, UIParent)
		rangeMainFrame:SetHeight(65)
		rangeMainFrame:SetWidth(110)
		rangeMainFrame:SetPoint("TOPLEFT", rangeDragFrame, 0, -13)
		rangeMainFrame:SetBackdrop({
				bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
				edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
				tile = true,
				tileSize = 8,
				edgeSize = 8,
				insets = { left = 2, right = 2, top = 2, bottom = 2 }
				})
		rangeMainFrame:SetClampedToScreen()
		rangeMainFrame:EnableMouse()
		rangeMainFrame:SetMovable()
		rangeMainFrame:SetBackdropColor(.5, .5, .5)
		rangeFramePlayer = {}
		for i=1,5,1 do
			rangeFramePlayer[i] = rangeMainFrame:CreateFontString(nil, "OVERLAY")
			if i == 1 then
				rangeFramePlayer[i]:SetPoint("TOP", 0, -2)
			else
				rangeFramePlayer[i]:SetPoint("TOP", 0, ((i-1) * -12)-2)
			end
			rangeFramePlayer[i]:SetFontObject("GameFontNormal")
			rangeFramePlayer[i]:SetText("")
			rangeFramePlayer[i]:SetTextColor(1, 1, 1)
		end
		rangeMainFrame:Hide()
		rangeDragFrame:Hide()
	end
	
	--[[
	Notes:
		*Hides the distance frame
	]]--
	function Core:DistanceFrameHide()
		if rangeDragFrame then
			rangeDragFrame:Hide()
			rangeMainFrame:Hide()
		end
		if rangeUpdateTimer then
			self:CancelTimer(rangeUpdateTimer)
			rangeUpdateTimer = nil
		end
	end

	--[[
	Arguments:
		number = Distance to set the checking too. (optional)
	Notes:
		*Shows the distance frame
	]]--
	function Core:DistanceFrameShow(distance)
		if distance then
			RangeFrame_Distance = distance
			if distance == 15 then
				if (not IsItemInRange(L["Heavy Neatherweave Bandage"], "player") == 1) and not UnitIsDeadOrGhost("player") then
					if RangeFrame_BandageAlert then
						self:Alert("High", L["Error while setting the proximity frame to 15 yards. You must have a Heavy Netherweave Bandage with you."])
						self:print(L["Error while setting the proximity frame to 15 yards. You must have a Heavy Netherweave Bandage with you."])
						RangeFrame_BandageAlert = false
					end
				end
			end
		end
		rangeDragFrame:Show()
		rangeMainFrame:Show()
		rangeUpdateTimer = self:ScheduleRepeatingTimer(updateRangeFrame, 0.5)
	end

	--[[
	Notes:
		*Hides the distance frame.
	]]--
	function Core:DistanceFrameRemove()
		self:DistanceFrameHide()
	end
end