if not RBM then	return end

local GetPlayerBuffName = GetPlayerBuffName
local GetPlayerBuffTexture = GetPlayerBuffTexture
local next = next
local setmetatable = setmetatable
local type = type
local GetRealZoneText = GetRealZoneText
local GetSpellTexture = GetSpellTexture
local GetSpellInfo = GetSpellInfo
local GetSpellLink = GetSpellLink
local playerClass = select(2, UnitClass("player"))
local playerName = UnitName("player")


local hiddenCooldowns, completedScan, interrupts, sharedCooldowns, cooldownEnders, infiniteDurations, spellIcons, spellCooldowns, itemCooldowns
local spellIDLst = {}

local module = RBM:NewPlugin("Cooldown Watch", "AceBucket-3.0")

local L = module:GetTranslations()

module:RegisterTranslations("enUS", -- translation automatically generated
	"Announce interrupt", true,
	"Announce other skills", true,
	"AnnounceInterrupts", true,
	"AnnounceOthers", true,
	"Cooldowns", true,
	"General skill cooldowns.", true,
	"Hidden Cooldowns", true,
	"Interrupt bars will be announced to the group.", true,
	"Interrupts", true,
	"Items or abilities with hidden cooldowns.", true,
	"Other skills", true,
	"Other skills with cooldowns to track.", true,
	"Skill cooldowns that should be announced to your group. A skill must be tracked before it can be announced.", true,
	"Skills or spells that interrupt spell casting.", true,
	"Track hidden cooldowns", true,
	"Track hidden cooldown buffs", true,
	"Track interrupt cooldowns", true,
	"TrackHiddenCD", true,
	"TrackHiddenCDBuffs", true,
	"TrackInterrupts", true,
	"TrackOthers", true,
	"Tracks hidden cooldowns on items such as Scarab of the Infinite Cycle or Hourglass of the Unraveller.", true,
	"Tracks buffs from items that have hidden cooldowns such as Scarab of the Infinite Cycle or Hourglass of the Unraveller.", true,
	"Tracks interrupt cooldowns such as Kick or Counterspell.", true,
	"^(%S+) min cooldown", true,
	"^(%S+) sec cooldown", true,
	"Item Cooldowns", true,
	"Items with an unhidden cooldown.", true,
	"Food & Drink", true,
	"Elixir", true,
	"Flask", true,
	"Item Enchantment", true,
	"Scroll", true,
	"Quest", true,
	"Pet", true,
	"Holiday", true,
	"Mount", true,
	"Junk", true,
	"Other", true,
	"Bandage", true,
	"Track item cooldowns", true,
	"Tracks cooldowns from items that do not have a hidden cooldown.", true,
	"Track Items", true,
	"Select which item cooldowns you wish to track", true,
	-- spell shit
	"Traps", true,
	"Stance Ultimates", true,
	"Shocks", true,
	"Show Name", true,
	"Potions", true,
	"Healthstones", true,
	"Drums", true,
	"Toggle showing your name on cooldown bars.", true,
	"Select All", true
)

module:RegisterTranslations("zhCN", -- translation automatically generated
	"Announce interrupt", "警报打断",
	"Announce other skills", "警报其他技能",
	"AnnounceInterrupts", "警报打断",
	"AnnounceOthers", "警报其他",
	"Cooldowns", "冷却",
	"General skill cooldowns.", "综合技能冷却",
	"Hidden Cooldowns", "隐藏冷却",
	"Interrupt bars will be announced to the group.", "打断计时将被通报到小队",
	"Interrupts", "打断",
	"Items or abilities with hidden cooldowns.", "物品",
	"Other skills", "其他技能",
	"Other skills with cooldowns to track.", "其他有冷却时间的技能",
	"Skill cooldowns that should be announced to your group. A skill must be tracked before it can be announced.", "需要通报到小队的技能冷却。在通报一个技能前必须先进行追踪。",
	"Skills or spells that interrupt spell casting.", "打断施法的技能或法术。",
	"Track hidden cooldowns", "追踪隐藏冷却",
	"Track hidden cooldown buffs", "追踪隐藏的增益冷却",
	"Track interrupt cooldowns", "追踪打断冷却",
	"TrackHiddenCD", "追踪隐藏冷却",
	"TrackHiddenCDBuffs", "追踪隐藏的增益冷却",
	"TrackInterrupts", "追踪打断冷却",
	"TrackOthers", "追踪其他",
	"Tracks hidden cooldowns on items such as Scarab of the Infinite Cycle or Hourglass of the Unraveller.", "追踪物品的隐藏冷却，例如无尽循环甲虫或分解者的沙漏。",
	"Tracks buffs from items that have hidden cooldowns such as Scarab of the Infinite Cycle or Hourglass of the Unraveller.", "追踪带有内置隐藏冷却的物品的buff，例如无尽循环甲虫或分解者的沙漏。",
	"Tracks interrupt cooldowns such as Kick or Counterspell.", "追踪打断技能冷却，例如脚踢和法术反制。",
	"^(%S+) min cooldown", "^(%S+)分钟冷却剩余",
	"^(%S+) sec cooldown", "^(%S+)秒冷却剩余",
	"Item Cooldowns", "物品冷却",
	"Items with an unhidden cooldown.", "有非隐藏冷却时间的物品",
	"Food & Drink", "食物和饮料",
	"Elixir", "药剂",
	"Flask", "合剂",
	"Item Enchantment", "物品强化",
	"Scroll", "卷轴",
	"Quest", "任务",
	"Pet", "宠物",
	"Holiday", "节日",
	"Mount", "坐骑",
	"Junk", "垃圾",
	"Other", "其它",
	"Bandage", "绷带",
	"Track item cooldowns", "追踪物品冷却",
	"Tracks cooldowns from items that do not have a hidden cooldown.", "追踪那些冷却时间不隐藏的物品的冷却。",
	"Track Items", "追踪物品",
	"Select which item cooldowns you wish to track", "选择要追踪的物品冷却",
	-- spell shit
	"Traps", "陷阱",
	"Stance Ultimates", "姿态终极技能",
	"Shocks", "真机",
	"Show Name", "显示名称",
	"Potions", "药水",
	"Healthstones", "治疗石",
	"Drums", "鼓",
	"Toggle showing your name on cooldown bars.", "在冷却计时条上显示你的名字。",
	"Select All", "全选"
)

module:RegisterTranslations("zhTW", -- translation automatically generated
	"Announce interrupt", "警報打斷",
	"Announce other skills", "警報其他技能",
	"AnnounceInterrupts", "警報打斷",
	"AnnounceOthers", "警報其他",
	"Cooldowns", "冷卻",
	"General skill cooldowns.", "綜合技能冷卻",
	"Hidden Cooldowns", "隱藏冷卻",
	"Interrupt bars will be announced to the group.", "打斷計時將被通報到小隊",
	"Interrupts", "打斷",
	"Items or abilities with hidden cooldowns.", "物品",
	"Other skills", "其他技能",
	"Other skills with cooldowns to track.", "其他有冷卻時間的技能",
	"Skill cooldowns that should be announced to your group. A skill must be tracked before it can be announced.", "需要通報到小隊的技能冷卻。在通報一個技能前必須先進行追蹤。",
	"Skills or spells that interrupt spell casting.", "打斷施法的技能或法術。",
	"Track hidden cooldowns", "追蹤隱藏冷卻",
	"Track hidden cooldown buffs", "追蹤隱藏的增益冷卻",
	"Track interrupt cooldowns", "追蹤打斷冷卻",
	"TrackHiddenCD", "追蹤隱藏冷卻",
	"TrackHiddenCDBuffs", "追蹤隱藏的增益冷卻",
	"TrackInterrupts", "追蹤打斷冷卻",
	"TrackOthers", "追蹤其他",
	"Tracks hidden cooldowns on items such as Scarab of the Infinite Cycle or Hourglass of the Unraveller.", "追蹤物品的隱藏冷卻，例如無盡迴圈寶石或破壞者沙漏。",
	"Tracks buffs from items that have hidden cooldowns such as Scarab of the Infinite Cycle or Hourglass of the Unraveller.", "追蹤帶有內置隱藏冷卻的物品的buff，例如無盡迴圈寶石或破壞者沙漏。",
	"Tracks interrupt cooldowns such as Kick or Counterspell.", "追蹤打斷技能冷卻，例如腳踢和法術反制。",
	"^(%S+) min cooldown", "^(%S+)分鐘冷卻剩餘",
	"^(%S+) sec cooldown", "^(%S+)秒冷卻剩餘",
	"Item Cooldowns", "物品冷卻",
	"Items with an unhidden cooldown.", "有非隱藏冷卻時間的物品",
	"Food & Drink", "食物和飲料",
	"Elixir", "藥劑",
	"Flask", "精煉藥劑",
	"Item Enchantment", "物品強化",
	"Scroll", "卷軸",
	"Quest", "任務",
	"Pet", "寵物",
	"Holiday", "節日",
	"Mount", "坐騎",
	"Junk", "垃圾",
	"Other", "其他",
	"Bandage", "繃帶",
	"Track item cooldowns", "追蹤物品冷卻",
	"Tracks cooldowns from items that do not have a hidden cooldown.", "追蹤那些冷卻時間不隱藏的物品的冷卻。",
	"Track Items", "追蹤物品",
	"Select which item cooldowns you wish to track", "選擇要追蹤的物品冷卻",
	-- spell shit
	"Traps", "陷阱",
	"Stance Ultimates", "姿態終極技能",
	"Shocks", "真機",
	"Show Name", "顯示名稱",
	"Potions", "藥水",
	"Healthstones", "治療石",
	"Drums", "鼓",
	"Toggle showing your name on cooldown bars.", "在冷卻計時條上顯示你的名字。",
	"Select All", "全選"
)

module:RegisterTranslations("koKR",
	"Announce interrupt", "방해 알림",
	"Announce other skills", "다른 스킬 알림",
	"AnnounceInterrupts", "방해 알림",
	"AnnounceOthers", "다른 알림",
	"Cooldowns", "재사용 대기시간",
	"General skill cooldowns.", "일반 스킬 재사용 대기시간",
	"Hidden Cooldowns", "숨겨진 재사용 대기시간",
	"Interrupt bars will be announced to the group.", "그룹에 방해 바를 알립니다.",
	"Interrupts", "방해",
	"Items or abilities with hidden cooldowns.", "아이템 또는 능력의 숨겨진 재사용 대기시간입니다.",
	"Other skills", "다른 스킬",
	"Other skills with cooldowns to track.", "다른 스킬의 재사용 대기시간을 추적합니다.",
	"Skill cooldowns that should be announced to your group. A skill must be tracked before it can be announced.", "스킬 재사용 대기시간을 당신의 그룹에 알립니다. 스킬의 추적이 되어야 알릴수 있습니다.",
	"Skills or spells that interrupt spell casting.", "시전을 방해하는 기술 또는 주문입니다.",
	"Track hidden cooldowns", "숨겨진 재사용 대기시간 추적",
	"Track hidden cooldown buffs", "숨겨진 버프 재사용 대기시간 추적",
	"Track interrupt cooldowns", "방해 재사용 대기시간 추적",
	"TrackHiddenCD", "숨겨진 CD 추적",
	"TrackHiddenCDBuffs", "숨겨진 버프 CD 추적",
	"TrackInterrupts", "방해 추적",
	"TrackOthers", "다른 추적",
	"Tracks hidden cooldowns on items such as Scarab of the Infinite Cycle or Hourglass of the Unraveller.", "무한한 세월의 스카라베 또는 해결사의 모래 시계등의 아이템의 숨겨진 재사용 대기시간을 추적합니다.",
	"Tracks buffs from items that have hidden cooldowns such as Scarab of the Infinite Cycle or Hourglass of the Unraveller.", "무한한 세월의 스카라베 또는 해결사의 모래 시계등의 숨겨진 재사용 대기시간 아이템의 버프 추적합니다.",
	"Tracks interrupt cooldowns such as Kick or Counterspell.", "발차기 또는 마법차단등 방해 재사용 대기시간을 추적합니다.",
	"^(%S+) min cooldown", "재사용 대기시간 ^(%S+) 분",
	"^(%S+) sec cooldown", "재사용 대기시간 ^(%S+) 초",
	"Item Cooldowns", "아이템 재사용 대기시간",
	"Items with an unhidden cooldown.", "아이템의 숨겨지지 않은 재사용 대기시간입니다.",
	"Food & Drink", "음식 & 음료",
	"Elixir", "영약",
	"Flask", "물약",
	"Item Enchantment", "마부용품",
	"Scroll", "두루마리",
	"Quest", "퀘스트",
	"Pet", "애완동물",
	"Holiday", "축제용품",
	"Mount", "탈것",
	"Junk", "잡동사니",
	"Other", "기타",
	"Bandage", "휘장",
	"Track item cooldowns", "아이템 재사용 대기시간 추적",
	"Tracks cooldowns from items that do not have a hidden cooldown.", "숨겨진 재사용 대기시간이 없는 아이템의 재사용 대기시간을 추적합니다.",
	"Track Items", "아이템 추적",
	"Select which item cooldowns you wish to track", "추적을 원하는 아이템 재사용 대기시간 선택",
	-- spell shit
	"Traps", "덫",
	"Stance Ultimates", "태세 궁극기",
	"Shocks", "충격",
	"Show Name", "이름 보기",
	"Potions", "물약",
	"Healthstones", "생명석",
	"Drums", "북",
	"Toggle showing your name on cooldown bars.", "재사용 대기시간 바의 이름 표시를 전환합니다.",
	"Select All", "모두 선택"
)

local db
local trackingOthers
local function UpdateTracking()
	trackingOthers = next(db.TrackOthers) and true or false
end

function module:OnInitialize()
	self:SetDefaultEnabledState(false)
	self:RegisterCategory(L["Hidden Cooldowns"], L["Items or abilities with hidden cooldowns."], .2, .9, .6)
	self:RegisterCategory(L["Cooldowns"], L["General skill cooldowns."], .4, .2, .7)
	self:RegisterCategory(L["Interrupts"], L["Skills or spells that interrupt spell casting."], .7, .5, .3)
	self:RegisterCategory(L["Item Cooldowns"], L["Items with an unhidden cooldown."], .2, .5, .6)

	self.db:RegisterDefaults({
		profile = {
			ShowName = true,
			TrackInterrupts = true,
			TrackHiddenCD = true,
			TrackItemCD = false,
			AnnounceInterrupts = false,
			TrackOthers = {},
			AnnounceOthers = {},
			TrackItems = {},
		},
	})

	local itemLst = {}
	local function SetOption(info, value, value2)
		if not db then return end
		local key = info[#info]
		if key == "TrackInterrupts" then
			if value then
				self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
				self:RegisterEvent("SPELLS_CHANGED", "ScanSpells")
				self:RegisterEvent("ZONE_CHANGED_NEW_AREA")
				self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
				self:RegisterEvent("PLAYER_AURAS_CHANGED")
				
				self:ScanSpells()
			
			elseif not trackingOthers then
				self:UnregisterEvent("UNIT_SPELLCAST_SUCCEEDED")
				self:UnregisterEvent("ZONE_CHANGED_NEW_AREA")
				self:UnregisterEvent("SPELLS_CHANGED")
				self:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
				self:UnregisterEvent("PLAYER_AURAS_CHANGED")
			end
			db[key] = value
			
		elseif key == "TrackItemCD" then
			if value then
				self:RegisterBucketEvent("BAG_UPDATE_COOLDOWN", 1.5, "BagChange")
				self:RegisterBucketEvent("UNIT_INVENTORY_CHANGED", 1.5, "BagChange")
			else
				self:UnregisterAllBuckets()
			end
			db[key] = value
		elseif key == "AnnounceInterrupts" or key == "TrackHiddenCD" or key == "TrackHiddenCDBuffs" or key == "ShowName" then
			db[key] = value
	
		elseif key == "TrackItems" then
			db[key][value] = value2 or nil
		
		elseif key == "TrackOthers" then
			local spell, value = value, value2
			if db[key][spell] then
				db[key][spell] = nil
			end
			for id in pairs(spellIDLst[spell]) do
				db[key][id] = value or nil
			end
			UpdateTracking()
			if not trackingOthers and not db.TrackInterrupts then
				self:UnregisterEvent("UNIT_SPELLCAST_SUCCEEDED")
				self:UnregisterEvent("SPELLS_CHANGED")
				self:UnregisterEvent("ZONE_CHANGED_NEW_AREA")
				self:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
				self:UnregisterEvent("PLAYER_AURAS_CHANGED")
			else
				self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
				self:RegisterEvent("SPELLS_CHANGED", "ScanSpells")
				self:RegisterEvent("ZONE_CHANGED_NEW_AREA")
				self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
				self:RegisterEvent("PLAYER_AURAS_CHANGED")

				self:ScanSpells()
			end
		elseif key == "AnnounceOthers" then
			local spell, value = value, value2
			if db[key][spell] then
				db[key][spell] = nil
			end
			for id in pairs(spellIDLst[spell]) do
				db[key][id] = value or nil
			end
		elseif key == "SelectAll" then
			for spell in pairs(spellCooldowns) do
				for id in pairs(spellIDLst[spell]) do
					db["TrackOthers"][id] = value or nil
				end
			end
			UpdateTracking()
		end
	end
	
	local function GetOption(info, spell)
		if not db then return end
	
		local key, key2 = info[#info]
		if not key2 then key2 = spell end
		if key == "AnnounceOthers" or key == "TrackOthers" then
			if GetSpellLink(key2, "") then
				key2 = GetSpellLink(key2, ""):match("spell:(%d+)")	-- Thanks Arrowmaster	-- initial rank spell id
			end
			return db[key][key2]
		end
		if key == "TrackItems" then
			return db[key][key2]
		end
		if key == "SelectAll" then
			local num, total = 0, 0
			for name in pairs(spellCooldowns) do
				for id in pairs(spellIDLst[name]) do
					if not db.TrackOthers[id] then
						return false
					end
				end
			end
			return true
		end
		return db[key]
	end
	
	local spellList = {}
	local function GetSpellList()
		if not db then return end
		self:ScanSpells()
		for i in pairs(spellList) do
			spellList[i] = nil
		end
		for spell in pairs(spellCooldowns) do
			if not interrupts or not interrupts[spell] then
				spellList[spell] = spell
			end
		end
		return spellList
	end
	
	local spellAnnounceDict = {}
	local function GetSpellAnnounceList()
		if not db then return end
		for i in pairs(spellAnnounceDict) do
			spellAnnounceDict[i] = nil
		end
		for id, on in pairs(db.TrackOthers) do
			local spell = GetSpellInfo(id)
			if on and spell then
				spellAnnounceDict[spell] = spell
			end
		end
		return spellAnnounceDict
	end
	
	local itemfilterLst = {
		[L["Food & Drink"]] = true,
		[L["Elixir"]] = true,
		[L["Flask"]] = true,
		[L["Item Enchantment"]] = true,
		[L["Scroll"]] = true,
		[L["Quest"]] = true,
		[L["Pet"]] = true,
		[L["Holiday"]] = true,
		[L["Mount"]] = true,
		[L["Junk"]] = true,
		[L["Other"]] = true,
		[L["Bandage"]] = true,
	}
	local function GetItemList()
		if not db then return end
		for i in pairs(itemLst) do
			itemLst[i] = nil
		end
		for i=1,18 do
			local _, _, active = GetInventoryItemCooldown("player", i)
			if active == 1 then
				local link = GetInventoryItemLink("player", i)
				local itemName = select(3, link:find("Hitem[^|]+|h%[([^[]+)%]"))
				local itemID   = select(3, link:find("Hitem:(%d+)"))
				itemLst[itemID] = itemName
			end
		end
		for i=0,4 do
			local x = 1
			while x < GetContainerNumSlots(i) do
				local _, _, active = GetContainerItemCooldown(i,x)
				if active == 1 then
					local link = GetContainerItemLink(i,x)
					local itemID = select(3, link:find("Hitem:(%d+)"))
					local itemGroup = self:GetRBMItemName(tonumber(itemID))
					local itemName = select(1, GetItemInfo(itemID))
					if not (select(9, GetItemInfo(itemID)) == "INVTYPE_TRINKET") then
						if itemGroup then
							itemLst[itemGroup] = itemGroup
						else
							if not itemfilterLst[select(7, GetItemInfo(link))] or itemID == "6948" then
								itemLst[itemID] = itemName
							end
						end
					end
				end
				x=x+1
			end
		end
		return itemLst
	end	
	local function IsHidden(info)
		if not db then return true end
		local pv = info[#info]
		if pv == "TrackInterrupts" or pv == "AnnounceInterrupts" then
			return not interrupts
		
		elseif pv == "TrackItems" then
			return not db.TrackItemCD
		end
	end
	
	self:SetOptionsTable{
		args = {
			ShowName = {
				type = "toggle",
				name = L["Show Name"],
				desc = L["Toggle showing your name on cooldown bars."],
				get = GetOption,
				set = SetOption,
				hidden = IsHidden,
				order = 1,
			},
			TrackInterrupts = {
				type = "toggle",
				name = L["Track interrupt cooldowns"],
				desc = L["Tracks interrupt cooldowns such as Kick or Counterspell."],
				get = GetOption,
				set = SetOption,
				width = "double",
				hidden = IsHidden,
				order = 10,
			},
			AnnounceInterrupts = {
				type = "toggle",
				name = L["Announce interrupt"],
				desc = L["Interrupt bars will be announced to the group."],
				get = GetOption,
				set = SetOption,
				width = "double",
				hidden = IsHidden,
				disabled = function() return not db or not db.TrackInterrupts end,
				order = 20,
			},
			TrackHiddenCD = {
				type = "toggle",
				name = L["Track hidden cooldowns"],
				desc = L["Tracks hidden cooldowns on items such as Scarab of the Infinite Cycle or Hourglass of the Unraveller."],
				get = GetOption,
				set = SetOption,
				width = "double",
				hidden = IsHidden,
				order = 30,
			},
			TrackHiddenCDBuffs = {
				type = "toggle",
				name = L["Track hidden cooldown buffs"],
				desc = L["Tracks buffs from items that have hidden cooldowns such as Scarab of the Infinite Cycle or Hourglass of the Unraveller."],
				get = GetOption,
				set = SetOption,
				width = "double",
				hidden = IsHidden,
				order = 31,
			},
			TrackItemCD = {
				type = "toggle",
				name = L["Track item cooldowns"],
				desc = L["Tracks cooldowns from items that do not have a hidden cooldown."],
				get = GetOption,
				set = SetOption,
				width = "double",
				hidden = IsHidden,
				order = 39,
			},
			TrackOthers = {
				type = "multiselect",
				name = L["Other skills"],
				desc = L["Other skills with cooldowns to track."],
				get = GetOption,
				set = SetOption,
				values = GetSpellList,
				hidden = IsHidden,
				dialogControl = "Dropdown",
				order = 40,
			},
			SelectAll = {
				type = "toggle",
				name = L["Select All"],
				desc = L["Select All"],
				get = GetOption,
				set = SetOption,
				hidden = IsHidden,
				order = 41,
			},
			AnnounceOthers = {
				type = "multiselect",
				name = L["Announce other skills"],
				desc = L["Skill cooldowns that should be announced to your group. A skill must be tracked before it can be announced."],
				get = GetOption,
				set = SetOption,
				values = GetSpellAnnounceList,
				hidden = IsHidden,
				disabled = function()
					return not trackingOthers
				end,
				order = 50,
			},
			TrackItems = {
				type = "multiselect",
				name = L["Track Items"],
				desc = L["Select which item cooldowns you wish to track"],
				get = GetOption,
				set = SetOption,
				values = GetItemList,
				hidden = IsHidden,
				order = 60,
			},
		},
	}
end

local labels, icons
local BuildDatabase
function module:OnEnable()
	db = self.db.profile
	self:UpgradeProfiles()
	do
		local showName = function()
			return db.ShowName
		end
		local mt = {
			__index = function(self, key)
				if self == icons then
					if GetItemIcon(key) then
						self[key] = GetItemIcon(key):match("Interface\\Icons\\(.+)")
					else
						self[key] = GetPlayerBuffTexture(key):match("Interface\\Icons\\(.+)")
					end
				elseif self == labels then
					if showName() then
						self[key] = module:CreateLabel(playerName, key)
					else
						self[key] = key
					end
				end
				return self[key]
			end,
		}
		labels = setmetatable({}, mt)
		icons = setmetatable({}, mt)
	end
	if BuildDatabase then
		BuildDatabase()
		BuildDatabase = nil
	end
	UpdateTracking()
	if (interrupt and db.TrackInterrupts) or trackingOthers then
		self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
		self:RegisterEvent("SPELLS_CHANGED", "ScanSpells")
		self:RegisterEvent("ZONE_CHANGED_NEW_AREA")
		self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
		self:RegisterEvent("PLAYER_AURAS_CHANGED")
		
		self:ScanSpells()
	end
	if db.TrackItemCD then
		self:RegisterBucketEvent("BAG_UPDATE_COOLDOWN", 1.5, "BagChange")
		self:RegisterBucketEvent("UNIT_INVENTORY_CHANGED", 1.5, "BagChange")
		self:BagChange(true)
	end

end

function module:OnDisable()
	self:UnregisterAllEvents()
	db = nil
	spellIcons = nil
	spellCooldowns = nil
	labels, icons = nil, nil
end

local inInfinite
function module:COMBAT_LOG_EVENT_UNFILTERED(_, _, event, _, sourceName, _, _, _, _, id)
	if sourceName ~= playerName or not id or event ~= "SPELL_MISSED" then return end
	
	local spell = GetSpellInfo(id)
	if not spell then return end
	
	if event == "SPELL_MISSED" then
		id = tostring(id)	-- convert to string
		if self:IsBarActive(labels[sharedCooldowns and sharedCooldowns[id] or spell.." "]) then
			self:SetBarColor(labels[sharedCooldowns and sharedCooldowns[id] or spell.." "], .3, .3, .3, db.AnnounceOthers[spell])
		end
	end		
end


function module:UNIT_SPELLCAST_SUCCEEDED(_, _, spell, rank)
	local id, label
	if GetSpellLink(spell, rank or "") then
		id = GetSpellLink(spell, rank or ""):match("spell:(%d+)")
	end
	if not id then return end
	if interrupts and db.TrackInterrupts and interrupts[id] then
		self:AdvancedTimedBar(db.AnnounceInterrupts, labels[spell.." "], L["Interrupts"], spellCooldowns[spell], spellIcons[spell], true)
	
	elseif trackingOthers then
		if infiniteDurations and infiniteDurations[id] then
			inInfinite = spell
			return
		end
		if db.TrackOthers[id] then
			label = labels[sharedCooldowns and sharedCooldowns[id] or spell.." "]
			self:AdvancedTimedBar(
				db.AnnounceOthers[id], 
				label,
				L["Cooldowns"],
				spellCooldowns[spell],
				spellIcons[spell],
				true
			)
		end
		if cooldownEnders and cooldownEnders[id] then
			for chainedCD in pairs(cooldownEnders[id]) do
				label = labels[sharedCooldowns and sharedCooldowns[chainedCD] or GetSpellInfo(chainedCD).." "]
				if self:IsBarActive(label) then
					self:CancelBar(label, db.AnnounceOthers[chainedCD])
				end
			end
		end
	end
end

function module:PLAYER_AURAS_CHANGED()
--[[
	for name, cd in pairs(hiddenCooldowns) do
		if not self:IsBarActive(labels[name]) and GetPlayerBuffName(name) then
			self:AdvancedTimedBar(false, labels[name], L["Hidden Cooldowns"], cd, icons[name], true)
		end
	end
]]
	if db.TrackHiddenCD then
		for id in pairs(hiddenCooldowns) do
			local itemname = GetItemInfo(hiddenCooldowns[id]["item"])
			if itemname then
				local buffname = GetSpellInfo(id)
				if not self:IsBarActive(labels[itemname.." "]) and GetPlayerBuffName(buffname) then
					self:AdvancedTimedBar(false, labels[itemname.." "], L["Hidden Cooldowns"], hiddenCooldowns[id]["cooldown"], icons[itemname], true)
				end

				if db.TrackHiddenCDBuffs and hiddenCooldowns[id]["buffdur"] then
					if not self:IsBarActive(labels[buffname.." "]) and GetPlayerBuffName(buffname) then
						self:AdvancedTimedBar(false, labels[buffname.." "], L["Hidden Cooldowns"], hiddenCooldowns[id]["buffdur"], icons[buffname], true)
					end
				end
			end
		end
	end
	if inInfinite and not GetPlayerBuffName(inInfinite) then
		local spell = inInfinite
		local id = GetSpellLink(spell, ""):match("spell:(%d+)")
		inInfinite = nil
		if db.TrackOthers[id] then
			self:AdvancedTimedBar(
				db.AnnounceOthers[id], 
				labels[sharedCooldowns and sharedCooldowns[id] or spell.." "],
				L["Cooldowns"],
				spellCooldowns[spell],
				spellIcons[spell],
				true
			)
		end
	end
end

do
	local inArena
	function module:ZONE_CHANGED_NEW_AREA()
		local zone = GetRealZoneText()
		if zone == L["Blade's Edge Arena"] or zone == L["Nagrand Arena"] or zone == L["Ruins of Lordaeron"] then
			self:CancelBars(true)
			inArena = true
			return
		end
		if inArena then
			self:CancelBars(true)
			inArena = false
		end
	end
end

do
	local tooltip, right1, right2
	local cooldownMinPattern = L["^(%S+) min cooldown"]
	local cooldownSecPattern = L["^(%S+) sec cooldown"]
	local function UpdateSpellInfo(id, name, bookType)
		if not spellIcons[name] then
			spellIcons[name] = GetSpellTexture(id, bookType):match("Interface\\Icons\\(.+)")
		end
		tooltip:SetSpell(id, bookType)
		local cd
		for i=1, 2 do
			if i == 1 then
				cd = right1:GetText()
			else
				cd = right2:GetText()
			end
			if cd then
				local secs = cd:match(cooldownSecPattern)
				if secs then
					secs = tonumber(secs)
					spellCooldowns[name] = secs * 1
					break
				else
					secs = cd:match(cooldownMinPattern)
					if secs then
						secs = tonumber(secs)
						spellCooldowns[name] = secs * 60
						break
					end
				end
			end
		end
	end
	function module:ScanSpells()
		if not spellIcons then
			spellIcons = {}
			spellCooldowns = {}
		end
		local lastSpell, name, id
		if not tooltip then
			tooltip = CreateFrame("GameTooltip")
			tooltip:SetOwner(UIParent, "ANCHOR_NONE")
			right1, right2 = tooltip:CreateFontString(), tooltip:CreateFontString()
			tooltip:AddFontStrings(tooltip:CreateFontString(), tooltip:CreateFontString())
			tooltip:AddFontStrings(tooltip:CreateFontString(), right1)
			tooltip:AddFontStrings(tooltip:CreateFontString(), right2)
			
		end
		for k=1, GetNumSpellTabs() do
			local offset, numSpells = select(3, GetSpellTabInfo(k))
			for i = offset + 1, offset + numSpells do
				if not IsPassiveSpell(i, BOOKTYPE_SPELL) then 
					name = GetSpellName(i, BOOKTYPE_SPELL)
					if not completedScan then-- and SpellHasCooldown(i, BOOKTYPE_SPELL) then
						if not spellIDLst[name] then
							spellIDLst[name] = { }
						end
						id = GetSpellLink(i, BOOKTYPE_SPELL):match("spell:(%d+)")	-- true spell ID for ranks
						spellIDLst[name][id] = true
					end

					if lastSpell ~= name then
						UpdateSpellInfo(i, name, BOOKTYPE_SPELL)
						lastSpell = name
					end
				end
			end
		end
		for id in pairs(db.TrackOthers) do
			if not spellIDLst[GetSpellInfo(id)] or spellIDLst[GetSpellInfo(id)] and not spellIDLst[GetSpellInfo(id)][id] then
				db.TrackOthers[id] = nil
			end
		end
		for id in pairs(db.AnnounceOthers) do
			if not spellIDLst[GetSpellInfo(id)] or not db.TrackOthers[id] then
				db.AnnounceOthers[id] = nil
			end
		end
		completedScan = true
	end
end

function module:BagChange(val)
    for i=1,18 do
        local starttime, dur, active = GetInventoryItemCooldown("player", i)
        if dur > 3 and active == 1 then
            local link = GetInventoryItemLink("player", i)
            local itemName = select(3, link:find("Hitem[^|]+|h%[([^[]+)%]"))
            local itemID   = select(3, link:find("Hitem:(%d+)"))
			if db.TrackItems[itemID] and not self:IsBarActive(itemName) then
				self:LocalTimedBar(itemName, L["Item Cooldowns"], dur, icons[itemID], true)
				if val then
					if self:GetBarDuration(itemName) ~= dur then
						self:SetBarTime(itemName, dur, false)
					end
					self:SetBarCurrentTime(itemName, (starttime+dur)-GetTime(), false)
				end
				break
			end
        end
    end

    for i=0,4 do
		local x = 1
		while x < GetContainerNumSlots(i) do
	        local starttime, dur, active = GetContainerItemCooldown(i,x)
            if dur > 3 and active == 1 then
                local itemID = select(3, GetContainerItemLink(i,x):find("Hitem:(%d+)"))
                local itemName = self:GetRBMItemName(tonumber(itemID)) or select(1, GetItemInfo(itemID))

				if not (select(9, GetItemInfo(itemID)) == "INVTYPE_TRINKET") and (db.TrackItems[itemID] or db.TrackItems[itemName]) then
					if not self:IsBarActive(itemName) then
						self:LocalTimedBar(itemName, L["Item Cooldowns"], dur, icons[itemID], true)
						if val then
							if self:GetBarDuration(itemName) ~= dur then
								self:SetBarTime(itemName, dur, false)
							end
							self:SetBarCurrentTime(itemName, (starttime+dur)-GetTime(), false)
						end
						return
					end
	            end
            end
            x=x+1
        end
    end
end

function module:GetRBMItemName(id)
    if not id then return nil end
	if itemCooldowns.potions[id] then return L["Potions"]
	elseif itemCooldowns.healthstones[id] then return L["Healthstones"]
	elseif itemCooldowns.drums[id] then return L["Drums"]
	end
    return nil
end

function BuildDatabase()
	itemCooldowns = {
		healthstones = { [5509] = true, [5510] = true, [5511] = true, [5512] = true, [9421] = true, [19004] = true, [19005] = true, [19006] = true, [19007] = true, [19008] = true, [19009] = true, [19010] = true, [19011] = true, [19012] = true, [19013] = true, [22103] = true, [22104] = true, [22105] = true, },
        -- Drums (Leatherworking)
		drums = { [29528] = true, [29530] = true, [29531] = true, [29532] = true, [29529] = true, [24268] = true, [24269] = true, },
		potions = {
			[118] = true,[858] = true,[929] = true,[1710] = true,[2455] = true,[2456] = true,[3385] = true,[3827] = true,[3928] = true,
			[4596] = true,[5631] = true,[5633] = true,[6048] = true,[6049] = true,[6050] = true,[6051] = true,[6052] = true,[6149] = true,
			[9144] = true,[11562] = true,[11952] = true,[12190] = true,[13442] = true,[13443] = true,[13444] = true,[13446] = true,[13456] = true,
			[13457] = true,[13458] = true,[13459] = true,[13461] = true,[17348] = true,[17349] = true,[17351] = true,[17352] = true,[18253] = true,
			[18839] = true,[18841] = true,[20002] = true,[22795] = true,[22829] = true,[22832] = true,[22836] = true,[22838] = true,[22841] = true,
			[22842] = true,[22844] = true,[22845] = true,[22846] = true,[22847] = true,[22850] = true,[23822] = true,[23823] = true,[28100] = true,
			[28101] = true,[31677] = true,[31838] = true,[31839] = true,[31840] = true,[31841] = true,[31852] = true,[31853] = true,
			[31854] = true,[31855] = true,[32063] = true,[32783] = true,[32784] = true,[32902] = true,[32903] = true,[32904] = true,[32905] = true,
			[32909] = true,[32910] = true,[32947] = true,[32948] = true,[33092] = true,[33093] = true,[33934] = true,[33935] = true,[34440] = true,
		},
	}
	hiddenCooldowns = {}
	--[[
	Example:
	if GetItemCount(itemID, true) > 0 then
		hiddenCooldowns["buffID"] = {
			["item"] = itemID,
			["cooldown"] = hiddenCooldown,
			["buffdur"] = buffDuration,
		}
	end
	]]
	if GetItemCount(28830, true) > 0 then		-- Dragonspine Trophy
		hiddenCooldowns["34775"] = {
			["item"] = 28830,
			["cooldown"] = 20,
			["buffdur"] = 10,
		}
	end
	if GetItemCount(28578, true) > 0 then		-- Masquerade Gown
		hiddenCooldowns["34585"] = {
			["item"] = 28578,
			["cooldown"] = 30,
			["buffdur"] = 15,
		}
	end
	if GetItemCount(28034, true) > 0 then		-- Hourglass of the Unraveller
		hiddenCooldowns["33649"] = {
			["item"] = 28034,
			["cooldown"] = 45,
			["buffdur"] = 10,
		}
	end
	if GetItemCount(27683, true) > 0 then		-- Quag's Eye
		hiddenCooldowns["33370"] = {
			["item"] = 27683,
			["cooldown"] = 45,
			["buffdur"] = 6,
		}
	end
	if GetItemCount(28190, true) > 0 then		-- Scarab of the Inf Cycle
		hiddenCooldowns["33370"] = {
			["item"] = 28190,
			["cooldown"] = 45,
			["buffdur"] = 6,
		}
	end
	if GetItemCount(30450, true) > 0 then		-- Warp Spring Coil (Rogue t5 Trinket)
		hiddenCooldowns["37174"] = {
			["item"] = 30450,
			["cooldown"] = 30,
			["buffdur"] = 15,
		}
	end
	if GetItemCount(30626, true) > 0 then		-- Sextant of Unstable Currents
		hiddenCooldowns["38348"] = {
			["item"] = 30626,
			["cooldown"] = 45,
			["buffdur"] = 15,
		}
	end
	if GetItemCount(28602, true) > 0 then		-- Robe of the Elder Scribes
		hiddenCooldowns["34597"] = {
			["item"] = 28602,
			["cooldown"] = 45,
			["buffdur"] = 10,
		}
	end
	if GetItemCount(30627, true) > 0 then		-- Tsunami Talisman
		hiddenCooldowns["42084"] = {
			["item"] = 30627, 
			["cooldown"] = 45,
			["buffdur"] = 10,
		}
	end
	if GetItemCount(29305, true) > 0 then		-- Band of The Eternal Sage
		hiddenCooldowns["35084"] = {
			["item"] = 29305,
			["cooldown"] = 60,
			["buffdur"] = 10,
		}
	end
	if GetItemCount(29297, true) > 0 then		-- Band of the Eternal Defender
		hiddenCooldowns["35078"] = {
			["item"] = 29297,
			["cooldown"] = 60,
			["buffdur"] = 10,
		}
	end
	if GetItemCount(29301, true) > 0 then		-- Band of the Eternal Champion
		hiddenCooldowns["35081"] = {
			["item"] = 29301,
			["cooldown"] = 60,
			["buffdur"] = 10,
		}
	end
	if GetItemCount(29309, true) > 0 then		-- Band of the Eternal Restorer
		hiddenCooldowns["35087"] = {
			["item"] = 29309,
			["cooldown"] = 60,
			["buffdur"] = 10,
		}
	end	
	if GetItemCount(34679, true) > 0 then		-- Shattered Sun Pendant of Might (Aldor)
		hiddenCooldowns["45480"] = {
			["item"] = 34679,
			["cooldown"] = 45,
			["buffdur"] = 10,
		}
	end
	if GetItemCount(34678, true) > 0 then		-- Shattered Sun Pendant of Acumen (Aldor)
		hiddenCooldowns["45479"] = {
			["item"] = 34678,
			["cooldown"] = 45,
			["buffdur"] = 10,
		}
	end
	if GetItemCount(34680, true) > 0 then		-- Shattered Sun Pendant of Resolve (Scryer)
		hiddenCooldowns["45431"] = {
			["item"] = 34680,
			["cooldown"] = 45,
			["buffdur"] = 10,
		}
	end
	if GetItemCount(34680, true) > 0 then		-- Shattered Sun Pendant of Resolve (Aldor)
		hiddenCooldowns["45432"] = {
			["item"] = 34680,
			["cooldown"] = 45,
			["buffdur"] = 10,
		}
	end
	if GetItemCount(34677, true) > 0 then		-- Shattered Sun Pendant of Restoration (Aldor)
		hiddenCooldowns["45478"] = {
			["item"] = 34677,
			["cooldown"] = 45,
			["buffdur"] = 10,
		}
	end
	if GetItemCount(34473, true) > 0 then		-- Commendation of Kael'thas
		hiddenCooldowns["45057"] = {
			["item"] = 34473,
			["cooldown"] = 30,
			["buffdur"] = 10,
		}
	end
	if GetItemCount(34472, true) > 0 then		-- Shard of Contempt
		hiddenCooldowns["45053"] = {
			["item"] = 34472,
			["cooldown"] = 30,
			["buffdur"] = 10,
		}
	end	
	
	if playerClass == "WARRIOR" then
		interrupts = {
			["72"] = true,		-- shield bash rank 1
			["1671"] = true,	-- shield bash rank 2
			["1672"] = true,	-- shield bash rank 3
			["29704"] = true,	-- shield bash rank 4
			["6552"] = true,	-- pummel rank 1
			["6554"] = true,	-- pummel rank 2
		}
		sharedCooldowns = {
			["20230"] = L["Stance Ultimates"],	-- Retaliation
			["871"] = L["Stance Ultimates"],	-- Shield Wall
			["1719"] = L["Stance Ultimates"],	-- Recklessness
		}
	elseif playerClass == "SHAMAN" then
		interrupts = {
			["8042"] = true,	-- Earth Shock Rank 1
			["8044"] = true,	-- Earth Shock Rank 2
			["8045"] = true,	-- Earth Shock Rank 3
			["8046"] = true,	-- Earth Shock Rank 4
			["10412"] = true,	-- Earth Shock Rank 5
			["10413"] = true,	-- Earth Shock Rank 6
			["10414"] = true,	-- Earth Shock Rank 7
			["25454"] = true,	-- Earth Shock Rank 8
		}
		infiniteDurations = {
			["16166"] = true,	-- Elemental Mastery
			["16188"] = true,	-- Nature Swiftness
		}
		sharedCooldowns = {
			["8042"] = L["Shocks"],		-- Earth Shock Rank 1
			["8044"] = L["Shocks"],		-- Earth Shock Rank 2
			["8045"] = L["Shocks"],		-- Earth Shock Rank 3
			["8046"] = L["Shocks"],		-- Earth Shock Rank 4
			["10412"] = L["Shocks"],	-- Earth Shock Rank 5
			["10413"] = L["Shocks"],	-- Earth Shock Rank 6
			["10414"] = L["Shocks"],	-- Earth Shock Rank 7
			["25454"] = L["Shocks"],	-- Earth Shock Rank 8
			["8056"] = L["Shocks"],		-- Frost Shock Rank 1
			["8058"] = L["Shocks"],		-- Frost Shock Rank 2
			["10472"] = L["Shocks"],	-- Frost Shock Rank 3
			["10473"] = L["Shocks"],	-- Frost Shock Rank 4
			["25464"] = L["Shocks"],	-- Frost Shock Rank 5
			["8050"] = L["Shocks"],		-- Flame Shock Rank 1
			["8052"] = L["Shocks"],		-- Flame Shock Rank 2
			["8053"] = L["Shocks"],		-- Flame Shock Rank 3
			["10447"] = L["Shocks"],	-- Flame Shock Rank 4
			["10448"] = L["Shocks"],	-- Flame Shock Rank 5
			["29228"] = L["Shocks"],	-- Flame Shock Rank 6
			["25457"] = L["Shocks"],	-- Flame Shock Rank 7
		}
	elseif playerClass == "WARLOCK" then
	elseif playerClass == "DRUID" then
		infiniteDurations = {
			["17116"] = true,	-- Nature Swiftness
			["5215"] = true,	-- Prowl Rank 1
			["6783"] = true,	-- Prowl Rank 2
			["9913"] = true,	-- Prowl Rank 3
		}
	elseif playerClass == "PALADIN" then 
		infiniteDurations = {
			["20216"] = true,	-- Divine Favor
		}
	elseif playerClass == "PRIEST" then
		infiniteDurations = {
			["14751"] = true,	-- Inner Focus
		}
	elseif playerClass == "MAGE" then
		interrupts = {
			["2139"] = true,	-- Counterspell
		}
		infiniteDurations = {
			["12043"] = true,	-- Presence of Mind
			["11129"] = true,	-- Combustion
		}
		cooldownEnders = {
			["11958"] = {	-- Cold Snap
				["120"] = true, -- Cone of Cold Rank 1
				["8492"] = true, -- Cone of Cold Rank 2
				["10159"] = true, -- Cone of Cold Rank 3
				["10160"] = true, -- Cone of Cold Rank 4
				["10161"] = true, -- Cone of Cold Rank 5
				["27087"] = true, -- Cone of Cold Rank 6
				["122"] = true,	-- Frost Nova Rank 1
				["865"] = true, -- Frost Nova Rank 2
				["6131"] = true,-- Frost Nova Rank 3
				["10230"] = true,	-- Frost Nova Rank 4
				["27088"] = true,	-- Frost Nova Rank 5
				["11426"] = true,	-- Ice Barrier Rank 1
				["13031"] = true,	-- Ice Barrier Rank 2
				["13032"] = true,	-- Ice Barrier Rank 3
				["13033"] = true,	-- Ice Barrier Rank 4
				["27134"] = true,	-- Ice Barrier Rank 5
				["33405"] = true,	-- Ice Barrier Rank 6
				["31687"] = true,	-- Summon Water Elemental Rank 1
				["45438"] = true,	-- Ice Block
				["6143"] = true,	-- Frost Ward Rank 1
				["8461"] = true,	-- Frost Ward Rank 2
				["8462"] = true,	-- Frost Ward Rank 3
				["10177"] = true,	-- Frost Ward Rank 4
				["28609"] = true,	-- Frost Ward Rank 5
				["32796"] = true,	-- Frost Ward Rank 6
			},
		}
	elseif playerClass == "ROGUE" then
		interrupts = {
			["1766"] = true, -- Kick Rank 1
			["1767"] = true, -- Kick Rank 2
			["1768"] = true, -- Kick Rank 3
			["1769"] = true, -- Kick Rank 4
			["38768"] = true, -- Kick Rank 5
		}
		infiniteDurations = {
			["14177"] = true, -- Cold Blood
			["1784"] = true, -- Stealth Rank 1
			["1785"] = true, -- Stealth Rank 2
			["1786"] = true, -- Stealth Rank 3
			["1787"] = true, -- Stealth Rank 4
		}
		cooldownEnders = {
			["14185"] = { 
				["14177"] = true,	-- Cold Blood
				["1725"] = true,	-- Distract
				["1966"] = true,	-- Feint Rank 1
				["6768"] = true,	-- Feint Rank 2
				["8637"] = true,	-- Feint Rank 3
				["11303"] = true,	-- Feint Rank 4
				["25302"] = true,	-- Feint Rank 5
				["27448"] = true,	-- Feint Rank 6
				["1776"] = true,	-- Gouge Rank 1
				["1777"] = true,	-- Gouge Rank 2
				["8629"] = true,	-- Gouge Rank 3
				["11285"] = true,	-- Gouge Rank 4
				["11286"] = true,	-- Gouge Rank 5
				["38764"] = true,	-- Gouge Rank 6
				["5277"] = true,	-- Evasion Rank 1
				["26669"] = true,	-- Evasion Rank 2
				["1766"] = true,	-- Kick Rank 1
				["1767"] = true,	-- Kick Rank 2
				["1768"] = true,	-- Kick Rank 3
				["1769"] = true,	-- Kick Rank 4
				["38768"] = true,	-- Kick Rank 5
				["408"] = true,		-- Kidney Shot Rank 1
				["8643"] = true,	-- Kidney Shot Rank 2
				["2983"] = true,	-- Sprint Rank 1
				["8696"] = true,	-- Sprint Rank 2
				["11305"] = true,	-- Sprint Rank 3
				["1856"] = true,	-- Vanish Rank 1
				["1857"] = true,	-- Vanish Rank 2
				["26889"] = true,	-- Vanish Rank 3
			},
		}
	elseif playerClass == "HUNTER" then
		interrupts = {
			["34490"] = true,	-- silencing shot
		}
		infiniteDurations = {
			["5384"] = true,
		}
		sharedCooldowns = {
			["13795"] = L["Traps"],	-- immolation trap rank 1
			["14302"] = L["Traps"],	-- immolation trap rank 2
			["14303"] = L["Traps"],	-- immolation trap rank 3
			["14304"] = L["Traps"],	-- immolation trap rank 4
			["14305"] = L["Traps"],	-- immolation trap rank 5
			["27023"] = L["Traps"],	-- immolation trap rank 6
			["1499"]  = L["Traps"],	-- freezing trap rank 1
			["14310"] = L["Traps"],	-- freezing trap rank 2
			["14311"] = L["Traps"],	-- freezing trap rank 3
			["13809"] = L["Traps"],	-- frost trap
			["13813"] = L["Traps"],	-- explosive trap rank 1
			["14316"] = L["Traps"],	-- explosive trap rank 2
			["14317"] = L["Traps"],	-- explosive trap rank 3
			["27025"] = L["Traps"],	-- explosive trap rank 4
			["34600"] = L["Traps"],	-- snake trap rank 1
		}
		cooldownEnders = {
			["23989"] = {-- readiness, I pulled all of these from my spellbook via ingame.  There are in some random order.
				["34477"] = true,["20736"] = true,["25294"] = true,["14310"] = true,["3045"] = true,["14317"] = true,["1495"] = true,["14281"] = true,["20554"] = true,["14279"] = true,
				["34600"] = true,["3044"] = true,["14261"] = true,["14280"] = true,["14266"] = true,["5116"] = true,["14284"] = true,["14264"] = true,["14288"] = true,["14282"] = true,
				["14286"] = true,["27019"] = true,["5384"] = true,["3034"] = true,["14303"] = true,["27020"] = true,["1513"] = true,["14287"] = true,["15629"] = true,
				["14260"] = true,["15631"] = true,["14272"] = true,["2973"] = true,["14262"] = true,["14271"] = true,["14283"] = true,["2643"] = true,["14289"] = true,
				["27022"] = true,["34026"] = true,["14294"] = true,["14305"] = true,["781"] = true,["1510"] = true,["1543"] = true,["14304"] = true,["14316"] = true,
				["27025"] = true,["14302"] = true,["14285"] = true,["14290"] = true,["13795"] = true,["14270"] = true,["19801"] = true,["27014"] = true,["14327"] = true,
				["27015"] = true,["14311"] = true,["13809"] = true,["13813"] = true,["14274"] = true,["36916"] = true,["15632"] = true,["27021"] = true,["14295"] = true,
				["14265"] = true,["27023"] = true,["15630"] = true,["27018"] = true,["1499"] = true,["14269"] = true,["14273"] = true,["14326"] = true,["14263"] = true,
				["19386"] = true,["24132"] = true,["24133"] = true,["27068"] = true,["19306"] = true,["20909"] = true,["20910"] = true,["27076"] = true,["19263"] = true,
			},
		}
	end
	local _, race = UnitRace("player")
	if race == "NightElf" then
		if not infiniteDurations then
			infiniteDurations = {}
		end
		infiniteDurations["20580"] = true	-- shadowmeld
	end
end