--I, Apoco, Author of RBM, do not take any credit for the gradient work.
--The gradient's code was copied from CandyBar-2.0 with permissions
local GetMacroIconInfo = GetMacroIconInfo
local GetNumMacroIcons = GetNumMacroIcons
local PlaySoundFile = PlaySoundFile
local unpack = unpack
local random = math.random
local sin = math.sin
local floor = math.floor
local min = math.min
local max = math.max
local type = type
local pairs = pairs
local ipairs = ipairs
local GetTime = GetTime
local UIParent = UIParent

setfenv(1, RBM.FunctionEnviroment)
local BarClass = BarClass

local MediaHandler = MediaHandler
MediaHandler:Register("statusbar", "BantoBar", [[Interface\Addons\RBM\Images\BantoBar.tga]])
MediaHandler:Register("statusbar", "Cloud", [[Interface\Addons\RBM\Images\Cloud.tga]])

MediaHandler:Register("border", "RothSquare", [[Interface\Addons\RBM\Images\RothSquare.tga]])

MediaHandler:Register("spark", "Blizzard", [[Interface\CastingBar\UI-CastingBar-Spark]])

MediaHandler:Register("sound", "Kachink", [[Interface\Addons\RBM\Sounds\Kachink.wav]])
MediaHandler:Register("sound", "Info", [[Interface\Addons\RBM\Sounds\Info.wav]])

local function OnClick(self, button)
	self:GetParent():OnBarClick(self, button)
end

function BarClass:New()
	if self ~= BarClass then return end
	local bar = CreateFrame("Button")
	bar:Hide()
	if _G.VisualThemes then
		_G.VisualThemes:RegisterFrames(L["RBM Bars"], 0, bar)
	end

	bar.timer = bar:CreateFontString()
	bar.text = bar:CreateFontString()

	bar.status = CreateFrame("StatusBar", nil, bar)
	bar.spark = bar.status:CreateTexture(nil, "OVERLAY")
	bar.icon = bar.status:CreateTexture(nil, "OVERLAY")
	bar:RegisterForClicks("AnyUp")

	bar:SetScript("OnClick", OnClick)

	BarClass:Embed(bar)

	return bar
end

function BarClass:Initialize(parent)
	if self.transferring and self.count and self.maxCount then
		self:SetScript("OnUpdate", function() self:FinishTransfer() end)
	end
	self:SetParent(parent)
	self:RefreshSettings()
end

local format = _G.format
local function FormatTime(secs, format)
	if secs < 60 then --under a minute
		--return format("%.1f", secs)
		return "%."..format.."f", secs
	elseif secs < 3600 then --under an hour
		--return format("%d:%02d", secs / 60, secs % 60)
		return "%d:%02d", secs / 60, secs % 60
	elseif secs < 86400 then --under a day
		--return format("%d:%02d hr", secs / 3600, secs % 3600 / 60)
		return "%d:%02d hr", secs / 3600, secs % 3600 / 60
	elseif secs < 604800 then --under a week
		--return format("%d+ days", secs / 86400)
		return "%d+ days", secs / 86400
	else
		--return format("%d+ wks", secs / 604800)
		return "%d+ wks", secs / 604800
	end
end

-- this function was copied from CandyBar-2.0 with Permission from Ammo.  Thanks!
local function UpdateGradient(self, elapsed)
	local p = floor( (elapsed / self.dur) * 100 ) / 100
	if not self.cachedGradient[self.gradientid][p] then
		local gstart, gend, gp
		for i=1, #self.gradientTable - 1 do
			if self.gradientTable[i][4] < p and p <= self.gradientTable[i+1][4] then
				gstart = self.gradientTable[i]
				gend = self.gradientTable[i+1]
				gp = (p - gstart[4]) / (gend[4] - gstart[4])
			end
		end
		if gstart and gend then
			self.cachedGradient[self.gradientid][p] = {}
			local i
			for i = 1, 4 do
				self.cachedGradient[self.gradientid][p][i] = gstart[i]*(1-gp) + gend[i]*(gp)
			end
		end
	end
	if self.cachedGradient[self.gradientid][p] then
		self.status:SetStatusBarColor(unpack(self.cachedGradient[self.gradientid][p], 1, 3))
	end
end

function BarClass:UpdateFade(db)
	if not self.fadeelapsed then 
		self.fadeelapsed = 0 
	end
	if not self.isfading then
		self.isfading = true
	end
	local p = (db.FadeComplete - self.fadeelapsed) / db.FadeComplete

	self:SetBackdropColor(db.BarBackdropColor.r, db.BarBackdropColor.g, db.BarBackdropColor.b, (db.BarBackdropColor.a * p))
	self:SetBackdropBorderColor(db.BarBackdropBorderColor.r, db.BarBackdropBorderColor.g, db.BarBackdropBorderColor.b, (db.BarBackdropBorderColor.a * p))
	self.status:SetStatusBarColor(self.r, self.g, self.b, ((self.a or 1) * p))
	self.text:SetTextColor(db.LabelColor.r, db.LabelColor.g, db.LabelColor.b, (db.LabelColor.a * p))
	self.timer:SetTextColor(db.TimerColor.r, db.TimerColor.g, db.TimerColor.b, (db.TimerColor.a * p))
	self.spark:SetVertexColor(db.SparkColor.r, db.SparkColor.g, db.SparkColor.b, (db.SparkColor.a * p))
	if db.IconColorUsed then
		self.icon:SetVertexColor(db.IconColor.r , db.IconColor.g, db.IconColor.b, (db.IconColor.a * p))
	else
		self.icon:SetAlpha(p)
	end
	self.fadeelapsed = self.fadeelapsed + 1
	if self.fadeelapsed >= db.FadeComplete then self:Cancel() end
end

function BarClass:OnUpdate(remains, now, frame)
	if self.TimerFormat then	-- yes, there should always be one.  But sometimes on the first frame update there isn't.
		self.timer:SetFormattedText(FormatTime(remains, self.TimerFormat))
	end
	local sparkPos
	if self.isfading then
		self:RefreshSettings()
		self.isfading = nil
	end
	if self.NormalizeTime > 0 then
		sparkPos = (min(remains, self.NormalizeTime) / self.NormalizeTime) * self.status:GetWidth()
		self.status:SetValue(self.reverse and -max(now, self.endTime-self.NormalizeTime) or max(now, self.endTime-self.NormalizeTime))
	else
		sparkPos = (remains / (self.endTime - self.startTime)) * self.status:GetWidth()
		self.status:SetValue(self.reverse and -now or now)
	end

	self.spark:SetPoint("CENTER", self.status, self.reverse and "LEFT" or "RIGHT", self.reverse and sparkPos or -sparkPos, 0)
	if self.pulseTime and now >= self.pulseTime then
		self:SetScale((sin(remains * 5) * .03) + 1)
	end
	if self.blinkTime and now >= self.blinkTime then
		self:SetAlpha((sin(remains * 3) * .8) + 1)
	end
	if self.soundTime and now >= self.soundTime then
		PlaySoundFile(MediaHandler:Fetch("sound", self.soundToPlay))
		self.soundTime = nil
	end
	if self.gradient then
		UpdateGradient(self, self.reverse and self.dur - remains or remains - self.dur)
	end
	if self.transferring then
		if not frame then
			frame = self:GetParent()
		end
		local bx, by = self:GetCenter()
		local fx, fy = frame:GetCenter() + self.transferOffsetX, frame:GetAnimationPoint()

		local xDiff, yDiff = fx - bx, fy - by
		if (xDiff < 0 and -xDiff or xDiff) < 10 and (yDiff < 0 and -yDiff or yDiff) < 10 then --twice as fast as abs
			frame:FinishBarTransfer(self)
			if self.idealHeight then
				self:SetHeight(self.idealHeight)
				self.idealHeight = nil
			end
			if self.idealWidth then
				self:SetWidth(self.idealWidth)
				self.idealWidth = nil
			end
		else
			self:SetPoint("CENTER", UIParent, "BOTTOMLEFT", self.GetTransferAnimationPoints(bx, by, fx, fy, self.rate))
			if self.idealHeight then
				local height = self:GetHeight()
				local diff = self.idealHeight - height
				if (diff < 0 and -diff or diff) < 3 then
					self:SetHeight(self.idealHeight)
					self.idealHeight = nil
				else
					self:SetHeight(height + diff * self.rate)
				end
			end
			if self.idealWidth then
				local width = self:GetWidth()
				local diff = self.idealWidth - width
				if (diff < 0 and -diff or diff) < 3 then
					self:SetWidth(self.idealWidth)
					self.idealWidth = nil
				else
					self:SetWidth(width + diff * self.rate)
				end
			end
			self:SetMinMax(self.startTime, self.endTime)
			self:RefreshIcon()
		end
	end
end

function BarClass:Cancel()
	self:Hide()
	self.paused = nil
	self.count = nil
	self.iconCoords = nil
	self.gradient = nil
	self.gradientTable = nil
	self.cachedGradient = nil
	self.fadeelapsed = nil
	self.fadetime = nil
	self.isfading = nil
	return self:GetParent():ReclaimBar(self)
end

function BarClass:Pause()
	if not self.startTime or self.paused then return end 
	self.paused = GetTime()
end

function BarClass:Unpause()
	if not self.paused then return end
	local pausedTime = GetTime() - self.paused
	self.paused = nil
	self.startTime = self.startTime + pausedTime
	self.endTime = self.endTime + pausedTime
	self:SetMinMax(self.startTime, self.endTime)
	self:UpdateSpecialTimes()
end

function BarClass:IncreaseCount()
	if self.count then 
		self:SetCount(self.count + 1)
	end 
end

function BarClass:DecreaseCount()
	if self.count then 
		self:SetCount(self.count - 1)
	end 
end

function BarClass:SetCount(count)
	if self.count and count then 
		if count > self.maxCount then
			count = self.maxCount 
		elseif count < 0 then
			count = 0
		end
		self.count = count
		self.timer:SetText(("%d/%d"):format(self.count, self.maxCount)) 
		self.status:SetValue(self.count)
		self.spark:SetPoint("CENTER", self.status, "LEFT", (self.count / self.maxCount) * self.status:GetWidth(), 0)
	end 
end

function BarClass:SetMaxCount(maxCount)
	if self.count and maxCount then 
		self.maxCount = maxCount
		self.count = self.count <= self.maxCount and self.count or self.maxCount
		self.timer:SetText(("%d/%d"):format(self.count, self.maxCount)) 
		self.status:SetValue(self.count)
		self.spark:SetPoint("CENTER", self.status, "LEFT", (self.count / self.maxCount) * self.status:GetWidth(), 0)
	end 
end

function BarClass:SetColor(r, g, b, a)
	self.r, self.g, self.b, self.a = r or self.r, g or self.g, b or self.b, a or self.a
	self.status:SetStatusBarColor(self.r, self.g, self.b, self.a)
end

local Icons = Icons
function BarClass:SetIcon(icon)
	self.iconName = Icons[icon]
	self.icon:SetTexture(self.iconName)
end

function BarClass:SetIconCoords(l,r,t,b)
	if self.icon and self.iconName then
		self.iconCoords = {}
		self.iconCoords[1] = l
		self.iconCoords[2] = r
		self.iconCoords[3] = t
		self.iconCoords[4] = b
		self:RefreshIcon()
	end
end
function BarClass:SetLabel(label)
	self.label = label
	self.text:SetText(label)
end

function BarClass:SetTime(time)
	if self.startTime then
		if time < 0 then
			self.reverse = not self.reverse
			time = -time
		end
		self.startTime = GetTime()
		self.endTime = self.startTime + time
		
		self:SetMinMax(self.startTime, self.endTime)
		if self.paused then
			self.paused = self.startTime
			self:OnUpdate(self.endTime - self.startTime, self.startTime)
		else
			self:UpdateSpecialTimes()
		end
	end
end

function BarClass:SetCurrentTime(time)
	local db = db or self:GetParent().db.profile
	if self.startTime then
		local now = GetTime()
		local diff = (self.endTime - now) - time
		self.startTime = self.startTime - diff
		self.endTime = self.endTime - diff
		if self.startTime > now then
			local adjust =  self.startTime - now
			self.startTime = self.startTime - adjust
			self.endTime = self.endTime - adjust
		end
		self:SetMinMax(self.startTime, self.endTime)
		self:UpdateSpecialTimes()
		if self.paused then
			self:OnUpdate(self.endTime - self.paused, self.paused)
		end
	end
end

function BarClass:Shift(value)
	if self.startTime then
		self.startTime = self.startTime + value
		self.endTime = self.endTime + value
		local max = GetTime()
		if self.startTime > max then
			local adjust =  self.startTime - max
			self.startTime = self.startTime - adjust
			self.endTime = self.endTime - adjust
		end
		self:SetMinMax(self.startTime, self.endTime)
		
		self:UpdateSpecialTimes()
		if self.paused then
			self:OnUpdate(self.endTime - self.paused, self.paused)
		end
	end
end


function BarClass:SetMinMax(min, max)
	local db = db or self:GetParent().db.profile
	if self.startTime then
		self.startTime = min
		self.endTime = max
		if db.NormalizeTime > 0 then
			self.status:SetMinMaxValues(self.reverse and -self.endTime or (self.endTime - db.NormalizeTime), self.reverse and (-(self.endTime - db.NormalizeTime)) or self.endTime)
		else
			self.status:SetMinMaxValues(self.reverse and -self.endTime or self.startTime, self.reverse and -self.startTime or self.endTime)
		end
		if self.paused then
			local now = GetTime()
			self:OnUpdate(self.endTime - now, now)
		else
			self:UpdateSpecialTimes()
		end
	end
end

function BarClass:UpdateSpecialTimes(db)
	db = db or self:GetParent().db.profile
	self.transferAboveAt = nil
	self.transferBelowAt = nil
	self.pulseTime = nil
	self.blinkTime = nil
	self.soundTime = nil
	self.NormalizeTime = db.NormalizeTime
	self.TimerFormat = db.TimerFormat
	if not self.startTime then 
		if self.count and self.maxCount and db.TransferCountBars then
			self.transferBelowAt = db.TransferBelowByPercent and db.TransferBelowPercent or nil
			self.transferAboveAt = db.TransferAboveByPercent and db.TransferAbovePercent or nil
		end
		return 
	end
	self:SetAlpha(1)
	self:SetScale(1)

	local totalTime = self.endTime - self.startTime
	self.transferBelowAt = db.TransferBelowByPercent and self.endTime - (totalTime * db.TransferBelowPercent) or nil

	if db.TransferBelowByTime then
		local absolute = self.endTime - db.TransferBelowTime
		if not self.transferBelowAt or absolute < self.transferBelowAt then
			self.transferBelowAt = absolute
		end
	end
	db.transferAboveAt = db.TransferAboveByPercent and self.endTime - (totalTime * db.TransferAbovePercent) or nil
	
	if db.TransferAboveByTime then
		local absolute = self.endTime - db.TransferAboveTime
		self.transferAboveAt = (not self.transferAboveAt or absolute < self.transferAboveAt) and absolute or nil
	end

	self.pulseTime = db.PulseByPercent and self.endTime - (totalTime * db.PulsePercent) or nil
	
	if db.PulseByTime then
		local absolute = self.endTime - db.PulseTime
		self.pulseTime = (not self.pulseTime or absolute < self.pulseTime) and absolute or nil
	end

	self.blinkTime = db.BlinkByPercent and self.endTime - (totalTime * db.BlinkPercent) or nil
	if db.BlinkByTime then
		local absolute = self.endTime - db.BlinkTime
		if not self.blinkTime or absolute < self.blinkTime then
			self.blinkTime = absolute
		end
	end
	local now
	local category, subCategory = self.category, self.subCategory
	if db.SoundByPercent[category][subCategory] then
		now = GetTime()
		self.soundTime = self.endTime - (totalTime * db.SoundPercent[category][subCategory])
		if now > self.soundTime then
			self.soundTime = nil
		end
	end
	if db.SoundByTime[category][subCategory] then
		now = now or GetTime()
		local absolute = self.endTime - db.SoundTime[category][subCategory]
		if not self.soundTime or absolute < self.soundTime then
			self.soundTime = now > absolute and nil or absolute
		end
	end
	if self.soundTime then
		self.soundToPlay = db.CustomLabels[self.label].CustomSound and db.CustomLabels[self.label].CustomSoundToPlay or db.SoundToPlay[category][subCategory]
	end
end

function BarClass:GetRelativePoint(point)
	if point == "LEFT" then return "RIGHT"
	elseif point == "RIGHT" then return "LEFT"
	elseif point == "TOP" then return "BOTTOM"
	elseif point == "BOTTOM" then return "TOP"
	elseif point == "CENTER" then return "CENTER"
	elseif point == "TOPRIGHT" then return "BOTTOMLEFT"
	elseif point == "BOTTOMLEFT" then return "TOPRIGHT"
	elseif point == "TOPLEFT" then return "BOTTOMRIGHT"
	elseif point == "BOTTOMRIGHT" then return "TOPLEFT"
	else return "RIGHT"
	end
end

function BarClass:RefreshSettings()
	local db = self:GetParent().db.profile
	self:RefreshBase(db)
	self:RefreshLabel(db)
	self:RefreshTimer(db)
	self:RefreshStatus(db)
	self:RefreshSpark(db)
	self:RefreshIcon(db)
	self:UpdateSpecialTimes(db)
end

function BarClass:RefreshBase(db)
	db = db or self:GetParent().db.profile

	local adjust = db.IconVisible and db.BarHeight or 0
	adjust = self.iconName and adjust or 0
	if self.transferring then
		self.idealHeight = db.BarHeight
		self.idealWidth = (db.BarWidth * db.Width) - adjust
	else
		self:SetHeight(db.BarHeight)
		self:SetWidth((db.BarWidth * db.Width) - adjust)
	end

	local bg, edge = db.BarBackdrop.bgFile, db.BarBackdrop.edgeFile
	db.BarBackdrop.bgFile, db.BarBackdrop.edgeFile = MediaHandler:Fetch("background", db.BarBackdrop.bgFile), MediaHandler:Fetch("border", db.BarBackdrop.edgeFile)
	self:SetBackdrop(db.BarBackdrop)
	db.BarBackdrop.bgFile, db.BarBackdrop.edgeFile = bg, edge

	self:SetBackdropColor(db.BarBackdropColor.r, db.BarBackdropColor.g, db.BarBackdropColor.b, db.BarBackdropColor.a)
	self:SetBackdropBorderColor(db.BarBackdropBorderColor.r, db.BarBackdropBorderColor.g, db.BarBackdropBorderColor.b,db.BarBackdropBorderColor.a)

	self:EnableMouse(self:GetParent().IsForceShown or db.EnableMouse)
end

function BarClass:RefreshStatus(db)
	db = db or self:GetParent().db.profile
	self.status:SetPoint("TOPLEFT", self, "TOPLEFT", db.StatusLeftSpacing, -db.StatusTopSpacing)
	self.status:SetPoint("BOTTOMRIGHT", self, "BOTTOMRIGHT", -db.StatusRightSpacing, db.StatusBottomSpacing)
	self.status:SetStatusBarTexture(MediaHandler:Fetch("statusbar", db.StatusTexture))
	self.status:SetFrameLevel(self:GetFrameLevel())
end

function BarClass:RefreshIcon(db)
	db = db or self:GetParent().db.profile
	self.icon:ClearAllPoints()
	self.icon:SetParent(self)
	self.icon:SetPoint(self:GetRelativePoint(db.IconLocation), self, db.IconLocation, db.IconOffsetX == 0 and 0 or db.IconOffsetX, db.IconOffsetY == 0 and 0 or db.IconOffsetY)
	self.icon:SetWidth(db.IconWidth == 0 and self:GetHeight() or db.IconWidth)
	self.icon:SetHeight(db.IconHeight == 0 and self:GetHeight() or db.IconHeight)
	if db.IconVisible and self.iconName then
		if self.iconCoords then
			self.icon:SetTexCoord(unpack(self.iconCoords))
		else
			self.icon:SetTexCoord(0, 0, 0, 1, 1, 0, 1, 1)
		end
		self.icon:Show()
		self.transferOffsetX = db.IconLocation == "LEFT" and (self:GetHeight() * .5) or -(self:GetHeight() * .5)
		if db.IconColorUsed then
			self.icon:SetVertexColor(db.IconColor.r , db.IconColor.g, db.IconColor.b, db.IconColor.a)
		else
			self.icon:SetAlpha(1.0)
		end
	else 
		self.icon:Hide()
		self.transferOffsetX = 0
	end	
end

function BarClass:RefreshSpark(db)
	db = db or self:GetParent().db.profile
	self.spark:ClearAllPoints()
	local height = self:GetHeight()
	self.spark:SetHeight(height * db.SparkHeight)
	self.spark:SetWidth(height * db.SparkWidth)
	self.spark:SetTexture(MediaHandler:Fetch("spark", db.SparkTexture))
	self.spark:SetBlendMode(db.SparkBlend)
	self.spark:SetVertexColor(db.SparkColor.r, db.SparkColor.g, db.SparkColor.b, db.SparkColor.a)
	if db.SparkVisible and self.startTime then
		self.spark:Show()
	else
		self.spark:Hide()
	end
end

function BarClass:RefreshTimer(db)
	db = db or self:GetParent().db.profile
	self.timer:SetPoint("BOTTOMRIGHT", self, "BOTTOMRIGHT", db.TimerAdjust, 0)
	self.timer:SetPoint("TOPLEFT", self, "TOPLEFT", db.TimerAdjust, 0)
	self.timer:SetJustifyH(db.TimerJustifyH)
	self.timer:SetJustifyV(db.TimerJustifyV)
	self.timer:SetTextColor(db.TimerColor.r, db.TimerColor.g, db.TimerColor.b, db.TimerColor.a)
	self.timer:SetFont(MediaHandler:Fetch("font", db.TimerFont), db.TimerFontSize, db.LabelOutline or "")
	if db.LabelUseShadowColor then
		self.timer:SetShadowColor(db.LabelShadowColor.r, db.LabelShadowColor.g, db.LabelShadowColor.b, db.LabelShadowColor.a)
		self.timer:SetShadowOffset(db.LabelShadowOffsetX or 0, db.LabelShadowOffsetY or 0)
	end
end

function BarClass:RefreshLabel(db)
	db = db or self:GetParent().db.profile
	self.text:SetPoint("BOTTOMRIGHT", self, "BOTTOMRIGHT", db.LabelAdjust, 0)
	self.text:SetPoint("TOPLEFT", self, "TOPLEFT", db.LabelAdjust, 0)
	self.text:SetJustifyH(db.LabelJustifyH)
	self.text:SetJustifyV(db.LabelJustifyV)
	self.text:SetFont(MediaHandler:Fetch("font", db.LabelFont), db.LabelFontSize, db.LabelOutline or "")
	self.text:SetTextColor(db.LabelColor.r, db.LabelColor.g, db.LabelColor.b, db.LabelColor.a)
	if db.LabelUseShadowColor then
		self.text:SetShadowColor(db.LabelShadowColor.r, db.LabelShadowColor.g, db.LabelShadowColor.b, db.LabelShadowColor.a)
		self.text:SetShadowOffset(db.LabelShadowOffsetX or 0, db.LabelShadowOffsetY or 0)
	end
end

function BarClass:FinishTransfer(db)
	db = db or self:GetParent().db.profile
	if self.transferring and self.count and self.maxCount then
		local frame = self:GetParent()

		local bx, by = self:GetCenter()
		local fx, fy = frame:GetCenter() + self.transferOffsetX, frame:GetAnimationPoint()

		local xDiff, yDiff = fx - bx, fy - by
		
		if (xDiff < 0 and -xDiff or xDiff) < 10 and (yDiff < 0 and -yDiff or yDiff) < 10 then --twice as fast as abs
			frame:FinishBarTransfer(self)
			self:SetScript("OnUpdate", nil)
			if self.idealHeight then
				self:SetHeight(self.idealHeight)
				self.idealHeight = nil
			end
			if self.idealWidth then
				self:SetWidth(self.idealWidth)
				self.idealWidth = nil
			end
		else
			self:SetPoint("CENTER", UIParent, "BOTTOMLEFT", self.GetTransferAnimationPoints(bx, by, fx, fy, self.rate))
			if self.idealHeight then
				local height = self:GetHeight()
				local diff = self.idealHeight - height
				if (diff < 0 and -diff or diff) < 3 then
					self:SetHeight(self.idealHeight)
					self.idealHeight = nil
				else
					self:SetHeight(height + diff * self.rate)
				end
			end
			if self.idealWidth then
				local width = self:GetWidth()
				local diff = self.idealWidth - width
				if (diff < 0 and -diff or diff) < 3 then
					self:SetWidth(self.idealWidth)
					self.idealWidth = nil
				else
					self:SetWidth(width + diff * self.rate)
				end
			end
			self:RefreshIcon(db)
		end
	end
end
