local module = RBM:NewPlugin("Auto Respond")
module:SetDefaultEnabledState(false)

local L = module:GetTranslations()

module:RegisterTranslations("enUS", -- translation automatically generated
	"%.1f secs", true,
	"%d+ days", true,
	"%d+ wks", true,
	"%d:%02d hr", true,
	"%d:%02d secs", true,
	"Auto respond", true,
	"Automatically responds with a message when someone messages you while you're engaged with a boss.", true,
	"Automatically sets your DND flag when you engage a boss.", true,
	"Block incoming whispers", true,
	"Block incoming whispers while engaged with a boss. Whispers from group members will not be blocked. Blocked messages will be shown to you after the boss is disengaged.", true,
	"Chat Frame 1", true,
	"Chat Frame 2", true,
	"Chat Frame 3", true,
	"Chat Frame 4", true,
	"Chat Frame 5", true,
	"Chat Frame 6", true,
	"Chat Frame 7", true,
	"Detailed autoresponse", true,
	"Output frame", true,
	"<RBM> I am currently engaged with %s(%s%%), for %s.  Raid Status: %d/%d", true,
	"<RBM> I am currently engaged with a boss.  Message me later.", true,
	"Responds with detailed information about who you're fighting, for how long, how many are alive and what percentage the boss is at. If this option is disabled a simple response that informs them you're busy will be issued.", true,
	"Set DND flag", true,
	"The frame to send blocked messages to after a fight is over.", true,
	"Unknown", true,
	"Detailed Message", true,
	"Customize the detailed reply message when fighting a boss.", true,
	"<Message>", true,
	"Reset Detailed Message", true,
	"Reset the detailed message to default settings.", true,
	"Normal Message", true,
	"Customize the normal message displayed when fighting a boss.", true,
	"Reset Normal Message", true,
	"Reset the normal message to default settings.", true,
	"|cff82e6ffAll:|r\r|cff51c5dd<boss>|r--Boss Name\r\r|cff51c5dd<bossperc>|r--Bosses current health with \"%\" sign.\r\r|cff51c5dd<bossperctrue>|r--Bosses current health without \"%\" sign.\r\r|cff51c5dd<raidalive>|r--Number of raid memebrs alive and affecting combat.\r\r|cff51c5dd<raiddead>|r--Number of raid members dead.\r\r|cff51c5dd<raidmax>|r--Max number of raid members.\r\r|cff51c5dd<time>|r--Time of how long you have been fighting the boss with label\r\r|cff51c5dd<timetrue>|r--Time of how long you have been fighting the boss without label", true,
	"|cff37FDFCRBM_AutoRespond|r: %d messages received while engaged with %s:", true,
	"|cff37FDFCRBM_AutoRespond|r: [%s]: %s", true
)

module:RegisterTranslations("zhCN",
	"%.1f secs", "%.1f 秒",
	"%d+ days", "%d+ 天",
	"%d+ wks", "%d+ 周",
	"%d:%02d hr", "%d:%02d 小时",
	"%d:%02d secs", "%d:%02d 秒",
	"Auto respond", "自动回复",
	"Automatically responds with a message when someone messages you while you're engaged with a boss.", "在首领战中自动回复密语",
	"Automatically sets your DND flag when you engage a boss.", "在首领战中自动设置勿扰",
	"Block incoming whispers", "阻止密语",
	"Block incoming whispers while engaged with a boss. Whispers from group members will not be blocked. Blocked messages will be shown to you after the boss is disengaged.", "进入首领战后将阻止密语，被阻止的密语会在你退出战斗后显示，当前队伍成员的密语不会被阻止。",
	"Chat Frame 1", "聊天窗口 1",
	"Chat Frame 2", "聊天窗口 2",
	"Chat Frame 3", "聊天窗口 3",
	"Chat Frame 4", "聊天窗口 4",
	"Chat Frame 5", "聊天窗口 5",
	"Chat Frame 6", "聊天窗口 6",
	"Chat Frame 7", "聊天窗口 7",
	"Detailed autoresponse", "自动回复的详情",
	"Output frame", "输出框体",
	"<RBM> I am currently engaged with %s(%s%%), for %s.  Raid Status: %d/%d", "<RBM>我正在与%s(%s%%)作战中, 已持续 %s.  当前团队状况: %d/%d",
	"<RBM> I am currently engaged with a boss.  Message me later.", "<RBM>正在首领战中，请稍后密我。",
	"Responds with detailed information about who you're fighting, for how long, how many are alive and what percentage the boss is at. If this option is disabled a simple response that informs them you're busy will be issued.", "自动回复你正在与谁作战、持续时间、团队状况等详细信息，若这个选项被关闭，则会回复一个你正在首领战中的简单信息。",
	"Set DND flag", "设置勿扰",
	"The frame to send blocked messages to after a fight is over.", "退出战斗后显示密语的框体",
	"Unknown", "未知",
	"Detailed Message", "详细信息",
	"Customize the detailed reply message when fighting a boss.", "自定义详细信息。",
	"<Message>", "<信息>",
	"Reset Detailed Message", "重置自动回复信息",
	"Reset the detailed message to default settings.", "重置自动回复信息为默认设置",
	"Normal Message", "普通信息",
	"Customize the normal message displayed when fighting a boss.", "自定义普通信息。",
	"Reset Normal Message", "重置普通信息",
	"Reset the normal message to default settings.", "重置普通信息为默认设置",
	"|cff82e6ffAll:|r\r|cff51c5dd<boss>|r--Boss Name\r\r|cff51c5dd<bossperc>|r--Bosses current health with \"%\" sign.\r\r|cff51c5dd<bossperctrue>|r--Bosses current health without \"%\" sign.\r\r|cff51c5dd<raidalive>|r--Number of raid memebrs alive and affecting combat.\r\r|cff51c5dd<raiddead>|r--Number of raid members dead.\r\r|cff51c5dd<raidmax>|r--Max number of raid members.\r\r|cff51c5dd<time>|r--Time of how long you have been fighting the boss with label\r\r|cff51c5dd<timetrue>|r--Time of how long you have been fighting the boss without label", "|cff82e6ff所有:|r\r|cff51c5dd<首领>|r--首领名称\r\r|cff51c5dd<bossperc>|r--首领当前血量 \"%\" sign.\r\r|cff51c5dd<bossperctrue>|r--不包含\"%\"标志的首领血量.\r\r|cff51c5dd<raidalive>|r--存活人数。\r\r|cff51c5dd<raiddead>|r--死亡人数。\r\r|cff51c5dd<raidmax>|r--最大成员数.\r\r|cff51c5dd<time>|r--你和该首领战斗的时间\r\r|cff51c5dd<timetrue>|r--你和该首领战斗的时间（无标签）",
	"|cff37FDFCRBM_AutoRespond|r: %d messages received while engaged with %s:", "|cff37FDFCRBM-自动回复|r:在与%s战斗过程中收到%d条信息",
	"|cff37FDFCRBM_AutoRespond|r: [%s]: %s", "|cff37FDFCRBM_自动回复|r: [%s]: %s"
)

module:RegisterTranslations("zhTW",
	"%.1f secs", "%.1f 秒",
	"%d+ days", "%d+ 天",
	"%d+ wks", "%d+ 周",
	"%d:%02d hr", "%d:%02d 小時",
	"%d:%02d secs", "%d:%02d 秒",
	"Auto respond", "自動回覆",
	"Automatically responds with a message when someone messages you while you're engaged with a boss.", "在首領戰中自動回覆密語",
	"Automatically sets your DND flag when you engage a boss.", "在首領戰中自動設置勿擾",
	"Block incoming whispers", "阻止密語",
	"Block incoming whispers while engaged with a boss. Whispers from group members will not be blocked. Blocked messages will be shown to you after the boss is disengaged.", "進入首領戰後將阻止密語，被阻止的密語會在你退出戰鬥後顯示，當前隊伍成員的密語不會被阻止。",
	"Chat Frame 1", "聊天窗口 1",
	"Chat Frame 2", "聊天窗口 2",
	"Chat Frame 3", "聊天窗口 3",
	"Chat Frame 4", "聊天窗口 4",
	"Chat Frame 5", "聊天窗口 5",
	"Chat Frame 6", "聊天窗口 6",
	"Chat Frame 7", "聊天窗口 7",
	"Detailed autoresponse", "自動回覆的詳情",
	"Output frame", "輸出框架",
	"<RBM> I am currently engaged with %s(%s%%), for %s.  Raid Status: %d/%d", "<RBM>我正在與%s(%s%%)作戰中, 已持續 %s.  當前團隊狀況: %d/%d",
	"<RBM> I am currently engaged with a boss.  Message me later.", "<RBM>正在首領戰中，請稍後密我。",
	"Responds with detailed information about who you're fighting, for how long, how many are alive and what percentage the boss is at. If this option is disabled a simple response that informs them you're busy will be issued.", "自動回覆你正在與誰作戰、持續時間、團隊狀況等詳細資訊，若這個選項被關閉，則會回覆一個你正在首領戰中的簡單資訊。",
	"Set DND flag", "設置勿擾",
	"The frame to send blocked messages to after a fight is over.", "退出戰鬥後顯示密語的框架",
	"Unknown", "未知",
	"Detailed Message", "詳細資訊",
	"Customize the detailed reply message when fighting a boss.", "自定義詳細資訊。",
	"<Message>", "<信息>",
	"Reset Detailed Message", "重置自動回覆資訊",
	"Reset the detailed message to default settings.", "重置自動回覆資訊為默認設置",
	"Normal Message", "普通資訊",
	"Customize the normal message displayed when fighting a boss.", "自定義普通資訊。",
	"Reset Normal Message", "重置普通資訊",
	"Reset the normal message to default settings.", "重置普通資訊為默認設置",
	"|cff82e6ffAll:|r\r|cff51c5dd<boss>|r--Boss Name\r\r|cff51c5dd<bossperc>|r--Bosses current health with \"%\" sign.\r\r|cff51c5dd<bossperctrue>|r--Bosses current health without \"%\" sign.\r\r|cff51c5dd<raidalive>|r--Number of raid memebrs alive and affecting combat.\r\r|cff51c5dd<raiddead>|r--Number of raid members dead.\r\r|cff51c5dd<raidmax>|r--Max number of raid members.\r\r|cff51c5dd<time>|r--Time of how long you have been fighting the boss with label\r\r|cff51c5dd<timetrue>|r--Time of how long you have been fighting the boss without label", "|cff82e6ff所有:|r\r|cff51c5dd<首領>|r--首領名稱\r\r|cff51c5dd<bossperc>|r--首領當前血量 \"%\" sign.\r\r|cff51c5dd<bossperctrue>|r--不包含\"%\"標誌的首領血量.\r\r|cff51c5dd<raidalive>|r--存活人數。\r\r|cff51c5dd<raiddead>|r--死亡人數。\r\r|cff51c5dd<raidmax>|r--最大成員數.\r\r|cff51c5dd<time>|r--你和該首領戰鬥的時間\r\r|cff51c5dd<timetrue>|r--你和該首領戰鬥的時間（無標籤）",
	"|cff37FDFCRBM_AutoRespond|r: %d messages received while engaged with %s:", "|cff37FDFCRBM-自動回覆|r:在與%s戰鬥過程中收到%d條資訊",
	"|cff37FDFCRBM_AutoRespond|r: [%s]: %s", "|cff37FDFCRBM_自動回覆|r: [%s]: %s"
)

module:RegisterTranslations("koKR",
	"%.1f secs", "%.1f 초",
	"%d+ days", "%d+ 일",
	"%d+ wks", "%d+ 주",
	"%d:%02d hr", "%d:%02d 시간",
	"%d:%02d secs", "%d:%02d 초",
	"Auto respond", "자동 응답",
	"Automatically responds with a message when someone messages you while you're engaged with a boss.", "당신이 보스 공략중인 동안에 누군가에게 메시지가 오면 자동으로 응답 메시지를 보냅니다.",
	"Automatically sets your DND flag when you engage a boss.", "당신이 보스 공략중이면 다른용무중으로 자동 설정합니다.",
	"Block incoming whispers", "귓속말 차단",
	"Block incoming whispers while engaged with a boss. Whispers from group members will not be blocked. Blocked messages will be shown to you after the boss is disengaged.", "보스 공략중 오는 귓속말을 차단합니다. 그룹 멤버의 귓속말은 차단하지 않습니다. 차단된 메시지는 보스 공략이 끝난 후에 볼 수 있습니다.",
	--"Chat Frame 1", true,
	--"Chat Frame 2", true,
	--"Chat Frame 3", true,
	--"Chat Frame 4", true,
	--"Chat Frame 5", true,
	--"Chat Frame 6", true,
	--"Chat Frame 7", true,
	"Detailed autoresponse", "상세한 자동응답",
	"Output frame", "출력 프레임",
	"<RBM> I am currently engaged with %s(%s%%), for %s.  Raid Status: %d/%d", "<RBM> 저는 현재 공략중으로 %s(%s%%), %s. 공격대 상태: %d/%d",
	"<RBM> I am currently engaged with a boss.  Message me later.", "<RBM> 저는 현재 보스 공략중입니다.",
	"Responds with detailed information about who you're fighting, for how long, how many are alive and what percentage the boss is at. If this option is disabled a simple response that informs them you're busy will be issued.", "당신의 전투에 대해 얼마나 오래, 얼마나 많은 사람들이 살아 있고, 보스가 몇 퍼센트인지 상세한 응답을 합니다. 만약 이 옵션을 비활성화 중이라면 간단한 응답으로 알려줍니다.",
	"Set DND flag", "다른용무중 표시 설정",
	"The frame to send blocked messages to after a fight is over.", "전투가 끝난 후에 차단된 메시지를 이 프레임에 출력합니다.",
	"Unknown", "알수없음",
	"Detailed Message", "상세한 메세지",
	"Customize the detailed reply message when fighting a boss.", "보스와 전투시 상세한 응답 메세지의 사용자 설정입니다.",
	"<Message>", "<메세지>",
	"Reset Detailed Message", "상세한 메세지 초기화",
	"Reset the detailed message to default settings.", "상세 메세지를 설정 기본값으로 초기화합니다.",
	"Normal Message", "보통 메세지",
	"Customize the normal message displayed when fighting a boss.", "보스와 전투시 보통 메세지의 사용자 설정입니다.",
	"Reset Normal Message", "보통 메세지 초기화",
	"Reset the normal message to default settings.", "보통 메세지를 설정 기본값으로 초기화합니다.",
	"|cff82e6ffAll:|r\r|cff51c5dd<boss>|r--Boss Name\r\r|cff51c5dd<bossperc>|r--Bosses current health with \"%\" sign.\r\r|cff51c5dd<bossperctrue>|r--Bosses current health without \"%\" sign.\r\r|cff51c5dd<raidalive>|r--Number of raid memebrs alive and affecting combat.\r\r|cff51c5dd<raiddead>|r--Number of raid members dead.\r\r|cff51c5dd<raidmax>|r--Max number of raid members.\r\r|cff51c5dd<time>|r--Time of how long you have been fighting the boss with label\r\r|cff51c5dd<timetrue>|r--Time of how long you have been fighting the boss without label", "|cff82e6ff모두:|r\r|cff51c5dd<boss>|r--보스 이름\r\r|cff51c5dd<bossperc>|r--보스 현재 체력과 \"%\"표시.\r\r|cff51c5dd<bossperctrue>|r--보스의 현재체력에서 \"%\"만 표시.\r\r|cff51c5dd<raidalive>|r--생존&전투가능한 공격대원의 수.\r\r|cff51c5dd<raiddead>|r--죽은 공격대원의 수.\r\r|cff51c5dd<raidmax>|r--전체 공격대원의 수.\r\r|cff51c5dd<time>|r--보스의 라벨과 전투 시간\r\r|cff51c5dd<timetrue>|r--보스의 라벨을 제외한 전투 시간",
	"|cff37FDFCRBM_AutoRespond|r: %d messages received while engaged with %s:", "|cff37FDFCRBM_자동응답|r: %2$s 전투동안 %1$d개의 메시지를 수신:",
	"|cff37FDFCRBM_AutoRespond|r: [%s]: %s", "|cff37FDFCRBM_자동응답|r: [%s]: %s"
)

local UnitIsDead = UnitIsDead
local UnitName = UnitName
local player = UnitName("player")
local format = string.format
local RBM = RBM
local UnitInRaid = UnitInRaid
local GetNumRaidMembers = GetNumRaidMembers
local GetRaidRosterInfo = GetRaidRosterInfo
local GetNumPartyMembers = GetNumPartyMembers
local UnitHealth = UnitHealth
local SendChatMessage = SendChatMessage

local currentBoss

local db
function module:OnInitialize()
	local function IsHidden()
		return not db
	end
	local function GetOption(info)
		if not db then return end
		return db[info[#info]]
	end
	local function SetOption(info, value)
		db[info[#info]] = value
	end
	self:SetOptionsTable{
		get = GetOption,
		set = SetOption,
		args = {
			BlockIncoming = {
				type = "toggle",
				name = L["Block incoming whispers"],
				desc = L["Block incoming whispers while engaged with a boss. Whispers from group members will not be blocked. Blocked messages will be shown to you after the boss is disengaged."],
				order = 10,
				hidden = IsHidden,
			},
			AutoRespond = {
				type = "toggle",
				name = L["Auto respond"],
				desc = L["Automatically responds with a message when someone messages you while you're engaged with a boss."],
				order = 20,
				hidden = IsHidden,
			},
			DetailedResponse = {
				type = "toggle",
				name = L["Detailed autoresponse"],
				desc = L["Responds with detailed information about who you're fighting, for how long, how many are alive and what percentage the boss is at. If this option is disabled a simple response that informs them you're busy will be issued."],
				disabled = function()
					return not db.AutoRespond
				end,
				hidden = IsHidden,
				order = 30,
			},
			SetDNDFlag = {
				type = "toggle",
				name = L["Set DND flag"],
				desc = L["Automatically sets your DND flag when you engage a boss."],
				order = 40,
				hidden = IsHidden,
			},
			OutputFrame = {
				type = "select",
				name = L["Output frame"],
				desc = L["The frame to send blocked messages to after a fight is over."],
				values = {
					DEFAULT_CHAT_FRAME = L["Chat Frame 1"],
					ChatFrame2 = L["Chat Frame 2"],
					ChatFrame3 = L["Chat Frame 3"],
					ChatFrame4 = L["Chat Frame 4"],
					ChatFrame5 = L["Chat Frame 5"],
					ChatFrame6 = L["Chat Frame 6"],
					ChatFrame7 = L["Chat Frame 7"],
				},
				order = 50,
				hidden = IsHidden,
			},
			CustomResponse = {
				type = "group",
				name = "Custom Responses",
				order = -1,
				hidden = IsHidden,
				args = {
					CustomDetailedResponse = {
						type = "input",
						name = L["Detailed Message"],
						desc = L["Customize the detailed reply message when fighting a boss."],
						usage = L["<Message>"],
						width = "full",
						validate = function(_, msg)
							if msg == "" then
								return L["Error: The message must exist!"]
							elseif msg == " " then
								return L["Error: The message must contain more than a space!"]
							elseif msg:match("^%s%s+") then
								return L["Error: The message must not start with a multiple spaces (or be all spaces)!"]
							end
							return true
						end,
						order = 1,
					},
					ResetDetailedMessage = {
						type = "execute",
						name = L["Reset Detailed Message"],
						desc = L["Reset the detailed message to default settings."],
						order = 10,
						width = "double",
						func = "ResetCustomMessages",
					},
					CustomNormalResponse = {
						type = "input",
						name = L["Normal Message"],
						desc = L["Customize the normal message displayed when fighting a boss."],
						usage = L["<Message>"],
						width = "full",
						validate = function(_, msg)
							if msg == "" then
								return L["Error: The message must exist!"]
							elseif msg == " " then
								return L["Error: The message must contain more than a space!"]
							elseif msg:match("^%s%s+") then
								return L["Error: The message must not start with a multiple spaces (or be all spaces)!"]
							end
							return true
						end,
						order = 20,
					},
					ResetNormalMessage = {
						type = "execute",
						name = L["Reset Normal Message"],
						desc = L["Reset the normal message to default settings."],
						width = "double",
						order = 21,
						func = "ResetCustomMessages",
					},		
					Help = {
						type = "group",
						name = " ",
						order = -1,
						inline = true,
						args = {
							help = {
								type = "description", 
								name = L["|cff82e6ffAll:|r\r|cff51c5dd<boss>|r--Boss Name\r\r|cff51c5dd<bossperc>|r--Bosses current health with \"%\" sign.\r\r|cff51c5dd<bossperctrue>|r--Bosses current health without \"%\" sign.\r\r|cff51c5dd<raidalive>|r--Number of raid memebrs alive and affecting combat.\r\r|cff51c5dd<raiddead>|r--Number of raid members dead.\r\r|cff51c5dd<raidmax>|r--Max number of raid members.\r\r|cff51c5dd<time>|r--Time of how long you have been fighting the boss with label\r\r|cff51c5dd<timetrue>|r--Time of how long you have been fighting the boss without label"],
							},
						},
					},
				},
			},
					
		},
	}

	self.db:RegisterDefaults({
		profile = {
			BlockIncoming = true,
			AutoRespond = true,
			DetailedResponse = true,
			SetDNDFlag = false,
			OutputFrame = "DEFAULT_CHAT_FRAME",
			CustomDetailedResponse = "I am currently busy fighting <boss>(<bossperc>).  Raid Life: <raidalive>/<raidmax>",
			CustomNormalResponse = "I am currently busy fighting a boss.",
		},
	})
end

local function NotInGroup(who)
	if who == player then
		return
	end
	if UnitInRaid("player") then
		for i=1, GetNumRaidMembers() do
			if UnitName("raid"..i) == who then
				return
			end
		end
	else
		for i=1, GetNumPartyMembers() do
			if UnitName("party"..i) == who then
				return
			end
		end
	end
	if UnitInRaid(who) or UnitInParty(who) then return end
	return true
end

local function GetNumAlive()
	local alive, num = 0, 0
	if UnitInRaid("player") then
		for i=1, GetNumRaidMembers() do
			if not UnitIsDeadOrGhost("raid"..i) then
				alive = alive + 1
			end
			if UnitAffectingCombat("raid"..i) or UnitIsDeadOrGhost("raid"..i) then
				num = num + 1
			end
		end
	else
		if not UnitIsDeadOrGhost("player") then alive = 1 end
		for i=1, GetNumPartyMembers() do
			if not UnitIsOrGhostDead("party"..i) then
				alive = alive + 1
			end
			if UnitAffectingCombat("party"..i) or UnitIsDeadOrGhost("party"..i) then
				num = num + 1
			end
		end
	end
	return alive, num
end

local function GetUnitHealth(name)
	if name == UnitName("target") then
		return UnitHealth("target")
	elseif name == UnitName("focustarget") then
		return UnitHealth("focustarget")
	end
	if UnitInRaid("player") then
		for i=1, GetNumRaidMembers() do
			local unit = "raid"..i.."target"
			if UnitName(unit) == name then
				return UnitHealth(unit)
			end
		end
	else
		for i=1, GetNumPartyMembers() do
			local unit = "party"..i.."target"
			if UnitName(unit) == name then
				return UnitHealth(unit)
			end
		end
	end
	return L["Unknown"]
end

local function GetTimeFromStart(val)
	local secs = RBM:GetModule("BossModule", currentBoss):GetSecondsFromStart()
	if not secs then return end
	if secs < 60 then --under a minute
		return format(val and "%.1f" or "%.1f "..L["secs"], secs)
	elseif secs < 3600 then --under an hour
		return format(val and "%d:%02d" or "%d:%02d "..L["min"], secs / 60, secs % 60)
	elseif secs < 86400 then --under a day
		return format(val and "%d:%02d" or "%d:%02d "..L["hr"], secs / 3600, secs % 3600 / 60)
	elseif secs < 604800 then --under a week
		return format(val and "%d+" or "%d+ "..L["days"], secs / 86400)
	else
		return format(val and "%d+" or "%d+ "..L["wks"], secs / 604800)
	end
end

local repliedLst = { }
local messages, messageFrom
local lastSentWhisper, lastSentPlayer
local HookChat
local lastRecievedMsg, lastRecievedPlayer
do
	local orig_ChatFrame_MessageEventHandler
	function HookChat()
		if not orig_ChatFrame_MessageEventHandler then
			orig_ChatFrame_MessageEventHandler = ChatFrame_MessageEventHandler
			function ChatFrame_MessageEventHandler(event, ...) --what a poorly written function Blizzard, you should be ashamed
				if db and currentBoss then
					local arg1, arg2 = arg1, arg2
					if event == "CHAT_MSG_WHISPER" then
						if db and db.BlockIncoming and NotInGroup(arg2) and lastRecievedMsg ~= arg1 and lastRecievedPlayer ~= arg2 then
							do
								local index = #messages + 1
								messages[index] = arg1
								messageFrom[index] = arg2
								lastRecievedMsg = arg1
								lastRecievedPlayer = arg2
							end
							local msg
							if db.AutoRespond then
								if db.DetailedResponse then
									msg = "<RBM>"..db.CustomDetailedResponse
								else
									msg = "<RBM>"..db.CustomNormalResponse
								end
								local alive, max = GetNumAlive()
								msg = msg:gsub("<boss>", currentBoss)
								msg = msg:gsub("<bossperc>", GetUnitHealth(currentBoss).."%%")
								msg = msg:gsub("<bossperctrue>", GetUnitHealth(currentBoss))
								msg = msg:gsub("<raidalive>", alive or 0)
								msg = msg:gsub("<raidmax>", max or 0)
								msg = msg:gsub("<raiddead>", (max - alive) or 0)
								msg = msg:gsub("<time>", GetTimeFromStart() or 0)
								msg = msg:gsub("<timetrue>", GetTimeFromStart(true) or 0)
								if not repliedLst[arg2] then
									SendChatMessage(msg, "WHISPER", nil, arg2)
									repliedLst[arg2] = true
								end
							end
							lastSentWhisper = msg
							lastSentPlayer = arg2
							return
						end
					elseif event == "CHAT_MSG_WHISPER_INFORM" then
						if lastSentWhisper == arg1 then
							return
						end
						lastSentWhisper = nil
					elseif event == "CHAT_MSG_AFK" or event == "CHAT_MSG_DND" then
						if lastSentPlayer == arg2 then
							return
						end
						lastSentPlayer = nil
					end
				end
				return orig_ChatFrame_MessageEventHandler(event, ...)
			end
		end
	end
end

do
	local stop_Orig
	local start_Orig
	function module:OnEnable()
		db = self.db.profile
		self:UpgradeProfiles()
		if HookChat then
			HookChat()
			HookChat = nil
		end
		if not stop_Orig then
			local bmc = RBM.FunctionEnviroment.BossModuleClass
			stop_Orig = bmc.Stop
			start_Orig = bmc.Start
			function bmc:Stop(...)
				if db then
					module:ModuleStopped(self)
				end
				return stop_Orig(self, ...)
			end
			function bmc:Start(...)
				if db then
					module:ModuleStarted(self)
				end
				return start_Orig(self, ...)
			end
		end
		messages = {}
		messageFrom = {}
		
	end
end

function module:OnDisable()
	db = nil
	messages = nil
	messageFrom = nil
end

local function print(...)
	(_G[db.OutputFrame] or DEFAULT_CHAT_FRAME):AddMessage(format(...))
end

function module:ModuleStopped(module)
	currentBoss = nil
	if messages and #messages > 0 then
		print(L["|cff37FDFCRBM_AutoRespond|r: %d messages received while engaged with %s:"], #messages, module:GetName()) --#FORCE_LOCALIZE
		for i, msg in ipairs(messages) do
			print(L["|cff37FDFCRBM_AutoRespond|r: [%s]: %s"], messageFrom[i], msg) --#FORCE_LOCALIZE
		end
		for i=1, #messages do
			messages[i] = nil
			messageFrom[i] = nil
		end
	end
	for i in pairs(repliedLst) do
		repliedLst[i] = nil
	end
	if db.SetDNDFlag and UnitIsDND("player") then
		SendChatMessage("", "DND")
		SendChatMessage("", "DND")
		SendChatMessage("", "DND")
	end
end

function module:ModuleStarted(module)
	currentBoss = module:GetName()
	if db.SetDNDFlag and not UnitIsDND("player") then
		SendChatMessage("", "DND")
	end
	self.startTime = GetTime()
end

function module:ResetCustomMessages(info)
	local type = info[#info]
 	if type == "ResetDetailedMessage" then
		db.CustomDetailedResponse = "I am currently busy fighting <boss>(<bossperc>).  Raid Life: <raidalive>/<raidmax>"
	elseif type == "ResetNormalMessage" then
		db.CustomNormalResponse = "I am currently busy fighting a boss."
	end
end