-- RABuffs_ui.lua
--  Handles command line user interaction / background UI stuff.
-- Version 1.2.3

local RAB_ChatColor_Cache = setmetatable({},{__index=function(t,k)
 local nk = RAID_CLASS_COLORS[type(k) == "string" and k:upper() or k or 0];
 t[k] = nk and ("|cff%02x%02x%02x"):format(nk.r*255, nk.g*255, nk.b*255) or false;
 return t[k];
end});
function RAB_Chat_Color(class, text)
 local c = RAB_ChatColor_Cache[class or 0];
 return c and (c .. text .. "|r") or text;
end
RAB_ChatColor_Cache["Pet"], RAB_ChatColor_Cache["PET"] = "|cffFABFFF", "|cffFABFFF";

local function RAB_BuffTooltipHook(obj, unit, bId)
 local name, _, _, tex, _, left = UnitName(unit), UnitBuff(unit, bId);
 tex = RAB_TextureToBuffKey[tex];
 if tex and name and not left then
  tex = name .. "." .. tex;
  if RAB_BuffTimers and RAB_BuffTimers[tex] then
   local tLeft = RAB_BuffTimers[tex] - GetTime();
   if tLeft > 0 then
    obj:AddLine(sRAB_Tooltip_TimeLeft:format(RAB_TimeFormatOffset(tLeft)));
    obj:Show();
   end
  end
 end
end
hooksecurefunc(GameTooltip, "SetUnitBuff", RAB_BuffTooltipHook);

SLASH_RABUFFSQ1, SLASH_RABUFFSQ2 = "/rq", "/rabq";
SlashCmdList["RABUFFSQ"] = function(msg)
 msg = msg:lower();
 if msg == "" then
  for key, val in pairs(sRAB_Slash_QHelp) do
   RAB_Print(val);
  end
  return;
 end

 local target, buffer, b2, b3 = "CONSOLE", msg:match("^(%S+)");
 if buffer == "raid" or buffer == "party" or buffer == "officer" then
  msg, target = msg:match("^%S+ (.+)$"), strupper(buffer);
 else
  buffer, b2, b3 = msg:match("^([wc]) (%S+) (.+)$");
  if buffer then
   target, msg = (buffer == "c" and "CHANNEL:" or "WHISPER:") .. b2, b3;
  end
 end

 local invert = false;
 if #msg > 4 and msg:sub(1,4) == "not " then
  invert, msg = true, msg:sub(5);
 end

 if string.match(msg,"^%a+ ?[1-8]* ?[mlprdhswa]*") then
  RAB_BuffCheckOutput(msg,target,invert);
 else
  RAB_Print(sRAB_Slash_UnrecognizedQuery,"warn");
 end
end

SLASH_RABUFFS1, SLASH_RABUFFS2 = "/rab", "/rabuffs";
SlashCmdList["RABUFFS"] = function(msg)
 if msg == "config" then
  EC_Raise("RAB_SHOW_UI", "config");
 else
  EC_Raise("RAB_SHOW_UI", "ui");
 end
end

local function RAB_ChatFrame_Colorize(full, name, group, cshort) 
 return cshort and RAB_ClassShort[cshort] and (RAB_Chat_Color(RAB_ClassShort[cshort], name) .. " [G" .. group .. "]") or full;
end
local function RAB_ChatFrame_ColorFilter(t)
 return t:gsub("((%S+) %[G(%d)(%a)%])",RAB_ChatFrame_Colorize);
end
RAB_RegisterChatHook("queryColor", "^<Buffs>.+:.+%[G%d%a%]", RAB_ChatFrame_ColorFilter)

if not UIParent.tinfoil then
	UIParent.tinfoil = true;
	local oldItemRef, oldSendMessage, oldMessageEventHandler, tip = SetItemRef, SendChatMessage, ChatFrame_MessageEventHandler, ItemRefTooltip;
	local al = function(...) for i=1,select("#", ...) do tip:AddLine((select(i, ...)),1,1,1,1); end end
	SetItemRef = function(link, text, button, ...)
		if type(text) == "string" and text:match("%[Tinfoil Hat%]") and button == "LeftButton" and not (IsControlKeyDown() or IsShiftKeyDown() or IsAltKeyDown()) then
			ShowUIPanel(tip);
			if (not tip:IsVisible()) then
				tip:SetOwner(UIParent, "ANCHOR_PRESERVE");
			end
			tip:ClearLines();
			al("|cff0070ddTinfoil Hat|r", "Binds when equipped");
			tip:AddDoubleLine("Head","Cloth",1,1,1,1,1,1);
			al("10 Armor", "-10 Intellect", "+10 Spirit", (UnitLevel("player") < 10) and "|cffff0000Requires Level 10|r" or "Requires Level 10");
			al("|cff00ff00Equip: Hides the wearer's profile from the Armory.|r");
			al("|cff00ff00Equip: Allows the wearer to see \"the truth.\" May lead to an incontrollable urge to share \"the truth\" with others.|r");
			al("|cff00ff00Use: Grants the wearer immunity to all forms of mind control for the next 10 seconds... or does it?|r");
			al("|cffffd517\"On behalf of the International Gnomish Conspiracy, I've got to inform you that we're almost out of tinfoil.\"|r");
			tip:Show();
		else
			return oldItemRef(link, text, button, ...);
		end
	end
	SendChatMessage = function(text, ...)
		if type(text) == "string" then text = text:gsub("|cff0070dd|Hitem:8191:0:0:0:0:0:0:0|h%[Tinfoil Hat%]|h|r", "[Tinfoil hat]"); end
		return oldSendMessage(text, ...);
	end
	local filter = function(str)
		return type(str) == "string" and str:gsub("%[Tinfoil hat%]", "|cff0070dd|Hitem:8191:0:0:0:0:0:0:0|h[Tinfoil Hat]|h|r") or str;
	end
	RAB_RegisterChatHook("tinfoil", "%[Tinfoil hat%]", filter);
end