-- RABuffs_strings.lua
--  Localization code and various release markers, there is no need to touch this file.
-- Version 1.3.0

sRAB_Settings_UIHeader, BINDING_HEADER_RAB = "RABuffs", "RABuffs";
sRAB_DownloadLocations = {["WoWInterface"]="http://www.wowinterface.com/downloads/info5873-RABuffs.html"};

sRAB_LOCALIZATION, sRAB_LOCALIZATION_ui, sRAB_LOCALIZATION_out = {}, "", "";

sRAB_ChangeLog =     [[<html><body>
			<h1 align="center">RABuffs 1.3.0</h1>
			<h2 align="center">&quot;I'll have to improvise!&quot;<br/></h2>
			<h2><br />General</h2>
			<p> - Compatibility fixes for World of Warcraft 3.0.</p>
			<br/></body></html>]];

sRAB_SpellNames = {};

local RAB_Spelltip = CreateFrame("GameTooltip", "RAB_Spelltip", WorldFrame, "GameTooltipTemplate");

function sRAB_Localize(strings, spells)
 if strings then
  sRAB_LOCALIZATION_ui, sRAB_LOCALIZATION_out = "enUS", "enUS";
  sRAB_LOCALIZATION["enUS"].func(true,true);
  if RAB_Settings.uilocale ~= "enUS" and sRAB_LOCALIZATION[RAB_Settings.uilocale] then
   sRAB_LOCALIZATION[RAB_Settings.uilocale].func(true, false);
   sRAB_LOCALIZATION_ui = RAB_Settings.uilocale;
  end
  if RAB_Settings.outlocale ~= "enUS" and sRAB_LOCALIZATION[RAB_Settings.outlocale] then
   sRAB_LOCALIZATION[RAB_Settings.outlocale].func(false, true);
   sRAB_LOCALIZATION_out = RAB_Settings.outlocale;
  end
 end
 if spells then
  sRAB_PseudoLocalize();
 end
 EC_Raise("RAB_LOCALIZATION_LOADED", strings, spells);
end
function sRAB_Buffname(bkey, fortext)
 local larr = _G["sRAB_BuffNames_" .. tostring(_G["sRAB_LOCALIZATION_" .. (fortext and "out" or "ui")])];
 return larr and larr[bkey] and larr[bkey] or (RAB_Buffs[bkey] and RAB_Buffs[bkey].name or "");
end
function sRAB_Class(enClass, fortext)
 local larr = _G["sRAB_Classes_" .. tostring(_G["sRAB_LOCALIZATION_" .. (fortext and "out" or "ui")])];
 return larr and larr[enClass] and larr[enClass] or enClass;
end
function RAB_TimeFormatOffset(tmr)
 return ("%d:%02d"):format(tmr / 60, tmr % 60);
end
function sRAB_QueryType(bkey)
 local mod = "buff";
 if not RAB_Buffs[bkey] then
 elseif RAB_Buffs[bkey].type and _G["sRAB_BuffType_" .. RAB_Buffs[bkey].type] then mod = RAB_Buffs[bkey].type
 elseif RAB_Buffs[bkey].sfunc then mod = "other";
 end
 return _G["sRAB_BuffType_" .. mod], mod;
end
function sRAB_QueryString(bkey)
 local qicon, b = "", RAB_Buffs[bkey] and RAB_Buffs[bkey].textures;
 if b then qicon = "|TInterface\\Icons\\" .. (b[2] or b[1]) .. ":16:16:0:-1|t "; end
 return qicon .. sRAB_Buffname(bkey) .. " |c00" .. (sRAB_SpellNames[bkey] and "4488ee[" or "999999[") .. sRAB_QueryType(bkey) .. "]|r";
end

function sRAB_PseudoLocalize()
 local i = select(3, GetSpellTabInfo(2)) + 1;
 if i == 1 then return; end

 local aTex, mc = {}, RAB_UnitClass("player");
 for k, v in pairs(RAB_Buffs) do
  if v.castClass == mc then
   aTex[v.textures[1]] = k;
   if v.bigcast then aTex[v.textures[2]] = v.bigcast; end
  end
 end

 local mana, manaCost, sKey = 0, {};
 RAB_Spelltip:SetOwner(RABFrame, "ANCHOR_LEFT");
 for b = 1, 2 do
  local booktype = b == 1 and BOOKTYPE_SPELL or BOOKTYPE_PET;
  while GetSpellName(i, booktype) do
   sKey = aTex[GetSpellTexture(i,booktype):match("([^/\\]+)$")];
   if sKey then
    RAB_Spelltip:ClearLines(); RAB_Spelltip:SetSpell(i, booktype);
    mana = tonumber(RAB_SpelltipTextLeft2:GetText():match("%d+"));
    if (not manaCost[sKey] or mana > manaCost[sKey]) and (b == 1 or RAB_Buffs[sKey].source == "pet") then
     sRAB_SpellNames[sKey], manaCost[sKey] = GetSpellName(i, booktype), mana;
     if RAB_Buffs and RAB_Buffs[sKey] and RAB_Buffs[sKey].linkSpell then
      sRAB_SpellNames[RAB_Buffs[sKey].linkSpell] = sRAB_SpellNames[sKey];
     end
    end
   end
   i = i + 1;
  end
  i = 1;
 end
end
EC_Register("PLAYER_LOGIN", "RAB_localizationInit", function() sRAB_Localize(true, true); return "remove"; end);
EC_Register("LEARNED_SPELL_IN_TAB", "RAB_spellSync", function() sRAB_Localize(false, true) end);
EC_Register("PET_BAR_UPDATE", "RAB_spellSyncPet", function() sRAB_Localize(false, true); end);
RAB_Spelltip:SetScript("OnUpdate", RAB_Spelltip.Hide);