-- RABuffs_net.lua
--  Networking bridge, parsing of incoming chat/addon messages, sending available information.
-- Version 1.2.3

local gS_State, gS_Channel, gS_AChannel = 0, "rabuffsgvsync"; -- rabuffsgvsync
local RAB_VersionStringMatch = "^([%w.]+) (%d+)[.,](%d+) ?(%a?)";

local RAB_RA_BuffsMask = "(%a%w+) (%d+)";
local RAB_RA_ItemMask = "i(%d+) (%d+)";
local RAB_BI_ItemMask = "i%[(%d+)%]=(%d+)";
local RAB_BI_TalentMask = "t%[(%S+)%]=(%d+)";
local RAB_BS_FullMask = "%[([^%]]+)%]=(%d+)";

RAB_Versions, RAL_Versions = {}, {}; -- [Realm.Name] = {name=Name,v=display,d=compare,l=lastseen}.
RAB_BuffTimers = {}; -- Name.query = expire;
RAB_ItemCount = {}; -- Name.iid = count;
RAB_Talents = {}; -- Name.tid = points;

local RAB_SyncItemIDs = {8079,22018,34062};
local RAB_TimerSpells = {}; -- [Name] = bkey

local function RAB_Net_SpellsUpdated(event, ui, spells)
 if spells then
  for k in pairs(RAB_TimerSpells) do RAB_TimerSpells[k] = nil; end
  for key, val in pairs(sRAB_SpellNames) do
   if RAB_Buffs[key] and RAB_Buffs[key].type == "timer" then
    RAB_TimerSpells[val] = key;
   end
  end
 end
end

function RAB_Net_GetVersionString(prefix)
	return ("%s%s %s %s"):format(prefix or "", RABuffs_Version, RABuffs_DeciVersion, (RABuffs_LiveVersion and " L" or " B"));
end
function RAB_IsRABEnabled(name, minversion)
	local v = RAB_Versions[GetRealmName() .. "." .. name];
	return v and v.l > (time()-259200) and v.d >= (minversion or 0);
end
function RAB_UpdatePeople(nick, realm, versionstring)
	local display, version1, version2, live = versionstring:match(RAB_VersionStringMatch);
	if not display then return; end
	local version, s, realmNick = tonumber(version1) + tonumber(version2)/(10^#version2), RAB_Settings, (realm or GetRealmName()) .. "." .. nick;
	if (version > RABuffs_DeciVersion and version > s.newestVersion) and (live == "L" or s.betanotification or not RABuffs_LiveVersion) then
		s.newestVersion, s.newestVersionTitle, s.newestVersionUser = version, display, realmNick;
	end
	RAB_Versions[realmNick] = RAB_Versions[realmNick] or {};
	local t = RAB_Versions[realmNick];
	t.v, t.d, t.l, t.ltag, t.name, t.rname  = display, version, time(), live, nick, realmNick;
	return true;
end

-- [[Global version sync block: join/leave, send, read data]]
hooksecurefunc("UIParent_OnEvent", function (e, a1, ...)
	if e == "CHANNEL_PASSWORD_REQUEST" and a1 == gS_EatPasswordRequest then
		StaticPopup_Hide("CHAT_CHANNEL_PASSWORD");
		gS_EatPasswordRequest = nil;
	end
end);
local function gS_Event(event, message, author, language, cfullname, ctarget, sflags, zoneid, cnumber, cname)
 if cname:lower() == gS_AChannel and message:sub(1,5) == "RABV " then
	RAB_UpdatePeople(author, nil, message:match("^RABV (.+)"));
 end
end
local function gS_AdvanceChannel(...)
	if event == "CHAT_MSG_CHANNEL_NOTICE" and arg9 == gS_AChannel then
		gS_EatPasswordRequest = arg9;
		gS_AChannel = gS_AChannel:match("^%a+") .. (tonumber(gS_AChannel:match("(%d+)$") or 0)+1);
		return nil, JoinChannelByName(gS_AChannel);
	end
	return ...;
end
function gS_JoinChannel()
	if GetChannelName(gS_Channel) == 0 and gS_State == 0 then
		gS_AChannel = gS_Channel;
	  for i=7,10 do
	   if GetChannelName(i) == 0 then
	    JoinChannelByName(gS_Channel);
	    break;
	   end
	  end
	end
  if GetChannelName(gS_AChannel) ~= 0 and gS_State == 0 then
   EC_Register("CHAT_MSG_CHANNEL","gSync",gS_Event);
   EC_Register("RAB_LOGOUT","gSyncLeave", function() LeaveChannelByName(gS_AChannel); end)
   RAB_RegisterChatHook("gSyncMove", "^WRONG_PASSWORD$", gS_AdvanceChannel);
	 gS_State = 1;
  end
end
local function gS_LeaveChannel()
	LeaveChannelByName(gS_AChannel);
	EC_Unregister("CHAT_MSG_CHANNEL","gSync");
	EC_Unregister("RAB_LOGOUT","gSyncLeave");
	RAB_RegisterChatHook("gSyncMove");
	gS_State = 0;
end
local function gS_Timer()
	local h, m = GetGameTime();
	if m >= 57 and gS_State == 0 then
		gS_JoinChannel();
	elseif m > 3 and m < 57 and gS_State ~= 0 then
		gS_LeaveChannel();
	elseif m == 0 and gS_State == 1 then
		gS_State = 2, RAB_SendMessage(RAB_Net_GetVersionString("RABV "), "CHANNEL:" .. gS_AChannel);
	end
end

local function RAB_Net_ReadRAL(event, mtype, message, channel, sender)
	if mtype == "RAL/VC" or mtype == "RAL/V" then
		local release, caption = message:match("^(%d+) ([%w.]+)");
		if release then
			local name, realm = sender:match("^([^-]+)-(.+)$");
			if not name then name, realm = sender, GetRealmName(); end
			local lkey = realm .. "." .. name;
			RAL_Versions[lkey] = RAL_Versions[lkey] or {};
			RAL_Versions[lkey].name, RAL_Versions[lkey].v, RAL_Versions[lkey].d, RAL_Versions[lkey].l = name, caption, tonumber(release), time();
		end
	end
end
local function RAB_Net_ReadNative(event, mtype, message, channel, sender)
	if mtype:sub(1,4) ~= "RAB/" then return; end

	if channel == "RAID" or channel == "PARTY" then
		if mtype == "RAB/BT" then
			for key, dur in message:gmatch(RAB_RA_BuffsMask) do
				RAB_BuffTimers[sender .. "." .. key] = GetTime() + tonumber(dur);
			end
		elseif mtype == "RAB/BI" then
			for key, val in message:gmatch(RAB_BI_ItemMask) do
				RAB_ItemCount[sender .. "." .. key] = tonumber(val);
			end
			for key, val in message:gmatch(RAB_BI_TalentMask) do
				RAB_Talents[sender .. "." .. key] = tonumber(val);
			end
		elseif mtype == "RAB/BS" then
			for id, time in message:gmatch(RAB_BS_FullMask) do
				RAB_BuffTimers[id] = GetTime() + tonumber(time);
			end

		elseif mtype == "RAB/RD" then
			RAB_PendingRes[sender] = {"self", GetTime()+60};
		elseif mtype == "RAB/RN" then
			RAB_PendingRes[sender] = nil;
		elseif mtype == "RAB/RE" then
			RAB_PendingRes[message] = {sender, GetTime()+15};
		elseif mtype == "RAB/RO" then
			RAB_PendingRes[message] = {sender, GetTime()+60};
		elseif mtype == "RAB/RF" and RAB_PendingRes[message] and RAB_PendingRes[message][2] == sender then  
			RAB_PendingRes[message] = nil;

		elseif mtype == "RAB/BR" then
			local out, cl, pl = "", RAB_UnitClass("player"), UnitName("player");
			for key, val in pairs(RAB_Buffs) do
				if (val.castClass == cl and not sRAB_SpellNames[key]) then
					out = out .. "c[" .. key .. "]=no ";
				elseif (val.castClass == cl and val.talent ~= nil) then
					RAB_Talents[pl .. "." .. val.talent] = select(5,GetTalentInfo(tonumber(strsub(val.talent,1,1)), tonumber(strsub(val.talent,2,3))));
					out = out .. "t[" .. key .. "]=" .. RAB_Talents[pl .. "." .. val.talent] .. " ";
				end
			end
			SendAddonMessage("RAB/BC", strsub(out,1,245), channel);
		end
	end

	if mtype == "RAB/V" or mtype == "RAB/VC" then
		local name, realm = sender:match("^([^-]+)-(.+)$");
		local valid = RAB_UpdatePeople(name or sender, realm, message);
		if mtype == "RAB/VC" and valid then
			SendAddonMessage("RAB/V", RAB_Net_GetVersionString(), channel, sender);
		end
	end
end
local function RAB_Net_SendVersionOnGroupChange(event, arg1, arg2)
	if (arg1 > 0 and arg2 < 1) or (arg1 == 3 and arg2 < 3) then
		SendAddonMessage("RAB/VC", RAB_Net_GetVersionString(), arg1 == 3 and "BATTLEGROUND" or (arg1 == 2 and "RAID" or "PARTY"));
	end
end
local function RAB_Net_SendRessed()
	SendAddonMessage("RAB/RD", "RESSED", UnitInRaid("player") and "RAID" or "PARTY");
end
local function RAB_Net_SendResStatus(event, resTarget)
	local handle = (event == "RAB_RESCAST_SENT") and "RAB/RE" or ((event == "RAB_RESCAST_OK") and "RAB/RO" or "RAB/RF");
	SendAddonMessage(handle,resTarget,UnitInRaid("player") and "RAID" or "PARTY");
end


local function RAB_Net_SendBuffData(noout)
	local pl, otarg, out = UnitName("player"), (UnitInRaid("player") and "RAID" or (GetNumPartyMembers() > 0 and "PARTY" or "")), "";
 
	for spell, key in pairs(RAB_TimerSpells)  do
		local start, duration = GetSpellCooldown(spell);
		start = floor((start == 0) and 0 or (duration < 5 and 0 or (start + duration - GetTime())));
		out = out .. (out ~= "" and " " or "") .. key .. " " .. start;
		RAB_BuffTimers[pl .. "." .. key] = GetTime() + start;
	end
	
	if otarg ~= "" and out ~= "" and not noout then
		SendAddonMessage("RAB/BT", out, otarg);
	end
end
local function RAB_Net_SendCapsData()
	local out, otarg = "", "", (UnitInRaid("player") and "RAID" or (GetNumPartyMembers() > 0 and "PARTY" or ""));
	local pl, cl, d = UnitName("player"), RAB_UnitClass("player"), {};
	for key, val in pairs(RAB_SyncItemIDs) do
		RAB_ItemCount[pl .. "." .. val] = RAB_CountItems(val);
		out, d[val] = out .. "i[" .. val .. "]=" .. RAB_ItemCount[pl .. "." .. val] .. " ", true;
	end
	for key, val in pairs(RAB_Buffs) do
		if val.castClass == cl and val.reg ~= nil and not d[val.reg] then
			RAB_ItemCount[pl .. "." .. val.reg] = RAB_CountItems(val.reg);
			out, d[val.reg] = out .. "i[" .. val.reg .. "]=" .. RAB_ItemCount[pl .. "." .. val.reg] .. " ", true;
		end
	end
	if otarg ~= "" and out ~= "" then
		SendAddonMessage("RAB/BI", out, otarg);
	end
end
local function RAB_Net_SendSelfUpdateData()
	local om, buff = "";
	if (GetNumRaidMembers() + GetNumPartyMembers()) == 0 then return; end
	for k in pairs(RAB_RecentlyChangedBuffsCastBySelf) do
		if RAB_BuffTimers[k] then
			buff = "[" .. k .. "]=" .. floor(RAB_BuffTimers[k] - GetTime());
			if strlen(om) + strlen(buff) < 240 then
				om = om .. (om == "" and "" or " ") .. buff;
				RAB_RecentlyChangedBuffsCastBySelf[k] = nil;
			end
		end
	end
	if om ~= "" then
		SendAddonMessage("RAB/BS", om, UnitInRaid("player") and "RAID" or "PARTY"); 
	end
end
local function RAB_Net_SendUsedTimerCast(event, unit, spell, rank) 
	if unit == "player" and RAB_TimerSpells[spell] then
		local duration = RAB_Buffs[RAB_TimerSpells[spell]].cd;
		RAB_BuffTimers[UnitName("player") .. "." .. RAB_TimerSpells[spell]] = GetTime() + duration;
		SendAddonMessage("RAB/BT", RAB_TimerSpells[spell] .. " " .. duration, "RAID");
	end
end

local function RAB_Net_Init()
	EC_Timer("RAB_gSync", gS_Timer, 50);
	if IsInGuild() then
		SendAddonMessage("RAB/VC", RABuffs_Version .. " " ..RABuffs_DeciVersion .. (RABuffs_LiveVersion and "L" or "B"), "GUILD");
	end
	RAB_Net_SendBuffData(true);
	return "remove";
end

EC_Register("RAB_RESCAST_SENT", "RAB.net.ressent", RAB_Net_SendResStatus);
EC_Register("RAB_RESCAST_FAIL", "RAB.net.resfail", RAB_Net_SendResStatus);
EC_Register("RAB_RESCAST_OK", "RAB.net.resok", RAB_Net_SendResStatus);
EC_Register("RAB_GROUPSTATUS", "RAB.sendvc", RAB_Net_SendVersionOnGroupChange);
EC_Register("CHAT_MSG_ADDON", "RAB.netNative", RAB_Net_ReadNative);
EC_Register("CHAT_MSG_ADDON", "RAB.netRAL", RAB_Net_ReadRAL);
EC_Register("RESURRECT_REQUEST", "RAB.sendRessed", RAB_Net_SendRessed);
EC_Register("PLAYER_ENTERING_WORLD", "RAB.net.init", RAB_Net_Init);
EC_Register("RAB_LOCALIZATION_LOADED", "RAB.Net.SpellsUpdate", RAB_Net_SpellsUpdated);
EC_Register("UNIT_SPELLCAST_SUCCEEDED","RAB.Net.QuickTimer", RAB_Net_SendUsedTimerCast);

--Timers at prime intervals to minimize stacking. Triple every 4 hours; double every ~7 and ~19 minutes.
EC_Timer("RAB.sendNative", RAB_Net_SendBuffData, 31);
EC_Timer("RAB.sendNativeExt", RAB_Net_SendCapsData, 37);
EC_Timer("RAB.sendNativeShare", RAB_Net_SendSelfUpdateData, 13);