-- RABuffs_data.lua
--  Handles actual querying, and owns related tables.
-- Version 1.2.3

RAB_BuffTimers = {}; -- Name.query = expire;
RAB_ItemCount = {}; -- Name.itemid = count;
RAB_PendingRes = {}; -- Name = {resbyName, expire}
RAB_AssignedBuffs = {} -- Name = { {query="", assignBy="", scope, stuff?}, ... }
RAB_RecentlyChangedBuffsCastBySelf = {}; -- ["Name.bkey"]=true
local RAB_CurrentResTarget, RAB_CurrentSpellTarget;

function RAB_ShouldRecast(unit, cmd, isbuffed)
 local bkey = UnitName(unit) .. "." .. cmd;
 if (RAB_BuffTimers[bkey] ~= nil and RAB_BuffTimers[bkey] > GetTime() and RAB_Buffs[cmd].recast ~= nil) then
  if (isbuffed) then
   local fadetime = RAB_BuffTimers[bkey] - GetTime();
   if (fadetime < RAB_Buffs[cmd].recast*60) then
    return true, fadetime;
   end
   return false, fadetime;
  else
   RAB_BuffTimers[bkey] = 0;
  end
 end
 return false;
end
function RAB_ResetRecastTimer(unit, cmd, castType)
 local m;
 if (castType == nil) then
  RAB_BuffTimers[UnitName(unit) .. "." .. cmd] = 0;
 else
  m = RAB_ClassShort[RAB_UnitClass(unit)];
  if (castType == "group") then
   for i, u, g in RAB_GroupMembers("all") do
    if (UnitIsUnit(unit, u)) then
     m = g; break;
    end
   end
  end
  for i, u in RAB_GroupMembers("all " .. tostring(m)) do
   RAB_BuffTimers[UnitName(u) .. "." .. cmd] = 0;
  end
 end
end
function RAB_IsEligible(u, cmd)
 local c = RAB_Buffs[cmd];
 if ((c.incoffline or UnitIsConnected(u)) and (c.incdead or not RAB_UnitIsDead(u))) then
  if ((c.type ~= "self" or RAB_UnitClass(u) == c.castClass) and
      not (c.ignoreClass and c.ignoreClass:match(RAB_ClassShort[RAB_UnitClass(u)]))) then
   return true;
  end
 end
 return false;
end
function RAB_UnitIsDead(unit) -- Still hopelessly bugged.
 return (UnitIsDeadOrGhost(unit) and not RAB_isUp(UnitBuff, unit,"Ability_Rogue_FeignDeath"));
end
local fnc = setmetatable({},{__index=function(t,k) t[k] = tostring(k); return t[k]; end});
local lastUpIndex, lastUpTextureIndex = {}, {};
function RAB_isUp(func, unit, buff)
 if not (unit and buff and func) then return false; end
 local i, len, lk, name, tex, stack = 1, -#buff, fnc[func]..unit..buff;
 if lastUpIndex[lk] then
  name, _, tex, stack = func(unit, lastUpIndex[lk]);
  if name and tex:sub(len) == buff then return true, stack; end
 end
 while 1 do
  name, _, tex, stack = func(unit,i);
  if not name then
   lastUpIndex[lk] = nil;
   return false;
  elseif tex:sub(len) == buff then
   lastUpIndex[lk] = i;
   return true, stack;
  end
  i = i + 1;
 end
end
function RAB_IsBuffUp(unit, bkey)
 if (RAB_Buffs[bkey].sfm == 2) then
  return (RAB_Buffs[bkey].sfunc(unit) and true or false), false;
 elseif (RAB_Buffs[bkey].sfm == 3) then
  return RAB_Buffs[bkey].sfunc(unit, bkey);
 elseif (RAB_Buffs[bkey].type == "custom") then
  return RAB_MiniCustom(unit, bkey);
 elseif RAB_Buffs[bkey].textures then
  local b, func = false, (RAB_Buffs[bkey].type == "debuff") and UnitDebuff or UnitBuff;
  local last = lastUpTextureIndex[bkey .. unit];
  if last and RAB_isUp(func, unit, RAB_Buffs[bkey].textures[last]) then
   return true, RAB_ShouldRecast(unit, bkey, true);
  end
  for i=1,#RAB_Buffs[bkey].textures do
   if i ~= last and RAB_isUp(func, unit, RAB_Buffs[bkey].textures[i]) then
    lastUpTextureIndex[bkey .. unit] = i;
    return true, RAB_ShouldRecast(unit, bkey, true);
   end
  end
  lastUpTextureIndex[bkey .. unit] = nil;
  return false, RAB_ShouldRecast(unit, bkey, false);
 end
end
function RAB_ResolveHeader(bkey, type)
 bkey = (RAB_Buffs[bkey].loc ~= nil and RAB_Buffs[bkey].loc or bkey);
 local s = getglobal("sRAB_BuffOutput_" .. bkey .. "_" .. type);
 return (s and s or getglobal("sRAB_BuffOutput_Default_" .. type));
end
function RAB_IsBeingRessed(name)
 for key, val in pairs(RAB_PendingRes) do
  if (key == name and val ~= nil and val[2] ~= nil and val[2] > GetTime()) then
   return true;
  elseif (val[2] ~= nil and val[2] < GetTime()) then
   RAB_PendingRes[key] = nil;
  end
 end
 return false;
end


function RAB_OwnResurrectCastEvent(event, unit, spell, rank, target)
 if (unit == "player") then
  local myres = sRAB_SpellNames[strlower(select(2,UnitClass("player"))).."res"];
  if (event == "UNIT_SPELLCAST_SENT" and spell == myres) then
   RAB_PendingRes[target] = {UnitName("player"),GetTime()+11};
   EC_Raise("RAB_RESCAST_SENT", target);
   RAB_CurrentResTarget, RAB_CurrentSpellTarget = target, nil;
  elseif (event == "UNIT_SPELLCAST_SENT") then 
   RAB_CurrentSpellTarget, RAB_CurrentResTarget = target, nil;
  elseif (event == "UNIT_SPELLCAST_SUCCEEDED") then
   if (RAB_CurrentResTarget ~= nil) then
    RAB_PendingRes[RAB_CurrentResTarget] = {UnitName("player"),GetTime()+60};
    EC_Raise("RAB_RESCAST_OK", RAB_CurrentResTarget);
   end
   RAB_CurrentResTarget, RAB_CurrentSpellTarget = nil, nil;
  elseif (RAB_CurrentResTarget ~= nil) then
   RAB_PendingRes[RAB_CurrentResTarget] = nil;
   EC_Raise("RAB_RESCAST_FAIL", RAB_CurrentResTarget);
   RAB_CastLog[RAB_CurrentResTarget], RAB_CurrentResTarget = GetTime()+15, nil;
  elseif (RAB_CurrentSpellTarget ~= nil) then
   RAB_CastLog[RAB_CurrentSpellTarget], RAB_CurrentSpellTarget = GetTime()+15, nil;
  end
 end
end
EC_Register("UNIT_SPELLCAST_SENT","RAB.spellState",RAB_OwnResurrectCastEvent);
EC_Register("UNIT_SPELLCAST_FAILED","RAB.spellState",RAB_OwnResurrectCastEvent);
EC_Register("UNIT_SPELLCAST_INTERRUPTED","RAB.spellState",RAB_OwnResurrectCastEvent);
EC_Register("UNIT_SPELLCAST_SUCCEEDED","RAB.spellState",RAB_OwnResurrectCastEvent);


-- BLOCK 1: Query functions
function RAB_DefaultQueryHandler(query, cmd, otype, oinvert)
 local buffed, fading, total, raw, tOut = 0, 0, 0, (otype ~= 0 and {} or nil), "";
 oinvert = not not oinvert;
 if RAB_Buffs[cmd].invert then oinvert = not oinvert; end

 local b, iF, fT;
 for i, u, g in RAB_GroupMembers(query) do
  if RAB_IsEligible(u, cmd) then
   b, iF, fT, append, custom = RAB_IsBuffUp(u, cmd);
   if b ~= nil then
    total, buffed, fading = total + 1, buffed + (b and 1 or 0), fading + (iF and 1 or 0);
    if (otype ~= 0 and (otype == 1 or (b == oinvert or (iF and not oinvert)))) then
     tinsert(raw, {unit=u, name=UnitName(u), class=RAB_UnitClass(u), group=g, buffed=b, fading=iF, fade=fT, append=append, custom=custom, kstate=(iF and 2 or (b and 1 or 0))});
    end
    if RAB_Buffs[cmd].unique and RAB_UnitClass(u) ~= RAB_Buffs[cmd].castClass then
     total = total - 1;
    end
   end
  end
 end
 total = max(buffed, total);

 if otype == 0 then
  return buffed, fading, total;
 else
  local header = RAB_ResolveHeader(cmd, (oinvert and "Okay" or ((buffed < total or fading == 0) and "Missing" or "Expire")));
  local rawsort, rawgroup = (RAB_Buffs[cmd].sort == "class" and "class" or (RAB_Buffs[cmd].sort == nil and "group" or RAB_Buffs[cmd].sort)), (RAB_Buffs[cmd].sort ~= nil and "%s" or sRAB_Core_GroupFormat);
  if RAB_Buffs[cmd].sort ~= nil and otype == 2 then 
   rawsort, rawgroup = RAB_Buffs[cmd].sort, "%s"; 
  elseif RAB_Buffs[cmd].textsort ~= nil and otype == 1 then
   rawsort, rawgroup = RAB_Buffs[cmd].textsort, "%s";
  end
  table.sort(raw, function(a,b) return a[rawsort] < b[rawsort]; end);

  if (otype == 1) then
   if (total == 0) then
    tOut = sRAB_BuffOutput_Zero;
   elseif (buffed == 0) then
    tOut = (oinvert and sRAB_BuffOutput_NoOne or sRAB_BuffOutput_Everyone);
   elseif (buffed == total and fading == 0 and (buffed > 3 or not oinvert)) then
    tOut = (oinvert and sRAB_BuffOutput_Everyone or sRAB_BuffOutput_NoOne);
   else
    local bstate = fading ~= 0 and 2 or 1; -- 0: is not buffed; 1: is buffed; 2: is fading.
    if (RAB_Buffs[cmd].textsort ~= nil) then rawsort, rawgroup = RAB_Buffs[cmd].textsort, (RAB_Buffs[cmd].textsort == "group" and sRAB_Core_GroupFormat or "%s"); end
    if (total ~= buffed or RAB_Buffs[cmd].type == "timer") then bstate = oinvert and 1 or 0; end -- Partial hack, "fading" for timers does not make sense
    tOut = RAB_GenerateCompactOutput(raw, bstate, rawsort, rawgroup);
   end
   local summary = (total > 0 and buffed > 0 and total ~= buffed) and string.format(" [%s / %s] ", oinvert and buffed or (total-buffed) , total) or " ";
   return string.format(header, sRAB_Buffname(cmd, true)) .. summary .. tOut .. ".";
  elseif (otype == 2) then
   if (not oinvert) then
    i = 1;
    while (i <= table.getn(raw)) do
     if (raw[i].buffed == oinvert or (buffed == total and raw[i].fading and not oinvert)) then
      i = i + 1
     else
      tremove(raw, i);
     end
    end
   end
   return buffed, fading, total, raw, rawsort, rawgroup, string.format(header, sRAB_Buffname(cmd));
  end
 end
end
function RAB_GenerateCompactOutput(raw, ks, sort, group)
 local tOut, tBuff, miss, hit, ident, i = "", "",0,0;
 GLX, GLY = raw, {ks, sort, group};
 for i=1,#raw do
  if (raw[i][sort] ~= ident) then
   if (miss == 0 and hit > 1) then tBuff = string.format(group,ident) .. " [" .. hit .. "]"; end
   if (RAB_Settings.compactoutput and hit > 1) then tBuff = string.format(group,ident) .. " [" .. hit .. "/"..(hit+miss).."]"; end
   if (hit > 0) then tOut = tOut .. (tOut == "" and "" or ", ") .. tBuff; end
   ident, tBuff, hit, miss = raw[i][sort],"",0,0;
  end
  if (raw[i].kstate == ks or (ks == 1 and raw[i].kstate == 2)) then
   tBuff, hit = tBuff .. (tBuff == "" and "" or ", ") .. raw[i].name .. " [G" .. raw[i].group .. RAB_ClassShort[raw[i].class] .."]" .. ((fades and raw[i].fade ~= nil) and " (" .. RAB_TimeFormatOffset(raw[i].fade) .. ")" or "") .. (raw[i].append ~= nil and raw[i].append or ""), hit + 1;
  else
   miss = miss + 1;
  end
 end
 if (miss == 0 and hit > 1) then tBuff = string.format(group,ident) .. " [" .. hit .. "]"; end
 if (RAB_Settings.compactoutput and hit > 1) then tBuff = string.format(group,ident) .. " [" .. hit .. "/"..(hit+miss).."]"; end
 if (hit > 0) then tOut = tOut .. (tOut == "" and "" or ", ") .. tBuff; end
 return tOut;
end
function RAB_QueryStatus(msg) -- Overview.
 local out, buffed, total, _ = "", 0, 0;
 local glspaced = string.match(msg,"%a+( %w+)") or "";
 buffed, _, total = RAB_GetQueryResult("ai" .. glspaced);
 out = out .. "AI: " .. buffed .. "/" .. total .. ", ";
 buffed, _, total = RAB_GetQueryResult("pwf" .. glspaced)
 out = out .. "PWF: " ..  buffed .. "/" .. total .. ", ";
 buffed, _, total = RAB_GetQueryResult("motw" .. glspaced)
 out = out .. "MoTW: " ..  buffed .. "/" .. total .. ", ";
 buffed, _, total = RAB_GetQueryResult("bos" .. glspaced)
 out = out .. "BoS: " ..  buffed .. "/" .. total .. ", ";
 buffed, _, total = RAB_GetQueryResult("bok" .. glspaced)
 out = out .. "BoK: " ..  buffed .. "/" .. total .. ", ";
 buffed, _, total = RAB_GetQueryResult("bom" .. glspaced)
 out = out .. "BoM: " ..  buffed .. "/" .. total .. ", ";
 buffed, _, total = RAB_GetQueryResult("bow" .. glspaced)
 out = out .. "BoW: " ..  buffed .. "/" .. total .. ", ";

 buffed, _, total = RAB_GetQueryResult("ss" .. glspaced)
 out = out .. buffed .. " SS.";	
 return out;
end
function RAB_QueryBuffInfo()
 local buffs, debuffs, i,b, bn = "","",1;
 if (not UnitExists("target")) then
  return sRAB_BuffOutput_BuffInfo_NoTarget,sRAB_BuffOutput_BuffInfo_NoTarget;
 end
 while (UnitBuff("target",i)) do
  b = string.sub(select(3, UnitBuff("target",i)),17);
  bn = RAB_TextureToBuffKey[b];
  if bn then
   b = "[" .. sRAB_Buffname(bn,true) .. "]";
  end
  buffs = buffs .. (buffs  == "" and "" or ", ") .. b;
  i = i + 1;
 end
 i = 1;
 while (UnitDebuff("target",i)) do
  b = string.sub(select(3,UnitDebuff("target",i)),17);
  debuffs = debuffs .. (debuffs == "" and "" or ", ") .. b;
  i = i + 1;
 end
 return string.format(sRAB_BuffOutput_BuffInfo_General,UnitName("target"),(buffs == "" and sRAB_BuffOutput_BuffInfo_None or buffs), (debuffs == "" and sRAB_BuffOutput_BuffInfo_None or debuffs));
end
function RAB_QueryBlank(msg, cmd, otype, oinvert)
 if (otype == 0 or otype == 2) then
  return 0, 0, 0, nil;
 end
end
function RAB_MiniHere(u)
 local b, a = true, "";
 if not UnitIsPlayer(u) then return nil;
 elseif (not UnitIsConnected(u)) then b, a = false, sRAB_BuffOutput_Here_OFF;
 elseif (UnitIsAFK(u)) then b, a = false, sRAB_BuffOutput_Here_AFK;
 elseif (not (UnitIsVisible(u) or UnitInRaid("player"))) then b, a = false, sRAB_BuffOutput_Here_OOS;
 elseif (not UnitIsVisible(u)) then
  b, _, _, _, _, _, _, a = false, GetRaidRosterInfo(tonumber(strsub(u,5)));
 end
 return b, false, nil, nil, a == nil and "" or a;
end
function RAB_MiniAlive(u, bkey)
 local alive = not RAB_UnitIsDead(u);
 return alive, alive and ((UnitHealthMax(u) * 0.25) > UnitHealth(u));
end
function RAB_MiniHealthRequirement(u, bkey)
 local hp = UnitHealth(u);
 return hp > RAB_Buffs[bkey].ext, false;
end
function RAB_MiniInventory(u, bkey)
 local slot, match = string.match(RAB_Buffs[bkey].ext,"(%d+):(%d+)");
 slot = tonumber(slot);
 if (CheckInteractDistance(u,1) and GetInventoryItemLink(u,slot)) then
  item = string.match(tostring(GetInventoryItemLink(u,slot)),"item:(%d+):");
  return (item == match), false;
 end
end
function RAB_QueryMana(msg, cmd, otype, oinvert)
	local buffed, fading, total, misc, tOut, raw, i, u, g, b, f, a = 0,0,0,"", "", (otype == 2 and {} or nil);
	local mana_dead, mana_oom = 0, 0;

	for i,u,g in RAB_GroupMembers(msg) do
		if (UnitPowerType(u) == 0) then 
			if (RAB_UnitIsDead(u)) then
				mana_dead, f, a = mana_dead + 1, true, sRAB_BuffOutput_Mana_DeadAppend;
			else
				b, f = UnitMana(u), UnitMana(u)/UnitManaMax(u) < 0.15;
				buffed, fading, total, mana_oom = buffed + b, fading + (f and b or 0), total + UnitManaMax(u), mana_oom + (f and 1 or 0);
				a = " (" .. min(100,floor(UnitMana(u) * 100 / UnitManaMax(u))) .. "%)";
			end
			if (f == (not oinvert)) then
				if (otype == 1) then
					tOut = tOut .. (tOut == "" and "" or ", ") .. UnitName(u) .. a;
				elseif (otype == 2) then
					tinsert(raw, {name=UnitName(u), class=RAB_UnitClass(u), group=g, buffed=not f, unit=u, append=a});
				end
			end
		end 
	end
	if (otype == 0) then
		return buffed, fading, total;
	elseif (otype == 1) then
		return string.format(sRAB_BuffOutput_Mana_Summary, buffed, total, (total > 0) and floor(buffed * 100 / total) or 0) .. " " .. tOut;
	elseif (otype == 2) then
		if (UnitInRaid("player") and table.getn(raw) > 1) then table.sort(raw,function (a,b) return a.group < b.group end); end
		return buffed, fading, total, raw, "group", nil, (oinvert and sRAB_BuffOutput_Mana_Fine or sRAB_BuffOutput_Mana_OutOfMana);
	end
end
function RAB_MiniWater(u)
 local p = UnitName(u);
 if (RAB_ItemCount[p .. ".34062"] == nil) then return nil; end
 return RAB_ItemCount[p .. ".34062"] > 0, (RAB_ItemCount[p .. ".34062"] <= 5 and RAB_ItemCount[p .. ".34062"] > 0), nil, " (" .. RAB_ItemCount[p .. ".34062"] .. ")";
end
function RAB_MiniDebuff(u, bkey)
 local btype = RAB_Buffs[bkey].ext;
 local f = (btype == "SELF") and 1 or 0;
 if (RAB_UnitIsDead(u)) then
  return nil;
 else
  local f, i, type = (btype == "SELF") and 1 or 0, 1;
  while (UnitDebuff(u,i,f) ~= nil) do
   _, _, type = UnitDebuff(u,i,f);
   if (f == 1 or type == btype or (type == nil and btype == "")) then
    return true;
   end
   i = i + 1;
  end
  return false;
 end
end
function RAB_MiniTimer(u, bkey)
 local p = UnitName(u) .. ".";
 if (RAB_BuffTimers[p .. bkey] == nil) then
  return nil;
 elseif (RAB_Buffs[bkey] ~= nil and RAB_Buffs[bkey].reg ~= nil and RAB_ItemCount[p .. RAB_Buffs[bkey].reg] == 0) then
  return false, false, nil, sRAB_BuffOutput_NoReagents;
 else
  return (RAB_BuffTimers[p .. bkey] < GetTime()), false, nil, (RAB_BuffTimers[p .. bkey] - GetTime() > 0 and " (" .. RAB_TimeFormatOffset(RAB_BuffTimers[p .. bkey] - GetTime()) .. ")" or "");
 end
end
function RAB_MiniCustom(unit, bkey)   
 if (RAB_Buffs[bkey] == nil or RAB_Buffs[bkey].ctype == nil) then return nil; end   
 local cfunc, i = UnitBuff, 1;   
 if (RAB_Buffs[bkey].ctype == 2) then cfunc = UnitDebuff; end   
 while true do   
  local bName, _, bTex = cfunc(unit, i);   
  if (bName == nil or bTex == nil) then   
   return false, false;   
  elseif (string.match(RAB_Buffs[bkey].cmtype == 1 and bName or bTex, RAB_Buffs[bkey].cmatch)) then   
   return true, false;   
  end   
  i = i + 1;   
 end   
end

function RAB_CountItems(itemId, justNeedSlot)
 local bag, slot, count = 0,0,0;

 itemId = tostring(itemId);
 for i=0, 4 do
  for j = 1, GetContainerNumSlots(i) do
   local link = GetContainerItemLink(i, j);
   if (link ~= nil) then
    local id = string.match(link, "item:(%d+):");
    if (id == itemId) then
     local _, itemCount = GetContainerItemInfo(i,j);
     count = count + itemCount;
     bag, slot = i, j;
     if (justNeedSlot ~= nil) then return count, bag, slot; end
    end
   end
  end
 end
 return count, bag, slot;
end

-- BLOCK 2: Casting functions
function RAB_GetCastTarget(mode, query)
 local cmd = type(query) == "string" and query:match("^(%a+)");
 if mode == "cast" then
	EC_Raise("RAB_INTERNAL_SYNCGROUPSTATE");
 end
 if RAB_Buffs[cmd] and RAB_Buffs[cmd].buffFunc then
  return RAB_Buffs[cmd].buffFunc(mode, query);
 elseif RAB_Buffs[cmd] then
  return RAB_DefaultCastingHandler(mode, query);
 end
end
function RAB_DefaultCastingHandler(mode, query)
 local playerClass, cmd, clicktocast = RAB_UnitClass("player"), query:match("^(%a+)"), sRAB_Tooltip_ClickToCast;
 local istip = (mode == "tip");

 if RAB_Buffs[cmd].castClass ~= playerClass or sRAB_SpellNames[cmd] == nil or RAB_Buffs[cmd].nocast then
  return false;
 elseif RAB_Buffs[cmd].type == "timer" then
  return false;
 elseif playerClass == "Druid" and not IsUsableSpell(sRAB_SpellNames[cmd]) and RAB_IsBuffUp("player","druidshift") then
  return istip and sRAB_Tooltip_CastFail_Shapeshift;
 end

 if RAB_Buffs[cmd].type == "self" or RAB_Buffs[cmd].type == "aura" then
  local isup, recast = RAB_IsBuffUp("player",cmd);
  if (isup and not recast) then
   return false;
  end
  local buff = sRAB_SpellNames[cmd];
  local canbuff, reason, farg = RAB_CastSpell_IsSpellCastable(buff, istip);
  if (not canbuff) then
   return istip and _G["sRAB_Tooltip_CastFail_" .. reason]:format(farg);
  end
  if istip then
   return string.format(isup and sRAB_Tooltip_ClickToRecastNeutral or sRAB_Tooltip_ClickToCastNeutral, buff);
  else
   RAB_ResetRecastTimer("player",cmd);
--   RAB_Print(string.format(sRAB_CastBuff_CastNeutral,buff));
   return buff;
  end
 end

 local dogroupbuff, mygroup, bigkey = IsAltKeyDown(), 0, RAB_Buffs[cmd].bigcast;
 if RAB_Settings.castbigbuffs then dogroupbuff = not dogroupbuff; end
 if not (bigkey and sRAB_SpellNames[bigkey] and RAB_CastSpell_IsSpellCastable(sRAB_SpellNames[bigkey],true)) then dogroupbuff = false; end
 if RAB_Settings.cheapbgbuffs and RAB_CurrentGroupStatus == 3 then dogroupbuff = false; end

 local canbuff, reason, farg = RAB_CastSpell_IsSpellCastable(sRAB_SpellNames[cmd], istip);
 if not (canbuff or dogroupbuff) then
  return istip and _G["sRAB_Tooltip_CastFail_" .. reason]:format(farg);
 end

 if (UnitInRaid("player") and RAB_Settings.partymode) then
  for i=1,40 do 
   if (UnitIsUnit("raid" .. i, "player")) then
    _, _, mygroup = GetRaidRosterInfo(i);
    break;
   end
  end
 end 

 local people, group, i, u, g, ir = {};
 local pvpfail, rangefail = 0,0;
 for i, u, g in RAB_GroupMembers(query) do
  local n = UnitName(u);
  local ekey = n .. "." .. cmd;
  local pri = UnitIsUnit("player",u) and (RAB_Buffs[cmd].selfPriority ~= nil and RAB_Buffs[cmd].selfPriority or 9) or 1;
  if (g == mygroup) then pri = pri + 1; end
  if (RAB_CastLog[n] ~= nil and RAB_CastLog[n] >= time()) then pri = pri / 10; end
  if (RAB_Buffs[cmd].priority ~= nil and RAB_Buffs[cmd].priority[strlower(RAB_UnitClass(u))] ~= nil) then pri = pri + RAB_Buffs[cmd].priority[strlower(RAB_UnitClass(u))]; end
  if (RAB_IsEligible(u,cmd) and RAB_IsSanePvP(u) and IsSpellInRange(sRAB_SpellNames[cmd], u) == 1 and pri > 0) then
   if (not RAB_IsBuffUp(u,cmd)) then
    tinsert(people,{u=u,group=g,class=RAB_UnitClass(u),p=pri});
   elseif (RAB_ShouldRecast(u, cmd, true) and pri > 0) then
    if not (RAB_Settings.forcefulself and UnitIsUnit("player", u)) then pri = pri / 10; end
    if RAB_CastLog[n] and RAB_CastLog[n] >= time() then pri = pri / 15; end
    tinsert(people,{u=u,group=g,class=RAB_UnitClass(u),p=pri,recast=true})
   end
  elseif RAB_IsEligible(u,cmd) and pri > 0 then
   if not RAB_IsSanePvP(u) then
    pvpfail = pvpfail + 1;
   elseif not RAB_IsBuffUp(u,cmd) and not IsSpellInRange(sRAB_SpellNames[cmd], u) == 1 then
    rangefail = rangefail + 1;
   end
  end
 end


 if #people == 0 then
  if not istip then 
   if (pvpfail > 0 or rangefail > 0) then
    UIErrorsFrame:AddMessage(sRAB_CastingLayer_NoCast:format(sRAB_Buffname(cmd), pvpfail, rangefail), 1, 0, 0, 1, 1.5);
   else
    UIErrorsFrame:AddMessage(sRAB_CastingLayer_NoNeed:format(sRAB_Buffname(cmd)), 1, 0, 0, 1, 1.5);
   end
  end
  return false;
 end

 if (dogroupbuff and table.getn(people) < RAB_Buffs[cmd].bigthreshold and not RAB_Settings.alwayscastbigbuffs) then dogroupbuff = false; end
 if (dogroupbuff and IsUsableSpell(sRAB_SpellNames[RAB_Buffs[cmd].bigcast])) then
  local bsort, bsortkeys, stype = {}, {}, RAB_Buffs[cmd].bigsort;
  for key, val in pairs(people) do
   if (bsortkeys[val[stype]] == nil) then
    tinsert(bsort,{pri=val.p,cast=val.u,heads=1,key=val[stype]});
    bsortkeys[val[stype]] = table.getn(bsort);
   else
    local ckey = bsortkeys[val[stype]];
    bsort[ckey].pri, bsort[ckey].heads = bsort[ckey].pri + val.p, bsort[ckey].heads + 1;
   end
  end
  table.sort(bsort,function (a,b) return (a.heads == b.heads) and (a.pri > b.pri) or (a.heads > b.heads) end);
  if (bsort[1].heads >= RAB_Buffs[cmd].bigthreshold or RAB_Settings.alwayscastbigbuffs) then
   local bname = sRAB_SpellNames[RAB_Buffs[cmd].bigcast];
   if istip then
    return string.format(clicktocast, bname, RAB_Chat_Color(RAB_UnitClass(bsort[1].cast), UnitName(bsort[1].cast)) .. " [" .. bsort[1].key .. "]");
   else
    RAB_ResetRecastTimer(bsort[1].cast, cmd, RAB_Buffs[cmd].bigsort);
--    RAB_Print(string.format(sRAB_CastBuff_Cast, bname, RAB_Chat_Color(RAB_UnitClass(bsort[1].cast), UnitName(bsort[1].cast) .. " [" .. bsort[1].key .. "]")));    
    return bname, bsort[1].cast;
   end
  end
 end

 table.sort(people,function (a,b) return (a.p > b.p) end);
 if (people[1].recast) then clicktocast = sRAB_Tooltip_ClickToRecast; end
 local bname = sRAB_SpellNames[cmd] ~= nil and sRAB_SpellNames[cmd] or RAB_Buffs[cmd].name;
 if istip then
  return string.format(clicktocast,bname, RAB_Chat_Color(RAB_UnitClass(people[1].u), UnitName(people[1].u))); 
 else
  RAB_ResetRecastTimer(people[1].u,cmd);   
--  RAB_Print(string.format(sRAB_CastBuff_Cast, bname, RAB_Chat_Color(RAB_UnitClass(people[1].u), UnitName(people[1].u))));
  return bname, people[1].u;
 end
end
function RAB_CastResurrect(mode, msg)
 local res, i, u = sRAB_SpellNames[strlower(RAB_UnitClass("player")) .. "res"];
 if not res then return false; end
 local istip = (mode == "tip");

 local canbuff, reason, farg = RAB_CastSpell_IsSpellCastable(res, istip);
 if not canbuff then
  return istip and _G["sRAB_Tooltip_CastFail_" .. reason]:format(farg);
 end

 local toRes = {}; -- {u="",pri=deci};
 for i, u, group in RAB_GroupMembers(msg) do
  local n = UnitName(u);
  if (UnitIsUnit(u,"player") ~= 1 and UnitIsVisible(u) and (RAB_UnitIsDead(u) and not UnitIsGhost(u)) and RAB_IsSanePvP(u) and IsSpellInRange(res, u) == 1) then
   if (not RAB_IsBeingRessed(UnitName(u))) then
    local pri = (RAB_UnitClass(u) == "Priest" and 2 or 0) + (RAB_UnitClass(u) == "Paladin" and 2 or 0) + (RAB_UnitClass(u) == "Shaman" and 2 or 0) + (RAB_UnitClass(u) == "Mage" and 1 or 0) + (RAB_Versions[UnitName(u)] ~= nil and 0.25 or 0);
    if (RAB_CastLog[n] ~= nil and RAB_CastLog[n] > GetTime()) then pri = pri / 15; end
    tinsert(toRes, {u=u,pri=pri});
   end
  end
 end
 if (table.getn(toRes) == 0) then
  return false;
 elseif (table.getn(toRes) > 1) then
  table.sort(toRes,function (a,b) return a.pri > b.pri end);
 end

 if istip then
  return sRAB_Tooltip_ClickToCast:format(res, RAB_Chat_Color(RAB_UnitClass(toRes[1].u), UnitName(toRes[1].u)));
 else
  return res, toRes[1].u;
 end
end
function RAB_CastWater(mode, msg)
 if sRAB_SpellNames.water == nil or not RAB_CastSpell_IsSpellCastable(sRAB_SpellNames.water,true) then
  return;
 end
 if mode == "tip" then
  return string.format(sRAB_Tooltip_ClickToCastNeutral,sRAB_SpellNames.water);
 else
  return sRAB_SpellNames.water;
 end
end

function RAB_QueryInRange(query, unit)
 local cmd = string.match(query,"^(%a+)");
 if (RAB_Buffs[cmd] ~= nil and RAB_Buffs[cmd].userange ~= nil) then
  return (RAB_Buffs[cmd].userange == "inrange" and true or RAB_QueryInRange(RAB_Buffs[cmd].userange,unit));
 end
 if (RAB_Buffs[cmd] == nil or RAB_Buffs[cmd].type == "debuff" or RAB_Buffs[cmd].type == "self" or RAB_Buffs[cmd].type == "aura" or RAB_Buffs[cmd].buffFunc ~= nil or sRAB_SpellNames[cmd] == nil) then 
  return (UnitIsVisible(unit) == 1);
 else
  return (IsSpellInRange(sRAB_SpellNames[cmd],unit) == 1);
 end
end

-- BLOCK 3: Query definitions
RAB_Buffs, RAB_CBuffs, RAB_OBuffs = 	{
			ai={name="Arcane Intellect",bigcast="ab",bigsort="group",bigthreshold=3,textures={"Spell_Holy_MagicalSentry", "Spell_Holy_ArcaneIntellect"},ignoreClass="wr",castClass="Mage",priority={priest=0.5,druid=0.5,paladin=0.4,shaman=0.4,warlock=0.3},recast=5,reg=17020},
			dampen={name="Dampen Magic",textures={"Spell_Nature_AbolishMagic"},castClass="Mage",recast=3},
			amplify={name="Amplify Magic",textures={"Spell_Holy_FlashHeal"},castClass="Mage",recast=3},
			barrier={name="Ice Barrier",textures={"Spell_Ice_Lament"},castClass="Mage",type="self",invert=true},
			block={name="Ice Block",textures={"Spell_Frost_Frost"},castClass="Mage",type="self",invert=true},
			magearmor={name="Mage Armor",textures={"Spell_MageArmor"},castClass="Mage",type="self",recast=5},
			frostarmor={name="Frost Armor",textures={"Spell_Frost_FrostArmor02"},castClass="Mage",type="self",recast=5},
			moltenarmor={name="Molten Armor",textures={"Ability_Mage_MoltenArmor"},castClass="Mage",type="self",recast=5},
			water={name="Water",type="special",textures={"INV_Drink_18"},castClass="Mage",sfunc=RAB_MiniWater, sfm=3,incdead=true, incoffline=true,buffFunc=RAB_CastWater,description="H2O data as reported by RABuffs.",ignoreClass="rw"},
			fireward={name="Fire Ward",textures={"Spell_Fire_FireArmor"},castClass="Mage",type="self"},
			frostward={name="Frost Ward",textures={"Spell_Frost_FrostWard"},castClass="Mage",type="self"},

			pwf={name="Power Word: Fortitude",bigsort="group",bigthreshold=3,bigcast="pof",textures={"Spell_Holy_WordFortitude", "Spell_Holy_PrayerOfFortitude"},castClass="Priest",recast=5, reg=17029, talent="104", talentmax=2},
			sprot={name="Shadow Protection",bigsort="group",bigthreshold=3,bigcast="posprot",textures={"Spell_Shadow_AntiShadow","Spell_Holy_PrayerofShadowProtection"},castClass="Priest",recast=3, reg=17029},
			ds={name="Divine Spirit",bigsort="group",bigthreshold=3,bigcast="pos",textures={"Spell_Holy_DivineSpirit","Spell_Holy_PrayerofSpirit"},ignoreClass="wr",castClass="Priest",priority={priest=0.5,druid=0.3,mage=0.4,paladin=0.3},recast=5, reg=17029, talent="115", talentmax=2},
			pws={name="Power Word: Shield",textures={"Spell_Holy_PowerWordShield"},castClass="Priest",invert=true},
			fearward={name="Fear Ward",textures={"Spell_Holy_Excorcism"},castClass="Priest",invert=true,recast=3},
			innerfire={name="Inner Fire",textures={"Spell_Holy_InnerFire"},castClass="Priest",type="self",recast=3},
			pi={name="Power Infusion",textures={"Spell_Holy_PowerInfusion"},castClass="Priest",ignoreClass="wrh",priority={priest=0.2,druid=0.2,mage=0.5,warlock=0.5},selfPriority=0},

			motw={name="Mark of the Wild",bigcast="gotw",bigsort="group",bigthreshold=3,textures={"Spell_Nature_Regeneration","Spell_Nature_GiftoftheWild"},castClass="Druid",recast=5,reg=22148, talent="301", talentmax=5},
			thorns={name="Thorns",textures={"Spell_Nature_Thorns"},castClass="Druid",recast=3},
			clarity={name="Omen of Clarity",textures={"Spell_Nature_CrystalBall"},castClass="Druid",type="self",recast=5},
			rebirth={name="Rebirth",textures={"Spell_Nature_Reincarnation"},castClass="Druid",type="timer",cd=1200,invert=true, loc="timer", sfunc=RAB_MiniTimer, sfm=3, incdead=true, reg=22147, userange="motw"},
			innervate={name="Innervate", textures={"Spell_Nature_Lightning"},castClass="Druid",type="timer",cd=360,invert=true, loc="timer", sfunc=RAB_MiniTimer, sfm=3, incdead=true},
			druidshift={name="Shapeshifted",textures={"Ability_Druid_TravelForm","Ability_Racial_BearForm","Ability_Druid_CatForm","Ability_Druid_AquaticForm", "Ability_Druid_FlightForm", "Spell_Nature_ForceOfNature", "Ability_Druid_TreeofLife"},type="dummy",castClass="Druid"},

			bos={name="Blessing of Salvation",bigcast="gbos",bigsort="class",bigthreshold=3,textures={"Spell_Holy_SealOfSalvation","Spell_Holy_GreaterBlessingofSalvation"},castClass="Paladin",priority={priest=0.5,druid=0.5,mage=0.4,warlock=0.4,paladin=0.4},sort="class",recast=5, reg=21177},
			bow={name="Blessing of Wisdom",bigcast="gbow",bigsort="class",bigthreshold=3,textures={"Spell_Holy_SealOfWisdom","Spell_Holy_GreaterBlessingofWisdom"},ignoreClass="wr",castClass="Paladin",priority={priest=0.5,druid=0.5,mage=0.4,warlock=0.4,paladin=0.4},sort="class",recast=5, reg=21177, talent="110", talentmax=2},
			bok={name="Blessing of Kings",bigcast="gbok",bigsort="class",bigthreshold=3,textures={"Spell_Magic_MageArmor","Spell_Magic_GreaterBlessingofKings"},castClass="Paladin",sort="class",recast=5, reg=21177, talent="206",talentmax=1},
			bol={name="Blessing of Light",bigcast="gbol",bigsort="class",bigthreshold=3,textures={"Spell_Holy_PrayerOfHealing02","Spell_Holy_GreaterBlessingofLight"},castClass="Paladin",sort="class",recast=5, reg=21177},
			bom={name="Blessing of Might",bigcast="gbom",bigsort="class",bigthreshold=3,textures={"Spell_Holy_FistOfJustice","Spell_Holy_GreaterBlessingofKings"},ignoreClass="mpl",castClass="Paladin",sort="class",recast=5, reg=21177, talent="301", talentmax=5},
			bosanc={name="Blessing of Sanctuary",bigcast="gbosanc",bigsort="class",bigthreshold=3,textures={"Spell_Nature_LightningShield","Spell_Holy_GreaterBlessingofSanctuary"},castClass="Paladin",sort="class",recast=5, reg=21177},
			bop={name="Blessing of Protection",textures={"Spell_Holy_SealOfProtection"},castClass="Paladin",unique=true},
			command={name="Seal of Command",textures={"Ability_Warrior_InnerRage"},castClass="Paladin",type="self"},
			devotion={name="Devotion Aura",textures={"Spell_Holy_DevotionAura"},castClass="Paladin",type="aura"},
			concentration={name="Concentration Aura",textures={"Spell_Holy_MindSooth"},castClass="Paladin",type="aura"},
			fireaura={name="Fire Resistance Aura",textures={"Spell_Fire_SealOfFire"},castClass="Paladin",type="aura"},
			shadowaura={name="Shadow Resistance Aura",textures={"Spell_Shadow_SealOfKings"},castClass="Paladin",type="aura"},
			retribution={name="Retribution Aura",textures={"Spell_Holy_AuraOfLight"},castClass="Paladin",type="aura"},
			frostaura={name="Frost Resistance Aura",textures={"Spell_Frost_WizardMark"},castClass="Paladin",type="aura"},
			di={name="Divine Intervention",textures={"Spell_Nature_TimeStop"},castClass="Paladin",priority={priest=2,paladin=2,druid=1,mage=0.5},selfPriority=-10, reg=17033, linkSpell="dit"},
			dit={name="Divine Intervention",type="timer",cd=3600,castClass="Paladin",textures={"Spell_Nature_TimeStop"},invert=true, loc="timer", sfunc=RAB_MiniTimer, sfm=3, incdead=true, reg=17033, userange="bom", linkSpell="di"},
			loht={name="Lay on Hands",type="timer",cd=3600,castClass="Paladin",textures={"Spell_Holy_LayOnHands"},invert=true, loc="timer", sfunc=RAB_MiniTimer, sfm=3, incdead=true, userange="bom"},
			rfury={name="Righteous Fury",type="self",castClass="Paladin",textures={"Spell_Holy_SealOfFury"},invert=true},

			ss={name="Soulstone",textures={"Spell_Shadow_SoulGem"},castClass="Warlock",nocast=true,invert=true,unique=true,recast=5},
			ub={name="Unending Breath",textures={"Spell_Shadow_DemonBreath"},castClass="Warlock",recast=3},
			detectinvisibility={name="Detect Invisibility",textures={"Spell_Shadow_DetectLesserInvisibility"},castClass="Warlock",recast=3},
			demonarmor={name="Demon Armor",textures={"Spell_Shadow_RagingScream"},castClass="Warlock",type="self",recast=5},
			felarmor={name="Fel Armor",textures={"Spell_Shadow_FelArmour"},castClass="Warlock",type="self",recast=5},
			bloodpact={name="Blood Pact",textures={"Spell_Shadow_BloodBoil"},castClass="Warlock",type="aura", source="pet"},
			paranoia={name="Paranoia",textures={"Spell_Shadow_AuraOfDarkness"},castClass="Warlock",invert=true, type="aura", source="pet"},
			voidsac={name="Sacrifice",textures={"Spell_Shadow_SacrificialShield"},castClass="Warlock",type="self",source="pet",invert=true},

			hawk={name="Aspect of the Hawk",textures={"Spell_Nature_RavenForm"},castClass="Hunter",type="self"},
			cheetah={name="Aspect of the Cheetah",textures={"Ability_Mount_JungleTiger"},castClass="Hunter",type="self"},
			beast={name="Aspect of the Beast",textures={"Ability_Mount_PinkTiger"},castClass="Hunter",type="self"},
			aspectwild={name="Aspect of the Wild",textures={"Spell_Nature_ProtectionformNature"},castClass="Hunter",type="aura"},
			pack={name="Aspect of the Pack",textures={"Ability_Mount_WhiteTiger"},castClass="Hunter",type="aura"},
			monkey={name="Aspect of the Monkey",textures={"Ability_Hunter_AspectOfTheMonkey"},castClass="Hunter",type="self"},
			trueshot={name="True Shot Aura",textures={"Ability_TrueShot"},castClass="Hunter",type="aura"},

			waterwalk={name="Waterwalking",textures={"Spell_Frost_WindWalkOn"}, castClass="Shaman", recast=1},
			waterbreath={name="Water breathing",textures={"Spell_Shadow_DemonBreath"}, castClass="Shaman", recast=1},
			reincarnate={name="Reincarnation",type="timer",cd=3600,castClass="Shaman",textures={"Spell_Nature_Reincarnation"},invert=true, loc="timer", sfunc=RAB_MiniTimer, sfm=3, incdead=true, reg=17030,userange="inrange"},
			watershield={name="Water Shield",textures={"Ability_Shaman_WaterShield"}, castClass="Shaman", recast=1, type="self"},
			lightningshield={name="Lightning Shield",textures={"Spell_Nature_LightningShield"}, castClass="Shaman", recast=1, type="self"},
			earthshield={name="Earth Shield",textures={"Spell_Nature_SkinofEarth"}, castClass="Shaman", recast=1, invert=true, unique=true},
			heroism={name="Heroism", textures={"Ability_Shaman_Heroism"}, castClass="Shaman", cd=600, type="timer", invert=true, loc="timer", sfunc=RAB_MiniTimer, sfm=3, incdead=true, userange="inrange", linkSpell="hero"},
			bloodlust={name="Blood Lust", textures={"Spell_Nature_BloodLust"}, castClass="Shaman", cd=600, type="timer", invert=true, loc="timer", sfunc=RAB_MiniTimer, sfm=3, incdead=true, userange="inrange", linkSpell="lust"},
			hero={name="Heroism", textures={"Ability_Shaman_Heroism"}, castClass="Shaman", type="aura", linkSpell="heroism"},
			lust={name="Blood Lust", textures={"Ability_Nature_BloodLust"}, castClass="Shaman", type="aura", linkSpell="bloodlust"},
			manatide={name="Mana Tide", textures={"Spell_Frost_SummonWaterElemental"}, castClass="Shaman", cd=600, type="timer", invert=true, loc="timer", sfunc=RAB_MiniTimer, sfm=3, incdead=true, userange="inrange"},

			battleshout={name="Battle Shout",textures={"Ability_Warrior_BattleShout"},castClass="Warrior",type="aura"},
			laststand={name="Last Stand",type="timer",cd=480,castClass="Warrior",textures={"Spell_Holy_AshesToAshes"},invert=true, loc="timer", sfunc=RAB_MiniTimer, sfm=3, incdead=true,userange="inrange"},
			shieldwall={name="Shield Wall",type="timer",cd=1800,castClass="Warrior",textures={"Ability_Warrior_ShieldWall"},invert=true, loc="timer", sfunc=RAB_MiniTimer, sfm=3, incdead=true,userange="inrange"},

			flag={name="Battleground Flag",textures={"INV_BannerPVP_01","INV_BannerPVP_02","Inv_Misc_SummerFest_BrazierGreen"},invert=true,havebuff="Carrying flag",missbuff="No flag"},
			battlestandard={name="Battle Standard",textures={"INV_Banner_02","INV_Banner_01"},invert=true,type="item"},

			regen={name="Eat/Drink",textures={"INV_Drink_18","INV_Drink_07","INV_Misc_Fork&Knife"},invert=true,havebuff="Consuming beverages",missbuff="Starving",type="item"},

			frostmark={name="Mark of Frost",textures={"Spell_Frost_ChainsOfIce"},invert=true,type="debuff"},
			naturemark={name="Mark of Nature",textures={"Spell_Nature_SpiritArmor"},invert=true,type="debuff"},
			dcurse={name="Curses",sfunc=RAB_MiniDebuff, sfm=3,ext="Curse",type="debuff",invert=true, loc="debuff"},
			dmagic={name="Magic debuffs",sfunc=RAB_MiniDebuff, sfm=3,ext="Magic",type="debuff",invert=true, loc="debuff"},
			ddisease={name="Diseases",sfunc=RAB_MiniDebuff, sfm=3,ext="Disease",type="debuff",invert=true, loc="debuff"},
			dpoison={name="Poisons",sfunc=RAB_MiniDebuff, sfm=3,ext="Poison",type="debuff",invert=true, loc="debuff"},
			dtypeless={name="Typeless debuffs",sfunc=RAB_MiniDebuff, sfm=3,ext="",type="debuff",invert=true, loc="debuff"},
			dicanremove={name="Debuffs I can remove",sfunc=RAB_MiniDebuff, sfm=3,ext="SELF",type="debuff",invert=true, loc="debuff"},

			incombat={name="In Combat",sfunc=UnitAffectingCombat,sfm=2,havebuff="In Combat",missbuff="Out of combat",invert=true, description="Displays people currently in combat"},
			pvp={name="PvP Enabled",sfunc=UnitIsPVP,sfm=2,invert=true,havebuff="PvP Enabled",missbuff="Not PvP Enabled", description="Displays people currently flagged for PvP."},
			alive={name="Alive",type="special",sfunc=RAB_MiniAlive,sfm=3, incdead=true, incoffline=true, buffFunc=RAB_CastResurrect,description="Number of people alive versus total headcount; life is marked as fading at X% health."},
			mana={name="Mana",type="special",queryFunc=RAB_QueryMana,description="Sum of current mana vs sum of max mana; segment is marked as fading if caster has less than 15% left.",ignoreClass="rw"},
			status={name="Status",type="special",queryFunc=RAB_QueryStatus,description="Displays buff sumary for Power Word: Fortitute, Arcane Intellect, Mark of the Wild, Blessings of Wisdom, Salvation and Wisdom as well as soulstones.",noUI=true},
			ishere={name="Is Here",type="special",sfunc=RAB_MiniHere,sfm=3,incdead=true, incoffline=true, sort="custom",textsort="group",userange="inrange",description="Displays people currently afk, offline or out of visible/follow ranges."},
			blank={name="Blank",type="special",queryFunc=RAB_QueryBlank,description="A simple, blank bar to be used as a separator if desired."},
			onycloak={name="Onyxia Cloak",type="special",sfunc=RAB_MiniInventory,sfm=3,ext="15:15138",description="Checks that people are wearing their Onyxia Cloak."},
			info={name="List target's effects",type="special",queryFunc=RAB_QueryBuffInfo,description="Outputs buff names / textures for buffs and debuffs on your current target.",noUI=true},
			najburst={name="Survives Bubble Burst", type="special",sfunc=RAB_MiniHealthRequirement,sfm=3,ext=8500,description="Displays raid members without enough HP to survive Najentus' bubble burst."},

			priestres={name="Resurrection",type="dummy",textures={"Spell_Holy_Resurrection"},castClass="Priest"},
			paladinres={name="Redemption",type="dummy",textures={"Spell_Holy_Resurrection"},castClass="Paladin"},
			shamanres={name="Ancestral Spirit",type="dummy",textures={"Spell_Nature_Regenerate"},castClass="Shaman"},
		}, {}, {};
RAB_TextureToBuffKey = setmetatable({}, {__index = function(t, tex) 
 if (type(tex) ~= "string") then return nil; end
 tex = tex:match("([^/\\]+)$");
 for key, val in pairs(RAB_Buffs) do
  if (val.textures ~= nil) then
   for key2, val2 in pairs(val.textures) do
    if (val2 == tex) then
     t[tex], t["Interface\\Icons\\" .. tex] = key, key;
     return t[tex];
    end
   end
  end
 end
 t[tex], t["Interface\\Icons\\" .. tex] = false, false;
 return false;
end});
RAB_Buffs[select(2, UnitFactionGroup("player")) == "Horde" and "heroism" or "bloodlust"] = nil;
RAB_Buffs[select(2, UnitFactionGroup("player")) == "Horde" and "hero" or "lust"] = nil;

--Block 4: Custom query madness
function RAB_SetCustomFlag(query, flag, value)
 RAB_CBuffs[query], RAB_OBuffs[query] = RAB_CBuffs[query] or {}, RAB_OBuffs[query] or {};
 if RAB_OBuffs[query][flag] == value then
  RAB_CBuffs[query][flag], RAB_Buffs[query][flag] = nil, value;
	if not next(RAB_CBuffs[query]) then
  	RAB_OBuffs[query], RAB_CBuffs[query] = nil, nil;
	end
 else
  RAB_OBuffs[query][flag] = RAB_OBuffs[query][flag] or RAB_Buffs[query][flag];
  RAB_CBuffs[query][flag], RAB_Buffs[query][flag] = value, value;
 end
end
function RAB_RestoreQuery(query)
 if (RAB_OBuffs[query] ~= nil) then
  for key, val in pairs(RAB_OBuffs[query]) do
   RAB_Buffs[query][key] = val;
  end
  RAB_OBuffs[query], RAB_CBuffs[query] = nil, nil;
 end
end
function RAB_MergeCustomQueries()
 for k, v in pairs(RAB_CBuffs) do
  if RAB_Buffs[k] then
   for k2, v2 in pairs(v) do
    RAB_SetCustomFlag(k,k2,v2);
   end
  else
   RAB_Buffs[k] = v;
  end
 end 
 return "remove";
end
EC_Register("VARIABLES_LOADED","RAB.mergeCustom",RAB_MergeCustomQueries);

--Block 5: Managing buff expiery times
local auracache;
local function RAB_AuraEvent(event, unit)
 if not (UnitInRaid(unit) or UnitInParty(unit)) then
  return;
 end

 if not auracache then -- Following runs only ONCE
  auracache = {};
  local mc = RAB_UnitClass("player")
  for k, v in pairs(RAB_Buffs) do
   if v.castClass == mc and v.type ~= "dummy" and v.type ~= "timer" and v.type ~= "debuff" and v.type ~= "special" and type(v.textures) == "table" then
    for i, v2 in pairs(v.textures) do
     auracache["Interface\\Icons\\" .. v2] = k;
    end
   end
  end
 end

 local i, un, isnotme, name, tex, left = 1, UnitName(unit), not UnitIsUnit(unit, "player");
 while true do
  name, _, tex, _, _, left = UnitBuff(unit, i, 1);
  if not name then return; end
  tex = auracache[tex];
  if left ~= nil and tex ~= nil and type(left) == "number" and left > 1 then
   local nexp = left + GetTime();
   if isnotme and (RAB_BuffTimers[un .. "." .. tex] == nil or abs(RAB_BuffTimers[un .. "." .. tex] - nexp) > 10) then
    RAB_RecentlyChangedBuffsCastBySelf[un .. "." .. tex] = true;
   end
   RAB_BuffTimers[un .. "." .. tex] = nexp;
  end
  i = i + 1;
 end
end
EC_Register("UNIT_AURA","RAB.storeTimers", RAB_AuraEvent);