-- RABuffs_ctra.lua
--  Pluggable 3-rd party comm filter. Reads from: CT_RaidAssist, PallyPower.
-- Version 1.0.2

local RAB_CTRA_BuffID = {[1]="pwf", [2]="motw", [3]="ai", [5]="sprot", [6]="pws", [7]="ss", [8]="ds", [9]="thorns", [10]="fearward",
		  [11]="bom", [12]="bow", [13]="bok", [14]="bos", [15]="bol", [16]="bosanc", [20]="amplify", [21]="dampen"};
local RAB_CTRA_BuffsMaskPart = "RN (%d+) (%d+) (%d+)";
local RAB_CTRA_TimerMaskPart = "CD (%d+) (%d+)";

local RAB_PLPWR_BuffID = {[1]="bow",[2]="bom",[3]="bos",[4]="bol",[5]="bok",[6]="bosanc"};
local RAB_PLPWR_ClassID = "wrpdahmls";
local RAB_PLPWR_Reagents = "SYMCOUNT (%d+)";
local RAB_PLPWR_SelfResponse = "SELF ([0-9n]*)@([0-9n]*)";

function RAB_RaidMemberInfo(name)
 for i,u in RAB_GroupMembers("all") do
  if (UnitName(u) == name) then
   local rank = 0;
   if (UnitInRaid("player")) then _, rank = GetRaidRosterInfo(i); end
   if (UnitIsPartyLeader(u)) then rank = 2; end
   return true, u, rank;
  end
 end
 return false,"", -1;
end

function RAB_CTRA_AddOnEvent(event, arg1, arg2, arg3, arg4)
 if (arg1 ~= "CTRA" or arg3 ~= "RAID") then return; end
 local inGroup, unitID, lr = RAB_RaidMemberInfo(arg4);
 if (not inGroup) then return; end
 while (string.find(arg2,"#") ~= nil) do
  lr, arg2 = string.match(arg2,"(.-)#(.+)");
  RAB_CTRA_Parse(arg4, lr, unitID);
 end
 RAB_CTRA_Parse(arg4, arg2, unitID);
end
function RAB_CTRA_Parse(arg4, arg2, unitID)
 if (string.match(arg2,RAB_CTRA_BuffsMaskPart) ~= nil and RAB_IsRABEnabled(arg4) == false) then
  local dur, ctrakey, subtype;
  local nkey = GetCVar("realmName") .. "." .. arg4;
  for dur, ctrakey, subtype in string.gmatch(arg2,RAB_CTRA_BuffsMaskPart) do
   if (RAB_CTRA_BuffID[tonumber(ctrakey)] ~= nil and RAB_IsBuffUp(unitID,RAB_CTRA_BuffID[tonumber(ctrakey)])) then
    RAB_BuffTimers[arg4 .. "." .. RAB_CTRA_BuffID[tonumber(ctrakey)]] = GetTime() + tonumber(dur);
   end
  end
 end
 if (string.match(arg2,RAB_CTRA_TimerMaskPart) ~= nil and not RAB_IsRABEnabled(arg4, 0.1003)) then
  local uclass, spid, cool = RAB_UnitClass(unitID);
  for spid, cool in string.gmatch(arg2,RAB_CTRA_TimerMaskPart) do
   if (tonumber(spid) == 1 and uclass == "Druid") then
    RAB_BuffTimers[arg4 .. ".rebirth"] = GetTime()+tonumber(cool)*60;
   end
  end
 end

 if (string.match(arg2,"CANRES") ~= nil) then
  RAB_PendingRes[arg4] = {"self2-ctra", GetTime()+60};
 elseif (string.match(arg2,"RESSED") ~= nil) then
  RAB_PendingRes[arg4] = {"self-ctra", GetTime()+60};
 elseif (string.match(arg2, "NORESSED") ~= nil) then
  RAB_PendingRes[arg4] = nil;
 end
 local resee = string.match(arg2, "RES ([^#]*)");
 if (resee ~= nil) then
  RAB_PendingRes[resee] = {arg4, GetTime()+70};
 elseif (string.match(arg2, "RESNO")) then
  local key, val;
  for key, val in pairs(RAB_PendingRes) do
   if (val[1] == arg4) then
    RAB_PendingRes[key] = nil;
   end
  end
 end
end

function RAB_PLPWR_AddOnEvent(event, head, msg, channel, name)
 if (head ~= "PLPWR" or (channel ~= "RAID" and channel ~= "PARTY")) then return; end

 local sc = string.match(msg, RAB_PLPWR_Reagents);
 if sc then RAB_ItemCount[name .. ".21177"] = sc; return; end

 local talents, assigns = string.match(msg, RAB_PLPWR_SelfResponse);
 if talents and assigns then
  if not RAB_IsRABEnabled(name,1.0003) then -- Native talent broadcasts in 1.0003
   for i=1,12,2 do
    local id, talent, srank = (i+1)/2, strsub(talents,i+1,i+1), strsub(talents,i,i);
    talent, srank = talent == "n" and 0 or tonumber(talent), srank == "n" and 0 or tonumber(srank);
    RAB_Talents[name .. "." .. tostring(RAB_Buffs[RAB_PLPWR_BuffID[id]].talent)] = talent; -- Can introduce nil, but we won't read those!
   end
  end
  local assignTemp = {};
  for i=1,9 do
   local a = strsub(assigns,i,i);
   if (a ~= "n") then
    assignTemp[RAB_PLPWR_BuffID[tonumber(a)]] = (assignTemp[RAB_PLPWR_BuffID[tonumber(a)]] or "") .. strsub(RAB_PLPWR_ClassID,i,i);
   end
  end
  if RAB_AssignedBuffs[name] == nil then RAB_AssignedBuffs[name] = {}; end
  for k, v in pairs(RAB_AssignedBuffs[name]) do
   if v.assignBy == "PallyPower" then RAB_AssignedBuffs[name][k] = nil; end
  end
  for k, v in pairs(assignTemp) do
   tinsert(RAB_AssignedBuffs[name],{query=k .. " " .. v,assignBy="PallyPower"});
  end
 end
end

EC_Register("CHAT_MSG_ADDON","RAB.CT_RaidAssist.Filter", RAB_CTRA_AddOnEvent);
EC_Register("CHAT_MSG_ADDON","RAB.PallyPower.Filter", RAB_PLPWR_AddOnEvent);