-- RABuffs_core.lua
--  General AddOn code - SV, group state changes, some abstraction required by other layers.
-- Version 1.3.0
RABuffs_Version, RABuffs_DeciVersion, RABuffs_LiveVersion = "1.3.0", 1.0300, true;
local nf = NORMAL_FONT_COLOR;
local RAB_DefSettings, RABui_DefBars = {
			Layout = {}, LastUIState = {},
			firstRun = true, lastVersion=RABuffs_Version,	betanotification = false, releasenotification=true,
			newestVersion="fresh", newestVersionTitle=RABuffs_Version, newestVersionUser="",
			uilocale = "", outlocale = "",
			strictrange = false,
			colorizechat = true, hookprat=true, compactoutput = false,
			castbigbuffs = true, alwayscastbigbuffs = false, cheapbgbuffs = true, partymode = true, forcefulself=true, stoppvp = true,
			showsolo = true, showparty = true, showraid = true, showbg = true,
			lockwindow = false, enablefadingfx = true, dummymode = true,
			uibarwidth=120, uibarheight=12, uibarfontsize=10, uibarvspace=0, uiinvertbars=false, uirtlbars=false, uisplitbars=false, 
			uibartexture=false, uilabelfont=false, uinumberfont=false, uilabelcolor={nf.r, nf.g, nf.b}, uilabelextcolor={1,1,1}, uibgcolor={0.125, 0.125, 0.125, 0.7},
		 }, {
			{class="ALL",cmd="alive mlprdhswa",label="Alive",color={0.01,0.729,0.0039}},
			{class="ALL",cmd="mana pdsa",label="Healer",color={0,0.6196,0.8431}},
			{class="ALL",cmd="mana mlh",label="DPS",color={0,0.32,0.843}},
			{class="DRUID",cmd="motw",label="Mark",color={0.8,0.2,1}},
			{class="PRIEST",cmd="pwf",label="Fortitude",color={0.9,0.9,0.9}},
			{class="MAGE",cmd="ai",label="Intellect",color={0,0.6,1}}
		};

RAB_ClassShort = {Mage="m", Warlock="l", Priest="p", Rogue="r", Druid="d", Hunter="h", Shaman="s", Warrior="w", Paladin="a", Pet="e",
		  m="Mage", l="Warlock", p="Priest", r="Rogue", d="Druid", h="Hunter", s="Shaman", w="Warrior", a="Paladin", e="Pet"};

RAB_CastLog = {}; -- [name] = last cast + 15
RAB_CurrentGroupStatus = -1;
RAB_CurrentProfile = "Realm.Character";
local RAB_GroupSyncPending = false;
local RAB_CurrentOwnGroup;
local RAB_PlayerName = UnitName("player");

function RAB_Print(text, type)
 local r,g,b = 0.3, 0.5, 1;
 if (type == "fail") then r,g,b = 1, 0.2, 0; end
 if (type == "warn") then r,g,b = 1, 0.8, 0; end
 if (type == "ok") then   r,g,b = 0, 0.7, 0; end
 DEFAULT_CHAT_FRAME:AddMessage(text,r,g,b);
end
local function RAB_DoSendMessage(txt, target)
 if (target == "RAID" or target == "RAID_WARNING" or target == "GUILD" or target == "OFFICER" or target == "PARTY" or target == "SAY") then
  SendChatMessage(txt, target);
 else
  local pre, targ = string.match(target,"([A-Z]+):(%w+)");
  if pre == "CHANNEL" then
   local cid = GetChannelName(targ);
   if (cid ~= 0) then
    SendChatMessage(txt, "CHANNEL", nil, cid);
   else
    RAB_Print(sRAB_Error_NoChannel:format(targ),"warn");
   end
  else
   SendChatMessage(txt, "WHISPER",  nil, targ or target);
  end
 end
end
function RAB_SendMessage(st, target, prefix) -- Chunk up at commas.
 if (target == "CONSOLE") then
  RAB_Print(st);
 else
  local autoClearAFK = GetCVar("autoClearAFK");
  SetCVar("autoClearAFK", 0);
  if (strlen(st) < 256) then
   RAB_DoSendMessage(st, target);
  else
   local chunk1, chunk2 = strsub(st,1,250), strsub(st,251);
   local lcpos = 251 - (chunk1:reverse():find(",", 1, true) or 0);
   chunk1, chunk2 = strsub(chunk1, 1, lcpos) .. " ...", "... " .. strsub(chunk1, lcpos+1) .. chunk2;
   RAB_DoSendMessage(chunk1, target);
   RAB_SendMessage((prefix or "") .. chunk2, target);
  end
  SetCVar("autoClearAFK", autoClearAFK);
 end
end 

local RAB_ChatHooks, RAB_OldChatHandler = {}, ChatFrame_MessageEventHandler;
function RAB_RegisterChatHook(hkey, match, f)
 RAB_ChatHooks[hkey] = match and {match, f} or nil;
end
function ChatFrame_MessageEventHandler(...)
 if type(arg1) == "string" then
  for k, v in pairs(RAB_ChatHooks) do
   if arg1:match(v[1]) then
    arg1 = v[2](arg1);
		if not arg1 then return; end
    if type(Prat) == "table" and RAB_Settings.hookprat then
     if type(Prat.SplitMessage) == "table" and type(Prat.SplitMessage.MESSAGE) == "string" then
      Prat.SplitMessage.MESSAGE = v[2](Prat.SplitMessage.MESSAGE);
     end
     if type(Prat.SplitMessageOrg) == "table" and type(Prat.SplitMessageOrg.MESSAGE) == "string" then
      Prat.SplitMessageOrg.MESSAGE = v[2](Prat.SplitMessageOrg.MESSAGE);
     end
    end
   end
  end
 end
 return RAB_OldChatHandler(...);
end


local function RAB_propercase(f, s)
 return f:upper() .. s:lower();
end
local RAB_QueryEvalCache = setmetatable({}, {__index=function(t, state)
 if not state then return nil; end
 local sgl, scl, sic, ti, te, gl, cl = state:match("^%a* ?(%d*) ?(%a*) ?(.*)$");
 if sic and sic ~= "" then
  local si, se = sic:match("%+%[([^%]]*)%]"), sic:match("%-%[([^%]]*)%]");
  if si and si ~= "" then
   ti = {}; for v in si:gmatch("[^,]+") do ti[v:gsub("^(.?)(.-)$", RAB_propercase)] = true; end
  end
  if se and se ~= "" then
   te = {}; for v in se:gmatch("[^,]+") do te[v:gsub("^(.?)(.-)$", RAB_propercase)] = true; end
  end
 end
 if sgl ~= "" then
  gl = {}; for v in sgl:gmatch("%d") do gl[tonumber(v)] = true; end
 end
 if scl ~= "" then
  cl = {}; for v in scl:gmatch("%a") do cl[v] = true; end
 end
 if gl and gl[9] then
	for k, v in pairs(gl) do gl[k] = nil; end gl[9] = true;
	ti = ti or {};
	ti[UnitName("player")] = true;
 end

 t[state] = {g=gl, c=cl, i=ti, e=te};
 return t[state];
end});
local function RAB_GroupIterator(query, i)
 local pp, pm, c, u, un, se, g = "raid", 40, RAB_QueryEvalCache[query];
 if c == nil then return; end
 if not UnitInRaid("player") then pp, pm = "party", 5; end
 local mg = c.g and c.g[0] and RAB_CurrentOwnGroup or nil;
 while i < pm do
  u, i = pp .. (i+1), i+1;
  u = u == "party5" and "player" or u;
  if UnitExists(u) then
   un, g = UnitName(u), select(3,GetRaidRosterInfo(i)) or 1;
   if un == RAB_PlayerName then
    RAB_CurrentOwnGroup, mg = g, g;
   end
   if not (c.e and c.e[un]) and 
      ( 
       (c.i and c.i[un]) or
       (((g == mg and c.g and c.g[0]) or not c.g or c.g[g]) and (not c.c or c.c[RAB_ClassShort[RAB_UnitClass(u)]]))
      ) then
    return i, u, g;
   end
  end
 end
 if c.c and not c.c.e then return; end
 local j = i - pm;
 while j < pm do
  u, j, i = pp .. "pet" .. (j+1), j+1, i+1;
  u = u == "partypet5" and "pet" or u;
  if UnitExists(u) then
   un, g = UnitName(u), select(3,GetRaidRosterInfo(j)) or 1;
   if not (c.e and c.e[un]) and 
      ( 
       (c.i and c.i[un]) or
       (g == mg or not c.g or c.g[g])
      ) then
    return i, u, g;
   end
  end
 end
end
function RAB_GroupMembers(init) return RAB_GroupIterator, init, 0; end  

-- GENERAL BUFF-QUERY CODELINE.
function RAB_BuffCheckOutput(msg,outputTo,invert) -- Check query, output results (Called by the /rq and bar clicks).
 local q = RAB_GetQueryResult(msg, 1, invert);
 if q then
  local cmd, grouplimit, classlimit = string.match(msg,"(%a+) ?(%d*) ?(%a*)");
  out = ((grouplimit ~= "" and #grouplimit < 9 and UnitInRaid("player")) and ("[G" .. grouplimit .. "] ") or "") .. (classlimit ~= "" and #classlimit < 8 and "[" .. classlimit .. "] " or "") .. q;
  if grouplimit:match("9") then out = sRAB_BuffOutput_LimitFragment_LimitToSelf .. " " .. q; end
  if not RAB_Buffs[cmd] then
   outputTo = "CONSOLE";
  elseif outputTo == "RAID" and not UnitInRaid("player") then
   outputTo = "PARTY";
  end
  RAB_SendMessage(sRAB_BuffOutputPrefix .. out, outputTo, sRAB_BuffOutputPrefix);
 end
end
function RAB_GetQueryResult(query, qtype, qinvert)
 local cmd = string.match(query,"^(%a+)");
 if not (RAB_Buffs and RAB_Buffs[cmd]) then
  if qtype == 1 then
   return sRAB_Error_NoBuffData;
  else
   return 0,0,0;
  end
 elseif RAB_Buffs[cmd].queryFunc then
  return RAB_Buffs[cmd].queryFunc(query, cmd, (qtype and qtype or 0), qinvert);
 else
  return RAB_DefaultQueryHandler(query, cmd, (qtype and qtype or 0), qinvert);
 end
end

function RAB_IsSanePvP(target)
 return (not UnitIsPVP(target)) or (UnitIsPVP("player") or not RAB_Settings.stoppvp);
end
function RAB_UnitClass(unit) -- Localization/nil workaround.
 local ec, ip = select(2, UnitClass(unit)), not UnitIsPlayer(unit);
 ec = ip and "Pet" or ec or "Mage";
 return ec:sub(1,1) .. ec:sub(2):lower();
end

function RAB_CastSpell_IsSpellCastable(spell, mute)
 if UnitIsDeadOrGhost("player") then
  if not mute then UIErrorsFrame:AddMessage(sRAB_CastingLayer_Dead:format(spell), 1, 0, 0, 1, 1.5); end
  return false, "Dead";
 elseif UnitOnTaxi("player") or not ((IsFlying() and GetCVar("autoDismountFlying") == "1") or (not IsFlying() and IsMounted() and GetCVar("autoDismount") == "1") or not IsMounted()) then
  if not mute then UIErrorsFrame:AddMessage(sRAB_CastingLayer_Mounted:format(spell), 1, 0, 0, 1, 1.5); end
  return false, "Taxi";
 end
 local ic, mana = IsUsableSpell(spell);
 if mana then
  if not mute then UIErrorsFrame:AddMessage(sRAB_CastingLayer_NoMana:format(spell), 1, 0, 0, 1, 1.5) end
  return false, "Mana";
 elseif not ic then
  if RAB_UnitClass("player") == "Druid" and RAB_IsBuffUp("player","druidshift") then
   return false, "Shapeshift";
  else
   return false, "Reagent";
  end
 end
 local ok, start, duration = pcall(GetSpellCooldown, spell);
 if (ok and start ~= 0 and start ~= nil) then
  local tl = start+duration-GetTime();
  if not mute then UIErrorsFrame:AddMessage(sRAB_CastingLayer_Cooldown:format(spell, tl), 1, 0, 0, 1, 1.5); end
  return false, "Cooldown", tl;
 end
 return true;
end

local function RAB_GroupStatusChange(event, arg1)
 local ns, status = 0;
 if event == "CHAT_MSG_SYSTEM" and arg1 == ERR_RAID_YOU_LEFT then
  ns = 0;
 elseif (event == "CHAT_MSG_SYSTEM" and arg1 == ERR_RAID_YOU_JOINED) or GetNumRaidMembers() > 0 then
  ns = 2;
 elseif GetNumPartyMembers() > 0 then
  ns = 1;
 end

 for i=1, MAX_BATTLEFIELD_QUEUES do
  if GetBattlefieldStatus(i) == "active" then
   ns = 3;
   break;
  end
 end

 if ns ~= RAB_CurrentGroupStatus then
  EC_Raise("RAB_GROUPSTATUS", ns, RAB_CurrentGroupStatus);
  RAB_CurrentGroupStatus = ns;
 end
 if not RAB_GroupSyncPending then
  EC_Timer("RAB.groupStatusSync", function() RAB_GroupStatusChange("timer"); RAB_GroupSyncPending = false; return "remove"; end, 3);
  RAB_GroupSyncPending = true;
 end
end
local function RAB_Exit()
 EC_Raise("RAB_LOGOUT");
 RAB_Settings.Layout[RAB_CurrentProfile] = RABui_Bars;
end
local function RAB_Init()
 RAB_Settings = RAB_Settings or {};
 for key, val in pairs(RAB_Settings) do
  if RAB_DefSettings[key] == nil then
   RAB_Settings[key] = nil;
  end
 end
 for key, val in pairs(RAB_DefSettings) do
  if (RAB_Settings[key] == nil) then
   RAB_Settings[key] = RAB_DefSettings[key];
  end
 end

 RAB_CurrentProfile = GetCVar("realmName") .. "." .. UnitName("player");
 if (RAB_Settings.Layout[RAB_CurrentProfile] == nil) then
  local _, uc = UnitClass("player");
  RAB_Settings.Layout[RAB_CurrentProfile] = {};
  for key, val in pairs(RABui_DefBars) do
   if (val.class == uc or val.class == "ALL") then
    val.out, val.vstates, val.class = "RAID", "012", nil;
    tinsert(RAB_Settings.Layout[RAB_CurrentProfile], val);
   end
  end
 end
 RABui_Bars = RAB_Settings.Layout[RAB_CurrentProfile];
 RABui_DefBars, RAB_DefSettings = nil, nil;

 if (RAB_Settings.newestVersion == "fresh" or RAB_Settings.newestVersion < RABuffs_DeciVersion) then
  RAB_Settings.newestVersion = RABuffs_DeciVersion;
  RAB_Settings.newestVersionTitle = RABuffs_Version;
  RAB_Settings.newestVersionUser = GetRealmName() .. "." .. UnitName("player");
 end

 EC_Raise("RAB_LOAD_SVREADY");
 EC_Register("PLAYER_LOGOUT", "RAB.logout", RAB_Exit);
 EC_Register("PLAYER_ENTERING_WORLD", "RAB.group", RAB_GroupStatusChange);
 EC_Register("CHAT_MSG_SYSTEM", "RAB.group", RAB_GroupStatusChange);
 EC_Register("RAB_INTERNAL_SYNCGROUPSTATE", "RAB.group", RAB_GroupStatusChange);

 return "remove";
end
EC_Register("VARIABLES_LOADED", "RAB_load", RAB_Init);