-- RABuffs_controls.lua
--  Creates and manages custom controls used by RABuffs.
-- Version 1.2.0

function RABui_BoolShow(obj, bool)
 if bool then obj:Show(); else obj:Hide(); end
end
function RABui_BoolEnable(obj, bool)
 if bool then obj:Enable(); else obj:Disable(); end
end

--[[ UIIExcludeControl -- custom add/remove people ]]--
local function RAB_IExcludeControl_Loc(obj)
 obj.inbut.toolHeader, obj.exbut.toolHeader, obj.inbut.toolText2, obj.exbut.toolText2 = sRAB_IEC_IncludeHeader, sRAB_IEC_ExcludeHeader, sRAB_IEC_TargetPlease, sRAB_IEC_TargetPlease;
 if UnitExists("target") and (UnitIsUnit("target", "player") or (UnitIsPlayer("target") and (UnitInRaid("target") or UnitInParty("target")))) then
  local un, uc = UnitName("target"), select(2,UnitClass("target"));
	obj.inbut.toolText2 = obj.inc[un] and sRAB_IEC_ClickToRemove:format(un) or sRAB_IEC_ClickToAdd:format(un);
	obj.exbut.toolText2 = obj.exc[un] and sRAB_IEC_ClickToRemove:format(un) or sRAB_IEC_ClickToAdd:format(un);
 end
 local s = "";
 for k in pairs(obj.inc) do s = s .. (s ~= "" and "\n" or "") .. k; end
 obj.inbut.toolText, obj.inbut.toolText2, s = (s == "" and sRAB_IEC_Blank or s), obj.inbut.toolText2 .. (s ~= "" and sRAB_IEC_ClickToClear or ""), "";
 for k in pairs(obj.exc) do s = s .. (s ~= "" and "\n" or "") .. k; end
 obj.exbut.toolText, obj.exbut.toolText2, s = (s == "" and sRAB_IEC_Blank or s), obj.exbut.toolText2 .. (s ~= "" and sRAB_IEC_ClickToClear or ""), "";
end
local function RAB_IExcludeControl_Click(obj, btn)
 if UnitExists("target") and (UnitInRaid("target") or UnitInParty("target") or UnitIsUnit("player", "target")) and btn == "LeftButton" then
  local un = UnitName("target");
  if obj.li[un] then
   obj.li[un] = nil;
  else
   obj.li[un] = true;
  end
 elseif btn == "RightButton" then
  for k in pairs(obj.li) do obj.li[k] = nil; end
 end
 obj:GetParent():Hide(); obj:GetParent():Show(); -- Force updates
end
local function RAB_IExcludeControl_GetValue(obj)
 local e, i, r = "", "", "";
 for k in pairs(obj.exc) do e = e .. (e ~= "" and "," or "") .. k; end
 for k in pairs(obj.inc) do i = i .. (i ~= "" and "," or "") .. k; end
 if i ~= "" then r = " +[" .. i .. "]"; end
 if e ~= "" then r = r .. " -[" .. e .. "]"; end
 return r;
end
local function RAB_IExcludeControl_SetValue(obj, val)
 for k in pairs(obj.exc) do obj.exc[k] = nil; end
 for k in pairs(obj.inc) do obj.inc[k] = nil; end

 local si, se = string.match(val, "%+%[([^%]]*)%]"), string.match(val, "%-%[([^%]]*)%]");
 if si and si ~= "" then
  for v in string.gmatch(si, "[^,]+") do obj.inc[v] = true; end
 end
 if se and se ~= "" then
  for v in string.gmatch(se, "[^,]+") do obj.exc[v] = true; end
 end
 RAB_IExcludeControl_Loc(obj);
end
local function RAB_IExcludeControl_Disable(obj)
 obj.inbut:Disable(); obj.exbut:Disable();
 SetDesaturation(obj.itex, 1);  SetDesaturation(obj.etex, 1);
end
local function RAB_IExcludeControl_Enable(obj)
 obj.inbut:Enable(); obj.exbut:Enable();
 SetDesaturation(obj.itex, nil);  SetDesaturation(obj.etex, nil);
end
local function RAB_IExcludeControl_OnEnter(obj)
  RAB_IExcludeControl_Loc(obj:GetParent());
	obj:RegisterEvent("PLAYER_TARGET_CHANGED");
end
local function RAB_IExcludeControl_OnLeave(obj)
	obj:UnregisterEvent("PLAYER_TARGET_CHANGED");
end
function RABui_IExcludeControl_Init(obj)
 obj.itex, obj.etex = _G[obj:GetName() .. "IncludeTex"], _G[obj:GetName() .. "ExcludeTex"]
 obj.itex:SetTexture("Interface\\Icons\\Spell_ChargePositive");
 obj.etex:SetTexture("Interface\\Icons\\Spell_ChargeNegative");
 obj:SetScript("OnShow", RAB_IExcludeControl_Loc);
 obj.inbut, obj.exbut = _G[obj:GetName() .. "Include"], _G[obj:GetName() .. "Exclude"];
 obj.inc, obj.exc, obj.Enable, obj.Disable = {}, {}, RAB_IExcludeControl_Enable, RAB_IExcludeControl_Disable
 obj.inbut.li, obj.exbut.li = obj.inc, obj.exc;
 for k, button in pairs({obj.inbut, obj.exbut}) do
  button:RegisterForClicks("RightButtonUp", "LeftButtonUp");
  button:SetScript("OnClick", RAB_IExcludeControl_Click);
  button:HookScript("OnEnter", RAB_IExcludeControl_OnEnter);
  button:HookScript("OnLeave", RAB_IExcludeControl_OnLeave);
  button:SetScript("OnEvent", function(self) RAB_IExcludeControl_Loc(self:GetParent()); end);
 end
 obj.SetValue, obj.GetValue, obj.Enable, obj.Disable = RAB_IExcludeControl_SetValue, RAB_IExcludeControl_GetValue, RAB_IExcludeControl_Enable, RAB_IExcludeControl_Disable;
end

--[[ UISelectionControl -- mask-based group/class selection ]]--
local function RAB_SelectionControl_OnClick(self)
 local parent = self:GetParent();
 if parent and parent.Changed then
  parent:Changed();
 end
end
local function RAB_SelectionControl_GetValue(obj)
 local b = "";
 if not obj.type then
  return nil;
 elseif obj.type == "class" then
  for k, v in pairs(obj.btn) do
   b = b .. (v:GetChecked() == 1 and string.sub("wmrdhsplae",k+1,k+1) or "");
  end
 elseif obj.type == "group" then
  for i=0,8 do
   b = b .. (obj.btn[i]:GetChecked() == 1 and ((i + 1) % 9) or "");
  end
 end
 return b;
end
local function RAB_SelectionControl_SetValue(obj, value)
 if obj.type == "class" then
  for i=0,9 do
   local b = obj.btn[i];
   if b then b:SetChecked(value:match(string.sub("wmrdhsplae",i+1,i+1)) and 1 or 0); end
  end
 elseif obj.type == "group" then
  for i=0,8 do
   local b = obj.btn[i];
   if b then b:SetChecked(value:match((i + 1) % 9) and 1 or 0); end
  end
 end
end
local function RAB_SelectionControl_SetMask(obj, mask)
 if obj.type ~= "class" then return; end
 for i=0,9 do
  local b, m = obj.btn[i], string.match(mask, string.sub("wmrdhsplae",i+1,i+1)) ~= nil;
  if (b and m) then 
   b:Enable();
  elseif (b and not m) then
   b:Disable();
   b:SetChecked(0);
  end
 end
 obj.mask = mask;
end
local function RAB_SelectionControl_GetMask(obj)
 return obj.mask;
end
local function RAB_SelectionControl_Disable(obj)
 for k, v in pairs(obj.btn) do v:Disable(); end
end
local function RAB_SelectionControl_Enable(obj)
 for k, v in pairs(obj.btn) do v:Enable(); end
end
function RABui_SelectionControl_Init(obj, ctlType)
 obj:SetWidth((ctlType == "class" and 10 or 9)*26);
 obj:SetHeight(24);
 obj.type, obj.btn = ctlType, obj.btn or {};
 local f = function() if (this:GetParent().Changed) then this:GetParent().Changed(); end end;
 for i=0,(ctlType == "class" and 9 or 8) do
  local btn = obj.btn[i];
  if not btn then
   btn = CreateFrame("CHECKBUTTON", obj:GetName() .. "Btn" .. i, obj, "RAB_ToggleTemplate");
   btn:SetID(i+1);
   btn:SetChecked(1);
   btn:SetScript("OnClick", RAB_SelectionControl_OnClick);
   btn:Show();
   btn:SetPoint("TOPLEFT", i*26,0);
   obj.btn[i], btn.txt = btn, _G[btn:GetName() .. "Text"];
  end
  if ctlType == "class" then
   if i == 9 then
    btn:GetNormalTexture():SetTexture("Interface\\Icons\\INV_Jewelcrafting_BlackPearlPanther");
    btn:GetDisabledTexture():SetTexture("Interface\\Icons\\INV_Jewelcrafting_BlackPearlPanther");
   else
    btn:GetNormalTexture():SetTexture("Interface\\Glues\\CharacterCreate\\UI-CharacterCreate-Classes");
    btn:GetNormalTexture():SetTexCoord(0.25 * (i % 4), 0.25 * (i % 4) + 0.25, floor(i/4)/4, floor(i/4)/4 + 0.25);
    btn:GetDisabledTexture():SetTexture("Interface\\Glues\\CharacterCreate\\UI-CharacterCreate-Classes");
    btn:GetDisabledTexture():SetTexCoord(0.25 * (i % 4), 0.25 * (i % 4) + 0.25, floor(i/4)/4, floor(i/4)/4 + 0.25);
   end
   SetDesaturation(btn:GetDisabledTexture(), 1);
  else
   btn:GetNormalTexture():SetTexture("Interface\\Buttons\\CheckButtonGlow");
   btn:GetNormalTexture():SetTexCoord(0.20,0.80,0.20,0.80);
   btn:GetNormalTexture():SetVertexColor(0.4,0.4,0.4);
   btn:GetDisabledTexture():SetTexture("Interface\\Buttons\\CheckButtonGlow");
   btn:GetDisabledTexture():SetTexCoord(0.20,0.80,0.20,0.80);
   btn:GetDisabledTexture():SetVertexColor(0.05,0.05,0.05, 0.5);
   SetDesaturation(btn:GetDisabledTexture(), 1);
   btn.txt:SetText(i == 8 and "O" or (i+1));
  end
  btn:SetDisabledCheckedTexture("Interface\\Buttons\\CheckButtonGlow");
	btn:SetCheckedTexture("Interface\\Buttons\\CheckButtonHilight");
	btn:GetCheckedTexture():SetBlendMode("ADD");
  btn:GetDisabledCheckedTexture():SetTexCoord(0.20,0.80,0.20,0.80);
  btn:GetDisabledCheckedTexture():SetVertexColor(0.2,0.2,0.2);
	SetDesaturation(btn:GetDisabledCheckedTexture(), 1);
 end
 obj.SetValue, obj.GetValue, obj.SetMask, obj.GetMask, obj.Disable, obj.Enable = RAB_SelectionControl_SetValue, RAB_SelectionControl_GetValue, RAB_SelectionControl_SetMask, RAB_SelectionControl_GetMask, RAB_SelectionControl_Disable, RAB_SelectionControl_Enable;
end