-- RABuffs.vui.lua
--  Handles the visual user interface (bar collection).
-- Version 1.2.0

local RAB_layout_BarTextureDefault, RAB_layout_BarTexture = "Interface\\AddOns\\RABuffs\\bar.tga";
local RAB_UIState_Header, RAB_UIState_PreCombat;
local RAB_UIState_CloseButton = RAB_UIState_CloseButton;
local RAB_UIState_MinButton = RAB_UIState_MinButton;

local RAB_UIBarCollection, RAB_PendingLayoutSync = {}, true;
local RAB_UIBarHovering, RAB_UIShiftKeyState;
local RAB_UIState_ShowFlags = {[0] = "solo", [1]="party", [2]="raid", [3]="bg"};

local RAB_NextUpdateMod, RAB_NextUpdateTime = 0, 0;

local RAB_layout_UpdateBarTooltip; -- we cheat by declaring the upvalue here. It's a func
local RAB_lsc_invert, RAB_lsc_split = false, true; -- Cache uiinvertbars ands uisplitbars settings

local RAB_layout_FormatConverter = {["#b"]="%1$d", ["#f"]="%2$d", ["#t"]="%3$d"};
local RAB_layout_ChromeAlpha = {0.4, 0.2, 0.8};
local log10 = math.log10;

local function RAB_layout_BarUpdateGx(self)
 local buffed, fading, total, full, part, w = self.buffed or 0, self.fading or 0, self.total or 0, 0, 0, self:GetWidth();
 if RAB_lsc_invert ~= self.invert then
  full, part = total-buffed, total-buffed+fading;
 else
  full, part = buffed-fading, buffed;
 end
 if full > 0 then self.tex:SetWidth(w*full/total); end
 if part > 0 then self.tex2:SetWidth(w*buffed/total); end
 if RAB_lsc_split then
	local len = log10(buffed);
	if len < 3 then
		self.ext:SetText(buffed);
	elseif len < 6 then
		self.ext:SetFormattedText("%.1fk", buffed*0.001);
	elseif len < 9 then
		self.ext:SetFormattedText("%.1fm", buffed*0.000001);
	else
		self.ext:SetFormattedText("%.1fb", buffed*0.000000001);
	end
 end
 RABui_BoolShow(self.tex, full > 0);
 RABui_BoolShow(self.tex2, part > full and part > 0);
end
local function RAB_layout_BarSetValue(self, buffed, fading, total, text)
 total = math.max(0, buffed, total);

 local nchange, tchange = self.buffed ~= buffed or self.fading ~= fading or self.total ~= total, self.text ~= text or self.focus ~= self.ofocus;

 if nchange then
  self.buffed, self.fading, self.total = buffed, fading, total;
  RAB_layout_BarUpdateGx(self);
 end
 if self.text ~= text then
  self.text, self.etext = text, text:gsub("#[bft]", RAB_layout_FormatConverter);
 end

 if self.focus and (nchange or not self.ofocus) and not RAB_lsc_split then
  self:SetText(buffed .. " / " .. total .. (total > 0 and " (" .. floor(buffed*100/total) .. "%)" or ""));
 elseif tchange or (self.etext ~= self.text and nchange) then
  if self.etext then
   self:SetFormattedText(self.etext, buffed, fading, total);
  else
   self:SetText(self.text);
  end
 end
 self.ofocus = self.focus;
end
local function RAB_layout_BarGetValue(self)
 return self.buffed, self.fading, self.total, self.text;
end
local function RAB_layout_BarEnter(self)
 self.focus, RAB_UIBarHovering = true, self:GetID();
 RAB_layout_UpdateBarTooltip(RAB_UIBarHovering);
end
local function RAB_layout_BarExit(self)
 self.focus, RAB_UIBarHovering = false, nil;
 RAB_Tooltip:Hide();
 RAB_layout_BarSetValue(self, RAB_layout_BarGetValue(self));
end
local function RAB_layout_SetBarSpell(bar, target, spell, altspell)
 bar:SetAttribute("*type1", "spell");
 bar:SetAttribute("*spell1", spell);
 bar:SetAttribute("alt-spell1", altspell or spell);
 bar:SetAttribute("ctrl-spell1",ATTRIBUTE_NOOP);
 bar:SetAttribute("unit", target or "none");
end
local function RAB_layout_SetDefaultSpell(bar, cmd)
 if (RAB_Buffs[cmd] and RAB_Buffs[cmd].type ~= "dummy" and RAB_Buffs[cmd].type ~= "timer") then
  if (RAB_Settings.alwayscastbigbuffs and (RAB_CurrentGroupStatus ~= 3 or not RAB_Settings.cheapbgbuffs) and RAB_Buffs[cmd].bigcast ~= nil and sRAB_SpellNames[RAB_Buffs[cmd].bigcast] ~= nil) then
   RAB_layout_SetBarSpell(bar, "none", sRAB_SpellNames[RAB_Buffs[cmd].bigcast], sRAB_SpellNames[cmd]);
  else
   RAB_layout_SetBarSpell(bar, "none", sRAB_SpellNames[cmd], RAB_Buffs[cmd].bigcast and sRAB_SpellNames[RAB_Buffs[cmd].bigcast] or sRAB_SpellNames[cmd]);
  end
 end
end
local function RAB_layout_BarClick(self, button)
 local barInfo = RABui_Bars[self:GetID()];
 local cmd = barInfo.cmd:match("^(%a+)");

 if button == "LeftButton" and IsControlKeyDown() then
  RAB_BuffCheckOutput(barInfo.cmd, barInfo.out or "RAID", IsShiftKeyDown());
 elseif button == "LeftButton" and RAB_Buffs[cmd] and not InCombatLockdown() then
  local spell, target = RAB_GetCastTarget("cast", barInfo.cmd);
  if spell then
   RAB_layout_SetBarSpell(self, target, spell);
   if RAB_CastLog and target and target ~= "player" then
    RAB_CastLog[UnitName(target)] = time()+10;
   end
   RAB_CastNotifyIcon:SetTexture(GetSpellTexture(spell));
   RAB_CastNotifyTarget:SetText(RAB_Chat_Color(RAB_UnitClass(target or "player"), UnitName(target or "player")));
   RAB_CastNotify:Show();
  else
   RAB_layout_SetBarSpell(self);
  end
 end
end
local function RAB_layout_BarPostClick(self)
 RAB_layout_SetDefaultSpell(self, RABui_Bars[self:GetID()].cmd:match("^(%a+)"));
end
local function RAB_layout_BarRedraw(self)
 self.tex2:SetAlpha(cos(GetTime()*180)*0.2+0.5);
end
local function RAB_layout_SpawnBar(t, id)
 local ptr = CreateFrame("Button","RAB_Bar" .. id, RABFrame, "RAB_BarTemplate");
 ptr:SetID(id);
 ptr:SetText("x"); ptr:GetFontString():SetPoint("LEFT",4,1); ptr:GetFontString():SetPoint("RIGHT",-4,1);
 ptr:SetNormalFontObject(RAB_BarLabelFont);
 ptr.SetValue, ptr.GetValue, ptr.tex, ptr.tex2, ptr.ext = RAB_layout_BarSetValue, RAB_layout_BarGetValue, _G["RAB_Bar" .. id .. "Tex"], _G["RAB_Bar" .. id .. "Tex2"], _G["RAB_Bar" .. id .. "Ext"];
 ptr.tex2:SetAlpha(0.5);
 if RAB_Settings.enablefadingfx then
  ptr:SetScript("OnUpdate", RAB_layout_BarRedraw);
 end
 ptr:SetScript("OnEnter", RAB_layout_BarEnter);
 ptr:SetScript("OnLeave", RAB_layout_BarExit);
 ptr:SetScript("PreClick", RAB_layout_BarClick);
 ptr:SetScript("PostClick", RAB_layout_BarPostClick);
 RAB_UIState_Header:SetFrameRef("newchild", ptr);

 RAB_UIBarCollection[id] = ptr;
 return RAB_UIBarCollection[id];
end

local function RAB_layout_FormatTooltipNick(name, c, u, append, q)
 local nick = "";
 if not RAB_QueryInRange(q, u) then nick = "|cffaaaaaa" .. name .. "|r";
 elseif not RAB_IsSanePvP(u) then nick = "|cff00ff33" .. name .. "|r";
 else nick = RAB_Chat_Color(c, name);
 end
 return nick .. (append ~= nil and RAB_Chat_Color(c, append) or "");
end
RAB_layout_UpdateBarTooltip = function(id)
 local bcmd = RABui_Bars[id].cmd:match("^(%a+)");

 if not (bcmd and bcmd ~= "break" and RAB_Buffs[bcmd]) then return; end
 local buffed, fading, total, raw, rawsort, rawgroup, header = RAB_GetQueryResult(RABui_Bars[id].cmd, 2, IsShiftKeyDown());
 RAB_UIBarCollection[id]:SetValue(buffed, fading, total, RABui_Bars[id].label);
 RAB_UIBarHovering = id;

 local floatLeft = (RABFrame:GetCenter() / UIParent:GetWidth()) > 0.5;
 RAB_Tooltip:SetOwner(RABFrame, "ANCHOR_NONE");
 RAB_Tooltip:SetPoint(floatLeft and "RIGHT" or "LEFT", RAB_UIBarCollection[id], floatLeft and "LEFT" or "RIGHT", floatLeft and -4 or 4, 0);



 if header and header ~= "" then
  RAB_Tooltip:AddLine(header);
 end
 if type(raw) == "table" then -- This block does something; nobody is quite sure what.
  local og,cg, pline,linepeoplecount, index, info, l, line = 0,"","",0;
  rawgroup = rawgroup and rawgroup or sRAB_Core_GroupFormat;
  l = 0;
  for i=1,#raw do
   if (raw[i] ~= nil and raw[i].class ~= nil) then
    line = raw[i]; l = l +1;
    line.append = line.append ~= nil and line.append or "";
    cg = string.format(rawgroup, tostring(line[rawsort]));
    linepeoplecount = linepeoplecount + 1;
    if ((og ~= cg or rawgroup == false or rawgroup == nil) and og ~= 0 or linepeoplecount > 5) then
     RAB_Tooltip:AddDoubleLine(pline, og);
     pline = "";
     linepeoplecount = 1;
    end
    og = cg;
    pline = pline .. (pline == "" and "" or ", ") .. RAB_layout_FormatTooltipNick(line.name, line.class, line.unit, line.append, bcmd) .. (line.fade ~= nil and " (" .. RAB_TimeFormatOffset(line.fade) .. ")" or "");
   end
  end
  if (og ~= 0) then
   RAB_Tooltip:AddDoubleLine(pline, og);	
  end
  if (l == 0) then
   RAB_Tooltip:AddLine(sRAB_Tooltip_NoOne);
  end
 end

 if (RAB_Settings.dummymode) then 
  local help, outTarget,n = sRAB_Tooltip_ShiftToInvert, "";
  if (RABui_Bars[id].out == "RAID" and UnitInRaid("player")) then outTarget = strlower(CHAT_MSG_RAID);
  elseif ((RABui_Bars[id].out == "RAID" or RABui_Bars[id].out == "PARTY" or RABui_Bars[id].out == nil) and GetNumPartyMembers() > 0) then outTarget = strlower(CHAT_MSG_PARTY);
  elseif (RABui_Bars[id].out == "OFFICER") then outTarget = sRAB_Settings_BarDetail_Output_Officer;
  elseif (string.match(tostring(RABui_Bars[id].out),"^CHANNEL:") ~= nil) then n = string.match(RABui_Bars[id].out,"^CHANNEL:(.+)"); outTarget = n;
  elseif (string.match(tostring(RABui_Bars[id].out),"^WHISPER:") ~= nil) then n = string.match(RABui_Bars[id].out,"^WHISPER:(.+)"); outTarget = n .. sRAB_Settings_BarDetail_Output_WhisperSuffix;
  end
  if outTarget ~= "" then help = sRAB_Tooltip_ClickToOutput:format(outTarget) .. " " .. help end
  RAB_Tooltip:AddLine(help);
 end

 if ((RAB_Buffs[bcmd].castClass == RAB_UnitClass("player") and sRAB_SpellNames[bcmd] ~= nil) or RAB_Buffs[bcmd].buffFunc ~= nil) then
  local tip = RAB_UIBarCollection[id]:GetAttribute(IsAltKeyDown() and "alt-spell1" or "*spell1");
  if (InCombatLockdown() and tip ~= nil) then
   local canbuff, reason, howmuch = RAB_CastSpell_IsSpellCastable(tip,true);
   if (not canbuff) then
    if (reason == "Cooldown") then
     tip = string.format(_G["sRAB_Tooltip_CastFail_" .. reason],floor(howmuch*10)/10);
    else
     tip = _G["sRAB_Tooltip_CastFail_" .. reason];
    end
   elseif (tip ~= nil and RAB_Buffs[bcmd].type == "self") then
    tip = string.format(RAB_IsBuffUp("player",bcmd) and sRAB_Tooltip_ClickToRecastNeutral or sRAB_Tooltip_ClickToCastNeutral, tip);
   else
    tip = string.format(sRAB_Tooltip_ClickToCastLockdown, tip);
   end
  elseif (not InCombatLockdown()) then
   tip = RAB_GetCastTarget("tip", RABui_Bars[id].cmd);
  end
  if (type(tip) == "string" and tip ~= "") then RAB_Tooltip:AddLine(tip); end
 end

 RAB_Tooltip:Show();
end
local function RAB_layout_UpdateBar(id)
 if RAB_UIBarHovering == id then
  return RAB_layout_UpdateBarTooltip(id);
 end
 local buffed, fading, total = RAB_GetQueryResult(RABui_Bars[id].cmd, 0);
 RAB_UIBarCollection[id]:SetValue(buffed, fading, total, RABui_Bars[id].label);
end
local function RAB_layout_UpdateAll()
 for i=1,#RABui_Bars do
  RAB_layout_UpdateBar(i);
 end
end
local function RAB_layout_UpdateSched()
 local nshift = (IsShiftKeyDown() and 1 or 0) + (IsAltKeyDown() and 2 or 0) + (IsControlKeyDown() and 4 or 0);

 if RAB_UIBarHovering and nshift ~= RAB_UIShiftKeyState then
  RAB_UIShiftKeyState = nshift, RAB_layout_UpdateBarTooltip(RAB_UIBarHovering);
 end
 if RAB_NextUpdateTime > GetTime() then return; end

 RAB_NextUpdateMod, RAB_NextUpdateTime = RAB_NextUpdateMod % 3 + 1, GetTime() + 0.2;
 for i=RAB_NextUpdateMod, #RABui_Bars, 3 do
  if RAB_UIBarCollection[i] and RAB_UIBarCollection[i]:IsShown() or i == RAB_UIBarHovering then
   RAB_layout_UpdateBar(i);
  end
 end
end

local function RAB_layout_GxPhysSync()
 local splitDisplay = RAB_Settings.uisplitbars;
 local attachBarsTo = RAB_Settings.uirtlbars and "RIGHT" or "LEFT";

 RAB_BarLabelFont:SetJustifyH(splitDisplay and attachBarsTo or "CENTER");
 RAB_BarLabelExtFont:SetJustifyH(RAB_Settings.uirtlbars and "LEFT" or "RIGHT")

 RAB_layout_BarTexture = RAB_Settings.uibartexture or RAB_layout_BarTextureDefault;
 if RAB_UIBarCollection and RAB_UIBarCollection[1] then
  RAB_UIBarCollection[1].tex:SetTexture(RAB_layout_BarTexture);
  local rt = RAB_UIBarCollection[1].tex:GetTexture();
  RAB_layout_BarTexture = rt or RAB_layout_BarTextureDefault;
 end

 for k, b in pairs(RAB_UIBarCollection) do
  b.tex:ClearAllPoints(); b.tex:SetPoint(attachBarsTo); b.tex:SetTexture(RAB_layout_BarTexture);
  b.tex2:ClearAllPoints(); b.tex2:SetPoint(attachBarsTo); b.tex2:SetTexture(RAB_layout_BarTexture);
  RABui_BoolShow(b.ext, splitDisplay);
  RAB_layout_BarUpdateGx(b);
 end
end
local function RAB_layout_PhysSync()
 RAB_PendingLayoutPhysSync = not not InCombatLockdown();
 if not RAB_PendingLayoutPhysSync then
  for i=1, #RABui_Bars do
   local bar = RAB_UIBarCollection[i];
   bar:SetWidth(RAB_Settings.uibarwidth);
   bar:SetHeight(RAB_Settings.uibarheight);
  end
  RABFrame:SetWidth(RAB_Settings.uibarwidth+6);
 end
 RABFrameTitle:ClearAllPoints();
 RABFrameTitle:SetPoint("TOP", math.max(0.3*(110-RAB_Settings.uibarwidth), 0), -4);
 RAB_layout_GxPhysSync();
end
local function RAB_layout_SyncColors(e, id)
 if RAB_PendingLayoutSync then return; end -- Do not sync if layout is dirty.
 if not id and e then id = e; end
 for i=(id or 1), (id or #RABui_Bars) do
  local bar, ui = RAB_UIBarCollection[i], RABui_Bars[i];
  bar.tex:SetVertexColor(ui.color[1],ui.color[2],ui.color[3]);
  bar.tex2:SetVertexColor(ui.color[1],ui.color[2],ui.color[3]);
 end
end
local function RAB_layout_Sync(synconly)
 RAB_lsc_invert, RAB_lsc_split = RAB_Settings.uiinvertbars, RAB_Settings.uisplitbars;
 RAB_PendingLayoutSync = InCombatLockdown();
 if RAB_PendingLayoutSync then return; end

 local barOffset, barHeight = RAB_Settings.uibarheight + RAB_Settings.uibarvspace, RAB_Settings.uibarheight;
 local barCount, bar, data, ofsy, showstates = {[0]=0, [1]=0 ,[2]=0}; -- barCount[state] = numBars
 for i=1, #RABui_Bars do
  bar, data = RAB_UIBarCollection[i], RABui_Bars[i];
  if not bar then break; end
  ofsy, showstates = "", "";
  for state=0,2 do
   if data.vstates == nil or data.vstates:match(state) then
    ofsy = ofsy .. (ofsy == "" and "" or ";") .. state .. ":" .. (-barCount[state]*barOffset - 17);
    showstates = showstates .. (showstates == "" and "" or ",") .. state;
    barCount[state] = barCount[state] + 1;
   end
   bar:SetAttribute("showstates", showstates); bar:SetAttribute("ofsy", ofsy);
  end
  RAB_layout_SyncColors(i);
  local a,b,c = bar:GetValue();
  bar:SetValue(a or 0, b or 0, c or 0, data.label);
  bar:SetHeight(barHeight); bar.tex:SetHeight(barHeight); bar.tex2:SetHeight(barHeight);
  RAB_layout_SetDefaultSpell(bar, data.cmd:match("^(%a+)"));
  bar.invert = (data.invert == true);
 end
 for i=#RABui_Bars+1, #RAB_UIBarCollection do
  RAB_UIBarCollection[i]:SetAttribute("showstates", "");
 end

 local height = "";
 for i=0,2 do
  height = height .. (";%d:%d"):format(i, 20+barCount[i]*barOffset-RAB_Settings.uibarvspace);
 end
 RABFrame:SetAttribute("headheight", height:sub(2));
 RABFrame:SetAttribute("showstates", (barCount[0] == 0 and "!0," or "") .. (barCount[1] == 0 and "!1," or "") .. (barCount[2] == 0 and "!2," or "") .. "0-9");

 local os = RAB_UIState_Header:GetAttribute("state");
 RAB_UIState_Header:SetAttribute("state", 99);
 RAB_UIState_Header:SetAttribute("state", os);

 RAB_layout_PhysSync();

 if not synconly then
  RAB_layout_UpdateAll();
 end
end
local function RAB_layout_SyncStaticColors()
 RAB_BarLabelExtFont:SetTextColor(unpack(RAB_Settings.uilabelextcolor));
 RAB_BarLabelFont:SetTextColor(unpack(RAB_Settings.uilabelcolor));
 RABFrame:SetBackdropColor(unpack(RAB_Settings.uibgcolor));
 RABFrame:SetBackdropBorderColor(unpack(RAB_Settings.uibgcolor));
 RAB_CastNotify_BL:SetVertexColor(unpack(RAB_Settings.uibgcolor));
 RAB_CastNotify_BR:SetVertexColor(unpack(RAB_Settings.uibgcolor));
 RAB_CastNotify_BC:SetVertexColor(unpack(RAB_Settings.uibgcolor));
 RAB_CastNotify_L:SetVertexColor(unpack(RAB_Settings.uibgcolor));
 RAB_CastNotify_R:SetVertexColor(unpack(RAB_Settings.uibgcolor));
 RAB_CastNotify_C:SetVertexColor(unpack(RAB_Settings.uibgcolor));
end

local function RAB_layout_CombatToggle(event)
 if event == "PLAYER_REGEN_DISABLED" then
  RAB_UIState_PreCombat = tonumber(RAB_UIState_Header:GetAttribute("state"));
  RAB_UIState_Header:SetAttribute("state", RAB_UIState_PreCombat < 10 and 2 or 12);
 elseif event == "PLAYER_REGEN_ENABLED" then
  if RAB_UIState_PreCombat and tonumber(RAB_UIState_Header:GetAttribute("state")) % 10 == 2 then
   RAB_UIState_Header:SetAttribute("state", RAB_UIState_PreCombat);
   RAB_UIState_PreCombat = nil;
  end
  if RAB_PendingLayoutSync then
   RAB_layout_Sync();
  end
  if RAB_PendingLayoutPhysSync then
   RAB_layout_PhysSync();
  end
 end
end
local function RAB_layout_GroupState(event, newstate, oldstate)
 if RAB_Settings["show" .. RAB_UIState_ShowFlags[newstate]] then
  if not RABFrame:IsShown() then
   RAB_UIState_CloseButton:Click();
  end
 elseif RABFrame:IsShown() then
  RAB_UIState_CloseButton:Click();
 end
end
local function RAB_layout_StateSync(self, state)
 local l, r = 32/128, 45/128;
 if tonumber(state) == 0 then
   l, r = 16/128, 29/128;
 end
 RAB_UIState_MinButton:GetNormalTexture():SetTexCoord(l,r,0,13/16);
 RAB_UIState_MinButton:GetHighlightTexture():SetTexCoord(l,r,0,13/16);
 RAB_UIState_MinButton:GetPushedTexture():SetTexCoord(l,r,0,13/16);
end

local function RAB_layout_SettingChanged(e, setting)
 if setting == "enablefadingfx" then
  local nvalue = RAB_Settings.enablefadingfx;
  for i=1,#RAB_UIBarCollection do
   RAB_UIBarCollection[i]:SetScript("OnUpdate", nvalue and RAB_layout_BarRedraw or nil);
   if not nvalue then RAB_UIBarCollection[i].tex2:SetAlpha(0.5); end
  end
 elseif setting == "uiinvertbars" or setting == "uirtlbars" or setting == "uisplitbars" or setting=="uibartexture" then
  RAB_lsc_invert, RAB_lsc_split = RAB_Settings.uiinvertbars, RAB_Settings.uisplitbars;
  RAB_layout_GxPhysSync();
 elseif setting == "uibarfontsize" then
	local font, size, flags = RAB_BarLabelFont:GetFont();
	RAB_BarLabelFont:SetFont(font, RAB_Settings.uibarfontsize, flags);
	local font, size, flags = RAB_BarLabelExtFont:GetFont();
	RAB_BarLabelExtFont:SetFont(font, RAB_Settings.uibarfontsize, flags);
 elseif setting == "uilabelfont" or setting == "uinumberfont" then
	local font = setting == "uilabelfont" and RAB_BarLabelFont or RAB_BarLabelExtFont;
	local ofont, size, flags = font:GetFont();
	font:SetFont(RAB_Settings[setting] or GameFontNormalSmall:GetFont(), size, flags);
	if not font:GetFont() then
		font:SetFont(ofont, size, flags); -- Rejected!
	end
	if setting == "uilabelfont" then
		RABFrameTitle:SetFont(font:GetFont(), 11, flags);
	end
 elseif setting == "uibarwidth" or setting == "uibarheight" or setting == "uibarvspace" then
  RAB_layout_Sync();
 elseif setting == "uilabelcolor" or setting == "uilabelextcolor" or setting == "uibgcolor" then
  RAB_layout_SyncStaticColors();
 end
end
local function RAB_layout_SaveSettings()
 RAB_Settings.LastUIState[GetCVar("realmName") .. "." .. UnitName("player")] = RAB_UIState_PreCombat or RAB_UIState_Header:GetAttribute("state");
end
local function RAB_layout_Show(e, uiobj)
 if uiobj == "ui" and not InCombatLockdown() then
	local ost = tonumber(RAB_UIState_Header:GetAttribute("state"));
  RAB_UIState_Header:SetAttribute("state", (ost > 9 and -10 or 10) + ost);
 end
end

local function RAB_layout_Localize()
 RABFrameTitle:SetText(sRAB_Settings_UIHeader);
 RAB_layout_Sync();
end
local function RAB_layout_ConfigChromeButton(btn, tex, lx, rx, ty, by, a)
 btn:SetNormalTexture(tex); btn:SetHighlightTexture(tex); btn:SetPushedTexture(tex);
 local t = {btn:GetNormalTexture(), btn:GetHighlightTexture(), btn:GetPushedTexture()};
 for i=1, #t do
  t[i]:SetTexture(tex); t[i]:SetTexCoord(lx,rx,ty,by);
  t[i]:SetVertexColor(0.7,0.7,0.7,RAB_layout_ChromeAlpha[i]);
 end
 btn:SetFrameLevel(btn:GetParent():GetFrameLevel()+1);
end
local function RAB_layout_InitTex(tex, path, width, height, point, ofsx, ofsy, left, right, top, bottom, r,g,b,a)
 tex:SetWidth(width); tex:SetHeight(height); tex:SetTexture(path); 
 if point then tex:SetPoint(point, ofsx, ofsy); end
 if left then tex:SetTexCoord(left, right, top, bottom); end
 if r then tex:SetVertexColor(r,g,b,a); end
end
local function RAB_layout_Init()
 if RABFrame then
  RAB_UIState_Header = RABFrame;
do
	for k, f in pairs({RAB_UIState_Header,RAB_UIState_CloseButton, RAB_UIState_MinButton}) do
	f:Execute(("%s = %q;"):format("SelectState", [[
		local rules, state, default = ...;
		state = tonumber(state);
		if not rules then return default; end
		for rule, value in rules:gmatch("([^:;]+):?([^:;]*)") do
			if value == "" then value = true; end
			for inv, cond in rule:gmatch("(!?)([^,]+)") do
				local min, max = cond:match("(%d+)%-(%d+)");
				if (min and (tonumber(min) <= state and tonumber(max) >= state) == (inv ~= "!")) or
				 (tonumber(cond) == state) == (inv ~= "!") or cond == "*" then
					return value;
				end
			end
		end
		return default;
	]]));
	end
	RAB_UIState_Header:SetAttribute("_onattributechanged", [[
		if name == "frameref-newchild" then
			children = children or newtable();
			children[self:GetFrameRef("newchild")] = true;
			value = self:GetAttribute("state");
		elseif name == "state" then
			self:SetHeight(control:Run(SelectState, self:GetAttribute("headheight"), value, self:GetHeight()));
			if control:Run(SelectState, self:GetAttribute("showstates"), value, false) then
				self:Show();
			else
				self:Hide();
			end
		end
		if not children then return; end
		for c in pairs(children) do
			local rules = c:GetAttribute("showstates");
			if rules == nil or control:Run(SelectState, rules, value, false) then
				c:Show();
				c:SetPoint("TOP", self, "TOP", 0, control:Run(SelectState, c:GetAttribute("ofsy"), value, 0));
			else
				c:Hide();
			end
		end
	]]);
	for k, f in pairs({RAB_UIState_CloseButton, RAB_UIState_MinButton}) do
		f:SetAttribute("_onclick", [[
			local os = self:GetParent():GetAttribute("state");
			local ns = control:Run(SelectState, self:GetAttribute("newstate"), os, os);
			if os ~= ns then
				self:GetParent():SetAttribute("state", ns);
			end
		]]);
	end
end

  RAB_UIState_Header:SetAttribute("state", RAB_Settings.LastUIState[GetCVar("realmName") .. "." .. UnitName("player")] or 0);
  RABFrame:SetAttribute("showstates","0-9");
  RAB_UIState_CloseButton:SetAttribute("newstate", "0:10;1:11;2:12;12:2;11:1;10:0");
  RAB_UIState_MinButton:SetAttribute("newstate", "0:1;11:1;12:2;*:0");
  EC_Register("PLAYER_REGEN_ENABLED", "RAB.layout.Combat", RAB_layout_CombatToggle);
  EC_Register("PLAYER_REGEN_DISABLED", "RAB.layout.Combat", RAB_layout_CombatToggle);
  EC_Register("RAB_LOGOUT", "RAB.layout.SaveState", RAB_layout_SaveSettings);

  sRAB_Localize(true,false);

  -- 1.2.0 styling
  local bp = "Interface\\AddOns\\RABuffs\\";
  local edge, bg, cross = bp.."edge.tga", bp.."bg.tga", bp.."cross.tga";
  local lc = RABFrame:CreateTexture("RABFrame_TL", "BACKGROUND");
  lc:SetTexture(cross);
  if lc:GetTexture() then
   RAB_layout_NewStylingModel = true;
   RABFrame:SetBackdrop({bgFile=bg, edgeFile=edge, tile=false, tileSize=16,edgeSize=16, insets = {left=16, right=16, top=16, bottom=16}});
   local b, ba = 0.12, 0.7;
   RABFrame:SetBackdropColor(b, b, b, ba);
   RABFrame:SetBackdropBorderColor(b, b, b, ba);
   RAB_layout_ConfigChromeButton(RAB_UIState_CloseButton, cross, 0, 13/128, 0, 13/16);
   RAB_layout_ConfigChromeButton(RAB_UIState_MinButton, cross, 16/128, 29/128, 0, 13/16);
   RAB_layout_ConfigChromeButton(RABFrame_ConfigButton, cross, 50/128, 63/128, 0, 13/16);
   RABFrame.StateChanged = RAB_layout_StateSync;

   local v, a = 0.5, 0.7;
   RAB_layout_InitTex(lc, cross, 10, 15, "TOPLEFT", 2, -2, 66/128, 76/128, 0, 1, v, v, v, a);
   RAB_layout_InitTex(RABFrame:CreateTexture("RABFrame_TR", "BACKGROUND"), cross, 10, 15, "TOPRIGHT", -2, -2, 99/128, 109/128, 0, 1, v, v, v, a);
   RAB_layout_InitTex(RABFrame:CreateTexture("RABFrame_TC", "BACKGROUND"), cross, 10, 15, "TOPRIGHT", -12, -2, 77/128, 98/128, 0, 1, v, v, v, a);
   RABFrame_TC:SetPoint("TOPLEFT",12,-2);

   RAB_layout_InitTex(RAB_CastNotify:CreateTexture("RAB_CastNotify_BL", "BACKGROUND"), edge, 16, 16, "BOTTOMLEFT", 0, 0, 6/8, 7/8, 0, 1, b, b, b, ba);
   RAB_layout_InitTex(RAB_CastNotify:CreateTexture("RAB_CastNotify_BR", "BACKGROUND"), edge, 16, 16, "BOTTOMRIGHT", 0, 0, 7/8, 1, 0, 1, b, b, b, ba);
   RAB_layout_InitTex(RAB_CastNotify:CreateTexture("RAB_CastNotify_BC", "BACKGROUND"), edge, 16, 16, "BOTTOMLEFT", 16, 0, nil, nil, nil, nil, b, b, b, ba);
   RAB_layout_InitTex(RAB_CastNotify:CreateTexture("RAB_CastNotify_L", "BACKGROUND"), edge, 16, 16, "TOPLEFT", 0, -1, 0, 1/8, 0, 1, b, b, b, ba);
   RAB_layout_InitTex(RAB_CastNotify:CreateTexture("RAB_CastNotify_R", "BACKGROUND"), edge, 16, 16, "TOPRIGHT", 0, -1, 1/8, 2/8, 0, 1, b, b, b, ba);
   RAB_layout_InitTex(RAB_CastNotify:CreateTexture("RAB_CastNotify_C", "BACKGROUND"), bg, 16, 16, "TOPLEFT", 16, -1, 1/8, 2/8, 0, 1, b, b, b, ba);
   RAB_CastNotify_BC:SetPoint("BOTTOMRIGHT", -16, 0); RAB_CastNotify_BC:SetTexCoord(1/8, 0, 0, 0, 1/8, 1, 0, 1);
   RAB_CastNotify_L:SetPoint("BOTTOMLEFT", 0, 16); RAB_CastNotify_R:SetPoint("BOTTOMRIGHT", 0, 16);
   RAB_CastNotify_C:SetPoint("TOPRIGHT", -16, -1); RAB_CastNotify_C:SetPoint("BOTTOMLEFT", -16, 16);
   RAB_layout_SyncStaticColors();
  elseif RAB_cfgMain_Message then
	 RAB_cfgMain_Message(sRAB_Error_DemandingUpdate .. "\n\n" .. sRAB_Error_RestartWoW, "restart");
	 lc:Hide();
  end

  RAB_UIBarCollection = setmetatable(RAB_UIBarCollection, {__index=RAB_layout_SpawnBar});
  EC_Register("RAB_LAYOUT_SYNC", "RAB.layout.sync", RAB_layout_Sync);
  EC_Register("RAB_LAYOUT_SYNC_COLOR", "RAB.layout.syncColor", RAB_layout_SyncColors);
  EC_Register("RAB_LOCALIZATION_LOADED", "RAB.layout.syncSpells", RAB_layout_Localize);
  EC_Register("RAB_SETTING_CHANGED", "RAB.layout.syncSettings", RAB_layout_SettingChanged);
  EC_Register("RAB_SHOW_UI", "RAB.layout.show", RAB_layout_Show);
  EC_Register("RAB_GROUPSTATUS", "RAB.layout.group", RAB_layout_GroupState);

	RAB_layout_SettingChanged("RAB_SETTING_CHANGED", "uinumberfont");
	RAB_layout_SettingChanged("RAB_SETTING_CHANGED", "uilabelfont");
	RAB_layout_SettingChanged("RAB_SETTING_CHANGED", "uibarfontsize");
  
  RABFrame:SetScript("OnUpdate", RAB_layout_UpdateSched);
  RABFrame:SetScript("OnShow", RAB_layout_UpdateAll);
  RABFrame_ConfigButton:SetScript("OnClick", function() EC_Raise("RAB_SHOW_UI", "config"); end)
  EC_Raise("RAB_LAYOUT_SYNC");
 end
end
EC_Register("RAB_LOAD_SVREADY", "RAB.vui.Init", RAB_layout_Init);