-- English Localization
-- Translates user interface and query output to English.
-- Version 1.2.3/full

sRAB_LOCALIZATION["enUS"] = {enLang="English", nativeLang="English", ui=true, out=true, desc="Default English localization.", func=function (ui, output) 
 if output then
  sRAB_BuffOutputPrefix = "<Buffs> ";
  sRAB_BuffOutput_Default_Missing = "%s is missing on:";
  sRAB_BuffOutput_Default_Expire = "%s will soon fade from:"
  sRAB_BuffOutput_Default_Okay = "%s is on:";
  sRAB_BuffOutput_Everyone = "everyone";
  sRAB_BuffOutput_NoOne = "no one";
  sRAB_BuffOutput_Zero = "not applicable";
  sRAB_BuffOutput_Group = "Group ";
  sRAB_BuffOutput_NoReagents = " (no reagents)";

  sRAB_BuffOutput_incombat_Missing = "Out of combat:";
  sRAB_BuffOutput_incombat_Okay = "In combat:";
  sRAB_BuffOutput_pvp_Missing = "Not tagged for PvP:";
  sRAB_BuffOutput_pvp_Okay = "PvP Flagged:";
  sRAB_BuffOutput_flag_Missing = "Not carrying flag:";
  sRAB_BuffOutput_flag_Okay = "Carrying flag:";
  sRAB_BuffOutput_regen_Missing = "Not having a snack:";
  sRAB_BuffOutput_regen_Okay = "Having a picnic:";
  sRAB_BuffOutput_alive_Missing = "Dead:";
  sRAB_BuffOutput_alive_Expire = "Dead soon:";
  sRAB_BuffOutput_alive_Okay = "Alive:";
  sRAB_BuffOutput_water_Missing = "Out of water:";
  sRAB_BuffOutput_water_Expire = "Almost out of water:";
  sRAB_BuffOutput_water_Okay = "Have water:";
  sRAB_BuffOutput_timer_Missing = "%s on cooldown:";
  sRAB_BuffOutput_timer_Okay = "Ready to cast %s:";
  sRAB_BuffOutput_ishere_Missing = "Not here:";
  sRAB_BuffOutput_ishere_Okay = "Here:";
  sRAB_BuffOutput_onycloak_Missing = "Going to die in a fire:";
  sRAB_BuffOutput_onycloak_Okay = "Wearing Onyxia Scale Cloak:";
  sRAB_BuffOutput_debuff_Missing = "Not affected by %s:";
  sRAB_BuffOutput_debuff_Okay = "Affected by %s:";

  sRAB_BuffOutput_Here_AFK = "AFK";
  sRAB_BuffOutput_Here_OOS = "Out of sight";
  sRAB_BuffOutput_Here_OFF = "Offline";
  sRAB_BuffOutput_Here_OK = "Here";
  sRAB_BuffOutput_Mana_OutOfMana = "Out of mana:";
  sRAB_BuffOutput_Mana_Fine = "OK:";
  sRAB_BuffOutput_Mana_DeadAppend = " (dead)";
  sRAB_BuffOutput_Mana_Summary = "Mana: %s / %s (%s%%)";
  sRAB_BuffOutput_BuffInfo_NoTarget = "Nothing is targeted.";
  sRAB_BuffOutput_BuffInfo_General = "[%s] Buffs: %s. Debuffs: %s.";
  sRAB_BuffOutput_BuffInfo_None = "none";
	sRAB_BuffOutput_LimitFragment_LimitToSelf = "[self]";
 end

 if ui then
  sRAB_Core_GroupFormat = "Group %s";
  sRAB_Core_NA = "N/A";
  sRAB_Settings_Welcome = [[<html><body><h1 align="center">RABuffs [vshort]</h1><p>Configure RABuffs using this dialog.</p>
	<p><br/>|cff66aaee|Hoverpage:2|hInterface|h|r and |cff66aaee|Hoverpage:3|hMisc|h|r tabs above contain options affecting how RABuffs looks and works.</p>
	<p>  |cff66aaee|Hconfigpage:LAYOUT|hLayout|h|r tab below is used to select which queries you want displayed.</p>
	<p>  |cff66aaee|Hconfigpage:QUERIES|hQueries|h|r tab below is used to view and modify existing as well as create custom queries ones.</p>
	<p><br/>You can use |cffffffff/rab|r to bring up the RABuffs window while out of combat, and |cffffffff/rab config|r to display this window at any time.</p>
	<h2><br/>About</h2>
	<p>Version: |Hchangelog|h[version]|h</p><p>- |c0000ee55|Hversions|hView version distribution|h|r.</p><p> - |c0000ee55|Hintro|hIntroduction to RABuffs|h|r.</p>
	<h2><br/>Download updates</h2><p>Click on a site name below to copy download page URL.</p><p>|c000077ff[downlink]|r</p></body></html>
	]];
	sRAB_DownloadLocation_Popup = "Get updates from the following address:";
  sRAB_Settings_Intro = [[<html><body><h1 align="center">Introduction</h1><p>It appears that you've just installed RABuffs, so a few words of introduction are probably in order.</p>
			<h2><br/>The user interface</h2><p>Somewhere on your screen is a RABuffs window with a number of bars. Hovering over the bars will display a list of people; you can hold down SHIFT to invert what is being shown. Clicking on a bar will cast the associated spell; CTRL+Clicking outputs a brief summary of the bar to a specified channel. You can configure what buffs (and other things) are displayed using the you can configure it further in the |cffddddddLayout|r tab of this dialog.</p>
			<h2><br/>General configuration options</h2><p>You can use the tabs on upper side of this dialog to change various aspects of what RABuffs does and how it looks like doing it. It is very worthwhile to explore those tabs and customize the options to your liking.</p>
			<h2><br/>Queries</h2><p>RABuffs can display multiple different types of information - almost all player-castable buffs, as well as some additional effects. You can view, customize options, and create new queries to be displayed using the UI on the |cffddddddQueries|r tab of this dialog.</p>
			<h2><br/>Query Links</h2><p>Query links, appearing like a |cff00dbba[Teal item link]|r, allow you to quickly customize your RABuffs layout from the chat interface.</p><p>To send a query link, type it in clear text, RABuffs will automatically make it clickable when it is displayed.</p><p>You can specify group, class and individual players to include/exclude using the following format:<br />|cffdddddd[queryid groups classes +[incl] -[excl]|r|cffdddddd]|r<br />Everything but the queryid is optional; you can find query names by looking up the desired queries in the |cffddddddQueries|r tab.</p><p>Classes are represented by letters: |cfff0f0f0M|rage, war|cfff0f0f0L|rock, |cfff0f0f0P|rriest, |cfff0f0f0R|rogue, |cfff0f0f0D|rruid, |cfff0f0f0H|runter, |cfff0f0f0S|rhaman, |cfff0f0f0W|rarrior, p|cfff0f0f0A|rladin.</p>
			<h2><br/>Slash commands</h2><p>There are two main slash commands:</p><p>|cffbbbbbb/rabq|r : allows you to display/send query text output without using a specific bar.</p><p>|cffbbbbbb/rab|r : various RABuffs-related commands.</p><p>You can always view help for those slash commands by simply typing them without any arguments.</p><br /><br/></body></html>]];

  sRAB_Settings_VersionOverview = "<html><body><h1 align=\"center\">Version Usage</h1><p>The following is a list of versions of RABuffs previously observed using RABuffs.</p><br />%s<br/><p>Legend: |cff%sStable Release|r, |cff%sBeta Release|r, |cff%sRALight|r.</p><br />%s</body></html>";
  sRAB_Settings_VersionOverview_NoData = "<p>No version usage data available.</p>";
	sRAB_Settings_LSM_TexList = [[<html><body><h1 align="center">Bar Textures</h1><p>Click on a texture name to set RABuffs to use that texture to display the buff bars.</p><br/><p>- |c0066ccff|Hsetbartex:default:0|hRABuffs default|h|r.%s</p><br/><p>|c0000ee55|Hoverpage:2|hReturn to UI options|h</p><br/></body></html>]];
	sRAB_Settings_LSM_TexEntry = [[<br/>- |c0066ccff|Hsetbartex:%s:%s|h%s|h|r]];
	sRAB_Settings_LSM_FontList = [[<html><body><h1 align="center">Bar Fonts</h1><p>Click on an element name next to the font you want RABuffs to use for displaying that element.</p><br/>
																<p>- Game Default (|c0066ccff|Hsetbarfont:l:default:0|hLabels|h|r, |c0066ccff|Hsetbarfont:n:default:0|hNumbers|h|r)%s</p><br/><p>|c0000ee55|Hoverpage:2|hReturn to UI options|h</p><br/></body></html>]];
	sRAB_Settings_LSM_FontEntry = [[<br/>- %s (|c0066ccff|Hsetbarfont:l:%s:%s|hLabels|h|r, |c0066ccff|Hsetbarfont:n:%2$s:%3$s|hNumbers|h|r)]];
  sRAB_Settings_Welcome_Return = "<p>|c0000ee55|Hwelcome|hReturn to overview|h|r.</p><br />";
  sRAB_Settings_VersionNewest = " (Up to date)";
  sRAB_Settings_VersionOutdated = " (Newest: %s used by %s on %s)";

  --[[ UIC: IExclude]]
  sRAB_IEC_IncludeHeader = "Also include:"
  sRAB_IEC_ExcludeHeader = "Except:"
  sRAB_IEC_Blank = "No players";
  sRAB_IEC_ClickToToggle = "Click to add/remove your target.";
  sRAB_IEC_TargetPlease = "Target a player in your group.";
  sRAB_IEC_ClickToRemove = "Left click to remove |cffffffff%s|r.";
  sRAB_IEC_ClickToAdd = "Left click to add |cffffffff%s|r."
  sRAB_IEC_ClickToClear = "\nRight click to clear.";

  --[[ Configuration: Configuration ]]
  sRAB_Settings_Tab1 = "Options";
  sRAB_Settings_Tab1Main = "Overview";
  sRAB_Settings_Tab1UI = "Interface";
  sRAB_Settings_Tab1Cast = "Misc";
  sRAB_Settings_Tab1Cast_Header = "Miscellaneous";
  sRAB_Settings_Tab1UI_Header = "User interface";
  sRAB_Settings_Tab1UI_Description = "Customize how RABuffs' interface looks and behaves using the options below.";
  sRAB_Settings_Tab1Cast_Description = "Options that did not fit in elsewhere; mostly concerning casting and query results.";

  --[[ Configuration: Query Management ]]
  sRAB_Settings_Queries_Header = "Queries";
  sRAB_Settings_Queries_Description = "View, modify, and create new RABuffs queries using this dialog.";
  --[[ Configuration: Query Management: Detail ]]
  sRAB_Settings_QuerySelector_NoSelection = "Select a query";
  sRAB_Settings_QuerySelector_NewCustom = "Create a new custom query";
  sRAB_Settings_BuffList_Detail_Priority = NORMAL_FONT_COLOR_CODE .. "Class priority:|r\n%s" .. NORMAL_FONT_COLOR_CODE .. " > |reveryone else" .. NORMAL_FONT_COLOR_CODE .. ".|r";
  sRAB_Settings_BuffList_Detail_UseBig = "Use %s: |cffffffffat least %s people|r.";
  sRAB_QueryDetail_ClassLimit = "Only offer to check on the following classes:";
  sRAB_QueryDetail_RecastTime = "Recast if runs out in: |cffffffff%s minutes|r.";
  sRAB_QueryDetail_CanCast = "RABuffs can cast this spell:\n";
  sRAB_QueryDetail_Version_class = "class-wide version";
  sRAB_QueryDetail_Version_group = "group-wide version";
  sRAB_QueryDetail_NoUI = "This query can not be used as a bar.";
  sRAB_QueryDetail_Custom_DisplayName = "Display name:";
  sRAB_QueryDetail_Custom_QueryName = "Query id:";
  sRAB_QueryDetail_Custom_QueryFor = "Check for a:"
  sRAB_QueryDetail_CMT_LookIn = "Match using:";
  sRAB_QueryDetail_CMT_MatchType = "Match type:";
  sRAB_QueryDetail_CMT_MatchText = "Match text:";
  sRAB_QueryDetail_CMT_Name = "Buff name";
  sRAB_QueryDetail_CMT_Texture = "Buff texture";
  sRAB_QueryDetail_CMT_Exact = "Exact";
  sRAB_QueryDetail_CMT_Loose = "Loose";
  sRAB_QueryDetail_SaveCustom = "Save";
  sRAB_QueryDetail_DeleteCustom = "Delete";
  sRAB_QueryDetail_RevertCustom = "Restore Default";
  sRAB_QueryDetail_InvertByDefault = "Invert results by default";

  --[[ Config/Display: Query Types ]]
  sRAB_BuffType_buff = "Buff";
  sRAB_BuffType_self = "Self-buff";
  sRAB_BuffType_timer = "Timer";
  sRAB_BuffType_aura = "Aura";
  sRAB_BuffType_debuff = "Debuff";
  sRAB_BuffType_other = "Other";
  sRAB_BuffType_special = "Special";
  sRAB_BuffType_dummy = "Spell";
  sRAB_BuffType_item = "Item";
  sRAB_BuffType_custom = "My Queries";
  sRAB_BuffTypeDesc_dummy = "This spell is used by another query. The query should not be used to check for buffs.";
  sRAB_BuffTypeDesc_timer = "This spell's cooldown is shared with your group. If queried directly, will display people able to cast the spell now.";

  --[[ Configuration: Layout ]]
  sRAB_Settings_Layout_Header = "Layout";
  sRAB_Settings_Layout_Description = "Modify the bars displayed by clicking on them in the list below. The profile dropdown can be used to quickly load another layout.";
  sRAB_Settings_Layout_AddNewBar = "(Click here to add a new bar)";
  sRAB_Settings_Layout_Position = "Position";
  sRAB_Settings_Layout_Name = "Label";
  sRAB_Settings_Layout_Query = "Buff queried";

  --[[ Configuration: Bar Detail ]]
  sRAB_Settings_BarDetail_New = "Create a new bar";
  sRAB_Settings_BarDetail_Edit = "Modify an existing bar";
  sRAB_Settings_BarDetail_NewBtn = "Add";
  sRAB_Settings_BarDetail_EditBtn = "Edit";
  sRAB_Settings_BarDetail_Cancel = "Cancel";
  sRAB_Settings_BarDetail_Label = "Label:";
  sRAB_Settings_BarDetail_Query = "Query:";
  sRAB_Settings_BarDetail_ShowState = "Show:";
  sRAB_Settings_BarDetail_Limits = "Limit scan to only include:";
  sRAB_Settings_BarDetail_Remove = "Remove";
  sRAB_Settings_BarDetail_ShowState_Always = "Always";
  sRAB_Settings_BarDetail_ShowState_Full = "Full view";
  sRAB_Settings_BarDetail_ShowState_Minimized = "Mini view";
  sRAB_Settings_BarDetail_ShowState_InCombat = "Combat view";
  sRAB_Settings_BarDetail_ShowState_Never = "Never (?!)";
  sRAB_Settings_BarDetail_ShowState_Invert = "Invert Texture";
  sRAB_Settings_BarDetail_ShowState_InvertShort = " (Invert)";
  sRAB_Settings_BarDetail_OutputTarget = "Output to:";
  sRAB_Settings_BarDetail_Output = {
	RAID="Raid/party chat",
	PARTY="Party chat",
	OFFICER="Officers' chat",
	WhisperMenu="Whisper",
	ChannelMenu="Channel",
	CHANNEL="%s",
	WHISPER="%s (whisper)"
  };
  sRAB_Settings_BarDetail_WhisperPrompt = "Whisper to:";
	sRAB_Settings_BarDetail_LimitToSelf = "Only on me";
	sRAB_Settings_BarDetail_LimitToSelfDescription = "If selected, this bar only executes the query on yourself.";

	--[[ Configuration: Interface/Misc option strings ]]
	sRAB_Settings_OptionHeader_DisplayWhile = "Display while in a...";
  sRAB_Settings_Option_stoppvp="PvP sanity check"
  sRAB_Settings_Option_stoppvp_Description = "If checked, RABuffs will not buff PvP-enabled players in your group unless you are PvP-enabled as well.";
  sRAB_Settings_Option_castbigbuffs = "Cast group/class buffs by default";
  sRAB_Settings_Option_castbigbuffs_Description = "Cast group/class buffs when more effective by default (rather than only on ALT+Click).";
  sRAB_Settings_Option_alwayscastbigbuffs = "Ignore efficiency requirements";
  sRAB_Settings_Option_alwayscastbigbuffs_Description = "Allows casting of group / class buffs on a single person.";
  sRAB_Settings_Option_partymode = "Prioritize own party";
  sRAB_Settings_Option_partymode_Description = "When casting single buffs, buff everyone in your own party before moving on to the rest of the raid.";
  sRAB_Settings_Option_dummymode = "Show help in bar tooltips";
  sRAB_Settings_Option_dummymode_Description = "If unchecked, the \"CTRL+Click to ... SHIFT to invert\" line will not appear in bar tooltips.";
  sRAB_Settings_Option_lockwindow = "Lock UI position";
  sRAB_Settings_Option_lockwindow_Description = "Stops you from accidentally moving the RABuffs window.";
  sRAB_Settings_Option_colorizechat = "Color <Buffs> messages";
  sRAB_Settings_Option_colorizechat_Description = "Colors player names rather than displaying their class as text in incoming <Buffs> messages.";
  sRAB_Settings_Option_showsolo = "Solo";
  sRAB_Settings_Option_showsolo_Description = "RABuffs window will be shown when you're outside a party or raid group.";
  sRAB_Settings_Option_showparty = "Party";
  sRAB_Settings_Option_showparty_Description = "RABuffs window will be shown when you're in a party.";
  sRAB_Settings_Option_showraid = "Raid";
  sRAB_Settings_Option_showraid_Description = "RABuffs window will be shown when you're in a raid group.";
  sRAB_Settings_Option_showbg = "Battleground/Arena";
  sRAB_Settings_Option_showbg_Description = "RABuffs window will be shown when you're fighting filthy Horde/Alliance.";
  sRAB_Settings_Option_enablefadingfx = "Flash 'fading' segment";
  sRAB_Settings_Option_enablefadingfx_Description = "If checked, segments of bars displaying soon-expiring buffs will flash.";
  sRAB_Settings_Option_strictrange = "Strict range check";
  sRAB_Settings_Option_strictrange_Description = "If checked, follow (rather than sight) range wil be used to determine OOR highlighting for tooltips not associated with spells.";
  sRAB_Settings_Option_compactoutput = "Compress chat output";
  sRAB_Settings_Option_compactoutput_Description = "Use Group [x/y] or Class [x/y] notation when showing more than two people from the same group/class.";
  sRAB_Settings_Option_cheapbgbuffs = "Save reagents in battlegrounds";
  sRAB_Settings_Option_cheapbgbuffs_Description = "Prevents RABuffs from casting group/class versions of buffs while inside a PvP battleground.";
  sRAB_Settings_Option_uiinvertbars = "Invert bar textures";
  sRAB_Settings_Option_uiinvertbars_Description = "Display textured bars when buffs are missing rather than present.";
  sRAB_Settings_Option_uirtlbars = "Right-to-Left bars";
  sRAB_Settings_Option_uirtlbars_Description = "Controls whether bar textures start on the left or right side of the RABuffs frame.";
  sRAB_Settings_Option_hookprat = "Enable Prat support";
  sRAB_Settings_Option_hookprat_Description = "More aggressive chat message rewriting when using Prat (disable if encountering chat issues).";
	sRAB_Settings_Option_forcefulself = "Buff self ruthlessly";
	sRAB_Settings_Option_forcefulself_Description = "Prioritizes refreshing buffs on self over buffing other people.";
	sRAB_Settings_Option_uisplitbars = "Split text display";
	sRAB_Settings_Option_uisplitbars_Description = "Bars display the number of people buffed in addition to their normal title.";
	sRAB_Settings_Option_betanotification = "Notify of new beta versions";
	sRAB_Settings_Option_betanotification_Description = "RABuffs will notify you of newer beta versions if this option is enabled, or if you are using a beta version. Betas may be unstable.";
	sRAB_Settings_Option_releasenotification = "Notify of new release versions";
	sRAB_Settings_Option_releasenotification_Description = "RABuffs will notify you of newer release versions if this option is enabled. Releases are generally stable.";
	
	sRAB_Settings_ShowTexList = "Change Textures";
	sRAB_Settings_ShowFontList = "Change Fonts";
	sRAB_Settings_BackgroundColor = "Background";
	sRAB_Settings_LabelColor = "Bar Labels";
	sRAB_Settings_LabelExtColor = "Numbers";

  sRAB_Settings_Slider_uibarheight = "Bar Height (%s)";
  sRAB_Settings_Slider_uibarwidth = "Bar Width (%s)";
  sRAB_Settings_Slider_uibarvspace = "Bar Spacing (%s)";
  sRAB_Settings_Slider_uibarfontsize = "Bar Font Size (%s)";
  sRAB_Settings_Localization_TextFormat = "Localization: %s UI, %s Output";
  sRAB_Settings_Localization_vui = "User Interface";
  sRAB_Settings_Localization_out = "Chat Output";
  sRAB_Settings_profileSelector_Current = "Current Profile: %s";
  sRAB_Settings_profileSelector_Entry = "%s of %s";
  sRAB_Settings_profileSelector_OtherChars = "Character Profiles";
  sRAB_Settings_profileSelector_SaveAs = "Save this layout as";
  sRAB_Settings_profileSelector_SaveAsNew = "A new profile";
  sRAB_Settings_profileSelector_SaveAsDefault = "%s's default profile";
  sRAB_Settings_Profile_NamePrompt = "Insert new profile name:";

	sRAB_Settings_MasterReset = "Master Reset";
	sRAB_Settings_PartialReset = "Partial Reset";
	sRAB_Settings_MasterResetPrompt = "Master Reset will restore ALL of your RABuffs settings to default, and erase any saved layouts. Type MRESET in the box below to perform a master reset.\n\nYour interface will be reloaded to perform the reset.";
	sRAB_Settings_PartialResetPrompt = "Partial Reset will restore your RABuffs settings to default, keeping saved layouts intact. Type PRESET in the box below to perform a partial reset.\n\nYour interface will be reloaded to perform the reset.";

  sRAB_Error_NoBuffData = "Query is not defined.";
  sRAB_Error_StateCombatLock = "[RABuffs] Can not switch UI states while in combat.";
  sRAB_Error_NoQuery = "A valid query is not selected, cannot save bar.";
  sRAB_Error_NoLabel = "Label is empty, cannot save bar.";
  sRAB_Error_NoChannel =  "[RABuffs] Cannot output to '" .. HIGHLIGHT_FONT_COLOR_CODE .. "%s|r': you must join this channel first.";
  sRAB_Error_SaveQuery_NoName = "Cannot save a query with no name.";
  sRAB_Error_SaveQuery_IDConflict = "A query with this ID already exists, specify a different ID.";
  sRAB_Error_SaveQuery_NoMatch = "Cannot save query: nothing to match buff by.";
  sRAB_Error_DemandingUpdate = "This RABuffs update introduces additional files.";
	sRAB_Error_RestartWoW = "Please exit and re-launch World of Warcraft.";

  sRAB_Greeting = "[RABuffs] Version %s loaded. |cffffffff/rab|r & |cffffffff/rab config|r.";
  sRAB_UpdateComplete = "[RABuffs] Updated to version %s. See Recent Changes for more information.";
  sRAB_OutOfDate_Box = NORMAL_FONT_COLOR_CODE .. "You are not using the most recent version of RABuffs (%s). \n\nSee the configuration dialog for download locations.";
  sRAB_OutOfDate = "[RABuffs] Your version of RABuffs is out of date. The newest version is %s (used by %s of %s).";

  sRAB_Menu_HideWindow = "Hide this window";
  sRAB_Menu_Settings = "Configure RABuffs";
  sRAB_Menu_Minimize = "Minimize layout";
  sRAB_Menu_RestoreToFull = "Restore full layout";
  sRAB_Menu_HiddenWindow = "[RABuffs] Use /rab show if you wish to display the UI frame again.";

  --[[ Layout Config: Query Link Menu ]]
  sRAB_ALMenu_Replace = "Replace [%s]";
  sRAB_ALMenu_AddNew = "Add as a new bar";
  sRAB_ALMenu_Groups = "Groups: |cffffffff%s|r";
  sRAB_ALMenu_Classes = "Classes: %s";
	sRAB_ALMenu_LimitToSelf = "Only on yourself";
  sRAB_ALMenu_Include = "Plus: |cffffffff%s|r";
  sRAB_ALMenu_Exclude = "Ignore: |cffffffff%s|r";
  sRAB_ALMenu_DefaultCaption = "New Bar";

  --[[ Casting success and error messages ]]
  sRAB_CastBuff_Cast = "[RABuffs] Cast " .. HIGHLIGHT_FONT_COLOR_CODE .. "%s|r on %s|r.";
  sRAB_CastBuff_CastNeutral = "[RABuffs] Cast " .. HIGHLIGHT_FONT_COLOR_CODE .. "%s|r.";
  sRAB_CastingLayer_Cooldown = "Cooldown on " .. HIGHLIGHT_FONT_COLOR_CODE .. "%s|r: %0.1fs left.";
  sRAB_CastingLayer_Mounted = "Dismount first";
  sRAB_CastingLayer_NoMana = "Not enough mana";
  sRAB_CastingLayer_Dead = "Corpses don't buff people";
  sRAB_CastingLayer_NoCast = "No one to cast " .. HIGHLIGHT_FONT_COLOR_CODE .. "%s|r on: %s PvP, %s out of range.";
  sRAB_CastingLayer_NoNeed = "No one needs " .. HIGHLIGHT_FONT_COLOR_CODE .. "%s|r.";

  sRAB_Tooltip_FadeSoon = "%s will soon fade on:";
  sRAB_Tooltip_ClickToRecast = "Click to recast " .. HIGHLIGHT_FONT_COLOR_CODE .. "%s|r on %s.";
  sRAB_Tooltip_ClickToRecastNeutral = "Click to recast " .. HIGHLIGHT_FONT_COLOR_CODE .. "%s|r.";
  sRAB_Tooltip_ClickToCast = "Click to cast " .. HIGHLIGHT_FONT_COLOR_CODE .. "%s|r on %s.";
  sRAB_Tooltip_ClickToCastNeutral = "Click to cast " .. HIGHLIGHT_FONT_COLOR_CODE .. "%s|r.";
  sRAB_Tooltip_ClickToCastLockdown = "Click to |cffff7700target|r " .. HIGHLIGHT_FONT_COLOR_CODE .. "%s|r.";
  sRAB_Tooltip_ClickToEquip = "Click to equip " .. HIGHLIGHT_FONT_COLOR_CODE .. "%s|r.";
  sRAB_Tooltip_ClickToUse = "Click to use " .. HIGHLIGHT_FONT_COLOR_CODE .. "%s|r.";
  sRAB_Tooltip_ClickToOutput = "CTRL+Click to send to " .. HIGHLIGHT_FONT_COLOR_CODE .. "%s|r.";
  sRAB_Tooltip_ShiftToInvert = "Use SHIFT to invert.";
  sRAB_Tooltip_NoOne = "No one.";
  sRAB_Tooltip_CastFail_Mana = "|cffff0000Cannot cast: Out of mana.|r";
  sRAB_Tooltip_CastFail_Shapeshift = "|cffff0000Cannot cast: Shapeshifted.|r";
  sRAB_Tooltip_CastFail_Taxi = "|cffff0000Cannot cast: mounted.|r";
  sRAB_Tooltip_CastFail_Dead = "|cffff0000Cannot cast: not alive.|r";
  sRAB_Tooltip_CastFail_Cooldown = "|cffff0000Cooldown (%.1fs).|r";
  sRAB_Tooltip_CastFail_Combat = "|cffff0000In combat.|r";
  sRAB_Tooltip_CastFail_NoItem = "|cffff0000Can't find %s.|r";
  sRAB_Tooltip_CastFail_Reagent = "|cffff0000No reagents|r";
  sRAB_Tooltip_TimeLeft = NORMAL_FONT_COLOR_CODE .. "Time left: |r" .. HIGHLIGHT_FONT_COLOR_CODE .. "%s|r" .. NORMAL_FONT_COLOR_CODE .. ".";

  sRAB_Slash_QHelp = {
		"General syntax: |cffffffff/rabq [target] [buff] [groups] [classes] +[[Player1,Player2]] -[[Player3,Player4]]|r",
		"[target], [groups] and [classes] are optional parameters.",
		"[target]: raid/party/w PlayerName/c Channel - specify where to output text.",
		"[buff]: a valid buff to query (use the Query tab). If you want to invert the output, prefix with 'not'.",
		"[groups]: # of each group to scan. '148' would only scan groups 1, 4 and 8.",
		"[classes]: letter for each class to scan (Mage warLock Priest Rogue Druid Hunter Shaman Warrior pAladin)."
	   };
  sRAB_Slash_UnrecognizedQuery = "[RABuffs] Buff query not recongized. You probably wanted /rab [command].";

  _G["BINDING_NAME_CLICK RAB_UIState_CloseButton:LeftButton"] = "Show/Hide UI";
  _G["BINDING_NAME_CLICK RAB_UIState_MinButton:LeftButton"] = "Toggle minimization";
 end

 sRAB_Classes_enUS = {m="Mage",l="Warlock",p="Priest",r="Rogue",d="Druid",h="Hunter",s="Shaman",w="Warrior",p="Paladin"};
 --[[ UI/Output: Buff names ]]
 --[[ REMOVE THIS LINE TO ENABLE LOCALIZATION (remember to replace enUS with your target locale)
  sRAB_BuffNames_enUS = {
			 ai="Arcane Intellect",
			 motw="Mark of the Wild"
		        };
 --]]
end
};