-- ConfigUI/Queries.lua
--  Customize existing and create new queries.
-- Version 1.3.0
local RAB_QueryDetail_SelectedType;

local function RAB_cfgQuery_Selector_UpdateText()
	if RAB_QueryDetail_SelectedType then
		local name = RAB_QueryDetail_SelectedType == "+new" and sRAB_Settings_QuerySelector_NewCustom or sRAB_QueryString(RAB_QueryDetail_SelectedType);
		UIDropDownMenu_SetText(RAB_Settings_querySelector, name);
	else
		UIDropDownMenu_SetText(RAB_Settings_querySelector, sRAB_Settings_QuerySelector_NoSelection);
	end
end
local function RAB_cfgQuery_SetCustomView(qkey)
	local qdata = qkey ~= "+new" and RAB_Buffs[qkey];
	RAB_QueryDetail_CustomName:SetText(qdata and qdata.name or "");
	RAB_QueryDetail_CustomID:SetText(qdata and qkey or "");
	RAB_QueryDetail_CustomMatch:SetText(qdata and qdata.cmatch:match("^%^?(.-)%$?$") or "");
	if qdata then
		RAB_QueryDetail_CustomMatchType, RAB_QueryDetail_CustomType, RAB_QueryDetail_CustomMatchMType = qdata.cmtype, qdata.ctype, qdata:match("^%^(.-)%$$") and 1 or 2;
		RAB_QueryDetail_CustomDelete:Show();
	else
		RAB_QueryDetail_CustomMatchType, RAB_QueryDetail_CustomMatchMType, RAB_QueryDetail_CustomType = 1, 1, 1;
		RAB_QueryDetail_CustomDelete:Hide();
	end
	for i=1,2 do
	 _G["RAB_QueryDetail_CustomMatchMType" ..i]:SetChecked(i==RAB_QueryDetail_CustomMatchMType);
	 _G["RAB_QueryDetail_CustomMatchType" ..i]:SetChecked(i==RAB_QueryDetail_CustomMatchType);
	 _G["RAB_QueryDetail_CustomType" ..i]:SetChecked(i==RAB_QueryDetail_CustomType);
	end
	local limit = "mlprdhswae";
	if qdata and qdata.ignoreClass and qdata.ignoreClass ~= "" then limit = limit:gsub("[" .. qdata.ignoreClass .. "]",""); end
	RAB_QueryDetail_CustomClassLimits:SetValue(limit);
	RAB_SettingsPanel3Custom:Show();
end
local function RAB_cfgQuery_SetDefaultView(qkey)
	RAB_QueryDetail_Caption:SetFormattedText("%s |cffcccccc(%s)", sRAB_Buffname(qkey), qkey);
	local qdata = RAB_Buffs[qkey];
	for i=1,7 do
		RABui_BoolShow(_G["RAB_QueryDetail_Icon" ..i], qdata.textures and qdata.textures[i]);
	  _G["RAB_QueryDetail_Icon" ..i .. "Tex"]:SetTexture("Interface\\Icons\\" .. (qdata and qdata.textures[i] or "Temp"));
	end
	local qtype, castInfo = select(2,sRAB_QueryType(qkey)), "";
	RABui_BoolShow(RAB_QueryDetail_ClassLimits, qtype == "buff")
	if qtype == "buff" then
		local limit = "mlprdhswae";
		if qdata.ignoreClass then limit = limit:gsub("[" .. qdata.ignoreClass .. "]",""); end
		RAB_QueryDetail_ClassLimits:SetValue(limit);
	end
	RAB_QueryDetail_RecastAdjust:Hide();
	RAB_QueryDetail_BigThreshold:Hide();
	RAB_QueryDetail_RecastInfo:SetText("");
	RAB_QueryDetail_CastInfo:SetText("");
	if sRAB_SpellNames[qkey] then
		castInfo = ("%s - |cffffffff%s|r"):format(sRAB_QueryDetail_CanCast, sRAB_SpellNames[qkey]);
		if qdata.bigcast and sRAB_SpellNames[qdata.bigcast] then
			castInfo = ("%s\n - |cffffffff%s|r (%s)"):format(castInfo, sRAB_SpellNames[qdata.bigcast], _G["sRAB_QueryDetail_Version_" .. qdata.bigsort])
			if qdata.bigthreshold then
				local usebig = sRAB_Settings_BuffList_Detail_UseBig:format(_G["sRAB_QueryDetail_Version_" .. qdata.bigsort], qdata.bigthreshold);
				RAB_QueryDetail_CastInfo:SetText(usebig); -- temporary, getting the size here
				RAB_QueryDetail_BigThreshold:SetPoint("BOTTOMLEFT", RAB_QueryDetail_CastInfo, "BOTTOMLEFT", RAB_QueryDetail_CastInfo:GetStringWidth()+5, -5);
				RAB_QueryDetail_BigThreshold:Show();
				castInfo = castInfo .. "\n\n" .. usebig;
		  end
		end
		if qdata.recast then
			RAB_QueryDetail_RecastInfo:SetText(sRAB_QueryDetail_RecastTime:format(qdata.recast));
			RAB_QueryDetail_RecastAdjust:SetPoint("BOTTOMLEFT",RAB_QueryDetail_RecastInfo, "BOTTOMLEFT", RAB_QueryDetail_RecastInfo:GetStringWidth()+5, -5);
			RAB_QueryDetail_RecastAdjust:Show();
	 end
	end
	RAB_QueryDetail_InvertByDefault:SetChecked(RAB_Buffs[qkey].invert and 1 or nil);
	local buffInfo = qtype and _G["sRAB_BuffTypeDesc_" .. qtype] or "";
	if qdata.noUI then buffInfo = buffInfo .. " " .. sRAB_QueryDetail_NoUI; end
	if qdata.description then buffInfo = qdata.description .. (buffInfo == "" and "" or "\n\n") .. buffInfo; end
	RABui_BoolShow(RAB_QueryDetail_CustomRestore, RAB_OBuffs[qkey] ~= nil);
	RAB_QueryDetail_CastInfo:SetText(castInfo);
	RAB_QueryDetail_DetailNote:SetText(buffInfo);
	RAB_SettingsPanel3Content:Show();
end
function RAB_cfgQuery_SetView(qkey)
	RAB_QueryDetail_SelectedType = qkey;
	RAB_cfgQuery_Selector_UpdateText();
	RAB_SettingsPanel3Content:Hide();
	RAB_SettingsPanel3Custom:Hide();
	if not qkey then
		UIDropDownMenu_SetSelectedValue(RAB_Settings_querySelector, nil);
	elseif qkey == "+new" or RAB_Buffs[qkey].type == "custom" then
		RAB_cfgQuery_SetCustomView(qkey);
	else
		RAB_cfgQuery_SetDefaultView(qkey);
	end
end

local function RAB_cfgQuery_Selector_Click(self, key)
	UIDropDownMenu_SetSelectedValue(RAB_Settings_querySelector, key);
	DropDownList1:Hide();
	RAB_cfgQuery_SetView(key);
end
local function RAB_cfgQuery_Selector_Menu(self, level)
	if not RAB_Type_Cats then return; end
	if level == 1 then
		for key,val in pairs(RAB_Type_Cats) do
			UIDropDownMenu_AddButton({text=val,value=val,hasArrow=1,notCheckable=1});
		end
		UIDropDownMenu_AddButton({text=sRAB_Settings_QuerySelector_NewCustom, value="+new", func=RAB_cfgQuery_Selector_Click, arg1="+new", checked=("+new" == RAB_QueryDetail_SelectedType) and 1 or nil});
	elseif UIDROPDOWNMENU_MENU_VALUE then
		for key,val in pairs(RAB_Type_Buffs) do
			if val.castby == UIDROPDOWNMENU_MENU_VALUE then
				UIDropDownMenu_AddButton({text=sRAB_QueryString(val.key), value=val.key, func=RAB_cfgQuery_Selector_Click, arg1=val.key, checked=(val.key == RAB_QueryDetail_SelectedType), tooltipText=val.tooltip, tooltipTitle=val.tooltitle},2);
			end
		end
	end
end

local function RAB_cfgQuery_SaveCustom()
	local nkey, okey = RAB_QueryDetail_CustomID:GetText():lower(), RAB_QueryDetail_SelectedType;
	if not okey then return; end
	local cmt = (RAB_QueryDetail_CustomMatchMType == 1);
	if (RAB_QueryDetail_CustomName:GetText() == "") then
		return RAB_cfgMain_Message(sRAB_Error_SaveQuery_NoName);
	elseif (nkey == "" or (okey == "+new" and RAB_Buffs[nkey] ~= nil)) then
		return RAB_cfgMain_Message(sRAB_Error_SaveQuery_IDConflict);
	elseif (RAB_QueryDetail_CustomMatch:GetText() == "") then
		return RAB_cfgMain_Message(sRAB_Error_SaveQuery_NoMatch);
	end
	if okey ~= "+new" and okey ~= nkey then
		RAB_Buffs[okey], RAB_CBuffs[okey], RAB_CBuffs[nkey] = nil, nil, {};
	elseif not RAB_CBuffs[nkey] then
		RAB_CBuffs[nkey] = {};
	end
	RAB_CBuffs[nkey].name, RAB_CBuffs[nkey].type, RAB_CBuffs[nkey].cmatch = RAB_QueryDetail_CustomName:GetText(), "custom", (cmt and "^" or "") .. RAB_QueryDetail_CustomMatch:GetText() .. (cmt and "$" or "");
	RAB_CBuffs[nkey].ctype, RAB_CBuffs[nkey].cmtype = tonumber(RAB_QueryDetail_CustomType), tonumber(RAB_QueryDetail_CustomMatchType);
	RAB_CBuffs[nkey].ignoreClass = ("mlprdhsawe"):gsub("[" .. RAB_QueryDetail_CustomClassLimits:GetValue() .. "]","");
	RAB_CBuffs[nkey].ignoreClass = RAB_CBuffs[nkey].ignoreClass ~= "" and RAB_CBuffs[nkey].ignoreClass or nil;
	RAB_Buffs[nkey] = RAB_CBuffs[nkey];
	EC_Raise("RAB_QUERY_SYNC");
	RAB_cfgQuery_SetView();
end
local function RAB_cfgQuery_DeleteCustom()
	RAB_Buffs[RAB_QueryDetail_SelectedType], RAB_CBuffs[RAB_QueryDetail_SelectedType] = nil, nil;
	RAB_QueryDetail_SelectedType = nil;
	RAB_SettingsPanel3Custom:Hide();
	RAB_cfgQuery_Selector_UpdateText();
	EC_Raise("RAB_QUERY_SYNC");
end
local function RAB_cfgQuery_RevertChanges()
	if RAB_OBuffs[RAB_QueryDetail_SelectedType] then
		RAB_RestoreQuery(RAB_QueryDetail_SelectedType);
		RAB_QueryDetail_CustomRestore:Hide();
		RAB_cfgQuery_SetView(RAB_QueryDetail_SelectedType);
	end
end
local function RAB_cfgQuery_MoveTreshold(s, shift)
	if (RAB_QueryDetail_SelectedType and RAB_Buffs[RAB_QueryDetail_SelectedType] and RAB_Buffs[RAB_QueryDetail_SelectedType].bigthreshold) then
		RAB_SetCustomFlag(RAB_QueryDetail_SelectedType, "bigthreshold", max(1,RAB_Buffs[RAB_QueryDetail_SelectedType].bigthreshold-shift));
		RAB_cfgQuery_SetView(RAB_QueryDetail_SelectedType);
	end
end
local function RAB_cfgQuery_MoveRecast(s, shift)
	if (RAB_QueryDetail_SelectedType and RAB_Buffs[RAB_QueryDetail_SelectedType] and RAB_Buffs[RAB_QueryDetail_SelectedType].recast) then
		RAB_SetCustomFlag(RAB_QueryDetail_SelectedType, "recast", max(0,RAB_Buffs[RAB_QueryDetail_SelectedType].recast-shift));
		RAB_cfgQuery_SetView(RAB_QueryDetail_SelectedType);
	end
end
local function RAB_cfgQuery_ChangeIgnore()
	if RAB_QueryDetail_ClassLimits:GetValue() ~= "" then
		RAB_SetCustomFlag(RAB_QueryDetail_SelectedType, "ignoreClass", ("mlprdhswae"):gsub(("[%s]"):format(RAB_QueryDetail_ClassLimits:GetValue()),""));
	end
end
local function RAB_cfgQuery_ChangedInvertValue(self)
	RAB_SetCustomFlag(RAB_QueryDetail_SelectedType, "invert", self:GetChecked() and true or false);
	RAB_cfgQuery_SetView(RAB_QueryDetail_SelectedType);
end

local function RAB_cfgQuery_Localize()
	RAB_cfgMain_RegisterPage("QUERIES", sRAB_Settings_Queries_Header, RAB_SettingsPanel3);

	RAB_SettingsPanel3Header:SetText(sRAB_Settings_Queries_Header);
	RAB_SettingsPanel3Description:SetText(sRAB_Settings_Queries_Description);
	RAB_QueryDetail_ClassLimitsCaption:SetText(sRAB_QueryDetail_ClassLimit);
	RAB_QueryDetail_CustomType1Text:SetText(sRAB_BuffType_buff);
	RAB_QueryDetail_CustomType2Text:SetText(sRAB_BuffType_debuff);
	RAB_QueryDetail_CustomMatchType1Text:SetText(sRAB_QueryDetail_CMT_Name);
	RAB_QueryDetail_CustomMatchType2Text:SetText(sRAB_QueryDetail_CMT_Texture);
	RAB_QueryDetail_CustomMatchMType1Text:SetText(sRAB_QueryDetail_CMT_Exact);
	RAB_QueryDetail_CustomMatchMType2Text:SetText(sRAB_QueryDetail_CMT_Loose);
	RAB_SettingsPanel3Custom_NameCaption:SetText(sRAB_QueryDetail_Custom_DisplayName);
	RAB_SettingsPanel3Custom_IDCaption:SetText(sRAB_QueryDetail_Custom_QueryName);
	RAB_SettingsPanel3Custom_CustomTypeCaption:SetText(sRAB_QueryDetail_Custom_QueryFor);
	RAB_SettingsPanel3Custom_LookInCaption:SetText(sRAB_QueryDetail_CMT_LookIn);
	RAB_SettingsPanel3Custom_MatchTypeCaption:SetText(sRAB_QueryDetail_CMT_MatchType);
	RAB_SettingsPanel3Custom_MatchTextCaption:SetText(sRAB_QueryDetail_CMT_MatchText);
	RAB_QueryDetail_CustomClassLimitsCaption:SetText(sRAB_QueryDetail_ClassLimit);
	RAB_QueryDetail_CustomSave:SetText(sRAB_QueryDetail_SaveCustom);
	RAB_QueryDetail_CustomDelete:SetText(sRAB_QueryDetail_DeleteCustom);
	RAB_QueryDetail_CustomRestore:SetText(sRAB_QueryDetail_RevertCustom);
	RAB_QueryDetail_InvertByDefaultText:SetText(sRAB_QueryDetail_InvertByDefault);
	RAB_cfgQuery_Selector_UpdateText();
end
local function RAB_cfgQuery_OnLoad()
	if RAB_Settings_querySelector then
		UIDropDownMenu_Initialize(RAB_Settings_querySelector, RAB_cfgQuery_Selector_Menu);
		UIDropDownMenu_SetWidth(RAB_Settings_querySelector, 250);
	end

	RAB_QueryDetail_Icon1:ClearAllPoints();
	RAB_QueryDetail_Icon1:SetPoint("TOPLEFT", RAB_SettingsPanel3Divider, "BOTTOMLEFT", 9, 0);
	for i=2,7 do 
		_G["RAB_QueryDetail_Icon" .. i]:ClearAllPoints();
		_G["RAB_QueryDetail_Icon" .. i]:SetPoint("TOPLEFT", _G["RAB_QueryDetail_Icon" .. (i-1)], "BOTTOMLEFT", 0, -2);
	end
	RAB_QueryDetail_Caption:SetPoint("TOPLEFT", RAB_QueryDetail_Icon1, "TOPRIGHT", 8, 0);
	RAB_QueryDetail_CastInfo:SetPoint("TOPLEFT", RAB_QueryDetail_Caption, "BOTTOMLEFT", 0, -5);
	RAB_QueryDetail_RecastInfo:SetPoint("TOPLEFT", RAB_QueryDetail_CastInfo, "BOTTOMLEFT", 0, -7);
	RAB_QueryDetail_DetailNote:SetPoint("TOPLEFT", RAB_QueryDetail_RecastInfo, "BOTTOMLEFT", 0, -7);
	RAB_QueryDetail_InvertByDefault:SetPoint("TOPLEFT",RAB_QueryDetail_DetailNote, "BOTTOMLEFT", 0, -5);
	RAB_QueryDetail_ClassLimits:SetPoint("TOPLEFT",RAB_QueryDetail_InvertByDefault, "BOTTOMLEFT", 0, -23);
	RAB_QueryDetail_DetailNote:SetWidth(275);
	RAB_QueryDetail_CastInfo:SetWidth(275);
	RAB_QueryDetail_BigThreshold.Click = RAB_cfgQuery_MoveTreshold;
	RAB_QueryDetail_RecastAdjust.Click = RAB_cfgQuery_MoveRecast;
	RAB_QueryDetail_ClassLimits.Changed = RAB_cfgQuery_ChangeIgnore;
	RAB_QueryDetail_InvertByDefault:SetScript("OnClick", RAB_cfgQuery_ChangedInvertValue);
	RAB_QueryDetail_CustomRestore:SetScript("OnClick", RAB_cfgQuery_RevertChanges);
	RAB_QueryDetail_CustomDelete:SetScript("OnClick", RAB_cfgQuery_DeleteCustom);
	RAB_QueryDetail_CustomSave:SetScript("OnClick", RAB_cfgQuery_SaveCustom);

	RAB_cfgMain_RegisterPage("QUERIES", "Queries", RAB_SettingsPanel3);

	EC_Register("RAB_LOCALIZATION_LOADED", "RAB.cfgQuery.localize", RAB_cfgQuery_Localize);
end
RAB_cfgQuery_OnLoad();