-- ConfigUI/Overview.lua
--  General settings, help and status display for RABuffs.
-- Version 1.2.0

local RAB_cfgOverview_CurTab;
local LSM; -- LibSharedMedia cache

local function RAB_cfgOverview_ShowText(id)
 if id == "welcome" then
  local t = {downlink="", version = "|c0000ff00" .. RABuffs_Version .. "|r" .. sRAB_Settings_VersionNewest, vshort=RABuffs_Version};
	for site in pairs(sRAB_DownloadLocations) do t.downlink = t.downlink .. "- |Hrabsite|h" .. site .. "|h<br/>"; end
  if RAB_Settings.newestVersion and RAB_Settings.newestVersion > RABuffs_DeciVersion then
   local nwr, nwp = RAB_Settings.newestVersionUser:match("^([^.]+)%.(.+)$");
   t.version = "|c00ff0000" .. RABuffs_Version .. "|r"  .. string.format(sRAB_Settings_VersionOutdated,RAB_Settings.newestVersionTitle,nwp,nwr);
  end
  RAB_SettingsPanel1HTML:SetText(sRAB_Settings_Welcome:gsub("%[(%S+)%]",t));
 elseif id == "changelog" then
  RAB_SettingsPanel1HTML:SetText(string.gsub(sRAB_ChangeLog,"</body>", sRAB_Settings_Welcome_Return .. "</body>"));
 elseif id == "versions" then
  local data, content = {}, "";
  for k, v in pairs(RAB_Versions) do
   tinsert(data,{srt=v.d,ver=v.v,nam=v.name,type=(v.ltag == "L" or v.ltag == "") and "live" or "beta"});
  end
	for k, v in pairs(RAL_Versions) do
	 tinsert(data,{srt=-1/(v.d),ver=v.v,nam=v.name,type="light"});
	end
  local colors = {live="00cc00", beta="0077ee", light="ccff22"};
  if #data == 0 then
   content = sRAB_Settings_VersionOverview_NoData;
  else
	 local otype, v;
   table.sort(data,function (a,b) return (a.srt == b.srt) and (a.ver > b.ver) or (a.srt > b.srt); end);
   for k=1,#data do
    if (v ~= data[k].ver) then
     local color = colors[data[k].type];
     content, v, otype = content .. (content ~= "" and ".</p>" or "") .. (otype ~= "light" and data[k].type == "light" and "<p><br/>" or "<p>") .. "|cff" .. color .. data[k].ver .. "|r: " .. data[k].nam, data[k].ver, data[k].type;
    else
     content = content .. ", " .. data[k].nam;
    end
   end
   content = content .. ".</p>";
  end
  local html = string.format(sRAB_Settings_VersionOverview,content, colors.live, colors.beta, colors.light, sRAB_Settings_Welcome_Return);
  RAB_SettingsPanel1HTML:SetText(html);
 elseif id == "intro" then
  RAB_SettingsPanel1HTML:SetText(string.gsub(sRAB_Settings_Intro,"</body>", sRAB_Settings_Welcome_Return .. "</body>"));
 elseif id == "bartex" and LSM then
	local out = "";
	for k, tex in pairs(LSM:List("statusbar")) do
		out = out .. sRAB_Settings_LSM_TexEntry:format("LSM", tex, tex, LSM:Fetch("statusbar", tex));
	end
	RAB_SettingsPanel1Frame1:Show();
	RAB_SettingsPanel1HTML:SetText(sRAB_Settings_LSM_TexList:format(out));
 elseif id == "barfont" and LSM then
	local out = "";
	for k, tex in pairs(LSM:List("font")) do
		out = out .. sRAB_Settings_LSM_FontEntry:format(tex, "LSM", tex, LSM:Fetch("font", tex));
	end
	RAB_SettingsPanel1Frame1:Show();
	RAB_SettingsPanel1HTML:SetText(sRAB_Settings_LSM_FontList:format(out));
 end
-- RAB_SettingsPanel1Frame1:UpdateScrollChildRect();
-- RAB_SettingsPanel1Frame1:SetVerticalScroll(0);
end
local function RAB_cfgOverview_SelectTab(tab)
 local id = type(tab) == "number" and tab or tab:GetID();
 if RAB_cfgOverview_CurTab then RAB_cfgOverview_CurTab:Hide(); end
 RAB_cfgOverview_CurTab = _G["RAB_SettingsPanel1Frame" .. id];
 RAB_cfgOverview_CurTab:Show();
 if (id == 1) then RAB_cfgOverview_ShowText("welcome"); end
 PanelTemplates_SetTab(RAB_Settings_TopNavigation, id);
end
local function RAB_cfgOverview_ClickedLink(self, link, text)
 if link == "rabsite" then
	local site = text:match("|h([^|]+)|h");
	RAB_cfgMain_Prompt(sRAB_DownloadLocation_Popup, nil, sRAB_DownloadLocations[site], "rabsite");
 elseif link:match("^setbartex:") then
  local provider, id = link:match("^setbartex:(%a+):(.+)$");
	if provider == "LSM" and LSM then
		local tex = LSM:Fetch("statusbar", id);
		RAB_Settings.uibartexture = tex;
		EC_Raise("RAB_SETTING_CHANGED", "uibartexture");
	elseif provider == "default" then
		RAB_Settings.uibartexture = false;
		EC_Raise("RAB_SETTING_CHANGED", "uibartexture");	
	end
 elseif link:match("^setbarfont:") then
	local location, provider, id = link:match("^setbarfont:([nl]):(%a+):(.+)$");
	location = location == "l" and "uilabelfont" or "uinumberfont";
	if provider == "LSM" and LSM then
		RAB_Settings[location] = LSM:Fetch("font", id);
	elseif provider == "default" then
		RAB_Settings[location] = false;
	end
	EC_Raise("RAB_SETTING_CHANGED", location);
 elseif link:match("^overpage:(%d+)") then
  RAB_SettingsPanel1Frame1:Hide();
	RAB_cfgOverview_SelectTab(tonumber(link:match("^overpage:(%d+)")));
 elseif link:match("^configpage:(.+)") then
  RAB_cfgMain_FocusPage(link:match("^configpage:(.+)"));
 else
	-- Can't call it directly, hyperlink handler blocks changes.
  EC_Timer("RABC.Overview.ChangePage", function() RAB_cfgOverview_ShowText(link); ResetCursor(); return "remove"; end, 0);
 end
end
local function RAB_cfgOverview_HoverLink(self, link, ...)
 if link:match("^overpage:") or link:match("^configpage:") then
  SetCursor("Interface\\CURSOR\\Interact");
 elseif link:match("^setbarfont:") or link:match("^setbartex:") then
  SetCursor("Interface\\CURSOR\\Cast");
 elseif link == "rabsite" then
  SetCursor("Interface\\Cursor\\Directions");
 else
  SetCursor("Interface\\CURSOR\\Trainer");
 end
end

function RAB_cfgOverview_ToggleOption(option)
 if RAB_Settings[option] ~= nil then
  RAB_Settings[option] = not RAB_Settings[option];
  EC_Raise("RAB_SETTING_CHANGED", option);
 else
  RAB_Print("ASSERT: Option '" .. option .. "' not set.","warn");
 end
end
function RAB_cfgOverview_UpdateOption(self)
 self.name = self:GetName():match("^RAB_Settings_(.+)$");
 _G[self:GetName() .. "Text"]:SetText(_G["sRAB_Settings_Option_" .. self.name]);
 self.toolText = _G["sRAB_Settings_Option_" .. self.name .. "_Description"];
 self:SetChecked(RAB_Settings[self.name] and 1 or 0);
end

function RAB_cfgOverview_UpdateSlider(self)
 self.name, self.text = self:GetName():match("^RAB_Settings_(.+)$"), _G[self:GetName() .. "Text"];
 self.text:SetText(_G["sRAB_Settings_Slider_" .. self.name]:format(RAB_Settings[self.name]));
 self:SetValue(RAB_Settings[self.name]);
end
function RAB_cfgOverview_ValueSlider(self)
 if type(RAB_Settings) == "table" then
  RAB_Settings[self.name] = self:GetValue();
  self.text:SetText(_G["sRAB_Settings_Slider_" .. self.name]:format(RAB_Settings[self.name]));
  EC_Raise("RAB_SETTING_CHANGED", self.name);
 end
end

local function RAB_cfgOverview_Loc_UpdateText()
 UIDropDownMenu_SetText(RAB_Settings_localizationSelector, sRAB_Settings_Localization_TextFormat:format(sRAB_LOCALIZATION[sRAB_LOCALIZATION_ui].nativeLang, sRAB_LOCALIZATION[sRAB_LOCALIZATION_out].nativeLang));
end
local function RAB_cfgOverview_Loc_SetValue(ele, locale)
 RAB_Settings[ele .. "locale"] = locale;
 sRAB_Localize(true,false);
 ToggleDropDownMenu(1, nil, RAB_Settings_localizationSelector);
 RAB_SettingsFrame:Hide();
 RAB_SettingsFrame:Show();
end
local function RAB_cfgOverview_Loc_Menu(self, level)
 local value = UIDROPDOWNMENU_MENU_VALUE;
 if (level == 1 or not level) then
  UIDropDownMenu_AddButton({text=sRAB_Settings_Localization_vui,notCheckable=1,value="ui",hasArrow=1},level);
  UIDropDownMenu_AddButton({text=sRAB_Settings_Localization_out,notCheckable=1,value="out",hasArrow=1},level);
 elseif (value == "ui" or value == "out") then
  for key, val in pairs(sRAB_LOCALIZATION) do
   if val[value] then
    UIDropDownMenu_AddButton({text=val.enLang .. " (" .. val.nativeLang .. ")", tooltipTitle=val.nativeLang, tooltipText=val.desc, checked=(key==_G["sRAB_LOCALIZATION_" .. value]), arg1=value, arg2=key, func=RAB_cfgOverview_Loc_SetValue}, level);
   end
  end
 end
end

local function RAB_cfgOverview_ColorChange(self, r, g, b, a)
	local c;
	if self == RAB_Settings_LabelColorWell then
		c = "uilabelcolor";
	elseif self == RAB_Settings_LabelExtColorWell then
		c = "uilabelextcolor";
	elseif self == RAB_Settings_BackgroundColorWell then
		c = "uibgcolor";
	end
	if not (c and RAB_Settings[c]) then return; end
	RAB_Settings[c][1], RAB_Settings[c][2], RAB_Settings[c][3] = r,g,b;
	if c == "uibgcolor" then RAB_Settings[c][4] = a; end
	EC_Raise("RAB_SETTING_CHANGED", c);
end

local function RAB_cfgOverview_ResetView()
 RAB_cfgOverview_SelectTab(1);
end
local function RAB_cfgOverview_CheckVersion()
 if (RAB_Settings.lastVersion ~= nil and RAB_Settings.lastVersion ~= RABuffs_Version) then
  ShowUIPanel(RAB_SettingsFrame);
  RAB_cfgMain_FocusPage("OVERVIEW");
  RAB_cfgOverview_SelectTab(1);
  RAB_cfgOverview_ShowText("changelog");
  RAB_Print(sRAB_UpdateComplete:format(RABuffs_Version), "ok");
  RAB_Settings.lastVersion, RAB_Settings.newestVersion, RAB_Settings.lastVersionTitle = RABuffs_Version, RABuffs_DeciVersion, RABuffs_Version;
 elseif RAB_Settings.firstRun then
  ShowUIPanel(RAB_SettingsFrame);
  RAB_cfgMain_FocusPage("OVERVIEW");
  RAB_cfgOverview_SelectTab(1);
  RAB_cfgOverview_ShowText("intro");
  RAB_Settings.firstRun = false;
 end

 if (RAB_Settings.newestVersion ~= nil and RAB_Settings.newestVersion > RABuffs_DeciVersion) and RAB_Settings.releasenotification then
  local nwr, nwp = RAB_Settings.newestVersionUser:match("^([^.]+)%.(.+)$");
  RAB_Print(sRAB_OutOfDate:format(RAB_Settings.newestVersionTitle, nwp, nwr),"warn");
  RAB_cfgMain_Message(sRAB_OutOfDate_Box:format(RAB_Settings.newestVersionTitle));
 else
  RAB_Print(sRAB_Greeting:format(RABuffs_Version),"ok");
 end

 return "remove";
end
local function RAB_cfgOverview_CheckLSM()
	LSM = LSM or (LibStub and LibStub:GetLibrary("LibSharedMedia-3.0", true));
	RABui_BoolShow(RAB_Settings_ShowTexList, LSM ~= nil);
	RABui_BoolShow(RAB_Settings_ShowFontList, LSM ~= nil);
end

local pendingReset = nil;
local function RAB_cfgOverview_DoReset()
	local wtR = _G[this:GetParent():GetName().."EditBox"]:GetText();
	if wtR == pendingReset then
		if wtR == "MRESET" then
			RAB_Settings = nil;
		elseif wtR == "PRESET" then
			for k, v in pairs(RAB_Settings) do if k ~= "Layout" then RAB_Settings[k] = nil; end end
		end
		ReloadUI();
	end
end
local function RAB_cfgOverview_HandleReset(self, button)
	if (self == RAB_Settings_MasterReset) then
		pendingReset = "MRESET";
		RAB_cfgMain_Prompt(sRAB_Settings_MasterResetPrompt, RAB_cfgOverview_DoReset)
	else
		pendingReset = "PRESET";
		RAB_cfgMain_Prompt(sRAB_Settings_PartialResetPrompt, RAB_cfgOverview_DoReset);
	end
end

local function RAB_cfgOverview_Localize()
 RAB_cfgMain_RegisterPage("OVERVIEW", sRAB_Settings_Tab1, RAB_SettingsPanel1, RAB_cfgOverview_ResetView);
 RAB_Settings_TopNavigationTab1:SetText(sRAB_Settings_Tab1Main);
 RAB_Settings_TopNavigationTab2:SetText(sRAB_Settings_Tab1UI);
 RAB_Settings_TopNavigationTab3:SetText(sRAB_Settings_Tab1Cast);
 RAB_SettingsPanel1Frame2Header:SetText(sRAB_Settings_Tab1UI_Header);
 RAB_SettingsPanel1Frame2Description:SetText(sRAB_Settings_Tab1UI_Description);
 RAB_SettingsPanel1Frame3Header:SetText(sRAB_Settings_Tab1Cast_Header);
 RAB_SettingsPanel1Frame3Description:SetText(sRAB_Settings_Tab1Cast_Description);
 RAB_Settings_DisplayHeader:SetText(sRAB_Settings_OptionHeader_DisplayWhile);
 RAB_Settings_ShowTexList:SetText(sRAB_Settings_ShowTexList);
 RAB_Settings_ShowFontList:SetText(sRAB_Settings_ShowFontList);
 RAB_cfgOverview_Loc_UpdateText();
 RAB_Settings_LabelColorLabel:SetText(sRAB_Settings_LabelColor);
 RAB_Settings_LabelExtColorLabel:SetText(sRAB_Settings_LabelExtColor);
 RAB_Settings_BackgroundColorLabel:SetText(sRAB_Settings_BackgroundColor);
 RAB_Settings_PartialReset:SetText(sRAB_Settings_PartialReset);
 RAB_Settings_MasterReset:SetText(sRAB_Settings_MasterReset);

 for j=1,3 do
  PanelTemplates_TabResize(_G["RAB_Settings_TopNavigationTab" .. j], 0);
 end
 PanelTemplates_UpdateTabs(RAB_Settings_TopNavigation);
end
local function RAB_cfgOverview_SetValues()
 RAB_Settings_LabelColorWell.sample:SetVertexColor(unpack(RAB_Settings.uilabelcolor));
 RAB_Settings_LabelExtColorWell.sample:SetVertexColor(unpack(RAB_Settings.uilabelextcolor));
 RAB_Settings_BackgroundColorWell.sample:SetVertexColor(unpack(RAB_Settings.uibgcolor));
end
local function RAB_cfgOverview_Load()
 UIDropDownMenu_Initialize(RAB_Settings_localizationSelector, RAB_cfgOverview_Loc_Menu);
 UIDropDownMenu_SetWidth(RAB_Settings_localizationSelector, 250);

 RAB_SettingsPanel1HTML:SetScript("OnHyperlinkClick", RAB_cfgOverview_ClickedLink);
 RAB_SettingsPanel1HTML:SetScript("OnHyperlinkEnter", RAB_cfgOverview_HoverLink);
 RAB_SettingsPanel1HTML:SetScript("OnHyperlinkLeave", function(self, link, ...) SetCursor(nil); end); 

 for i=1,3 do
  _G["RAB_Settings_TopNavigationTab" .. i]:SetScript("OnClick", RAB_cfgOverview_SelectTab);
 end

 RAB_Settings_uibarheight:SetMinMaxValues(5, 35);
 RAB_Settings_uibarheight:SetValueStep(1);
 RAB_Settings_uibarwidth:SetMinMaxValues(90, 250);
 RAB_Settings_uibarwidth:SetValueStep(10);
 RAB_Settings_uibarvspace:SetMinMaxValues(0, 30);
 RAB_Settings_uibarvspace:SetValueStep(1);
 RAB_Settings_uibarfontsize:SetMinMaxValues(8, 24);
 RAB_Settings_uibarfontsize:SetValueStep(1);
 RAB_SettingsPanel1Frame2:SetScript("OnShow", RAB_cfgOverview_CheckLSM);
 RAB_Settings_ShowTexList:SetScript("OnClick", function(self) 	RAB_cfgOverview_ClickedLink(nil, "bartex", nil); self:GetParent():Hide(); end);
 RAB_Settings_ShowFontList:SetScript("OnClick", function(self) 	RAB_cfgOverview_ClickedLink(nil, "barfont", nil); self:GetParent():Hide(); end);
 RAB_Settings_LabelColorWell.Changed = RAB_cfgOverview_ColorChange;
 RAB_Settings_LabelExtColorWell.Changed = RAB_cfgOverview_ColorChange;
 RAB_Settings_BackgroundColorWell.Changed, RAB_Settings_BackgroundColorWell.hasOpacity = RAB_cfgOverview_ColorChange, true;
 
 RAB_Settings_PartialReset:SetScript("OnClick", RAB_cfgOverview_HandleReset);
 RAB_Settings_MasterReset:SetScript("OnClick", RAB_cfgOverview_HandleReset);

 RAB_cfgMain_RegisterPage("OVERVIEW", "Overview", RAB_SettingsPanel1, RAB_cfgOverview_ResetView);
 EC_Register("RAB_LOCALIZATION_LOADED", "RAB.cfgOverview.localize",RAB_cfgOverview_Localize);
 EC_Register("PLAYER_ENTERING_WORLD", "RAB.cfgOverview.version", RAB_cfgOverview_CheckVersion);
 EC_Register("RAB_LOAD_SVREADY", "RAB.cfgOverview.init", RAB_cfgOverview_SetValues);
end
RAB_cfgOverview_Load();