-- ConfigUI/Layout.lua
--  Configure the visual bar collection.
-- Version 1.2.0

local RAB_BarList_Count, RAB_cfgLayout_Bars = 14, {};
local RAB_BarQuery, RAB_BarOutput, RAB_BarShowStates, RAB_BarID, RAB_BarInvertTexture;

local function RAB_CopyTable(t)
 local r = {};
 for k, v in pairs(t) do
  r[k] = type(v) == "table" and RAB_CopyTable(v) or v;
 end
 return r;
end

local function RAB_cfgLayout_Profile_Text()
 local cp = RAB_CurrentProfile;
 if (string.match(cp,"(.+)[.](.+)") ~= nil) then
  local server, char = string.match(cp,"(.+)[.](.+)");
  cp = char .. " of " .. server;
 end
 UIDropDownMenu_SetText(RAB_Settings_profileSelector, string.format(sRAB_Settings_profileSelector_Current,cp));
end
local function RAB_cfgLayout_Profile_Select(self, key)
 RABui_Bars, RAB_Settings.Layout[RAB_CurrentProfile], RAB_CurrentProfile = RAB_Settings.Layout[key], RABui_Bars, key;
 if RAB_BarDetailContainer then RAB_BarDetailContainer:Hide(); end
 EC_Raise("RAB_LAYOUT_SYNC");
 RAB_cfgLayout_Profile_Text();
end
function RAB_cfgLayout_Profile_Add(self, level, match)
 local char, realm;
 if (RAB_Settings.Layout == nil) then return; end
 for key, val in pairs(RAB_Settings.Layout) do
  if (string.match(key,"^[^.]+[.][^.]+$") == nil and match == false) then
   UIDropDownMenu_AddButton({text=key,checked=(RAB_CurrentProfile==key), func=RAB_cfgLayout_Profile_Select, arg1=key, value=key}, level);
  elseif (string.match(key,"^[^.]+[.][^.]+$") ~= nil and match) then
   realm, char = string.match(key,"^([^.]+)[.]([^.]+)$");
   UIDropDownMenu_AddButton({text=sRAB_Settings_profileSelector_Entry:format(char, realm),checked=(RAB_CurrentProfile==key), func=RAB_cfgLayout_Profile_Select, arg1=key, value=key}, level);
  end
 end
end
local function RAB_cfgLayout_Profile_Save(self, key)
 if key == "ask" then
  RAB_cfgMain_Prompt(sRAB_Settings_Profile_NamePrompt, function ()
   local pkey = _G[this:GetParent():GetName().."EditBox"]:GetText();
   if pkey ~= "" then
    RAB_cfgLayout_Profile_Save(pkey);
   end
  end);
 else
  RAB_Settings.Layout[key], RAB_CurrentProfile = RAB_CopyTable(RABui_Bars), key;
  RABui_Bars = RAB_Settings.Layout[key];
  EC_Raise("RAB_LAYOUT_SYNC");
  RAB_cfgLayout_Profile_Text();
 end
end
local function RAB_cfgLayout_Profile_Menu(self, level)
 if not level then return; end
 local pid = GetCVar("realmName") .. "." .. UnitName("player");
 if (level == 1) then
  RAB_cfgLayout_Profile_Add(1, false);
  UIDropDownMenu_AddButton({text=sRAB_Settings_profileSelector_OtherChars, hasArrow=1, value="list"},1);
  UIDropDownMenu_AddButton({text=sRAB_Settings_profileSelector_SaveAs, hasArrow=1, value="save"},1);
 elseif (UIDROPDOWNMENU_MENU_VALUE == "save") then
  UIDropDownMenu_AddButton({text=string.format(sRAB_Settings_profileSelector_SaveAsDefault,UnitName("player")),func=RAB_cfgLayout_Profile_Save,arg1=pid,notClickable=(pid==RABui_CurrentProfile and 1 or nil), value="sac"},2);
  UIDropDownMenu_AddButton({text=sRAB_Settings_profileSelector_SaveAsNew,func=RAB_cfgLayout_Profile_Save,arg1="ask", value="ask"},2);
 elseif (UIDROPDOWNMENU_MENU_VALUE == "list") then
  RAB_cfgLayout_Profile_Add(2, true);
 end
end

local function RAB_cfgLayout_ColorChange(self, r, g, b)
	local RAB_ColorBar = self:GetParent():GetID() + FauxScrollFrame_GetOffset(RAB_Settings_LayoutScrollBar);
  if type(RABui_Bars[RAB_ColorBar].color) ~= "table" then RABui_Bars[RAB_ColorBar].color = {}; end
  local c = RABui_Bars[RAB_ColorBar].color;
  c[1], c[2], c[3] = r,g,b;
  EC_Raise("RAB_LAYOUT_SYNC_COLOR", RAB_ColorBar);
end
local function RAB_cfgLayout_MoveBar(move, dir)
 local id = type(move) == "number" and move or (move:GetParent():GetID() + FauxScrollFrame_GetOffset(RAB_Settings_LayoutScrollBar));
 RABui_Bars[id+dir], RABui_Bars[id] = RABui_Bars[id], RABui_Bars[id+dir];
 EC_Raise("RAB_LAYOUT_SYNC");
end

local function RAB_cfgLayout_SyncBarList()
 FauxScrollFrame_Update(RAB_Settings_LayoutScrollBar, #RABui_Bars+1, RAB_BarList_Count, 16);
 local offset = FauxScrollFrame_GetOffset(RAB_Settings_LayoutScrollBar);

 for i=offset+1,offset+RAB_BarList_Count do
  local bar = RAB_cfgLayout_Bars[i-offset];
  if RABui_Bars[i] and bar then
   bar:Show();
   bar.label:SetText(RABui_Bars[i].label);
   bar.query:SetText(sRAB_Buffname(RABui_Bars[i].cmd:match("^(%a+)")));
   bar.swatch.sample:SetVertexColor(unpack(RABui_Bars[i].color));
   RABui_BoolEnable(bar.move.up, i ~= 1);
   RABui_BoolEnable(bar.move.down, i ~= #RABui_Bars);
  elseif bar then
   bar:Hide();
  end
 end
 if (offset+RAB_BarList_Count > #RABui_Bars) then
  RAB_Settings_BarLine20:SetPoint("TOP", RAB_cfgLayout_Bars[#RABui_Bars - offset], "BOTTOM");
  RAB_Settings_BarLine20:Show();
 else
  RAB_Settings_BarLine20:Hide();
 end
end



local function RAB_cfgLayout_Output_Text()
 local v = RAB_BarDetail_OutputTarget.selectedValue;
 local o = sRAB_Settings_BarDetail_Output[v];
 if v:match("^(%a+):") then
  local c, n = v:match("^(%a+):(.+)$");
  o = sRAB_Settings_BarDetail_Output[c]:format(n);
 end
 UIDropDownMenu_SetText(RAB_BarDetail_OutputTarget, o);
end
local function RAB_cfgLayout_Output_Set(self, key)
 if key ~= "WHISPER" then
  UIDropDownMenu_SetSelectedValue(RAB_BarDetail_OutputTarget, key);
  RAB_BarOutput = key;
  RAB_cfgLayout_Output_Text()
 else
  RAB_cfgMain_Prompt(sRAB_Settings_BarDetail_WhisperPrompt, function()
   local wtNick = _G[this:GetParent():GetName().."EditBox"]:GetText();
   if (string.match(wtNick,"[ !@#$%^&*()_+-=\|;':\",./<>?]") == nil) then
    RAB_cfgLayout_Output_Set("WHISPER:" .. wtNick);
   end
  end);
 end
 DropDownList1:Hide();
end
local function RAB_cfgLayout_Output_Menu(self, level)
 if level == 1 then
  UIDropDownMenu_AddButton({text=sRAB_Settings_BarDetail_Output.RAID, value="RAID", arg1="RAID", func=RAB_cfgLayout_Output_Set});
  UIDropDownMenu_AddButton({text=sRAB_Settings_BarDetail_Output.PARTY, value="PARTY", arg1="PARTY", func=RAB_cfgLayout_Output_Set});
  UIDropDownMenu_AddButton({text=sRAB_Settings_BarDetail_Output.OFFICER, value="OFFICER", arg1="OFFICER", func=RAB_cfgLayout_Output_Set});
  UIDropDownMenu_AddButton({text=sRAB_Settings_BarDetail_Output.WhisperMenu, value="WHISPER",arg1="WHISPER",func=RAB_cfgLayout_Output_Set,checked=RAB_BarOutput:match("^WHISPER:")});
  UIDropDownMenu_AddButton({text=sRAB_Settings_BarDetail_Output.ChannelMenu,value="CHANNEL",hasArrow=1});
 elseif UIDROPDOWNMENU_MENU_VALUE == "CHANNEL" then
  for i=1, 10 do
   id, name = GetChannelName(i);
   if (type(name) == "string" and name ~= "rabuffsgvsync" and not name:match(" ")) then
    UIDropDownMenu_AddButton({text=name, value="CHANNEL:" .. name, func=RAB_cfgLayout_Output_Set, arg1="CHANNEL:" .. name},2);
   end
  end
 end
end


local function RAB_cfgLayout_ShowState_Text()
 local s, tOut = {[0]=not not RAB_BarShowStates:match("0"), [1]=not not RAB_BarShowStates:match("1"), [2]=not not RAB_BarShowStates:match("2")};
 if s[0] and s[1] and s[2] then
  tOut = sRAB_Settings_BarDetail_ShowState_Always;
 else
  tOut = s[0] and sRAB_Settings_BarDetail_ShowState_Full or nil;
  if s[1] then tOut = (tOut and (tOut .. ", ") or "") .. sRAB_Settings_BarDetail_ShowState_Minimized; end
  if s[2] then tOut = (tOut and (tOut .. ", ") or "") .. sRAB_Settings_BarDetail_ShowState_InCombat; end
  tOut = tOut or sRAB_Settings_BarDetail_ShowState_Never;
 end
 if RAB_BarInvertTexture then
  tOut = tOut .. " " .. sRAB_Settings_BarDetail_ShowState_InvertShort;
 end
 UIDropDownMenu_SetText(RAB_BarDetail_ShowState, tOut);
end
local function RAB_cfgLayout_ShowState_Click(self, toggle)
 if toggle == "i" then
  RAB_BarInvertTexture = not RAB_BarInvertTexture;
 else
  local s = {[0]=not not RAB_BarShowStates:match("0"), [1]=not not RAB_BarShowStates:match("1"), [2]=not not RAB_BarShowStates:match("2")};
  s[toggle], RAB_BarShowStates = not s[toggle], "";
  for i=0,2 do RAB_BarShowStates = RAB_BarShowStates .. (s[i] and i or "-"); end
 end
 RAB_cfgLayout_ShowState_Text();
end
local function RAB_cfgLayout_ShowState_Menu()
 RAB_BarShowStates = RAB_BarShowStates or "012";
 UIDropDownMenu_AddButton({text=sRAB_Settings_BarDetail_ShowState_Full, func=RAB_cfgLayout_ShowState_Click, arg1=0, checked=(RAB_BarShowStates:match("0") ~= nil),keepShownOnClick=1});
 UIDropDownMenu_AddButton({text=sRAB_Settings_BarDetail_ShowState_Minimized, func=RAB_cfgLayout_ShowState_Click, arg1=1, checked=(RAB_BarShowStates:match("1") ~= nil),keepShownOnClick=1});
 UIDropDownMenu_AddButton({text=sRAB_Settings_BarDetail_ShowState_InCombat, func=RAB_cfgLayout_ShowState_Click, arg1=2, checked=(RAB_BarShowStates:match("2") ~= nil),keepShownOnClick=1});
 UIDropDownMenu_AddButton({text=sRAB_Settings_BarDetail_ShowState_Invert, func=RAB_cfgLayout_ShowState_Click, arg1="i", checked=RAB_BarInvertTexture == true,keepShownOnClick=1});
end

local function RAB_cfgLayout_SetClassLimits(bkey)
 local mask = "mlpdrhswae";
 if RAB_Buffs[bkey] and (RAB_Buffs[bkey].type == "self" or RAB_Buffs[bkey].type == "timer") then
  RAB_BarDetail_ClassLimits:Hide(); RAB_BarDetail_ClassLimits:SetMask(mask); RAB_BarDetail_ClassLimits:SetValue(mask);
 else
  RAB_BarDetail_ClassLimits:Show();
  if RAB_Buffs[bkey] and RAB_Buffs[bkey].ignoreClass and RAB_Buffs[bkey].ignoreClass ~= "" then
   mask = mask:gsub("[" .. RAB_Buffs[bkey].ignoreClass .. "]", "");
  end
  RAB_BarDetail_ClassLimits:SetMask(mask);
 end
end
local function RAB_cfgLayout_Type_Prepare()
 local srt, cby, old;
 RAB_Type_Buffs, RAB_Type_Cats = {}, {};
 for key, val in pairs(RAB_Buffs) do
  if (val.name ~= nil) then
   cby, srt = sRAB_BuffType_other, "z";
   if (val.castClass) then 
    cby, srt = sRAB_Class(val.castClass), "";
   elseif (val.type == "debuff" or val.type == "item" or val.type == "custom") then 
    cby = sRAB_QueryType(key);
   end
   old = sRAB_Buffname(key);
   tinsert(RAB_Type_Buffs,{name=old,castby=cby, key=key, tooltip=val.description, tooltitle=val.name, sortkey = srt .. cby .. ":" .. old, noUI=val.noUI, type=val.type});
  end
 end
 table.sort(RAB_Type_Buffs, function (a,b) return (a.sortkey < b.sortkey) end);

 for key, val in pairs(RAB_Type_Buffs) do
  if (val.castby ~= old) then
   old = val.castby;
   tinsert(RAB_Type_Cats, old);
  end
 end
end
local function RAB_cfgLayout_Type_Click(self, key)
 RAB_BarQuery = key, UIDropDownMenu_SetSelectedValue(RAB_BarDetail_Type, key);
 RAB_cfgLayout_SetClassLimits(RAB_BarQuery);
 ToggleDropDownMenu(1, nil, RAB_BarDetail_Type);
end
local function RAB_cfgLayout_Type_Menu()
 if RAB_Type_Cats and UIDROPDOWNMENU_MENU_LEVEL == 1 then
  for key,val in pairs(RAB_Type_Cats) do
   UIDropDownMenu_AddButton({text=val,value=val,hasArrow=1,notCheckable=1});
  end
 elseif RAB_Type_Buffs then
  for key,val in pairs(RAB_Type_Buffs) do
   if (val.castby == UIDROPDOWNMENU_MENU_VALUE and val.noUI == nil and val.type ~= "dummy") then
    UIDropDownMenu_AddButton({text=sRAB_QueryString(val.key), value=val.key, func=RAB_cfgLayout_Type_Click, arg1=val.key, checked=(val.key == RAB_BarQuery), tooltipText=val.tooltip, tooltipTitle=val.tooltitle},2);
   end
  end
 end
end
local function RAB_cfgLayout_SelfLimit(self)
	RABui_BoolEnable(RAB_BarDetail_GroupLimits, not self:GetChecked());
	RABui_BoolEnable(RAB_BarDetail_ClassLimits, not self:GetChecked());
end

local function RAB_cfgLayout_SetDetailView(bar)
 local id = bar:GetID() == 20 and 0 or (bar:GetID() + FauxScrollFrame_GetOffset(RAB_Settings_LayoutScrollBar));
 local new = id == 0;

 RAB_BarID = id;
 RAB_BarDetail_Header:SetText(_G["sRAB_Settings_BarDetail_" .. (new and "New" or "Edit")]);
 RAB_BarDetail_Accept:SetText(_G["sRAB_Settings_BarDetail_" .. (new and "NewBtn" or "EditBtn")]);
 RAB_BarDetail_ClassLimits:SetMask("mlpdrhsawe");
 RAB_BarDetail_Label:SetText(new and "" or RABui_Bars[id].label);

 if new then
  RAB_BarQuery, RAB_BarOutput, RAB_BarShowStates = "", "RAID", "012";
  RAB_BarDetail_GroupLimits:SetValue("012345678");
  RAB_BarDetail_IExclude:SetValue("");
	RAB_BarDetail_LimitToSelf:SetChecked(nil);
  RAB_BarInvertTexture = false;
 else
  RAB_BarQuery, RAB_BarOutput, RAB_BarShowStates = RABui_Bars[id].cmd:match("^(%a+)"), RABui_Bars[id].out or "RAID", RABui_Bars[id].vstates or "012";
  local g = (RABui_Bars[id].cmd:match("^%a+ (%d+)") or ""):gsub("9", "");
  RAB_BarDetail_GroupLimits:SetValue(g == "" and "123456780" or g);
  RAB_BarDetail_IExclude:SetValue(RABui_Bars[id].cmd);
	local cb = RABui_Bars[id].cmd:match("^%a+ ?%d* ([mlprdhswae]+)");
	if cb then RAB_BarDetail_ClassLimits:SetValue(cb); end
  RAB_BarInvertTexture = RABui_Bars[id].invert or false;
	RAB_BarDetail_LimitToSelf:SetChecked(RABui_Bars[id].cmd:match("^%a+ [0-8]*9") and 1 or nil);
 end
 UIDropDownMenu_SetSelectedValue(RAB_BarDetail_Type, query);
 UIDropDownMenu_SetText(RAB_BarDetail_Type, RAB_Buffs[RAB_BarQuery] and sRAB_QueryString(RAB_BarQuery) or "");
 RAB_cfgLayout_SetClassLimits(RAB_BarQuery);
 UIDropDownMenu_SetSelectedValue(RAB_BarDetail_OutputTarget, RAB_BarOutput);

 RAB_cfgLayout_Output_Text();
 RAB_cfgLayout_ShowState_Text();

 RABui_BoolShow(RAB_BarDetail_Remove, not new);
 RAB_cfgLayout_SelfLimit(RAB_BarDetail_LimitToSelf);
 RAB_BarListContainer:Hide(); RAB_BarDetailContainer:Show();
end
local function RAB_cfgLayout_IsFullGroups(groups)
	if #groups < 9 then return false; end
	for i=0,8 do
		if not string.find(groups, i, 1, true) then
			return false;
		end
	end
	return true;
end
local function RAB_cfgLayout_SaveDetail()
 local label = RAB_BarDetail_Label:GetText();
 if RAB_Buffs[RAB_BarQuery] and label ~= "" then
  if (RAB_BarID == 0) then
   local r,g,b = random(70,100)/100;
   b, g = r / random(1,3), r / random (1,4);
   for i=1, random(0, 2) do r, g, b = b, r, g; end
   tinsert(RABui_Bars, {color={min(1,max(0,r+random(-10,10)/100)), min(1,max(0,g+random(-10,10)/100)), min(1,max(0,b+random(-10,10)/100))}});
   RAB_BarID = #RABui_Bars;
  end
  local bar = RABui_Bars[RAB_BarID];
  for k, v in pairs(bar) do bar[k] = k == "color" and v or nil; end
  bar.label, bar.out, bar.vstates = label, RAB_BarOutput, RAB_BarShowStates;
  local group, class, ie = RAB_BarDetail_GroupLimits:GetValue(), RAB_BarDetail_ClassLimits:GetValue(), RAB_BarDetail_IExclude:GetValue();
  group = RAB_cfgLayout_IsFullGroups(group) and "" or (" " .. group);
  local ic = 10-strlen(RAB_Buffs[RAB_BarQuery].ignoreClass or "");
  class = class:len() == ic and "" or (" " .. class);
  if ie ~= "" then ie = " " .. ie; end
	if RAB_BarDetail_LimitToSelf:GetChecked() then group = (group == "" and " " or group) .. "9" end
  bar.cmd, bar.invert = RAB_BarQuery .. group .. class .. ie, RAB_BarInvertTexture;
  EC_Raise("RAB_LAYOUT_SYNC");
  RAB_BarDetailContainer:Hide();
 else
  RAB_cfgMain_Message(RAB_Buffs[RAB_BarQuery] and sRAB_Error_NoLabel or sRAB_Error_NoQuery);
 end
end
local function RAB_cfgLayout_DeleteBar()
 tremove(RABui_Bars, RAB_BarID);
 EC_Raise("RAB_LAYOUT_SYNC");
 RAB_BarDetailContainer:Hide();
end

local function RAB_layout_LinkAdd(self, asid)
 if asid == 0 then
  local r,g,b = random(70,100)/100;
  b, g = r / random(1,3), r / random (1,4);
  for i=1, random(0, 2) do r, g, b = b, r, g; end
  local qkey = sRAB_Buffname(RAB_AddLinkMenu.query:match("^(%a+)")) ;
  tinsert(RABui_Bars, {label=qkey ~= "" and qkey or sRAB_ALMenu_DefaultCaption, color={min(1,max(0,r+random(-10,10)/100)), min(1,max(0,g+random(-10,10)/100)), min(1,max(0,b+random(-10,10)/100))}});
  asid = #RABui_Bars;
 end
 RABui_Bars[asid].cmd = RAB_AddLinkMenu.query;
 EC_Raise("RAB_LAYOUT_SYNC");
end
local function RAB_layout_LinkMenu()
 if RAB_AddLinkMenu.query then
  local q, g, c, r = RAB_AddLinkMenu.query:match("^(%a+) ?(%d*) ?([mlprdhswae]*) ?(.*)$");
  UIDropDownMenu_AddButton({text=sRAB_QueryString(q),isTitle=1,notCheckable=1,justifyH="CENTER"});
  if g and g ~= "" then UIDropDownMenu_AddButton({text=g:match("9") and sRAB_ALMenu_LimitToSelf or sRAB_ALMenu_Groups:format(g:gsub("%d", ", %1"):gsub("^, ", "")),isTitle=1,notCheckable=1}); end
  if c and c ~= "" and not (g and g:match("9")) then 
   local oc, log, i = "", "", 0;
   for cl in c:gmatch("%a") do
    if RAB_ClassShort[cl] and not log:match(cl) then
     i, log, oc = i + 1, log .. cl, oc .. (oc == "" and "" or ", ") .. RAB_Chat_Color(RAB_ClassShort[cl], RAB_ClassShort[cl]);
     if i == 4 then
      UIDropDownMenu_AddButton({text=sRAB_ALMenu_Classes:format(oc),isTitle=1,notCheckable=1});
      oc = "";
     end
    end
   end
   if oc ~= "" then
    UIDropDownMenu_AddButton({text=sRAB_ALMenu_Classes:format(oc),isTitle=1,notCheckable=1});
   end
  end
  if r and r ~= "" and r:match("%+(%b[])") then UIDropDownMenu_AddButton({text=sRAB_ALMenu_Include:format(r:match("%+(%b[])"):match("^%[(.+)%]$"):gsub(",",", ")),isTitle=1,notCheckable=1}); end
  if r and r ~= "" and r:match("%-(%b[])") then UIDropDownMenu_AddButton({text=sRAB_ALMenu_Exclude:format(r:match("%-(%b[])"):match("^%[(.+)%]$"):gsub(",",", ")),isTitle=1,notCheckable=1}); end
  for i=1,#RABui_Bars do
   if q == RABui_Bars[i].cmd:match("^(%a+)") then
    UIDropDownMenu_AddButton({text=sRAB_ALMenu_Replace:format(RABui_Bars[i].label),notCheckable=1,func=RAB_layout_LinkAdd,arg1=i});
   end
  end
  UIDropDownMenu_AddButton({text=sRAB_ALMenu_AddNew, notCheckable=1, func=RAB_layout_LinkAdd, arg1=0});
 end
end
local function RAB_layout_LinkParse(w, ls, c, rs)
 if ls:match("|h") or rs:match("|H") then return w; end
 local key, groups, classes, r = c:match("^%[(%a+) ?(%d*) ?([mlprdhswae]*) ?(.*)%]$");
 if key and RAB_Buffs[key] and r:gsub("%+%b[]", "", 1):gsub("%-%b[]", "", 1):gsub("%s", "") == "" then
  return "|cff00dbba|Hrabqlink|h" .. c .. "|h|r";
 end
 return w;
end
local function RAB_layout_LinkFilter(t)
 return t:gsub("((%S*)(%b[])(%S*))", RAB_layout_LinkParse);
end
local oSIR, oSCM = SetItemRef, SendChatMessage;
SetItemRef = function(link, text, button, ...)
 if link == "rabqlink" and type(text) == "string" and not IsShiftKeyDown() then
  RAB_AddLinkMenu.query = text:match("%[(.+)%]");
  ToggleDropDownMenu(1, nil, RAB_AddLinkMenu, "cursor", 0, 0);
 else
  return oSIR(link, text, button, ...);
 end
end
SendChatMessage = function(t, ...)
 oSCM(type(t) == "string" and t:gsub("|cff00dbba|Hrabqlink|h(%b[])|h|r", "%1") or t, ...);
end
RAB_RegisterChatHook("querylink", "%[%a+ ?.*%]", RAB_layout_LinkFilter);


local function RAB_cfgLayout_Localize()
 RAB_cfgMain_RegisterPage("LAYOUT", sRAB_Settings_Layout_Header, RAB_SettingsPanel2);
 RAB_SettingsPanel2Header:SetText(sRAB_Settings_Layout_Header);
 RAB_SettingsPanel2Description:SetText(sRAB_Settings_Layout_Description); 
 RAB_Settings_BarLine0Name:SetText(sRAB_Settings_Layout_Name);
 RAB_Settings_BarLine0Position:SetText(sRAB_Settings_Layout_Position);
 RAB_Settings_BarLine0Query:SetText(sRAB_Settings_Layout_Query);
 RAB_Settings_BarLine20:SetText(sRAB_Settings_Layout_AddNewBar);
 RAB_BarDetail_LabelText:SetText(sRAB_Settings_BarDetail_Label);
 RAB_BarDetail_QueryText:SetText(sRAB_Settings_BarDetail_Query);
 RAB_BarDetail_OutputText:SetText(sRAB_Settings_BarDetail_OutputTarget);
 RAB_BarDetail_LimitsText:SetText(sRAB_Settings_BarDetail_Limits);
 RAB_BarDetail_StateText:SetText(sRAB_Settings_BarDetail_ShowState);
 RAB_BarDetail_Remove:SetText(sRAB_Settings_BarDetail_Remove);
 RAB_BarDetail_Close:SetText(sRAB_Settings_BarDetail_Cancel);
 RAB_BarDetail_LimitToSelf.toolHeader, RAB_BarDetail_LimitToSelf.toolText = 
	sRAB_Settings_BarDetail_LimitToSelf, sRAB_Settings_BarDetail_LimitToSelfDescription;
 RAB_cfgLayout_Profile_Text();
 RAB_cfgLayout_Type_Prepare();
end
local function RAB_cfgLayout_OnLoad()
 if RAB_Settings_profileSelector then
  UIDropDownMenu_Initialize(RAB_Settings_profileSelector, RAB_cfgLayout_Profile_Menu);
  UIDropDownMenu_SetWidth(RAB_Settings_profileSelector, 250);
 end
 if RAB_BarDetail_Type then
  UIDropDownMenu_Initialize(RAB_BarDetail_Type, RAB_cfgLayout_Type_Menu);
  UIDropDownMenu_SetWidth(RAB_BarDetail_Type, 180);
 end
 if RAB_BarDetail_ShowState then
  UIDropDownMenu_Initialize(RAB_BarDetail_ShowState, RAB_cfgLayout_ShowState_Menu);
  UIDropDownMenu_SetWidth(RAB_BarDetail_ShowState, 180);
 end
 if RAB_BarDetail_OutputTarget then
  UIDropDownMenu_Initialize(RAB_BarDetail_OutputTarget, RAB_cfgLayout_Output_Menu);
  UIDropDownMenu_SetWidth(RAB_BarDetail_OutputTarget, 180);
 end
 if RAB_Settings_BarLine0 then
  local n = NORMAL_FONT_COLOR;
  RAB_Settings_BarLine0Name:SetTextColor(n.r, n.g, n.b);
  RAB_Settings_BarLine0Query:SetTextColor(n.r, n.g, n.b);
  RAB_Settings_BarLine0Position:SetTextColor(n.r, n.g, n.b);
  RAB_Settings_BarLine0:Disable();
  RAB_Settings_BarLine0Move:Hide();
  RAB_Settings_BarLine0Swatch:Hide();
 end
 if RAB_BarListContainer then
  RAB_cfgLayout_Bars[0] = RAB_Settings_BarLine0;
  for i=1,RAB_BarList_Count do
   local n = "RAB_Settings_BarLine" .. i;
   RAB_cfgLayout_Bars[i] = CreateFrame("BUTTON", n, RAB_BarListContainer,"RAB_Settings_BarLine");
   local b = RAB_cfgLayout_Bars[i];
   b:SetPoint("TOP", RAB_cfgLayout_Bars[i-1], "BOTTOM"); b:SetID(i);
   b.swatch, b.move, b.label, b.query = _G[n .. "Swatch"], _G[n .. "Move"], _G[n .. "Name"], _G[n .. "Query"];
   b.move.Click, b.swatch.Changed = RAB_cfgLayout_MoveBar, RAB_cfgLayout_ColorChange;
   b:SetScript("OnClick", RAB_cfgLayout_SetDetailView);
  end
  RAB_Settings_BarLine20:SetScript("OnClick", RAB_cfgLayout_SetDetailView);
  RAB_Settings_LayoutScrollBar:SetPoint("BOTTOMRIGHT", RAB_cfgLayout_Bars[RAB_BarList_Count], "BOTTOMRIGHT", -2, 0);
  RAB_Settings_LayoutScrollBar:SetScript("OnVerticalScroll", function(...) FauxScrollFrame_OnVerticalScroll(16, RAB_cfgLayout_SyncBarList); end);
 end
 if RAB_BarDetail_Accept then
  RAB_BarDetail_Accept:SetScript("OnClick", RAB_cfgLayout_SaveDetail);
 end
 if RAB_BarDetail_Remove then
  RAB_BarDetail_Remove:SetScript("OnClick", RAB_cfgLayout_DeleteBar);
 end
 if RAB_BarDetail_LimitToSelf then
  RAB_BarDetail_LimitToSelf:SetScript("OnClick", RAB_cfgLayout_SelfLimit);
 end
 if RAB_AddLinkMenu then
  UIDropDownMenu_Initialize(RAB_AddLinkMenu, RAB_layout_LinkMenu, "MENU");
 end

 RAB_cfgMain_RegisterPage("LAYOUT", "Layout", RAB_SettingsPanel2);
 EC_Register("RAB_LOCALIZATION_LOADED", "RAB.cfgLayout.localize", RAB_cfgLayout_Localize);
 EC_Register("RAB_LAYOUT_SYNC", "RAB.cfgLayout.Sync", RAB_cfgLayout_SyncBarList);
 EC_Register("RAB_LAYOUT_SYNC_COLOR", "RAB.cfgLayout.Sync2", RAB_cfgLayout_SyncBarList);
 EC_Register("RAB_QUERY_SYNC", "RAB.cfgLayout.QSync", RAB_cfgLayout_Type_Prepare);
end
RAB_cfgLayout_OnLoad();