-- ConfigUI/Base.lua
-- Handles basic config frame functions.
-- Version 1.2.0

local RABui_Config_Tabs, RABui_Config_Pages = 3, 4;

StaticPopupDialogs["RAB_PROMPTDIALOG"], StaticPopupDialogs["RAB_MSG"] = {
	button1 = TEXT(ACCEPT),
	button2 = TEXT(CANCEL),
	hasEditBox = 1,
	maxLetters = 255,
	whileDead = 1,
	timeout = 0,
	hideOnEscape = true,
	OnHide = function() _G[this:GetName().."EditBox"]:SetText(""); end
}, {
	button1 = TEXT(OKAY),
	whileDead = 1,
	timeout = 0,
	hideOnEscape = 1
};

local RAB_cfgMain_Pages, RAB_cfgMain_PageTabs, RAB_cfgMain_CurPage = {}, {};

function RAB_cfgMain_Prompt(text, func, default, ident)
 ident = "RAB_PROMPTDIALOG" .. (ident or "")
 if not StaticPopupDialogs[ident] then StaticPopupDialogs[ident] = StaticPopupDialogs["RAB_PROMPTDIALOG"] end
 local dia = StaticPopupDialogs[ident];
 dia.text, dia.OnAccept, dia.EditBoxOnEnterPressed = text, func, func;
 local dialog = StaticPopup_Show(ident);
 if default then _G[dialog:GetName() .. "EditBox"]:SetText(default); _G[dialog:GetName() .. "EditBox"]:HighlightText(0, #default) end
 return dialog;
end
function RAB_cfgMain_Message(text, ident)
 ident = "RAB_MSG" .. (ident or "")
 StaticPopupDialogs[ident] = StaticPopupDialogs[ident] or StaticPopupDialogs["RAB_MSG"];
 StaticPopupDialogs[ident].text = text;
 StaticPopup_Show(ident);
end

function RAB_cfgMain_FocusPage(key)
 local newpage = RAB_cfgMain_Pages[key];
 if RAB_cfgMain_CurPage then RAB_cfgMain_CurPage:Hide(); end
 if newpage[4] then newpage[4](); end
 newpage[3]:Show();
 RAB_cfgMain_CurPage = newpage[3];
 PanelTemplates_SetTab(RAB_SettingsFrame, newpage[1]);
end
local function RAB_cfgMain_SelectPage(self)
 if self.key and RAB_cfgMain_Pages[self.key] then
  RAB_cfgMain_FocusPage(self.key);
 end
end
function RAB_cfgMain_RegisterPage(key, label, frame, showfunc)
 local page, tab = RAB_cfgMain_Pages[key];
 if not page then
  local nid = #RAB_cfgMain_PageTabs + 1;
  RAB_SettingsFrame.numTabs, RAB_cfgMain_PageTabs[nid] = nid, CreateFrame("BUTTON", "RAB_SettingsFrameTab" .. nid, RAB_SettingsFrame, "CharacterFrameTabButtonTemplate");
  RAB_cfgMain_Pages[key], tab = {nid, label, frame, showfunc}, RAB_cfgMain_PageTabs[nid];
  tab:SetID(nid);
  if nid == 1 then
   tab:SetPoint("TOPLEFT", tab:GetParent(), "BOTTOMLEFT", 15, 77);
   RAB_cfgMain_CurPage = frame;
  else
   tab:SetPoint("LEFT", RAB_cfgMain_PageTabs[#RAB_cfgMain_PageTabs - 1], "RIGHT", -16, 0);
  end
  tab:SetScript("OnClick", RAB_cfgMain_SelectPage);
 else
  tab = RAB_cfgMain_PageTabs[page[1]];
 end
 tab:SetText(label); tab.key = key;
 for j=1,#RAB_cfgMain_Pages do
  PanelTemplates_TabResize(_G["RAB_SettingsFrameTab" .. j], 0);
 end
 PanelTemplates_UpdateTabs(RAB_SettingsFrame);
end

local function RAB_cfgMain_Localize()
 RAB_SettingsTitleText:SetText(sRAB_Settings_UIHeader);
end
local function RAB_cfgMain_Show(e, uiobject)
 if uiobject == "config" and RAB_cfgMain_PageTabs[1] then
  if RAB_SettingsFrame:IsShown() then
   HideUIPanel(RAB_SettingsFrame);
  else
   RAB_cfgMain_SelectPage(RAB_cfgMain_PageTabs[1]);
   ShowUIPanel(RAB_SettingsFrame);
  end
 end
end

EC_Register("RAB_SHOW_UI", "RAB.cfgMain.show", RAB_cfgMain_Show);
EC_Register("RAB_LOCALIZATION_LOADED", "RAB.cfgMain.localize", RAB_cfgMain_Localize);