
local L = LibStub("AceLocale-3.0"):GetLocale("Quiet Npc")

local cfgFrame = CreateFrame("FRAME", nil, UIParent);

-- berschrift
local cfgFrameHeader = cfgFrame:CreateFontString("OVERLAY", nil, "GameFontNormalLarge");
cfgFrameHeader:SetPoint("TOPLEFT", 15, -15);

-- Konfiguratiostext
local cfgShowConfigText = cfgFrame:CreateFontString("OVERLAY", nil, "GameFontNormalSmall");
cfgShowConfigText:SetPoint("TOPLEFT", 15, -45);

-- Aktivierung
local cfgEnable = CreateFrame("CHECKBUTTON", "QN_cfgEnable", cfgFrame, "OptionsCheckButtonTemplate");
cfgEnable:SetHeight(24); cfgEnable:SetWidth(24); cfgEnable:SetPoint("TOPLEFT", 20, -65);


local defaults = {
    profile = {
        message = "Welcome Home!",
        showInChat = false,
        showOnScreen = true,
    },
}

local eatUpdate = false;

local function QN_cfgInitView()
	if eatUpdate then eatUpdate = false; return; end
	cfgFrameHeader:SetText(L['ConfigUeberschrift']);
	cfgShowConfigText:SetText(L['ConfigText']);
	QN_cfgEnableText:SetText(L['cfgEnable']);
	cfgEnable:SetChecked((QN_Enable ~= false) and 1 or nil);
end

local function QN_cfgSaveView()
	QN_Enable = cfgEnable:GetChecked() == 1;
	QN_cfgInitView();
end

local function QN_cfgSetDefaults()
	cfgEnable : SetChecked(1);
	eatUpdate = true;
end

local function QN_cfgInit()
	cfgFrame : SetScript("OnShow", QN_cfgInitView);
	cfgFrame.name, cfgFrame.okay, cfgFrame.default = "Quiet Npc", QN_cfgSaveView, QN_cfgSetDefaults;
	InterfaceOptions_AddCategory(cfgFrame);
end

QN_cfgInit();