﻿QM_Version = "1.0.1";
QM_Name = "QuickMark";

function print(arg)
    DEFAULT_CHAT_FRAME:AddMessage(arg);
end

function OnLoad()
    print(QM_Name .. " " .. QM_Version .. " loaded.  Use /qm to display available commands.");
    AddSlashCommandHandler();
end

function SlashCommandHandler( msg )
    if (msg=="") then
        print("Use /qm <command>");
        print("   <command>: show, hide, version");
    elseif ( msg=="show" ) then
        ShowMainForm();
    elseif ( msg=="hide" ) then
        HideMainForm();
    elseif ( msg=="version" ) then
        print("You are currently using " .. QM_Name .. " " .. QM_Version .. ".");
    end
end

function AddSlashCommandHandler()
    SlashCmdList["QUICKMARK"] = SlashCommandHandler;
    SLASH_QUICKMARK1 = "/quickmark";
    SLASH_QUICKMARK2 = "/qm";
end

function MarkCurrentTarget ( icon )
    SetRaidTargetIcon("target", icon);
end

function ShowMainForm()
    QuickMarkForm:Show();
end

function HideMainForm()
    QuickMarkForm:Hide();
end