---------------------------------------------------------------------------------------------
QHVERSION = "QuickHeal v2.4.1.0"
---------------------------------------------------------------------------------------------
-- Author
--
--	WakeZero (Saakura on Akama | [Horde]) (Maleena on Kel'Thuzad | Force [Alliance]) 
-- 
-- Description
--
--	This mod allows a player to quickly cast spells/macros on their party and raid with a
--	single mouse click.
--
-- Example
--
--	When enabled, damage taken bars will appear beside each player and party
--	unit frame. These bars increase with the amount of damage a player in the
--	party receives, changing colors from green to yellow to red upon death. When
--	in a raid, damage taken bars will appear beside the name of everyone in the
--	raid for quick and easy monitoring. A range checking option also gives the
--	ability to focus on party and raid members within 30 yards.
--
--	By opening the options menu (/QH or assigned keybinding) the user may
--	choose spells from their spellbook to cast upon the corresponding party
--	member when the bars are clicked. Currently all the mouse buttons may
--	be assigned to, as well as their Shift, Ctrl and Alt variants.
--
--	Macros may also be assigned and are prefixed in the spell list with [MACRO].
--	In order to allow macros to function the way you would expect them to when 
--	clicking on a unit's damage bar, you may use the keyword 'unit' to tell 
--	Quick Heal that you want the spell cast on the bar's unit. To cast the spell
--	renew, you could therefore create a macro '/cast [target=unit] Renew'
--
-- TODO
--
--	* Localize for other languages
--	* Add class specific bindings and options
--	* Clean up logic o.O
--
-- Changelog
--
--	v2.4.1.0 [2008-04-13] : - Added Option To Display Cureable Debuffs (Changes Bar Purple)
--
--				- Added Option To Display Units Out Of Range (75% Transparency)
--
--				- Fixed Unit Names Rearranging In Combat
--
--				- Fixed Range Checking
--
--	v2.3.3.1 [2008-02-11] : - Added Confirm Button To Reset Option
--
--				- Reset Button Now Only Affects Current Tab
--
--				- Added Optional Background To Raid Frame
--
--				- Added Automatic Macro Refresh On Change
--
--				- Made Target Frame Moveable By Holding Shift
--
--				- Fixed Non-English Client Raid Bug
--
--	v2.3.3.0 [2008-01-29] : - Added Raid Functionality
--
--				- Added Macros To Spell List
--
--				- Added Range Checking Option
--
--				- Options Frame Is Now Moveable
--
--	v2.3.0.0 [2007-12-19] : - Added Mouse Button4 and Button5 bindings
--
--				- Added Option to Disable Target Frame Adjustment
--
--				- Added Width/Height Options For Player and Party Damage Bars
--
--	v2.2.3.1 [2007-10-29] : - Added Option Tabs
--
--				- Added Shift, Alt, and Control bindings
--
--				- Added Damage Bar Transparency Setting
--
--				- Added Damage Bar Value Display
--
--				- Added Resurrection to Left Click When Party Member Dies
--
--
--	v2.2.3.0 [2007-10-25] : - First Release
--
-- Shoutouts
--
--	Jesus Christ - For joy, life and eternal love (and the whole forgiveness of sins bit)
--
--	Curse (wow.curse.com) - For hosting my mod and many others.
--
--	WoWWiki (www.wowwiki.com) - Greatest resource and API for WoW mod developers.
--
--	Force (www.forceguild.net) - Grats on Illidan, keep kicking ass!
--
---------------------------------------------------------------------------------------------
-- Variables
---------------------------------------------------------------------------------------------
-- Player Profile
QHProfile = {};
PlayerName = nil;
QHplayerclass = nil;

-- Key Bindings
BINDING_HEADER_QuickHeal = "QuickHeal";

-- QuickHeal Options Variables 
QHrunning = nil;
QHtab = "OPTIONS";
QHtransparency = 0;
QHresurrection = nil;
QHdamagebartext = nil;
QHshowdebuffs = nil;
QHhidenotinrange = nil;

-- QuickHeal Status Bar Variables
QHplayerbarheight = nil;
QHplayerbarwidth = nil;
QHpartybarheight = nil;
QHpartybarwidth = nil;

-- QuickHeal Raid Frame Variables
QHrfx = nil;
QHrfy = nil;
QHrfenabled = nil;
QHrfrows = 25;
QHrfunit = {};
QHrfrange = 'true';
QHrfhideparty = 'true';
QHrfsortby = "CLASS";
QHraidbarheight = nil;
QHraidbarwidth = nil;
QHshowrfbackdrop = nil;

-- QuickHeal Spell Variables [TODO: Put these neatly in list]
QHplayerleft = nil;
QHplayerleftshift = nil;
QHplayerleftctrl = nil;
QHplayerleftalt = nil;
QHplayermiddle = nil;
QHplayermiddleshift = nil;
QHplayermiddlectrl = nil;
QHplayermiddlealt = nil;
QHplayerright = nil;
QHplayerrightshift = nil;
QHplayerrightctrl = nil;
QHplayerrightalt = nil;
QHplayerfour = nil;
QHplayerfourshift = nil;
QHplayerfourctrl = nil;
QHplayerfouralt = nil;
QHplayerfive = nil;
QHplayerfiveshift = nil;
QHplayerfivectrl = nil;
QHplayerfivealt = nil;
QHpartyleft = nil;
QHpartyleftshift = nil;
QHpartyleftctrl = nil;
QHpartyleftalt = nil;
QHpartymiddle = nil;
QHpartymiddleshift = nil;
QHpartymiddlectrl = nil;
QHpartymiddlealt = nil;
QHpartyright = nil;
QHpartyrightshift = nil;
QHpartyrightctrl = nil;
QHpartyrightalt = nil;
QHpartyfour = nil;
QHpartyfourshift = nil;
QHpartyfourctrl = nil;
QHpartyfouralt = nil;
QHpartyfive = nil;
QHpartyfiveshift = nil;
QHpartyfivectrl = nil;
QHpartyfivealt = nil;

-- TargetFrame Position Variables
QHtfdontadjust = nil;
QHtfpoint = nil;
QHtfrelativeTo = nil;
QHtfrelativePoint = nil;
QHtfxofs = nil;
QHtfyofs = nil;

-- Debuff Spells
QHdebufflist = {};

---------------------------------------------------------------------------------------------
-- Setup/Profile Functions
---------------------------------------------------------------------------------------------
function QH_OnLoad()

	-- Setup Slash Commands
	QH_SetupCommands();
	
	-- Set Events
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("PLAYER_LOGIN");
end

function QH_SetupCommands()

	-- Toggles QH on and off
	SlashCmdList["QH"] = QH_ShowOptions;
	SLASH_QH1 = "/QH";
	SLASH_QH2 = "/QuickHeal";
end

function QH_Setup()
	
	-- Initialize Profile Variables
	QH_InitializeProfile();

	-- Store Default TargetFrame Position
	QHtfpoint,QHtfrelativeTo,QHtfrelativePoint,QHtfxofs,QHtfyofs = getglobal("TargetFrame"):GetPoint();

	-- Store Player Class
	local playerClass, englishClass = UnitClass("player");
	QHplayerclass = englishClass;
end

function QH_SetupRaidFrame()

	QHRaidFrame:EnableMouse(false);
	QHRaidFrame:SetFrameStrata("BACKGROUND");
	QHRaidFrame:SetBackdropColor(0.0,0.0,0.0,0.0);

	for i=1,50 do

		local name = CreateFrame("Button","QHNameraid"..i,QHRaidFrame,"SecureUnitButtonTemplate");
		local displayname = CreateFrame("Button","QHDisplayNameraid"..i,QHRaidFrame);
		local nametext = name:CreateFontString("QHNametextraid"..i);
		nametext:SetAllPoints(displayname);
		nametext:SetJustifyH('RIGHT');
		nametext:SetFontObject('GameFontNormalSmall');
		displayname:SetFontString(nametext);
		local bar = CreateFrame("StatusBar","QHBarraid"..i,QHRaidFrame,"QHBarTemplate");
		local button = CreateFrame("Button","QHButtonraid"..i,QHRaidFrame,"QHButtonTemplate");	
	end
end

function QH_SetupUI()

	-- Update Debuff List
	QH_UpdateDebuffList();

	-- Update Status Bars
	QH_UpdateStatusBars("player");
	QH_UpdateStatusBars("party1");
	QH_UpdateStatusBars("party2");
	QH_UpdateStatusBars("party3");
	QH_UpdateStatusBars("party4");

	-- Update Buttons
	QH_SetupUnitButton("player");
	QH_SetupUnitButton("party1");
	QH_SetupUnitButton("party2");
	QH_SetupUnitButton("party3");
	QH_SetupUnitButton("party4");

	-- Update Raid Bars
	QH_SetupRaidButtons();

	-- Hide Party Interface In Raid
	local oldpartyinterface = HIDE_PARTY_INTERFACE;
	if(QHrfhideparty) then
		setglobal("HIDE_PARTY_INTERFACE", "1");
		--RaidOptionsFrame_UpdatePartyFrames();

	else
		setglobal("HIDE_PARTY_INTERFACE", "0");
		--RaidOptionsFrame_UpdatePartyFrames();
	end
	if(oldpartyinterface ~= HIDE_PARTY_INTERFACE) then RaidOptionsFrame_UpdatePartyFrames(); end
	

	-- Adjust Target Frame To Accomodate For Player Status Bar
	getglobal("TargetFrame"):SetClampedToScreen(true);
	if(QHrunning == nil or QHtfdontadjust) then
		
		getglobal("TargetFrame"):SetUserPlaced(false);
		getglobal("TargetFrame"):SetPoint(QHtfpoint, QHtfrelativeTo, QHtfrelativePoint, QHtfxofs, QHtfyofs);
	else
		getglobal("TargetFrame"):RegisterForDrag("LeftButton");
		getglobal("TargetFrame"):SetScript("OnDragStart", function() if(IsShiftKeyDown()) then getglobal("TargetFrame"):StartMoving(); end end);
		getglobal("TargetFrame"):SetScript("OnDragStop", function() getglobal("TargetFrame"):StopMovingOrSizing(); getglobal("TargetFrame"):SetUserPlaced(true); end);
		
		if(not getglobal("TargetFrame"):IsUserPlaced()) then
			getglobal("TargetFrame"):SetPoint(QHtfpoint, QHtfrelativeTo, QHtfrelativePoint, QHtfxofs + QHplayerbarwidth, QHtfyofs);
		end
	end
end

function QH_InitializeProfile()

	if ( UnitName("player") ) then
		PlayerName = UnitName("player").."|"..QH_Trim(GetCVar("realmName"));
		QH_LoadSettings();
	end

	QH_Report();
end

function QH_LoadSettings(tab)

	if(QHProfile[PlayerName] == nil or tab) then

		if(not tab) then
			QHProfile[PlayerName] = {};
			QHProfile[PlayerName]["QHtab"] = "OPTIONS";
		end

		if(not tab or tab == "OPTIONS") then

			QHProfile[PlayerName]["QHrunning"] = 'true';
			QHProfile[PlayerName]["QHtransparency"] = 0;
			QHProfile[PlayerName]["QHresurrection"] = 'true';
			QHProfile[PlayerName]["QHdamagebartext"] = 'true';
			QHProfile[PlayerName]["QHtfdontadjust"] = nil;
			QHProfile[PlayerName]["QHrfrange"] = 'true';
			QHProfile[PlayerName]["QHhidenotinrange"] = nil;
			QHProfile[PlayerName]["QHshowdebuffs"] = 'true';
		end

		if(not tab or tab == "PLAYER") then
			
			QHProfile[PlayerName]["QHplayerleft"] = nil;
			QHProfile[PlayerName]["QHplayerleftshift"] = nil;
			QHProfile[PlayerName]["QHplayerleftctrl"] = nil;
			QHProfile[PlayerName]["QHplayerleftalt"] = nil;
			QHProfile[PlayerName]["QHplayermiddle"] = nil;
			QHProfile[PlayerName]["QHplayermiddleshift"] = nil;
			QHProfile[PlayerName]["QHplayermiddlectrl"] = nil;
			QHProfile[PlayerName]["QHplayermiddlealt"] = nil;
			QHProfile[PlayerName]["QHplayerright"] = nil;
			QHProfile[PlayerName]["QHplayerrightshift"] = nil;
			QHProfile[PlayerName]["QHplayerrightctrl"] = nil;
			QHProfile[PlayerName]["QHplayerrightalt"] = nil;
			QHProfile[PlayerName]["QHplayerfour"] = nil;
			QHProfile[PlayerName]["QHplayerfourshift"] = nil;
			QHProfile[PlayerName]["QHplayerfourctrl"] = nil;
			QHProfile[PlayerName]["QHplayerfouralt"] = nil;
			QHProfile[PlayerName]["QHplayerfive"] = nil;
			QHProfile[PlayerName]["QHplayerfiveshift"] = nil;
			QHProfile[PlayerName]["QHplayerfivectrl"] = nil;
			QHProfile[PlayerName]["QHplayerfivealt"] = nil;
			QHProfile[PlayerName]["QHplayerbarheight"] = 40;
			QHProfile[PlayerName]["QHplayerbarwidth"] = 100;
		end
		
		if(not tab or tab == "PARTY") then
		
			QHProfile[PlayerName]["QHpartyleft"] = nil;
			QHProfile[PlayerName]["QHpartyleftshift"] = nil;
			QHProfile[PlayerName]["QHpartyleftctrl"] = nil;
			QHProfile[PlayerName]["QHpartyleftalt"] = nil;
			QHProfile[PlayerName]["QHpartymiddle"] = nil;
			QHProfile[PlayerName]["QHpartymiddleshift"] = nil;
			QHProfile[PlayerName]["QHpartymiddlectrl"] = nil;
			QHProfile[PlayerName]["QHpartymiddlealt"] = nil;
			QHProfile[PlayerName]["QHpartyright"] = nil;
			QHProfile[PlayerName]["QHpartyrightshift"] = nil;
			QHProfile[PlayerName]["QHpartyrightctrl"] = nil;
			QHProfile[PlayerName]["QHpartyrightalt"] = nil;
			QHProfile[PlayerName]["QHpartyfour"] = nil;
			QHProfile[PlayerName]["QHpartyfourshift"] = nil;
			QHProfile[PlayerName]["QHpartyfourctrl"] = nil;
			QHProfile[PlayerName]["QHpartyfouralt"] = nil;
			QHProfile[PlayerName]["QHpartyfive"] = nil;
			QHProfile[PlayerName]["QHpartyfiveshift"] = nil;
			QHProfile[PlayerName]["QHpartyfivectrl"] = nil;
			QHProfile[PlayerName]["QHpartyfivealt"] = nil;
			QHProfile[PlayerName]["QHpartybarheight"] = 40;
			QHProfile[PlayerName]["QHpartybarwidth"] = 100;
		end
		
		if(not tab or tab == "RAID") then
		
			QHProfile[PlayerName]["QHrfrows"] = 25;
			QHProfile[PlayerName]["QHrfhideparty"] = 'true';
			QHProfile[PlayerName]["QHrfsortby"] = "CLASS";
			QHProfile[PlayerName]["QHrfenabled"] = 'true';
			QHProfile[PlayerName]["QHraidbarheight"] = 12;
			QHProfile[PlayerName]["QHraidbarwidth"] = 50;
			QHProfile[PlayerName]["QHrfx"] = 5;
			QHProfile[PlayerName]["QHrfy"] = 695;
			QHProfile[PlayerName]["QHshowrfbackdrop"] = nil;
			QHProfile[PlayerName]["QHrfbackdropalpha"] = 50;
		end
	end

	QHrunning = QHProfile[PlayerName]["QHrunning"];
	QHtab = QHProfile[PlayerName]["QHtab"];
	QHplayerleft = QHProfile[PlayerName]["QHplayerleft"];
	QHplayerleftshift = QHProfile[PlayerName]["QHplayerleftshift"];
	QHplayerleftctrl = QHProfile[PlayerName]["QHplayerleftctrl"];
	QHplayerleftalt = QHProfile[PlayerName]["QHplayerleftalt"];
	QHplayermiddle = QHProfile[PlayerName]["QHplayermiddle"];
	QHplayermiddleshift = QHProfile[PlayerName]["QHplayermiddleshift"];
	QHplayermiddlectrl = QHProfile[PlayerName]["QHplayermiddlectrl"];
	QHplayermiddlealt = QHProfile[PlayerName]["QHplayermiddlealt"];
	QHplayerright = QHProfile[PlayerName]["QHplayerright"];
	QHplayerrightshift = QHProfile[PlayerName]["QHplayerrightshift"];
	QHplayerrightctrl = QHProfile[PlayerName]["QHplayerrightctrl"];
	QHplayerrightalt = QHProfile[PlayerName]["QHplayerrightalt"];
	QHplayerfour = QHProfile[PlayerName]["QHplayerfour"]; 
	QHplayerfourshift = QHProfile[PlayerName]["QHplayerfourshift"]; 
	QHplayerfourctrl = QHProfile[PlayerName]["QHplayerfourctrl"]; 
	QHplayerfouralt = QHProfile[PlayerName]["QHplayerfouralt"]; 
	QHplayerfive = QHProfile[PlayerName]["QHplayerfive"]; 
	QHplayerfiveshift = QHProfile[PlayerName]["QHplayerfiveshift"]; 
	QHplayerfivectrl = QHProfile[PlayerName]["QHplayerfivectrl"]; 
	QHplayerfivealt = QHProfile[PlayerName]["QHplayerfivealt"]; 
	QHpartyleft = QHProfile[PlayerName]["QHpartyleft"];
	QHpartyleftshift = QHProfile[PlayerName]["QHpartyleftshift"];
	QHpartyleftctrl = QHProfile[PlayerName]["QHpartyleftctrl"];
	QHpartyleftalt = QHProfile[PlayerName]["QHpartyleftalt"];
	QHpartymiddle = QHProfile[PlayerName]["QHpartymiddle"];
	QHpartymiddleshift = QHProfile[PlayerName]["QHpartymiddleshift"];
	QHpartymiddlectrl = QHProfile[PlayerName]["QHpartymiddlectrl"];
	QHpartymiddlealt = QHProfile[PlayerName]["QHpartymiddlealt"];
	QHpartyright = QHProfile[PlayerName]["QHpartyright"];
	QHpartyrightshift = QHProfile[PlayerName]["QHpartyrightshift"];
	QHpartyrightctrl = QHProfile[PlayerName]["QHpartyrightctrl"];
	QHpartyrightalt = QHProfile[PlayerName]["QHpartyrightalt"];
	QHpartyfour = QHProfile[PlayerName]["QHpartyfour"]; 
	QHpartyfourshift = QHProfile[PlayerName]["QHpartyfourshift"]; 
	QHpartyfourctrl = QHProfile[PlayerName]["QHpartyfourctrl"]; 
	QHpartyfouralt = QHProfile[PlayerName]["QHpartyfouralt"]; 
	QHpartyfive = QHProfile[PlayerName]["QHpartyfive"]; 
	QHpartyfiveshift = QHProfile[PlayerName]["QHpartyfiveshift"]; 
	QHpartyfivectrl = QHProfile[PlayerName]["QHpartyfivectrl"]; 
	QHpartyfivealt = QHProfile[PlayerName]["QHpartyfivealt"]; 
	QHtransparency = QHProfile[PlayerName]["QHtransparency"];
	QHresurrection = QHProfile[PlayerName]["QHresurrection"];
	QHdamagebartext = QHProfile[PlayerName]["QHdamagebartext"];
	QHplayerbarheight = QHProfile[PlayerName]["QHplayerbarheight"];
	QHplayerbarwidth = QHProfile[PlayerName]["QHplayerbarwidth"];
	QHpartybarheight = QHProfile[PlayerName]["QHpartybarheight"];
	QHpartybarwidth = QHProfile[PlayerName]["QHpartybarwidth"];
	QHtfdontadjust = QHProfile[PlayerName]["QHtfdontadjust"];
	QHrfrows = QHProfile[PlayerName]["QHrfrows"];
	QHrfrange = QHProfile[PlayerName]["QHrfrange"];
	QHrfhideparty = QHProfile[PlayerName]["QHrfhideparty"];
	QHrfsortby = QHProfile[PlayerName]["QHrfsortby"];
	QHrfenabled = QHProfile[PlayerName]["QHrfenabled"];
	QHraidbarheight = QHProfile[PlayerName]["QHraidbarheight"];
	QHraidbarwidth = QHProfile[PlayerName]["QHraidbarwidth"];
	QHrfx = QHProfile[PlayerName]["QHrfx"];
	QHrfy = QHProfile[PlayerName]["QHrfy"];
	QHshowrfbackdrop = QHProfile[PlayerName]["QHshowrfbackdrop"];
	QHrfbackdropalpha = QHProfile[PlayerName]["QHrfbackdropalpha"];
	QHshowdebuffs = QHProfile[PlayerName]["QHshowdebuffs"];
	QHhidenotinrange = QHProfile[PlayerName]["QHhidenotinrange"];

	--Null Checks
	if(QHtransparency == nil) then QHtransparency = 0; end
	if(QHplayerbarheight == nil) then QHplayerbarheight = 40; end
	if(QHplayerbarwidth == nil) then QHplayerbarwidth = 100; end
	if(QHpartybarheight == nil) then QHpartybarheight = 40; end
	if(QHpartybarwidth == nil) then QHpartybarwidth = 100; end
	if(QHrfrows == nil) then QHrfrows = 25; end
	if(QHrfsortby == nil) then QHrfsortby = "CLASS"; end
	if(QHraidbarheight == nil) then QHraidbarheight = 12; end
	if(QHraidbarwidth == nil) then QHraidbarwidth = 50; end
	if(QHrfx == nil) then QHrfx = 5; end
	if(QHrfy == nil) then QHrfy = 695; end
	if(QHrfbackdropalpha == nil) then QHrfbackdropalpha = 50; end
end

function QH_ResetConfirm()

	StaticPopupDialogs["QHResetConfirm"] = {
  		text = "Are you sure you want to reset settings?",
  		button1 = "Yes",
  		button2 = "No",
  		OnAccept = QH_ResetSettings,
  		timeout = 0,
  		whileDead = 1,
  		hideOnEscape = 1
	};
	StaticPopup_Show ("QHResetConfirm");

end

function QH_ResetSettings()

	QH_LoadSettings(QHtab);
	QH_UpdateOptions();
	QH_SetupUI();
end

function QH_SaveVar(varname, value)

	if ( PlayerName ) then
		if ( QHProfile[PlayerName] ) then
			QHProfile[PlayerName][varname] = value;
		end
	end
end

---------------------------------------------------------------------------------------------
-- Event Handlers
---------------------------------------------------------------------------------------------
function QH_OnEvent()

        if (event == "VARIABLES_LOADED") then

		-- Initial Setup
		QH_Setup();

	elseif(event == "PLAYER_LOGIN") then

		-- Register Other Events
		getglobal("QHOptionsFrame"):RegisterEvent("PLAYER_LEAVE_COMBAT");
		getglobal("QHOptionsFrame"):RegisterEvent("PLAYER_REGEN_ENABLED");
		getglobal("QHOptionsFrame"):RegisterEvent("RAID_ROSTER_UPDATE");
		getglobal("QHOptionsFrame"):RegisterEvent("UPDATE_MACROS");
	
		-- Setup UI For First Time
		QH_SetupRaidFrame();
		QH_SetupUI();

	elseif(event == "PLAYER_LEAVE_COMBAT" or event == "PLAYER_REGEN_ENABLED" or event == "RAID_ROSTER_UPDATE" or event == "UPDATE_MACROS") then

		-- Update UI
		QH_SetupUI();
	end
end

---------------------------------------------------------------------------------------------
-- Options GUI Functions
---------------------------------------------------------------------------------------------
function QH_ShowOptions()

	if (QHOptionsFrame:IsVisible()) then
		HideUIPanel(QHOptionsFrame);
		HideUIPanel(QHOptionsFrameTabs);
	else
		QH_ChangeTabs();
		ShowUIPanel(QHOptionsFrame);
		ShowUIPanel(QHOptionsFrameTabs);
	end
end

function QH_HideAllOptions()

	HideUIPanel(QHBOXONOFF);
	HideUIPanel(QHBOXBARTEXT);
	HideUIPanel(QHBOXRESURRECTION);
	HideUIPanel(QHBOXTARGETADJUST);
	HideUIPanel(QHBOXRAIDONOFF);
	HideUIPanel(QHBOXPARTYHIDE);
	HideUIPanel(QHBOXRANGECHECK);
	HideUIPanel(QHBOXRFBACKDROP);
	HideUIPanel(QHBOXDEBUFF);
	HideUIPanel(QHBOXHIDENOTINRANGE);
	HideUIPanel(QHRFTransparencySlider);
	HideUIPanel(QHTransparencySlider);
	HideUIPanel(QHRowCountSlider);
	HideUIPanel(QHWidthSlider);
	HideUIPanel(QHHeightSlider);
	HideUIPanel(QHraidsortdropdown);
	HideUIPanel(QHraidsortdropdown);
	
	HideUIPanel(QHleftdropdown);	
	HideUIPanel(QHleftshiftdropdown);
	HideUIPanel(QHleftctrldropdown);
	HideUIPanel(QHleftaltdropdown);

	HideUIPanel(QHmiddledropdown);
	HideUIPanel(QHmiddleshiftdropdown);
	HideUIPanel(QHmiddlectrldropdown);
	HideUIPanel(QHmiddlealtdropdown);

	HideUIPanel(QHrightdropdown);
	HideUIPanel(QHrightshiftdropdown);
	HideUIPanel(QHrightctrldropdown);
	HideUIPanel(QHrightaltdropdown);

	HideUIPanel(QHfourdropdown);
	HideUIPanel(QHfourshiftdropdown);
	HideUIPanel(QHfourctrldropdown);
	HideUIPanel(QHfouraltdropdown);

	HideUIPanel(QHfivedropdown);
	HideUIPanel(QHfiveshiftdropdown);
	HideUIPanel(QHfivectrldropdown);
	HideUIPanel(QHfivealtdropdown);

	QHMOVERAIDLABEL:SetText("");
end

function QH_UpdateOptions()

	QH_HideAllOptions();

	QHOptionsFrame:RegisterForDrag("LeftButton");
	QHOptionsFrame:SetScript("OnDragStart", function() QHOptionsFrame:StartMoving() end);
	QHOptionsFrame:SetScript("OnDragStop", function() QHOptionsFrame:StopMovingOrSizing() end);
			
	if(QHtab == nil or QHtab == "OPTIONS") then

		QHTABLABEL:SetText(QH_LOCALE_OPTIONSTAB);

		ShowUIPanel(QHBOXONOFF);
		ShowUIPanel(QHBOXBARTEXT);
		ShowUIPanel(QHBOXRESURRECTION);
		ShowUIPanel(QHBOXTARGETADJUST);
		ShowUIPanel(QHBOXRANGECHECK);
		ShowUIPanel(QHTransparencySlider);
		ShowUIPanel(QHBOXDEBUFF);
		ShowUIPanel(QHBOXHIDENOTINRANGE);
		
		-- Setup CheckBoxes
		QHBOXONOFF:SetChecked(QHrunning);
		QHBOXBARTEXT:SetChecked(QHdamagebartext);
		QHBOXRESURRECTION:SetChecked(QHresurrection);
		QHBOXTARGETADJUST:SetChecked(QHtfdontadjust);
		QHBOXRANGECHECK:SetChecked(QHrfrange);
		QHBOXDEBUFF:SetChecked(QHshowdebuffs);
		QHBOXHIDENOTINRANGE:SetChecked(QHhidenotinrange);

		-- Setup Transparency Slider
		QHTransparencySlider:SetValue(QHtransparency);

	elseif(QHtab == "PLAYER") then

		QHTABLABEL:SetText(QH_LOCALE_PLAYERTAB);

		ShowUIPanel(QHWidthSlider);
		ShowUIPanel(QHHeightSlider);

		-- Setup Dropdown Menus
		QH_SetupDropdown(QHleftdropdown, QHplayerleft);
		QH_SetupDropdown(QHleftshiftdropdown, QHplayerleftshift);
		QH_SetupDropdown(QHleftctrldropdown, QHplayerleftctrl);
		QH_SetupDropdown(QHleftaltdropdown, QHplayerleftalt);

		QH_SetupDropdown(QHmiddledropdown, QHplayermiddle);
		QH_SetupDropdown(QHmiddleshiftdropdown, QHplayermiddleshift);
		QH_SetupDropdown(QHmiddlectrldropdown, QHplayermiddlectrl);
		QH_SetupDropdown(QHmiddlealtdropdown, QHplayermiddlealt);

		QH_SetupDropdown(QHrightdropdown, QHplayerright);
		QH_SetupDropdown(QHrightshiftdropdown, QHplayerrightshift);
		QH_SetupDropdown(QHrightctrldropdown, QHplayerrightctrl);
		QH_SetupDropdown(QHrightaltdropdown, QHplayerrightalt);

		QH_SetupDropdown(QHfourdropdown, QHplayerfour);
		QH_SetupDropdown(QHfourshiftdropdown, QHplayerfourshift);
		QH_SetupDropdown(QHfourctrldropdown, QHplayerfourctrl);
		QH_SetupDropdown(QHfouraltdropdown, QHplayerfouralt);

		QH_SetupDropdown(QHfivedropdown, QHplayerfive);
		QH_SetupDropdown(QHfiveshiftdropdown, QHplayerfiveshift);
		QH_SetupDropdown(QHfivectrldropdown, QHplayerfivectrl);
		QH_SetupDropdown(QHfivealtdropdown, QHplayerfivealt);

		-- Setup Width/Height Sliders
		QHHeightSlider:SetMinMaxValues(1,40);
		QHWidthSlider:SetMinMaxValues(1,100);
		QHWidthSlider:SetValue(QHplayerbarwidth);
		QHHeightSlider:SetValue(QHplayerbarheight);

	elseif(QHtab == "PARTY") then

		QHTABLABEL:SetText(QH_LOCALE_PARTYTAB);
		
		ShowUIPanel(QHWidthSlider);
		ShowUIPanel(QHHeightSlider);

		-- Setup Dropdown Menus
		QH_SetupDropdown(QHleftdropdown, QHpartyleft);
		QH_SetupDropdown(QHleftshiftdropdown, QHpartyleftshift);
		QH_SetupDropdown(QHleftctrldropdown, QHpartyleftctrl);
		QH_SetupDropdown(QHleftaltdropdown, QHpartyleftalt);

		QH_SetupDropdown(QHmiddledropdown, QHpartymiddle);
		QH_SetupDropdown(QHmiddleshiftdropdown, QHpartymiddleshift);
		QH_SetupDropdown(QHmiddlectrldropdown, QHpartymiddlectrl);
		QH_SetupDropdown(QHmiddlealtdropdown, QHpartymiddlealt);

		QH_SetupDropdown(QHrightdropdown, QHpartyright);
		QH_SetupDropdown(QHrightshiftdropdown, QHpartyrightshift);
		QH_SetupDropdown(QHrightctrldropdown, QHpartyrightctrl);
		QH_SetupDropdown(QHrightaltdropdown, QHpartyrightalt);

		QH_SetupDropdown(QHfourdropdown, QHpartyfour);
		QH_SetupDropdown(QHfourshiftdropdown, QHpartyfourshift);
		QH_SetupDropdown(QHfourctrldropdown, QHpartyfourctrl);
		QH_SetupDropdown(QHfouraltdropdown, QHpartyfouralt);

		QH_SetupDropdown(QHfivedropdown, QHpartyfive);
		QH_SetupDropdown(QHfiveshiftdropdown, QHpartyfiveshift);
		QH_SetupDropdown(QHfivectrldropdown, QHpartyfivectrl);
		QH_SetupDropdown(QHfivealtdropdown, QHpartyfivealt);

		-- Setup Width/Height Sliders
		QHHeightSlider:SetMinMaxValues(1,40);
		QHWidthSlider:SetMinMaxValues(1,100);
		QHWidthSlider:SetValue(QHpartybarwidth);
		QHHeightSlider:SetValue(QHpartybarheight);

	elseif(QHtab == "RAID") then

		QHTABLABEL:SetText(QH_LOCALE_RAIDTAB);
		QHMOVERAIDLABEL:SetText(QH_LOCALE_MOVERAID);

		ShowUIPanel(QHBOXRAIDONOFF);
		ShowUIPanel(QHBOXPARTYHIDE);
		ShowUIPanel(QHBOXRFBACKDROP);
		ShowUIPanel(QHRowCountSlider);
		ShowUIPanel(QHWidthSlider);
		ShowUIPanel(QHHeightSlider);
		ShowUIPanel(QHRFTransparencySlider);

		-- Setup CheckBoxes
		QHBOXRAIDONOFF:SetChecked(QHrfenabled);
		QHBOXPARTYHIDE:SetChecked(QHrfhideparty);
		QHBOXRFBACKDROP:SetChecked(QHshowrfbackdrop);

		-- Setup Dropdown
		QH_SetupDropdown(QHraidsortdropdown, QHrfsortby);

		-- Setup Sliders
		QHRowCountSlider:SetValue(QHrfrows);
		QHWidthSlider:SetValue(QHraidbarwidth);
		QHHeightSlider:SetValue(QHraidbarheight);
		QHRFTransparencySlider:SetValue(QHrfbackdropalpha);
		QHHeightSlider:SetMinMaxValues(12,40);
		QHWidthSlider:SetMinMaxValues(1,50);
	end
end

function QH_SetupDropdown(dropdown, value)

	ShowUIPanel(dropdown);

	if(dropdown == QHraidsortdropdown) then
		UIDropDownMenu_Initialize(dropdown, QH_InitializeRaidDropdown);
		UIDropDownMenu_SetWidth(140, dropdown);
	else
		UIDropDownMenu_Initialize(dropdown, QH_InitializeDropdown);
		UIDropDownMenu_SetWidth(125, dropdown);
	end
	
	UIDropDownMenu_SetText("", dropdown);
	UIDropDownMenu_SetSelectedValue(dropdown, value);

end

function QH_InitializeRaidDropdown()

	info = UIDropDownMenu_CreateInfo();

	info = {};
	info.text = "CLASS";
	info.value = "CLASS";
	info.owner = getglobal(UIDROPDOWNMENU_INIT_MENU);
	info.func = QHDropdown_OnClick;
	UIDropDownMenu_AddButton(info);

	info = {};
	info.text = "GROUP";
	info.value = "GROUP";
	info.owner = getglobal(UIDROPDOWNMENU_INIT_MENU);
	info.func = QHDropdown_OnClick;
	UIDropDownMenu_AddButton(info);

	local dropdownFrame = getglobal(UIDROPDOWNMENU_INIT_MENU);
	dropdownFrame:SetPoint("BOTTOM");
end

function QH_InitializeDropdown()

	info = UIDropDownMenu_CreateInfo();

	local spells = "";

	-- Populate list with available spells in spellbook
	local i=1; while true do

   		local spellname, spellrank = GetSpellName(i, BOOKTYPE_SPELL);

		-- Exit loop if nil
   		if not spellname then
		do break end
   		end

		-- Add Spell to Menu
		if((IsSpellInRange(spellname, "player") or IsSpellInRange(spellname, "party")) and not IsPassiveSpell(i, BOOKTYPE_SPELL) and strfind(spells, ";"..spellname) == nil) then

			spells = spells .. spellname .. ";";
		end
		
   		i=i+1;
	end

	-- Sort Spell List
	slist = {strsplit(";", spells)};
	sort(slist);

	local macros = "";
	local numglobal,numperchar = GetNumMacros();

	-- Populate list with available macros
	for i=1,numglobal do
		
		local name, texture, macrobody, localVar = GetMacroInfo(i);
		if(name) then
			macros = macros .. name .. ";";
		end
	end
	for i=1,numperchar do
		
		local name, texture, macrobody, localVar = GetMacroInfo(18 + i);
		if(name) then
			macros = macros .. name .. ";";
		end
	end
	
	-- Sort Macro List
	mlist = {strsplit(";", macros)};
	sort(mlist);
	

	-- Add Spells to Dropdown
	for i=1,#(slist) do
		
		info = {};	
		info.text = slist[i];--spellname;
		info.value = slist[i];--spellname;
		info.owner = getglobal(UIDROPDOWNMENU_INIT_MENU);
		info.func = QHDropdown_OnClick;
			
		UIDropDownMenu_AddButton(info);
	end

	-- Add Macros to Dropdown
	for i=1,#(mlist) do

		if(mlist[i] ~= "") then

			info = {};	
			info.text = "[MACRO] "..mlist[i];--macroname;
			info.value = "[MACRO] "..mlist[i];--macroname;
			info.owner = getglobal(UIDROPDOWNMENU_INIT_MENU);
			info.func = QHDropdown_OnClick;
			
			UIDropDownMenu_AddButton(info);
		end
	end

	
end

function QH_ChangeTabs(tab)

	if(tab ~= nil) then
		QHtab = tab;
		QH_SaveVar("QHtab", QHtab);
	end
	
	QHRaidTab:SetTextColor(1,1,0,1);
	QHPartyTab:SetTextColor(1,1,0,1);
	QHPlayerTab:SetTextColor(1,1,0,1);
	QHOptionsTab:SetTextColor(1,1,0,1);

	if(QHtab == "OPTIONS") then

		QHOptionsTab:SetTextColor(1,1,1,1);

	elseif(QHtab == "PLAYER") then

		QHPlayerTab:SetTextColor(1,1,1,1);

	elseif(QHtab == "PARTY") then

		QHPartyTab:SetTextColor(1,1,1,1);

	elseif(QHtab == "RAID") then

		QHRaidTab:SetTextColor(1,1,1,1);

	end

	QH_UpdateOptions();
end

function QHDropdown_OnClick()

	-- Set Dropdown Value	
	UIDropDownMenu_SetSelectedValue(this.owner, this.value);

	-- Save Settings
	if(this.owner == QHraidsortdropdown) then

		QHrfsortby = this.value;
		QH_SaveVar("QHrfsortby", this.value);

	else

		local var = gsub(this.owner:GetName(), "(dropdown)", "");
		if(QHtab == "PLAYER") then

			var = gsub(var, "(QH)", "QHplayer");
		elseif(QHtab == "PARTY") then

			var = gsub(var, "(QH)", "QHparty");
		end
		setglobal(var, this.value);
		QH_SaveVar(var, this.value);

	end

	-- Update Unit Buttons
	QH_SetupUI();
end

function QHOptionsCheckButton_OnLoad()

	-- Setup Check Boxes
	if(this == QHBOXONOFF) then
		getglobal(this:GetName().."Text"):SetText(QH_LOCALE_RUNNING);
	elseif(this == QHBOXBARTEXT) then
		getglobal(this:GetName().."Text"):SetText(QH_LOCALE_BARTEXT);
	elseif(this == QHBOXRESURRECTION) then
		getglobal(this:GetName().."Text"):SetText(QH_LOCALE_RESURRECTION);
	elseif(this == QHBOXTARGETADJUST) then
		getglobal(this:GetName().."Text"):SetText(QH_LOCALE_TARGETADJUST);
	elseif(this == QHBOXRAIDONOFF) then
		getglobal(this:GetName().."Text"):SetText(QH_LOCALE_RAIDENABLED);
	elseif(this == QHBOXRANGECHECK) then
		getglobal(this:GetName().."Text"):SetText(QH_LOCALE_RANGECHECK);
	elseif(this == QHBOXPARTYHIDE) then
		getglobal(this:GetName().."Text"):SetText(QH_LOCALE_PARTYHIDE);
	elseif(this == QHBOXRFBACKDROP) then
		getglobal(this:GetName().."Text"):SetText(QH_LOCALE_RFBACKDROP);
	elseif(this == QHBOXDEBUFF) then
		getglobal(this:GetName().."Text"):SetText(QH_LOCALE_SHOWDEBUFFS);
	elseif(this == QHBOXHIDENOTINRANGE) then
		getglobal(this:GetName().."Text"):SetText(QH_LOCALE_HIDENOTINRANGE);
	end

end

function QHOptionsCheckButton_OnClick()

	-- Check which box was clicked
	if(this == QHBOXONOFF) then

		QHrunning = this:GetChecked();
		QH_SaveVar("QHrunning", QHrunning);

	elseif(this == QHBOXBARTEXT) then

		QHdamagebartext = this:GetChecked();
		QH_SaveVar("QHdamagebartext", QHdamagebartext);

	elseif(this == QHBOXRESURRECTION) then

		QHresurrection = this:GetChecked();
		QH_SaveVar("QHresurrection", QHresurrection);

	elseif(this == QHBOXTARGETADJUST) then

		QHtfdontadjust = this:GetChecked();
		QH_SaveVar("QHtfdontadjust", QHtfdontadjust);

	elseif(this == QHBOXRAIDONOFF) then
	
		QHrfenabled = this:GetChecked();
		QH_SaveVar("QHrfenabled", QHrfenabled);

	elseif(this == QHBOXPARTYHIDE) then

		QHrfhideparty = this:GetChecked();
		QH_SaveVar("QHrfhideparty", QHrfhideparty);

	elseif(this == QHBOXRANGECHECK) then

		QHrfrange = this:GetChecked();
		QH_SaveVar("QHrfrange", QHrfrange);

		if(this:GetChecked()) then
			QHBOXHIDENOTINRANGE:Enable();
			getglobal(QHBOXHIDENOTINRANGE:GetName().."Text"):SetTextColor(0.99, 0.82, 0);
		else
			QHBOXHIDENOTINRANGE:Disable();
			
			getglobal(QHBOXHIDENOTINRANGE:GetName().."Text"):SetTextColor(0.5, 0.5, 0.5);
		end

	elseif(this == QHBOXRFBACKDROP) then
		
		QHshowrfbackdrop = this:GetChecked();
		QH_SaveVar("QHshowrfbackdrop", QHshowrfbackdrop);

	elseif(this == QHBOXDEBUFF) then
		
		QHshowdebuffs = this:GetChecked();
		QH_SaveVar("QHshowdebuffs", QHshowdebuffs);

	elseif(this == QHBOXHIDENOTINRANGE) then

		QHhidenotinrange = this:GetChecked();
		QH_SaveVar("QHhidenotinrange", QHhidenotinrange);
		
	end

	-- Update Unit Buttons
	QH_SetupUI();
end

function QHUpdateWidth()

	if(QHtab == "PLAYER") then
		QHplayerbarwidth = QHWidthSlider:GetValue();
		QH_SaveVar("QHplayerbarwidth", QHplayerbarwidth);
	elseif(QHtab == "PARTY") then
		QHpartybarwidth = QHWidthSlider:GetValue();
		QH_SaveVar("QHpartybarwidth", QHpartybarwidth);
	elseif(QHtab == "RAID") then
		QHraidbarwidth = QHWidthSlider:GetValue();
		QH_SaveVar("QHraidbarwidth", QHraidbarwidth);
	end
		
	getglobal(QHWidthSlider:GetName().."Text"):SetText(QH_LOCALE_BARWIDTH.." ["..QHWidthSlider:GetValue().."px]");
	QH_SetupUI();

end

function QHUpdateHeight()

	if(QHtab == "PLAYER") then
		QHplayerbarheight = QHHeightSlider:GetValue();
		QH_SaveVar("QHplayerbarheight", QHplayerbarheight);
	elseif(QHtab == "PARTY") then
		QHpartybarheight = QHHeightSlider:GetValue();
		QH_SaveVar("QHpartybarheight", QHpartybarheight);
	elseif(QHtab == "RAID") then
		QHraidbarheight = QHHeightSlider:GetValue();
		QH_SaveVar("QHraidbarheight", QHraidbarheight);
	end
		
	getglobal(QHHeightSlider:GetName().."Text"):SetText(QH_LOCALE_BARHEIGHT.." ["..QHHeightSlider:GetValue().."px]");
	QH_SetupUI();

end

---------------------------------------------------------------------------------------------
-- Spell Functions
---------------------------------------------------------------------------------------------
function QH_UpdateDebuffList()
	
	-- Magic, Disease, Poison, Curse
	QHdebufflist["Magic"] = nil;
	QHdebufflist["Disease"] = nil;
	QHdebufflist["Poison"] = nil;
	QHdebufflist["Curse"] = nil;
	

	if(QHplayerclass == "DRUID") then

		QHdebufflist["Poison"] = 'true';
		QHdebufflist["Curse"] = 'true';

	elseif(QHplayerclass == "PRIEST") then

		QHdebufflist["Magic"] = 'true';
		QHdebufflist["Disease"] = 'true';

	elseif(QHplayerclass == "MAGE") then

		QHdebufflist["Curse"] = 'true';

	elseif(QHplayerclass == "PALADIN") then

		QHdebufflist["Magic"] = 'true';
		QHdebufflist["Disease"] = 'true';
		QHdebufflist["Poison"] = 'true';

	elseif(QHplayerclass == "SHAMAN") then

		QHdebufflist["Disease"] = 'true';
		QHdebufflist["Poison"] = 'true';

	elseif(QHplayerclass == "WARLOCK") then

		QHdebufflist["Disease"] = 'true';
		QHdebufflist["Poison"] = 'true';

	end
end

function QH_SetAttribute(button, index, action, shiftaction, ctrlaction, altaction, unitressurect)

	local unit = button:GetAttribute("unit");

	local resurrection = QH_LOCALE_PRIESTRES;
	if(QHplayerclass == "DRUID") then
		resurrection = QH_LOCALE_DRUIDRES;
	elseif(QHplayerclass == "PALADIN") then
		resurrection = QH_LOCALE_PALADINRES;
	elseif(QHplayerclass == "SHAMAN") then
		resurrection = QH_LOCALE_SHAMANRES;
	end

	if(action == nil) then action = ""; end
	if(shiftaction == nil) then shiftaction = ""; end
	if(ctrlaction == nil) then ctrlaction = ""; end
	if(altaction == nil) then altaction = ""; end

	local name, texture, macrobody, localVar = GetMacroInfo(GetMacroIndexByName(string.gsub(action, "%[MACRO%] ", "")));
	local shiftname, shifttexture, shiftmacrobody, shiftlocalVar = GetMacroInfo(GetMacroIndexByName(string.gsub(shiftaction, "%[MACRO%] ", "")));
	local ctrlname, ctrltexture, ctrlmacrobody, ctrllocalVar = GetMacroInfo(GetMacroIndexByName(string.gsub(ctrlaction, "%[MACRO%] ", "")));
	local altname, alttexture, altmacrobody, altlocalVar = GetMacroInfo(GetMacroIndexByName(string.gsub(altaction, "%[MACRO%] ", "")));

	--Add Ressurect spell to left click upon death
	if(unitressurect) then

		button:SetAttribute("type"..index, "macro");
		if(string.find(action, "MACRO")) then
			
			button:SetAttribute("macrotext"..index, "/cast [target=" .. unitressurect .. ", dead] " .. resurrection .. ";\n" .. string.gsub(macrobody, "unit", unit));
		else
			button:SetAttribute("macrotext"..index, "/cast [target=" .. unitressurect .. ", dead] " .. resurrection .. "; [target=" .. unitressurect .. "] " .. action .. ";");
		end

	--LeftClick as Normal
	else

		if(string.find(action, "MACRO")) then

			--Substitue "unit" variable in macro
			button:SetAttribute("type"..index, "macro");
			button:SetAttribute("macrotext"..index, string.gsub(macrobody, "unit", unit));
		else
			button:SetAttribute("type"..index, "spell");
			button:SetAttribute("spell"..index, string.gsub(action, "%[MACRO%] ", ""));
		end
	end

	--Shift-Click
	if(string.find(shiftaction, "MACRO")) then

		--Substitue "unit" variable in macro
		button:SetAttribute("shift-type"..index, "macro");
		button:SetAttribute("shift-macrotext"..index, string.gsub(shiftmacrobody, "unit", unit));
			
	else
		button:SetAttribute("shift-type"..index, "spell");
		button:SetAttribute("shift-spell"..index, string.gsub(shiftaction, "%[MACRO%] ", ""));
	end

	--Ctrl-Click
	if(string.find(ctrlaction, "MACRO")) then

		--Substitue "unit" variable in macro
		button:SetAttribute("ctrl-type"..index, "macro");
		button:SetAttribute("ctrl-macrotext"..index, string.gsub(ctrlmacrobody, "unit", unit));
			
	else
		button:SetAttribute("ctrl-type"..index, "spell");
		button:SetAttribute("ctrl-spell"..index, string.gsub(ctrlaction, "%[MACRO%] ", ""));
	end

	--Alt-Click
	if(string.find(altaction, "MACRO")) then

		--Substitue "unit" variable in macro
		button:SetAttribute("alt-type"..index, "macro");
		button:SetAttribute("alt-macrotext"..index, string.gsub(altmacrobody, "unit", unit));
			
	else
		button:SetAttribute("alt-type"..index, "spell");
		button:SetAttribute("alt-spell"..index, string.gsub(altaction, "%[MACRO%] ", ""));
	end
end

function QH_SetupUnitButton(unit)
	
	local button = this;
	if(unit ~= nil) then
		button = getglobal("QHButton" .. unit);
	end
	
	if(QHrunning) then

		button:Enable();
		local id = button:GetID();
		button:RegisterForClicks('LeftButtonUp', 'RightButtonUp', 'MiddleButtonUp', 'Button4Up', 'Button5Up');

		local resurrection = QH_LOCALE_PRIESTRES;
		if(QHplayerclass == "DRUID") then
			resurrection = QH_LOCALE_DRUIDRES;
		elseif(QHplayerclass == "PALADIN") then
			resurrection = QH_LOCALE_PALADINRES;
		elseif(QHplayerclass == "SHAMAN") then
			resurrection = QH_LOCALE_SHAMANRES;
		end

		button:SetAttribute("unit", unit);

		local type = "spell";
		if(unit == "player") then
			
			-- LEFT CLICK
			QH_SetAttribute(button, 1, QHplayerleft, QHplayerleftshift, QHplayerleftctrl, QHplayerleftalt);

			-- RIGHT CLICK
			QH_SetAttribute(button, 2, QHplayerright, QHplayerrightshift, QHplayerrightctrl, QHplayerrightalt);

			-- MIDDLE CLICK
			QH_SetAttribute(button, 3, QHplayermiddle, QHplayermiddleshift, QHplayermiddlectrl, QHplayermiddlealt);

			-- Button4 CLICK
			QH_SetAttribute(button, 4, QHplayerfour, QHplayerfourshift, QHplayerfourctrl, QHplayerfouralt);

			-- Button5 CLICK
			QH_SetAttribute(button, 5, QHplayerfive, QHplayerfiveshift, QHplayerfivectrl, QHplayerfivealt);

		else

			if(QHresurrection) then

				-- LEFT CLICK
				QH_SetAttribute(button, 1, QHpartyleft, QHpartyleftshift, QHpartyleftctrl, QHpartyleftalt, unit);
			else

				-- LEFT CLICK
				QH_SetAttribute(button, 1, QHpartyleft, QHpartyleftshift, QHpartyleftctrl, QHpartyleftalt);
			end

			-- RIGHT CLICK
			QH_SetAttribute(button, 2, QHpartyright, QHpartyrightshift, QHpartyrightctrl, QHpartyrightalt);

			-- MIDDLE CLICK
			QH_SetAttribute(button, 3, QHpartymiddle, QHpartymiddleshift, QHpartymiddlectrl, QHpartymiddlealt);

			-- Button4 CLICK
			QH_SetAttribute(button, 4, QHpartyfour, QHpartyfourshift, QHpartyfourctrl, QHpartyfouralt);

			-- Button5 CLICK
			QH_SetAttribute(button, 5, QHpartyfive, QHpartyfiveshift, QHpartyfivectrl, QHpartyfivealt);
		
		end
	else

		button:Disable();
	end
end

function QH_RaidFrameStartMoving()

	if(IsShiftKeyDown()) then
		QHRaidFrame:SetMovable(true);
		this:GetParent():StartMoving();
	end
end

function QH_RaidFrameStopMoving()

	this:GetParent():StopMovingOrSizing();
	QHRaidFrame:SetMovable(false);
	QHrfx = QHRaidFrame:GetLeft();
	QHrfy = QHRaidFrame:GetTop();
	QH_SaveVar("QHrfx", QHrfx);
	QH_SaveVar("QHrfy", QHrfy);
end

function QH_SetupRaidButtons()	

	--if(UnitAffectingCombat("player")) then

		-- Can't change unit buttons in combat

	if(QHrunning and UnitInRaid("Player")) then

		QHrfunit = {};
		local raidlist = QH_SortRaid(QHrfsortby);

		QHRaidFrame:Show();
		QHRaidFrame:SetPoint("TOPLEFT", nil,"TOPLEFT",QHrfx,QHrfy-768);

		--Setup Raid Frame Background
		if(QHshowrfbackdrop) then
			QHRaidFrame:SetBackdrop({ 
	  			bgFile = "Interface\\ChatFrame\\ChatFrameBackground", 
	 			edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
	  			edgeSize = 16,
	  			tile = true, tileSize = 2,
	  			insets = {left = 4, right = 4, top = 4, bottom = 4}
			});
			QHRaidFrame:SetBackdropColor(HBframered,HBframegreen,HBframeblue,HBframealpha);

			local raidnumber = GetNumRaidMembers();
			QHRaidFrame:SetWidth(ceil(raidnumber / QHrfrows) * (100 + QHraidbarwidth));
			QHRaidFrame:SetHeight(min(raidnumber,QHrfrows) * (QHraidbarheight + 3) + 12);
			QHRaidFrame:SetBackdropColor(0,0,0,1 - (QHrfbackdropalpha / 100));
		else
			QHRaidFrame:SetBackdrop(nil);
		end

		for i=1,50 do

			-- Find which unit in the raid belongs to this button
			local unitclass, unit;
			if(raidlist[i]) then
				unitclass, unit = strsplit(",", raidlist[i]);				
			end

			if(not unit) then unit = "raid"; end

			QHrfunit[unit] = i;

			local y = -((mod(i-1,QHrfrows)+1)*(QHraidbarheight + 3))+8;
			local x = 6 + (floor((i-1) / QHrfrows) * (100 + QHraidbarwidth)) - 25;

			local name = getglobal("QHNameraid"..i);
			local displayname = getglobal("QHDisplayNameraid"..i);
			name:SetHeight(QHraidbarheight);
			name:SetWidth(100);
			name:SetPoint("TOPLEFT",x,y);
			displayname:SetPushedTextOffset(0,0);
			displayname:SetText(UnitName(unit));
			displayname:SetTextColor(QH_GetClassColor(unit));
			displayname:SetHeight(QHraidbarheight);
			displayname:SetWidth(100);
			displayname:SetPoint("TOPLEFT",x,y);
			

			-- Target
			name:EnableMouse(true);
			name:SetAttribute("unit", unit);
			name:RegisterForClicks('LeftButtonUp', 'RightButtonUp', 'MiddleButtonUp', 'Button4Up', 'Button5Up');
			name:SetAttribute("type1", "target");

			-- Drag
			name:RegisterForDrag("LeftButton");
			--name:SetScript("OnDragStart", function() if(IsShiftKeyDown()) then QHRaidFrame:SetMovable(true); this:GetParent():StartMoving(); end end);
			--name:SetScript("OnDragStop", function() this:GetParent():StopMovingOrSizing(); QHRaidFrame:SetMovable(false); end);
			name:SetScript("OnDragStart",QH_RaidFrameStartMoving);
			name:SetScript("OnDragStop",QH_RaidFrameStopMoving);

			-- TODO: Menu... either figure out a way to piggyback party dropdowns or write my own =/
			--name:SetAttribute("type2","menu");
			--name.showmenu = UnitPopup_ShowMenu; --(UIDROPDOWNMENU_OPEN_MENU,"PARTY",unit);

			local bar = getglobal("QHBarraid"..i);
			bar:SetHeight(QHraidbarheight);
			bar:SetWidth(QHraidbarwidth);
			bar:SetPoint("TOPLEFT",x+110,y);
			bar:SetStatusBarColor(0,1,0,1);
			bar:SetMinMaxValues(0, 100);
			bar:SetValue(100);
		
			local button = getglobal("QHButtonraid"..i);
			button:SetHeight(QHraidbarheight);
			button:SetWidth(QHraidbarwidth);
			button:SetPoint("TOPLEFT",x+110,y);
			button:SetAttribute("unit", unit);
			button:RegisterForClicks('LeftButtonUp', 'RightButtonUp', 'MiddleButtonUp', 'Button4Up', 'Button5Up');

			if(QHresurrection) then

				-- LEFT CLICK
				QH_SetAttribute(button, 1, QHpartyleft, QHpartyleftshift, QHpartyleftctrl, QHpartyleftalt, unit);

			else
				-- LEFT CLICK
				QH_SetAttribute(button, 1, QHpartyleft, QHpartyleftshift, QHpartyleftctrl, QHpartyleftalt);

			end
			
			-- RIGHT CLICK
			QH_SetAttribute(button, 2, QHpartyright, QHpartyrightshift, QHpartyrightctrl, QHpartyrightalt);

			-- MIDDLE CLICK
			QH_SetAttribute(button, 3, QHpartymiddle, QHpartymiddleshift, QHpartymiddlectrl, QHpartymiddlealt);

			-- Button4 CLICK
			QH_SetAttribute(button, 4, QHpartyfour, QHpartyfourshift, QHpartyfourctrl, QHpartyfouralt);

			-- Button5 CLICK
			QH_SetAttribute(button, 5, QHpartyfive, QHpartyfiveshift, QHpartyfivectrl, QHpartyfivealt);
		
			-- Update Status Bar
			QH_UpdateStatusBars(unit);
		end

	else

		QHRaidFrame:Hide();
	end
end

---------------------------------------------------------------------------------------------
-- UI Functions
---------------------------------------------------------------------------------------------
function QH_UpdateStatusBars(unit)
	
	local bar, button, label, name, displayname, raid, party, inrange;

	if(unit) then

		if(string.find(unit, "raid")) then
			
			raid = 'true';
			if(QHrfunit[unit]) then

				bar = getglobal("QHBarraid"..QHrfunit[unit]);
				name = getglobal("QHNameraid"..QHrfunit[unit]);
				displayname = getglobal("QHDisplayNameraid"..QHrfunit[unit]);
				button = getglobal("QHButtonraid"..QHrfunit[unit]);
				label = getglobal("QHBarraid"..QHrfunit[unit].."text");
			end
		else

			bar = getglobal("QHBar"..unit);
			button = getglobal("QHButton"..unit);
			label = getglobal("QHBar"..unit.."text");
		end
	end

	if(bar) then

		-- Set Status Bar Dimensions
		if(unit == "player") then

			bar:SetHeight(QHplayerbarheight);
			bar:SetWidth(QHplayerbarwidth);
			button:SetHeight(QHplayerbarheight);
			button:SetWidth(QHplayerbarwidth);

		elseif(string.find(unit, "party")) then
			
			party = 'true';
			bar:SetHeight(QHpartybarheight);
			bar:SetWidth(QHpartybarwidth);
			button:SetHeight(QHpartybarheight);
			button:SetWidth(QHpartybarwidth);
		end

		if(not QHrfrange or QH_UnitInRange(unit) or CheckInteractDistance(unit, 4)) then inrange = 'true'; end	

		if(QHrunning and UnitExists(unit) and (unit == "player" or party or raid)) then

			bar:Show();
			button:Show();
			
			if(name) then

				name:Show();
				--name:SetText(UnitName(unit));
				--name:SetTextColor(QH_GetClassColor(unit));
				displayname:Show();
				displayname:SetText(UnitName(unit));
				displayname:SetTextColor(QH_GetClassColor(unit));
			end

			local health = UnitHealth(unit);
			local healthmax = UnitHealthMax(unit);
			local healthdefecit = healthmax - health;
	
			bar:SetMinMaxValues(0, healthmax);

			if(QHdamagebartext) then

				local text = button:CreateFontString("QHButton"..unit.."text");
				text:SetAllPoints(button);
				text:SetJustifyH('LEFT');
				text:SetFontObject('GameFontNormal');
				button:SetFontString(text);
				button:SetTextColor(1, 1, 1, QHtransparency / -100 + 1);
				button:SetHighlightTextColor(1, 1, 1, QHtransparency / -100 + 1);

				if(healthdefecit > 0) then
					button:SetText("-" .. healthdefecit);
				else
					button:SetText("");
				end
			else
				button:SetText("");
			end
			
			if(UnitIsDeadOrGhost(unit)) then

				bar:SetValue(healthmax);
				bar:SetStatusBarColor(1, 0, 0, QHtransparency / -100 + 1);
					
			elseif(not UnitIsConnected(unit)) then

				bar:SetValue(0);
				bar:SetStatusBarColor(0, 0, 0, QHtransparency / -100 + 1);
					
			elseif(health and healthmax) then

				bar:SetValue(healthmax - health);

				if(QH_UnitHasCureableDebuff(unit)) then

					bar:SetStatusBarColor(0.63, 0.13, 0.94, QHtransparency / -100 + 1);

				elseif((health / healthmax) < 0.66) then

					bar:SetStatusBarColor(1, 1, 0, QHtransparency / -100 + 1);
				else

					bar:SetStatusBarColor(0, 1, 0, QHtransparency / -100 + 1);
				end

			end
			
			if(not inrange) then

				if(QHhidenotinrange) then
					bar:SetAlpha(0.25);
					button:SetTextColor(1, 1, 1, 0.25);
					button:SetHighlightTextColor(1, 1, 1, 0.25);
				else
					bar:Hide();
					button:SetText("");
				end
			else

				bar:SetAlpha(QHtransparency / -100 + 1);
				button:SetTextColor(1, 1, 1, QHtransparency / -100 + 1);
				button:SetHighlightTextColor(1, 1, 1, QHtransparency / -100 + 1);
			end

		else

			bar:Hide();
			button:Hide();
			if(name) then name:Hide(); end
			if(displayname) then displayname:Hide(); end
		end
	end
end

---------------------------------------------------------------------------------------------
-- Utility Functions
---------------------------------------------------------------------------------------------
function QH_Print(msg, red, green, blue)
	DEFAULT_CHAT_FRAME:AddMessage(msg, red, green, blue);
end

function QH_Trim(s)
	return (string.gsub(s, "^%s*(.-)%s*$", "%1"));
end

function QH_UnitInRange(unit)

	local spell = "";
	if(QHplayerclass == "PALADIN") then
		spell = QH_LOCALE_PALADINHEAL;
	elseif(QHplayerclass == "PRIEST") then
		spell = QH_LOCALE_PRIESTHEAL;
	elseif(QHplayerclass == "DRUID") then
		spell = QH_LOCALE_DRUIDHEAL;
	elseif(QHplayerclass == "SHAMAN") then
		spell = QH_LOCALE_SHAMANHEAL;
	end

	if(IsSpellInRange(spell,unit) == 1) then

		return true;
	end
end

function QH_UnitHasCureableDebuff(unit)

	for i=1,40 do

		local name = UnitDebuff(unit,i,1);
		if(name) then
			return true;
		end	
	end

end

function QH_GetClassColor(unit)

	local locclass, engclass = UnitClass(unit);
	if(engclass == 'DRUID') then return 1.0 ,0.49,0.04;
	elseif(engclass == 'HUNTER') then return 0.67,0.83,0.45;
	elseif(engclass == 'MAGE') then return 0.41,0.8,0.94;
	elseif(engclass == 'PALADIN') then return 0.96,0.55,0.73;
	elseif(engclass == 'PRIEST') then return 1.0 , 1.0 , 1.0;
	elseif(engclass == 'ROGUE') then return 1.0 , 0.96, 0.41;
	elseif(engclass == 'SHAMAN') then return 0.14, 0.35, 1.0;
	elseif(engclass == 'WARLOCK') then return 0.58, 0.51, 0.79;
	elseif(engclass == 'WARRIOR') then return 0.78, 0.61, 0.43;
	else return 0.5,0.5,0.5; end
end


function QH_SortRaid(method)

	local list = {};
	for i=1,40 do
		
		if(UnitClass("raid"..i)) then
			local locclass, engclass = UnitClass("raid"..i);
			list[i] = engclass..",raid"..i..","..UnitName("raid"..i);
		end
	end

	if(method == "CLASS") then
		
		table.sort(list, QH_ClassCompare);
	elseif(method == "GROUP") then
		
		local lastgroup = 1;
		table.sort(list, QH_GroupCompare);
		for n=1,50 do

			if(list[n]) then

				local class, unit = strsplit(",", list[n]);
				local index = string.gsub(unit, "raid", "");
				local name, rank, subgroup, level, class, fileName, zone, online, isDead, role, isML = GetRaidRosterInfo(tonumber(index));
				
				if(subgroup and subgroup ~= lastgroup) then
					
					table.insert(list, n, "Group "..subgroup);
					lastgroup = subgroup;
				end
			end
		end
	end

	return list;
end

function QH_ClassCompare(a,b)

	local classA, classB;
	if(a) then classA = strsplit(",", a); end
	if(b) then classB = strsplit(",", b); end

	if(not classA) then return false; end
	if(not classB) then return true; end
	
	local classes = "WARRIOR,ROGUE,MAGE,WARLOCK,HUNTER,PRIEST,PALADIN,SHAMAN,DRUID";

	local ia, ib;
	ia = string.find(classes, classA);
	ib = string.find(classes, classB);

	if(not ib) then
		return true;
	elseif(not ia) then
		return false;
	elseif(ia < ib) then
		return true;
	else
		return false;
	end
end

function QH_GroupCompare(a, b)
	
	local classA, unita = strsplit(",", a);
	local classB, unitb = strsplit(",", b);
	local indexa = string.gsub(unita, "raid", "");
	local indexb = string.gsub(unitb, "raid", "");
	local namea, ranka, subgroupa, levela, classa, fileNamea, zonea, onlinea, isDeada, rolea, isMLa = GetRaidRosterInfo(tonumber(indexa));
	local nameb, rankb, subgroupb, levelb, classb, fileNameb, zoneb, onlineb, isDeadb, roleb, isMLb = GetRaidRosterInfo(tonumber(indexb));

	return subgroupa < subgroupb;
end

---------------------------------------------------------------------------------------------
-- Slash Command Functions
---------------------------------------------------------------------------------------------
function QH_Report()
	if(QHrunning) then
		QH_Print("QuickHeal is |cFF00FF00ON".."|cFFFFFFFF ["..QH_LOCALE_HELP.."]");
	else
		QH_Print("QuickHeal is |cFFFF0000OFF".."|cFFFFFFFF ["..QH_LOCALE_HELP.."]");
	end
end

function QH_Help()

	QH_Print("|cFFFFFF00"..QH_LOCALE_HELP);
end

function QH_ToggleRun()

	if(QHrunning) then
		QHrunning = nil;
		QH_Print("QuickHeal is now |cFFFF0000OFF".."|cFFFFFFFF ["..QH_LOCALE_HELP.."]");
	else
		QHrunning = 'true';
		QH_Print("QuickHeal is now |cFF00FF00ON".."|cFFFFFFFF ["..QH_LOCALE_HELP.."]");
	end
end