local version='1.0';
local QWU = 0;
local QuestJunkie_Quest = {};
local LogNum = 0
local PartyHas = {};
local QuestTitle = {};
local QuestHeaderInfo = {};
local QuestInfo = {};
local QuestObjectives = {};
local HCount = 0;
local QCount = 0;
local QLCount = 0;
local QList = {};
local QSelect = '';
local QPSelect = '';

QJ_QUESTS_DISPLAYED = 6;
QJ_MAX_OBJECTIVES = 10;
QJ_LOGHEIGHT = 16;

QUESTJUNKIE_TITLE = 'QuestJunkie';
QUESTJUNKIE_DESC = 'These options control the output of QuestJunkie.';
QUESTJUNKIE_ENABLE = 'Enable chat output';
QUESTJUNKIE_ENABLE_TITLE = 'Enable |cFFFFFFFF<|cFF00FFFF' .. QUESTJUNKIE_TITLE .. '|cFFFFFFFF>|r display on chat output';
QUESTJUNKIE_ENABLE_PARTY_CHAT = 'Party';
QUESTJUNKIE_ENABLE_SAY_CHAT = 'Say';
QUESTJUNKIE_ENABLE_CHANNEL = 'Please select an output channel:';
QUESTJUNKIE_LOADMESSAGE = '|cFFFFFFFF<|cFF00FFFF%s|cFFFFFFFF>|r Version %s loaded.';
QUESTJUNKIE_OUTPUT_COMPLETE = '%s%s is complete';
QUESTJUNKIE_OUTPUT_FAILED = '%s%s has failed';

QJ_settings = {};
QJ_settings["enable_output"] = 1;
QJ_settings["enable_output_title"] = 1;
QJ_settings["enable_output_type"] = PARTY;

local function debug(msg)
	DEFAULT_CHAT_FRAME:AddMessage('QB_DEBUG: ' .. msg,1,1,0)
end

local function RGBHEX(r, g, b)
	r = r <= 1 and r >= 0 and r or 0
	g = g <= 1 and g >= 0 and g or 0
	b = b <= 1 and b >= 0 and b or 0
	return string.format("%02x%02x%02x", r*255, g*255, b*255)
end

local function GetPartyNum()
    local CurrPartyNum = 0;
    for i = 1, MAX_PARTY_MEMBERS do
        if(GetPartyMember(i)) then
            CurrPartyNum = CurrPartyNum + 1;
        end
    end
    return CurrPartyNum;
end

function QB_PartyMenu_OnLoad()
	level = 1
	local info = UIDropDownMenu_CreateInfo();	
	for i = 1, GetPartyNum() do
		if (PartyHas[UnitName('party' .. i)] == 1) then
			info.text = UnitName('party' .. i);
			info.value = UnitName('party' .. i);
			info.func = QB_PartyMenu_OnClick;
			info.owner = this:GetParent();
			info.checked = nil;
			info.icon = nil;
			UIDropDownMenu_AddButton(info, level);
		end
	end
end

function QB_PartyMenu_OnClick()
	UIDropDownMenu_SetSelectedValue(this.owner, this.value);
	QuestTitle = {};
	QPSelect = this.value;
	SendAddonMessage("<QuestBarker Request>", UnitName('player'), "WHISPER", this.value);
end

function OnClickQJTab(arg)
	if (arg == 'QuestLogFrameTab2') then
		HideUIPanel(QuestLogFrame);
		ShowUIPanel(QuestBarkerFrame);
		if (QSelect ~= '') then
        	QuestTitle = {};
			SendAddonMessage("<QuestBarker Request>", UnitName('player'), "WHISPER", QPSelect);
			ClearInfo()
		end
	end
	
	if (arg == 'QuestBarkerFrameTab1') then
		HideUIPanel(QuestBarkerFrame);
		ShowUIPanel(QuestLogFrame);
	end
		
end

function QuestBarker_GetCmd(msg)
 	if msg then
 		local a,b,c=strfind(msg, "(%S+)");
 		if a then
 			return c, strsub(msg, b+2);
 		else	
 			return "";
 		end
 	end
end

function QB_OnEvent (event, ...)
	if (event == "QUEST_WATCH_UPDATE" and QJ_settings["enable_output"] == 1) then
    	if (QWU == 0) then QWU = 1; LogNum = arg1; end
    end
    
    if (event == "QUEST_LOG_UPDATE" and QJ_settings["enable_output"] == 1) then
    	if(QWU == 0) then
    		QB_PrepLog(1);
    	elseif (QWU == 1) then
    		local numEntries, numQuests = GetNumQuestLogEntries()
            local questTitle, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(LogNum);
            if (not isComplete) then
                local LB = GetNumQuestLeaderBoards(LogNum);
                for countLB = 1,LB do
                    if (QuestJunkie_Quest[questTitle][countLB] ~= GetQuestLogLeaderBoard(countLB,LogNum)) then
                        QuestJunkie_Quest[questTitle][countLB] = GetQuestLogLeaderBoard(countLB,LogNum);
                        local n = GetNumPartyMembers();
                        local msg = string.format('%s%s',QUESTJUNKIE_OUTPUTMESSAGE,GetQuestLogLeaderBoard(countLB, LogNum));
                        if(QJ_settings["enable_output_type"] == SAY) then
                        	SendChatMessage(msg, QJ_settings["enable_output_type"]);
                        end
    
                        if (GetNumPartyMembers() > 0 and QJ_settings["enable_output_type"] == PARTY) then
                        	SendChatMessage(msg, QJ_settings["enable_output_type"]);
                        end
                    end
                end
            end
            if(isComplete == 1) then
                local n = GetNumPartyMembers();
                local msg = string.format(QUESTJUNKIE_OUTPUT_COMPLETE,QUESTJUNKIE_OUTPUTMESSAGE,questTitle);
                if(QJ_settings["enable_output_type"] == SAY) then
                	SendChatMessage(msg, QJ_settings["enable_output_type"]);
                end
                if (GetNumPartyMembers() > 0 and QJ_settings["enable_output_type"] == PARTY) then
                    SendChatMessage(msg, QJ_settings["enable_output_type"]);
                end
            end
            if(isComplete == -1) then
                local n = GetNumPartyMembers();
                local msg = string.format(QUESTJUNKIE_OUTPUT_FAILED,QUESTJUNKIE_OUTPUTMESSAGE,questTitle);
                if(QJ_settings["enable_output_type"] == SAY) then
                	SendChatMessage(msg, QJ_settings["enable_output_type"]);
                end
                if (GetNumPartyMembers() > 0 and QJ_settings["enable_output_type"] == PARTY) then
                    SendChatMessage(msg, QJ_settings["enable_output_type"]);
                end
            end
        end
        QWU = 0;	
    end
    
    if (event == "CHAT_MSG_ADDON") then
    	if(arg1 == '<QuestBarker check>') then
    		SendAddonMessage('<QuestBarker check request>',UnitName('player'),'WHISPER',arg2);
    	end
    	
        if (arg1 == '<QuestBarker check request>') then
            for i = 1, GetPartyNum() do
            	if(arg2 == UnitName('party' .. i)) then
            		PartyHas[UnitName('party' .. i)] = 1;
            	end
            end
            UIDropDownMenu_Initialize(QB_PartyMenu, QB_PartyMenu_OnLoad);
        end
        
        if (arg1 == '<QuestBarker Request>') then
        	QB_SendQuestList(arg2)
        end
        
        if (arg1 == '<QuestBarker Clear>') then
        	QuestTitle = {};
			QuestHeaderInfo = {};
			QuestInfo = {};
			QuestObjectives = {};
			HCount = 0;
			QCount = 0;
			QOCount = 0;
        end
        
        if (arg1 == '<QuestBarker Header>') then
        	HCount = HCount + 1;
        	QuestHeaderInfo[HCount] = arg2;
        	QuestTitle[arg2] = {};
        end
        
        if (arg1 == '<QuestBarker Titles>') then
        	QCount = QCount + 1;
        	header,title,level,levelc,tag,suggestedGroup = strsplit('^',arg2);
        	QuestTitle[header][QCount] = levelc .. '^' .. level .. '^' .. title .. '^' .. tag .. '^' .. suggestedGroup;
        	QuestObjectives[title] = {};
        end
        
        if (arg1 == '<QuestBarker Info>') then
        	title,info = strsplit('^', arg2);
        	QuestInfo[title] = info;
        end
        
        if (arg1 == '<QuestBarker Obj>') then
        	title,obj,objn = strsplit('^', arg2);
        	QuestObjectives[title][objn] = obj;
        end
        
        if (arg1 == '<QuestBarker List Complete>') then
        	QLCount = 0;
        	foreach(QuestHeaderInfo, DisplayQuest, arg4)
        	QJ_UpdateList()
        end
        
    end
    if (event == "PARTY_MEMBERS_CHANGED") then
    	UIDropDownMenu_ClearAll(QB_PartyMenu);
		SendAddonMessage("<QuestBarker check>", UnitName('player'), "PARTY");
    end
    if (event == "ADDON_LOADED") then
        if(arg1 == 'QuestJunkie') then
        	QB_PartyMenu = CreateFrame("Frame", "QB_PartyMenu", QuestBarkerFrame, "UIDropDownMenuTemplate"); 
    		QB_PartyMenu:SetPoint("TOPLEFT",QuestBarkerFrame,"TOPLEFT",55,-40);
            if (GetNumPartyMembers() > 0) then
                SendAddonMessage("<QuestBarker check>", UnitName('player'), "PARTY");
            end
        	if (QJ_settings["enable_output_title"] == 0) then
            	QUESTJUNKIE_CHATMESSAGE = '';
           	 	QUESTJUNKIE_OUTPUTMESSAGE = '';
       		else
            	QUESTJUNKIE_CHATMESSAGE = '|cFFFFFFFF<|cFF00FFFF' .. QUESTJUNKIE_TITLE .. '|cFFFFFFFF>|r ';
            	QUESTJUNKIE_OUTPUTMESSAGE = '<' .. QUESTJUNKIE_TITLE .. '> ';
        	end
        end
    end
end

function DisplayQuest(HC,Header,name)
	QSelect = '';
	QLCount = QLCount + 1;
	QList[QLCount] = {};
	for i = 1, GetNumPartyMembers() do
		if(UnitName('party' .. i) == name) then
			pnumber = i;
		end
	end
	QList[QLCount]['Display'] = '|cFFA0A0A0' .. Header .. '|r';
	QList[QLCount]['Actual'] = Header;
	QList[QLCount]['Type'] = 'header';
	foreach(QuestTitle[Header], 
		function(QC, QInfo)
			local levelc,level,title,tag,suggestedGroup = strsplit('^', QInfo);
			QLCount = QLCount + 1;
			QList[QLCount] = {}
			QList[QLCount]['Display'] = '     |cFF808080[|cFF' .. levelc ..  level .. '|r|cFF808080] |cFF' .. levelc .. title .. '|r'
			QList[QLCount]['Actual'] = title;
			QList[QLCount]['Type'] = 'quest';			
		end
	)
end

function QJ_UpdateList()
	local scrollBar = QBQuestLogListScrollFrame
	FauxScrollFrame_Update(scrollBar, QLCount, QJ_QUESTS_DISPLAYED, QJ_LOGHEIGHT);
	local offset=FauxScrollFrame_GetOffset(scrollBar)
	for line=1, QJ_QUESTS_DISPLAYED do
		local lineplusoffset = line + offset;
		local lineButton=getglobal("QBQuestLogTitle"..line)
		local lineData=QList[lineplusoffset]
		lineButton:SetText(lineData.Display);
		lineButton:Show();
	end
end

function QJInfo_Click(arg)
	for a=1, 10 do
		local QOBJ = getglobal("QJQuestObj"..a);
		QOBJ:Hide();
	end
	QJQuestTitle:SetText('')
	QJQuestInfo:SetText('')
	local lineButton=getglobal("QBQuestLogTitle"..arg)
	local title = lineButton:GetText();
	local lineData
	for t=1, QLCount do
		if (QList[t]['Display'] == title) then
			lineData = QList[t]
		end
	end
	if (lineData.Type ~= 'header') then
		QJQuestTitle:SetText(lineData.Actual)
		QJQuestInfo:SetText(QuestInfo[lineData.Actual])
		local ObjCount = 0;
		foreach(QuestObjectives[lineData.Actual],
			function (OC, Objective)
				if (Objective ~= "No Obj") then
					ObjCount = ObjCount + 1;
					local QOBJ = getglobal("QJQuestObj"..ObjCount);
					QOBJ:SetText(Objective)
					QOBJ:Show();
				end
			end
		)
		QSelect = lineData.Display
		QJ_UpdateList()
	end
end

function ClearInfo()
	QJQuestTitle:SetText('');
	QJQuestInfo:SetText('');
	for a=1, 10 do
		local QOBJ = getglobal("QJQuestObj"..a);
		QOBJ:Hide();
	end
end

function QB_SendQuestList(request)
	ExpandQuestHeader(0);
	SendAddonMessage('<QuestBarker Clear>','',"WHISPER",request);
	local numEntries, numQuests = GetNumQuestLogEntries()
	for count = 1,numEntries do 
		SelectQuestLogEntry(count);
       	local questTitle, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(count);
       	if (isHeader) then
       		currentHeader = questTitle;
       		SendAddonMessage('<QuestBarker Header>',currentHeader,'WHISPER',request);
       	else
       		if (not questTag) then
       			questTag = 'Solo';
       		end
       		c = GetDifficultyColor(level);
       		tc = RGBHEX(c.r, c.g, c.b);
       		msg = currentHeader .. '^' .. questTitle .. '^' .. level .. '^' .. tc ..  '^' .. questTag .. '^' .. suggestedGroup;
       		SendAddonMessage('<QuestBarker Titles>',msg,'WHISPER',request);
       		local questDescription, questObjectives = GetQuestLogQuestText(count);
       		msg = questTitle .. '^' .. questObjectives;
       		if (strlen(msg) > 235) then
       			msg = strsub(msg,1,235);
       		end
       		SendAddonMessage('<QuestBarker Info>',msg,'WHISPER',request);
       		local LB = GetNumQuestLeaderBoards(count);
            if (LB ~= 0) then
            	for countLB = 1,LB do
                	obj, junk, junk = GetQuestLogLeaderBoard(countLB,count);
                	SendAddonMessage('<QuestBarker Obj>',questTitle .. '^' .. obj .. '^' .. countLB,"WHISPER",request);
                end
            else
            	SendAddonMessage('<QuestBarker Obj>',questTitle .. '^No Obj^1',"WHISPER",request);
            end
            
       	end
    end   
    SendAddonMessage('<QuestBarker List Complete>','','WHISPER',request);
end

function QB_OnLoad()
    this:RegisterEvent("QUEST_LOG_UPDATE");
	this:RegisterEvent("QUEST_WATCH_UPDATE");
    this:RegisterEvent("CHAT_MSG_ADDON");
    this:RegisterEvent("PARTY_MEMBERS_CHANGED");
    this:RegisterEvent("ADDON_LOADED");    
    DEFAULT_CHAT_FRAME:AddMessage(string.format(QUESTJUNKIE_LOADMESSAGE,QUESTJUNKIE_TITLE,version),.5,.5,.5);
    QuestBarkerFrame:SetAttribute("UIPanelLayout-defined", true)
    QuestBarkerFrame:SetAttribute("UIPanelLayout-enabled", true)
    QuestBarkerFrame:SetAttribute("UIPanelLayout-area", "left")
    QuestBarkerFrame:SetAttribute("UIPanelLayout-pushable", 5)
    QuestBarkerFrame:SetAttribute("UIPanelLayout-whileDead", true)
    QuestBarkerTitleText:SetText(QUESTJUNKIE_TITLE .. ' ' .. version);
end

function QBLog_Update()
	FauxScrollFrame_Update(QBQuestLogListScrollFrame, numEntries, QUESTS_DISPLAYED, QUESTLOG_QUEST_HEIGHT, nil, nil, nil, QuestLogHighlightFrame, 293, 316 )
end

function QB_PrepLog(arg)
	if (arg == 1) then
		QuestJunkie_Quest = {};
        local numEntries, numQuests = GetNumQuestLogEntries()
        for count = 1,numEntries do 
            local questTitle, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(count);
            if (not isHeader) then
                QuestJunkie_Quest[questTitle] = {};
                local LB = GetNumQuestLeaderBoards(count);
                if (LB ~= 0) then
                    for countLB = 1,LB do
                        QuestJunkie_Quest[questTitle][countLB], junk, junk = GetQuestLogLeaderBoard(countLB,count);
                    end
                end
            end
        end
	else
		QuestJunkie_Quest = {};
	end
end

-- QuestBarker Options Panel --

function QBPanel_OnLoad(panel)
    panel.name = QUESTJUNKIE_TITLE;
    InterfaceOptions_AddCategory(panel);
end

function QBPanel_OnShow()
    getglobal("QuestBarkerOptionsEnableCheck"):SetChecked( QJ_settings["enable_output"] );
    getglobal("QuestBarkerOptionsEnableTitleCheck"):SetChecked ( QJ_settings["enable_output_title"] );
    if (QJ_settings["enable_output_type"] == PARTY) then
    	getglobal("QuestBarkerOptionsEnablePartyCheck"):SetChecked (1);
    	getglobal("QuestBarkerOptionsEnableSayCheck"):SetChecked(0);
    else
    	getglobal("QuestBarkerOptionsEnablePartyCheck"):SetChecked (0);
    	getglobal("QuestBarkerOptionsEnableSayCheck"):SetChecked(1);
    end
    
    if QJ_settings["enable_output"] == 0 then
        getglobal("QuestBarkerOptionsEnableTitleCheck"):Disable();
        getglobal("QuestBarkerOptionsEnablePartyCheck"):Disable();
    else
        getglobal("QuestBarkerOptionsEnableTitleCheck"):Enable();
        getglobal("QuestBarkerOptionsEnablePartyCheck"):Enable();
    end
end

function QB_Options(arg)
    if (arg == 'Enable') then
        if (QJ_settings["enable_output"] == 1) then
            QJ_settings["enable_output"] = 0;
            QB_PrepLog(0);
        else
            QJ_settings["enable_output"] = 1;
            if(QJ_settings["enable_output_type"] == 1) then
            	QB_PrepLog(1);
            end
        end
    end
    if (arg == 'Enable Title') then
        if (QJ_settings["enable_output_title"] == 1) then
            QJ_settings["enable_output_title"] = 0;
            QUESTJUNKIE_CHATMESSAGE = '';
            QUESTJUNKIE_OUTPUTMESSAGE = '';
        else
            QJ_settings["enable_output_title"] = 1;
            QUESTJUNKIE_CHATMESSAGE = '|cFFFFFFFF<|cFF00FFFF' .. QUESTJUNKIE_TITLE .. '|cFFFFFFFF>|r ';
            QUESTJUNKIE_OUTPUTMESSAGE = '<' .. QUESTJUNKIE_TITLE .. '> ';
        end
    end
    if (arg == 'Enable Party') then
        if(QJ_settings["enable_output_type"] == SAY) then
        	QJ_settings["enable_output_type"] = PARTY;
        	getglobal("QuestBarkerOptionsEnableSayCheck"):SetChecked(0);
        else
        	getglobal("QuestBarkerOptionsEnablePartyCheck"):SetChecked(1);
        end
    end
    if(arg == 'Enable Say') then
    	if(QJ_settings["enable_output_type"] == PARTY) then
    		QJ_settings["enable_output_type"] = SAY ;
    		getglobal("QuestBarkerOptionsEnablePartyCheck"):SetChecked(0);
    	else
    		getglobal("QuestBarkerOptionsEnableSayCheck"):SetChecked(1);
    	end
    end
end