---------------------------------------------------------------------------
-- Common controls like dropdown
-- Derived from addon, Lfgx

-- Samples:
-- Must set selection to dropdowns when load addon, otherwise UIDropDownMenu_GetSelectedID() returns nil values and crashes
-- QuestHistorySortDropDownEntry_SetNumber(1, "QuestHistorySortDropDown1")

-- Searching for current selection of a specific dropdown,
-- QuestHistorySortDropDownEntry_GetName(nil, "QuestHistorySortDropDown1")

-- Searching for specific selection from any similar dropdown, since not affect the actual dropdown
-- QuestHistorySortDropDownEntry_GetName(1, "QuestHistorySortDropDown1")

-- WARNING,
-- Dropdowns have to be able to handle:
-- - initializing dynamically to fill dropdown when selected
-- - select button in dropdown
-- - set button programmatically
-- - get current button selected programmatically
-- - get specific button selected programmatically without affecting current button
-- - safer to use only as a template, and leave original data and calculations in arrays and main program

-- WARNING,
-- if dropdowns give problems, most likely it is problems getting UIDropDownMenu_GetSelectedID()
-- sometimes frame name is wrong, or a choice from dropdown was nil and not selected yet.
-- Especially annoying when errors are reported in the external secured blizzard functions.
-- Enable the following to get an idea which procedure may have crashed, but still not easy.
--local QuestHistoryShowProcedureName = 1

---------------------------------------------------------------------------
-- Any Dropdown stuff
-- (generic to work on any single dropdown)

function QuestHistorySingleDropDownX_InitializeCommon(singledropdownname, buttonclick, dropdownlist, dropdowntooltiptitle, dropdowntooltip)
	local cProcedureName = "QuestHistorySingleDropDownX_InitializeCommon()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..singledropdownname); end

	-- Build dropdown
	-- WARNING, runs every time you click on popup
	-- uses default FrameXML/UIDropDownMenu.lua, but not much control nor accuracy
	local backupID = UIDropDownMenu_GetSelectedID(getglobal(singledropdownname))
	local backuptext = UIDropDownMenu_GetText(getglobal(singledropdownname))
	local info = {}

	for i = 1, getn(dropdownlist), 1 do
		info = { }
		info.text = dropdownlist[i].name
		if not info.text or strlen(info.text) == 0 then info.text = QuestHistory_SPACE1; end -- at least one space
		info.value = dropdownlist[i].buttonvalue

		info.func = getglobal(buttonclick)
		info.owner = UIDROPDOWNMENU_OPEN_MENU
		info.tooltipTitle = dropdowntooltiptitle
		info.tooltipText = dropdowntooltip
		-- can tooltip location be moved to mouse pointer? currently in bottom right ...
		-- (see list of options in UIDropDownMenu.lua)

		-- Removed/ignored
		local isHide = nil
		if dropdownlist[i].isHide then
			isHide = 1
		end

		-- Shown but white and not clickable
		-- (not yet implemented, so leave disabled)
		local isHeader = nil
		if dropdownlist[i].isHeader then
			info.disabled = 1
			isHeader = 1
		end

		-- Shown but gray, disabled, and not clickable
		local isDisable = nil
		if dropdownlist[i].isDisable then
			info.disabled = 1
			--isDisable = 1 -- not needed
		end

		if dropdownlist[i].notCheckable then
			info.notCheckable = 1
			info.checked = nil
			-- does not work very well though, still shows check in background
			-- so use the following when the button is blocked later to disable internal values
			--UIDropDownMenu_SetSelectedID(dropdownname, nil, nil)
		end		

		-- Size of text in dropdowns
		-- Also fixes bug so that colors and other attributes previously set are not ignored
		local _, currentTextHeight = GameFontHighlight:GetFont()
		currentTextHeight = math.floor(currentTextHeight+0.5) -- round off to nearest integer
		info.textHeight = currentTextHeight
		--local _, currentTextHeight = GameFontHighlight:GetFont() - white font
		--local _, currentTextHeight = GameFontHighlightSmall:GetFont()
		--local _, currentTextHeight = GameFontNormal:GetFont() -- yellow font
		--local _, currentTextHeight = GameFontNormalSmall:GetFont()

		if isHide then
		else
			UIDropDownMenu_AddButton(info)
		end
	end
	UIDropDownMenu_SetSelectedID(getglobal(singledropdownname), backupID)
	UIDropDownMenu_SetText(backuptext, getglobal(singledropdownname)) -- needed or else left undefined and not always using default from SetSelectedID()
	--UIDropDownMenu_SetText(QuestHistorySingleDropDownEntryX_GetNameFromIndexCommon(backupID, singledropdownname, dropdownlist), getglobal(singledropdownname)) -- not applicable at startup when nothing set yet
end

function QuestHistorySingleDropDownEntryX_GetIndexCommon(number, singledropdownname, dropdownlist)
	local cProcedureName = "QuestHistorySingleDropDownEntryX_GetIndexCommon()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..singledropdownname); end

	local index = 0
	if number then
		for i = 1, getn(dropdownlist), 1 do
			if (dropdownlist[i].number == number) then
				index = dropdownlist[i].index
				--index = i -- alternative
				break
			end
		end
	else -- current selection
		local dropdownname = getglobal(singledropdownname)
		index = dropdownname.index
		--index = UIDropDownMenu_GetSelectedID(getglobal(singledropdownname)) -- not needed, gives problems anyway
		-- if nil, then it means we never set the dropdown properly to the correct value
	end

	if not index or index < 1 or index > getn(dropdownlist) then
		index = 1 -- default is better than crashing
		QuestHistory_ShowCriticalError(cProcedureName .." . " ..singledropdownname .." is nil")
	end
	return index
end

function QuestHistorySingleDropDownEntryX_GetNumberCommon(index, singledropdownname, dropdownlist)
	local cProcedureName = "QuestHistorySingleDropDownEntryX_GetNumberCommon()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..singledropdownname); end

	local number = 0
	if index then
		number = dropdownlist[index].number
	else -- current selection
		local dropdownname = getglobal(singledropdownname)
		number = dropdownname.number
	end

	if not number then
		number = 1 -- default is better than crashing
		QuestHistory_ShowCriticalError(cProcedureName .." . " ..singledropdownname .." is nil")
	end
	return number
end

function QuestHistorySingleDropDownEntryX_GetNameCommon(number, singledropdownname, dropdownlist)
	local cProcedureName = "QuestHistorySingleDropDownEntryX_GetNameCommon()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..singledropdownname); end

	local name = ""
	local index = 0
	if number then
		for i = 1, getn(dropdownlist), 1 do
			if (dropdownlist[i].number == number) then
				index = dropdownlist[i].index
				--index = i -- alternative
				name = dropdownlist[index].name
				break
			end
		end
	else -- current selection
		local dropdownname = getglobal(singledropdownname)
		index = dropdownname.index
		name = dropdownlist[index].name
		--index = UIDropDownMenu_GetSelectedID(getglobal(singledropdownname)) -- not needed, gives problems anyway
		-- if nil, then it means we never set the dropdown properly to the correct value
	end

	if not name then
		name = "" -- default is better than crashing
		QuestHistory_ShowCriticalError(cProcedureName .." . " ..singledropdownname .." is nil")
	end
	return name
end

function QuestHistorySingleDropDownEntryX_GetNameFromIndexCommon(index, singledropdownname, dropdownlist)
	local cProcedureName = "QuestHistorySingleDropDownEntryX_GetNameFromIndexCommon()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..singledropdownname); end

	local name = ""
	if index then
		name = dropdownlist[index].name
	else -- current selection
		local dropdownname = getglobal(singledropdownname)
		index = dropdownname.index
		name = dropdownlist[index].name
	end

	if not name then
		name = "" -- default is better than crashing
		QuestHistory_ShowCriticalError(cProcedureName .." . " ..singledropdownname .." is nil")
	end
	return name
end

function QuestHistorySingleDropDownEntryX_SetNumberCommon(number, singledropdownname, dropdownlist)
	local cProcedureName = "QuestHistorySingleDropDownEntryX_SetNumberCommon()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..singledropdownname); end

	local index = 0
	if number then
		index = QuestHistorySingleDropDownEntryX_GetIndexCommon(number, singledropdownname, dropdownlist)
		QuestHistorySingleDropDownEntryX_SetIndexCommon(index, singledropdownname, dropdownlist)
	else -- nothing to do, current selection
	end
end

function QuestHistorySingleDropDownEntryX_SetIndexCommon(index, singledropdownname, dropdownlist)
	local cProcedureName = "QuestHistorySingleDropDownEntryX_SetIndexCommon()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..singledropdownname); end

	if index then
		-- Save current settings
		local dropdownname = getglobal(singledropdownname)
		dropdownname.index = index
		dropdownname.number = dropdownlist[index].number
		UIDropDownMenu_SetSelectedID(getglobal(singledropdownname), index)
		UIDropDownMenu_SetText(QuestHistorySingleDropDownEntryX_GetNameFromIndexCommon(index, singledropdownname, dropdownlist), getglobal(singledropdownname)) -- needed or else left undefined and not always using default from SetSelectedID()
	else -- nothing to do, current selection
	end
end

---------------------------------------------------------------------------
-- Sort Dropdown stuff
-- (generic to work on more than one)
function QuestHistorySortDropDownX_Initialize(dropdownname, buttonclick)
	local cProcedureName = "QuestHistorySortDropDownX_Initialize()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..dropdownname); end

	local dropdownlist = QUESTHISTORY_SORT_DROPDOWN_LIST
	local dropdowntooltiptitle = QUESTHISTORY_SORT_DROPDOWN_LIST_TOOLTIPTITLE
	local dropdowntooltip = QUESTHISTORY_SORT_DROPDOWN_LIST_TOOLTIP
	QuestHistorySingleDropDownX_InitializeCommon(dropdownname, buttonclick, dropdownlist, dropdowntooltiptitle, dropdowntooltip)
end

function QuestHistorySortDropDownEntryX_GetIndex(number, dropdownname)
	local cProcedureName = "QuestHistorySortDropDownEntryX_GetIndex()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..dropdownname); end

	local index = 0
	local dropdownlist = QUESTHISTORY_SORT_DROPDOWN_LIST
	index = QuestHistorySingleDropDownEntryX_GetIndexCommon(number, dropdownname, dropdownlist)
	return index
end

function QuestHistorySortDropDownEntryX_GetNumber(index, dropdownname)
	local cProcedureName = "QuestHistorySortDropDownEntryX_GetNumber()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..dropdownname); end

	local number = 0
	local dropdownlist = QUESTHISTORY_SORT_DROPDOWN_LIST
	number = QuestHistorySingleDropDownEntryX_GetNumberCommon(index, dropdownname, dropdownlist)
	return number
end

function QuestHistorySortDropDownEntryX_GetName(number, dropdownname)
	local cProcedureName = "QuestHistorySortDropDownEntryX_GetName()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..dropdownname); end

	local name = ""
	local dropdownlist = QUESTHISTORY_SORT_DROPDOWN_LIST
	name = QuestHistorySingleDropDownEntryX_GetNameCommon(number, dropdownname, dropdownlist)
	return name
end

function QuestHistorySortDropDownEntryX_GetNameFromIndex(index, dropdownname)
	local cProcedureName = "QuestHistorySortDropDownEntryX_GetNameFromIndex()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..dropdownname); end

	local name = ""
	local dropdownlist = QUESTHISTORY_SORT_DROPDOWN_LIST
	name = QuestHistorySingleDropDownEntryX_GetNameFromIndexCommon(index, dropdownname, dropdownlist)
	return name
end

function QuestHistorySortDropDownEntryX_SetNumber(number, dropdownname, seconddropdownname)
	local cProcedureName = "QuestHistorySortDropDownEntryX_SetNumber()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..dropdownname); end

	local dropdownlist = QUESTHISTORY_SORT_DROPDOWN_LIST
	QuestHistorySingleDropDownEntryX_SetNumberCommon(number, dropdownname, dropdownlist)

	-- update next dropdown, if exists
	if seconddropdownname then
		QuestHistoryNameDropDownEntryX_SetNumber(1, seconddropdownname, dropdownname) -- set other popup
		--QuestHistorySecondDropDownEntryX_SetNumberCommon(... -- not yet implemented
	end
end

function QuestHistorySortDropDownEntryX_SetIndex(index, dropdownname, seconddropdownname)
	local cProcedureName = "QuestHistorySortDropDownEntryX_SetIndex()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..dropdownname); end

	local dropdownlist = QUESTHISTORY_SORT_DROPDOWN_LIST
	QuestHistorySingleDropDownEntryX_SetIndexCommon(index, dropdownname, dropdownlist)

	-- update next dropdown, if exists
	if seconddropdownname then
		QuestHistoryNameDropDownEntryX_SetNumber(1, seconddropdownname, dropdownname) -- set other popup
		--QuestHistorySecondDropDownEntryX_SetNumberCommon(... -- not yet implemented
	end
end

function QuestHistorySortDropDownEntryX_Verify(typen, SortDropDownname)
	local cProcedureName = "QuestHistorySortDropDownEntryX_Verify()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..SortDropDownname); end

	local isValid = nil
	local dropdownlist = QUESTHISTORY_SORT_DROPDOWN_LIST
	if typen then
		for i = 1, getn(dropdownlist), 1 do
			if not (dropdownlist[i].number == typen) then
			elseif dropdownlist[i].isHide then
			elseif dropdownlist[i].isDisable then
			else
				isValid = 1
				break -- only need to find first match
			end
		end
	end
	return isValid
end

---------------------------------------------------------------------------
-- Character Dropdown stuff
-- (generic to work on more than one)
function QuestHistoryCharacterDropDownX_Initialize(dropdownname, buttonclick)
	local cProcedureName = "QuestHistoryCharacterDropDownX_Initialize()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..dropdownname); end

	local dropdownlist = getglobal(dropdownname.."array")
	local dropdowntooltiptitle = ""
	local dropdowntooltip = ""
	QuestHistorySingleDropDownX_InitializeCommon(dropdownname, buttonclick, dropdownlist, dropdowntooltiptitle, dropdowntooltip)
end

function QuestHistoryCharacterDropDownEntryX_GetIndex(number, dropdownname)
	local cProcedureName = "QuestHistoryCharacterDropDownEntryX_GetIndex()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..dropdownname); end

	local index = 0
	local dropdownlist = getglobal(dropdownname.."array")
	index = QuestHistorySingleDropDownEntryX_GetIndexCommon(number, dropdownname, dropdownlist)
	return index
end

function QuestHistoryCharacterDropDownEntryX_GetNumber(index, dropdownname)
	local cProcedureName = "QuestHistoryCharacterDropDownEntryX_GetNumber()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..dropdownname); end

	local number = 0
	local dropdownlist = getglobal(dropdownname.."array")
	number = QuestHistorySingleDropDownEntryX_GetNumberCommon(index, dropdownname, dropdownlist)
	return number
end

function QuestHistoryCharacterDropDownEntryX_GetName(number, dropdownname)
	local cProcedureName = "QuestHistoryCharacterDropDownEntryX_GetName()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..dropdownname); end

	local name = ""
	local dropdownlist = getglobal(dropdownname.."array")
	name = QuestHistorySingleDropDownEntryX_GetNameCommon(number, dropdownname, dropdownlist)
	return name
end

function QuestHistoryCharacterDropDownEntryX_GetNameFromIndex(index, dropdownname)
	local cProcedureName = "QuestHistoryCharacterDropDownEntryX_GetNameFromIndex()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..dropdownname); end

	local name = ""
	local dropdownlist = getglobal(dropdownname.."array")
	name = QuestHistorySingleDropDownEntryX_GetNameFromIndexCommon(index, dropdownname, dropdownlist)
	return name
end

function QuestHistoryCharacterDropDownEntryX_SetNumber(number, dropdownname, seconddropdownname)
	local cProcedureName = "QuestHistoryCharacterDropDownEntryX_SetNumber()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..dropdownname); end

	local dropdownlist = getglobal(dropdownname.."array")
	QuestHistorySingleDropDownEntryX_SetNumberCommon(number, dropdownname, dropdownlist)

	-- update next dropdown, if exists
	if seconddropdownname then
		QuestHistoryNameDropDownEntryX_SetNumber(1, seconddropdownname, dropdownname) -- set other popup
		--QuestHistorySecondDropDownEntryX_SetNumberCommon(... -- not yet implemented
	end
end

function QuestHistoryCharacterDropDownEntryX_SetIndex(index, dropdownname, seconddropdownname)
	local cProcedureName = "QuestHistoryCharacterDropDownEntryX_SetIndex()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..dropdownname); end

	local dropdownlist = getglobal(dropdownname.."array")
	QuestHistorySingleDropDownEntryX_SetIndexCommon(index, dropdownname, dropdownlist)

	-- update next dropdown, if exists
	if seconddropdownname then
		QuestHistoryNameDropDownEntryX_SetNumber(1, seconddropdownname, dropdownname) -- set other popup
		--QuestHistorySecondDropDownEntryX_SetNumberCommon(... -- not yet implemented
	end
end

function QuestHistoryCharacterDropDownEntryX_Verify(typen, CharacterDropDownname)
	local cProcedureName = "QuestHistoryCharacterDropDownEntryX_Verify()"
	if QuestHistoryShowProcedureName then DEFAULT_CHAT_FRAME:AddMessage("Dropdown: " ..cProcedureName .." " ..CharacterDropDownname); end

	local isValid = nil
	local dropdownlist = getglobal(dropdownname.."array")
	if typen then
		for i = 1, getn(dropdownlist), 1 do
			if not (dropdownlist[i].number == typen) then
			elseif dropdownlist[i].isHide then
			elseif dropdownlist[i].isDisable then
			else
				isValid = 1
				break -- only need to find first match
			end
		end
	end
	return isValid
end
