QuestGuru_WatchHeaders = {};
QuestGuru_WatchQuests = {};
QuestGuru_WatchList = {};
QuestGuru_WatchLine = {};
QuestGuru_WatchLines = 0;
QuestGuru_WatchLastFade = false;
QuestGuru_WatchUpdateTime = 0;

function QuestGuru_SetWatchBorder(enabled)
	if (enabled) then
		QuestGuru_QuestWatchFrame:SetBackdrop({
			bgFile="Interface\\Characterframe\\UI-Party-Background",
			edgeFile="Interface\\Tooltips\\UI-Tooltip-Border",
			tile=1, tileSize=16, edgeSize=16,
			insets={left=4, right=4, top=4, bottom=4}
		});
	else
		QuestGuru_QuestWatchFrame:SetBackdrop({
			bgFile="Interface\\Characterframe\\UI-Party-Background",
			tile=1, tileSize=16,
			insets={left=4, right=4, top=4, bottom=4}
		});
	end
	QuestGuru_QuestWatchFrame:SetBackdropColor(0,0,0,QuestGuru_Settings.Tracker.Alpha);
end

do
	local temp, i;

	QuestGuru_QuestWatchFrame = CreateFrame("FRAME", "QuestGuru_QuestWatchFrame", UIParent);
	QuestGuru_QuestWatchFrame:Hide();
	QuestGuru_QuestWatchFrame:EnableMouse(1);
	QuestGuru_QuestWatchFrame:EnableMouseWheel(1);
	QuestGuru_QuestWatchFrame:SetMovable(1);
	QuestGuru_QuestWatchFrame:SetResizable(0);
	QuestGuru_QuestWatchFrame:SetToplevel(1);
	QuestGuru_QuestWatchFrame:SetFrameStrata("LOW");
	QuestGuru_QuestWatchFrame:SetClampedToScreen(true);
	QuestGuru_QuestWatchFrame:SetWidth(256);
	QuestGuru_QuestWatchFrame:SetHeight(20);
	QuestGuru_QuestWatchFrame:SetPoint("TOPRIGHT", MinimapCluster, "BOTTOMRIGHT", 0, 10);
	QuestGuru_QuestWatchFrame:SetHitRectInsets(-16, 0, 0, 0);
	QuestGuru_SetWatchBorder(2);
	
	QuestGuru_QuestWatchFrame:RegisterForDrag("LeftButton");
	QuestGuru_QuestWatchFrame:SetScript("OnDragStart",
		function ()
			this:StartMoving();
			this.isMoving = true;
 		end);
 	QuestGuru_QuestWatchFrame:SetScript("OnDragStop",
 		function ()
			this:StopMovingOrSizing();
			this.isMoving = false;
			QuestGuru_Settings.Tracker.Left = QuestGuru_QuestWatchFrame:GetLeft();
		    QuestGuru_Settings.Tracker.Top = QuestGuru_QuestWatchFrame:GetTop();
		    QuestGuru_Settings.Tracker.Bottom = QuestGuru_QuestWatchFrame:GetBottom();
		    QuestGuru_QuestWatchFrameSlider:ClearAllPoints();
		    if (((QuestGuru_Settings.Tracker.Left + 256) * QuestGuru_Settings.Tracker.Scale) > (UIParent:GetWidth() - 16)) then
				QuestGuru_QuestWatchFrameSlider:SetPoint("TOPLEFT", -14, -20);
		    else
				QuestGuru_QuestWatchFrameSlider:SetPoint("TOPRIGHT", 14, -20);
		    end
		end);
	QuestGuru_QuestWatchFrame:SetScript("OnEnter",
		function ()
		    QuestGuru_QuestWatchFrameSlider:SetScript("OnMouseUp", nil);
			QuestGuru_ShowTrackerSlider(true);
		end);
	QuestGuru_QuestWatchFrame:SetScript("OnLeave",
		function ()
			QuestGuru_ShowTrackerSlider(false);
		end);
    QuestGuru_QuestWatchFrame:SetScript("OnMouseWheel",
        function ()
            local min, max = QuestGuru_QuestWatchFrameSlider:GetMinMaxValues();
            local currVal = QuestGuru_QuestWatchFrameSlider:GetValue();
            
            currVal = currVal - arg1;
            if (currVal < min) then currVal = min; end
            if (currVal > max) then currVal = max; end
            QuestGuru_QuestWatchFrameSlider:SetValue(currVal);
		end);
	QuestGuru_QuestWatchFrame:SetScript("OnShow",
	    function ()
	        QuestGuru_ShowTrackerSlider(false);
		end);

    temp = QuestGuru_QuestWatchFrame:CreateTexture("QuestGuru_QuestWatchFrameTitleBackground", "ARTWORK");
    temp:SetWidth(248);
    temp:SetHeight(18);
    temp:SetPoint("TOPLEFT", 4, -4);
    temp:SetTexture(1, 1, 1);
    temp:SetGradientAlpha("VERTICAL", 0, 0, 0, 0, 0.3, 0.3, 0.3, 1);

	temp = QuestGuru_QuestWatchFrame:CreateFontString("QuestGuru_QuestWatchQuestName", "ARTWORK", "GameFontNormal");
	temp:SetPoint("TOPLEFT", 8, -6);
	temp:SetJustifyH("LEFT");
	temp:SetWidth(0);
	temp:SetHeight(12);
	temp:SetText("QuestGuru Tracker");

	temp = QuestGuru_QuestWatchFrame:CreateFontString("QuestGuru_QuestWatchNumQuests", "ARTWORK", "GameFontNormal");
	temp:SetPoint("LEFT", QuestGuru_QuestWatchQuestName, "RIGHT", 12, 0);
	temp:SetJustifyH("CENTER");
	temp:SetWidth(0);
	temp:SetHeight(12);
	temp:SetText("0/"..MAX_QUESTS);
	
	QuestGuru_QuestWatchFrameOptions = CreateFrame("BUTTON", "QuestGuru_QuestWatchFrameOptions", QuestGuru_QuestWatchFrame, "QuestGuru_QuestWatchMiniButtonTemplate");
	QuestGuru_QuestWatchFrameOptions:SetText("O");
	QuestGuru_QuestWatchFrameOptions:SetPoint("TOPRIGHT", -5, -4);
	QuestGuru_QuestWatchFrameOptions:SetScript("OnClick",
		function ()
			InterfaceOptionsFrame_OpenToFrame("QG Tracker");
		end);
	QuestGuru_QuestWatchFrameOptions:SetScript("OnEnter",
		function ()
		    QuestGuru_QuestWatchFrameSlider:SetScript("OnMouseUp", nil);
		    QuestGuru_ShowTrackerSlider(true);
			GameTooltip:SetOwner(this, "ANCHOR_LEFT");
			GameTooltip:SetText("Tracker Options", nil,nil, nil, nil, 1);
		end);
	QuestGuru_QuestWatchFrameOptions:SetScript("OnLeave",
		function ()
		    QuestGuru_ShowTrackerSlider(false);
			GameTooltip:Hide();
		end);
	
	QuestGuru_QuestWatchFrameMinimize = CreateFrame("BUTTON", "QuestGuru_QuestWatchFrameMinimize", QuestGuru_QuestWatchFrame, "QuestGuru_QuestWatchMiniButtonTemplate");
	QuestGuru_QuestWatchFrameMinimize:SetText("-");
	QuestGuru_QuestWatchFrameMinimize:SetPoint("RIGHT", QuestGuru_QuestWatchFrameOptions, "LEFT", 0, 0);
	QuestGuru_QuestWatchFrameMinimize:RegisterForClicks("LeftButtonUp", "RightButtonUp");
	QuestGuru_QuestWatchFrameMinimize:SetScript("OnClick",
		function ()
			if (arg1 == "LeftButton") then
				if (QuestGuru_Settings.Tracker.AutoMinimize) then
					QuestGuru_ShowTrackerSlider(false);
					QuestGuru_Settings.Tracker.Minimized = true;
				else
		    		QuestGuru_ShowTrackerSlider(QuestGuru_Settings.Tracker.Minimized);
					QuestGuru_Settings.Tracker.Minimized = not QuestGuru_Settings.Tracker.Minimized;
				end
		    	QuestGuru_Settings.Tracker.AutoMinimize = false;
				QuestWatch_Update();
				GameTooltip:Hide();
			elseif (arg1 == "RightButton") then
				QuestGuru_Settings.Tracker.AutoMinimize = not QuestGuru_Settings.Tracker.AutoMinimize;
				QuestWatch_Update();
			end
		end);
	QuestGuru_QuestWatchFrameMinimize:SetScript("OnEnter",
		function ()
		    QuestGuru_QuestWatchFrameSlider:SetScript("OnMouseUp", nil);
		    QuestGuru_ShowTrackerSlider(true);
			GameTooltip:SetOwner(this, "ANCHOR_LEFT");
			if (QuestGuru_Settings.Tracker.Minimized) then
				GameTooltip:SetText("Show Tracker", nil,nil, nil, nil, 1);
			else
				GameTooltip:SetText("Minimize Tracker", nil,nil, nil, nil, 1);
			end
		end);
	QuestGuru_QuestWatchFrameMinimize:SetScript("OnLeave",
		function ()
		    QuestGuru_ShowTrackerSlider(false);
			GameTooltip:Hide();
		end);
		
	QuestGuru_QuestWatchFrameSlider = CreateFrame("Slider", "QuestGuru_QuestWatchFrameSlider", QuestGuru_QuestWatchFrame, "OptionsSliderTemplate");
	QuestGuru_QuestWatchFrameSlider:SetWidth(16);
	QuestGuru_QuestWatchFrameSlider:SetHeight(200);
	QuestGuru_QuestWatchFrameSliderText:SetText("");
	QuestGuru_QuestWatchFrameSliderHigh:SetText("");
	QuestGuru_QuestWatchFrameSliderLow:SetText("");
	QuestGuru_QuestWatchFrameSlider:SetOrientation("VERTICAL");
	QuestGuru_QuestWatchFrameSlider:SetPoint("TOPLEFT", -14, -20);
	QuestGuru_QuestWatchFrameSlider:SetMinMaxValues(0,0);
	QuestGuru_QuestWatchFrameSlider:SetValueStep(1);
	QuestGuru_QuestWatchFrameSlider:SetValue(0);
	QuestGuru_QuestWatchFrameSlider:Hide();
	QuestGuru_QuestWatchFrameSlider:SetAlpha(0);	
	QuestGuru_QuestWatchFrameSlider:SetScript("OnEnter",
		function ()
			QuestGuru_ShowTrackerSlider(true);
		end);
	QuestGuru_QuestWatchFrameSlider:SetScript("OnLeave",
		function ()
			QuestGuru_ShowTrackerSlider(false);
		end);
    QuestGuru_QuestWatchFrameSlider:SetScript("OnValueChanged",
        function ()
            QuestWatch_Update();
		end);

	for i=1, 40 do
		temp = CreateFrame("Button", "QuestGuru_QuestWatchLine"..i, QuestGuru_QuestWatchFrame, "QuestGuru_QuestWatchButtonTemplate");
		temp:SetPoint("TOPLEFT", QuestGuru_QuestWatchFrame, 8, -20);
		temp:SetHeight(13);
		temp:RegisterForClicks("LeftButtonUp", "RightButtonUp");
	end
	
	QuestGuru_QuestWatchTooltip = CreateFrame("GameTooltip", "QuestGuru_QuestWatchTooltip", QuestGuru_QuestWatchFrame, "GameTooltipTemplate");
	QuestGuru_QuestWatchTooltip:Hide();
	QuestGuru_QuestWatchTooltip:SetFrameStrata("TOOLTIP");
end

function QuestGuru_ShowTrackerSlider(flag)
	UIFrameFadeRemoveFrame(QuestGuru_QuestWatchFrameSlider);
	local currAlpha = QuestGuru_QuestWatchFrameSlider:GetAlpha();
	if (QuestGuru_Settings and QuestGuru_Settings.Tracker and (QuestGuru_Settings.Tracker.AutoMinimize==true) and not IsMouseButtonDown("LeftButton")) then
		QuestGuru_Settings.Tracker.Minimized = not flag;
	end

    local watchLines = 30;
    if (QuestGuru_Settings and QuestGuru_Settings.Tracker and QuestGuru_Settings.Tracker.Lines) then
    	watchLines = QuestGuru_Settings.Tracker.Lines;
    end
	if ((flag == true) and (QuestGuru_WatchLines > watchLines) and not QuestGuru_Settings.Tracker.Minimized) then
		if (currAlpha < 1) then
			QuestGuru_QuestWatchFrameSlider:Show();
			local fadeInfo = {};
			fadeInfo.mode = "IN";
			fadeInfo.timeToFade = 0.1 * (1 - currAlpha);
			fadeInfo.startAlpha = currAlpha;
			fadeInfo.endAlpha = 1;
			fadeInfo.finishedFunc = function ()
					QuestWatch_Update();
				end;
			QuestGuru_QuestWatchFrameSlider.fadeInfo = fadeInfo;
			tinsert(FADEFRAMES, QuestGuru_QuestWatchFrameSlider);
		end
	else
		if (IsMouseButtonDown("LeftButton")) then
	        this:SetScript("OnMouseUp",
	            function ()
	                QuestGuru_ShowTrackerSlider(false);
	                this:SetScript("OnMouseUp", nil);
				end);
	    else
			local fadeInfo = {};
			fadeInfo.mode = "OUT";
			fadeInfo.timeToFade = 0.1 * currAlpha;
			fadeInfo.startAlpha = currAlpha;
			fadeInfo.endAlpha = 0;
			fadeInfo.finishedFunc = function ()
					QuestGuru_QuestWatchFrameSlider:Hide();
					QuestWatch_Update();
				end;
			QuestGuru_QuestWatchFrameSlider.fadeInfo = fadeInfo;
			tinsert(FADEFRAMES, QuestGuru_QuestWatchFrameSlider);
		end
	end
end

function QuestGuru_SetTrackerMouse(enableFlag)
	QuestGuru_QuestWatchFrame:EnableMouse(enableFlag);
	for i=1, 40 do
		getglobal("QuestGuru_QuestWatchLine"..i):EnableMouse(enableFlag);
	end
end

function QuestGuru_QuestWatchButton_OnEnter()
	local qID = this.qID;
	local minWidth = 224;

	this.fading = 0;
	this:SetScript("OnUpdate", nil);
	getglobal(this:GetName().."Highlight"):SetAlpha(0.5);
	getglobal(this:GetName().."Highlight"):Show();
	if (qID == nil) then -- header
		return;
	elseif (tonumber(qID) == nil) then -- objective line
		local objName = string.sub(this:GetText(),4);
		local objText = "";
		if (qID == "item") then
			local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(objName);
			if ((not itemLink) and QuestGuru_Items[QuestGuru_RealmName][objName]) then
				itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(QuestGuru_Items[QuestGuru_RealmName][objName]);
			end
			if (itemLink and QuestGuru_Settings.Tracker.ShowQuestTooltips) then
				GameTooltip:SetOwner(this);
				GameTooltip:SetHyperlink(itemLink);
			end
		end
	else -- quest line
	    if (QuestGuru_Settings.Tracker.ShowQuestTooltips) then
			QuestGuru_QuestWatchTooltip:SetOwner(this, "ANCHOR_LEFT");
			QuestGuru_QuestWatchTooltip:SetHyperlink(GetQuestLink(qID));
			QuestGuru_QuestWatchTooltip:Show();
		end
		if (QuestGuru_Settings.Tracker.ShowPartyTooltips) then QuestLog_UpdatePartyInfoTooltip(); end
	end
end

function QuestGuru_QuestWatchButton_OnLeave()
	getglobal(this:GetName().."Highlight"):Hide();
	QuestGuru_ShowTrackerSlider(false);
	QuestGuru_QuestWatchTooltip:Hide();
	GameTooltip:Hide();
end

function QuestGuru_QuestWatchButton_OnUpdate(self, elapsed)
	local hilight = getglobal(this:GetName().."Highlight");
	
	if (this.fading == 1) then
	    local a = hilight:GetAlpha();
	    a = a - elapsed;
	    if (a <= 0) then
			a = 0;
			this.fading = 0;
			this:SetScript("OnUpdate", nil);
		end
		hilight:SetAlpha(a);
	end
end

function QuestGuru_QuestWatchButton_OnClick(button)
	local qID = this.qID;

    QuestGuru_ShowTrackerSlider(true);
	if (button == "LeftButton") then
		if ( IsShiftKeyDown() ) then
			if (qID == nil) then -- header line
				if (ChatFrameEditBox:IsVisible()) then
					ChatFrameEditBox:Insert(this:GetText());
				end			
			elseif (tonumber(qID) == nil) then -- objective line
				local objName = string.sub(this:GetText(),4);
				local objText = "";
				if (qID == "item") then
					local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(objName);
					if (itemLink == nil) then
						objText = objName;
					else
						objText = itemLink;
					end
				else
					objText = objName;
				end
				if (ChatFrameEditBox:IsVisible()) then
					ChatFrameEditBox:Insert(objText);
				end					
			else -- quest number
				if (ChatFrameEditBox:IsVisible()) then
					ChatFrameEditBox:Insert(GetQuestLink(qID));
				end
			end
		else
			if (qID == nil) then -- header line
				local headName = this:GetText();
				if (QuestGuru_WatchHeaders[headName] ~= false) then
					QuestGuru_WatchHeaders[headName] = false;
				else
					QuestGuru_WatchHeaders[headName] = true;
				end
				QuestWatch_Update();
			elseif (tonumber(qID) == nil) then -- objective line
				local objName = string.sub(this:GetText(),4);
				if (qID == "item") then
					local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(objName);
					if (itemLink ~= nil) then
						SetItemRef(itemLink, nil, button);
					end
				end
			else -- title line
				QuestLog_SetSelection(qID);
				QuestLog_Update();
				QuestGuru_QuestLogFrame:Show();
			end
		end
	elseif (button == "RightButton") then
		if (qID == nil) then -- header line
			local headName = this:GetText();
			if (QuestGuru_WatchHeaders[headName] ~= false) then
				QuestGuru_WatchHeaders[headName] = false;
			else
				QuestGuru_WatchHeaders[headName] = true;
			end
			QuestWatch_Update();
		elseif (tonumber(qID) ~= nil) then -- title line
		    -- expand/collapse quests
			local qName = GetQuestLogTitle(qID);

			if (QuestGuru_WatchQuests[qName] ~= false) then
				QuestGuru_WatchQuests[qName] = false;
			else
				QuestGuru_WatchQuests[qName] = true;
			end
			QuestWatch_Update();
		end
	end
end

-- QuestWatch functions
local old_QuestWatch_Update = QuestWatch_Update;
function QuestWatch_Update()
	if (not QuestGuru_Settings.Tracker.Enabled) then
	    QuestGuru_QuestWatchFrame:Hide();
	    old_QuestWatch_Update();
	    return;
	end

	QuestWatchFrame:Hide();
	local numObjectives;
	local questWatchMaxWidth = 0;
	local tempWidth;
	local watchText;
	local text, type, finished;
	local questTitle
	local watchTextIndex = 1;
	QuestGuru_WatchLine[watchTextIndex] = {};
	local questIndex;
	local objectivesCompleted;
	local strLvl;
	local currHeader = "";
	local lastWatchHeader = "";
	local lastWatchIndex = 0;
	local i, j;
	
	if (QuestGuru_WatchFlash == nil) then QuestGuru_WatchFlash = {}; end

	local numEntries, numQuests = GetNumQuestLogEntries();
	
	QuestGuru_QuestWatchNumQuests:SetText(numQuests.."/"..MAX_QUESTS);
	
	if(QuestGuru_Settings.Tracker.ClickThrough) then
		QuestGuru_SetTrackerMouse(0);
	else
		QuestGuru_SetTrackerMouse(1);
	end

	for questIndex=1, numEntries do
		local questLogTitleText, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(questIndex);
		if (isHeader) then
		    currHeader = questLogTitleText;
		end
		if (IsQuestWatched(questIndex) and (not isHeader)) then
			if (currHeader ~= lastWatchHeader and QuestGuru_Settings.Tracker.ShowHeaders) then
				QuestGuru_WatchLine[watchTextIndex].Text = currHeader;
				QuestGuru_WatchLine[watchTextIndex].TextColor = {r=1, g=1, b=1};
				QuestGuru_WatchLine[watchTextIndex].Tag = "";
				lastWatchHeader = currHeader;
				lastWatchIndex = watchTextIndex;
				QuestGuru_WatchLine[watchTextIndex].qID = nil;
		      	QuestGuru_WatchLine[watchTextIndex].isHeader = true;
		      	QuestGuru_WatchLine[watchTextIndex].isTitle = false;
		      	watchTextIndex = watchTextIndex + 1;
		      	QuestGuru_WatchLine[watchTextIndex] = {};
			end
			
			if ( QuestGuru_WatchHeaders[currHeader] ~= false ) then
				-- Set title
				strLvl = "["..level
				if (isDaily) then
				    strLvl = strLvl.."Y";
				end
				if (questTag ~= nil) then
					if ((questTag == "Group") and (suggestedGroup > 0)) then
						strLvl = strLvl.."G"..suggestedGroup;
					elseif (questTag == "Dungeon") then
						strLvl = strLvl.."D";
					else
						strLvl = strLvl.."+"
					end
				end
				strLvl = strLvl.."] "
				if (QuestGuru_Settings.Tracker.ShowLevels) then
					QuestGuru_WatchLine[watchTextIndex].Text = strLvl..questLogTitleText;
				else
					QuestGuru_WatchLine[watchTextIndex].Text = questLogTitleText;
				end
				QuestGuru_WatchLine[watchTextIndex].qID = questIndex;

				QuestGuru_WatchLine[watchTextIndex].isHeader = false;
				QuestGuru_WatchLine[watchTextIndex].isTitle = true;

				local watchQuestIndex = watchTextIndex;
				watchTextIndex = watchTextIndex + 1;
				QuestGuru_WatchLine[watchTextIndex] = {};
				objectivesCompleted = 0;
				local questNumNeeded = 0;
				local questNumDone = 0;
				local r, g, b;
				numObjectives = GetNumQuestLeaderBoards(questIndex);
				for j=1, numObjectives do
					text, type, finished = GetQuestLogLeaderBoard(j, questIndex);
				    local qi, qj, itemName, numDone, numNeeded = string.find(text,"(.*):%s*([%d]+)%s*/%s*([%d]+)");
				    
				    if ((type == "item") and QuestGuru_Items[QuestGuru_RealmName]) then
						iiName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, texture = GetItemInfo(itemName);
						if (iiName and itemLink) then
							QuestGuru_Items[QuestGuru_RealmName][iiName] = itemLink;
						end
				    end

					if ((not finished) or QuestGuru_Settings.Tracker.ShowCompletedObj) then
						-- Set Objective text
						if ((type == "item") or (type == "monster") or (type == "object")) then
						    QuestGuru_WatchLine[watchTextIndex].Text = " - "..itemName;
						    if (numDone == numNeeded) then
						        QuestGuru_WatchLine[watchTextIndex].Tag = COMPLETE;
								objectivesCompleted = objectivesCompleted + 1;
							else
						    	QuestGuru_WatchLine[watchTextIndex].Tag = numDone.."/"..numNeeded;
							end
							r, g, b = QuestGuru_QuestWatchGetObjColor(numDone/numNeeded);
							questNumNeeded = questNumNeeded + numNeeded;
							questNumDone = questNumDone + numDone;
						else
							QuestGuru_WatchLine[watchTextIndex].Text = " - "..text;
							QuestGuru_WatchLine[watchTextIndex].Tag = "";
							questNumNeeded = questNumNeeded + 1;
							if (finished) then
								questNumDone = questNumDone + 1;
								objectivesCompleted = objectivesCompleted + 1;
								r, g, b = QuestGuru_QuestWatchGetObjColor(1);
							else
							    r, g, b = QuestGuru_QuestWatchGetObjColor(0);
							end
						end
						QuestGuru_WatchLine[watchTextIndex].qID = type;
				      	QuestGuru_WatchLine[watchTextIndex].isHeader = false;
				      	QuestGuru_WatchLine[watchTextIndex].isTitle = false;
						-- Color the objectives
						QuestGuru_WatchLine[watchTextIndex].TextColor = {r=r,g=g,b=b};
						if (QuestGuru_WatchQuests[questLogTitleText] == false) then
							if (QuestGuru_WatchFlash and QuestGuru_WatchFlash[questIndex] and QuestGuru_WatchFlash[questIndex][j]) then
								QuestGuru_WatchLine[watchQuestIndex].fading = QuestGuru_WatchFlash[questIndex][j];
								QuestGuru_WatchFlash[questIndex][j] = nil;
							end
						    watchTextIndex = watchTextIndex - 1;
						else
							if (QuestGuru_WatchFlash and QuestGuru_WatchFlash[questIndex] and QuestGuru_WatchFlash[questIndex][j]) then
								QuestGuru_WatchLine[watchTextIndex].fading = QuestGuru_WatchFlash[questIndex][j];
								QuestGuru_WatchFlash[questIndex][j] = nil;
							end
						end
						watchTextIndex = watchTextIndex + 1;
						QuestGuru_WatchLine[watchTextIndex] = {};
					elseif (finished) then
					    objectivesCompleted = objectivesCompleted + 1;
						if ((type == "item") or (type == "monster") or (type == "object")) then
							questNumNeeded = questNumNeeded + numNeeded;
							questNumDone = questNumDone + numDone;
						else
							questNumNeeded = questNumNeeded + 1;
							questNumDone = questNumDone + 1;
						end
					end
				end
				-- Brighten the quest title if all the quest objectives were met
				color = GetDifficultyColor(level);
				if ( objectivesCompleted == numObjectives ) then
				    QuestGuru_WatchLine[watchQuestIndex].Tag = COMPLETE;
					QuestGuru_WatchLine[watchQuestIndex].TextColor = {r=color.r, g=color.g, b=color.b};
				else
					if (questNumNeeded > 0) then
						local perComplete = math.floor((questNumDone * 100) / questNumNeeded);
						QuestGuru_WatchLine[watchQuestIndex].Tag = perComplete.."%";
					else
				    	QuestGuru_WatchLine[watchQuestIndex].Tag = "";
				    end
					QuestGuru_WatchLine[watchQuestIndex].TextColor = {r=color.r * 0.75, g=color.g * 0.75, b=color.b * 0.75};
				end
			elseif (QuestGuru_WatchFlash[questIndex]) then
				if (QuestGuru_WatchFlash[questIndex].fading == true) then
					QuestGuru_WatchLine[lastWatchIndex].fading = true;
					QuestGuru_WatchFlash[questIndex].fading = nil;
				end
			end
		end
	end

	-- Set tracking indicator
	if ( watchTextIndex > 1 ) then
		QuestGuru_QuestLogTrackTracking:SetVertexColor(0, 1.0, 0);
	else
		QuestGuru_QuestLogTrackTracking:SetVertexColor(1.0, 0, 0);
	end

    local watchLines = 30;
    if (QuestGuru_Settings and QuestGuru_Settings.Tracker and QuestGuru_Settings.Tracker.Lines) then
    	watchLines = QuestGuru_Settings.Tracker.Lines;
    end
	
	QuestGuru_WatchLines = watchTextIndex - 1;
	if (QuestGuru_WatchLines > watchLines) then
		QuestGuru_QuestWatchFrameSlider:SetMinMaxValues(0,QuestGuru_WatchLines - watchLines);
	else
		QuestGuru_QuestWatchFrameSlider:SetMinMaxValues(0,0);
	end

	-- If no watch lines used then hide the frame and return
	if (QuestGuru_WatchLines == 0) then
		QuestGuru_QuestWatchFrame:Hide();
		return;
	end
	
	if (QuestGuru_Settings.Tracker.Minimized) then
		if (QuestGuru_Settings.Tracker.AutoMinimize) then
			QuestGuru_QuestWatchFrameMinimize:SetText("*");
		else
			QuestGuru_QuestWatchFrameMinimize:SetText("+");
		end
		for i=1, 40 do
			getglobal("QuestGuru_QuestWatchLine"..i):Hide();
		end
	    QuestGuru_QuestWatchFrame:SetHeight(26);

		if (QuestGuru_Settings.Tracker.Left == nil) then
			QuestGuru_Settings.Tracker.Left = MinimapCluster:GetLeft();
		end
		if (QuestGuru_Settings.Tracker.Top == nil) then
		    QuestGuru_Settings.Tracker.Top = MinimapCluster:GetBottom()+10;
		end
		if (QuestGuru_Settings.Tracker.Bottom == nil) then
		    QuestGuru_Settings.Tracker.Bottom = 60;
		end
		if (not QuestGuru_QuestWatchFrame.isMoving) then
			QuestGuru_QuestWatchFrame:ClearAllPoints();
			if (QuestGuru_Settings.Tracker.Anchor == "TOP") then
				QuestGuru_QuestWatchFrame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", QuestGuru_Settings.Tracker.Left, QuestGuru_Settings.Tracker.Top);
			elseif (QuestGuru_Settings.Tracker.Anchor == "BOTTOM") then
				QuestGuru_QuestWatchFrame:SetPoint("BOTTOMLEFT", "UIParent", "BOTTOMLEFT", QuestGuru_Settings.Tracker.Left, QuestGuru_Settings.Tracker.Bottom);
			end
		end

	    QuestGuru_QuestWatchFrame:Show();
	    return;
	end
	if (QuestGuru_Settings.Tracker.AutoMinimize) then
		QuestGuru_QuestWatchFrameMinimize:SetText("*");
	else
		QuestGuru_QuestWatchFrameMinimize:SetText("-");
	end

	local numHeaders = 0;
	local numTitles = 0;
    local sliderVal = QuestGuru_QuestWatchFrameSlider:GetValue();
    local i, j, lastQuestWatch;
	for i= 1, QuestGuru_WatchLines do
        j = i - sliderVal;
	    if (j > watchLines) then
			j = j - 1;
			break;
		end
	    if (i > sliderVal) then
			watchText = getglobal("QuestGuru_QuestWatchLine"..j);
			watchTextTag = getglobal("QuestGuru_QuestWatchLine"..j.."Tag");
			watchNormalText = getglobal("QuestGuru_QuestWatchLine"..j.."NormalText");
			watchTextHighlight = getglobal("QuestGuru_QuestWatchLine"..j.."Highlight");
			watchText:SetText(QuestGuru_WatchLine[i].Text);
			if (QuestGuru_WatchLine[i].TextColor == nil) then
			    watchText:SetTextColor(1, 1, 1);
			else
				watchText:SetTextColor(QuestGuru_WatchLine[i].TextColor.r,QuestGuru_WatchLine[i].TextColor.g,QuestGuru_WatchLine[i].TextColor.b);
			end
			watchText.qID = QuestGuru_WatchLine[i].qID;
			watchTextTag:SetText(QuestGuru_WatchLine[i].Tag);
		    watchTextTag:Show();

			if (QuestGuru_WatchLine[i].isHeader == true) then
				if ( j > 1 ) then
					watchText:SetPoint("TOPLEFT", "QuestGuru_QuestWatchLine"..(j - 1), "BOTTOMLEFT", 0, -6);
					numHeaders = numHeaders + 1;
				end
				watchText:SetNormalTexture("Interface\\Buttons\\UI-SortArrow");
				watchNormalText:SetPoint("LEFT", "QuestGuru_QuestWatchLine"..j, "LEFT", 8, 0);
				if (QuestGuru_WatchHeaders[QuestGuru_WatchLine[i].Text] ~= false) then
					QuestGuru_WatchHeaders[QuestGuru_WatchLine[i].Text] = true;
					getglobal("QuestGuru_QuestWatchLine"..j.."Arrow"):SetTexCoord(0, 0.5, 0, 1);
				else
					getglobal("QuestGuru_QuestWatchLine"..j.."Arrow"):SetTexCoord(0.5, 0, 0, 0, 0.5, 1, 0, 1);
				end
			elseif (QuestGuru_WatchLine[i].isTitle == true) then
				if ( j > 1 ) then
					watchText:SetPoint("TOPLEFT", "QuestGuru_QuestWatchLine"..(j - 1), "BOTTOMLEFT", 0, -4);
				    numTitles = numTitles + 1;
				end
				watchText:SetNormalTexture("");
				watchNormalText:SetPoint("LEFT", "QuestGuru_QuestWatchLine"..j, "LEFT", 0, 0);
				if (not QuestGuru_Settings.Tracker.ShowQuestPercent) then
				    watchTextTag:Hide();
				end
			else
			    if (j > 1) then
					watchText:SetPoint("TOPLEFT", "QuestGuru_QuestWatchLine"..(j - 1), "BOTTOMLEFT", 0, 0);
				end
				watchText:SetNormalTexture("");
				watchNormalText:SetPoint("LEFT", "QuestGuru_QuestWatchLine"..j, "LEFT", 0, 0);
			end
			local tempWidth = watchTextTag:GetWidth() + 8;
			watchNormalText:SetWidth(240 - tempWidth);
			if (QuestGuru_WatchLine[i].fading) then
				watchText.fading = 1;
				watchText:SetScript("OnUpdate", QuestGuru_QuestWatchButton_OnUpdate);
				watchTextHighlight:SetAlpha(1);
				watchTextHighlight:Show();
			end
			watchText:Show();
			lastQuestWatch = j;
		end
	end

	QuestGuru_QuestWatchFrame:Show();
	local tempHeight = (numHeaders*6)+(numTitles*4)+((lastQuestWatch+1)*13)+16;
	QuestGuru_QuestWatchFrame:SetHeight(tempHeight);
	QuestGuru_QuestWatchFrameSlider:SetHeight(tempHeight - 20);
	QuestGuru_QuestWatchFrame:SetWidth(256);
	if (QuestGuru_Settings.Tracker.Left == nil) then
		QuestGuru_Settings.Tracker.Left = MinimapCluster:GetLeft();
	end
	if (QuestGuru_Settings.Tracker.Top == nil) then
	    QuestGuru_Settings.Tracker.Top = MinimapCluster:GetBottom()+10;
	end
	if (QuestGuru_Settings.Tracker.Bottom == nil) then
	    QuestGuru_Settings.Tracker.Bottom = 60;
	end
	if (not QuestGuru_QuestWatchFrame.isMoving) then
		QuestGuru_QuestWatchFrame:ClearAllPoints();
		if (QuestGuru_Settings.Tracker.Anchor == "TOP") then
			QuestGuru_QuestWatchFrame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", QuestGuru_Settings.Tracker.Left, QuestGuru_Settings.Tracker.Top);
			QuestGuru_Settings.Tracker.Bottom = QuestGuru_QuestWatchFrame:GetBottom();
		elseif (QuestGuru_Settings.Tracker.Anchor == "BOTTOM") then
			QuestGuru_QuestWatchFrame:SetPoint("BOTTOMLEFT", "UIParent", "BOTTOMLEFT", QuestGuru_Settings.Tracker.Left, QuestGuru_Settings.Tracker.Bottom);
			QuestGuru_Settings.Tracker.Top = QuestGuru_QuestWatchFrame:GetTop();
		end
	end
    QuestGuru_QuestWatchFrameSlider:ClearAllPoints();
    if (((QuestGuru_Settings.Tracker.Left + 256) * QuestGuru_Settings.Tracker.Scale) > (UIParent:GetWidth() - 16)) then
		QuestGuru_QuestWatchFrameSlider:SetPoint("TOPLEFT", -14, -20);
    else
		QuestGuru_QuestWatchFrameSlider:SetPoint("TOPRIGHT", 14, -20);
    end
	-- Hide unused watch lines
	for i=j + 1, 40 do
		getglobal("QuestGuru_QuestWatchLine"..i):Hide();
	end

	if (IsAddOnLoaded("MobMap")) then
		for i=1, 40 do
			local frame=getglobal("QuestGuru_QuestWatchLine"..i);
			local button=getglobal("MobMapQuestGuruWatchButton"..i);
			if (frame:IsVisible() and mobmap_hide_questtracker_buttons==false) then
				local questobj=frame:GetText();
				if(questobj) then
					if (button==nil) then
						button = CreateFrame("Frame","MobMapQuestGuruWatchButton"..i, frame, "MobMapQuestButtonFrameTemplate");
						button:ClearAllPoints();
						button:SetPoint("RIGHT","QuestGuru_QuestWatchLine"..i,"LEFT",-6,0);
						button:SetAlpha(0.6);
						button:SetFrameStrata("LOW");
						getglobal(button:GetName().."Button"):SetScript("OnEnter",
							function ()
								QuestGuru_ShowTrackerSlider(true);
								GameTooltip_AddNewbieTip("MobMap",1.0,1.0,1.0,MOBMAP_QUEST_BUTTON_TOOLTIP);
							end);
						getglobal(button:GetName().."Button"):SetScript("OnLeave",
							function ()
								QuestGuru_ShowTrackerSlider(false);
								GameTooltip:Hide();
							end);
					end
					if (string.sub(questobj,1,3)==" - ") then
						button.questobj=string.sub(questobj,4);
						button.questtitle=nil;
						button.unknowntext=nil;
						button:Show();
					else
						local title=questobj;
						if(title~=nil) then
							local filteredtitle=string.match(title,".*%] (.*)");
							if(filteredtitle~=nil) then
								title=filteredtitle;
							end
						end
						button.questtitle=title;
						button.questobj=nil;
						button.unknowntext=nil;
						button:Show();
					end
				end
			else
				if (button) then
					button:Hide();
				end
			end
		end
	end
end

function QuestGuru_QuestWatchGetObjColor(progress, alwaysColor)
	local r, g, b;
	if (QuestGuru_Settings.Tracker.ColorizeObj or alwaysColor) then
		if (progress == 1) then
			r = QuestGuru_Settings.Tracker.ColorizeObjComplete.r;
			g = QuestGuru_Settings.Tracker.ColorizeObjComplete.g;
			b = QuestGuru_Settings.Tracker.ColorizeObjComplete.b;
		else
			r = QuestGuru_Settings.Tracker.ColorizeObjZero.r + ((QuestGuru_Settings.Tracker.ColorizeObjFull.r - QuestGuru_Settings.Tracker.ColorizeObjZero.r) * progress);
			g = QuestGuru_Settings.Tracker.ColorizeObjZero.g + ((QuestGuru_Settings.Tracker.ColorizeObjFull.g - QuestGuru_Settings.Tracker.ColorizeObjZero.g) * progress);
			b = QuestGuru_Settings.Tracker.ColorizeObjZero.b + ((QuestGuru_Settings.Tracker.ColorizeObjFull.b - QuestGuru_Settings.Tracker.ColorizeObjZero.b) * progress);
		end
	else
	    if (progress == 1) then
	        r = HIGHLIGHT_FONT_COLOR.r;
	        g = HIGHLIGHT_FONT_COLOR.g;
	        b = HIGHLIGHT_FONT_COLOR.b;
	    else
	        r = GRAY_FONT_COLOR.r;
			g = GRAY_FONT_COLOR.g;
			b = GRAY_FONT_COLOR.b;
	    end
	end
	return r, g, b;
end

local old_AddQuestWatch = AddQuestWatch;
function AddQuestWatch(questIndex, watchTime)
	if (not QuestGuru_Settings.Tracker.Enabled) then
	    return old_AddQuestWatch(questIndex, watchTime);
	end
	local questLogTitleText, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(questIndex);
	if (isHeader) then
		QuestGuru_AddQuestWatchHeader(questLogTitleText);
		return false;
	end
	if (QuestGuru_WatchList[questLogTitleText] == nil) then
	    QuestGuru_WatchList[questLogTitleText] = {};
	end
	if (QuestGuru_WatchList[questLogTitleText].Watched) then
	    return true;
	end
	QuestGuru_WatchList[questLogTitleText].Watched = true;
	return true;
end

function QuestGuru_AddQuestWatchHeader(questHeader)
	local numEntries, numQuests = GetNumQuestLogEntries();
	local inHeader = false;

	for questIndex=1, numEntries do
		local questLogTitleText, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(questIndex);
		if (isHeader) then
			if (questLogTitleText == questHeader) then
		    	inHeader = true;
		    else
		    	inHeader = false;
		    end
		end
		if (inHeader and (not isHeader)) then
			AddQuestWatch(questIndex);
		end
	end
end

local old_RemoveQuestWatch = RemoveQuestWatch;
function RemoveQuestWatch(questIndex, ...)
	if (not QuestGuru_Settings.Tracker.Enabled) then
	    old_RemoveQuestWatch(questIndex);
	    return;
	end
	local questLogTitleText, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(questIndex);
	if (isHeader) then
		QuestGuru_RemoveQuestWatchHeader(questLogTitleText);
	end
	QuestGuru_WatchList[questLogTitleText] = nil;
	QuestGuru_WatchQuests[questLogTitleText] = nil;
	QuestWatch_Update();
end

function QuestGuru_RemoveQuestWatchHeader(questHeader)
	local numEntries, numQuests = GetNumQuestLogEntries();
	local inHeader = false;

	for questIndex=1, numEntries do
		local questLogTitleText, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(questIndex);
		if (isHeader) then
			if (questLogTitleText == questHeader) then
		    	inHeader = true;
		    else
		    	inHeader = false;
		    end
		end
		if (inHeader and (not isHeader)) then
			RemoveQuestWatch(questIndex);
		end
	end
end

local old_IsQuestWatched = IsQuestWatched;
function IsQuestWatched(questIndex, ...)
	if (not QuestGuru_Settings.Tracker.Enabled) then
	    return old_IsQuestWatched(questIndex);
	end
	local questLogTitleText, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(questIndex);
	if (QuestGuru_WatchList[questLogTitleText] == nil) then
		return false;
	end
	return QuestGuru_WatchList[questLogTitleText].Watched;
end

function QuestGuru_QuestWatchLoadSettings()
	if (QuestGuru_WatchHeaders == nil) then
	    QuestGuru_WatchHeaders = {};
	end
	if (QuestGuru_WatchQuests == nil) then
	    QuestGuru_WatchQuests = {};
	end

	if (QuestGuru_Settings.Tracker == nil) then
	    QuestGuru_Settings.Tracker = {};
	end
	if (QuestGuru_Settings.Tracker.Enabled ~= false) then
	    QuestGuru_Settings.Tracker.Enabled = true;
	end
	QuestGuru_OptionsFrameTrackerEnabledToggle:SetChecked(QuestGuru_Settings.Tracker.Enabled);
	if (QuestGuru_Settings.Tracker.Scale == nil) then
	    QuestGuru_Settings.Tracker.Scale = 0.9;
	end
	QuestGuru_OptionsFrameTrackerScaleText:SetText("Tracker Size ("..ceil((QuestGuru_Settings.Tracker.Scale * 100)-0.5).."%)");
	QuestGuru_OptionsFrameTrackerScale:SetValue(QuestGuru_Settings.Tracker.Scale);
	QuestGuru_QuestWatchFrame:SetScale(QuestGuru_Settings.Tracker.Scale);
	
	if (QuestGuru_Settings.Tracker.Lines == nil) then
		QuestGuru_Settings.Tracker.Lines = 30;
	end
	QuestGuru_OptionsFrameTrackerLinesText:SetText("Max. Tracker Lines: "..QuestGuru_Settings.Tracker.Lines);
	QuestGuru_OptionsFrameTrackerLines:SetValue(QuestGuru_Settings.Tracker.Lines);
	
	if (QuestGuru_Settings.Tracker.Minimized ~= true) then
	    QuestGuru_Settings.Tracker.Minimized = false;
	end
	if (QuestGuru_Settings.Tracker.AutoMinimize ~= true) then
		QuestGuru_Settings.Tracker.AutoMinimize = false;
	end
	if (QuestGuru_Settings.Tracker.Anchor == nil) then
	    QuestGuru_Settings.Tracker.Anchor = "TOP";
	end
	if (QuestGuru_Settings.Tracker.Anchor == "BOTTOM") then
		QuestGuru_OptionsFrameTrackerExpandUpToggle:SetChecked(true);
	else
	    QuestGuru_OptionsFrameTrackerExpandUpToggle:SetChecked(false);
	end

	if (QuestGuru_Settings.Tracker.Alpha == nil) then
		QuestGuru_Settings.Tracker.Alpha = 0.7;
	end
	QuestGuru_QuestWatchFrame:SetBackdropColor(0,0,0,QuestGuru_Settings.Tracker.Alpha);
	QuestGuru_OptionsFrameTrackerAlphaText:SetText("Background Alpha ("..abs(ceil((QuestGuru_Settings.Tracker.Alpha * 100)-0.5)).."%)");
	QuestGuru_OptionsFrameTrackerAlpha:SetValue(QuestGuru_Settings.Tracker.Alpha);

	if (QuestGuru_Settings.Tracker.ShowHeaders ~= false) then
		QuestGuru_Settings.Tracker.ShowHeaders = true;
	end
	QuestGuru_OptionsFrameTrackerHeadersToggle:SetChecked(QuestGuru_Settings.Tracker.ShowHeaders);

	if (QuestGuru_Settings.Tracker.ShowBorder ~= false) then
		QuestGuru_Settings.Tracker.ShowBorder = true;
	end
	QuestGuru_OptionsFrameTrackerBorderToggle:SetChecked(QuestGuru_Settings.Tracker.ShowBorder);
	QuestGuru_SetWatchBorder(QuestGuru_Settings.Tracker.ShowBorder);

	if (QuestGuru_Settings.Tracker.ShowLevels ~= false) then
	    QuestGuru_Settings.Tracker.ShowLevels = true;
	end
	QuestGuru_OptionsFrameTrackerShowLevelsToggle:SetChecked(QuestGuru_Settings.Tracker.ShowLevels);

	if (QuestGuru_Settings.Tracker.AutoTrack ~= false) then
	    QuestGuru_Settings.Tracker.AutoTrack = true;
	end
	QuestGuru_OptionsFrameTrackerAutoTrackToggle:SetChecked(QuestGuru_Settings.Tracker.AutoTrack);

	if (QuestGuru_Settings.Tracker.AutoUnTrack ~= true) then
	    QuestGuru_Settings.Tracker.AutoUnTrack = false;
	end
	QuestGuru_OptionsFrameTrackerAutoUnTrackToggle:SetChecked(QuestGuru_Settings.Tracker.AutoUnTrack);

	if (QuestGuru_Settings.Tracker.ShowCompletedObj ~= false) then
	    QuestGuru_Settings.Tracker.ShowCompletedObj = true;
	end
	QuestGuru_OptionsFrameTrackerShowCompletedObjToggle:SetChecked(QuestGuru_Settings.Tracker.ShowCompletedObj);

	if (QuestGuru_Settings.Tracker.ColorizeObj ~= true) then
	    QuestGuru_Settings.Tracker.ColorizeObj = false;
	end
	QuestGuru_OptionsFrameTrackerColorizeObjToggle:SetChecked(QuestGuru_Settings.Tracker.ColorizeObj);
	
	if (QuestGuru_Settings.Tracker.ColorizeObjZero == nil) then
	    QuestGuru_Settings.Tracker.ColorizeObjZero = {};
	    QuestGuru_Settings.Tracker.ColorizeObjZero.r = 0.8;
	    QuestGuru_Settings.Tracker.ColorizeObjZero.g = 0.2;
	    QuestGuru_Settings.Tracker.ColorizeObjZero.b = 0.8;
	end
	if (QuestGuru_Settings.Tracker.ColorizeObjFull == nil) then
	    QuestGuru_Settings.Tracker.ColorizeObjFull = {};
	    QuestGuru_Settings.Tracker.ColorizeObjFull.r = 0.3;
	    QuestGuru_Settings.Tracker.ColorizeObjFull.g = 0.8;
	    QuestGuru_Settings.Tracker.ColorizeObjFull.b = 1.0;
	end
	if (QuestGuru_Settings.Tracker.ColorizeObjComplete == nil) then
	    QuestGuru_Settings.Tracker.ColorizeObjComplete = {};
	    QuestGuru_Settings.Tracker.ColorizeObjComplete.r = 0.1;
	    QuestGuru_Settings.Tracker.ColorizeObjComplete.g = 0.9;
	    QuestGuru_Settings.Tracker.ColorizeObjComplete.b = 1.0;
	end

	if (QuestGuru_Settings.Tracker.ClickThrough ~= true) then
		QuestGuru_Settings.Tracker.ClickThrough = false;
	end
	QuestGuru_OptionsFrameTrackerClickThroughToggle:SetChecked(QuestGuru_Settings.Tracker.ClickThrough);

	if (QuestGuru_Settings.Tracker.ShowQuestTooltips ~= false) then
		QuestGuru_Settings.Tracker.ShowQuestTooltips = true;
	end
	QuestGuru_OptionsFrameTrackerQuestTooltipsToggle:SetChecked(QuestGuru_Settings.Tracker.ShowQuestTooltips);

	if (QuestGuru_Settings.Tracker.ShowPartyTooltips ~= false) then
		QuestGuru_Settings.Tracker.ShowPartyTooltips = true;
	end
	QuestGuru_OptionsFrameTrackerPartyTooltipsToggle:SetChecked(QuestGuru_Settings.Tracker.ShowPartyTooltips);

	if (QuestGuru_Settings.Tracker.ShowQuestPercent ~= false) then
		QuestGuru_Settings.Tracker.ShowQuestPercent = true;
	end
	QuestGuru_OptionsFrameTrackerQuestPercentToggle:SetChecked(QuestGuru_Settings.Tracker.ShowQuestPercent);
end