local lastColorPick;

QuestGuru_Sounds = {"PVPENTERQUEUE","PVPTHROUGHQUEUE","GLUECREATECHARACTERBUTTON","GLUEENTERWORLDBUTTON","QUESTCOMPLETED","INTERFACESOUND_MONEYFRAMEOPEN",
"igPlayerInvite","LEVELUP","QUESTADDED","gsCharacterCreationCreateChar","TalentScreenOpen","ReadyCheck","RaidWarning","AuctionWindowOpen","AuctionWindowClose",
"Sound\\Creature\\Peon\\PeonBuildingComplete1.wav", "Sound\\Creature\\Peon\\PeonReady1.wav", "Sound\\Creature\\Peasant\\PeasantReady1.wav", "Sound\\Interface\\igPlayerBind.wav",
"Sound\\Creature\\MillhouseManastorm\\TEMPEST_Millhouse_Ready01.wav", "Sound\\Creature\\MillhouseManastorm\\TEMPEST_Millhouse_Slay01.wav"};

function QuestGuru_OptionsFrameSoundProgressDropDown_Initialize()
	if (QuestGuru_Settings.Sounds == nil) then return; end
	local info = UIDropDownMenu_CreateInfo();
	info.func = QuestGuru_OptionsFrameSoundProgress_OnClick;
	info.owner = QuestGuru_OptionsFrameSoundProgressButton;
	info.checked = nil;
	info.icon = nil;

	for i,v in ipairs(QuestGuru_Sounds) do
	    info.text = v;
	    info.value = i;
	    if (v == QuestGuru_Settings.Sounds.Progress.Sound) then
	        info.checked = 1;
		else
		    info.checked = nil;
		end
	    UIDropDownMenu_AddButton(info, 1);
	end
	UIDropDownMenu_SetText(QuestGuru_Settings.Sounds.Progress.Sound, QuestGuru_OptionsFrameSoundProgressButton);
end

function QuestGuru_OptionsFrameSoundProgress_OnClick()
	if (QuestGuru_Settings.Sounds == nil) then return; end
	local sound = QuestGuru_Sounds[this.value];
	if ((string.sub(sound, -4) == ".wav") or (string.sub(sound, -4) == ".mp3")) then
	    PlaySoundFile(sound);
	else
		PlaySound(sound);
	end
	UIDropDownMenu_SetText(sound, QuestGuru_OptionsFrameSoundProgressButton);
	QuestGuru_Settings.Sounds.Progress.Sound = sound;
end

function QuestGuru_OptionsFrameSoundObjCompleteDropDown_Initialize()
	if (QuestGuru_Settings.Sounds == nil) then return; end
	local info = UIDropDownMenu_CreateInfo();
	info.func = QuestGuru_OptionsFrameSoundObjComplete_OnClick;
	info.owner = QuestGuru_OptionsFrameSoundObjCompleteButton;
	info.checked = nil;
	info.icon = nil;

	for i,v in ipairs(QuestGuru_Sounds) do
	    info.text = v;
	    info.value = i;
	    if (v == QuestGuru_Settings.Sounds.ObjComplete.Sound) then
	        info.checked = 1;
		else
		    info.checked = nil;
		end
	    UIDropDownMenu_AddButton(info, 1);
	end
	UIDropDownMenu_SetText(QuestGuru_Settings.Sounds.ObjComplete.Sound, QuestGuru_OptionsFrameSoundObjCompleteButton);
end

function QuestGuru_OptionsFrameSoundObjComplete_OnClick()
	if (QuestGuru_Settings.Sounds == nil) then return; end
	local sound = QuestGuru_Sounds[this.value];
	if ((string.sub(sound, -4) == ".wav") or (string.sub(sound, -4) == ".mp3")) then
	    PlaySoundFile(sound);
	else
		PlaySound(sound);
	end
	UIDropDownMenu_SetText(sound, QuestGuru_OptionsFrameSoundObjCompleteButton);
	QuestGuru_Settings.Sounds.ObjComplete.Sound = sound;
end

function QuestGuru_OptionsFrameSoundQuestCompleteDropDown_Initialize()
	if (QuestGuru_Settings.Sounds == nil) then return; end
	local info = UIDropDownMenu_CreateInfo();
	info.func = QuestGuru_OptionsFrameSoundQuestComplete_OnClick;
	info.owner = QuestGuru_OptionsFrameSoundQuestCompleteButton;
	info.checked = nil;
	info.icon = nil;

	for i,v in ipairs(QuestGuru_Sounds) do
	    info.text = v;
	    info.value = i;
	    if (v == QuestGuru_Settings.Sounds.QuestComplete.Sound) then
	        info.checked = 1;
		else
		    info.checked = nil;
		end
	    UIDropDownMenu_AddButton(info, 1);
	end
	UIDropDownMenu_SetText(QuestGuru_Settings.Sounds.QuestComplete.Sound, QuestGuru_OptionsFrameSoundQuestCompleteButton);
end

function QuestGuru_OptionsFrameSoundQuestComplete_OnClick()
	if (QuestGuru_Settings.Sounds == nil) then return; end
	local sound = QuestGuru_Sounds[this.value];
	if ((string.sub(sound, -4) == ".wav") or (string.sub(sound, -4) == ".mp3")) then
	    PlaySoundFile(sound);
	else
		PlaySound(sound);
	end
	UIDropDownMenu_SetText(sound, QuestGuru_OptionsFrameSoundQuestCompleteButton);
	QuestGuru_Settings.Sounds.QuestComplete.Sound = sound;
end

do
	local temp, i;

---------------------
-- General Options --
---------------------
	QuestGuru_OptionsFrameGeneral = CreateFrame("FRAME", "QuestGuru_OptionsFrameGeneral", QuestGuru_OptionsFrame);
	QuestGuru_OptionsFrameGeneral.name = "QuestGuru";
	QuestGuru_OptionsFrameGeneral.default = function () QuestGuru_SetGeneralDefaults(); end;
	InterfaceOptions_AddCategory(QuestGuru_OptionsFrameGeneral);

	QuestGuru_OptionsFrameGeneralTitle = QuestGuru_OptionsFrameGeneral:CreateFontString("QuestGuru_OptionsFrameGeneralTitle", "ARTWORK", "GameFontNormalLarge");
	QuestGuru_OptionsFrameGeneralTitle:SetPoint("TOPLEFT", 16, -16);
	QuestGuru_OptionsFrameGeneralTitle:SetJustifyH("LEFT");
	QuestGuru_OptionsFrameGeneralTitle:SetJustifyV("TOP");
	QuestGuru_OptionsFrameGeneralTitle:SetText("QuestGuru Options");

	QuestGuru_OptionsFrameGeneralSubText = QuestGuru_OptionsFrameGeneral:CreateFontString("QuestGuru_OptionsFrameGeneralSubText", "ARTWORK", "GameFontHighlightSmall");
	QuestGuru_OptionsFrameGeneralSubText:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameGeneralTitle", "BOTTOMLEFT", 0, -8);
	QuestGuru_OptionsFrameGeneralSubText:SetPoint("RIGHT", -32, 0);
	QuestGuru_OptionsFrameGeneralSubText:SetJustifyH("LEFT");
	QuestGuru_OptionsFrameGeneralSubText:SetJustifyV("TOP");
	QuestGuru_OptionsFrameGeneralSubText:SetHeight(24);
	QuestGuru_OptionsFrameGeneralSubText:SetText("These options change general settings for QuestGuru.\nChanges to these settings are saved immediately.");

	QuestGuru_OptionsFrameGeneralColorize = QuestGuru_OptionsFrameGeneral:CreateFontString("QuestGuru_OptionsFrameGeneralColorize", "OVERLAY", "GameFontHighlight");
	QuestGuru_OptionsFrameGeneralColorize:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameGeneralSubText", "BOTTOMLEFT", -2, -8);
	QuestGuru_OptionsFrameGeneralColorize:SetText("Colorize");

	QuestGuru_OptionsFrameColorizePlayerNameToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameColorizePlayerNameToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameColorizePlayerNameToggle:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameGeneralColorize", "BOTTOMLEFT", 0, -4);
	QuestGuru_OptionsFrameColorizePlayerNameToggleText:SetText("Player Name");
	QuestGuru_OptionsFrameColorizePlayerNameToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameColorizePlayerNameToggle:GetChecked()) then
				QuestGuru_Settings.Colorize.PlayerName.Enabled = true;
			else
				QuestGuru_Settings.Colorize.PlayerName.Enabled = false;
			end
		end);
		
	QuestGuru_OptionsFrameColorizePlayerNameColor = CreateFrame("Button", "QuestGuru_OptionsFrameColorizePlayerNameColor", QuestGuru_OptionsFrameGeneral, "QuestGuru_ColorPickerButtonTemplate");
	QuestGuru_OptionsFrameColorizePlayerNameColor:SetPoint("LEFT", QuestGuru_OptionsFrameColorizePlayerNameToggle, "RIGHT", 80, 0);
	QuestGuru_OptionsFrameColorizePlayerNameColorSwatch:SetTexture(1.0, 1.0, 1.0, 1.0);
	QuestGuru_OptionsFrameColorizePlayerNameColor:SetScript("OnClick",
		function ()
			ColorPickerFrame.hasOpacity = false;
			ColorPickerFrame.func = QuestGuru_OptionsSaveColor;
			lastColorPick = "PlayerName";
			ColorPickerFrame:SetColorRGB(QuestGuru_Settings.Colorize.PlayerName.Color.r, QuestGuru_Settings.Colorize.PlayerName.Color.g, QuestGuru_Settings.Colorize.PlayerName.Color.b);
			ColorPickerFrame:Show();
			ColorPickerFrame:SetPoint("TOPLEFT", InterfaceOptionsFrame, "TOPRIGHT", -50, 0);
		end);

	QuestGuru_OptionsFrameColorizeAreaNamesToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameColorizeAreaNamesToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameColorizeAreaNamesToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameColorizePlayerNameToggle, "BOTTOMLEFT", 0, -2);
	QuestGuru_OptionsFrameColorizeAreaNamesToggleText:SetText("Area Names");
	QuestGuru_OptionsFrameColorizeAreaNamesToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameColorizeAreaNamesToggle:GetChecked()) then
				QuestGuru_Settings.Colorize.AreaNames.Enabled = true;
			else
				QuestGuru_Settings.Colorize.AreaNames.Enabled = false;
			end
		end);
		
	QuestGuru_OptionsFrameColorizeAreaNamesColor = CreateFrame("Button", "QuestGuru_OptionsFrameColorizeAreaNamesColor", QuestGuru_OptionsFrameGeneral, "QuestGuru_ColorPickerButtonTemplate");
	QuestGuru_OptionsFrameColorizeAreaNamesColor:SetPoint("LEFT", QuestGuru_OptionsFrameColorizeAreaNamesToggle, "RIGHT", 80, 0);
	QuestGuru_OptionsFrameColorizeAreaNamesColorSwatch:SetTexture(1.0, 1.0, 1.0, 1.0);
	QuestGuru_OptionsFrameColorizeAreaNamesColor:SetScript("OnClick",
		function ()
			ColorPickerFrame.hasOpacity = false;
			ColorPickerFrame.func = QuestGuru_OptionsSaveColor;
			lastColorPick = "AreaNames";
			ColorPickerFrame:SetColorRGB(QuestGuru_Settings.Colorize.AreaNames.Color.r, QuestGuru_Settings.Colorize.AreaNames.Color.g, QuestGuru_Settings.Colorize.AreaNames.Color.b);
			ColorPickerFrame:Show();
			ColorPickerFrame:SetPoint("TOPLEFT", InterfaceOptionsFrame, "TOPRIGHT", -50, 0);
		end);

	QuestGuru_OptionsFrameColorizeNPCNamesToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameColorizeNPCNamesToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameColorizeNPCNamesToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameColorizeAreaNamesToggle, "BOTTOMLEFT", 0, -2);
	QuestGuru_OptionsFrameColorizeNPCNamesToggleText:SetText("NPC Names");
	QuestGuru_OptionsFrameColorizeNPCNamesToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameColorizeNPCNamesToggle:GetChecked()) then
				QuestGuru_Settings.Colorize.NPCNames.Enabled = true;
			else
				QuestGuru_Settings.Colorize.NPCNames.Enabled = false;
			end
		end);
		
	QuestGuru_OptionsFrameColorizeNPCNamesColor = CreateFrame("Button", "QuestGuru_OptionsFrameColorizeNPCNamesColor", QuestGuru_OptionsFrameGeneral, "QuestGuru_ColorPickerButtonTemplate");
	QuestGuru_OptionsFrameColorizeNPCNamesColor:SetPoint("LEFT", QuestGuru_OptionsFrameColorizeNPCNamesToggle, "RIGHT", 80, 0);
	QuestGuru_OptionsFrameColorizeNPCNamesColorSwatch:SetTexture(1.0, 1.0, 1.0, 1.0);
	QuestGuru_OptionsFrameColorizeNPCNamesColor:SetScript("OnClick",
		function ()
			ColorPickerFrame.hasOpacity = false;
			ColorPickerFrame.func = QuestGuru_OptionsSaveColor;
			lastColorPick = "NPCNames";
			ColorPickerFrame:SetColorRGB(QuestGuru_Settings.Colorize.NPCNames.Color.r, QuestGuru_Settings.Colorize.NPCNames.Color.g, QuestGuru_Settings.Colorize.NPCNames.Color.b);
			ColorPickerFrame:Show();
			ColorPickerFrame:SetPoint("TOPLEFT", InterfaceOptionsFrame, "TOPRIGHT", -50, 0);
		end);


	QuestGuru_OptionsFrameGeneralShowLevels = QuestGuru_OptionsFrameGeneral:CreateFontString("QuestGuru_OptionsFrameGeneralShowLevels", "OVERLAY", "GameFontHighlight");
	QuestGuru_OptionsFrameGeneralShowLevels:SetPoint("TOP", "QuestGuru_OptionsFrameGeneralSubText", "BOTTOM", 0, -8);
	QuestGuru_OptionsFrameGeneralShowLevels:SetPoint("LEFT", 200, 0);
	QuestGuru_OptionsFrameGeneralShowLevels:SetText("Show Levels");

	QuestGuru_OptionsFrameShowLevelsQuestLogToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameShowLevelsQuestLogToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameShowLevelsQuestLogToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameGeneralShowLevels, "BOTTOMLEFT", 0, -4);
	QuestGuru_OptionsFrameShowLevelsQuestLogToggleText:SetText("In Quest Log");
	QuestGuru_OptionsFrameShowLevelsQuestLogToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameShowLevelsQuestLogToggle:GetChecked()) then
				QuestGuru_Settings.ShowLevels.QuestLog = true;
			else
				QuestGuru_Settings.ShowLevels.QuestLog = false;
			end
			QuestLog_Update();
		end);

	QuestGuru_OptionsFrameShowLevelsHistoryToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameShowLevelsHistoryToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameShowLevelsHistoryToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameShowLevelsQuestLogToggle, "BOTTOMLEFT", 0, -2);
	QuestGuru_OptionsFrameShowLevelsHistoryToggleText:SetText("In History Log");
	QuestGuru_OptionsFrameShowLevelsHistoryToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameShowLevelsHistoryToggle:GetChecked()) then
				QuestGuru_Settings.ShowLevels.History = true;
			else
				QuestGuru_Settings.ShowLevels.History = false;
			end
			QuestGuru_UpdateHistory();
		end);

	QuestGuru_OptionsFrameShowLevelsAbandonToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameShowLevelsAbandonToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameShowLevelsAbandonToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameShowLevelsHistoryToggle, "BOTTOMLEFT", 0, -2);
	QuestGuru_OptionsFrameShowLevelsAbandonToggleText:SetText("In Abandon Log");
	QuestGuru_OptionsFrameShowLevelsAbandonToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameShowLevelsAbandonToggle:GetChecked()) then
				QuestGuru_Settings.ShowLevels.Abandon = true;
			else
				QuestGuru_Settings.ShowLevels.Abandon = false;
			end
			QuestGuru_UpdateAbandon();
		end);

	QuestGuru_OptionsFrameShowTooltipTextToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameShowTooltipTextToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameShowTooltipTextToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameColorizeNPCNamesToggle, "BOTTOMLEFT", 0, -10);
	QuestGuru_OptionsFrameShowTooltipTextToggleText:SetText("Show text in item and mob Tooltips");
	QuestGuru_OptionsFrameShowTooltipTextToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameShowTooltipTextToggle:GetChecked()) then
				QuestGuru_Settings.TooltipText = true;
			else
				QuestGuru_Settings.TooltipText = false;
			end
		end);

	QuestGuru_OptionsFrameAutoCompleteToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameAutoCompleteToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameAutoCompleteToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameShowTooltipTextToggle, "BOTTOMLEFT", 0, -6);
	QuestGuru_OptionsFrameAutoCompleteToggleText:SetText("AutoComplete Quests");
	QuestGuru_OptionsFrameAutoCompleteToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameAutoCompleteToggle:GetChecked()) then
				QuestGuru_Settings.AutoComplete = true;
			else
				QuestGuru_Settings.AutoComplete = false;
			end
		end);

	QuestGuru_OptionsFrameAltStatusToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameAltStatusToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameAltStatusToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameAutoCompleteToggle, "BOTTOMLEFT", 0, -6);
	QuestGuru_OptionsFrameAltStatusToggleText:SetText("Show Alts Quest Status in party tooltip");
	QuestGuru_OptionsFrameAltStatusToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameAltStatusToggle:GetChecked()) then
				QuestGuru_Settings.ShowAltStatus = true;
			else
				QuestGuru_Settings.ShowAltStatus = false;
			end
		end);

	QuestGuru_OptionsFrameGuildStatusToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameGuildStatusToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameGuildStatusToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameAltStatusToggle, "BOTTOMLEFT", 0, 0);
	QuestGuru_OptionsFrameGuildStatusToggleText:SetText("Show Guild Members Status in party tooltip");
	QuestGuru_OptionsFrameGuildStatusToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameGuildStatusToggle:GetChecked()) then
				QuestGuru_Settings.ShowGuildStatus = true;
			    QuestGuru_OptionsFrameSimpleGuildStatusToggle:Enable();
			else
				QuestGuru_Settings.ShowGuildStatus = false;
			    QuestGuru_OptionsFrameSimpleGuildStatusToggle:Disable();
			end
		end);

	QuestGuru_OptionsFrameSimpleGuildStatusToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameSimpleGuildStatusToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameSimpleGuildStatusToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameGuildStatusToggle, "BOTTOMLEFT", 24, 0);
	QuestGuru_OptionsFrameSimpleGuildStatusToggleText:SetText("Simple Guild Member display");
	QuestGuru_OptionsFrameSimpleGuildStatusToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameSimpleGuildStatusToggle:GetChecked()) then
				QuestGuru_Settings.ShowSimpleGuildStatus = true;
			else
				QuestGuru_Settings.ShowSimpleGuildStatus = false;
			end
		end);
	QuestGuru_OptionsFrameSimpleGuildStatusToggle:SetScript("OnUpdate",
		function ()
			if (QuestGuru_OptionsFrameSimpleGuildStatusToggle:IsEnabled() == 1) then
				QuestGuru_OptionsFrameSimpleGuildStatusToggleText:SetTextColor(HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
			else
				QuestGuru_OptionsFrameSimpleGuildStatusToggleText:SetTextColor(GRAY_FONT_COLOR.r, GRAY_FONT_COLOR.g, GRAY_FONT_COLOR.b);
			end
		end);

	QuestGuru_OptionsFrameShowObjItemIconsToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameShowObjItemIconsToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameShowObjItemIconsToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameSimpleGuildStatusToggle, "BOTTOMLEFT", -24, -6);
	QuestGuru_OptionsFrameShowObjItemIconsToggleText:SetText("Show objective item icons in log");
	QuestGuru_OptionsFrameShowObjItemIconsToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameShowObjItemIconsToggle:GetChecked()) then
				QuestGuru_Settings.ShowObjItemIcons = true;
			else
				QuestGuru_Settings.ShowObjItemIcons = false;
			end
			QuestLog_UpdateQuestDetails();
		end);

	QuestGuru_OptionsFrameDisableCommToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameDisableCommToggle", QuestGuru_OptionsFrameGeneral, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameDisableCommToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameShowObjItemIconsToggle, "BOTTOMLEFT", 0, -6);
	QuestGuru_OptionsFrameDisableCommToggleText:SetText("Disable all addon-to-addon communications");
	QuestGuru_OptionsFrameDisableCommToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameDisableCommToggle:GetChecked()) then
				QuestGuru_Settings.DisableComm = true;
			else
				QuestGuru_Settings.DisableComm = false;
			end
		end);

---------------------
-- Tracker Options --
---------------------
	QuestGuru_OptionsFrameTracker = CreateFrame("FRAME", "QuestGuru_OptionsFrameTracker", QuestGuru_OptionsFrame);
	QuestGuru_OptionsFrameTracker.name = "QG Tracker";
	QuestGuru_OptionsFrameTracker.parent = "QuestGuru";
	QuestGuru_OptionsFrameTracker.default = function () QuestGuru_SetTrackerDefaults(); end;
	InterfaceOptions_AddCategory(QuestGuru_OptionsFrameTracker);
	QuestGuru_OptionsFrameTracker:SetScript("OnShow",
	    function ()
	        QuestGuru_UpdateOptionsTrackerObjFade();
		end);

	QuestGuru_OptionsFrameTrackerTitle = QuestGuru_OptionsFrameTracker:CreateFontString("QuestGuru_OptionsFrameTrackerTitle", "ARTWORK", "GameFontNormalLarge");
	QuestGuru_OptionsFrameTrackerTitle:SetPoint("TOPLEFT", 16, -16);
	QuestGuru_OptionsFrameTrackerTitle:SetJustifyH("LEFT");
	QuestGuru_OptionsFrameTrackerTitle:SetJustifyV("TOP");
	QuestGuru_OptionsFrameTrackerTitle:SetText("QuestGuru Tracker Options");

	QuestGuru_OptionsFrameTrackerSubText = QuestGuru_OptionsFrameTracker:CreateFontString("QuestGuru_OptionsFrameTrackerSubText", "ARTWORK", "GameFontHighlightSmall");
	QuestGuru_OptionsFrameTrackerSubText:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameTrackerTitle", "BOTTOMLEFT", 0, -8);
	QuestGuru_OptionsFrameTrackerSubText:SetPoint("RIGHT", -32, 0);
	QuestGuru_OptionsFrameTrackerSubText:SetJustifyH("LEFT");
	QuestGuru_OptionsFrameTrackerSubText:SetJustifyV("TOP");
	QuestGuru_OptionsFrameTrackerSubText:SetHeight(24);
	QuestGuru_OptionsFrameTrackerSubText:SetText("These options change the look of the QuestGuru Tracker.\nChanges to these settings are saved immediately.");

	QuestGuru_OptionsFrameTrackerEnabledToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameTrackerEnabledToggle", QuestGuru_OptionsFrameTracker, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameTrackerEnabledToggle:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameTrackerSubText", "BOTTOMLEFT", -2, -8);
	QuestGuru_OptionsFrameTrackerEnabledToggleText:SetText("Use QuestGuru tracker");
	QuestGuru_OptionsFrameTrackerEnabledToggle.tooltipText = "Uncheck this option to use the game's built-in tracker or other tracker addons";
	QuestGuru_OptionsFrameTrackerEnabledToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameTrackerEnabledToggle:GetChecked()) then
				QuestGuru_Settings.Tracker.Enabled = true;
			else
				QuestGuru_Settings.Tracker.Enabled = false;
			end
			QuestWatch_Update();
			QuestLog_Update();
		end);

	QuestGuru_OptionsFrameTrackerBorderToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameTrackerBorderToggle", QuestGuru_OptionsFrameTracker, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameTrackerBorderToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameTrackerEnabledToggle, "BOTTOMLEFT", 0, 2);
	QuestGuru_OptionsFrameTrackerBorderToggleText:SetText("Show border");
	QuestGuru_OptionsFrameTrackerBorderToggle.tooltipText = "Check this option to display a thin border around the tracker";
	QuestGuru_OptionsFrameTrackerBorderToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameTrackerBorderToggle:GetChecked()) then
				QuestGuru_Settings.Tracker.ShowBorder = true;
			else
				QuestGuru_Settings.Tracker.ShowBorder = false;
			end
			QuestGuru_SetWatchBorder(QuestGuru_Settings.Tracker.ShowBorder);
			QuestWatch_Update();
		end);

	QuestGuru_OptionsFrameTrackerClickThroughToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameTrackerClickThroughToggle", QuestGuru_OptionsFrameTracker, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameTrackerClickThroughToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameTrackerBorderToggle, "BOTTOMLEFT", 0, 2);
	QuestGuru_OptionsFrameTrackerClickThroughToggleText:SetText("Click through tracker");
	QuestGuru_OptionsFrameTrackerClickThroughToggle.tooltipText = "Check this option to disable the mouse for the tracker, allowing you to click through it";
	QuestGuru_OptionsFrameTrackerClickThroughToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameTrackerClickThroughToggle:GetChecked()) then
				QuestGuru_Settings.Tracker.ClickThrough = true;
			else
				QuestGuru_Settings.Tracker.ClickThrough = false;
			end
			QuestWatch_Update();
		end);

	QuestGuru_OptionsFrameTrackerHeadersToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameTrackerHeadersToggle", QuestGuru_OptionsFrameTracker, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameTrackerHeadersToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameTrackerSubText, "BOTTOMLEFT", 200, -8);
	QuestGuru_OptionsFrameTrackerHeadersToggleText:SetText("Show headers");
	QuestGuru_OptionsFrameTrackerHeadersToggle.tooltipText = "Checking this option displays zone headers in the tracker";
	QuestGuru_OptionsFrameTrackerHeadersToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameTrackerHeadersToggle:GetChecked()) then
				QuestGuru_Settings.Tracker.ShowHeaders = true;
			else
				QuestGuru_Settings.Tracker.ShowHeaders = false;
			end
			QuestWatch_Update();
		end);

	QuestGuru_OptionsFrameTrackerShowLevelsToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameTrackerShowLevelsToggle", QuestGuru_OptionsFrameTracker, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameTrackerShowLevelsToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameTrackerHeadersToggle, "BOTTOMLEFT", 0, 2);
	QuestGuru_OptionsFrameTrackerShowLevelsToggleText:SetText("Show quest levels");
	QuestGuru_OptionsFrameTrackerShowLevelsToggle.tooltipText = "Checking this option shows quest level information in the tracker";
	QuestGuru_OptionsFrameTrackerShowLevelsToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameTrackerShowLevelsToggle:GetChecked()) then
				QuestGuru_Settings.Tracker.ShowLevels = true;
			else
				QuestGuru_Settings.Tracker.ShowLevels = false;
			end
			QuestWatch_Update();
		end);

	QuestGuru_OptionsFrameTrackerQuestTooltipsToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameTrackerQuestTooltipsToggle", QuestGuru_OptionsFrameTracker, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameTrackerQuestTooltipsToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameTrackerShowLevelsToggle, "BOTTOMLEFT", 0, 2);
	QuestGuru_OptionsFrameTrackerQuestTooltipsToggleText:SetText("Show quest tooltips");
	QuestGuru_OptionsFrameTrackerQuestTooltipsToggle.tooltipText = "Checking this option displays a tooltip with more information when you mouse over a quest name or objective item in the tracker";
	QuestGuru_OptionsFrameTrackerQuestTooltipsToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameTrackerQuestTooltipsToggle:GetChecked()) then
				QuestGuru_Settings.Tracker.ShowQuestTooltips = true;
			else
				QuestGuru_Settings.Tracker.ShowQuestTooltips = false;
			end
		end);

	QuestGuru_OptionsFrameTrackerPartyTooltipsToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameTrackerPartyTooltipsToggle", QuestGuru_OptionsFrameTracker, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameTrackerPartyTooltipsToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameTrackerQuestTooltipsToggle, "BOTTOMLEFT", 0, 2);
	QuestGuru_OptionsFrameTrackerPartyTooltipsToggleText:SetText("Show party tooltips");
	QuestGuru_OptionsFrameTrackerPartyTooltipsToggle.tooltipText = "Checking this option displays the party/alt/guild info tooltip when you mouse over a quest name in the tracker";
	QuestGuru_OptionsFrameTrackerPartyTooltipsToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameTrackerPartyTooltipsToggle:GetChecked()) then
				QuestGuru_Settings.Tracker.ShowPartyTooltips = true;
			else
				QuestGuru_Settings.Tracker.ShowPartyTooltips = false;
			end
		end);

	QuestGuru_OptionsFrameTrackerQuestPercentToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameTrackerQuestPercentToggle", QuestGuru_OptionsFrameTracker, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameTrackerQuestPercentToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameTrackerPartyTooltipsToggle, "BOTTOMLEFT", 0, 2);
	QuestGuru_OptionsFrameTrackerQuestPercentToggleText:SetText("Show quest percent");
	QuestGuru_OptionsFrameTrackerQuestPercentToggle.tooltipText = "This option shows your quest progress percentage next to the quest name in the tracker";
	QuestGuru_OptionsFrameTrackerQuestPercentToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameTrackerQuestPercentToggle:GetChecked()) then
				QuestGuru_Settings.Tracker.ShowQuestPercent = true;
			else
				QuestGuru_Settings.Tracker.ShowQuestPercent = false;
			end
			QuestWatch_Update();
		end);

	QuestGuru_OptionsFrameTrackerExpandUpToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameTrackerExpandUpToggle", QuestGuru_OptionsFrameTracker, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameTrackerExpandUpToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameTrackerQuestPercentToggle, "BOTTOMLEFT", 0, 2);
	QuestGuru_OptionsFrameTrackerExpandUpToggleText:SetText("Anchor Bottom");
	QuestGuru_OptionsFrameTrackerExpandUpToggle.tooltipText = "Anchor the bottom of the tracker to make it expand upwards.";
	QuestGuru_OptionsFrameTrackerExpandUpToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameTrackerExpandUpToggle:GetChecked()) then
				QuestGuru_Settings.Tracker.Anchor = "BOTTOM";
			else
				QuestGuru_Settings.Tracker.Anchor = "TOP";
			end
			QuestWatch_Update();
		end);

	QuestGuru_OptionsFrameTrackerAutoTrackToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameTrackerAutoTrackToggle", QuestGuru_OptionsFrameTracker, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameTrackerAutoTrackToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameTrackerClickThroughToggle, "BOTTOMLEFT", 0, 2);
	QuestGuru_OptionsFrameTrackerAutoTrackToggleText:SetText("Auto-track new quests");
	QuestGuru_OptionsFrameTrackerAutoTrackToggle.tooltipText = "Check this option to automatically add new quests to the tracker";
	QuestGuru_OptionsFrameTrackerAutoTrackToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameTrackerAutoTrackToggle:GetChecked()) then
				QuestGuru_Settings.Tracker.AutoTrack = true;
			else
				QuestGuru_Settings.Tracker.AutoTrack = false;
			end
			QuestWatch_Update();
		end);

	QuestGuru_OptionsFrameTrackerAutoUnTrackToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameTrackerAutoUnTrackToggle", QuestGuru_OptionsFrameTracker, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameTrackerAutoUnTrackToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameTrackerAutoTrackToggle, "BOTTOMLEFT", 0, 2);
	QuestGuru_OptionsFrameTrackerAutoUnTrackToggleText:SetText("Untrack complete quests");
	QuestGuru_OptionsFrameTrackerAutoUnTrackToggle.tooltipText = "Automatically remove quests from the tracker upon completion of all objectives";
	QuestGuru_OptionsFrameTrackerAutoUnTrackToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameTrackerAutoUnTrackToggle:GetChecked()) then
				QuestGuru_Settings.Tracker.AutoUnTrack = true;
			else
				QuestGuru_Settings.Tracker.AutoUnTrack = false;
			end
		end);

	QuestGuru_OptionsFrameTrackerShowCompletedObjToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameTrackerShowCompletedObjToggle", QuestGuru_OptionsFrameTracker, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameTrackerShowCompletedObjToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameTrackerAutoUnTrackToggle, "BOTTOMLEFT", 0, 2);
	QuestGuru_OptionsFrameTrackerShowCompletedObjToggleText:SetText("Show completed objectives");
	QuestGuru_OptionsFrameTrackerShowCompletedObjToggle.tooltipText = "Uncheck this option to hide complete objectives in the tracker";
	QuestGuru_OptionsFrameTrackerShowCompletedObjToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameTrackerShowCompletedObjToggle:GetChecked()) then
				QuestGuru_Settings.Tracker.ShowCompletedObj = true;
			else
				QuestGuru_Settings.Tracker.ShowCompletedObj = false;
			end
			QuestWatch_Update();
		end);

	QuestGuru_OptionsFrameTrackerColorizeObjToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameTrackerColorizeObjToggle", QuestGuru_OptionsFrameTracker, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameTrackerColorizeObjToggle:SetPoint("TOPLEFT", QuestGuru_OptionsFrameTrackerShowCompletedObjToggle, "BOTTOMLEFT", 0, 2);
	QuestGuru_OptionsFrameTrackerColorizeObjToggleText:SetText("Color objectives based on progress");
	QuestGuru_OptionsFrameTrackerColorizeObjToggle.tooltipText = "Check this option to color objectives based on progress using the colors below";
	QuestGuru_OptionsFrameTrackerColorizeObjToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameTrackerColorizeObjToggle:GetChecked()) then
				QuestGuru_Settings.Tracker.ColorizeObj = true;
			else
				QuestGuru_Settings.Tracker.ColorizeObj = false;
			end
			QuestWatch_Update();
		end);

	QuestGuru_OptionsFrameTrackerZeroColor = CreateFrame("Button", "QuestGuru_OptionsFrameTrackerZeroColor", QuestGuru_OptionsFrameTracker, "QuestGuru_ColorPickerButtonTemplate");
	QuestGuru_OptionsFrameTrackerZeroColor:SetPoint("TOPLEFT", QuestGuru_OptionsFrameTrackerColorizeObjToggle, "BOTTOMLEFT", 0, -6);
	QuestGuru_OptionsFrameTrackerZeroColorSwatch:SetTexture(1.0, 1.0, 1.0, 1.0);
	QuestGuru_OptionsFrameTrackerZeroColor.tooltipText = "Color for objectives that are 0% complete";
	QuestGuru_OptionsFrameTrackerZeroColor:SetScript("OnClick",
		function ()
			ColorPickerFrame.hasOpacity = false;
			ColorPickerFrame.func = QuestGuru_OptionsSaveColor;
			lastColorPick = "TrackerZero";
			ColorPickerFrame:SetColorRGB(QuestGuru_Settings.Tracker.ColorizeObjZero.r, QuestGuru_Settings.Tracker.ColorizeObjZero.g, QuestGuru_Settings.Tracker.ColorizeObjZero.b);
			ColorPickerFrame:Show();
			ColorPickerFrame:SetPoint("TOPLEFT", InterfaceOptionsFrame, "TOPRIGHT", -50, 0);
		end);
	QuestGuru_OptionsFrameTrackerZeroLabel = QuestGuru_OptionsFrameTracker:CreateFontString("QuestGuru_OptionsFrameTrackerZeroLabel", "ARTWORK", "GameFontNormalSmall");
	QuestGuru_OptionsFrameTrackerZeroLabel:SetPoint("TOP", "QuestGuru_OptionsFrameTrackerZeroColor", "BOTTOM", 0, 0);
	QuestGuru_OptionsFrameTrackerZeroLabel:SetText("0%");

	temp = QuestGuru_OptionsFrameTracker:CreateTexture("QuestGuru_OptionsFrameTrackerGradient", "ARTWORK");
	temp:SetWidth(200);
	temp:SetHeight(12);
	temp:SetTexture(1, 1, 1);
	temp:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameTrackerZeroColor", "TOPRIGHT", 12, -2);

	QuestGuru_OptionsFrameTrackerFullColor = CreateFrame("Button", "QuestGuru_OptionsFrameTrackerFullColor", QuestGuru_OptionsFrameTracker, "QuestGuru_ColorPickerButtonTemplate");
	QuestGuru_OptionsFrameTrackerFullColor:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameTrackerGradient", "TOPRIGHT", 12, 2);
	QuestGuru_OptionsFrameTrackerFullColorSwatch:SetTexture(1.0, 1.0, 1.0, 1.0);
	QuestGuru_OptionsFrameTrackerFullColor.tooltipText = "Color for objectives that are 99% complete";
	QuestGuru_OptionsFrameTrackerFullColor:SetScript("OnClick",
		function ()
			ColorPickerFrame.hasOpacity = false;
			ColorPickerFrame.func = QuestGuru_OptionsSaveColor;
			lastColorPick = "TrackerFull";
			ColorPickerFrame:SetColorRGB(QuestGuru_Settings.Tracker.ColorizeObjFull.r, QuestGuru_Settings.Tracker.ColorizeObjFull.g, QuestGuru_Settings.Tracker.ColorizeObjFull.b);
			ColorPickerFrame:Show();
			ColorPickerFrame:SetPoint("TOPLEFT", InterfaceOptionsFrame, "TOPRIGHT", -50, 0);
		end);
	QuestGuru_OptionsFrameTrackerFullLabel = QuestGuru_OptionsFrameTracker:CreateFontString("QuestGuru_OptionsFrameTrackerFullLabel", "ARTWORK", "GameFontNormalSmall");
	QuestGuru_OptionsFrameTrackerFullLabel:SetPoint("TOP", "QuestGuru_OptionsFrameTrackerFullColor", "BOTTOM", 0, 0);
	QuestGuru_OptionsFrameTrackerFullLabel:SetText("99%");

	QuestGuru_OptionsFrameTrackerCompleteColor = CreateFrame("Button", "QuestGuru_OptionsFrameTrackerCompleteColor", QuestGuru_OptionsFrameTracker, "QuestGuru_ColorPickerButtonTemplate");
	QuestGuru_OptionsFrameTrackerCompleteColor:SetPoint("TOPLEFT", QuestGuru_OptionsFrameTrackerFullColor, "TOPRIGHT", 40, 0);
	QuestGuru_OptionsFrameTrackerCompleteColorSwatch:SetTexture(1.0, 1.0, 1.0, 1.0);
	QuestGuru_OptionsFrameTrackerCompleteColor.tooltipText = "Color for objectives that are complete";
	QuestGuru_OptionsFrameTrackerCompleteColor:SetScript("OnClick",
		function ()
			ColorPickerFrame.hasOpacity = false;
			ColorPickerFrame.func = QuestGuru_OptionsSaveColor;
			lastColorPick = "TrackerComplete";
			ColorPickerFrame:SetColorRGB(QuestGuru_Settings.Tracker.ColorizeObjComplete.r, QuestGuru_Settings.Tracker.ColorizeObjComplete.g, QuestGuru_Settings.Tracker.ColorizeObjComplete.b);
			ColorPickerFrame:Show();
			ColorPickerFrame:SetPoint("TOPLEFT", InterfaceOptionsFrame, "TOPRIGHT", -50, 0);
		end);
	QuestGuru_OptionsFrameTrackerCompleteLabel = QuestGuru_OptionsFrameTracker:CreateFontString("QuestGuru_OptionsFrameTrackerCompleteLabel", "ARTWORK", "GameFontNormalSmall");
	QuestGuru_OptionsFrameTrackerCompleteLabel:SetPoint("TOP", "QuestGuru_OptionsFrameTrackerCompleteColor", "BOTTOM", 0, 0);
	QuestGuru_OptionsFrameTrackerCompleteLabel:SetText(COMPLETE);

	QuestGuru_OptionsFrameTrackerAlpha = CreateFrame("Slider", "QuestGuru_OptionsFrameTrackerAlpha", QuestGuru_OptionsFrameTracker, "OptionsSliderTemplate");
	QuestGuru_OptionsFrameTrackerAlpha:SetWidth(300);
	QuestGuru_OptionsFrameTrackerAlpha:SetHeight(16);
	QuestGuru_OptionsFrameTrackerAlpha:SetPoint("CENTER", QuestGuru_OptionsFrameTracker, "BOTTOM", 0, 24);
	QuestGuru_OptionsFrameTrackerAlphaText:SetText("Background Alpha");
	QuestGuru_OptionsFrameTrackerAlphaHigh:SetText("100%");
	QuestGuru_OptionsFrameTrackerAlphaLow:SetText("0%");
	QuestGuru_OptionsFrameTrackerAlpha:SetMinMaxValues(0,1);
	QuestGuru_OptionsFrameTrackerAlpha:SetValueStep(0.01);
	QuestGuru_OptionsFrameTrackerAlpha:SetValue(0.7);
	QuestGuru_OptionsFrameTrackerAlpha:SetScript("OnValueChanged",
		function ()
			QuestGuru_Settings.Tracker.Alpha = QuestGuru_OptionsFrameTrackerAlpha:GetValue();
			QuestGuru_QuestWatchFrame:SetBackdropColor(0,0,0,QuestGuru_Settings.Tracker.Alpha);
			QuestGuru_OptionsFrameTrackerAlphaText:SetText("Background Alpha ("..abs(ceil((QuestGuru_Settings.Tracker.Alpha * 100)-0.5)).."%)");
		end);

	QuestGuru_OptionsFrameTrackerScale = CreateFrame("Slider", "QuestGuru_OptionsFrameTrackerScale", QuestGuru_OptionsFrameTracker, "OptionsSliderTemplate");
	QuestGuru_OptionsFrameTrackerScale:SetWidth(300);
	QuestGuru_OptionsFrameTrackerScale:SetHeight(16);
	QuestGuru_OptionsFrameTrackerScale:SetPoint("CENTER", QuestGuru_OptionsFrameTracker, "BOTTOM", 0, 58);
	QuestGuru_OptionsFrameTrackerScaleText:SetText("Tracker Size");
	QuestGuru_OptionsFrameTrackerScaleHigh:SetText("150%");
	QuestGuru_OptionsFrameTrackerScaleLow:SetText("50%");
	QuestGuru_OptionsFrameTrackerScale:SetMinMaxValues(0.5,1.5);
	QuestGuru_OptionsFrameTrackerScale:SetValueStep(0.01);
	QuestGuru_OptionsFrameTrackerScale:SetValue(0.9);
	QuestGuru_OptionsFrameTrackerScale:SetScript("OnValueChanged",
		function ()
			QuestGuru_Settings.Tracker.Scale = QuestGuru_OptionsFrameTrackerScale:GetValue();
			QuestGuru_OptionsFrameTrackerScaleText:SetText("Tracker Size ("..ceil((QuestGuru_Settings.Tracker.Scale * 100)-0.5).."%)");
			QuestGuru_QuestWatchFrame:SetScale(QuestGuru_Settings.Tracker.Scale);
		end);

	QuestGuru_OptionsFrameTrackerLines = CreateFrame("Slider", "QuestGuru_OptionsFrameTrackerLines", QuestGuru_OptionsFrameTracker, "OptionsSliderTemplate");
	QuestGuru_OptionsFrameTrackerLines:SetWidth(300);
	QuestGuru_OptionsFrameTrackerLines:SetHeight(16);
	QuestGuru_OptionsFrameTrackerLines:SetPoint("CENTER", QuestGuru_OptionsFrameTracker, "BOTTOM", 0, 92);
	QuestGuru_OptionsFrameTrackerLinesText:SetText("Max. Tracker Lines");
	QuestGuru_OptionsFrameTrackerLinesHigh:SetText("40");
	QuestGuru_OptionsFrameTrackerLinesLow:SetText("7");
	QuestGuru_OptionsFrameTrackerLines:SetMinMaxValues(7,40);
	QuestGuru_OptionsFrameTrackerLines:SetValueStep(1);
	QuestGuru_OptionsFrameTrackerLines:SetValue(30);
	QuestGuru_OptionsFrameTrackerLines:SetScript("OnValueChanged",
		function ()
			QuestGuru_Settings.Tracker.Lines = QuestGuru_OptionsFrameTrackerLines:GetValue();
			QuestGuru_OptionsFrameTrackerLinesText:SetText("Max. Tracker Lines: "..QuestGuru_Settings.Tracker.Lines);
			QuestWatch_Update();
		end);
		

---------------------
-- Sound Options --
---------------------
	QuestGuru_OptionsFrameSound = CreateFrame("FRAME", "QuestGuru_OptionsFrameSound", QuestGuru_OptionsFrame);
	QuestGuru_OptionsFrameSound.name = "QG Sounds";
	QuestGuru_OptionsFrameSound.parent = "QuestGuru";
	QuestGuru_OptionsFrameSound.default = function () QuestGuru_SetSoundDefaults(); end;
	InterfaceOptions_AddCategory(QuestGuru_OptionsFrameSound)

	QuestGuru_OptionsFrameSoundTitle = QuestGuru_OptionsFrameSound:CreateFontString("QuestGuru_OptionsFrameSoundTitle", "ARTWORK", "GameFontNormalLarge");
	QuestGuru_OptionsFrameSoundTitle:SetPoint("TOPLEFT", 16, -16);
	QuestGuru_OptionsFrameSoundTitle:SetJustifyH("LEFT");
	QuestGuru_OptionsFrameSoundTitle:SetJustifyV("TOP");
	QuestGuru_OptionsFrameSoundTitle:SetText("QuestGuru Sound Options");

	QuestGuru_OptionsFrameSoundSubText = QuestGuru_OptionsFrameSound:CreateFontString("QuestGuru_OptionsFrameSoundSubText", "ARTWORK", "GameFontHighlightSmall");
	QuestGuru_OptionsFrameSoundSubText:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameSoundTitle", "BOTTOMLEFT", 0, -8);
	QuestGuru_OptionsFrameSoundSubText:SetPoint("RIGHT", -32, 0);
	QuestGuru_OptionsFrameSoundSubText:SetJustifyH("LEFT");
	QuestGuru_OptionsFrameSoundSubText:SetJustifyV("TOP");
	QuestGuru_OptionsFrameSoundSubText:SetHeight(24);
	QuestGuru_OptionsFrameSoundSubText:SetText("Use this panel to change the sounds played on quest progress.\nChanges to these settings are saved immediately.");

	QuestGuru_OptionsFrameSoundToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameSoundToggle", QuestGuru_OptionsFrameSound, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameSoundToggle:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameSoundSubText", "BOTTOMLEFT", -2, -8);
	QuestGuru_OptionsFrameSoundToggleText:SetText("Enable additional sounds");
	QuestGuru_OptionsFrameSoundToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameSoundToggle:GetChecked()) then
				QuestGuru_Settings.Sounds.Enabled = true;
			else
				QuestGuru_Settings.Sounds.Enabled = false;
			end
		end);

	QuestGuru_OptionsFrameSoundProgressToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameSoundProgressToggle", QuestGuru_OptionsFrameSound, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameSoundProgressToggle:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameSoundToggle", "BOTTOMLEFT", 0, -12);
	QuestGuru_OptionsFrameSoundProgressToggleText:SetText("Play sound on objective progress:");
	QuestGuru_OptionsFrameSoundProgressToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameSoundProgressToggle:GetChecked()) then
				QuestGuru_Settings.Sounds.Progress.Enabled = true;
			else
				QuestGuru_Settings.Sounds.Progress.Enabled = false;
			end
		end);

	QuestGuru_OptionsFrameSoundProgressButton = CreateFrame("Frame", "QuestGuru_OptionsFrameSoundProgressButton", QuestGuru_OptionsFrameSound, "UIDropDownMenuTemplate");
	QuestGuru_OptionsFrameSoundProgressButton:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameSoundProgressToggle", "BOTTOMLEFT");
	QuestGuru_OptionsFrameSoundProgressButton:SetWidth(200);
	QuestGuru_OptionsFrameSoundProgressButtonText:SetJustifyH("LEFT");
	UIDropDownMenu_SetWidth(200, QuestGuru_OptionsFrameSoundProgressButton);
	UIDropDownMenu_Initialize(QuestGuru_OptionsFrameSoundProgressButton, QuestGuru_OptionsFrameSoundProgressDropDown_Initialize);

	QuestGuru_OptionsFrameSoundObjCompleteToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameSoundObjCompleteToggle", QuestGuru_OptionsFrameSound, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameSoundObjCompleteToggle:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameSoundProgressToggle", "BOTTOMLEFT", 0, -48);
	QuestGuru_OptionsFrameSoundObjCompleteToggleText:SetText("Play sound on objective completion:");
	QuestGuru_OptionsFrameSoundObjCompleteToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameSoundObjCompleteToggle:GetChecked()) then
				QuestGuru_Settings.Sounds.ObjComplete.Enabled = true;
			else
				QuestGuru_Settings.Sounds.ObjComplete.Enabled = false;
			end
		end);

	QuestGuru_OptionsFrameSoundObjCompleteButton = CreateFrame("Frame", "QuestGuru_OptionsFrameSoundObjCompleteButton", QuestGuru_OptionsFrameSound, "UIDropDownMenuTemplate");
	QuestGuru_OptionsFrameSoundObjCompleteButton:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameSoundObjCompleteToggle", "BOTTOMLEFT");
	QuestGuru_OptionsFrameSoundObjCompleteButton:SetWidth(200);
	QuestGuru_OptionsFrameSoundObjCompleteButtonText:SetJustifyH("LEFT");
	UIDropDownMenu_SetWidth(200, QuestGuru_OptionsFrameSoundObjCompleteButton);
	UIDropDownMenu_Initialize(QuestGuru_OptionsFrameSoundObjCompleteButton, QuestGuru_OptionsFrameSoundObjCompleteDropDown_Initialize);

	QuestGuru_OptionsFrameSoundQuestCompleteToggle = CreateFrame("CheckButton", "QuestGuru_OptionsFrameSoundQuestCompleteToggle", QuestGuru_OptionsFrameSound, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_OptionsFrameSoundQuestCompleteToggle:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameSoundObjCompleteToggle", "BOTTOMLEFT", 0, -48);
	QuestGuru_OptionsFrameSoundQuestCompleteToggleText:SetText("Play sound on quest completion:");
	QuestGuru_OptionsFrameSoundQuestCompleteToggle:SetScript("OnClick",
		function ()
			if (QuestGuru_OptionsFrameSoundQuestCompleteToggle:GetChecked()) then
				QuestGuru_Settings.Sounds.QuestComplete.Enabled = true;
			else
				QuestGuru_Settings.Sounds.QuestComplete.Enabled = false;
			end
		end);

	QuestGuru_OptionsFrameSoundQuestCompleteButton = CreateFrame("Frame", "QuestGuru_OptionsFrameSoundQuestCompleteButton", QuestGuru_OptionsFrameSound, "UIDropDownMenuTemplate");
	QuestGuru_OptionsFrameSoundQuestCompleteButton:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameSoundQuestCompleteToggle", "BOTTOMLEFT");
	QuestGuru_OptionsFrameSoundQuestCompleteButton:SetWidth(200);
	QuestGuru_OptionsFrameSoundQuestCompleteButtonText:SetJustifyH("LEFT");
	UIDropDownMenu_SetWidth(200, QuestGuru_OptionsFrameSoundQuestCompleteButton);
	UIDropDownMenu_Initialize(QuestGuru_OptionsFrameSoundQuestCompleteButton, QuestGuru_OptionsFrameSoundQuestCompleteDropDown_Initialize);
end

function QuestGuru_UpdateOptionsTrackerObjFade()
	local r, g, b;
	
	QuestGuru_OptionsFrameTrackerGradient:SetGradient("HORIZONTAL", QuestGuru_Settings.Tracker.ColorizeObjZero.r, QuestGuru_Settings.Tracker.ColorizeObjZero.g, QuestGuru_Settings.Tracker.ColorizeObjZero.b, QuestGuru_Settings.Tracker.ColorizeObjFull.r, QuestGuru_Settings.Tracker.ColorizeObjFull.g, QuestGuru_Settings.Tracker.ColorizeObjFull.b);

	r, g, b = QuestGuru_QuestWatchGetObjColor(0, true);
	QuestGuru_OptionsFrameTrackerZeroColorSwatch:SetTexture(r, g, b);

	r, g, b = QuestGuru_QuestWatchGetObjColor(0.99, true);
	QuestGuru_OptionsFrameTrackerFullColorSwatch:SetTexture(r, g, b);

	r, g, b = QuestGuru_QuestWatchGetObjColor(1, true);
	QuestGuru_OptionsFrameTrackerCompleteColorSwatch:SetTexture(r, g, b);
end

function QuestGuru_OptionsSaveColor()
	local r,g,b = ColorPickerFrame:GetColorRGB();

	if (lastColorPick == "TrackerZero") then
	    QuestGuru_Settings.Tracker.ColorizeObjZero.r = r;
	    QuestGuru_Settings.Tracker.ColorizeObjZero.g = g;
	    QuestGuru_Settings.Tracker.ColorizeObjZero.b = b;
	    QuestGuru_UpdateOptionsTrackerObjFade();
	    QuestWatch_Update();
	elseif (lastColorPick == "TrackerFull") then
	    QuestGuru_Settings.Tracker.ColorizeObjFull.r = r;
	    QuestGuru_Settings.Tracker.ColorizeObjFull.g = g;
	    QuestGuru_Settings.Tracker.ColorizeObjFull.b = b;
	    QuestGuru_UpdateOptionsTrackerObjFade();
	    QuestWatch_Update();
	elseif (lastColorPick == "TrackerComplete") then
	    QuestGuru_Settings.Tracker.ColorizeObjComplete.r = r;
	    QuestGuru_Settings.Tracker.ColorizeObjComplete.g = g;
	    QuestGuru_Settings.Tracker.ColorizeObjComplete.b = b;
	    QuestGuru_OptionsFrameTrackerCompleteColorSwatch:SetTexture(r, g, b);
	    QuestWatch_Update();
	else
		QuestGuru_Settings.Colorize[lastColorPick].Color.r = r;
		QuestGuru_Settings.Colorize[lastColorPick].Color.g = g;
		QuestGuru_Settings.Colorize[lastColorPick].Color.b = b;
		QuestGuru_OptionsFrameColorizePlayerNameColorSwatch:SetTexture(QuestGuru_Settings.Colorize.PlayerName.Color.r, QuestGuru_Settings.Colorize.PlayerName.Color.g, QuestGuru_Settings.Colorize.PlayerName.Color.b, 1.0);
		QuestGuru_OptionsFrameColorizeAreaNamesColorSwatch:SetTexture(QuestGuru_Settings.Colorize.AreaNames.Color.r, QuestGuru_Settings.Colorize.AreaNames.Color.g, QuestGuru_Settings.Colorize.AreaNames.Color.b, 1.0);
		QuestGuru_OptionsFrameColorizeNPCNamesColorSwatch:SetTexture(QuestGuru_Settings.Colorize.NPCNames.Color.r, QuestGuru_Settings.Colorize.NPCNames.Color.g, QuestGuru_Settings.Colorize.NPCNames.Color.b, 1.0);
	end
end

function QuestGuru_OptionsSoundsLoadSettings()
	if (QuestGuru_Settings.Sounds == nil) then
	    QuestGuru_Settings.Sounds = {};
	end
	if (QuestGuru_Settings.Sounds.Enabled ~= false) then
	    QuestGuru_Settings.Sounds.Enabled = true;
	end
	QuestGuru_OptionsFrameSoundToggle:SetChecked(QuestGuru_Settings.Sounds.Enabled);
	
	if (QuestGuru_Settings.Sounds.Progress == nil) then
	    QuestGuru_Settings.Sounds.Progress = {};
	end
	if (QuestGuru_Settings.Sounds.Progress.Enabled ~= false) then
	    QuestGuru_Settings.Sounds.Progress.Enabled = true;
	end
	QuestGuru_OptionsFrameSoundProgressToggle:SetChecked(QuestGuru_Settings.Sounds.Progress.Enabled);
	if (QuestGuru_Settings.Sounds.Progress.Sound == nil) then
	    QuestGuru_Settings.Sounds.Progress.Sound = "AuctionWindowOpen";
	end
	UIDropDownMenu_SetText(QuestGuru_Settings.Sounds.Progress.Sound, QuestGuru_OptionsFrameSoundProgressButton);

	if (QuestGuru_Settings.Sounds.ObjComplete == nil) then
	    QuestGuru_Settings.Sounds.ObjComplete = {};
	end
	if (QuestGuru_Settings.Sounds.ObjComplete.Enabled ~= false) then
	    QuestGuru_Settings.Sounds.ObjComplete.Enabled = true;
	end
	QuestGuru_OptionsFrameSoundObjCompleteToggle:SetChecked(QuestGuru_Settings.Sounds.ObjComplete.Enabled);
	if (QuestGuru_Settings.Sounds.ObjComplete.Sound == nil) then
	    QuestGuru_Settings.Sounds.ObjComplete.Sound = "AuctionWindowClose";
	end
	UIDropDownMenu_SetText(QuestGuru_Settings.Sounds.ObjComplete.Sound, QuestGuru_OptionsFrameSoundObjCompleteButton);

	if (QuestGuru_Settings.Sounds.QuestComplete == nil) then
	    QuestGuru_Settings.Sounds.QuestComplete = {};
	end
	if (QuestGuru_Settings.Sounds.QuestComplete.Enabled ~= false) then
	    QuestGuru_Settings.Sounds.QuestComplete.Enabled = true;
	end
	QuestGuru_OptionsFrameSoundQuestCompleteToggle:SetChecked(QuestGuru_Settings.Sounds.QuestComplete.Enabled);
	if (QuestGuru_Settings.Sounds.QuestComplete.Sound == nil) then
	    QuestGuru_Settings.Sounds.QuestComplete.Sound = "ReadyCheck";
	end
	UIDropDownMenu_SetText(QuestGuru_Settings.Sounds.QuestComplete.Sound, QuestGuru_OptionsFrameSoundQuestCompleteButton);
end

function QuestGuru_SetGeneralDefaults()
	QuestGuru_Echo("Resetting General settings to defaults.");
    QuestGuru_Settings.AutoComplete = false;
	QuestGuru_OptionsFrameAutoCompleteToggle:SetChecked(QuestGuru_Settings.AutoComplete);
	QuestGuru_Settings.ShowObjItemIcons = false;
	QuestGuru_OptionsFrameShowObjItemIconsToggle:SetChecked(QuestGuru_Settings.ShowObjItemIcons);
	QuestGuru_Settings.TooltipText = true;
	QuestGuru_OptionsFrameShowTooltipTextToggle:SetChecked(QuestGuru_Settings.TooltipText);
	QuestGuru_Settings.DisableComm = false;
	QuestGuru_OptionsFrameDisableCommToggle:SetChecked(QuestGuru_Settings.DisableComm);
	QuestGuru_Settings.ShowAltStatus = true;
	QuestGuru_OptionsFrameAltStatusToggle:SetChecked(QuestGuru_Settings.ShowAltStatus);
	QuestGuru_Settings.ShowGuildStatus = true;
	QuestGuru_OptionsFrameGuildStatusToggle:SetChecked(QuestGuru_Settings.ShowGuildStatus);
    QuestGuru_OptionsFrameSimpleGuildStatusToggle:Enable();
	QuestGuru_Settings.ShowSimpleGuildStatus = false;
	QuestGuru_OptionsFrameSimpleGuildStatusToggle:SetChecked(QuestGuru_Settings.ShowSimpleGuildStatus);
    QuestGuru_Settings.ShowLevels = {};
    QuestGuru_Settings.ShowLevels.QuestLog = true;
	QuestGuru_OptionsFrameShowLevelsQuestLogToggle:SetChecked(QuestGuru_Settings.ShowLevels.QuestLog);
    QuestGuru_Settings.ShowLevels.History = true;
	QuestGuru_OptionsFrameShowLevelsHistoryToggle:SetChecked(QuestGuru_Settings.ShowLevels.History);
    QuestGuru_Settings.ShowLevels.Abandon = true;
	QuestGuru_OptionsFrameShowLevelsAbandonToggle:SetChecked(QuestGuru_Settings.ShowLevels.Abandon);
	QuestGuru_Settings.Colorize = {};
	QuestGuru_Settings.Colorize.PlayerName = {};
	QuestGuru_Settings.Colorize.PlayerName.Enabled = true;
	QuestGuru_OptionsFrameColorizePlayerNameToggle:SetChecked(QuestGuru_Settings.Colorize.PlayerName.Enabled);
	QuestGuru_Settings.Colorize.PlayerName.Color = { r=0, g=0.4, b=0.8 };
	QuestGuru_OptionsFrameColorizePlayerNameColorSwatch:SetTexture(QuestGuru_Settings.Colorize.PlayerName.Color.r, QuestGuru_Settings.Colorize.PlayerName.Color.g, QuestGuru_Settings.Colorize.PlayerName.Color.b, 1.0);
	QuestGuru_Settings.Colorize.AreaNames = {};
	QuestGuru_Settings.Colorize.AreaNames.Enabled = true;
	QuestGuru_OptionsFrameColorizeAreaNamesToggle:SetChecked(QuestGuru_Settings.Colorize.AreaNames.Enabled);
	QuestGuru_Settings.Colorize.AreaNames.Color = { r=0, g=0.4, b=0.8 };
	QuestGuru_OptionsFrameColorizeAreaNamesColorSwatch:SetTexture(QuestGuru_Settings.Colorize.AreaNames.Color.r, QuestGuru_Settings.Colorize.AreaNames.Color.g, QuestGuru_Settings.Colorize.AreaNames.Color.b, 1.0);
	QuestGuru_Settings.Colorize.NPCNames = {};
	QuestGuru_Settings.Colorize.NPCNames.Enabled = true;
	QuestGuru_OptionsFrameColorizeNPCNamesToggle:SetChecked(QuestGuru_Settings.Colorize.NPCNames.Enabled);
	QuestGuru_Settings.Colorize.NPCNames.Color = { r=0, g=0.4, b=0.8 };
	QuestGuru_OptionsFrameColorizeNPCNamesColorSwatch:SetTexture(QuestGuru_Settings.Colorize.NPCNames.Color.r, QuestGuru_Settings.Colorize.NPCNames.Color.g, QuestGuru_Settings.Colorize.NPCNames.Color.b, 1.0);
	QuestLog_Update();
end

function QuestGuru_SetTrackerDefaults()
	QuestGuru_Echo("Resetting Tracker settings to defaults.");
    QuestGuru_Settings.Tracker.Enabled = true;
	QuestGuru_OptionsFrameTrackerEnabledToggle:SetChecked(QuestGuru_Settings.Tracker.Enabled);
    QuestGuru_Settings.Tracker.Scale = 0.9;
	QuestGuru_OptionsFrameTrackerScaleText:SetText("Tracker Size ("..ceil((QuestGuru_Settings.Tracker.Scale * 100)-0.5).."%)");
	QuestGuru_OptionsFrameTrackerScale:SetValue(QuestGuru_Settings.Tracker.Scale);
	QuestGuru_QuestWatchFrame:SetScale(QuestGuru_Settings.Tracker.Scale);
	QuestGuru_Settings.Tracker.Lines = 30;
	QuestGuru_OptionsFrameTrackerLinesText:SetText("Max. Tracker Lines: "..QuestGuru_Settings.Tracker.Lines);
	QuestGuru_OptionsFrameTrackerLines:SetValue(QuestGuru_Settings.Tracker.Lines);
    QuestGuru_Settings.Tracker.Minimized = false;
	QuestGuru_Settings.Tracker.Alpha = 0.7;
	QuestGuru_QuestWatchFrame:SetBackdropColor(0,0,0,QuestGuru_Settings.Tracker.Alpha);
	QuestGuru_OptionsFrameTrackerAlphaText:SetText("Background Alpha ("..abs(ceil((QuestGuru_Settings.Tracker.Alpha * 100)-0.5)).."%)");
	QuestGuru_OptionsFrameTrackerAlpha:SetValue(QuestGuru_Settings.Tracker.Alpha);
	QuestGuru_Settings.Tracker.ShowHeaders = true;
	QuestGuru_OptionsFrameTrackerHeadersToggle:SetChecked(QuestGuru_Settings.Tracker.ShowHeaders);
	QuestGuru_Settings.Tracker.ShowBorder = true;
	QuestGuru_OptionsFrameTrackerBorderToggle:SetChecked(QuestGuru_Settings.Tracker.ShowBorder);
	QuestGuru_SetWatchBorder(QuestGuru_Settings.Tracker.ShowBorder);
    QuestGuru_Settings.Tracker.ShowLevels = true;
	QuestGuru_OptionsFrameTrackerShowLevelsToggle:SetChecked(QuestGuru_Settings.Tracker.ShowLevels);
    QuestGuru_Settings.Tracker.AutoTrack = true;
	QuestGuru_OptionsFrameTrackerAutoTrackToggle:SetChecked(QuestGuru_Settings.Tracker.AutoTrack);
    QuestGuru_Settings.Tracker.AutoUnTrack = false;
	QuestGuru_OptionsFrameTrackerAutoUnTrackToggle:SetChecked(QuestGuru_Settings.Tracker.AutoUnTrack);
    QuestGuru_Settings.Tracker.ShowCompletedObj = true;
	QuestGuru_OptionsFrameTrackerShowCompletedObjToggle:SetChecked(QuestGuru_Settings.Tracker.ShowCompletedObj);
    QuestGuru_Settings.Tracker.ColorizeObj = false;
	QuestGuru_OptionsFrameTrackerColorizeObjToggle:SetChecked(QuestGuru_Settings.Tracker.ColorizeObj);
    QuestGuru_Settings.Tracker.ColorizeObjZero.r = 0.8;
    QuestGuru_Settings.Tracker.ColorizeObjZero.g = 0.2;
    QuestGuru_Settings.Tracker.ColorizeObjZero.b = 0.8;
    QuestGuru_Settings.Tracker.ColorizeObjFull.r = 0.3;
    QuestGuru_Settings.Tracker.ColorizeObjFull.g = 0.8;
    QuestGuru_Settings.Tracker.ColorizeObjFull.b = 1.0;
    QuestGuru_Settings.Tracker.ColorizeObjComplete.r = 0.1;
    QuestGuru_Settings.Tracker.ColorizeObjComplete.g = 0.9;
    QuestGuru_Settings.Tracker.ColorizeObjComplete.b = 1.0;
	QuestGuru_Settings.Tracker.ClickThrough = false;
	QuestGuru_OptionsFrameTrackerClickThroughToggle:SetChecked(QuestGuru_Settings.Tracker.ClickThrough);
	QuestGuru_Settings.Tracker.ShowQuestTooltips = true;
	QuestGuru_OptionsFrameTrackerQuestTooltipsToggle:SetChecked(QuestGuru_Settings.Tracker.ShowQuestTooltips);
	QuestGuru_Settings.Tracker.ShowPartyTooltips = true;
	QuestGuru_OptionsFrameTrackerPartyTooltipsToggle:SetChecked(QuestGuru_Settings.Tracker.ShowPartyTooltips);
	QuestGuru_Settings.Tracker.ShowQuestPercent = true;
	QuestGuru_OptionsFrameTrackerQuestPercentToggle:SetChecked(QuestGuru_Settings.Tracker.ShowQuestPercent);
	QuestGuru_Settings.Tracker.Anchor = "TOP";
	QuestGuru_OptionsFrameTrackerExpandUpToggle:SetChecked(false);
    QuestGuru_UpdateOptionsTrackerObjFade();
    QuestWatch_Update();
end

function QuestGuru_SetSoundDefaults()
	QuestGuru_Echo("Resetting Sound settings to defaults.");
    QuestGuru_Settings.Sounds.Progress.Enabled = true;
	QuestGuru_Settings.Sounds.QuestComplete.Sound = "ReadyCheck";
    QuestGuru_Settings.Sounds.ObjComplete.Sound = "AuctionWindowClose";
    QuestGuru_Settings.Sounds.Progress.Sound = "AuctionWindowOpen";
end