do
	local temp, i;

	QuestGuru_AnnounceFrame = CreateFrame("FRAME", "QuestGuru_AnnounceFrame", QuestGuru_OptionsFrame);
	QuestGuru_AnnounceFrame.name = "QG Announcer";
	QuestGuru_AnnounceFrame.parent = "QuestGuru";
	QuestGuru_AnnounceFrame.default = function () QuestGuru_SetAnnounceDefaults(); end;
	QuestGuru_AnnounceFrame.okay = function () QuestGuru_SaveAnnounceSettings(); end;
	QuestGuru_AnnounceFrame.cancel = function () QuestGuru_CancelAnnounceChanges(); end;
	InterfaceOptions_AddCategory(QuestGuru_AnnounceFrame);

	QuestGuru_OptionsFrameAnnounceTitle = QuestGuru_AnnounceFrame:CreateFontString("QuestGuru_OptionsFrameAnnounceTitle", "ARTWORK", "GameFontNormalLarge");
	QuestGuru_OptionsFrameAnnounceTitle:SetPoint("TOPLEFT", 16, -16);
	QuestGuru_OptionsFrameAnnounceTitle:SetJustifyH("LEFT");
	QuestGuru_OptionsFrameAnnounceTitle:SetJustifyV("TOP");
	QuestGuru_OptionsFrameAnnounceTitle:SetText("QuestGuru Announcer Options");

	QuestGuru_OptionsFrameAnnounceSubText = QuestGuru_AnnounceFrame:CreateFontString("QuestGuru_OptionsFrameAnnounceSubText", "ARTWORK", "GameFontHighlightSmall");
	QuestGuru_OptionsFrameAnnounceSubText:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameAnnounceTitle", "BOTTOMLEFT", 0, -8);
	QuestGuru_OptionsFrameAnnounceSubText:SetPoint("RIGHT", -32, 0);
	QuestGuru_OptionsFrameAnnounceSubText:SetJustifyH("LEFT");
	QuestGuru_OptionsFrameAnnounceSubText:SetJustifyV("TOP");
	QuestGuru_OptionsFrameAnnounceSubText:SetHeight(24);
	QuestGuru_OptionsFrameAnnounceSubText:SetText("Use these options to announce your quest progress to others.\nChanges to these settings are saved when you click Okay.");

	QuestGuru_AnnounceFrameAnnounceToggle = CreateFrame("CheckButton", "QuestGuru_AnnounceFrameAnnounceToggle", QuestGuru_AnnounceFrame, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_AnnounceFrameAnnounceToggle:SetPoint("TOPLEFT", "QuestGuru_OptionsFrameAnnounceSubText", "BOTTOMLEFT", -2, -8);
	QuestGuru_AnnounceFrameAnnounceToggleText:SetText("Announce Quest Progress");

	temp = QuestGuru_AnnounceFrame:CreateFontString("QuestGuru_AnnounceFrameChannelsLabel", "ARTWORK", "GameFontNormal");
	temp:SetText("Channels:");
	temp:SetPoint("TOPLEFT", "QuestGuru_AnnounceFrameAnnounceToggle", "BOTTOMLEFT", 0, -6);
	
	QuestGuru_AnnounceFrameChannelSayToggle = CreateFrame("CheckButton", "QuestGuru_AnnounceFrameChannelSayToggle", QuestGuru_AnnounceFrame, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_AnnounceFrameChannelSayToggle:SetPoint("TOPLEFT", "QuestGuru_AnnounceFrameChannelsLabel", "BOTTOMLEFT", 0, -2);
	QuestGuru_AnnounceFrameChannelSayToggleText:SetText("/s");
	QuestGuru_AnnounceFrameChannelSayToggle.tooltipText = "Make announcements in Say";
	
	QuestGuru_AnnounceFrameChannelPartyToggle = CreateFrame("CheckButton", "QuestGuru_AnnounceFrameChannelPartyToggle", QuestGuru_AnnounceFrame, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_AnnounceFrameChannelPartyToggle:SetPoint("LEFT", "QuestGuru_AnnounceFrameChannelSayToggle", "RIGHT", 34, 0);
	QuestGuru_AnnounceFrameChannelPartyToggleText:SetText("/p");
	QuestGuru_AnnounceFrameChannelPartyToggle.tooltipText = "Make announcements to your Party";
	
	QuestGuru_AnnounceFrameChannelGuildToggle = CreateFrame("CheckButton", "QuestGuru_AnnounceFrameChannelGuildToggle", QuestGuru_AnnounceFrame, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_AnnounceFrameChannelGuildToggle:SetPoint("LEFT", "QuestGuru_AnnounceFrameChannelPartyToggle", "RIGHT", 34, 0);
	QuestGuru_AnnounceFrameChannelGuildToggleText:SetText("/g");
	QuestGuru_AnnounceFrameChannelGuildToggle.tooltipText = "Make announcements to your Guild";
	
	QuestGuru_AnnounceFrameChannelWhisperToggle = CreateFrame("CheckButton", "QuestGuru_AnnounceFrameChannelWhisperToggle", QuestGuru_AnnounceFrame, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_AnnounceFrameChannelWhisperToggle:SetPoint("LEFT", "QuestGuru_AnnounceFrameChannelGuildToggle", "RIGHT", 34, 0);
	QuestGuru_AnnounceFrameChannelWhisperToggleText:SetText("/w");
	QuestGuru_AnnounceFrameChannelWhisperToggle.tooltipText = "Whisper your announcements to someone";

	temp = QuestGuru_AnnounceFrame:CreateFontString("QuestGuru_AnnounceFrameChannelWhisperToText", "ARTWORK", "GameFontNormal");
	temp:SetText("to:");
	temp:SetPoint("LEFT", "QuestGuru_AnnounceFrameChannelWhisperToggle", "RIGHT", 24, 0);
	
	QuestGuru_AnnounceFrameChannelWhisperTo = CreateFrame("EditBox", "QuestGuru_AnnounceFrameChannelWhisperTo", QuestGuru_AnnounceFrame, "InputBoxTemplate");
	QuestGuru_AnnounceFrameChannelWhisperTo:SetPoint("LEFT", "QuestGuru_AnnounceFrameChannelWhisperToText", "RIGHT", 8, 0);
	QuestGuru_AnnounceFrameChannelWhisperTo:SetHeight(20);
	QuestGuru_AnnounceFrameChannelWhisperTo:SetWidth(72);
	QuestGuru_AnnounceFrameChannelWhisperTo:SetAutoFocus(false);
	QuestGuru_AnnounceFrameChannelWhisperTo:SetScript("OnShow",
		function ()
			QuestGuru_AnnounceFrameChannelWhisperTo:SetCursorPosition(1);
		end);
	QuestGuru_AnnounceFrameChannelWhisperTo:SetScript("OnEscapePressed",
		function ()
			this:ClearFocus();
		end);

	temp = QuestGuru_AnnounceFrame:CreateFontString("QuestGuru_AnnounceFrameMessageLabel", "ARTWORK", "GameFontNormal");
	temp:SetText("Messages:");
	temp:SetPoint("TOPLEFT", "QuestGuru_AnnounceFrameChannelSayToggle", "BOTTOMLEFT", 0, -24);
	
	QuestGuru_AnnounceFrameMessageHelpButton = CreateFrame("BUTTON", "QuestGuru_AnnounceFrameMessageHelpButton", QuestGuru_AnnounceFrame, "UIPanelButtonTemplate");
	QuestGuru_AnnounceFrameMessageHelpButton:SetHeight(24);
	QuestGuru_AnnounceFrameMessageHelpButton:SetWidth(24);
	QuestGuru_AnnounceFrameMessageHelpButton:SetText("?");
	QuestGuru_AnnounceFrameMessageHelpButton:SetPoint("TOP", "QuestGuru_AnnounceFrameChannelSayToggle", "BOTTOM", 0, -24);
	QuestGuru_AnnounceFrameMessageHelpButton:SetPoint("RIGHT", -8, 0);
	QuestGuru_AnnounceFrameMessageHelpButton:SetScript("OnEnter",
		function ()
			GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
			GameTooltip:ClearLines();
			GameTooltip:AddLine("Announce Message Variables");
			GameTooltip:AddDoubleLine("$done","Number of items collected or monsters killed");
			GameTooltip:AddDoubleLine("$needed","Total number of items or monsters needed");
			GameTooltip:AddDoubleLine("$numleft","Number of items or monsters remaining");
			GameTooltip:AddDoubleLine("$name","Objective text without #/#");
			GameTooltip:AddDoubleLine("$questTitle","Name of the quest for this objective");
			GameTooltip:AddDoubleLine("$uitext","The text that showed up onscreen");
			GameTooltip:AddDoubleLine("$complete","Localized complete message: \""..COMPLETE.."\"");
			GameTooltip:AddDoubleLine("$qlink","The quest link of the affected quest");
			GameTooltip:Show();
		end);
	QuestGuru_AnnounceFrameMessageHelpButton:SetScript("OnLeave",
		function ()
			GameTooltip:Hide();
		end);

	QuestGuru_AnnounceFrameMessageItemToggle = CreateFrame("CheckButton", "QuestGuru_AnnounceFrameMessageItemToggle", QuestGuru_AnnounceFrame, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_AnnounceFrameMessageItemToggle:SetPoint("TOPLEFT", "QuestGuru_AnnounceFrameMessageLabel", "BOTTOMLEFT", 0, -2);
	QuestGuru_AnnounceFrameMessageItemToggleText:SetText("Announce item objective progress using message:");
	
	QuestGuru_AnnounceFrameMessageItem = CreateFrame("EditBox", "QuestGuru_AnnounceFrameMessageItem", QuestGuru_AnnounceFrame, "InputBoxTemplate");
	QuestGuru_AnnounceFrameMessageItem:SetPoint("TOPLEFT", "QuestGuru_AnnounceFrameMessageItemToggle", "BOTTOMLEFT", 2, 0);
	QuestGuru_AnnounceFrameMessageItem:SetHeight(20);
	QuestGuru_AnnounceFrameMessageItem:SetWidth(352);
	QuestGuru_AnnounceFrameMessageItem:SetAutoFocus(false);
	QuestGuru_AnnounceFrameMessageItem:SetScript("OnShow",
		function ()
			QuestGuru_AnnounceFrameMessageItem:SetCursorPosition(1);
		end);
	QuestGuru_AnnounceFrameMessageItem:SetScript("OnEscapePressed",
		function ()
			this:ClearFocus();
		end);

	QuestGuru_AnnounceFrameMessageMonsterToggle = CreateFrame("CheckButton", "QuestGuru_AnnounceFrameMessageMonsterToggle", QuestGuru_AnnounceFrame, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_AnnounceFrameMessageMonsterToggle:SetPoint("TOPLEFT", "QuestGuru_AnnounceFrameMessageItem", "BOTTOMLEFT", -2, -8);
	QuestGuru_AnnounceFrameMessageMonsterToggleText:SetText("Announce monster objective progress using message:");
	
	QuestGuru_AnnounceFrameMessageMonster = CreateFrame("EditBox", "QuestGuru_AnnounceFrameMessageMonster", QuestGuru_AnnounceFrame, "InputBoxTemplate");
	QuestGuru_AnnounceFrameMessageMonster:SetPoint("TOPLEFT", "QuestGuru_AnnounceFrameMessageMonsterToggle", "BOTTOMLEFT", 2, 0);
	QuestGuru_AnnounceFrameMessageMonster:SetHeight(20);
	QuestGuru_AnnounceFrameMessageMonster:SetWidth(352);
	QuestGuru_AnnounceFrameMessageMonster:SetAutoFocus(false);
	QuestGuru_AnnounceFrameMessageMonster:SetScript("OnShow",
		function ()
			QuestGuru_AnnounceFrameMessageMonster:SetCursorPosition(1);
		end);
	QuestGuru_AnnounceFrameMessageMonster:SetScript("OnEscapePressed",
		function ()
			this:ClearFocus();
		end);

	QuestGuru_AnnounceFrameMessageEventToggle = CreateFrame("CheckButton", "QuestGuru_AnnounceFrameMessageEventToggle", QuestGuru_AnnounceFrame, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_AnnounceFrameMessageEventToggle:SetPoint("TOPLEFT", "QuestGuru_AnnounceFrameMessageMonster", "BOTTOMLEFT", -2, -8);
	QuestGuru_AnnounceFrameMessageEventToggleText:SetText("Announce event objective progress using message:");
	
	QuestGuru_AnnounceFrameMessageEvent = CreateFrame("EditBox", "QuestGuru_AnnounceFrameMessageEvent", QuestGuru_AnnounceFrame, "InputBoxTemplate");
	QuestGuru_AnnounceFrameMessageEvent:SetPoint("TOPLEFT", "QuestGuru_AnnounceFrameMessageEventToggle", "BOTTOMLEFT", 2, 0);
	QuestGuru_AnnounceFrameMessageEvent:SetHeight(20);
	QuestGuru_AnnounceFrameMessageEvent:SetWidth(352);
	QuestGuru_AnnounceFrameMessageEvent:SetAutoFocus(false);
	QuestGuru_AnnounceFrameMessageEvent:SetScript("OnShow",
		function ()
			QuestGuru_AnnounceFrameMessageEvent:SetCursorPosition(1);
		end);
	QuestGuru_AnnounceFrameMessageEvent:SetScript("OnEscapePressed",
		function ()
			this:ClearFocus();
		end);

	QuestGuru_AnnounceFrameMessageQuestToggle = CreateFrame("CheckButton", "QuestGuru_AnnounceFrameMessageQuestToggle", QuestGuru_AnnounceFrame, "QuestGuru_InterfaceOptionsCheckButtonTemplate");
	QuestGuru_AnnounceFrameMessageQuestToggle:SetPoint("TOPLEFT", "QuestGuru_AnnounceFrameMessageEvent", "BOTTOMLEFT", -2, -8);
	QuestGuru_AnnounceFrameMessageQuestToggleText:SetText("Announce quest completion using message:");
	
	QuestGuru_AnnounceFrameMessageQuest = CreateFrame("EditBox", "QuestGuru_AnnounceFrameMessageQuest", QuestGuru_AnnounceFrame, "InputBoxTemplate");
	QuestGuru_AnnounceFrameMessageQuest:SetPoint("TOPLEFT", "QuestGuru_AnnounceFrameMessageQuestToggle", "BOTTOMLEFT", 2, 0);
	QuestGuru_AnnounceFrameMessageQuest:SetHeight(20);
	QuestGuru_AnnounceFrameMessageQuest:SetWidth(352);
	QuestGuru_AnnounceFrameMessageQuest:SetAutoFocus(false);
	QuestGuru_AnnounceFrameMessageQuest:SetScript("OnShow",
		function ()
			QuestGuru_AnnounceFrameMessageQuest:SetCursorPosition(1);
		end);
	QuestGuru_AnnounceFrameMessageQuest:SetScript("OnEscapePressed",
		function ()
			this:ClearFocus();
		end);
end

function QuestGuru_QuestAnnounceLoadSettings()
	if (QuestGuru_Settings.Announce == nil) then
	    QuestGuru_Settings.Announce={};
	end
	
	if (QuestGuru_Settings.Announce.Enabled ~= true) then
	    QuestGuru_Settings.Announce.Enabled = false;
	end
	QuestGuru_AnnounceFrameAnnounceToggle:SetChecked(QuestGuru_Settings.Announce.Enabled);

	if (QuestGuru_Settings.Announce.item == nil) then
	    QuestGuru_Settings.Announce.item = {};
	end
	if (QuestGuru_Settings.Announce.item.Enabled ~= false) then
	    QuestGuru_Settings.Announce.item.Enabled = true;
	end
	QuestGuru_AnnounceFrameMessageItemToggle:SetChecked(QuestGuru_Settings.Announce.item.Enabled);
	if (QuestGuru_Settings.Announce.item.Text == nil) then
	    QuestGuru_Settings.Announce.item.Text = "Collected $done $name of $needed needed for $questTitle";
	end
	QuestGuru_AnnounceFrameMessageItem:SetText(QuestGuru_Settings.Announce.item.Text);

	if (QuestGuru_Settings.Announce.monster == nil) then
	    QuestGuru_Settings.Announce.monster = {};
	end
	if (QuestGuru_Settings.Announce.monster.Enabled ~= false) then
	    QuestGuru_Settings.Announce.monster.Enabled = true;
	end
	QuestGuru_AnnounceFrameMessageMonsterToggle:SetChecked(QuestGuru_Settings.Announce.monster.Enabled);
	if (QuestGuru_Settings.Announce.monster.Text == nil) then
	    QuestGuru_Settings.Announce.monster.Text = "$done $name of $needed needed for $questTitle";
	end
	QuestGuru_AnnounceFrameMessageMonster:SetText(QuestGuru_Settings.Announce.monster.Text);

	if (QuestGuru_Settings.Announce.event == nil) then
	    QuestGuru_Settings.Announce.event = {};
	end
	if (QuestGuru_Settings.Announce.event.Enabled ~= false) then
	    QuestGuru_Settings.Announce.event.Enabled = true;
	end
	QuestGuru_AnnounceFrameMessageEventToggle:SetChecked(QuestGuru_Settings.Announce.event.Enabled);
	if (QuestGuru_Settings.Announce.event.Text == nil) then
	    QuestGuru_Settings.Announce.event.Text = "$uitext";
	end
	QuestGuru_AnnounceFrameMessageEvent:SetText(QuestGuru_Settings.Announce.event.Text);

	if (QuestGuru_Settings.Announce.Quest == nil) then
	    QuestGuru_Settings.Announce.Quest = {};
	end
	if (QuestGuru_Settings.Announce.Quest.Enabled ~= false) then
	    QuestGuru_Settings.Announce.Quest.Enabled = true;
	end
	QuestGuru_AnnounceFrameMessageQuestToggle:SetChecked(QuestGuru_Settings.Announce.Quest.Enabled);
	if (QuestGuru_Settings.Announce.Quest.Text == nil) then
	    QuestGuru_Settings.Announce.Quest.Text = "$qlink $complete!";
	end
	QuestGuru_AnnounceFrameMessageQuest:SetText(QuestGuru_Settings.Announce.Quest.Text);
	
	if (QuestGuru_Settings.Announce.say ~= true) then
	    QuestGuru_Settings.Announce.say = false;
	end
	QuestGuru_AnnounceFrameChannelSayToggle:SetChecked(QuestGuru_Settings.Announce.say);
	if (QuestGuru_Settings.Announce.party ~= false) then
	    QuestGuru_Settings.Announce.party = true;
	end
	QuestGuru_AnnounceFrameChannelPartyToggle:SetChecked(QuestGuru_Settings.Announce.party);
	if (QuestGuru_Settings.Announce.guild ~= true) then
	    QuestGuru_Settings.Announce.guild = false;
	end
	QuestGuru_AnnounceFrameChannelGuildToggle:SetChecked(QuestGuru_Settings.Announce.guild);
	if (QuestGuru_Settings.Announce.whisper == nil) then
	    QuestGuru_Settings.Announce.whisper = {};
	end
	if (QuestGuru_Settings.Announce.whisper.Enabled ~= true) then
	    QuestGuru_Settings.Announce.whisper.Enabled = false;
	end
	QuestGuru_AnnounceFrameChannelWhisperToggle:SetChecked(QuestGuru_Settings.Announce.whisper.Enabled);
	if (QuestGuru_Settings.Announce.whisper.To == nil) then
	    QuestGuru_Settings.Announce.whisper.To = "";
	end
	QuestGuru_AnnounceFrameChannelWhisperTo:SetText(QuestGuru_Settings.Announce.whisper.To);
end

function QuestGuru_SetAnnounceDefaults()
	QuestGuru_Echo("Resetting Announcer settings to defaults.");
    QuestGuru_Settings.Announce.Enabled = false;
	QuestGuru_AnnounceFrameAnnounceToggle:SetChecked(QuestGuru_Settings.Announce.Enabled);
    QuestGuru_Settings.Announce.item = {};
    QuestGuru_Settings.Announce.item.Enabled = true;
	QuestGuru_AnnounceFrameMessageItemToggle:SetChecked(QuestGuru_Settings.Announce.item.Enabled);
    QuestGuru_Settings.Announce.item.Text = "Collected $done $name of $needed needed for $questTitle";
	QuestGuru_AnnounceFrameMessageItem:SetText(QuestGuru_Settings.Announce.item.Text);
    QuestGuru_Settings.Announce.monster = {};
    QuestGuru_Settings.Announce.monster.Enabled = true;
	QuestGuru_AnnounceFrameMessageMonsterToggle:SetChecked(QuestGuru_Settings.Announce.monster.Enabled);
    QuestGuru_Settings.Announce.monster.Text = "$done $name of $needed needed for $questTitle";
	QuestGuru_AnnounceFrameMessageMonster:SetText(QuestGuru_Settings.Announce.monster.Text);
    QuestGuru_Settings.Announce.event = {};
    QuestGuru_Settings.Announce.event.Enabled = true;
	QuestGuru_AnnounceFrameMessageEventToggle:SetChecked(QuestGuru_Settings.Announce.event.Enabled);
    QuestGuru_Settings.Announce.event.Text = "$uitext";
	QuestGuru_AnnounceFrameMessageEvent:SetText(QuestGuru_Settings.Announce.event.Text);
    QuestGuru_Settings.Announce.Quest = {};
    QuestGuru_Settings.Announce.Quest.Enabled = true;
	QuestGuru_AnnounceFrameMessageQuestToggle:SetChecked(QuestGuru_Settings.Announce.Quest.Enabled);
    QuestGuru_Settings.Announce.Quest.Text = "$qlink $complete!";
	QuestGuru_AnnounceFrameMessageQuest:SetText(QuestGuru_Settings.Announce.Quest.Text);

    QuestGuru_Settings.Announce.say = false;
	QuestGuru_AnnounceFrameChannelSayToggle:SetChecked(QuestGuru_Settings.Announce.say);
    QuestGuru_Settings.Announce.party = true;
	QuestGuru_AnnounceFrameChannelPartyToggle:SetChecked(QuestGuru_Settings.Announce.party);
    QuestGuru_Settings.Announce.guild = false;
	QuestGuru_AnnounceFrameChannelGuildToggle:SetChecked(QuestGuru_Settings.Announce.guild);
    QuestGuru_Settings.Announce.whisper = {};
    QuestGuru_Settings.Announce.whisper.Enabled = false;
	QuestGuru_AnnounceFrameChannelWhisperToggle:SetChecked(QuestGuru_Settings.Announce.whisper.Enabled);
    QuestGuru_Settings.Announce.whisper.To = "";
	QuestGuru_AnnounceFrameChannelWhisperTo:SetText(QuestGuru_Settings.Announce.whisper.To);
end

function QuestGuru_SaveAnnounceSettings()
	if (QuestGuru_AnnounceFrameAnnounceToggle:GetChecked()) then
		QuestGuru_Settings.Announce.Enabled = true;
	else
		QuestGuru_Settings.Announce.Enabled = false;
	end
	if (QuestGuru_AnnounceFrameChannelSayToggle:GetChecked()) then
		QuestGuru_Settings.Announce.say = true;
	else
		QuestGuru_Settings.Announce.say = false;
	end
	if (QuestGuru_AnnounceFrameChannelPartyToggle:GetChecked()) then
		QuestGuru_Settings.Announce.party = true;
	else
		QuestGuru_Settings.Announce.party = false;
	end
	if (QuestGuru_AnnounceFrameChannelGuildToggle:GetChecked()) then
		QuestGuru_Settings.Announce.guild = true;
	else
		QuestGuru_Settings.Announce.guild = false;	
	end
	if (QuestGuru_AnnounceFrameChannelWhisperToggle:GetChecked()) then
		QuestGuru_Settings.Announce.whisper.Enabled = true;
	else
		QuestGuru_Settings.Announce.whisper.Enabled = false;
	end
	QuestGuru_Settings.Announce.whisper.To = QuestGuru_AnnounceFrameChannelWhisperTo:GetText();
	if (QuestGuru_AnnounceFrameMessageItemToggle:GetChecked()) then
		QuestGuru_Settings.Announce.item.Enabled = true;
	else
		QuestGuru_Settings.Announce.item.Enabled = false;
	end
	QuestGuru_Settings.Announce.item.Text = QuestGuru_AnnounceFrameMessageItem:GetText();
	if (QuestGuru_AnnounceFrameMessageMonsterToggle:GetChecked()) then
		QuestGuru_Settings.Announce.monster.Enabled = true;
	else
		QuestGuru_Settings.Announce.monster.Enabled = false;
	end
	QuestGuru_Settings.Announce.monster.Text = QuestGuru_AnnounceFrameMessageMonster:GetText();
	if (QuestGuru_AnnounceFrameMessageEventToggle:GetChecked()) then
		QuestGuru_Settings.Announce.event.Enabled = true;
	else
		QuestGuru_Settings.Announce.event.Enabled = false;
	end
	QuestGuru_Settings.Announce.event.Text = QuestGuru_AnnounceFrameMessageEvent:GetText();
	if (QuestGuru_AnnounceFrameMessageQuestToggle:GetChecked()) then
		QuestGuru_Settings.Announce.Quest.Enabled = true;
	else
		QuestGuru_Settings.Announce.Quest.Enabled = false;
	end
	QuestGuru_Settings.Announce.Quest.Text = QuestGuru_AnnounceFrameMessageQuest:GetText();
end

function QuestGuru_CancelAnnounceChanges()
	QuestGuru_AnnounceFrameAnnounceToggle:SetChecked(QuestGuru_Settings.Announce.Enabled);
	QuestGuru_AnnounceFrameChannelSayToggle:SetChecked(QuestGuru_Settings.Announce.say);
	QuestGuru_AnnounceFrameChannelPartyToggle:SetChecked(QuestGuru_Settings.Announce.party);
	QuestGuru_AnnounceFrameChannelGuildToggle:GetChecked(QuestGuru_Settings.Announce.guild);
	QuestGuru_AnnounceFrameChannelWhisperToggle:GetChecked(QuestGuru_Settings.Announce.whisper.Enabled);
	QuestGuru_AnnounceFrameChannelWhisperTo:SetText(QuestGuru_Settings.Announce.whisper.To);
	QuestGuru_AnnounceFrameMessageItemToggle:SetChecked(QuestGuru_Settings.Announce.item.Enabled);
	QuestGuru_AnnounceFrameMessageItem:SetText(QuestGuru_Settings.Announce.item.Text);
	QuestGuru_AnnounceFrameMessageMonsterToggle:SetChecked(QuestGuru_Settings.Announce.monster.Enabled);
	QuestGuru_AnnounceFrameMessageMonster:SetText(QuestGuru_Settings.Announce.monster.Text);
	QuestGuru_AnnounceFrameMessageEventToggle:SetChecked(QuestGuru_Settings.Announce.event.Enabled);
	QuestGuru_AnnounceFrameMessageEvent:SetText(QuestGuru_Settings.Announce.event.Text);
	QuestGuru_AnnounceFrameMessageQuestToggle:SetChecked(QuestGuru_Settings.Announce.Quest.Enabled);
	QuestGuru_AnnounceFrameMessageQuest:SetText(QuestGuru_Settings.Announce.Quest.Text);
end

function QuestGuru_DoAnnounce(announceText, numDone, numNeeded, itemName, questTitle, arg1, questID)
	if (not QuestGuru_Settings.Announce.Enabled) then return; end

	if (announceText ~= nil) then
	    if (numDone == nil) then numDone = 0; end
	    if (numNeeded == nil) then numNeeded = 0; end
	    announceText = string.gsub(announceText,"$done",numDone);
	    announceText = string.gsub(announceText,"$needed",numNeeded);
	    announceText = string.gsub(announceText,"$numleft",numNeeded-numDone);
	    announceText = string.gsub(announceText,"$name",itemName);
	    announceText = string.gsub(announceText,"$questTitle",questTitle);
	    announceText = string.gsub(announceText,"$uitext",arg1);
	    announceText = string.gsub(announceText,"$complete",COMPLETE);
	    announceText = string.gsub(announceText,"$qlink",GetQuestLink(questID));
	    
	    if (QuestGuru_Settings.Announce.say) then
	    	SendChatMessage(announceText, "SAY");
	    end
	    local partyNum = GetNumPartyMembers();
	    if ((QuestGuru_Settings.Announce.party) and (partyNum > 0)) then
	    	SendChatMessage(announceText, "PARTY");
	    end
	    if ((QuestGuru_Settings.Announce.guild) and IsInGuild()) then
	    	SendChatMessage(announceText, "GUILD");
	    end
	    if (QuestGuru_Settings.Announce.whisper.Enabled) then
	    	SendChatMessage(announceText, "WHISPER", nil, QuestGuru_Settings.Announce.whisper.To);
	    end
	end
end