QuestGuru_Abandon = {};
QuestGuru_AbandonHeaders = {};
QuestGuru_numAbandoned = 0;
QuestGuru_currAbandon = 2;

StaticPopupDialogs["QUESTGURU_CLEARABANDON"] = {
  text = "Do you want to clear the Abandon list?",
  button1 = "Yes",
  button2 = "No",
  OnAccept = function()
      QuestGuru_Abandon = {};
      QuestGuru_UpdateAbandon();
  end,
  timeout = 0,
  whileDead = 1,
  hideOnEscape = 1
};

StaticPopupDialogs["QUESTGURU_DELETEABANDONTITLE"] = {
  text = "Delete \"%s\" from your Abandon log?",
  button1 = "Yes",
  button2 = "No",
  OnAccept = function()
	local qhTitle = getglobal("QuestGuru_QuestAbandonTitle"..QuestGuru_currAbandon - FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame));
	local i, qH;
   	for i, qH in ipairs(QuestGuru_Abandon) do
   		if (qH.qID == qhTitle.qID) then
   			tremove(QuestGuru_Abandon, i)
			QuestGuru_Quests[QuestGuru_RealmName][qH.qID][QuestGuru_Player] = nil;
			break;
		end
	end
	QuestGuru_UpdateAbandon();
  end,
  timeout = 0,
  whileDead = 1,
  hideOnEscape = 1
};

function QuestGuru_QuestAbandonTitleMenu_OnLoad()
	local info = UIDropDownMenu_CreateInfo();
	info.func = QuestGuru_QuestAbandonTitleMenu_OnClick;
	info.checked = nil;
	info.icon = nil;

	info.text = "Delete Quest";
	info.value = "delete";
	UIDropDownMenu_AddButton(info, 1);

	info.text = "-----------------";
	info.value = "-";
	info.isTitle = 1;
	UIDropDownMenu_AddButton(info, 1);

	info = UIDropDownMenu_CreateInfo();
	info.func = QuestGuru_QuestAbandonTitleMenu_OnClick;
	info.checked = nil;
	info.icon = nil;
	info.text = "Cancel";
	info.value = "cancel";
	UIDropDownMenu_AddButton(info, 1);

end

function QuestGuru_QuestAbandonTitleMenu_OnClick()
	local qhTitle = getglobal("QuestGuru_QuestAbandonTitle"..QuestGuru_currAbandon - FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame));
	if (this.value == "delete") then
		StaticPopup_Show("QUESTGURU_DELETEABANDONTITLE", qhTitle:GetText());
	end
end

function QuestGuru_QuestAbandonTitleButton_OnLoad()
	this:RegisterForClicks("LeftButtonUp", "RightButtonUp");
	this:RegisterEvent("UNIT_QUEST_LOG_CHANGED");
	this:RegisterEvent("PARTY_MEMBER_ENABLE");
	this:RegisterEvent("PARTY_MEMBER_DISABLE");
end

function QuestGuru_QuestAbandonTitleButton_OnEvent(event)
	if ( GameTooltip:IsOwned(this) ) then
		GameTooltip:Hide();
--		QuestLog_UpdatePartyInfoTooltip();
	end
end

function QuestGuru_QuestAbandonTitleButton_OnClick(button)
	local questName = this:GetText();
	local questIndex = this:GetID() + FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);
	
	QuestLog_SetAbandonSelection(questIndex)
	if (button == "LeftButton") then
		if ( IsShiftKeyDown() ) then
			-- If header then return
			if ( this.isHeader ) then
				return;
			end
			-- Otherwise try to put it into chat
			if ( ChatFrameEditBox:IsVisible() ) then
				local n, qH, currHead;
				local c = 0;
				for n, qH in ipairs(QuestGuru_Abandon) do
					if (qH.Header ~= currHead) then
						currHead = qH.Header;
						c = c + 1;
					end
					if (QuestGuru_AbandonHeaders[currHead] ~= false) then
						c = c + 1;
					end
					if (c == questIndex) then
					    if (QuestGuru_Abandon[n].Link) then
					        ChatFrameEditBox:Insert(QuestGuru_Abandon[n].Link);
						else
							ChatFrameEditBox:Insert(strtrim("["..QuestGuru_Abandon[n].Level.."] "..QuestGuru_Abandon[n].Title));
						end
					end
				end
			end
		end
	elseif (button == "RightButton") then
		ToggleDropDownMenu(1, nil, QuestGuru_QuestAbandonTitleMenu, this:GetName(), 0, 0)
	end	
	QuestGuru_UpdateAbandon();
end

function QuestGuru_QuestAbandonTitleButton_OnEnter()
	-- Set highlight
	getglobal(this:GetName().."Tag"):SetTextColor(HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
	getglobal(this:GetName().."Level"):SetTextColor(HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);

	-- Set group info tooltip
	QuestGuru_UpdateAbandonPartyInfoTooltip();
end

function QuestGuru_UpdateAbandonPartyInfoTooltip()
	if (not QuestGuru_Settings.ShowAltStatus) then return; end
	if (this.isHeader) then return; end

	local index = this:GetID() + FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);
	GameTooltip_SetDefaultAnchor(GameTooltip, this);
	
	local lastHeader = "";
	local altOnQuest;
	for i, questAbandon in ipairs(QuestGuru_Abandon) do
		if (questAbandon.Header ~= lastHeader) then
			lastHeader = questAbandon.Header;
			index = index - 1;
		end
		if (not QuestGuru_AbandonHeaders[questAbandon.Header]) then
			index = index + 1;
		end
		if (i == index) then
			local questTitleText = questAbandon.Title;
			GameTooltip:SetText(questTitleText);

			local i, v;
			local questDescription = questAbandon.Description;
			local questObjectives = questAbandon.ObjectiveText;
			local qID = this.qID;
	
			if (QuestGuru_Quests[QuestGuru_RealmName][qID] ~= nil) then
				for i, v in pairs(QuestGuru_Quests[QuestGuru_RealmName][qID]) do
					if ((i ~= "level") and (i ~= QuestGuru_Player) and (i ~= "_link")) then
						if (not altOnQuest) then
							GameTooltip:AddLine("---------- Alts Quest Status ----------");
							altOnQuest = true;
						end
						if (v == "Complete") then
							GameTooltip:AddDoubleLine(i, v, 1, 1, 1, 0, 1, 0);
						elseif (v == "Abandoned") then
							GameTooltip:AddDoubleLine(i, v, 1, 1, 1, 1, 0, 0);
						else
							GameTooltip:AddDoubleLine(i, "Active", 1, 1, 1, 0, 1, 1);
							local currStatus = QuestGuru_strsplit(";", v);

							local numObjectives = questAbandon.Objectives;
			
							if (numObjectives ~= nil) then
								for j=1, numObjectives, 1 do
									local text = questAbandon.Objective[j].Description;
									local type = questAbandon.Objective[j].Type;
				
									if (type == "item") then
										local numNeeded = questAbandon.Objective[j].numNeeded;
								    	GameTooltip:AddDoubleLine("  - "..text, currStatus[j+1].."/"..numNeeded, 1, 1, 1, 1, 1, 1);
								    elseif (type == "monster") then
										local x, y, name, numItems, numNeeded = string.find(text,"(.*):%s*([%d]+)%s*/%s*([%d]+)");
								    	GameTooltip:AddDoubleLine("  - "..name, currStatus[j+1].."/"..numNeeded, 1, 1, 1, 1, 1, 1);
									else
										if (currStatus[j+1] == 1) then
											GameTooltip:AddDoubleLine("  - "..text, "Complete", 1, 1, 1, 0, 1, 0);
										else
											GameTooltip:AddDoubleLine("  - "..text, "Not Complete", 1, 1, 1, 1, 0, 0);
										end
									end
								end
							end
						end
					end
				end
			end
		end
	end
	if (altOnQuest) then
		GameTooltip:Show();
	else
		GameTooltip:Hide();
	end
end

function QuestGuru_QuestAbandonStart_OnClick()
	local scrollOffset = FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);
	local questTitle = getglobal("QuestGuru_QuestAbandonTitle"..QuestGuru_currAbandon - scrollOffset);
	local qID;
	if (not questTitle) then
		local n, qH, currHead;
		local c = 0;
		for n, qH in ipairs(QuestGuru_Abandon) do
			if (qH.Header ~= currHead) then
				currHead = qH.Header;
				c = c + 1;
			end
			if (QuestGuru_AbandonHeaders[currHead] ~= false) then
				c = c + 1;
			end
			if (c == QuestGuru_currAbandon) then
				qID = qH.qID;
			end
		end
	else
		qID = questTitle.qID;
	end
	if (not qID) then return; end
	for i, questAbandon in ipairs(QuestGuru_Abandon) do
		if (questAbandon.qID == qID) then
			QuestGuru_WorldmapIconTexture:SetTexCoord(0, 0.125, 0.5, 1);
			QuestGuru_ShowMap(questAbandon.StartNPCZone, questAbandon.StartPosX, questAbandon.StartPosY, questAbandon.StartNPCName);
		end
	end
end

function QuestGuru_QuestAbandonStart_OnEnter()
	local tempWidth, maxWidth;
	local scrollOffset = FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);
	local questTitle = getglobal("QuestGuru_QuestAbandonTitle"..QuestGuru_currAbandon - scrollOffset);
	local qID;
	if (not questTitle) then
		local n, qH, currHead;
		local c = 0;
		for n, qH in ipairs(QuestGuru_Abandon) do
			if (qH.Header ~= currHead) then
				currHead = qH.Header;
				c = c + 1;
			end
			if (QuestGuru_AbandonHeaders[currHead] ~= false) then
				c = c + 1;
			end
			if (c == QuestGuru_currAbandon) then
				qID = qH.qID;
			end
		end
	else
		qID = questTitle.qID;
	end
	if (not qID) then return; end

	local NPCColor, AreaColor;
	if (QuestGuru_Settings.Colorize.NPCNames.Enabled) then
		NPCColor = QuestGuru_Settings.Colorize.NPCNames.Color;
	else
		NPCColor = { r=0, g=0, b=0 };
	end
	if (QuestGuru_Settings.Colorize.AreaNames.Enabled) then
		AreaColor = QuestGuru_Settings.Colorize.AreaNames.Color;
	else
		AreaColor = { r=0, g=0, b=0 };
	end
	local i, questHistory;

	for i, questAbandon in ipairs(QuestGuru_Abandon) do
		if (questAbandon.qID == qID) then
			QuestGuru_QuestStartInfoFrame:ClearAllPoints();
	        QuestGuru_QuestStartInfoFrame:SetPoint("BOTTOM", QuestGuru_QuestAbandonStart, "TOP");
	        QuestGuru_QuestStartInfoTitle:SetText("Quest Start Details");
	        maxWidth = QuestGuru_QuestStartInfoTitle:GetWidth();

	        QuestGuru_QuestStartInfoNPC:SetText(questAbandon.StartNPCName);
			QuestGuru_QuestStartInfoNPC:SetTextColor(NPCColor.r, NPCColor.g, NPCColor.b);

	        QuestGuru_QuestStartInfoPOS:SetText("("..questAbandon.StartPosX..","..questAbandon.StartPosY..")");
			QuestGuru_QuestStartInfoPOS:SetTextColor(AreaColor.r, AreaColor.g, AreaColor.b);
			tempWidth = QuestGuru_QuestStartInfoNPC:GetWidth() + QuestGuru_QuestStartInfoPOS:GetWidth() + 8;
			if (tempWidth > maxWidth) then maxWidth = tempWidth; end

	        QuestGuru_QuestStartInfoArea:SetText(questAbandon.StartNPCZone);
			QuestGuru_QuestStartInfoArea:SetTextColor(AreaColor.r, AreaColor.g, AreaColor.b);
			tempWidth = QuestGuru_QuestStartInfoArea:GetWidth();
			if (tempWidth > maxWidth) then maxWidth = tempWidth; end

			QuestGuru_QuestStartInfoTimeLabel:SetText("Start time:");
			QuestGuru_QuestStartInfoTime:SetText(questAbandon.StartTime);
			tempWidth = QuestGuru_QuestStartInfoTimeLabel:GetWidth() + QuestGuru_QuestStartInfoTime:GetWidth() + 8;
			if (tempWidth > maxWidth) then maxWidth = tempWidth; end

			QuestGuru_QuestStartInfoLevelLabel:SetText("Start level:");
			QuestGuru_QuestStartInfoLevel:SetText(questAbandon.StartLevel);
			tempWidth = QuestGuru_QuestStartInfoLevelLabel:GetWidth() + QuestGuru_QuestStartInfoLevel:GetWidth() + 8;
			if (tempWidth > maxWidth) then maxWidth = tempWidth; end

			QuestGuru_QuestStartInfoFrame:SetWidth(maxWidth + 18);
	        QuestGuru_QuestStartInfoFrame:Show();
        end
	end
end

function QuestGuru_QuestAbandonFinish_OnEnter()
--	local questName = QuestGuru_QuestAbandonQuestTitle:GetText();
--	local NPCColor = QuestGuru_Settings.Colorize.NPCNames.Color;
--	local AreaColor = QuestGuru_Settings.Colorize.AreaNames.Color;
--	local i, questHistory;

--	for i, questAbandon in ipairs(QuestGuru_Abandon) do
--		if (questAbandon.Title == questName) then
--			GameTooltip:Hide();
--			GameTooltip:ClearLines();
--			GameTooltip:SetOwner(this,"ANCHOR_CURSOR");
--			GameTooltip:AddLine("Quest Abandon Details",1,1,1);
--			GameTooltip:AddDoubleLine("Abandoned on:",questAbandon.FinishTime,1,1,1);
--			GameTooltip:AddDoubleLine("Abandoned at level:",questAbandon.FinishLevel,1,1,1);
--			GameTooltip:Show();
--		end
--	end
end

function QuestGuru_SaveAbandon()
	local inserted = false;
	local i, qH;
	local qLinki, qLinkj, qLinkNum;
	
	if (QuestGuru_LastCompleteQuest.Level == nil) then
	    return;
	end
    if (QuestGuru_LastCompleteQuest.Title ~= nil) then
		for i, qH in ipairs(QuestGuru_Abandon) do
			if (qH.Header == QuestGuru_LastCompleteQuest.Header) then
				if (qH.Level == QuestGuru_LastCompleteQuest.Level) then
					if (qH.qID == qID) then
						if (qH.Count == nil) then qH.Count = 1; end
						qH.Count = qH.Count + 1;
						inserted = true;
						break;
					end
					if (qH.Title > QuestGuru_LastCompleteQuest.Title) then
						tinsert(QuestGuru_Abandon, i, QuestGuru_LastCompleteQuest);
						inserted = true;
						break;
					end
				elseif (qH.Level > QuestGuru_LastCompleteQuest.Level) then
					tinsert(QuestGuru_Abandon, i, QuestGuru_LastCompleteQuest);
					inserted = true;
					break;
				end
			elseif (qH.Header > QuestGuru_LastCompleteQuest.Header) then
				tinsert(QuestGuru_Abandon, i, QuestGuru_LastCompleteQuest);
				inserted = true;
				break;
			end
			if (inserted == true) then
				qLinki, qLinkj, qLinkNum = string.find(qH.Link, (":(%d+):"));
			end
		end
		if (not inserted) then
			tinsert(QuestGuru_Abandon, QuestGuru_LastCompleteQuest);
			inserted = true;
		end
		QuestGuru_WatchList[QuestGuru_LastCompleteQuest.Title] = nil;
		QuestGuru_QuestStart[QuestGuru_LastCompleteQuest.Title] = nil;
	end
	QuestGuru_LastCompleteQuest = {};
	QuestGuru_UpdateAbandon();
	if (qLinkNum) then
		QuestGuru_CommSendPGMessage("010C", qLinkNum);
	end
end
hooksecurefunc("AbandonQuest", QuestGuru_SaveAbandon);

function QuestGuru_UpdateAbandon()
	local count=0;
	local headCount = 0;
	local titleCount = 0;
	local currAbandon = 1;
	local currHeader = "";
	local questAbandon;
	local scrollOffset = FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);

	local questIndex, questAbandonTitle, questTitleTag, questLevel, questNormalText, questHighlight;
	local questLogTitleText, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily, color;
	local numPartyMembers, partyMembersOnQuest, tempWidth, textWidth;
	local questTagText, strLvl, textLeft;

	QuestGuru_QuestAbandonHighlightFrame:Hide();

	for i, questAbandon in ipairs(QuestGuru_Abandon) do
		if ((titleCount+headCount >= scrollOffset) or (questAbandon.Header ~= currHeader and titleCount+headCount+1==scrollOffset)) then
			if (currAbandon <= QUESTGURU_QUESTS_DISPLAYED) then

				if ((titleCount+headCount+1) == scrollOffset and questAbandon.Header ~= currHeader) then
					currHeader = questAbandon.Header;
					headCount = headCount + 1;
				else
					if (questAbandon.Header ~= currHeader) then
						questAbandonTitle = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon);
						questTitleTag = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon.."Tag");
						questLevel = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon.."Level");
						questNormalText = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon.."NormalText");
						questHighlight = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon.."Highlight");
						questAbandonTitle:SetText(questAbandon.Header);
						if (QuestGuru_AbandonHeaders[questAbandon.Header] ~= false) then
							questAbandonTitle:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-Up");
							QuestGuru_AbandonHeaders[questAbandon.Header] = true;
						else
							questAbandonTitle:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-Up");
						end
						questHighlight:SetTexture("Interface\\Buttons\\UI-PlusButton-Hilight");
						questAbandonTitle.isHeader = true;
						questAbandonTitle.qID = "";
						currHeader = questAbandon.Header;
						color = QuestDifficultyColor["header"];
						questTitleTag:SetText("");
						questTitleTag:SetTextColor(color.r, color.g, color.b);
						questLevel:SetText("");
						questAbandonTitle:SetTextColor(color.r, color.g, color.b);
						questAbandonTitle.r = color.r;
						questAbandonTitle.g = color.g;
						questAbandonTitle.b = color.b;
						questAbandonTitle:Show();
						textLeft = 20;
						questNormalText:SetPoint("LEFT", textLeft, 0);
						headCount = headCount + 1;
						currAbandon = currAbandon + 1;
					end
				end

				if ((currAbandon <= QUESTGURU_QUESTS_DISPLAYED) and (QuestGuru_AbandonHeaders[questAbandon.Header] ~= false) and (strfind(strlower(questAbandon.Title),strlower(QuestGuru_QuestAbandonSearch:GetText())))) then
					questAbandonTitle = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon);
					questTitleTag = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon.."Tag");
					questLevel = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon.."Level");
					questNormalText = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon.."NormalText");
					questHighlight = getglobal("QuestGuru_QuestAbandonTitle"..currAbandon.."Highlight");

					strLvl = questAbandon.Level
					if (questAbandon.Daily) then
					    strLvl = strLvl.."Y";
					end
					if (questAbandon.Tag ~= nil) then
						if ((questAbandon.Tag == "Group") and (questAbandon.SuggestedGroup > 0)) then
							strLvl = strLvl.."G"..questAbandon.SuggestedGroup;
						elseif (questAbandon.Tag == "Dungeon") then
							strLvl = strLvl.."D";
						else
							strLvl = strLvl.."+"
						end
					end
					questLevel:SetText(strLvl);
					local s = questAbandon.Title;
					if (questAbandon.Count ~= nil and questAbandon.Daily) then
						s = s.." ("..questAbandon.Count..")";
					end
					questAbandonTitle:SetText(s);
					
					if (QuestGuru_Settings.ShowLevels == nil) then
					    QuestGuru_Settings.ShowLevels = {};
					end
					if (QuestGuru_Settings.ShowLevels.Abandon) then
					    textLeft = 40;
					    questLevel:Show();
					else
					    textLeft = 16;
					    questLevel:Hide();
					end
					questNormalText:SetPoint("LEFT", textLeft, 0);

					QuestGuru_QuestLogDummyText:SetText(s);

					questAbandonTitle:SetNormalTexture("");
					questHighlight:SetTexture("");

					-- Save if its a header or not
					questAbandonTitle.isHeader = false;
					
					if (questAbandon.qID == nil) then
						questAbandon.qID = QuestGuru_GetQuestID(questAbandon.Title, questAbandon.ObjectiveText, questAbandon.Description);
					end
					questAbandonTitle.qID = questAbandon.qID;
					if (QuestGuru_Quests[QuestGuru_RealmName][questAbandon.qID] == nil) then
					    QuestGuru_Quests[QuestGuru_RealmName][questAbandon.qID] = {};
					end

					if (questAbandon.Link == nil) then
					    questAbandon.Link = QuestGuru_Quests[QuestGuru_RealmName][questAbandon.qID]["_link"];
					else
						local qIDi, qIDj, qNum = string.find(questAbandon.Link, (":(%d+):"));
					    if (QuestGuru_Quests[QuestGuru_RealmName][qNum] == nil) then
					        QuestGuru_Quests[QuestGuru_RealmName][qNum] = {};
						end
						QuestGuru_Quests[QuestGuru_RealmName][qNum][questAbandon.qID] = 1;
					end

					questTag = questAbandon.Tag;
					if ( questTag ) then
					    if ((questTag == "Group") and (questAbandon.SuggestedGroup == 0)) then
					        questTag = "Elite";
						end
						questTagText = "("..questTag
						if ((questAbandon.SuggestedGroup ~= nil) and (questAbandon.SuggestedGroup > 0)) then
							questTagText = questTagText..":"..questAbandon.SuggestedGroup;
						end
						questTagText = questTagText..")";
						questTitleTag:SetText(questTagText);
						-- Shrink text to accomdate quest tags without wrapping
						tempWidth = 300 - textLeft - 8 - questTitleTag:GetWidth();

						if ( QuestGuru_QuestLogDummyText:GetWidth() > tempWidth ) then
							textWidth = tempWidth;
						else
							textWidth = QuestGuru_QuestLogDummyText:GetWidth();
						end

						questNormalText:SetWidth(tempWidth);
					else
						questTitleTag:SetText("");
						questNormalText:SetWidth(300 - textLeft);
					end

					-- Color the quest title and highlight according to the difficulty level
					local playerLevel = UnitLevel("player");
					color = GetDifficultyColor(questAbandon.Level);
					questTitleTag:SetTextColor(color.r, color.g, color.b);
					questAbandonTitle:SetTextColor(color.r, color.g, color.b);
					questLevel:SetTextColor(color.r, color.g, color.b);
					questAbandonTitle.r = color.r;
					questAbandonTitle.g = color.g;
					questAbandonTitle.b = color.b;
					questAbandonTitle:Show();

					-- Place the highlight and lock the highlight state
					if ( QuestGuru_currAbandon == currAbandon + scrollOffset ) then
						QuestGuru_QuestAbandonHighlightFrame:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonTitle"..currAbandon, "TOPLEFT", 0, 0);
						QuestGuru_QuestAbandonSkillHighlight:SetVertexColor(questAbandonTitle.r, questAbandonTitle.g, questAbandonTitle.b);
						QuestGuru_QuestAbandonHighlightFrame:Show();
						questTitleTag:SetTextColor(HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
						questLevel:SetTextColor(HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
						questAbandonTitle:LockHighlight();
					else
						questAbandonTitle:UnlockHighlight();
					end

					currAbandon = currAbandon + 1;
				end
			else
				if (questAbandon.Header ~= currHeader) then
					currHeader = questAbandon.Header;
					headCount = headCount + 1;
				end
			end
		else
			if (questAbandon.Header ~= currHeader) then
				currHeader = questAbandon.Header;
				headCount = headCount + 1;
			end
		end
		if (QuestGuru_AbandonHeaders[questAbandon.Header] ~= false) then
			titleCount = titleCount + 1;
		end
		count = count + 1;
	end

	-- ScrollFrame update
	FauxScrollFrame_Update(QuestGuru_QuestAbandonListScrollFrame, titleCount + headCount, QUESTGURU_QUESTS_DISPLAYED, QUESTLOG_QUEST_HEIGHT, nil, nil, nil, QuestGuru_QuestAbandonHighlightFrame, 293, 316 )
	local currTab = PanelTemplates_GetSelectedTab(QuestGuru_QuestLogFrame);
	if ( count == 0 ) then
	    if (currTab == 3) then
	        QuestGuru_QuestLogNoQuestsText:SetText("No Abandoned Quests");
			QuestGuru_EmptyQuestLogFrame:Show();
		end
		QuestGuru_QuestAbandonDetailScrollFrame:Hide();
	else
	    if (currTab == 3) then
			QuestGuru_EmptyQuestLogFrame:Hide();
		end
		QuestGuru_QuestAbandonDetailScrollFrame:Show();
	end
	QuestGuru_QuestLogFrameTab3:SetText("Abandoned ("..count..")");
	QuestGuru_UpdateTabs();

	for i=currAbandon, QUESTGURU_QUESTS_DISPLAYED do
		getglobal("QuestGuru_QuestAbandonTitle"..i):Hide();
	end
end

function QuestLog_SetAbandonSelection(questID)
	local selectedQuest;
	if ( questID == 0 ) then
		QuestGuru_QuestAbandonDetailScrollFrame:Hide();
		return;
	end

	-- Get xml id
	local id = questID - FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);

	QuestGuru_currAbandon = questID;

	local titleButton = getglobal("QuestGuru_QuestAbandonTitle"..id);
	local titleButtonTag = getglobal("QuestGuru_QuestAbandonTitle"..id.."Tag");

	if ( titleButton.isHeader ) then
		if ( QuestGuru_AbandonHeaders[titleButton:GetText()] == true ) then
			QuestGuru_AbandonHeaders[titleButton:GetText()] = false;
			QuestGuru_UpdateAbandon();
			return;
		else
			QuestGuru_AbandonHeaders[titleButton:GetText()] = true;
			QuestGuru_UpdateAbandon();
			return;
		end
	else
		-- Set newly selected quest and highlight it
		local scrollFrameOffset = FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);
		if ( questID > scrollFrameOffset and questID <= (scrollFrameOffset + QUESTGURU_QUESTS_DISPLAYED) ) then
			titleButton:LockHighlight();
			titleButtonTag:SetTextColor(HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
			QuestGuru_QuestAbandonSkillHighlight:SetVertexColor(titleButton.r, titleButton.g, titleButton.b);
			QuestGuru_QuestAbandonHighlightFrame:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonTitle"..id, "TOPLEFT", 5, 0);
			QuestGuru_QuestAbandonHighlightFrame:Show();
		end
	end
	QuestLog_UpdateQuestAbandonDetails();
end

function QuestLog_UpdateQuestAbandonDetails(doNotScroll)
	local questAbandon;
	local questFound = false;
	local i, qH, NPCColor, PosColor;

	local scrollOffset = FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);
	local qID = getglobal("QuestGuru_QuestAbandonTitle"..QuestGuru_currAbandon - scrollOffset).qID;

	for i, qH in ipairs(QuestGuru_Abandon) do
		if (qH.qID == qID) then
			questAbandon = qH;
			questFound = true;
			break;
		end
	end

	if (not questFound) then
	    return;
	end

	local questTitle = questAbandon.Title;
	local lastObjective;

-- Added LightHeaded support
if (IsAddOnLoaded("LightHeaded")) then
	if (PanelTemplates_GetSelectedTab(QuestGuru_QuestLogFrame) == 3) then
		if (questAbandon.Link) then
			local i, j, qNum = string.find(questAbandon.Link, (":(%d+):"));
			if LightHeaded.db.profile.singlepage then
				LightHeaded:UpdateFrame(tonumber(qNum), nil)
			else
				LightHeaded:UpdateFrame(tonumber(qNum), 1)
			end
		else
			LightHeaded:UpdateFrame(0, nil);
		end
	end
end

-- End LightHeaded support

	if ( not questTitle ) then
		questTitle = "";
	end
	QuestGuru_QuestAbandonQuestTitle:SetText(questTitle);

	local questDescription = gsub(questAbandon.Description,"<%name%>",QuestGuru_Player);
    
	QuestGuru_QuestAbandonObjectivesText:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonQuestTitle", "BOTTOMLEFT", 0, -5);
	QuestGuru_QuestAbandonStart:Hide();
	QuestGuru_QuestAbandonFinish:Hide();
	if (questAbandon ~= nil) then
		if ((questAbandon.StartNPCName ~= nil) and (questAbandon.StartNPCName ~= "Unknown") and (questAbandon.StartPosX ~= nil) and (questAbandon.StartPosY ~= nil)) then
			QuestGuru_QuestAbandonStartNPCName:SetText(questAbandon.StartNPCName);
			if (QuestGuru_Settings.Colorize.NPCNames.Enabled) then
				NPCColor = QuestGuru_Settings.Colorize.NPCNames.Color;
			else
				NPCColor = { r=0, g=0, b=0 };
			end
			QuestGuru_QuestAbandonStartNPCName:SetTextColor(NPCColor.r, NPCColor.g, NPCColor.b);
			QuestGuru_QuestAbandonStartPos:SetText("(" .. questAbandon.StartPosX .. "," .. questAbandon.StartPosY .. ")");
			if (QuestGuru_Settings.Colorize.AreaNames.Enabled) then
				PosColor = QuestGuru_Settings.Colorize.AreaNames.Color;
			else
				PosColor = { r=0, g=0, b=0 };
			end
			QuestGuru_QuestAbandonStartPos:SetTextColor(PosColor.r, PosColor.g, PosColor.b);
			local tempWidth = QuestGuru_QuestAbandonStartLabel:GetWidth() + QuestGuru_QuestAbandonStartPos:GetWidth();
			QuestGuru_QuestAbandonStartNPCName:SetWidth(285 - tempWidth);
			QuestGuru_QuestAbandonStart:Show();
			QuestGuru_QuestAbandonObjectivesText:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonStart", "BOTTOMLEFT", 0, -8);
		end
		if (questAbandon.FinishTime ~= nil) then
			QuestGuru_QuestAbandonFinishNPCName:SetText(questAbandon.FinishTime);
			QuestGuru_QuestAbandonFinishPos:SetText("");
			QuestGuru_QuestAbandonFinish:Show();
			QuestGuru_QuestAbandonObjectivesText:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonFinish", "BOTTOMLEFT", 0, -8);
		end
	end
	
	local questObjectives = gsub(questAbandon.ObjectiveText,"<%name%>",QuestGuru_Player);

	questObjectives = QuestGuru_ColorizeText(questObjectives);
	QuestGuru_QuestAbandonObjectivesText:SetText(questObjectives);

	QuestGuru_QuestAbandonTimerText:Hide();
	QuestGuru_QuestAbandonObjective1:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonObjectivesText", "BOTTOMLEFT", 0, -10);

	local numObjectives = questAbandon.Objectives;
	local currObj = 0;

	for i=1, 10 do
		getglobal("QuestGuru_QuestAbandonObjective"..i):Hide();
	end

	for i=1, numObjectives, 1 do
		local text = questAbandon.Objective[i].Description;
		local type = questAbandon.Objective[i].Type;
--		if (type ~= "item") then
			currObj = currObj + 1;
			local string = getglobal("QuestGuru_QuestAbandonObjective"..currObj);
			if ( not text or strlen(text) == 0 ) then
				text = type;
			end
			if (questAbandon.Objective[i].numNeeded ~= nil) then
				text = text.." ("..questAbandon.Objective[i].numNeeded..")";
			end
			string:SetTextColor(0, 0, 0);
			string:SetText(text);
			string:Show();
			QuestFrame_SetAsLastShown(string);
			lastObjective = string;
--		end
	end

	-- If there's money required then anchor and display it
	if ( questAbandon.RequiredMoney > 0 ) then
		if ( numObjectives > 0 ) then
			QuestGuru_QuestAbandonRequiredMoneyText:SetPoint("TOPLEFT", lastObjective, "BOTTOMLEFT", 0, -4);
		else
			QuestGuru_QuestAbandonRequiredMoneyText:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonObjectivesText", "BOTTOMLEFT", 0, -10);
		end

		MoneyFrame_Update("QuestGuru_QuestAbandonRequiredMoneyFrame", questAbandon.RequiredMoney);

		QuestGuru_QuestAbandonRequiredMoneyText:SetTextColor(0.2, 0.2, 0.2);
		SetMoneyFrameColor("QuestGuru_QuestAbandonRequiredMoneyFrame", 1.0, 1.0, 1.0);

		QuestGuru_QuestAbandonRequiredMoneyText:Show();
		QuestGuru_QuestAbandonRequiredMoneyFrame:Show();
	else
		QuestGuru_QuestAbandonRequiredMoneyText:Hide();
		QuestGuru_QuestAbandonRequiredMoneyFrame:Hide();
	end

	if ( questAbandon.SuggestedGroup > 0 ) then
		local suggestedGroupString = format(QUEST_SUGGESTED_GROUP_NUM, questAbandon.SuggestedGroup);
		QuestGuru_QuestAbandonSuggestedGroupNum:SetText(suggestedGroupString);
		QuestGuru_QuestAbandonSuggestedGroupNum:Show();
		QuestGuru_QuestAbandonSuggestedGroupNum:ClearAllPoints();
		if ( questAbandon.RequiredMoney > 0 ) then
			QuestGuru_QuestAbandonSuggestedGroupNum:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonRequiredMoneyText", "BOTTOMLEFT", 0, -4);
		elseif ( numObjectives > 0 ) then
			QuestGuru_QuestAbandonSuggestedGroupNum:SetPoint("TOPLEFT", lastObjective, "BOTTOMLEFT", 0, -4);
		else
			QuestGuru_QuestAbandonSuggestedGroupNum:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonObjectivesText", "BOTTOMLEFT", 0, -10);
		end
	else
		QuestGuru_QuestAbandonSuggestedGroupNum:Hide();
	end

	if ( questAbandon.SuggestedGroup > 0 ) then
		QuestGuru_QuestAbandonDescriptionTitle:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonSuggestedGroupNum", "BOTTOMLEFT", 0, -10);
	elseif ( questAbandon.RequiredMoney > 0 ) then
		QuestGuru_QuestAbandonDescriptionTitle:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonRequiredMoneyText", "BOTTOMLEFT", 0, -10);
	elseif ( numObjectives > 0 ) then
		QuestGuru_QuestAbandonDescriptionTitle:SetPoint("TOPLEFT", lastObjective, "BOTTOMLEFT", 0, -10);
	else
		QuestGuru_QuestAbandonDescriptionTitle:SetPoint("TOPLEFT", "QuestGuru_QuestAbandonObjectivesText", "BOTTOMLEFT", 0, -10);
	end
	if ( questDescription ) then
	    questDescription = QuestGuru_ColorizeText(questDescription);
		QuestGuru_QuestAbandonQuestDescription:SetText(questDescription);
		QuestFrame_SetAsLastShown(QuestGuru_QuestAbandonQuestDescription);
	end
	local numRewards = questAbandon.Rewards;
	local numChoices = questAbandon.Choices;
	local money = questAbandon.RewardMoney;
	local honor = questAbandon.Honor;
	local playerTitle = questAbandon.RewardTitle;

	if ( playerTitle or (numRewards + numChoices + money + honor) > 0 ) then
		QuestGuru_QuestAbandonRewardTitleText:Show();
		QuestFrame_SetAsLastShown(QuestGuru_QuestAbandonRewardTitleText);
	else
		QuestGuru_QuestAbandonRewardTitleText:Hide();
	end

	QuestGuru_QuestAbandonFrameItems_Update("QuestAbandon");
	if ( not doNotScroll ) then
		QuestGuru_QuestAbandonDetailScrollFrameScrollBar:SetValue(0);
	end
	QuestGuru_QuestAbandonDetailScrollFrame:UpdateScrollChildRect();
end

function QuestGuru_QuestAbandonFrameItems_Update(questState)
	local isQuestLog = 0;
	local questAbandon;

	if ( questState == "QuestAbandon" ) then
		isQuestLog = 1;
		questState = "QuestGuru_QuestAbandon";
	end

	local scrollOffset = FauxScrollFrame_GetOffset(QuestGuru_QuestAbandonListScrollFrame);
	local qID = getglobal("QuestGuru_QuestAbandonTitle"..QuestGuru_currAbandon - scrollOffset).qID;

	for i, qH in ipairs(QuestGuru_Abandon) do
		if (qH.qID == qID) then
			questAbandon = qH;
			questFound = true;
			break;
		end
	end

	if (not questFound) then
	    return
	end

	local numQuestRewards = questAbandon.Rewards;
	local numQuestChoices = questAbandon.Choices;
	local numQuestSpellRewards = questAbandon.SpellRewards;
	local money = questAbandon.RewardMoney;
	local honor = questAbandon.Honor;
	local playerTitle = questAbandon.RewardTitle;
	local spacerFrame = QuestGuru_QuestAbandonSpacerFrame;

	local totalRewards = numQuestRewards + numQuestChoices + numQuestSpellRewards;
	local questItemName = questState.."Item";
	local material = QuestFrame_GetMaterial();
	local honorFrame = getglobal(questState.."HonorFrame");
	local moneyFrame = getglobal(questState.."MoneyFrame");
	local playerTitleFrame = getglobal(questState.."PlayerTitleFrame");
	local questItemReceiveText = getglobal(questState.."ItemReceiveText");
	if ( totalRewards == 0 and money == 0 and honor == 0 and not playerTitle ) then
		getglobal(questState.."RewardTitleText"):Hide();
	else
		getglobal(questState.."RewardTitleText"):Show();
		QuestFrame_SetTitleTextColor(getglobal(questState.."RewardTitleText"), material);
		QuestFrame_SetAsLastShown(getglobal(questState.."RewardTitleText"), spacerFrame);
	end
	if ( money == 0 ) then
		moneyFrame:Hide();
	else
		moneyFrame:Show();
		QuestFrame_SetAsLastShown(moneyFrame, spacerFrame);
		MoneyFrame_Update(questState.."MoneyFrame", money);
	end

	if (honor == 0) then
		honorFrame:Hide();
	else
		honorFrame:Show();
		QuestHonorFrame_Update(questState.."HonorFrame", honor);
		honorFrame:ClearAllPoints();
		if (money == 0) then
			honorFrame:SetPoint("LEFT", questItemReceiveText, "RIGHT", 15, 0);
		else
			honorFrame:SetPoint("LEFT", moneyFrame, "RIGHT", -5, 0);
		end
		QuestFrame_SetAsLastShown(honorFrame, spacerFrame);
	end

	if ( not playerTitle ) then
		playerTitleFrame:Hide();
	else
		local anchorFrame;
		if ( honor ~= 0 ) then
			anchorFrame = honorFrame;
		elseif ( money ~= 0 ) then
			anchorFrame = moneyFrame;
		else
			anchorFrame = getglobal(questState.."RewardTitleText");
		end
		playerTitleFrame:SetPoint("TOP", anchorFrame, "BOTTOM", 0, -5);
		playerTitleFrame:SetPoint("LEFT", questState.."ItemReceiveText", "LEFT", -3, -5);
		getglobal(questState.."PlayerTitleFrameTitle"):SetText(playerTitle);
		playerTitleFrame:Show();
		QuestFrame_SetAsLastShown(playerTitleFrame, spacerFrame);
	end
	
	-- Hide unused rewards
	for i=totalRewards + 1, MAX_NUM_ITEMS, 1 do
		getglobal(questItemName..i):Hide();
	end

	local questItem, name, texture, isTradeskillSpell, isSpellLearned, quality, isUsable, numItems = 1;
	local rewardsCount = 0;

	-- Setup choosable rewards
	if ( numQuestChoices > 0 ) then
		local itemChooseText = getglobal(questState.."ItemChooseText");
		itemChooseText:Show();
		QuestFrame_SetTextColor(itemChooseText, material);
		QuestFrame_SetAsLastShown(itemChooseText, spacerFrame);

		local index;
		local baseIndex = rewardsCount;
		for i=1, numQuestChoices, 1 do
			index = i + baseIndex;
			questItem = getglobal(questItemName..index);
			questItem.type = "choice";
			name, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, texture = GetItemInfo(questAbandon.Choice[i].Link)
			if (texture == nil) then
				GameTooltip:SetHyperlink(questAbandon.Choice[i].Link);
				GameTooltip:Show();
				GameTooltip:Hide();
				questItem.timerEnabled = true;
			end
			numItems = questAbandon.Choice[i].Count;

			questItem:SetID(i)
			questItem:Show();
			-- For the tooltip
			questItem.rewardType = "item"
			QuestFrame_SetAsLastShown(questItem, spacerFrame);
			getglobal(questItemName..index.."Name"):SetText(name);
			SetItemButtonCount(questItem, numItems);
			SetItemButtonTexture(questItem, texture);
			questItem.link = questAbandon.Choice[i].Link;
--			if ( IsEquippableItem(itemLink) or IsConsumableItem(itemLink) ) then
				SetItemButtonTextureVertexColor(questItem, 1.0, 1.0, 1.0);
				SetItemButtonNameFrameVertexColor(questItem, 1.0, 1.0, 1.0);
--			else
--				SetItemButtonTextureVertexColor(questItem, 0.9, 0, 0);
--				SetItemButtonNameFrameVertexColor(questItem, 0.9, 0, 0);
--			end
			if ( i > 1 ) then
				if ( mod(i,2) == 1 ) then
					questItem:SetPoint("TOPLEFT", questItemName..(index - 2), "BOTTOMLEFT", 0, -2);
				else
					questItem:SetPoint("TOPLEFT", questItemName..(index - 1), "TOPRIGHT", 1, 0);
				end
			else
				questItem:SetPoint("TOPLEFT", itemChooseText, "BOTTOMLEFT", -3, -5);
			end
			rewardsCount = rewardsCount + 1;
		end
	else
		getglobal(questState.."ItemChooseText"):Hide();
	end

	-- Setup spell rewards
	if ( numQuestSpellRewards > 0 ) then
		local learnSpellText = getglobal(questState.."SpellLearnText");
		learnSpellText:Show();
		QuestFrame_SetTextColor(learnSpellText, material);
		QuestFrame_SetAsLastShown(learnSpellText, spacerFrame);

		--Anchor learnSpellText if there were choosable rewards
		if ( rewardsCount > 0 ) then
			learnSpellText:SetPoint("TOPLEFT", questItemName..rewardsCount, "BOTTOMLEFT", 3, -5);
		else
			learnSpellText:SetPoint("TOPLEFT", questState.."RewardTitleText", "BOTTOMLEFT", 0, -5);
		end

		texture = questAbandon.SpellReward.Texture;
		name = questAbandon.SpellReward.Name;

		learnSpellText:SetText(name);

		rewardsCount = rewardsCount + 1;
		questItem = getglobal(questItemName..rewardsCount);
		questItem:Show();
		-- For the tooltip
		questItem.link = "";
		questItem.rewardType = "spell";
		SetItemButtonCount(questItem, 0);
		SetItemButtonTexture(questItem, texture);
		getglobal(questItemName..rewardsCount.."Name"):SetText(name);
		questItem:SetPoint("TOPLEFT", learnSpellText, "BOTTOMLEFT", -3, -5);
	else
		getglobal(questState.."SpellLearnText"):Hide();
	end

	-- Setup mandatory rewards
	if ( numQuestRewards > 0 or money > 0) then
		QuestFrame_SetTextColor(questItemReceiveText, material);
		-- Anchor the reward text differently if there are choosable rewards
		if ( numQuestSpellRewards > 0  ) then
			questItemReceiveText:SetText(REWARD_ITEMS);
			questItemReceiveText:SetPoint("TOPLEFT", questItemName..rewardsCount, "BOTTOMLEFT", 3, -5);
		elseif ( numQuestChoices > 0  ) then
			questItemReceiveText:SetText(REWARD_ITEMS);
			local index = numQuestChoices;
			if ( mod(index, 2) == 0 ) then
				index = index - 1;
			end
			questItemReceiveText:SetPoint("TOPLEFT", questItemName..index, "BOTTOMLEFT", 3, -5);
		else
			questItemReceiveText:SetText(REWARD_ITEMS_ONLY);
			questItemReceiveText:SetPoint("TOPLEFT", questState.."RewardTitleText", "BOTTOMLEFT", 3, -5);
		end
		questItemReceiveText:Show();
		QuestFrame_SetAsLastShown(questItemReceiveText, spacerFrame);
		-- Setup mandatory rewards
		local index;
		local baseIndex = rewardsCount;
		for i=1, numQuestRewards, 1 do
			index = i + baseIndex;
			questItem = getglobal(questItemName..index);

			questItem.type = "reward";
			name, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, texture = GetItemInfo(questAbandon.Reward[i].Link);
			numItems = questAbandon.Reward[i].Count;

			questItem:SetID(i)
			questItem:Show();
			-- For the tooltip
			questItem.link = questAbandon.Reward[i].Link;
			questItem.rewardType = "item";
			QuestFrame_SetAsLastShown(questItem, spacerFrame);
			getglobal(questItemName..index.."Name"):SetText(name);
			SetItemButtonCount(questItem, numItems);
			SetItemButtonTexture(questItem, texture);
--			if ( IsEquippableItem(itemLink) or IsConsumableItem(itemLink) ) then
				SetItemButtonTextureVertexColor(questItem, 1.0, 1.0, 1.0);
				SetItemButtonNameFrameVertexColor(questItem, 1.0, 1.0, 1.0);
--			else
--				SetItemButtonTextureVertexColor(questItem, 0.5, 0, 0);
--				SetItemButtonNameFrameVertexColor(questItem, 1.0, 0, 0);
--			end

			if ( i > 1 ) then
				if ( mod(i,2) == 1 ) then
					questItem:SetPoint("TOPLEFT", questItemName..(index - 2), "BOTTOMLEFT", 0, -2);
				else
					questItem:SetPoint("TOPLEFT", questItemName..(index - 1), "TOPRIGHT", 1, 0);
				end
			else
				questItem:SetPoint("TOPLEFT", questState.."ItemReceiveText", "BOTTOMLEFT", -3, -5);
			end
			rewardsCount = rewardsCount + 1;
		end
	else
		questItemReceiveText:Hide();
	end
end

function QuestGuru_DeleteAbandon(questID)
	local i, qH;

	for i, qH in ipairs(QuestGuru_Abandon) do
	    if (qH.qID == questID) then
	        tremove(QuestGuru_Abandon, i);
	        i = i - 1;
		end
	end
	QuestGuru_UpdateAbandon();
end

function QuestGuru_CheckAbandon()
	local i, qH, prevH;

    for i, qH in ipairs(QuestGuru_Abandon) do
        if (qH.Level == nil) then
            tremove(QuestGuru_Abandon, i);
		end
		if (qH.StartNPCName == nil) then
			qH.StartNPCName = "Unknown";
		end
		if (qH.StartNPCZone == nil) then
		    qH.StartNPCZone = "Unknown";
		end
		if (qH.StartPosX == nil) then
		    qH.StartPosX = 0;
		end
		if (qH.StartPosY == nil) then
			qH.StartPosY = 0;
		end
		if (qH.StartLevel == nil) then
		    qH.StartLevel = 0;
		end
        if (qH.Honor == nil) then
            qH.Honor = 0;
		end
   		if (qH.qID == nil) then
   			local qID = QuestGuru_GetQuestID(qH.Title, qH.ObjectiveText, qH.Description);
   			qH.qID = qID;
   		end
	end
end

function QuestGuru_UpdateAbandonDB()
	if (QuestGuru_Quests[QuestGuru_RealmName] == nil) then return; end
	local i, qH, qID;

   	for i, qH in ipairs(QuestGuru_Abandon) do
   		if (qH.qID == nil) then
   			qID = QuestGuru_GetQuestID(qH.Title, qH.ObjectiveText, qH.Description);
   			qH.qID = qID;
   		else
   			qID = qH.qID;
   		end
   		if (qID == nil) then return; end
		if (QuestGuru_Quests[QuestGuru_RealmName][qID] == nil) then
			QuestGuru_Quests[QuestGuru_RealmName][qID] = {};
			QuestGuru_Quests[QuestGuru_RealmName][qID].level = qH.Level;
		end
		QuestGuru_Quests[QuestGuru_RealmName][qID][QuestGuru_Player] = "Abandoned";
		if (QuestGuru_Quests[QuestGuru_RealmName][qID].level ~= qH.Level) then
--			QuestGuru_Echo("Possible QuestID conflict with \""..qH.Title.."\". Please report on QuestGuru page on WoWUI.");
		end
	end
end