local L = AceLibrary("AceLocale-2.2"):new("PvPCount")
local Frames={}
local cfg = {}
PvPCount.Frames = Frames;


--------------------------------------------------------------------------------------------------------
--                                       PvPCount Window Creation - Enemy Viewer                      --
--------------------------------------------------------------------------------------------------------

Frames.a = CreateFrame("Frame","PvPCountAnchor",UIParent);
Frames.a:SetWidth(200);
Frames.a:SetHeight(100);
Frames.a:SetBackdrop({ bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", tile = true, tileSize = 8, edgeSize = 12, insets = { left = 2, right = 2, top = 2, bottom = 2 } });
Frames.a:SetBackdropColor(0.1,0.1,0.2,1);
Frames.a:SetBackdropBorderColor(0.1,0.1,0.1,1);
Frames.a:SetMovable(1);
Frames.a:EnableMouse(1);
Frames.a:SetToplevel(1);
Frames.a:SetClampedToScreen(1);
Frames.a:SetPoint("CENTER");
Frames.a:Hide();

Frames.a.text = Frames.a:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.a.text:SetText("PvPCount - Enemy Viewer");
Frames.a.text:SetPoint("TOPLEFT",6,0);

Frames.a.close = CreateFrame("Button",nil,Frames.a,"UIPanelCloseButton");
Frames.a.close:SetWidth(24);
Frames.a.close:SetHeight(24);
Frames.a.close:SetPoint("TOPRIGHT");


Frames.b = CreateFrame("Frame","PvPCountLine1",Frames.a);
Frames.b:SetWidth(200);
Frames.b:SetHeight(25);
Frames.b:SetPoint("TOP",0,-20);
Frames.b.text = Frames.b:CreateFontString(nil,"ARTWORK","GameFontNormal");
Frames.b.text:SetText("Nothing selected");
Frames.b.text:SetPoint("TOPLEFT",6,0);
Frames.b:Show();


Frames.c = CreateFrame("Frame","PvPCountLine2",Frames.a);
Frames.c:SetWidth(200);
Frames.c:SetHeight(25);
Frames.c:SetPoint("TOP",0,-40);
Frames.c.text = Frames.c:CreateFontString(nil,"ARTWORK","GameFontNormal");
Frames.c.text:SetText("");
Frames.c.text:SetPoint("TOPLEFT",6,0);
Frames.c:Show();

Frames.d = CreateFrame("Frame","PvPCountLine3",Frames.a);
Frames.d:SetWidth(200);
Frames.d:SetHeight(25);
Frames.d:SetPoint("TOP",0,-60);
Frames.d.text = Frames.d:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.d.text:SetText("");
Frames.d.text:SetPoint("TOPLEFT",6,0);
Frames.d:Show();


Frames.e = CreateFrame("Frame","PvPCountLine4",Frames.a);
Frames.e:SetWidth(200);
Frames.e:SetHeight(25);
Frames.e:SetPoint("TOP",0,-80);
Frames.e.text = Frames.e:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.e.text:SetText("");
Frames.e.text:SetPoint("TOPLEFT",6,0);
Frames.e:Show();

-- Anchor OnMouseUp
local function OnMouseUp()
	Frames.a:StopMovingOrSizing();
	cfg.left = Frames.a:GetLeft();
	cfg.top = Frames.a:GetTop();
end

Frames.a:SetScript("OnMouseDown",function() Frames.a:StartMoving() end);
Frames.a:SetScript("OnMouseUp",OnMouseUp);
--a:SetScript("OnEvent",OnEvent);

-- show anchor (can be set with settings later)
Frames.a:Show();



--------------------------------------------------------------------------------------------------------
--                                       PvPCount Window Creation - Small Viewer                      --
--------------------------------------------------------------------------------------------------------

Frames.sv = CreateFrame("Frame","PvPCountSmall",UIParent);
Frames.sv:SetWidth(50);
Frames.sv:SetHeight(40);

Frames.sv:SetBackdrop({ bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", tile = true, tileSize = 8, edgeSize = 12, insets = { left = 2, right = 2, top = 2, bottom = 2 } });
Frames.sv:SetBackdropColor(0.1,0.1,0.2,1);
Frames.sv:SetBackdropBorderColor(0.1,0.1,0.1,1);

Frames.sv:SetMovable(1);
Frames.sv:EnableMouse(1);
Frames.sv:SetToplevel(1);
Frames.sv:SetClampedToScreen(1);
Frames.sv:SetPoint("CENTER");
Frames.sv:Hide();

Frames.sv.text = Frames.sv:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sv.text:SetText("K:");
Frames.sv.text:SetFont("Interface\\AddOns\\oUF_P3lim\\font.ttf", 10)
Frames.sv.text:SetPoint("TOPLEFT",6,-5);

Frames.sv.text2 = Frames.sv:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sv.text2:SetText("D:");
Frames.sv.text2:SetPoint("TOPLEFT",6,-20);
Frames.sv.text2:SetTextColor(255,0,0);

Frames.sv.kills = Frames.sv:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sv.kills:SetText("0");
Frames.sv.kills:SetFont("Interface\\AddOns\\oUF_P3lim\\font.ttf", 10)
Frames.sv.kills:SetPoint("TOPLEFT",26,-5);

Frames.sv.deaths = Frames.sv:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sv.deaths:SetText("0");
Frames.sv.deaths:SetPoint("TOPLEFT",26,-20);
Frames.sv.deaths:SetTextColor(255,0,0);


-- SmallViewer OnMouseUp
local function SmallViewer_OnMouseUp()
	Frames.sv:StopMovingOrSizing();
	cfg.left_sv = Frames.sv:GetLeft();
	cfg.top_sv = Frames.sv:GetTop();
end

Frames.sv:SetScript("OnMouseDown",function() Frames.sv:StartMoving() end);
Frames.sv:SetScript("OnMouseUp",SmallViewer_OnMouseUp);

-- Don't show this frame by default (it's being activated when clicking a unit)
Frames.sv:Hide();


--------------------------------------------------------------------------------------------------------
--                                       PvPCount Window Creation - Stats Frame                       --
--------------------------------------------------------------------------------------------------------

Frames.sf = CreateFrame("Frame","PvPCountStats",UIParent);
Frames.sf:SetFrameStrata("BACKGROUND");
Frames.sf:SetWidth(500);
Frames.sf:SetHeight(500);
Frames.sf:SetPoint("CENTER", UIParent, "CENTER");

local bg = Frames.sf:CreateTexture(nil,"BACKGROUND");
bg:SetTexture("Interface\\Addons\\PvPCount\\PvPCountFrame");
bg:SetAllPoints(Frames.sf);
Frames.sf.texture = bg;


Frames.sf:SetMovable(1);
Frames.sf:EnableMouse(1);
Frames.sf:SetToplevel(1);
Frames.sf:SetClampedToScreen(1);
Frames.sf:Show();

-- TITLE
Frames.sf.title = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.title:SetText("PvPCount - Stats");
Frames.sf.title:SetPoint("TOPLEFT",140,-75);

-- BUTTON
Frames.sf.close = CreateFrame("Button",nil,Frames.sf,"UIPanelCloseButton");
Frames.sf.close:SetWidth(32);
Frames.sf.close:SetHeight(38);
Frames.sf.close:SetPoint("TOPRIGHT",-19,-61);

-- PLAYED BGs
Frames.sf.t1 = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.t1:SetText("Played Battlegrounds:");
Frames.sf.t1:SetPoint("TOPLEFT",100,-150);
Frames.sf.v1 = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.v1:SetText("0");
Frames.sf.v1:SetPoint("TOPLEFT",250,-150);

-- WON
Frames.sf.t2 = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.t2:SetText("Won:");
Frames.sf.t2:SetPoint("TOPLEFT",280,-150);
Frames.sf.v2 = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.v2:SetText("0");
Frames.sf.v2:SetPoint("TOPLEFT",320,-150);

-- LOST
Frames.sf.t3 = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.t3:SetText("Lost:");
Frames.sf.t3:SetPoint("TOPLEFT",350,-150);
Frames.sf.v3 = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.v3:SetText("0");
Frames.sf.v3:SetPoint("TOPLEFT",390,-150);


-- DAMAGE
Frames.sf.t4 = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.t4:SetText("Total Damage Done:");
Frames.sf.t4:SetPoint("TOPLEFT",100,-170);
Frames.sf.v4 = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.v4:SetText("0");
Frames.sf.v4:SetPoint("TOPLEFT",250,-170);

Frames.sf.t5 = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.t5:SetText("Total Damage Received:");
Frames.sf.t5:SetPoint("TOPLEFT",100,-190);
Frames.sf.v5 = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.v5:SetText("0");
Frames.sf.v5:SetPoint("TOPLEFT",250,-190);

-- KILLS
Frames.sf.t6 = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.t6:SetText("Total Kills:");
Frames.sf.t6:SetPoint("TOPLEFT",100,-210);
Frames.sf.v6 = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.v6:SetText("0");
Frames.sf.v6:SetPoint("TOPLEFT",250,-210);

Frames.sf.t7 = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.t7:SetText("Total Deaths:");
Frames.sf.t7:SetPoint("TOPLEFT",100,-230);
Frames.sf.v7 = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.v7:SetText("0");
Frames.sf.v7:SetPoint("TOPLEFT",250,-230);

-- BG Header
Frames.sf.bg0h = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg0h:SetText("Battleground Statistics:");
Frames.sf.bg0h:SetPoint("TOPLEFT",100,-295);
Frames.sf.bg0h1 = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg0h1:SetText("Won");
Frames.sf.bg0h1:SetPoint("TOPLEFT",250,-295);
Frames.sf.bg0h2 = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg0h2:SetText("Lost");
Frames.sf.bg0h2:SetPoint("TOPLEFT",350,-295);


-- BG Details
-- BG 1
Frames.sf.bg1h = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg1h:SetText("Not Played:");
Frames.sf.bg1h:SetPoint("TOPLEFT",100,-315);
Frames.sf.bg1vw = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg1vw:SetText("0");
Frames.sf.bg1vw:SetTextColor(0,255,0);
Frames.sf.bg1vw:SetPoint("TOPLEFT",255,-315);
Frames.sf.bg1vl = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg1vl:SetText("0");
Frames.sf.bg1vl:SetTextColor(1,0.1,0.1);
Frames.sf.bg1vl:SetPoint("TOPLEFT",355,-315);
Frames.sf.bg1vwt = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg1vwt:SetText("N/A");
Frames.sf.bg1vwt:SetPoint("TOPLEFT",285,-315);
Frames.sf.bg1vlt = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg1vlt:SetText("N/A");
Frames.sf.bg1vlt:SetPoint("TOPLEFT",385,-315);


-- BG 2
Frames.sf.bg2h = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg2h:SetText("Not Played:");
Frames.sf.bg2h:SetPoint("TOPLEFT",100,-335);
Frames.sf.bg2vw = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg2vw:SetText("0");
Frames.sf.bg2vw:SetTextColor(0,255,0);
Frames.sf.bg2vw:SetPoint("TOPLEFT",255,-335);
Frames.sf.bg2vl = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg2vl:SetText("0");
Frames.sf.bg2vl:SetTextColor(1,0.1,0.1);
Frames.sf.bg2vl:SetPoint("TOPLEFT",355,-335);
Frames.sf.bg2vwt = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg2vwt:SetText("N/A");
Frames.sf.bg2vwt:SetPoint("TOPLEFT",285,-335);
Frames.sf.bg2vlt = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg2vlt:SetText("N/A");
Frames.sf.bg2vlt:SetPoint("TOPLEFT",385,-335);

-- BG 3
Frames.sf.bg3h = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg3h:SetText("Not Played:");
Frames.sf.bg3h:SetPoint("TOPLEFT",100,-355);
Frames.sf.bg3vw = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg3vw:SetText("0");
Frames.sf.bg3vw:SetTextColor(0,255,0);
Frames.sf.bg3vw:SetPoint("TOPLEFT",255,-355);
Frames.sf.bg3vl = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg3vl:SetText("0");
Frames.sf.bg3vl:SetTextColor(1,0.1,0.1);
Frames.sf.bg3vl:SetPoint("TOPLEFT",355,-355);
Frames.sf.bg3vwt = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg3vwt:SetText("N/A");
Frames.sf.bg3vwt:SetPoint("TOPLEFT",285,-355);
Frames.sf.bg3vlt = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg3vlt:SetText("N/A");
Frames.sf.bg3vlt:SetPoint("TOPLEFT",385,-355);

-- BG 4
Frames.sf.bg4h = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg4h:SetText("Not Played:");
Frames.sf.bg4h:SetPoint("TOPLEFT",100,-375);
Frames.sf.bg4vw = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg4vw:SetText("0");
Frames.sf.bg4vw:SetTextColor(0,255,0);
Frames.sf.bg4vw:SetPoint("TOPLEFT",255,-375);
Frames.sf.bg4vl = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg4vl:SetText("0");
Frames.sf.bg4vl:SetTextColor(1,0.1,0.1);
Frames.sf.bg4vl:SetPoint("TOPLEFT",355,-375);
Frames.sf.bg4vwt = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg4vwt:SetText("N/A");
Frames.sf.bg4vwt:SetPoint("TOPLEFT",285,-375);
Frames.sf.bg4vlt = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.bg4vlt:SetText("N/A");
Frames.sf.bg4vlt:SetPoint("TOPLEFT",385,-375);

-- BUTTONS
Frames.sf.resetAll = CreateFrame("Button",nil,Frames.sf,"UIPanelButtonTemplate");
Frames.sf.resetAll:SetWidth(80);
Frames.sf.resetAll:SetHeight(22);
Frames.sf.resetAll:SetPoint("BOTTOMRIGHT",-340,50);
Frames.sf.resetAll:SetText(L["RESET_NAME"]);
Frames.sf.resetAll:SetScript("OnClick", function() 
	Frames.q:Show();
end);

Frames.sf.cleanUp = CreateFrame("Button",nil,Frames.sf,"UIPanelButtonTemplate");
Frames.sf.cleanUp:SetWidth(80);
Frames.sf.cleanUp:SetHeight(22);
Frames.sf.cleanUp:SetPoint("BOTTOMRIGHT",-340,70);
Frames.sf.cleanUp:SetText(L["CLEANUP_NAME"]);
Frames.sf.cleanUp:SetScript("OnClick", function() 
	PvPCount:CleanUp(); 
end);

Frames.sf.AnnounceT = Frames.sf:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.sf.AnnounceT:SetText(L["ANNOUNCE_BG_STATS_NAME"]);
Frames.sf.AnnounceT:SetPoint("BOTTOMRIGHT",-190,75);
Frames.sf.Announce = CreateFrame("CheckButton",nil,Frames.sf,"OptionsCheckButtonTemplate");
Frames.sf.Announce:SetWidth(22);
Frames.sf.Announce:SetHeight(22);
Frames.sf.Announce:SetPoint("BOTTOMRIGHT",-310,70);
Frames.sf.Announce:SetScript("OnShow", function(self) self:SetChecked(PvPCount.db.char.settings.AnnounceBGStats) end);
Frames.sf.Announce:SetScript("OnClick", function() 
	if PvPCount.db.char.settings.AnnounceBGStats then
		PvPCount.db.char.settings.AnnounceBGStats = false;
		PvPCount:Print("Announce switched off.");
	else
		PvPCount.db.char.settings.AnnounceBGStats = true;
		PvPCount:Print("Announce switched on.");
	end
end);






-- SmallViewer OnMouseUp
local function StatsFrame_OnMouseUp()
	Frames.sf:StopMovingOrSizing();
	cfg.left_sf = Frames.sf:GetLeft();
	cfg.top_sf = Frames.sf:GetTop();
end

Frames.sf:SetScript("OnMouseDown",function() Frames.sf:StartMoving() end);
Frames.sf:SetScript("OnMouseUp",StatsFrame_OnMouseUp);

Frames.sf:Hide();


--- FRAME DIALOG RESET QUESTION ---
Frames.q = CreateFrame("Frame","PvPCountQuestion",UIParent);
Frames.q:SetWidth(300);
Frames.q:SetHeight(50);
Frames.q:SetBackdrop({ bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", tile = true, tileSize = 8, edgeSize = 12, insets = { left = 2, right = 2, top = 2, bottom = 2 } });
Frames.q:SetBackdropColor(1,1,1,1);
--Frames.q:SetBackdropBorderColor(0.1,0.1,0.1,1);
Frames.q:SetMovable(0);
Frames.q:EnableMouse(0);
Frames.q:SetToplevel(1);
Frames.q:SetClampedToScreen(1);
Frames.q:SetPoint("CENTER");
Frames.q:Hide();

-- TITLE
Frames.q.q1 = Frames.q:CreateFontString(nil,"ARTWORK","GameFontHighlight");
Frames.q.q1:SetText(L["DELETE_ALL_DATA"]);
Frames.q.q1:SetPoint("TOPLEFT",10,-5);

-- OK BUTTON
Frames.q.qb1 = CreateFrame("Button",nil,Frames.q,"UIPanelButtonTemplate");
Frames.q.qb1:SetWidth(80);
Frames.q.qb1:SetHeight(22);
Frames.q.qb1:SetPoint("BOTTOMRIGHT",-140,10);
Frames.q.qb1:SetText(L["OK"]);
Frames.q.qb1:SetScript("OnClick", function() 
	PvPCount:Reset(); 
end);

-- CANCEL BUTTON
Frames.q.qb1 = CreateFrame("Button",nil,Frames.q,"UIPanelButtonTemplate");
Frames.q.qb1:SetWidth(80);
Frames.q.qb1:SetHeight(22);
Frames.q.qb1:SetPoint("BOTTOMRIGHT",-20,10);
Frames.q.qb1:SetText(L["CANCEL"]);
Frames.q.qb1:SetScript("OnClick", function() 
	Frames.q:Hide();
end);





--- FRAME FUNCTIONS ---

function Frames:Show()
	Frames.a:Show();
end

function Frames:ShowSmall()
	Frames.sv:Show();
end

function Frames:HideSmall()
	Frames.sv:Hide();
end

function Frames:ShowStats()
	Frames.sf:Show();
end