local L = AceLibrary("AceLocale-2.2"):new("PvPCount")

local options = {
	type='group',
	args= {

		stats = {
			type = 'execute',
			name = L["SHOW_STAT_FRAME_NAME"],
			desc = L["SHOW_STAT_FRAME_DESC"],
			func = 'ShowStatsSum'
		},

		consolestats = {
			type = 'execute',
			name = L["SHOW_STAT_CHAT_NAME"],
			desc = L["SHOW_STAT_CHAT_DESC"],
			func = 'ShowStats'
		},

		show = {
			type = 'execute',
			name = L["SHOW_FRAME_NAME"],
			desc = L["SHOW_FRAME_DESC"],
			func = 'ShowStatsFrame'
		},

		showsmall = {
			type = 'toggle',
			name = L["SHOW_SMALL_FRAME_NAME"],
			desc = L["SHOW_SMALL_FRAME_DESC"],
			get = "IsShowSmall",
			set = "ToggleShowSmall"
		},

		reset = {
			type = 'execute',
			name = L["RESET_NAME"],
			desc = L["RESET_DESC"],
			func = 'Reset'
		},

		cleanup = {
			type = 'execute',
			name = L["CLEANUP_NAME"],
			desc = L["CLEANUP_DESC"],
			func = 'CleanUp'
		},

		showInChat = {
			type = 'toggle',
			name = L["SHOW_INCHAT_NAME"],
			desc = L["SHOW_INCHAT_DESC"],
			get = "IsShowInChat",
			set = "ToggleShowInChat"
		},
		
		announce = {
			type = 'toggle',
			name = L["ANNOUNCE_BG_STATS_NAME"],
			desc = L["ANNOUNCE_BG_STATS_DESC"],
			get = "IsAnnounceBGStats",
			set = "ToggleAnnounceBGStats"
		}

	}
}

local bit_band  = bit.band
local UnitClass = UnitClass
local UnitHealth = UnitHealth
local UnitLevel = UnitLevel
local GetRealmName = GetRealmName
local BGHasEnded = false
local BGRunTime = 0
local KillsBG = 0
local DeathsBG = 0
local chatmessage = ""
local chatmessage2 = ""

local FlagsToUnitID =
{
 [COMBATLOG_OBJECT_TARGET]				= "target",
 [COMBATLOG_OBJECT_FOCUS]				= "focus",
 [COMBATLOG_OBJECT_MAINTANK]			= "maintank",
 [COMBATLOG_OBJECT_MAINASSIST]			= "mainassist",
 [COMBATLOG_OBJECT_RAIDTARGET1]			= "raid1target",
 [COMBATLOG_OBJECT_RAIDTARGET2]			= "raid2target",
 [COMBATLOG_OBJECT_RAIDTARGET3]			= "raid3target",
 [COMBATLOG_OBJECT_RAIDTARGET4]			= "raid4target",
 [COMBATLOG_OBJECT_RAIDTARGET5]			= "raid5target",
 [COMBATLOG_OBJECT_RAIDTARGET6]			= "raid6target",
 [COMBATLOG_OBJECT_RAIDTARGET7]			= "raid7target",
 [COMBATLOG_OBJECT_RAIDTARGET8]			= "raid8target",
}

PvPCount = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0")
PvPCount:RegisterChatCommand("/pc", "/pvpcount", options)

PvPCount:RegisterDB("PvPCountDB", "PvPCountDBPC")

PvPCount:RegisterDefaults('char', {
		sum={
			Init=false,
			TotalKills=0,
			PartyKills=0,
			UnitsDestroyed=0,
			Money=0

		},
		fights={
			['*'] = {
				Name="",
				DamageDone=0,
				DamageRcvd=0,
				Kills=0,
				Deaths=0,
				Class="",
				Level="",
				Server="",
				Mana="",
				Health=""

			}
		},
		settings={
			ShowInChat=true,
			ShowSmall=true,
			AnnounceBGStats=false,
		},
		bgs={
			['*'] = {
				Wins=0,
				Loses=0,
				WinTime=0,
				LoseTime=0
			}
		}

})



function PvPCount:ShowStatsSum()

    local playedBGs = 0
    local playedBG_Won = 0
    local playedBG_Lost = 0
    for k,v in pairs(PvPCount.db.char.bgs) do
            playedBGs = playedBGs + PvPCount.db.char.bgs[k].Wins + PvPCount.db.char.bgs[k].Loses
            playedBG_Won = playedBG_Won + PvPCount.db.char.bgs[k].Wins
            playedBG_Lost = playedBG_Lost + PvPCount.db.char.bgs[k].Loses

    end

    local totalDmg_Done = 0
    local totalDmg_Rcvd = 0
    local totalKills = 0
    local totalDeaths = 0
    for k,v in pairs(PvPCount.db.char.fights) do
        totalDmg_Done = totalDmg_Done + PvPCount.db.char.fights[k].DamageDone
        totalDmg_Rcvd = totalDmg_Rcvd + PvPCount.db.char.fights[k].DamageRcvd
        totalKills = totalKills + PvPCount.db.char.fights[k].Kills
        totalDeaths = totalDeaths + PvPCount.db.char.fights[k].Deaths
    end



    PvPCount.Frames.sf.v1:SetText(playedBGs);
    PvPCount.Frames.sf.v2:SetText(playedBG_Won);
    PvPCount.Frames.sf.v3:SetText(playedBG_Lost);

    PvPCount.Frames.sf.v4:SetText(totalDmg_Done);
    PvPCount.Frames.sf.v5:SetText(totalDmg_Rcvd);

    PvPCount.Frames.sf.v6:SetText(totalKills);
    PvPCount.Frames.sf.v7:SetText(totalDeaths);

    local i = 1
    for k,v in pairs(PvPCount.db.char.bgs) do
		if i == 1 then
			PvPCount.Frames.sf.bg1h:SetText(k);
			PvPCount.Frames.sf.bg1vw:SetText(PvPCount.db.char.bgs[k].Wins);
			PvPCount.Frames.sf.bg1vl:SetText(PvPCount.db.char.bgs[k].Loses);
			
			-- calc win/lose time 
			local wintime = PvPCount.db.char.bgs[k].WinTime / PvPCount.db.char.bgs[k].Wins
			local losetime = PvPCount.db.char.bgs[k].LoseTime / PvPCount.db.char.bgs[k].Loses
	
			if wintime > 0 then
				PvPCount.Frames.sf.bg1vwt:SetText(SecondsToTime(wintime/1000, true));
			end
			
			if losetime > 0 then
				PvPCount.Frames.sf.bg1vlt:SetText(SecondsToTime(losetime/1000, true));
			end

			
		elseif i == 2 then
			PvPCount.Frames.sf.bg2h:SetText(k);
			PvPCount.Frames.sf.bg2vw:SetText(PvPCount.db.char.bgs[k].Wins);
			PvPCount.Frames.sf.bg2vl:SetText(PvPCount.db.char.bgs[k].Loses);
			
			-- calc win/lose time 
			local wintime = PvPCount.db.char.bgs[k].WinTime / PvPCount.db.char.bgs[k].Wins
			local losetime = PvPCount.db.char.bgs[k].LoseTime / PvPCount.db.char.bgs[k].Loses
	
			if wintime > 0 then
				PvPCount.Frames.sf.bg2vwt:SetText(SecondsToTime(wintime/1000, true));
			end
			
			if losetime > 0 then
				PvPCount.Frames.sf.bg2vlt:SetText(SecondsToTime(losetime/1000, true));
			end
			
		elseif i == 3 then
			PvPCount.Frames.sf.bg3h:SetText(k);
			PvPCount.Frames.sf.bg3vw:SetText(PvPCount.db.char.bgs[k].Wins);
			PvPCount.Frames.sf.bg3vl:SetText(PvPCount.db.char.bgs[k].Loses);
			
			-- calc win/lose time 
			local wintime = PvPCount.db.char.bgs[k].WinTime / PvPCount.db.char.bgs[k].Wins
			local losetime = PvPCount.db.char.bgs[k].LoseTime / PvPCount.db.char.bgs[k].Loses
	
			if wintime > 0 then
				PvPCount.Frames.sf.bg3vwt:SetText(SecondsToTime(wintime/1000, true));
			end
			
			if losetime > 0 then
				PvPCount.Frames.sf.bg3vlt:SetText(SecondsToTime(losetime/1000, true));
			end
			
		elseif i == 4 then
			PvPCount.Frames.sf.bg4h:SetText(k);
			PvPCount.Frames.sf.bg4vw:SetText(PvPCount.db.char.bgs[k].Wins);
			PvPCount.Frames.sf.bg4vl:SetText(PvPCount.db.char.bgs[k].Loses);
			
			-- calc win/lose time 
			local wintime = PvPCount.db.char.bgs[k].WinTime / PvPCount.db.char.bgs[k].Wins
			local losetime = PvPCount.db.char.bgs[k].LoseTime / PvPCount.db.char.bgs[k].Loses
	
			if wintime > 0 then
				PvPCount.Frames.sf.bg4vwt:SetText(SecondsToTime(wintime/1000, true));
			end
			
			if losetime > 0 then
				PvPCount.Frames.sf.bg4vlt:SetText(SecondsToTime(losetime/1000, true));
			end
			
		end

    	i = i + 1
    end



    PvPCount.Frames.ShowStats();

end

function PvPCount:ShowSmall()
	PvPCount.Frames.ShowSmall();
end

function PvPCount:IsShowInChat()
	return self.db.char.settings.ShowInChat;
end

function PvPCount:ToggleShowInChat()
	self.db.char.settings.ShowInChat = not self.db.char.settings.ShowInChat;
end

function PvPCount:IsShowSmall()
	return self.db.char.settings.ShowSmall;
end

function PvPCount:ToggleShowSmall()
	self.db.char.settings.ShowSmall = not self.db.char.settings.ShowSmall;
end

function PvPCount:IsAnnounceBGStats()
	return self.db.char.settings.AnnounceBGStats;
end

function PvPCount:ToggleAnnounceBGStats()
	self.db.char.settings.AnnounceBGStats = not self.db.char.settings.AnnounceBGStats;
end

function PvPCount:OnInitialize()
	-- Called when the addon is loaded

	PvPCount.PlayerName = UnitName("player");
	PvPCount.CurrentMoney = GetMoney();
	PvPCount.LastAttacker = "nil";
	PvPCount.PlayerRealm = GetRealmName("player");
	PvPCount.PlayerFaction, localizedFaction = UnitFactionGroup("player");
	PvPCount.KillsBG = 0;

	-- Register Events
	PvPCount:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED","CombatLogEvent");
	PvPCount:RegisterEvent("PLAYER_MONEY","PlayerMoney");
	PvPCount:RegisterEvent("UPDATE_MOUSEOVER_UNIT","MouseOverUnit")
	PvPCount:RegisterEvent("CHAT_MSG_BG_SYSTEM_NEUTRAL","BattleGround");
	PvPCount:RegisterEvent("ZONE_CHANGED","ZoneChanged");
	PvPCount:RegisterEvent("UPDATE_BATTLEFIELD_SCORE","UPDATE_BATTLEFIELD_SCORE");
	PvPCount:RegisterEvent("PLAYER_TARGET_CHANGED","PLAYER_TARGET_CHANGED");

end

function PvPCount:ZoneChanged()

	PvPCount.CurrentZone = GetRealZoneText();

	if PvPCount.CurrentZone == L["BG_ARATHI"] or PvPCount.CurrentZone == L["BG_WARSONG"] or PvPCount.CurrentZone == L["BG_ALTERAC"] or PvPCount.CurrentZone == L["BG_EYE"] then

		--if self.db.char.settings.ShowInChat then
		--	self:Print("Found Battleground: " .. PvPCount.CurrentZone);
		--end

		PvPCount.BGHasEnded = false

		PvPCount.CurrentBG = PvPCount.CurrentZone
	else
		PvPCount.CurrentBG = nil
	end

end

function PvPCount:UPDATE_BATTLEFIELD_SCORE()
	PvPCount:BattleGround();
end

function PvPCount:BattleGround()

  	local winner = GetBattlefieldWinner()

	-- only updated RunTime if we have a value (EYE and WARSONG don't update GetBattlefieldInstanceRunTime() every time)
	if GetBattlefieldInstanceRunTime() > 0 then
		PvPCount.BGRunTime = GetBattlefieldInstanceRunTime();
	end
	
	

  	if (winner == 0 or winner == 1) and PvPCount.BGHasEnded == false then

		
		-- say some stats (end of BG, only if Kills >= 5)
		local totalBGs = self.db.char.bgs[PvPCount.CurrentBG].Loses + self.db.char.bgs[PvPCount.CurrentBG].Wins;
		local totalBGRunTime = self.db.char.bgs[PvPCount.CurrentBG].WinTime + self.db.char.bgs[PvPCount.CurrentBG].LoseTime
		
		local wintime = PvPCount.db.char.bgs[PvPCount.CurrentBG].WinTime / PvPCount.db.char.bgs[PvPCount.CurrentBG].Wins
		local losetime = PvPCount.db.char.bgs[PvPCount.CurrentBG].LoseTime / PvPCount.db.char.bgs[PvPCount.CurrentBG].Loses
		
		PvPCount.chatmessage = "PvPCount: " .. totalBGs .. " " .. PvPCount.CurrentBG .. " " .. L["played"] .. " in " .. SecondsToTime(totalBGRunTime/1000);
		
			
		PvPCount.BGHasEnded = true;
		PvPCount.KillsBG = 0;
		PvPCount.DeathsBG = 0;
		
		-- we need to set the chatmessage2 value before the if comes ...
		PvPCount.chatmessage2="nil";
		
		-- 0=Horde, 1=Alliance
	    if winner == 0 then
            if PvPCount.PlayerFaction == "Alliance" then
                self.db.char.bgs[PvPCount.CurrentBG].Loses = self.db.char.bgs[PvPCount.CurrentBG].Loses + 1
                self.db.char.bgs[PvPCount.CurrentBG].LoseTime = self.db.char.bgs[PvPCount.CurrentBG].LoseTime + PvPCount.BGRunTime
                if losetime > 0 then 
                	PvPCount.chatmessage2 = ", " .. L["lose"] .. " " .. L["average"] .. " " .. SecondsToTime(losetime/1000,true);
                end
            else
                self.db.char.bgs[PvPCount.CurrentBG].Wins = self.db.char.bgs[PvPCount.CurrentBG].Wins + 1
                self.db.char.bgs[PvPCount.CurrentBG].WinTime = self.db.char.bgs[PvPCount.CurrentBG].WinTime + PvPCount.BGRunTime
                if wintime > 0 then
                	PvPCount.chatmessage2 = ", " .. L["win"] .. " " .. L["average"] .. " " .. SecondsToTime(wintime/1000,true);
                end
            end
        elseif winner == 1 then
            if PvPCount.PlayerFaction == "Alliance" then
                self.db.char.bgs[PvPCount.CurrentBG].Wins = self.db.char.bgs[PvPCount.CurrentBG].Wins + 1
                self.db.char.bgs[PvPCount.CurrentBG].WinTime = self.db.char.bgs[PvPCount.CurrentBG].WinTime + PvPCount.BGRunTime
                if wintime > 0 then
                	PvPCount.chatmessage2 = ", " .. L["win"] .. " " .. L["average"] .. " " .. SecondsToTime(wintime/1000,true);
                end
            else
                self.db.char.bgs[PvPCount.CurrentBG].Loses = self.db.char.bgs[PvPCount.CurrentBG].Loses + 1
                self.db.char.bgs[PvPCount.CurrentBG].LoseTime = self.db.char.bgs[PvPCount.CurrentBG].LoseTime + PvPCount.BGRunTime
                if losetime > 0 then 
                	PvPCount.chatmessage2 = ", " .. L["lose"] .. " " .. L["average"] .. " " .. SecondsToTime(losetime/1000,true);
                end
            end
        end
        
        -- announce stats ?
        if self.db.char.settings.AnnounceBGStats == true then
        	SendChatMessage(PvPCount.chatmessage .. PvPCount.chatmessage2,"BATTLEGROUND");
        else
        	self:Print(PvPCount.chatmessage .. PvPCount.chatmessage2);
        end

	end

end

-- CleanUP - deletes all Recordsets without data (no dmg done, no kills)
function PvPCount:CleanUp()

   	local i = 0

   	 for key,value in pairs(self.db.char.fights) do

		if self.db.char.fights[key].DamageDone == 0 and self.db.char.fights[key].Kills == 0 and self.db.char.fights[key].Deaths == 0 then

			self.db.char.fights[key] = nil;
			i = i + 1;

		end

     end

	self:Print(i .. " Recordsets cleaned up.");

end

function PvPCount:CheckUnitIDChanges(unitid,mouse)

    local name, server = UnitName(unitid)
    local health, mana = UnitHealth(unitid), 0
    local locclass, class = UnitClass(unitid)
    local level = UnitLevel(unitid)
    server = server or GetRealmName()

 	if server == PvPCount.PlayerRealm then
 		name = name
 	else
		name = name .. "-" .. server;
	end

	if name == nil then
		return
	end

    -- update tables
    self.db.char.fights[name].Class = class
    self.db.char.fights[name].Server = server
    self.db.char.fights[name].Level = level

	if health > 100 then
	    self.db.char.fights[name].Health = health
    	self.db.char.fights[name].Mana = mana
    end

	-- show on tooltip
	PvPCount.Frames.b.text:SetTextColor(RAID_CLASS_COLORS[class]["r"],RAID_CLASS_COLORS[class]["g"],RAID_CLASS_COLORS[class]["b"]);


	PvPCount.Frames.b.text:SetText(name .. " (" .. level .. ")");
	PvPCount.Frames.c.text:SetText(locclass);
	PvPCount.Frames.d.text:SetText(L["DMG"] .. ": " .. self.db.char.fights[name].DamageDone .. " / " .. self.db.char.fights[name].DamageRcvd);
	PvPCount.Frames.e.text:SetText(L["KILLS"] .. ": " .. self.db.char.fights[name].Kills .. " / " .. self.db.char.fights[name].Deaths);

	-- Small Frame (only if target, not mouseover)
	if mouse ~= "mouse" then
		PvPCount.Frames.sv.kills:SetText(self.db.char.fights[name].Kills);
		PvPCount.Frames.sv.deaths:SetText(self.db.char.fights[name].Deaths);
	end

end

function PvPCount:PLAYER_TARGET_CHANGED()

	local mytarget = UnitName("target");

	if mytarget ~= nil then
	    PvPCount:CheckUnitIDChanges("target");
		PvPCount.Frames.ShowSmall();
	else
		PvPCount.Frames.HideSmall();
	end


end

function PvPCount:MouseOverUnit(event)
	PvPCount:CheckUnitIDChanges("mouseover","mouse");
end

function PvPCount:ShowTop10()

	table.sort(self.db.char.fights);

	for key,value in pairs(self.db.char.fights) do
		self:Print(key..":" .. self.db.char.fights[key].Kills);
	end

end

function PvPCount:ShowStats()
	-- Called when entered /PvPCount stats

	self:Print("Stats (" .. PvPCount.PlayerFaction .. ")");
	self:Print("Total Kills: " .. self.db.char.sum.TotalKills);
	self:Print("Party Kills: " .. self.db.char.sum.PartyKills);
	self:Print("Units Destroyed: " .. self.db.char.sum.UnitsDestroyed);
	self:Print("Money looted: " .. FormatMoney(self.db.char.sum.Money));

	local i = 0

	-- count
	for key,value in pairs(self.db.char.fights) do
		i = i + 1
	end

	self:Print("Records in Database: " .. i);

	-- show bg stats
	for key,value in pairs(self.db.char.bgs) do
		self:Print(key..": WINS: " .. self.db.char.bgs[key].Wins .. " / LOSES: " .. self.db.char.bgs[key].Loses);
		self:Print(key..": WINTIME: " .. SecondsToTime(self.db.char.bgs[key].WinTime/1000) .. " / LOSETIME: " .. SecondsToTime(self.db.char.bgs[key].LoseTime/1000));
	end

	
end


function PvPCount:ShowStatsFrame()
	PvPCount.Frames.Show();
end

function PvPCount:Reset()
	-- Resets all tables

	for k,v in pairs(PvPCount.db.char.fights) do
		PvPCount.db.char.fights[k] = nil
	end

	for k,v in pairs(self.db.char.bgs) do
		PvPCount.db.char.bgs[k] = nil
	end

	PvPCount.db.char.sum.TotalKills=0;
	PvPCount.db.char.sum.PartyKills=0;
	PvPCount.db.char.sum.UnitsDestroyed=0;
	PvPCount.db.char.sum.Money=0;

	PvPCount:Print("Stored data deleted.");

end


function PvPCount:OnDisable()
	-- Called when the addon is disabled
end

function FormatMoney(money)
    local ret = ""
    local gold = floor(money / (COPPER_PER_SILVER * SILVER_PER_GOLD));
    local silver = floor((money - (gold * COPPER_PER_SILVER * SILVER_PER_GOLD)) / COPPER_PER_SILVER);
    local copper = mod(money, COPPER_PER_SILVER);
    if gold > 0 then
        ret = gold .. " gold "
    end
    if silver > 0 or gold > 0 then
        ret = ret .. silver .. " silver "
    end
    ret = ret .. copper .. " copper"
    return ret
end


function PvPCount:PlayerMoney()

	local tmpMoney = GetMoney()

    if self.CurrentMoney then
        self.DiffMoney = tmpMoney - self.CurrentMoney
    else
        self.DiffMoney = 0
    end

    self.CurrentMoney = tmpMoney

    if self.DiffMoney > 0 then
        self.db.char.sum.Money = self.db.char.sum.Money + self.DiffMoney;
    elseif self.DiffMoney < 0 then
        self.db.char.sum.Money = self.db.char.sum.Money - self.DiffMoney;
    end

end

-- Function FindUnitFromFlags taken from Recount Addon
function PvPCount:FindUnitFromFlags(unitname,unitFlags)

	if bit_band(unitFlags,COMBATLOG_OBJECT_TYPE_PLAYER)~=0 and bit_band(unitFlags,COMBATLOG_OBJECT_AFFILIATION_PARTY+COMBATLOG_OBJECT_AFFILIATION_RAID+COMBATLOG_OBJECT_AFFILIATION_MINE)~=0 then
		return unitname
	end

	-- This returns all target-inferable units from flags.
	for k,v in pairs(FlagsToUnitID) do
		if bit_band(k,unitFlags)~=0 then
			local vname, vrealm = UnitName(v)
			if vname and vname == unitname then
				return v
			end
		end
	end

	return nil
end


function PvPCount:SwingDamage(timestamp, eventtype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags,amount, school, resisted, blocked, absorbed, critical, glancing, crushing)
	PvPCount:SpellDamage(timestamp, eventtype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags,0, 0, 0, amount, school, resisted, blocked, absorbed, critical, glancing, crushing)
end

function PvPCount:SpellDamage(timestamp, eventtype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags,spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing)

	if srcName == PvPCount.PlayerName then
		self.db.char.fights[dstName].DamageDone = self.db.char.fights[dstName].DamageDone + amount;

	   	local unit = PvPCount:FindUnitFromFlags(dstName,dstFlags);

	   if unit then
	   	self.db.char.fights[dstName].Level = UnitLevel(unit);
	   end


	elseif dstName == PvPCount.PlayerName then
		self.db.char.fights[srcName].DamageRcvd = self.db.char.fights[srcName].DamageRcvd + amount;
		-- remember attacker (very likley he has killed us when we die)
		PvPCount.LastAttacker = srcName;
	end

end

function PvPCount:CombatLogEvent(timestamp, eventtype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, ...)

	if eventtype == "SWING_DAMAGE"  then

			PvPCount:SwingDamage(timestamp, eventtype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags,...);


	elseif eventtype == "RANGE_DAMAGE" or eventtype == "SPELL_DAMAGE" or eventtype == "SPELL_PERIODIC_DAMAGE" or eventtype == "DAMAGE_SHIELD" or eventtype == "DAMAGE_SPLIT"  then

		PvPCount:SpellDamage(timestamp, eventtype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags,...);

    elseif eventtype == "UNIT_DIED" or eventtype == "UNIT_DESTROYED" then

		if srcName == PvPCount.PlayerName then
	        self.db.char.sum.UnitsDestroyed = self.db.char.sum.UnitsDestroyed + 1;
	    elseif dstName == PvPCount.PlayerName then
	    	self.db.char.fights[PvPCount.LastAttacker].Deaths = self.db.char.fights[PvPCount.LastAttacker].Deaths + 1;
	    	if self.db.char.settings.ShowInChat == true then
	    		self:Print(PvPCount.LastAttacker .. " killed " .. dstName .. " " .. self.db.char.fights[PvPCount.LastAttacker].Deaths .. " times.");
	    	end
	    end


    elseif eventtype == "PARTY_KILL" and srcName == PvPCount.PlayerName then

		-- count overall kills
        self.db.char.sum.PartyKills = self.db.char.sum.PartyKills + 1;
        PvPCount.KillsBG = PvPCount.KillsBG + 1;
        


		-- count unit kills by unit name
		self.db.char.fights[dstName].Kills = self.db.char.fights[dstName].Kills + 1;

		-- display stats
		if self.db.char.settings.ShowInChat == true then
			self:Print(srcName .. " killed " .. dstName .. " " .. self.db.char.fights[dstName].Kills .. " times.");
		end

    end

end