local L = AceLibrary("AceLocale-2.2"):new("ProfessionsBook")

local channels = {"SAY", "PARTY", "GUILD", "OFFICER", "RAID", "WHISPER"}

-- Simple dialog box
StaticPopupDialogs["ProfessionBook_Receiver"] = {
	text = L["Receiver"],
	button1 = L["Send"],
	button2 = CANCEL,
	OnAccept = function()
		local receiver
		
		receiver = getglobal(this:GetParent():GetName().."EditBox"):GetText()
		ProfessionsBook:SendMessage(receiver)	
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
	hasEditBox = 1
}

StaticPopupDialogs["ProfessionBook_DeleteDatabase"] = {
	text = L["All scanned data will be lost."],
	button1 = YES,
	button2 = CANCEL,
	OnAccept = function()
			ProfessionsBook:ClearDatabase()
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1
}

function ProfessionsBook_CharacterDropDownMenu_Initialize()
        local i = 0
		local k, v
		local info = UIDropDownMenu_CreateInfo() 
		local charNames = {}
		
		charNames = ProfessionsBook:GetCharList()
		for k,v in pairs(charNames) do 
			info.text = v
			info.value = i
			info.func = ProfessionsBook_CharacterDropDownMenu_OnClick
			info.owner = ProfessionsBook_CharacterDropDownMenu
			info.checked = nil
			info.icon = nil
			UIDropDownMenu_AddButton(info, 1)
			i = i + 1
		end
		ProfessionsBook_TradeItemListScrollFrame:Hide()
		ProfessionsBook_TradeItemExpandButtonFrame:Hide()
end

function ProfessionsBook_CharacterDropDownMenu_OnClick()
	local i, button

	UIDropDownMenu_SetSelectedValue(this.owner, this.value)
	ProfessionsBook:SetSelectedChar(UIDropDownMenu_GetText(ProfessionsBook_CharacterDropDownMenu))
	ProfessionsBook:UpdateTradeSkillSelection()
	
	for i = 1, PROFESSIONSBOOK_TRADEITEM_BUTTON_COUNT do
		button = getglobal("ProfessionsBook_TradeItemButton" .. i)
		button:Hide()
	end
	ProfessionsBook_TradeItemHighlightFrame:Hide()
	for i = 1, PROFESSIONSBOOK_TRADESKILL_BUTTON_COUNT do
		button = getglobal("ProfessionsBook_TradeSkillButton" .. i)
		button:UnlockHighlight()
	end
	ProfessionsBook_DetailScrollFrame:Hide()
	ProfessionsBook_SendButton:Disable()
	ProfessionsBook_SkillLevel:Hide()
end 

function ProfessionsBook_ChannelsDropDownMenu_Initialize()
    local i = 0
	local k, v
	local info = UIDropDownMenu_CreateInfo() 

	for k,v in pairs(channels) do 
		info.text = L[v]
		info.value = i
		info.func = ProfessionsBook_ChannelsDropDownMenu_OnClick
		info.owner = ProfessionsBook_ChannelsDropDownMenu
		info.checked = nil
		info.icon = nil
		UIDropDownMenu_AddButton(info, 1)
		i = i + 1
	end
end

function ProfessionsBook_ChannelsDropDownMenu_OnClick()
	UIDropDownMenu_SetSelectedValue(this.owner, this.value)
	ProfessionsBook_SelectedChannel = this.value
end 

function ProfessionsBook_TradeTypeDropDownMenu_Initialize()
    local i = 1
	local k, v
	local info = UIDropDownMenu_CreateInfo() 

	info.text = L["All subclasses"]
	info.value = 0
	info.func = ProfessionsBook_TradeTypeDropDownMenu_OnClick
	info.owner = this:GetParent()
	info.checked = nil
	info.icon = nil
	UIDropDownMenu_AddButton(info, 1)		
	for k,v in pairs(ProfessionsBook_Headers) do 	
		info.text = ProfessionsBook:GetHeaderName(UIDropDownMenu_GetText(ProfessionsBook_CharacterDropDownMenu), ProfessionsBook_SelectedTradeSkill, k)
		if info.text ~= "" then
			info.value = i
			info.func = ProfessionsBook_TradeTypeDropDownMenu_OnClick
			info.owner = this:GetParent()
			info.checked = nil
			info.icon = nil
			UIDropDownMenu_AddButton(info, 1)
			i = i + 1
		end
	end
end

function ProfessionsBook_TradeTypeDropDownMenu_OnClick()
	UIDropDownMenu_SetSelectedValue(this.owner, this.value)
	ProfessionsBook_TradeItemList = ProfessionsBook:GetTradeItemList(ProfessionsBook:GetSelectedChar(), ProfessionsBook_SelectedTradeSkill, ProfessionsBook_Headers, UIDropDownMenu_GetText(ProfessionsBook_TradeTypeDropDownMenu), UIDropDownMenu_GetText(ProfessionsBook_PlacesDropDownMenu))
	ProfessionsBook:UpdateTradeItemButtons()
end 

function ProfessionsBook_PlacesDropDownMenu_Initialize()
	local i = 1
	local k, v
	local info = UIDropDownMenu_CreateInfo() 
	local placeList = {}

	placeList = ProfessionsBook:GetTradeItemPlaceList()
	info.text = L["All places"]
	info.value = 0
	info.func = ProfessionsBook_PlacesDropDownMenu_OnClick
	info.owner = this:GetParent()
	info.checked = nil
	info.icon = nil
	UIDropDownMenu_AddButton(info, 1)	
	for k,v in pairs(placeList) do
		info.text = v
		info.value = i
		info.func = ProfessionsBook_PlacesDropDownMenu_OnClick
		info.owner = this:GetParent()
		info.checked = nil
		info.icon = nil
		UIDropDownMenu_AddButton(info, 1)	
		i = i + 1
	end
end

function ProfessionsBook_PlacesDropDownMenu_OnClick()
	local placeList = {}
	
	UIDropDownMenu_SetSelectedValue(this.owner, this.value)
	placeList = ProfessionsBook:GetTradeItemPlaceList()
	ProfessionsBook_TradeItemList = ProfessionsBook:GetTradeItemList(ProfessionsBook:GetSelectedChar(), ProfessionsBook_SelectedTradeSkill, ProfessionsBook_Headers, UIDropDownMenu_GetText(ProfessionsBook_TradeTypeDropDownMenu), placeList[this.value])
	ProfessionsBook_TradeTypeDropDownMenu_OnClick()
end 

function ProfessionsBook_TradeItemButton_OnClick(id)
	-- Header item
	if id < 0 then
		if ProfessionsBook_Headers[tostring(-1 * id)] == true then
			ProfessionsBook_Headers[tostring(-1 * id)] = false
		else
			ProfessionsBook_Headers[tostring(-1 * id)] = true
		end
		ProfessionsBook_TradeItemList = ProfessionsBook:GetTradeItemList(ProfessionsBook:GetSelectedChar(), ProfessionsBook_SelectedTradeSkill, ProfessionsBook_Headers, UIDropDownMenu_GetText(ProfessionsBook_TradeTypeDropDownMenu), UIDropDownMenu_GetText(ProfessionsBook_PlacesDropDownMenu))
	-- Trade Item
	else
		ProfessionsBook_selectedTradeItem = ProfessionsBook:GetRecipeName(id)
		ProfessionsBook:UpdateRecipeDetails(id)
	end
	ProfessionsBook:UpdateTradeItemButtons()
end



function ProfessionsBook:HideSearchFrame()
	local button, i

	ProfessionsBook_SearchTop:Hide()
	ProfessionsBook_SearchTopRight:Hide()
	ProfessionsBook_SearchBottom:Hide()
	ProfessionsBook_SearchBottomRight:Hide()
	ProfessionsBook_SearchResultScrollFrame:Hide()
	ProfessionsBook_OpenSearchButton:SetNormalTexture("Interface\\Buttons\\UI-SpellbookIcon-NextPage-Up")
	ProfessionsBook_SearchBox:Hide()
	ProfessionsBook_SearchButton:Hide()
	ProfessionsBook_SearchResultHighlightFrame:Hide()
	for i=1,PROFESSIONSBOOK_SEARCHITEM_BUTTON_COUNT do
		button = getglobal("ProfessionsBook_SearchResultButton" .. i)
		button:Hide()
	end	
	ProfessionsBook_SearchFrameVisible = false
		ProfessionsBook_SearchRecipes_CheckButton:Hide()
	ProfessionsBook_SearchReagents_CheckButton:Hide()
end

function ProfessionsBook:ShowSearchFrame()
	ProfessionsBook_SearchTop:Show()
	ProfessionsBook_SearchTopRight:Show()
	ProfessionsBook_SearchBottom:Show()
	ProfessionsBook_SearchBottomRight:Show()
	ProfessionsBook_SearchResultScrollFrame:Show()
	ProfessionsBook_OpenSearchButton:SetNormalTexture("Interface\\Buttons\\UI-SpellbookIcon-PrevPage-Up")
	ProfessionsBook_SearchBox:Show()
	ProfessionsBook_SearchButton:Show()
	ProfessionsBook_SearchFrameVisible = true
	ProfessionsBook_SearchRecipes_CheckButton:Show()
	ProfessionsBook_SearchReagents_CheckButton:Show()
end

function ProfessionsBook_UpdateTradeItemFrame()
	FauxScrollFrame_Update(ProfessionsBook_TradeItemListScrollFrame, getn(ProfessionsBook_TradeItemList), PROFESSIONSBOOK_TRADEITEM_BUTTON_COUNT, PROFESSIONSBOOK_TRADEITEM_HEIGHT)
	ProfessionsBook:UpdateTradeItemButtons()
end
	
function ProfessionsBook:UpdateTradeItemButtons()
	local button, buttonCount
	local i, a, b, c, tradeItemType, tradeItemName, color

	-- Clear alle trade item buttons
	for i = 1, PROFESSIONSBOOK_TRADEITEM_BUTTON_COUNT do
		button = getglobal("ProfessionsBook_TradeItemButton" .. i)
		button:SetText("")
		button:Hide()		
	end
	ProfessionsBook_TradeItemHighlightFrame:Hide()
	buttonCount = 1
	for i = FauxScrollFrame_GetOffset(ProfessionsBook_TradeItemListScrollFrame) + 1, FauxScrollFrame_GetOffset(ProfessionsBook_TradeItemListScrollFrame) + PROFESSIONSBOOK_TRADEITEM_BUTTON_COUNT do
		if i > getn(ProfessionsBook_TradeItemList) then
			break
		end

		button = getglobal("ProfessionsBook_TradeItemButton" .. buttonCount)
		a, b, c = self:ParseTradeItem(ProfessionsBook_TradeItemList[i])
		if b == 0 then
			if ProfessionsBook_Headers[tostring(a)] == true then
				button:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-Up")
			else
				button:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-Up")
			end	
			tradeItemType = "header"
			tradeItemName = self:GetHeaderName(UIDropDownMenu_GetText(ProfessionsBook_CharacterDropDownMenu), ProfessionsBook_SelectedTradeSkill, a)
			if tradeItemName == "" then
				tradeItemName = L["All subclasses"]
			end
		else
			button:SetNormalTexture("")
			button:SetHighlightTexture("")	
			-- Place the highlight and lock the highlight state
			if ( ProfessionsBook_selectedTradeItem == self:GetRecipeName(b) ) then
				ProfessionsBook_TradeItemHighlightFrame:SetPoint("TOPLEFT", button, "TOPLEFT", 0, 0);
				ProfessionsBook_TradeItemHighlightFrame:Show()
				button:LockHighlight()
			else
				button:UnlockHighlight()
			end		
			tradeItemType = self:GetTradeItemType(UIDropDownMenu_GetText(ProfessionsBook_CharacterDropDownMenu), ProfessionsBook_SelectedTradeSkill, a, c)
			tradeItemName = self:GetRecipeName(b)
		end
		button:SetText(tradeItemName)
		button:Show()
		if b == 0 then
			button:SetID(0 - a)
		else
			button:SetID(b)
		end
		color = ProfessionsBook_TradeItemTypeColor[tradeItemType]
		if ( color ) then
			button:SetTextColor(color.r, color.g, color.b)
			if ( ProfessionsBook_selectedTradeItem == self:GetRecipeName(b) ) then
				ProfessionsBook_TradeItemHighlight:SetVertexColor(color.r, color.g, color.b)
			end
		end
		if ( ProfessionsBook_TradeItemListScrollFrame:IsShown() ) then
			button:SetWidth(283)
		else
			button:SetWidth(323)
		end	
		buttonCount = buttonCount + 1	
	end
	if getn(ProfessionsBook_TradeItemList) > PROFESSIONSBOOK_TRADEITEM_BUTTON_COUNT then
		ProfessionsBook_TradeItemListScrollFrame:Show()
	else
		ProfessionsBook_TradeItemListScrollFrame:Hide()
	end
end

function ProfessionsBook_TradeItemButton_OnShiftClick(id)

	if ProfessionsBook.selectedTradeSkill == L["Enchanting"] then
		ChatEdit_InsertLink(ProfessionsBook:GetRecipeLink(id))
	else
		ChatEdit_InsertLink(ProfessionsBook:GetRecipeRecipeLink(id))
	end
end

function ProfessionsBook_TradeSkillButton_OnClick(id, offset)
	local button, i, playerName
	
	ProfessionsBook_TradeItemList = {}
	playerName = UIDropDownMenu_GetText(ProfessionsBook_CharacterDropDownMenu)
	for i = 1, PROFESSIONSBOOK_TRADESKILL_BUTTON_COUNT do
		button= getglobal("ProfessionsBook_TradeSkillButton" .. i)
		button:UnlockHighlight()
	end
	button = getglobal("ProfessionsBook_TradeSkillButton" .. id)
	button:LockHighlight()
	ProfessionsBook_TradeItemExpandButtonFrame:Show()
	ProfessionsBook_SelectedTradeSkill = button:GetText()
	ProfessionsBook_selectedTradeItem = ""
	ProfessionsBook_Headers = ProfessionsBook:GetHeaderList(playerName, ProfessionsBook_SelectedTradeSkill)
	FauxScrollFrame_SetOffset(ProfessionsBook_TradeItemListScrollFrame, offset);
	UIDropDownMenu_Initialize(ProfessionsBook_TradeTypeDropDownMenu, ProfessionsBook_TradeTypeDropDownMenu_Initialize)
	UIDropDownMenu_SetSelectedValue(ProfessionsBook_TradeTypeDropDownMenu, 0)	
	UIDropDownMenu_Initialize(ProfessionsBook_PlacesDropDownMenu, ProfessionsBook_PlacesDropDownMenu_Initialize)
	UIDropDownMenu_SetSelectedValue(ProfessionsBook_PlacesDropDownMenu, 0)	
	ProfessionsBook_TradeItemList = ProfessionsBook:GetTradeItemList(playerName, ProfessionsBook_SelectedTradeSkill, ProfessionsBook_Headers, UIDropDownMenu_GetText(ProfessionsBook_TradeTypeDropDownMenu), UIDropDownMenu_GetText(ProfessionsBook_PlacesDropDownMenu))
	ProfessionsBook_DetailScrollFrame:Hide()
	ProfessionsBook_SendButton:Disable()
	ProfessionsBook_SkillLevel:SetText(SKILL_LEVEL .. ": " .. ProfessionsBook:GetTradeSkillLevel(playerName, ProfessionsBook_SelectedTradeSkill))
	ProfessionsBook_SkillLevel:Show()
	ProfessionsBook:UpdateTradeItemButtons()
end

function ProfessionsBook:UpdateRecipeDetails(id)
	local tradeItemTexture, tradeItemLink, tool, producedCount 
	local reagentList = {}
	local reagentCount, reagentName, reagentLink, reagentTexture

	ProfessionsBook_SendButton:Enable()
	LabelTradeItemName:SetText(ProfessionsBook_selectedTradeItem)
	ProfessionsBook_DetailScrollFrame:Show()
	tradeItemLink = self:GetRecipeLink(id)
	_, _, _, _, _, _, _, _, _, tradeItemTexture = GetItemInfo(tradeItemLink)
	if ProfessionsBook_SelectedTradeSkill == L["Enchanting"] then
		ProfessionsBook_TradeItemIcon:SetNormalTexture("Interface\\Icons\\INV_Scroll_04")
	else
		ProfessionsBook_TradeItemIcon:SetNormalTexture(tradeItemTexture)
	end
	
	tool = ProfessionsBook:GetRecipeTool(id)
	producedCount = ProfessionsBook:GetRecipeProducedItemCount(id)
	if producedCount <= 1 then
		ProfessionsBook_TradeItemIconCount:SetText("")
	else
		ProfessionsBook_TradeItemIconCount:SetText(tostring(producedCount))
	end
	if (tool == "") or (tool == nil) then
		LabelRequirement:Hide()
		LabelRequirementText:Hide()
	else
		LabelRequirement:Show()
		LabelRequirementText:Show()	
		LabelRequirementText:SetText(tool)
	end
	
	reagentList = self:GetReagentList(id)
	for i = 1, getn(reagentList) do
		reagentCount = self:GetReagentCount(id, reagentList[i])
		reagentName = self:GetReagentName(id, reagentList[i])
		reagentLink = self:GetReagentLink(id, reagentList[i])
		if reagentLink ~= nil then
			_, _, _, _, _, _, _, _, _, reagentTexture = GetItemInfo(reagentLink)
			button = getglobal("ProfessionsBook_TradeItemReagent" .. i)
			nameLabel = getglobal("ProfessionsBook_TradeItemReagent"..i.."Name")
			countLabel = getglobal("ProfessionsBook_TradeItemReagent"..i.."Count");
			SetItemButtonTexture(button, reagentTexture)
			nameLabel:SetText(reagentName)
			countLabel:SetText(reagentCount)
			button:Show()
		end
	end

	for i = getn(reagentList) + 1, 8 do
		button = getglobal("ProfessionsBook_TradeItemReagent" .. i)
		button:Hide()
	end
	ProfessionsBook_DetailScrollFrame:UpdateScrollChildRect()
end

function ProfessionsBook_SetTooltip()
	local tradeItemLink, id
	
	id = ProfessionsBook:GetTradeItemID(ProfessionsBook_selectedTradeItem)
	GameTooltip:SetOwner(this, "ANCHOR_TOPLEFT")
	tradeItemLink = ProfessionsBook:GetRecipeLink(id)
	GameTooltip:SetHyperlink(tradeItemLink)
	CursorUpdate()	
end

function ProfessionsBook_SetReagentTooltip(reagentID)
	local reagentsItemLink

	GameTooltip:SetOwner(this, "ANCHOR_TOPLEFT")
	id = ProfessionsBook:GetTradeItemID(ProfessionsBook_selectedTradeItem)
	reagentsItemLink = ProfessionsBook:GetReagentLink(id, reagentID)
	GameTooltip:SetHyperlink(reagentsItemLink)
end

function ProfessionsBook_TradeItemDetailButton_OnShiftClick()
	local tradeItemLink, id
	
	id = ProfessionsBook:GetTradeItemID(ProfessionsBook_selectedTradeItem)
	ChatEdit_InsertLink(ProfessionsBook:GetRecipeLink(id))
end

function ProfessionsBook_TradeItemDetailButton_OnCtrlClick()
	local tradeItemLink, id
	
	id = ProfessionsBook:GetTradeItemID(ProfessionsBook_selectedTradeItem)
	DressUpItemLink(ProfessionsBook:GetRecipeLink(id))
end

function ProfessionsBook_TradeItemReagentButton_OnShiftClick(reagentId)
	local id
	
	id = ProfessionsBook:GetTradeItemID(ProfessionsBook_selectedTradeItem)
	reagentsItemLink = ProfessionsBook:GetReagentLink(id, reagentId)
	ChatEdit_InsertLink(reagentsItemLink)
end

function ProfessionsBook_OpenSearchButton_OnClick()
	if ProfessionsBook_SearchFrameVisible == true then
		ProfessionsBook:HideSearchFrame()
	else
		ProfessionsBook:ShowSearchFrame()
	end
end

function ProfessionsBook_SearchButton_OnClick()
	local resultsCount
	
	resultsCount = ProfessionsBook:Search(ProfessionsBook_SearchBox:GetText())
	FauxScrollFrame_Update(ProfessionsBook_SearchResultScrollFrame, resultsCount, PROFESSIONSBOOK_SEARCHITEM_BUTTON_COUNT, PROFESSIONSBOOK_SEARCHITEM_HEIGHT)
	FauxScrollFrame_SetOffset(ProfessionsBook_SearchResultScrollFrame, 0)
	if (resultsCount <= PROFESSIONSBOOK_SEARCHITEM_BUTTON_COUNT) then
		ProfessionsBook_SearchResultScrollFrame:Hide()
	else
		ProfessionsBook_SearchResultScrollFrame:Show()
	end
	ProfessionsBook_selectedSearchItem = "none"
	ProfessionsBook:UpdateSearchFrame(resultsCount)
	ProfessionsBook_SearchBox:ClearFocus()
end

function ProfessionsBook:UpdateSearchFrame(resultsCount)
	local buttonCount, id, button, i
	
	buttonCount = 1
	for i = 1,PROFESSIONSBOOK_SEARCHITEM_BUTTON_COUNT do
		button = getglobal("ProfessionsBook_SearchResultButton" .. i)
		button:Hide()
	end
	ProfessionsBook_SearchResultHighlightFrame:Hide()
	for k,v in pairs(ProfessionsBook_SeachResult) do
		button = getglobal("ProfessionsBook_SearchResultButton" .. buttonCount)
		if (k > FauxScrollFrame_GetOffset(ProfessionsBook_SearchResultScrollFrame)) and (k <= FauxScrollFrame_GetOffset(ProfessionsBook_SearchResultScrollFrame) + PROFESSIONSBOOK_SEARCHITEM_BUTTON_COUNT) then		
			button:SetNormalTexture("")
			button:SetHighlightTexture("")	
			-- Place the highlight and lock the highlight state
			if (ProfessionsBook_selectedSearchItem == v.charName .. ": " .. v.tradeItemName) then
				ProfessionsBook_SearchResultHighlightFrame:SetPoint("TOPLEFT", "ProfessionsBook_SearchResultButton"..buttonCount, "TOPLEFT", 15, 0);
				ProfessionsBook_SearchResultHighlightFrame:Show()
				button:LockHighlight()
			else
				button:UnlockHighlight()						
			end
			button:SetText(v.charName .. ": " .. v.tradeItemName)
			button:Show()
			id = k
			button:SetID(id)
			color = ProfessionsBook_TradeItemTypeColor["medium"]
			button:SetTextColor(color.r, color.g, color.b)
			if (ProfessionsBook_SearchResultScrollFrame:IsShown()) then
				button:SetWidth(303);
			else
				button:SetWidth(323);
			end	
			buttonCount = buttonCount + 1			
		end
	end
	if resultsCount > PROFESSIONSBOOK_SEARCHITEM_BUTTON_COUNT then
		ProfessionsBook_SearchResultScrollFrame:Show()
	else
		ProfessionsBook_SearchResultScrollFrame:Hide()
	end
end

function ProfessionsBook_SearchResultButton_OnClick(id)
	local i, charName, tradeSkill, itemID, button, offset
	
	charName = ProfessionsBook_SeachResult[id].charName
	tradeSkill = ProfessionsBook_SeachResult[id].tradeSkill
	itemID = ProfessionsBook_SeachResult[id].id
	offset = tonumber(itemID)
	ProfessionsBook_selectedSearchItem = this:GetText()
	ProfessionsBook:UpdateSearchFrame(table.getn(ProfessionsBook_SeachResult))
	UIDropDownMenu_Initialize(ProfessionsBook_CharacterDropDownMenu, ProfessionsBook_CharacterDropDownMenu_Initialize)
	for i = 0, getn(ProfessionsBook:GetCharList()) do
		UIDropDownMenu_SetSelectedValue(ProfessionsBook_CharacterDropDownMenu, i)
		if UIDropDownMenu_GetText(ProfessionsBook_CharacterDropDownMenu) == charName then
			break
		end
	end
	for i = 1,PROFESSIONSBOOK_TRADESKILL_BUTTON_COUNT do 
		button = getglobal("ProfessionsBook_TradeSkillButton" .. i)
		if button:GetText() == tradeSkill then
			ProfessionsBook_TradeSkillButton_OnClick(i, 0)
		end
	end
	ProfessionsBook_selectedTradeItem = ProfessionsBook:GetRecipeName(id)
	ProfessionsBook_TradeItemButton_OnClick(offset)
end

function ProfessionsBook_SearchResultButton_OnShiftClick(id)
	ChatEdit_InsertLink(ProfessionsBook:GetRecipeRecipeLink(ProfessionsBook_SeachResult[id].id))
end

function ProfessionsBook_OptionsButton_OnClick()
	ProfessionsBook_OptionsDialog:Show()
end

function ProfessionsBook_SendButton_OnClick()
	-- Check if whipser
	if channels[ProfessionsBook_SelectedChannel + 1] == "WHISPER" then
		StaticPopup_Show ("ProfessionBook_Receiver")
	else
		ProfessionsBook:SendMessage(nil)
	end
end

function ProfessionsBook:SendMessage(receiver)	
	local id, tradeItemLink, k, v, reagentItemLink, reagentItemCount
	local reagentList = {}
	
	id = ProfessionsBook:GetRecipeID(ProfessionsBook_selectedTradeItem)
	tradeItemLink = ProfessionsBook:GetRecipeLink(id)
	SendChatMessage(L["Materials for"] .. " " .. tradeItemLink .. ":", channels[ProfessionsBook_SelectedChannel + 1], nil, receiver)
	reagentList = ProfessionsBook:GetReagentList(id)
	for k,v in pairs(reagentList) do
		reagentItemLink = ProfessionsBook:GetReagentLink(id, v)
		reagentItemCount = ProfessionsBook:GetReagentCount(id, v)
		if reagentItemCount > 0 then
			SendChatMessage("  " .. reagentItemLink .. " x " .. reagentItemCount, channels[ProfessionsBook_SelectedChannel + 1], nil, receiver)
		end
	end
end

function ProfessionsBook_TradeItemCollapseAllButton_OnClick()
	if (this.collapsed) then
		this.collapsed = nil
		ProfessionsBook_TradeItemCollapseAllButton:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-Up")
		ProfessionsBook:ExpandAllHeaders()
	else
		this.collapsed = 1
		ProfessionsBook_TradeItemCollapseAllButton:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-Up")
		ProfessionsBook:ColapseAllHeaders()
	end
	ProfessionsBook_TradeItemList = ProfessionsBook:GetTradeItemList(ProfessionsBook:GetSelectedChar(), ProfessionsBook_SelectedTradeSkill, ProfessionsBook_Headers, UIDropDownMenu_GetText(ProfessionsBook_TradeTypeDropDownMenu), UIDropDownMenu_GetText(ProfessionsBook_PlacesDropDownMenu))
	ProfessionsBook:UpdateTradeItemButtons()
end

function ProfessionsBook_SortDifficulty_CheckButton_OnClick()
	local playerName

	playerName = UIDropDownMenu_GetText(ProfessionsBook_CharacterDropDownMenu)
	ProfessionsBook_SortOrder = 0
	ProfessionsBook_SortAlphabetically_CheckButton:SetChecked(nil)
	ProfessionsBook_TradeItemList = ProfessionsBook:GetTradeItemList(playerName, ProfessionsBook_SelectedTradeSkill, ProfessionsBook_Headers, UIDropDownMenu_GetText(ProfessionsBook_TradeTypeDropDownMenu), UIDropDownMenu_GetText(ProfessionsBook_PlacesDropDownMenu))
	ProfessionsBook_UpdateTradeItemFrame()
end

function ProfessionsBook_SortAlphabetically_CheckButton_OnClick()
	local playerName

	playerName = UIDropDownMenu_GetText(ProfessionsBook_CharacterDropDownMenu)
	ProfessionsBook_SortOrder = 1
	ProfessionsBook_SortDifficulty_CheckButton:SetChecked(nil)
	ProfessionsBook_TradeItemList = ProfessionsBook:GetTradeItemList(playerName, ProfessionsBook_SelectedTradeSkill, ProfessionsBook_Headers, UIDropDownMenu_GetText(ProfessionsBook_TradeTypeDropDownMenu), UIDropDownMenu_GetText(ProfessionsBook_PlacesDropDownMenu))
	ProfessionsBook_UpdateTradeItemFrame()
end

function ProfessionsBook_SearchRecipes_CheckButton_OnClick()
	ProfessionsBook_SearchType = 0
	ProfessionsBook_SearchReagents_CheckButton:SetChecked(nil)
	ProfessionsBook_SeachResult = {}
	ProfessionsBook:UpdateSearchFrame(0)
end

function ProfessionsBook_SearchReagents_CheckButton_OnClick()
	ProfessionsBook_SearchType = 1
	ProfessionsBook_SearchRecipes_CheckButton:SetChecked(nil)
	ProfessionsBook_SeachResult = {}
	ProfessionsBook:UpdateSearchFrame(0)	
end

