local L = AceLibrary("AceLocale-2.2"):new("ProfessionsBook")

function ProfessionsBook:TRADE_SKILL_SHOW()
	ProfessionsBook_RescanCounter = 0
	ProfessionsBook:ScanTradeSkills("Other")
end

function ProfessionsBook:TRADE_SKILL_UPDATE()
	if ProfessionsBook_RescanCounter < PROFESSIONSBOOK_MAXRESCANS then
		ProfessionsBook_RescanCounter = ProfessionsBook_RescanCounter + 1
		ProfessionsBook:ScanTradeSkills("Other")
	end
end

function ProfessionsBook:CRAFT_SHOW()
	if GetCraftDisplaySkillLine() ~= nil then
		ProfessionsBook_RescanCounter = 0
		ProfessionsBook:ScanTradeSkills("Enchanting")
	end
end

function ProfessionsBook:CRAFT_UPDATE()
	if GetCraftDisplaySkillLine() ~= nil then
		if ProfessionsBook_RescanCounter < PROFESSIONSBOOK_MAXRESCANS then
			ProfessionsBook_RescanCounter = ProfessionsBook_RescanCounter + 1
			ProfessionsBook:ScanTradeSkills("Enchanting")
		end
	end
end

function ProfessionsBook:CheckReagents(recipeID, reagentCount, currentTradeSkill)
	local singleReagentCount, reagentName, reagentItemLink, i
	
	for j = 1, reagentCount do
		if currentTradeSkill == "Enchanting" then
			reagentName, _, singleReagentCount, _ = GetCraftReagentInfo(recipeID, j)
			reagentItemLink = GetCraftReagentItemLink(recipeID, j)
		else
			reagentName, _, singleReagentCount, _ = GetTradeSkillReagentInfo(recipeID, j)
			reagentItemLink = GetTradeSkillReagentItemLink(recipeID, j)
		end	
		if (self:StringValid(reagentName) == false) or (singleReagentCount == nil) or (self:StringValid(reagentItemLink) == false) then
			return false
		end
	end
	return true
end

function ProfessionsBook:StringValid(string)
	if string == nil then
		return false
	end
	if string == "" then
		return false
	end
	return true
end

function ProfessionsBook:ScanTradeSkills(currentTradeSkill)
	local tradeItemCount, tradeItemName, tradeItemType, tradeItemLink, tradeItemID, producedItemCount
	local tradeItemTool, reagentCount, tradeItemRecipeLink, headerID, recipeID
	local reagentName, singleReagentCount, reagentItemLink, currentTradeSkillLevel, tradeSkillName
	local reagentError
	local i, j
	local newTradeItemCount = 0
	local reagentList = {}

	self:DebugPrint("Scan started")
	playerName = UnitName("player")	
	if currentTradeSkill == "Enchanting" then
		tradeItemCount = GetNumCrafts()
		tradeSkillName, currentTradeSkillLevel, _ = GetCraftDisplaySkillLine()
	else
		tradeItemCount = GetNumTradeSkills()
		tradeSkillName, currentTradeSkillLevel, _ = GetTradeSkillLine()
	end
	self:SetTradeSkillLevel(playerName, tradeSkillName, currentTradeSkillLevel)
	for i = 1, tradeItemCount do
		if currentTradeSkill == "Enchanting" then
			tradeItemName, _, tradeItemType, _, _, _, _ = GetCraftInfo(i)
			producedItemCount = 1
			tradeItemLink = GetCraftItemLink(i)
			tradeItemTool = GetCraftSpellFocus(i)
			reagentCount = GetCraftNumReagents(i)
			tradeItemRecipeLink = tradeItemLink
		else
			tradeItemName, tradeItemType, _, _ = GetTradeSkillInfo(i)
			_, producedItemCount = GetTradeSkillNumMade(i)
			-- Scan recipe
			if tradeItemType ~= "header" then
				tradeItemLink = GetTradeSkillItemLink(i)
				tradeItemTool = GetTradeSkillTools(i)
				reagentCount = GetTradeSkillNumReagents(i)
				tradeItemRecipeLink = GetTradeSkillRecipeLink(i)
			end
		end	
		if (self:StringValid(tradeItemType) == true) and (self:StringValid(tradeItemName) == true) then
			if tradeItemType ~= "header" then
				if (self:StringValid(tradeItemLink) == true) and (reagentCount ~= nil) and (self:StringValid(tradeItemRecipeLink) == true) then
					recipeID = self:GetRecipeID(tradeItemName)				
					-- Add recipe to database if not presend allready
					if recipeID == -1 then				
						if (self:CheckReagents(i, reagentCount, currentTradeSkill)) then
							recipeID = self:AddRecipe(tradeItemName, tradeItemLink, tradeItemRecipeLink, tradeItemTool, producedItemCount)
							-- Add reagents
							for j = 1, reagentCount do
								if currentTradeSkill == "Enchanting" then
									reagentName, _, singleReagentCount, _ = GetCraftReagentInfo(i, j)
									reagentItemLink = GetCraftReagentItemLink(i, j)
								else
									reagentName, _, singleReagentCount, _ = GetTradeSkillReagentInfo(i, j)
									reagentItemLink = GetTradeSkillReagentItemLink(i, j)
								end	
								self:AddReagent(recipeID, j, reagentName, singleReagentCount, reagentItemLink)
							end
						end
					-- Check if any reagent is missing, add it if necessary
					else
						if (self:CheckReagents(i, reagentCount, currentTradeSkill)) then
							for j = 1, reagentCount do
								if self:GetReagentName(recipeID, j) == "" then
									if currentTradeSkill == "Enchanting" then
										reagentName, _, singleReagentCount, _ = GetCraftReagentInfo(i, j)
										reagentItemLink = GetCraftReagentItemLink(i, j)
									else
										reagentName, _, singleReagentCount, _ = GetTradeSkillReagentInfo(i, j)
										reagentItemLink = GetTradeSkillReagentItemLink(i, j)
									end	
									self:AddReagent(recipeID, j, reagentName, singleReagentCount, reagentItemLink)							
								end
							end
						end
					end	
				end
			end
			-- Find out, if the character knows the header allready
			if tradeItemType == "header" then
				headerID = self:GetHeaderID(playerName, tradeSkillName, tradeItemName)
				if headerID == -1 then
					self:AddHeader(playerName, tradeSkillName, tradeItemName)
				end
			else
				-- Add recipe if char does not know it
				tradeItemID = self:GetCharTradeItemID(playerName, tradeSkillName, headerID, recipeID)
				self:AddCharToRecipe(recipeID)	
				if currentTradeSkill == "Enchanting" then
					headerID = 1
				end
				if (tonumber(tradeItemID) ~= nil) and (tonumber(headerID) ~= nil) and (tonumber(recipeID) ~= nil) then
					if (tradeItemID == -1) and (headerID ~= -1) and (recipeID > 0) then				
						self:AddTradeItem(playerName, tradeSkillName, headerID, recipeID, tradeItemType)
						newTradeItemCount = newTradeItemCount + 1
					end
				end
				-- Update trade type (trivial, optimum, etc.)
				self:UpdateTradeItemType(playerName, tradeSkillName, headerID, recipeID, tradeItemType)
			end
		end
	end
	if newTradeItemCount > 0 then
		self:Print(newTradeItemCount .. " " .. L["new recipes found."])
		self:SetTradeItemCount(playerName, tradeSkillName, tradeItemCount)
	end
	self:ValidateDB()
	self:DebugPrint("Scan finished")
end


