local L = AceLibrary("AceLocale-2.2"):new("ProfessionsBook")

function ProfessionsBook:InitOptions()
	local playerName, x, y

	playerName= UnitName("player")
	if self:GetMinimap(playerName) == 1 then 
		ProfessionsBook_MinimapCheckButton:SetChecked(1)
		ProfessionsBook_MinimapButton:Show()
	else
		ProfessionsBook_MinimapCheckButton:SetChecked(nil)
		ProfessionsBook_MinimapButton:Hide()
	end
	x, y = self:CalculateMinimapCoords(self:GetDegr(playerName))
	ProfessionsBook_MinimapSlider:SetValue(self:GetDegr(playerName))
	ProfessionsBook_MinimapButton:SetPoint("CENTER", "MinimapBackdrop", "CENTER", x, y)	
	ProfessionsBook_ColorCode = self:GetColorCode(playerName)
	if ProfessionsBook_ColorCode == true then
		ProfessionsBook_ColorCodeCheckButton:SetChecked(1)
	else
		ProfessionsBook_ColorCodeCheckButton:SetChecked(nil)
	end
	ProfessionsBook_EnhanceTooltips = self:GetEnhanceTooltips(playerName)
	if ProfessionsBook_EnhanceTooltips == true then
		ProfessionsBook_EnhanceTooltipCheckButton:SetChecked(1)
	else
		ProfessionsBook_EnhanceTooltipCheckButton:SetChecked(nil)
	end
	ProfessionsBook_SaveLastViewingChar = self:GetLastViewingPlayer(playerName)
	if ProfessionsBook_SaveLastViewingChar == true then
		ProfessionsBook_SaveViewingCharacterCheckButton:SetChecked(1)
	else
		ProfessionsBook_SaveViewingCharacterCheckButton:SetChecked(nil)
	end
end

function ProfessionsBook:CalculateMinimapCoords(degr)
	local x, y
	
	y = sin(degr ) * 80
	x = y / tan(degr)
	return x + 10, y + 24
end

function ProfessionsBook_MinimapSlider_Init(slider)
	local sl = getglobal(slider)

	getglobal(slider .. "Low"):SetText("1")
	getglobal(slider .. "High"):SetText("360")
	getglobal(slider .. "Text"):SetText(L["Minimap position"])
end

function ProfessionsBook_MinimapSlider_Change()
	local degr, x, y, playerName
	
	playerName= UnitName("player")
	degr = ProfessionsBook_MinimapSlider:GetValue()
	x, y = ProfessionsBook:CalculateMinimapCoords(degr)
	ProfessionsBook_MinimapButton:SetPoint("CENTER", "MinimapBackdrop", "CENTER", x, y)
	if ProfessionsBook.GetRealm(ProfessionsBook) ~= nil then
		ProfessionsBook.SetDegr(ProfessionsBook, playerName, degr)
	end
end

function ProfessionsBook_MinimapCheckButton__OnClick()
	local playerName

	playerName= UnitName("player")
	if ProfessionsBook_MinimapCheckButton:GetChecked() == 1 then
		ProfessionsBook_MinimapButton:Show()
		ProfessionsBook:SetMinimap(playerName, 1)
	else
		ProfessionsBook_MinimapButton:Hide()
		ProfessionsBook:SetMinimap(playerName, 0)
	end
end

function ProfessionsBook_ColorCodeCheckButton__OnClick()
	local playerName

	playerName= UnitName("player")
	if ProfessionsBook_ColorCodeCheckButton:GetChecked() == 1 then
		ProfessionsBook_ColorCode = true
		ProfessionsBook:SetColorCode(playerName, true)
	else
		ProfessionsBook_ColorCode = false
		ProfessionsBook:SetColorCode(playerName, false)
	end	
end

function ProfessionsBook_EnhanceTooltipCheckButton__OnClick()
	local playerName

	playerName= UnitName("player")
	if ProfessionsBook_EnhanceTooltipCheckButton:GetChecked() == 1 then
		ProfessionsBook_EnhanceTooltips = true
		ProfessionsBook:SetEnhanceTooltips(playerName, true)
	else
		ProfessionsBook_EnhanceTooltips = false
		ProfessionsBook:SetEnhanceTooltips(playerName, false)
	end	
end

function ProfessionsBook_SaveViewingCharacter__OnClick()
	playerName= UnitName("player")
	if ProfessionsBook_SaveViewingCharacterCheckButton:GetChecked() == 1 then
		ProfessionsBook_SaveLastViewingChar = true
		ProfessionsBook:SetLastViewingPlayer(playerName, true)
	else
		ProfessionsBook_SaveLastViewingChar = false
		ProfessionsBook:SetLastViewingPlayer(playerName, false)
	end	
end

function ProfessionsBook_MinimapButton_OnClick()
	ProfessionsBook:ShowFrame()
end

function ProfessionsBook:RemoveDuplicates(knowingRecipe, mayLearnRecipe)
	local newList = {}
	local k1, v1, k2, v2, double
	
	for k1,v1 in pairs(mayLearnRecipe) do
		double = false
		for k2,v2 in pairs(knowingRecipe) do
			if v1 == v2 then
				double = true
			end
		end
		if double == false then
			table.insert(newList, v1)
		end
	end
	return newList
end

function ProfessionsBook:ShowTooltip(tooltip, tooltipName)
	local k,v, k2, v2, skillLevel, line, text, newText, a, charSkillLevel, charCount
	local mayLearnRecipe = {}
	local knowingRecipe = {}
	local mayLearnRecipeLater = {}
	
	for k,v in pairs(ProfessionsBook_Professions) do
		skillLevel = self:GetSkillLevel(tooltipName, v)
		if  skillLevel > -1 then
			line = getglobal(tooltipName .. "TextLeft" .. 1)
			text = line:GetText()
			a, _ = string.find(text, ': ') 
			if (a ~= nil) then
				text =  string.sub(text, a + 2)
			else
				return 0
			end
			knowingRecipe = self:GetCharsKnowingRecipe(text, v)	
			mayLearnRecipe = self:GetCharsMayLearnRecipe(v, skillLevel)
			mayLearnRecipe = self:RemoveDuplicates(knowingRecipe, mayLearnRecipe)
			mayLearnRecipeLater = self:GetCharsMayLearnRecipeLater(v)
			if getn(knowingRecipe) + getn(mayLearnRecipe) > 0 then
				tooltip:AddLine(" ")
			end
			if getn(knowingRecipe)  > 0 then
				newText = L["Known"] .. ": "
				for k2, v2 in pairs(knowingRecipe) do
					newText = newText .. " " .. v2
				end
				tooltip:AddLine(newText, 0.3, 0.3, 1.0)	
			end
			if getn(mayLearnRecipe)  > 0 then
				newText = L["Learnable"] .. ": "
				for k2, v2 in pairs(mayLearnRecipe) do
					newText = newText .. " " .. v2
				end
				tooltip:AddLine(newText, 0.3, 1.0, 0.3)	
			end	
			if getn(mayLearnRecipeLater) > 0 then
				newText = L["Skill too low"] .. ": "
				charCount = 0
				for k2, v2 in pairs(mayLearnRecipeLater) do
					 charSkillLevel = self:GetTradeSkillLevel(v2, v)
					if charSkillLevel < skillLevel then
						 charCount = charCount + 1
						newText = newText .. " " .. v2 .. "(" .. tostring(charSkillLevel) ..")"
					end
				end
				if charCount > 0 then
					tooltip:AddLine(newText, 1.0, 1.0, 0.1)
				end
			end
			tooltip:Show()
		end
	end
end

function ProfessionsBook:ShowItemTooltip(args)
	local link, text, button
	
	link = args[1]
	text = args[2]
	button = args[3]
	SetItemRef(link, text, button)
	text = '|Hplayer:Kaso|h[Kaso]|h'
	SetItemRef(link, text, button)
end

function ProfessionsBook:GetSkillLevel(tooltip, skillName)
	local i, line, text, a, b, skill, pattern, myTooltip

	myTooltip = getglobal(tooltip)
	for i=1,myTooltip:NumLines() do
		line = getglobal(tooltip .. "TextLeft" .. i)
		text = line:GetText()
		pattern = "%w+ " .. skillName .. " %((%w+)%)"
		a, b, skill = string.find(text, pattern)
		if skill ~= nil then
			return tonumber(skill)
		end
	end
	return -1
end

function ProfessionsBook:IsRecipe(tooltip)
	local i, line, text, a, b, skill, pattern, myTooltip

	myTooltip = getglobal(tooltip)
	for i=1,myTooltip:NumLines() do
		line = getglobal(tooltip .. "TextLeft" .. i)
		text = line:GetText()
		pattern = "%w+ " .. skillName .. " %((%w+)%)"
		a, b, skill = string.find(text, pattern)
		if skill ~= nil then
			return tonumber(skill)
		end
	end
	return -1
end

function ProfessionsBook:GetCharsMayLearnRecipeLater(skillName)
	local charList = {}
	local resultList = {}
	local k, v, charSkillLevel
	
	charList = self:GetCharList()
	for k,v in pairs(charList) do
		charSkillLevel = self:GetTradeSkillLevel(v, skillName)
		if (charSkillLevel > 0) then
			table.insert(resultList, v)
		end
	end
	table.sort(resultList)
	return resultList
end

function ProfessionsBook:GetCharsMayLearnRecipe(skillName, skillLevel)
	local charList = {}
	local resultList = {}
	local k, v, charSkillLevel
	
	charList = self:GetCharList()
	for k,v in pairs(charList) do
		charSkillLevel = self:GetTradeSkillLevel(v, skillName)
		if (skillLevel <= charSkillLevel) and (skillLevel > 0)then
			table.insert(resultList, v)
		end
	end
	table.sort(resultList)
	return resultList
end

function ProfessionsBook:ConvertRecipeToItem(itemLink)
	local a, b
	
	a, _ = string.find(itemLink, ': ') 
	b, _ = string.find(itemLink, ']')
	if (a ~= nil) and (b ~= nil) then
		return string.sub(itemLink, a + 2, b - 1)
	else
		return ""
	end
end

function ProfessionsBook:GetAuctionItemColor(itemLink, itemType, skill, id)
	local result, itemLevel
	local knowingRecipe = {}
	local mayLearnRecipe = {}
	local mayLearnRecipeLater = {}	

	if itemType == L["Recipe"] then
		ProfessionsBook_Tooltip:SetAuctionItem("list", id)
		itemLevel = self:GetSkillLevel("ProfessionsBook_Tooltip", skill)	
		--red
		result = "red"
		--yellow
		mayLearnRecipeLater = self:GetCharsMayLearnRecipeLater(skill)
		if getn(mayLearnRecipeLater) > 0 then
			result = "yellow"
		end
		--green
		mayLearnRecipe = self:GetCharsMayLearnRecipe(skill, itemLevel)
		if getn(mayLearnRecipe) > 0 then
			result = "green"
		end
		-- Blue color
		knowingRecipe = self:GetCharsKnowingRecipe(self:ConvertRecipeToItem(itemLink), skill)				
		if getn(knowingRecipe) > 0 then
			result = "blue"
		end	
	end
	return result
end

function ProfessionsBook:SetAuctionColors()
	local auctionCount, i, itemLink, itemType, skill, buttonName, iconTexture

	auctionCount, _ = GetNumAuctionItems("list")	
	-- Find out, if auction items have been updated and get color.
	for i = 1, auctionCount do
		itemLink = GetAuctionItemLink("list", i)
		if itemLink ~= nil then
			_, _, _, _, _, itemType, skill, _, _, _ = GetItemInfo(itemLink) 
			if ProfessionsBook_AuctionItemList[itemLink] == nil then
				ProfessionsBook_AuctionItemList[itemLink] = self:GetAuctionItemColor(itemLink, itemType, skill, i)
			end
		end
	end	

	for i = 1, PROFESSIONSBOOK_AUCTION_DISPLAY_COUNT do
		buttonName = "BrowseButton"..i
		if ProfessionsBook_AuctioneerAdv == true and getglobal("BrowseButton"..i):IsVisible() then
			itemLink = GetAuctionItemLink("list", getglobal("BrowseButton"..i).id)
		else
			itemLink = GetAuctionItemLink("list", i + FauxScrollFrame_GetOffset(BrowseScrollFrame))
		end
		if ProfessionsBook_AuctioneerAdv == true then
			iconTexture = getglobal("BrowseButton"..i).Icon
			iconTexture:SetVertexColor(1.0, 1.0, 1.0)
		else
			iconTexture = getglobal(buttonName.."ItemIconTexture")
		end		
		if itemLink ~= nil then
			_, _, _, _, _, itemType, _, _, _, _ = GetItemInfo(itemLink) 
			if itemType == L["Recipe"] then
				if ProfessionsBook_AuctionItemList[itemLink] == "red" then
					iconTexture:SetVertexColor(1.0, 0.1, 0.1)
				end	
				if ProfessionsBook_AuctionItemList[itemLink] == "yellow" then
					iconTexture:SetVertexColor(1.0, 1.0, 0.1)
				end				
				if ProfessionsBook_AuctionItemList[itemLink] == "green" then
					iconTexture:SetVertexColor(0.3, 1.0, 0.3)
				end
				if ProfessionsBook_AuctionItemList[itemLink] == "blue" then
					iconTexture:SetVertexColor(0.3, 0.3, 1.0)
				end				
			end
		end
	end
end

function ProfessionsBook_ClearDatabase_Button_OnClick()
	StaticPopup_Show("ProfessionBook_DeleteDatabase")
end

