local L = AceLibrary("AceLocale-2.2"):new("ProfessionsBook")
ProfessionsBook = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "AceEvent-2.0")

-- Create chat commands
local options = { 
    type='group',
    args = {
        Show = {
			name = "ProfessionsBook_Show",
		    type = 'execute',
			desc = L["Opens ProfessionsBook"],
			func = "ShowFrame"
        },
		Debug = {
			name = "ProfessionsBook_Debug",
			type = 'execute',
			desc = "Debuggin",
			func = "Debug"
		},
    },
}
ProfessionsBook:RegisterChatCommand("/professionsbook", "/pb", options)

-- Constants
PROFESSIONSBOOK_MAXRESCANS = 20
BINDING_NAME_PROFESSIONSBOOK = L["Opens ProfessionsBook"]
BINDING_HEADER_PROFESSIONSBOOK = "ProfessionsBook"
PROFESSIONSBOOK_TITLE = L["Professions Book"]
PROFESSIONSBOOK_SEND = L["Send"]
PROFESSIONSBOOK_OPTIONS = L["Options"] 
PROFESSIONSBOOK_OPTIONSTITLE = PROFESSIONSBOOK_OPTIONS .. " PB v" .. GetAddOnMetadata("ProfessionsBook", "Version")
PROFESSIONSBOOK_SHOWMINIMAPICON = L["Show minimap icon"]
PROFESSIONSBOOK_SORTDIFFICULTY = L["Difficulty"]
PROFESSIONSBOOK_SORTALPHABETICALLY = L["Alphabetically"]
PROFESSIONSBOOK_SEARCHRECIPES = L["Recipes"]
PROFESSIONSBOOK_SEARCHREAGENTS = L["Reagents"]
PROFESSIONSBOOK_SHOWCOLORCODE = L["Show color coding in auction house"]
PROFESSIONSBOOK_ENHANCETOOLTIP = L["Add recipe information to tooltip."]
PROFESSIONSBOOK_CLEARDATABASE = L["Delete database"]
PROFESSIONSBOOK_SAVEVIEWINGCHARACTER = L["Save last viewing character"]
PROFESSIONSBOOK_TRADESKILL_BUTTON_COUNT = 6
PROFESSIONSBOOK_TRADEITEM_BUTTON_COUNT = 8
PROFESSIONSBOOK_TRADEITEM_HEIGHT = 16
PROFESSIONSBOOK_SEARCHITEM_BUTTON_COUNT = 19
PROFESSIONSBOOK_SEARCHITEM_HEIGHT = 16
PROFESSIONSBOOK_AUCTION_DISPLAY_COUNT = 8
ProfessionsBook_TradeItemTypeColor = { }
ProfessionsBook_TradeItemTypeColor["optimal"]	= { r = 1.00, g = 0.50, b = 0.25 }
ProfessionsBook_TradeItemTypeColor["medium"]	= { r = 1.00, g = 1.00, b = 0.00 }
ProfessionsBook_TradeItemTypeColor["easy"]		= { r = 0.25, g = 0.75, b = 0.25 }
ProfessionsBook_TradeItemTypeColor["trivial"]	= { r = 0.50, g = 0.50, b = 0.50 }
ProfessionsBook_TradeItemTypeColor["header"]	= { r = 1.00, g = 0.82, b = 0 }
ProfessionsBook_Professions = {L["Alchemy"], L["Blacksmithing"], L["Enchanting"], L["Engineering"], L["Jewelcrafting"], L["Leatherworking"], L["Tailoring"], L["Cooking"], L["First Aid"] }

-- Global variables
ProfessionsBook_ColorCode = true
ProfessionsBook_EnhanceTooltips = true
ProfessionsBook_SaveLastViewingChar = true
ProfessionsBook_AuctionHooked = false
ProfessionsBook_CraftSkillHooked = false
ProfessionsBook_TradeSkillHooked = false
ProfessionsBook_SelectedTradeSkill = ""
ProfessionsBook_selectedTradeItem = ""
ProfessionsBook_Headers = {}
ProfessionsBook_TradeItemList = {}
ProfessionsBook_SeachResult = {}
ProfessionsBook_SearchFrameVisible = false
ProfessionsBook_selectedSearchItem = ""
ProfessionsBook_BlizzTradeSkillFunc = nil
ProfessionsBook_DefaultErrorHandler = nil
ProfessionsBook_SelectedChannel = 0
ProfessionsBook_RescanCounter = 0
ProfessionsBook_RescanStatus = "ok"
ProfessionsBook_AuctioneerAdv = false
ProfessionsBook_AuctionItemList = {}
ProfessionsBook_SortOrder = 0
ProfessionsBook_SearchType = 0
ProfessionsBook_LastTime = nil
ProfessionsBook_TradeSkillType = "none"

--  Hooking functions
local PB_AuctionScroll = function (...)
	if ProfessionsBook_ColorCode == true then
		ProfessionsBook:SetAuctionColors()
	end
end

local PB_ShowTooltip = function (...)
	if ProfessionsBook_EnhanceTooltips == true then
		ProfessionsBook:ShowTooltip(GameTooltip, "GameTooltip")
	end
end

PB_ToogleFrame = function (...)
	ProfessionsBook:ShowFrame()
end

local PB_ShowItemTooltip = function (...)
	if ProfessionsBook_EnhanceTooltips == true then
		ProfessionsBook:ShowTooltip(ItemRefTooltip, "ItemRefTooltip")
	end
end

-- Events
function ProfessionsBook:ADDON_LOADED()
	if IsAddOnLoaded("Blizzard_AuctionUI") then
		hooksecurefunc("AuctionFrameBrowse_Update", PB_AuctionScroll) 
	end
	self:Compatibility()
end

function PB_ErrorWithStack(msg)
   --msg = msg.."\n"..debugstack()
   --ProfessionsBook:Print(msg)
end

function ProfessionsBook:Compatibility()
	if IsAddOnLoaded("AHExtend") == 1 then
		PROFESSIONSBOOK_AUCTION_DISPLAY_COUNT = 16
	end
	ProfessionsBook_AuctioneerAdv = false
	if IsAddOnLoaded("Auc-Advanced") == 1 then
		if AucAdvanced.Settings.GetSetting("util.compactui.activated") == true then
			self:DebugPrint("Auctioneer Advanced CompactUI detected")
			PROFESSIONSBOOK_AUCTION_DISPLAY_COUNT = 14
			ProfessionsBook_AuctioneerAdv = true
		end
	end	
	if IsAddOnLoaded("AuctionFilterPlus") == 1 then
		hooksecurefunc("afp_AuctionFrameBrowse_Update", PB_AuctionScroll)
	end
end

function ProfessionsBook:Debug()
	if ProfessionsBook_Debug == false then
		self:Print("Debugging turned on.")
		ProfessionsBook_Debug = true
		seterrorhandler(PB_ErrorWithStack)
	else
		self:Print("Debugging turned off.")
		ProfessionsBook_Debug = false
		seterrorhandler(ProfessionsBook_DefaultErrorHandler)
	end
end

function ProfessionsBook:DebugPrint(string)
	if ProfessionsBook_Debug == true then
		self:Print(string)
	end
end

function ProfessionsBook:OnInitialize()
	ProfessionsBook_DefaultErrorHandler = geterrorhandler()
	self:InitOptions()	
	self:RegisterEvent("ADDON_LOADED")
	self:RegisterEvent("TRADE_SKILL_SHOW")
	self:RegisterEvent("TRADE_SKILL_UPDATE")
	self:RegisterEvent("CRAFT_SHOW")
	self:RegisterEvent("CRAFT_UPDATE")
	hooksecurefunc(GameTooltip, "SetAuctionItem", PB_ShowTooltip)
	hooksecurefunc(GameTooltip, "SetBagItem", PB_ShowTooltip)
	hooksecurefunc(GameTooltip, "SetLootItem", PB_ShowTooltip)
	hooksecurefunc(GameTooltip, "SetHyperlink", PB_ShowTooltip)
	hooksecurefunc(GameTooltip, "SetLootRollItem", PB_ShowTooltip)
	hooksecurefunc(GameTooltip, "SetMerchantItem", PB_ShowTooltip)
	hooksecurefunc("SetItemRef", PB_ShowItemTooltip)
	ProfessionsBook_Debug = false
end

function ProfessionsBook:ShowFrame()
	local i, selectChar, charCount
	
	if ProfessionsBook_Frame:IsVisible() then
		ProfessionsBook_Frame:Hide()
	else
		UIDropDownMenu_Initialize(ProfessionsBook_CharacterDropDownMenu, ProfessionsBook_CharacterDropDownMenu_Initialize)	
		if self:GetLastViewingPlayer(UnitName("player")) == true then
			selectChar = self:GetSelectedChar()
		else
			selectChar = UnitName("player")
		end
		charCount = getn(self:GetCharList())
		if  selectChar ~= "" then
			for i = 0, charCount do	
				UIDropDownMenu_SetSelectedValue(ProfessionsBook_CharacterDropDownMenu, i)	
				if selectChar == UIDropDownMenu_GetText(ProfessionsBook_CharacterDropDownMenu) then
					break
				end
				if UIDropDownMenu_GetText(ProfessionsBook_CharacterDropDownMenu) == nil then
					UIDropDownMenu_SetSelectedValue(ProfessionsBook_CharacterDropDownMenu, 0)
				end
			end
		else
			UIDropDownMenu_SetSelectedValue(ProfessionsBook_CharacterDropDownMenu, 0)
			self:SetSelectedChar(UIDropDownMenu_GetText(ProfessionsBook_CharacterDropDownMenu))
		end
		UIDropDownMenu_Initialize(ProfessionsBook_ChannelsDropDownMenu, ProfessionsBook_ChannelsDropDownMenu_Initialize)
		UIDropDownMenu_SetSelectedValue(ProfessionsBook_ChannelsDropDownMenu, 0)	
		ProfessionsBook_Frame:Show()
		ProfessionsBook_SendButton:Disable()
		ProfessionsBook:UpdateTradeSkillSelection()
		ProfessionsBook_DetailScrollFrame:Hide()
		ProfessionsBook:HideSearchFrame()
		searchFrameIsShown = false
		ProfessionsBook_SortDifficulty_CheckButton:SetChecked(1)
		ProfessionsBook_SortAlphabetically_CheckButton:SetChecked(nil)
		ProfessionsBook_SortOrder = 0
		ProfessionsBook_SearchReagents_CheckButton:SetChecked(nil)
		ProfessionsBook_SearchReagents_CheckButton:Hide()
		ProfessionsBook_SearchRecipes_CheckButton:SetChecked(1)
		ProfessionsBook_SearchRecipes_CheckButton:Hide()
		ProfessionsBook_SearchType = 0
	end
	ProfessionsBook_SelectedChannel = 0
end

function ProfessionsBook:Hide()
	local i, button

	for i = 1, PROFESSIONSBOOK_TRADEITEM_BUTTON_COUNT do
		button = getglobal("ProfessionsBook_TradeItemButton" .. i)
		button:Hide()
	end
	ProfessionsBook_TradeItemHighlightFrame:Hide()
	for i = 1, PROFESSIONSBOOK_TRADESKILL_BUTTON_COUNT do
		button = getglobal("ProfessionsBook_TradeSkillButton" .. i)
		button:UnlockHighlight()
	end
	ProfessionsBook_DetailScrollFrame:Hide()
	ProfessionsBook_SendButton:Disable()
	ProfessionsBook_SkillLevel:Hide()
end

function ProfessionsBook:UpdateTradeSkillSelection()
	local i
	local button
	local k, v
	local tradeSkillList = {}
	
	for i = 1, PROFESSIONSBOOK_TRADESKILL_BUTTON_COUNT do
		button = getglobal("ProfessionsBook_TradeSkillButton" .. i)
		button:Hide()
	end
	i = 1
	tradeSkillList = self:GetTradeSkillList(UIDropDownMenu_GetText(ProfessionsBook_CharacterDropDownMenu))
	for k,v in pairs(tradeSkillList) do 
		if v ~= "UNKNOWN" then
			button = getglobal("ProfessionsBook_TradeSkillButton" .. i)
			button:SetText(v)
			button:Show()
			i = i + 1
		end
	end
end

