local L = AceLibrary("AceLocale-2.2"):new("ProfessionsBook")
ProfessionsBook:RegisterDB("ProfessionsBookDB")

ProfessionsBook:RegisterDefaults('realm', {
	selectedChar = "",
	chars = {
		['*'] = { 
			minimap = 0,
			degr = 180,
			colorCode = true,
			enhanceTooltips = true,
			saveLastViewingPlayer = true,
			tradeSkills = {
				['*'] = { 
					skillLevel = 0,
					tradeItemCount = 0,
					headers = {
						['*'] = {
							headerName = "",
							tradeItems = {
								['*'] = { 
									recipeID = 0,
									tradeItemType = ""
								}
							}
						}
					}
				}
			}
		}
	}
})

ProfessionsBook:RegisterDefaults('account', {
	recipeCount = 0,
	recipes = {
		['*'] = { 
			recipeName = "",
			recipeLink = "",
			recipeRecipeLink = "",
			recipeTool = "",
			recipeItemCount = 0,
			reagents = {
				['*'] = { 
					reagentItemCount = 0,
					reagentItemName = "",
					reagentItemLink = ""
				}
			},
			characters = {
				['*'] = {
					realm = "",
					faction = ""
				}
			}
		}
    }
})

-- Seach result element
local searchElement = {
	charName = "",
	tradeSkill = "",
	id = 0,
	tradeItemName = ""
}

local ProfessionsBook_Difficulty = {"header", "optimal", "medium", "easy", "trivial"}

function ProfessionsBook:GetRealm()
	local realm
	
	realm = self.db.realm
	if realm == nil then
		self:DebugPrint("GetRealm(): realm is nil")
	end
	return realm
end

function ProfessionsBook:GetMinimap(playerName)
	local minimap
	
	if playerName == nil then
		self:DebugPrint("GetMinimap(): playerName is nil ")
	end
	minimap = self.db.realm.chars[playerName].minimap
	if minimap == nil then
		self:DebugPrint("GetMinimap(): minimap is nil")
	end
	return minimap
end

function ProfessionsBook:SetMinimap(playerName, value)
	if playerName == nil then
		self:DebugPrint("SetMinimap(): playerName is nil ")
	end
	if value == nil then
		self:DebugPrint("SetMinimap(): value is nil ")
	end
	self.db.realm.chars[playerName].minimap = value
end

function ProfessionsBook:GetDegr(playerName)
	local degr

	if playerName == nil then
		self:DebugPrint("GetDegr(): playerName is nil ")
	end
	degr = self.db.realm.chars[playerName].degr
	if degr == nil then
		self:DebugPrint("GetDegr(): degr is nil ")
	end
	return degr
end

function ProfessionsBook:SetDegr(playerName, value)
	if playerName == nil then
		self:DebugPrint("SetDegr(): playerName is nil ")
	end
	if value == nil then
		self:DebugPrint("SetDegr(): value is nil ")
	end
	self.db.realm.chars[playerName].degr = value
end

function ProfessionsBook:GetColorCode(playerName)
	local colorCode
	
	if playerName == nil then
		self:DebugPrint("GetColorCode(): playerName is nil ")
	end
	colorCode = self.db.realm.chars[playerName].colorCode
	if colorCode == nil then
		self:DebugPrint("GetColorCode(): colorCode is nil ")
	end
	return colorCode
end

function ProfessionsBook:GetLastViewingPlayer(playerName)
	local result
	
	if playerName == nil then
		self:DebugPrint("GetLastViewingPlayer(): playerName is nil ")
	end
	result = self.db.realm.chars[playerName].saveLastViewingPlayer
	if result == nil then
		self:DebugPrint("GetLastViewingPlayer(): result is nil ")
	end
	return result
end

function ProfessionsBook:SetLastViewingPlayer(playerName, value)
	if playerName == nil then
		self:DebugPrint("SetLastViewingPlayer(): playerName is nil ")
	end
	if value == nil then
		self:DebugPrint("SetLastViewingPlayer(): value is nil ")
	end
	self.db.realm.chars[playerName].saveLastViewingPlayer = value
end

function ProfessionsBook:SetColorCode(playerName, value)
	if playerName == nil then
		self:DebugPrint("SetColorCode(): playerName is nil ")
	end
	if value == nil then
		self:DebugPrint("SetColorCode(): value is nil ")
	end
	self.db.realm.chars[playerName].colorCode = value
end

function ProfessionsBook:GetEnhanceTooltips(playerName)
	local enhanceTooltips
	
	if playerName == nil then
		self:DebugPrint("GetEnhanceTooltips(): playerName is nil ")
	end
	enhanceTooltips = self.db.realm.chars[playerName].enhanceTooltips
	if enhanceTooltips == nil then
		self:DebugPrint("GetEnhanceTooltips(): enhanceTooltips is nil ")
	end
	return enhanceTooltips
end

function ProfessionsBook:SetEnhanceTooltips(playerName, value)
	if playerName == nil then
		self:DebugPrint("SetEnhanceTooltips(): playerName is nil ")
	end
	if value == nil then
		self:DebugPrint("SetEnhanceTooltips(): value is nil ")
	end
	self.db.realm.chars[playerName].enhanceTooltips = value
end

function ProfessionsBook:GetTradeSkillLevel(playerName, tradeSkillName)
	local skillLevel
	
	if playerName == nil then
		self:DebugPrint("GetTradeSkillLevel(): playerName is nil ")
	end
	if tradeSkillName == nil then
		self:DebugPrint("GetTradeSkillLevel(): tradeSkillName is nil ")
	end	
	skillLevel = self.db.realm.chars[playerName].tradeSkills[tradeSkillName].skillLevel	
	if skillLevel == nil then
		self:DebugPrint("GetTradeSkillLevel(): skillLevel is nil ")
	end	
	return skillLevel
end

function ProfessionsBook:SetTradeSkillLevel(playerName, tradeSkillName, value)
	if playerName == nil then
		self:DebugPrint("SetTradeSkillLevel(): playerName is nil ")
	end
	if tradeSkillName == nil then
		self:DebugPrint("SetTradeSkillLevel(): tradeSkillName is nil ")
	end	
	if value == nil then
		self:DebugPrint("SetTradeSkillLevel(): value is nil ")
	end	
	self.db.realm.chars[playerName].tradeSkills[tradeSkillName].skillLevel = value
end

function ProfessionsBook:GetTradeItemCount(playerName, tradeSkillName)
	local count
	
	if playerName == nil then
		self:DebugPrint("GetTradeItemCount(): playerName is nil ")
	end
	if tradeSkillName == nil then
		self:DebugPrint("GetTradeItemCount(): tradeSkillName is nil ")
	end	
	count = self.db.realm.chars[playerName].tradeSkills[tradeSkillName].tradeItemCount
	if count ~= nil then
		return count
	else
		return 0
	end
end

function ProfessionsBook:SetTradeItemCount(playerName, tradeSkillName, value)
	if playerName == nil then
		self:DebugPrint("SetTradeItemCount(): playerName is nil ")
	end
	if tradeSkillName == nil then
		self:DebugPrint("SetTradeItemCount(): tradeSkillName is nil ")
	end	
	if value == nil then
		self:DebugPrint("SetTradeItemCount(): value is nil ")
	end	
	self.db.realm.chars[playerName].tradeSkills[tradeSkillName].tradeItemCount = value
end

function ProfessionsBook:GetRecipeID(recipeName)
	local key, value
	
	if recipeName == nil then
		self:DebugPrint("GetRecipeID(): recipeName is nil ")
	end
	if self.db.account.recipes ~= nil then
		for key, value in pairs(self.db.account.recipes) do
			if value.recipeName == recipeName then
				return tonumber(key)
			end
		end
	end
	return -1
end

function ProfessionsBook:AddRecipe(tradeItemName, tradeItemLink, tradeItemRecipeLink, tradeItemTool, recipeItemCount)
	local id

	if tradeItemName == nil then
		self:DebugPrint("AddRecipe(): tradeItemName is nil ")
	end
	if tradeItemLink == nil then
		self:DebugPrint("AddRecipe(): tradeItemLink is nil ")
	end	
	if tradeItemRecipeLink == nil then
		self:DebugPrint("AddRecipe(): tradeItemRecipeLink is nil ")
	end	
	if tradeItemTool == nil then
		self:DebugPrint("AddRecipe(): tradeItemTool is nil ")
	end	
	id = 0
	if self.db.account.recipes ~= nil then
		for k,v in pairs(self.db.account.recipes) do
			if (tonumber(k) ~= nil) and (tonumber(k) > id) then
				id = tonumber(k)
			end
		end
	end
	id = id + 1
	self.db.account.recipes[tostring(id)].recipeName = tradeItemName
	self.db.account.recipes[tostring(id)].recipeLink = tradeItemLink
	self.db.account.recipes[tostring(id)].recipeRecipeLink = tradeItemRecipeLink
	self.db.account.recipes[tostring(id)].recipeTool = tradeItemTool	
	self.db.account.recipes[tostring(id)].recipeItemCount = recipeItemCount
	self.db.account.recipeCount = id
	return id
end

function ProfessionsBook:AddCharToRecipe(id)
	local playerName, realmName, faction
	
	playerName = UnitName("player")
	realmName = GetRealmName()
	faction, _ = UnitFactionGroup("player")
	
	if (self.db.account.recipes[tostring(id)].characters ~= nil) and (self.db.account.recipes[tostring(id)].characters[playerName].realm ~= nil) then
		if self.db.account.recipes[tostring(id)].characters[playerName].realm == "" then
			self.db.account.recipes[tostring(id)].characters[playerName].realm = realmName
			self.db.account.recipes[tostring(id)].characters[playerName].faction = faction
		end
	end
end

function ProfessionsBook:AddReagent(recipeID, reagentID, reagentName, reagentCount, reagentItemLink)
	if recipeID == nil then
		self:DebugPrint("AddReagent(): recipeID is nil ")
	end
	if reagentID == nil then
		self:DebugPrint("AddReagent(): reagentID is nil ")
	end	
	if reagentName == nil then
		self:DebugPrint("AddReagent(): reagentName is nil ")
	end	
	if reagentCount == nil then
		self:DebugPrint("AddReagent(): reagentCount is nil ")
	end	
	if reagentItemLink == nil then
		self:DebugPrint("AddReagent(): reagentItemLink is nil ")
	end		
	self.db.account.recipes[tostring(recipeID)].reagents[tostring(reagentID)].reagentItemName = reagentName
	self.db.account.recipes[tostring(recipeID)].reagents[tostring(reagentID)].reagentItemCount = reagentCount
	self.db.account.recipes[tostring(recipeID)].reagents[tostring(reagentID)].reagentItemLink = reagentItemLink
end

function ProfessionsBook:ClearTradeSkill(playerName, tradeSkillName)
	if playerName == nil then
		self:DebugPrint("ClearTradeSkill(): playerName is nil ")
	end
	if tradeSkillName == nil then
		self:DebugPrint("ClearTradeSkill(): tradeSkillName is nil ")
	end	
	self.db.realm.chars[playerName].tradeSkills[tradeSkillName] = nil
end

function ProfessionsBook:AddHeader(playerName, tradeSkillName, headerName)
	local headerID, k, v
	
	if playerName == nil then
		self:DebugPrint("AddHeader(): playerName is nil ")
	end
	if tradeSkillName == nil then
		self:DebugPrint("AddHeader(): tradeSkillName is nil ")
	end
	if headerName == nil then
		self:DebugPrint("AddHeader(): headerName is nil ")
	end	
	if tradeSkillName == L["Enchanting"] then
		headerID = 1
	else
		-- Get new headerID
		headerID = 0
		if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers ~= nil then
			for k,v in pairs(self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers) do
				if tonumber(k) ~= nil then
					if tonumber(k) > headerID then
						headerID = tonumber(k)
					end
				end
			end
		end
		headerID = headerID + 1
	end
	if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers ~= nil then
		self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[tostring(headerID)].headerName = headerName
	end
end

function ProfessionsBook:GetHeaderList(playerName, tradeSkillName)
	local headerList = {}
	local key, value

	if playerName == nil then
		self:DebugPrint("GetHeaderList(): playerName is nil ")
	end
	if tradeSkillName == nil then
		self:DebugPrint("GetHeaderList(): tradeSkillName is nil ")
	end	
	if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers ~= nil then
		for key, value in pairs(self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers) do
			headerList[key] = true
		end
	end
	return headerList
end

function ProfessionsBook:ColapseAllHeaders()
	for key, value in pairs(ProfessionsBook_Headers) do
		ProfessionsBook_Headers[key] = false
	end
end

function ProfessionsBook:ExpandAllHeaders()
	for key, value in pairs(ProfessionsBook_Headers) do
		ProfessionsBook_Headers[key] = true
	end
end

function ProfessionsBook:GetHeaderName(playerName, tradeSkillName, id)
	local headerName
	
	if playerName == nil then
		self:DebugPrint("GetHeaderName(): playerName is nil ")
	end
	if tradeSkillName == nil then
		self:DebugPrint("GetHeaderName(): tradeSkillName is nil ")
	end	
	if id == nil then
		self:DebugPrint("GetHeaderName(): id is nil ")
	end
	headerName = self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[tostring(id)].headerName
	if headerName == nil then
		self:DebugPrint("GetHeaderName(): headerName is nil ")
	end	
	return headerName
end

function ProfessionsBook:GetHeaderID(playerName, tradeSkillName, name)
	local k, v
	
	if playerName == nil then
		self:DebugPrint("GetHeaderID(): playerName is nil ")
	end
	if tradeSkillName == nil then
		self:DebugPrint("GetHeaderID(): tradeSkillName is nil ")
	end	
	if name == nil then
		self:DebugPrint("GetHeaderID(): name is nil ")
	end
	if tradeSkillName == L["Enchanting"] then
		return 1
	end
	if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers ~= nil then
		for k,v in pairs(self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers) do
			if tonumber(k) ~= nil then
				if v.headerName == name then
					return tonumber(k)
				end
			end
		end
	end
	return -1
end

function ProfessionsBook:AddTradeItem(playerName, tradeSkillName, headerID, recipeID, tradeItemType)
	local tradeItemID, k, v

	if playerName == nil then
		self:DebugPrint("AddTradeItem(): playerName is nil ")
	end
	if tradeSkillName == nil then
		self:DebugPrint("AddTradeItem(): tradeSkillName is nil ")
	end	
	if tradeSkillName == L["Enchanting"] then
		headerID = 1
	end	
	if headerID == nil then
		self:DebugPrint("AddTradeItem(): headerID is nil ")
	end
	if recipeID == nil then
		self:DebugPrint("AddTradeItem(): recipeID is nil ")
	end	
	if tradeItemType == nil then
		self:DebugPrint("AddTradeItem(): tradeItemType is nil ")
	end
	tradeItemID = 0
	if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[tostring(headerID)].tradeItems ~= nil then
		for k,v in pairs(self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[tostring(headerID)].tradeItems) do
			if tonumber(k) ~= nil then
				if tonumber(k) > tradeItemID then
					tradeItemID = tonumber(k)
				end
			end
		end
	end
	tradeItemID = tradeItemID + 1
	self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[tostring(headerID)].tradeItems[tostring(tradeItemID)].recipeID = recipeID
	self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[tostring(headerID)].tradeItems[tostring(tradeItemID)].tradeItemType = tradeItemType
end

function ProfessionsBook:UpdateTradeItemType(playerName, tradeSkillName, headerID, recipeID, tradeItemType)
	if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers ~= nil then
		if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[tostring(headerID)].tradeItems[tostring(recipeID)].tradeItemType ~= nil then
			self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[tostring(headerID)].tradeItems[tostring(recipeID)].tradeItemType = tradeItemType
		end
	end
end

function ProfessionsBook:GetSelectedChar()
	local selectedChar
	
	selectedChar = self.db.realm.selectedChar
	if selectedChar == nil then
		self:DebugPrint("GetSelectedChar(): selectedChar is nil ")
	end		
	return selectedChar
end

function ProfessionsBook:SetSelectedChar(name)
	if name == nil then
		self:DebugPrint("SetSelectedChar(): name is nil ")
	end		
	ProfessionsBook.db.realm.selectedChar = name
end

function ProfessionsBook:GetCharList()
	local charNames = {}
	local key, value
	
	if ProfessionsBook.db.realm.chars ~= nil then
		for key,value in pairs(ProfessionsBook.db.realm.chars) do 
			table.insert(charNames, key)
		end
	end
	table.sort(charNames)
	return charNames
end

function ProfessionsBook:GetTradeSkillList(charName)
	local skillList = {}
	local key, value

	if charName == nil then
		self:DebugPrint("GetTradeSkillList(): charName is nil ")
	end			
	if ProfessionsBook.db.realm.chars[charName].tradeSkills ~= nil then
		for key, value in pairs(ProfessionsBook.db.realm.chars[charName].tradeSkills) do
			if value.skillLevel ~= 0 then
				table.insert(skillList, key)
			end
		end
	end
	table.sort(skillList)
	return skillList
end

function ProfessionsBook:GetTradeItemList(playerName, tradeSkillName, headerList, tradeTypeFilter, placesFilter)
	-- Format in tradeItemList:
	-- 	Headers: <headerID>-0+0
	--	TradeItems: <headerID>-<recipeID>+<tradeItemID>
	
	local tradeItemList = {}
	local key1, key2, key3, value1, value2, value3
	local i = 1
	local headerName, itemPlace
	local headerIsEmpty

	if playerName == nil then
		self:DebugPrint("GetTradeItemList(): playerName is nil ")
	end		
	if tradeSkillName == nil then
		self:DebugPrint("GetTradeItemList(): tradeSkillName is nil ")
	end		
	if headerList == nil then
		self:DebugPrint("GetTradeItemList(): headerList is nil ")
	end		
	if tradeTypeFilter == nil then
		self:DebugPrint("GetTradeItemList(): tradeTypeFilter is nil ")
	end		
	if placesFilter == nil then
		self:DebugPrint("GetTradeItemList(): placesFilter is nil ")
	end		
	if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers ~= nil then
		for key1, value1 in pairs(self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers) do
			headerName = self:GetHeaderName(playerName, tradeSkillName, key1)
			headerIsEmpty = true
			-- Header is expanded and not filterd
			if (headerList[key1] == true) and ((tradeTypeFilter == L["All subclasses"]) or (tradeTypeFilter == headerName)) then
				for key2, value2 in pairs(ProfessionsBook_Difficulty) do
					if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[tostring(key1)].tradeItems ~= nil then
						for key3, value3 in pairs(self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[tostring(key1)].tradeItems) do
							if value3.tradeItemType == value2 then
								if (tonumber(value3.recipeID) > 0) then
									itemPlace = self:GetItemPlace(value3.recipeID)
									if (placesFilter == L["All places"]) or (placesFilter == itemPlace) then
										if (headerIsEmpty == true) then
											table.insert(tradeItemList, i, key1 .. "-0+0")						
											i = i + 1
										end
										table.insert(tradeItemList, i, key1 .. "-" .. value3.recipeID .. "+" .. key3)				
										i = i + 1
										headerIsEmpty = false
									end
								end
							end
						end
					end
				end
			end
		end
		-- Header is not expanded, not filtered and not empty
		if (headerList[key1] == false) and ((tradeTypeFilter == L["All subclasses"]) or (tradeTypeFilter == headerName)) then
			if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[tostring(key1)].tradeItems ~= nil then
				for key2, value2 in pairs(self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[tostring(key1)].tradeItems) do
					itemPlace = self:GetItemPlace(value2.recipeID)
					if (placesFilter == L["All places"]) or (placesFilter == itemPlace) then
						headerIsEmpty = false
					end
				end
			end
			if headerIsEmpty == false then
				table.insert(tradeItemList, i, key1 .. "-0+0")	
				i = i + 1
			end
		end
	end
	FauxScrollFrame_Update(ProfessionsBook_TradeItemListScrollFrame, i - 1, PROFESSIONSBOOK_TRADEITEM_BUTTON_COUNT, PROFESSIONSBOOK_TRADEITEM_HEIGHT)	
	return self:SortTradeItemList(tradeItemList)
end

function ProfessionsBook:SortListDifficulty(list)
	local key, value, key2, value2
	local playerName, a, c, tradeItemType
	local tempList = {}
	local newList = {}

	playerName = UIDropDownMenu_GetText(ProfessionsBook_CharacterDropDownMenu)	
	for key, value in pairs(ProfessionsBook_Difficulty) do
		tempList = {}
		for key2, value2 in pairs(list) do
			a, _, c = self:ParseTradeItem(value2)
			tradeItemType = self.db.realm.chars[playerName].tradeSkills[ProfessionsBook_SelectedTradeSkill].headers[tostring(a)].tradeItems[tostring(c)].tradeItemType
			if value == tradeItemType then
				table.insert(tempList, value2)
			end
		end
		tempList = self:SortListAlphabetically(tempList)
		for key2, value2 in pairs(tempList) do
			table.insert(newList, value2)
		end
	end
	return newList
end

function ProfessionsBook:SortListAlphabetically(list)
	local key, value, sorting
	local name1, name2, temp, b
	
	sorting = true
	while sorting == true do
		sorting = false
		for i = 1, getn(list) - 1 do
			_, b, _ = self:ParseTradeItem(list[i])
			name1 = self:GetRecipeName(b)
			_, b, _ = self:ParseTradeItem(list[i + 1])
			name2 = self:GetRecipeName(b)
			if name2 < name1 then
				sorting = true
				temp = list[i]
				list[i] = list[i + 1]
				list[i + 1] = temp
			end
		end
	end
	return list
end

function ProfessionsBook:SortList(list)
	if ProfessionsBook_SortOrder == 0 then
		list = self:SortListDifficulty(list)
	else
		list = self:SortListAlphabetically(list)
	end
	return list
end

function ProfessionsBook:SortTradeItemList(tradeItemList)
	local tradeItemListSorted = {}
	local tempList = {}
	local key, value, key2, value2
	
	for key, value in pairs(tradeItemList) do
		a, b, c = self:ParseTradeItem(value)
		-- Item is a header
		if (b == 0) and (c == 0) then
			tempList = self:SortList(tempList)
			for key2, value2 in pairs(tempList) do
				table.insert(tradeItemListSorted, value2)
			end
			tempList = {}
			table.insert(tradeItemListSorted, value)
		-- Trade item
		else
			table.insert(tempList, value)
		end
	end
	tempList = self:SortList(tempList)
	for key, value in pairs(tempList) do
		table.insert(tradeItemListSorted, value)
	end	
	return tradeItemListSorted
end

function ProfessionsBook:GetItemPlace(id)
	local itemLink, itemName, itemEquipLoc
	local a, b

	if id == nil then
		self:DebugPrint("GetItemPlace(): id is nil ")
	end	
	itemLink = ProfessionsBook.db.account.recipes[tostring(id)].recipeLink
	itemName = ProfessionsBook.db.account.recipes[tostring(id)].recipeName
	-- WoW has no function to get the equip place a enchanting can target. So we have to parse the string of the enchanting itself to geht the place. Seperator is "-". (Format: "Target - Enchanting")
	if L["Enchanting"] == ProfessionsBook_SelectedTradeSkill then
		a, b = string.find(itemName, "-")
		-- Entchanment is something to be produced and has no enchanting target.
		if a == nil then
			return L[""]
		else
			return string.sub(itemName, 1, a - 2)
		end
	else
		_, _, _, _, _, _, _, _, itemEquipLoc, _ = GetItemInfo(itemLink)
	end
	if itemEquipLoc ~= nil then
		return L[itemEquipLoc]
	else
		return ""
	end
end

function ProfessionsBook:AddToTradeItemPlaceList(id, placeList)
	local place, key, value
	local found = false

	if id == nil then
		self:DebugPrint("AddToTradeItemPlaceList(): id is nil ")
	end	
	if placeList == nil then
		self:DebugPrint("AddToTradeItemPlaceList(): placeList is nil ")
	end		
	place = self:GetItemPlace(id)
	for key, value in pairs(placeList) do
		if value == place then
			found = true
		end
	end
	if found == false then
		table.insert(placeList, place)
	end

	return placeList
end

function ProfessionsBook:GetTradeItemPlaceList()
	local key,value, a, b
	local placeList = {}
	
	for k,v in pairs(ProfessionsBook_TradeItemList) do
		a, b, _ = self:ParseTradeItem(v)
		if b ~= 0 then
			placeList = self:AddToTradeItemPlaceList(b, placeList)
		end
	end
	return placeList
end

function ProfessionsBook:GetTradeItemType(playerName, tradeSkillName, headerID, tradeItemID)
	local tradeItemType
	
	if playerName == nil then
		self:DebugPrint("GetTradeItemType(): playerName is nil ")
	end	
	if tradeSkillName == nil then
		self:DebugPrint("GetTradeItemType(): tradeSkillName is nil ")
	end	
	if headerID == nil then
		self:DebugPrint("GetTradeItemType(): headerID is nil ")
	end	
	if tradeItemID == nil then
		self:DebugPrint("GetTradeItemType(): tradeItemID is nil ")
	end		
	tradeItemType = self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[tostring(headerID)].tradeItems[tostring(tradeItemID)].tradeItemType
	if tradeItemType == nil then
		self:DebugPrint("GetTradeItemType(): tradeItemType is nil ")
	end	
	return tradeItemType
end

function ProfessionsBook:GetCharTradeItemID(playerName, tradeSkillName, headerID, recipeItemID)
	local tradeItemID
	
	if playerName == nil then
		self:DebugPrint("GetCharTradeItemID(): playerName is nil ")
	end	
	if tradeSkillName == nil then
		self:DebugPrint("GetCharTradeItemID(): tradeSkillName is nil ")
	end	
	if tradeSkillName == L["Enchanting"] then
		headerID = 1
	end
	if headerID == nil then
		self:DebugPrint("GetCharTradeItemID(): headerID is nil ")
	end	
	if recipeItemID == nil then
		self:DebugPrint("GetCharTradeItemID(): recipeItemID is nil ")
	end	
	if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers ~= nil then
		if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[tostring(headerID)].tradeItems ~= nil then
			for k,v in pairs(self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[tostring(headerID)].tradeItems) do
				if v.recipeID == recipeItemID then
					return tonumber(k)
				end
			end
		end
	end
	return -1
end

function ProfessionsBook:GetRecipeIDList(playerName, tradeSkillName)
	local k1,v1, k2, v2
	local resultList = {}

	if playerName == nil then
		self:DebugPrint("GetRecipeIDList(): playerName is nil ")
	end	
	if tradeSkillName == nil then
		self:DebugPrint("GetRecipeIDList(): tradeSkillName is nil ")
	end		
	if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers ~= nil then
		for k,v in pairs(self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers) do
			for k2,v2 in pairs(self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[tostring(k)].tradeItems) do
				table.insert(resultList, v2.recipeID)
			end
		end
	end
	return resultList
end

function ProfessionsBook:GetRecipeName(id)
	local recipeName
	
	if id == nil then
		self:DebugPrint("GetRecipeName(): id is nil ")
	end	
	recipeName = ProfessionsBook.db.account.recipes[tostring(id)].recipeName
	if recipeName == nil then
		self:DebugPrint("GetRecipeIDList(): recipeName is nil ")
	end	
	return recipeName
end

function ProfessionsBook:GetRecipeProducedItemCount(id)
	local itemCount
	
	if id == nil then
		self:DebugPrint("GetRecipeName(): id is nil ")
	end	
	itemCount = ProfessionsBook.db.account.recipes[tostring(id)].recipeItemCount
	if itemCount == nil then
		self:DebugPrint("GetRecipeProducedItemCount(): itemCount is nil ")
	end	
	return itemCount
end

function ProfessionsBook:GetRecipeLink(id)
	local recipeLink

	if id == nil then
		self:DebugPrint("GetRecipeLink(): id is nil ")
	end	
	recipeLink = ProfessionsBook.db.account.recipes[tostring(id)].recipeLink
	if recipeLink == nil then
		self:DebugPrint("GetRecipeLink(): recipeLink is nil ")
	end		
	return recipeLink
end

function ProfessionsBook:GetRecipeTool(id)
	local recipeTool
	
	if id == nil then
		self:DebugPrint("GetRecipeTool(): id is nil ")
	end	
	recipeTool = ProfessionsBook.db.account.recipes[tostring(id)].recipeTool
	if recipeTool == nil then
		self:DebugPrint("GetRecipeTool(): recipeTool is nil ")
	end		
	return recipeTool
end

function ProfessionsBook:GetRecipeRecipeLink(id)
	local recipeRecipeLink
	
	if id == nil then
		self:DebugPrint("GetRecipeRecipeLink(): id is nil ")
	end	
	recipeRecipeLink = ProfessionsBook.db.account.recipes[tostring(id)].recipeRecipeLink
	if recipeRecipeLink == nil then
		self:DebugPrint("GetRecipeRecipeLink(): recipeRecipeLink is nil ")
	end	
	return recipeRecipeLink
end

function ProfessionsBook:GetTradeItemID(name)
	local a, b, s1, s2

	if name == nil then
		self:DebugPrint("GetTradeItemID(): name is nil ")
	end	
	if ProfessionsBook.db.account.recipes ~= nil then
		for k,v in pairs(ProfessionsBook.db.account.recipes) do
			-- Exact pattern matching, works for most recipes
			if name == v.recipeName then
				return k
			end
			-- Check exceptions
			if (name ~= nil) and (v.recipeName ~= nil) then
				if ProfessionsBook_Exceptions[string.lower(v.recipeName)] == string.lower(name) then
					return k
				end
			end
		end
	end
	return -1
end


function ProfessionsBook:ParseTradeItem(value)
	local a, b, c, i, j

	if value == nil then
		self:DebugPrint("ParseTradeItem(): value is nil ")
	end		
	i, _ = string.find(value, "-")
	j, _ = string.find(value, "+")
	a = string.sub(value, 1, i - 1)
	b = string.sub(value, i + 1, j - 1)
	c = string.sub(value, j + 1)
	return tonumber(a), tonumber(b), tonumber(c)
end

function ProfessionsBook:GetReagentList(id)
	local k,v,i
	local reagentList = {}

	if id == nil then
		self:DebugPrint("GetReagentList(): id is nil ")
	end		
	i = 1
	if ProfessionsBook.db.account.recipes[tostring(id)].reagents ~= nil then
		for k,v in pairs(ProfessionsBook.db.account.recipes[tostring(id)].reagents) do
			table.insert(reagentList, tostring(i))
			i = i + 1
		end
	end
	return reagentList;
end

function ProfessionsBook:GetReagentCount(recipeId, reagentID)
	local reagentCount
	
	if recipeId == nil then
		self:DebugPrint("GetReagentCount(): recipeId is nil ")
	end	
	if reagentID == nil then
		self:DebugPrint("GetReagentCount(): reagentID is nil ")
	end	
	reagentCount = ProfessionsBook.db.account.recipes[tostring(recipeId)].reagents[tostring(reagentID)].reagentItemCount
	if reagentCount == nil then
		self:DebugPrint("GetReagentCount(): reagentCount is nil ")
	end		
	return reagentCount
end

function ProfessionsBook:GetReagentName(recipeId, reagentID)
	local reagentName
	
	if recipeId == nil then
		self:DebugPrint("GetReagentName(): recipeId is nil ")
	end	
	if reagentID == nil then
		self:DebugPrint("GetReagentName(): reagentID is nil ")
	end	
	reagentName = ProfessionsBook.db.account.recipes[tostring(recipeId)].reagents[tostring(reagentID)].reagentItemName
	if reagentName == nil then
		self:DebugPrint("GetReagentName(): reagentName is nil ")
	end	
	return reagentName
end

function ProfessionsBook:GetReagentLink(recipeId, reagentID)
	local reagentLink
	
	if recipeId == nil then
		self:DebugPrint("GetReagentLink(): recipeId is nil ")
	end	
	if reagentID == nil then
		self:DebugPrint("GetReagentLink(): reagentID is nil ")
	end	
	reagentLink = ProfessionsBook.db.account.recipes[tostring(recipeId)].reagents[tostring(reagentID)].reagentItemLink
	if reagentLink == nil then
		self:DebugPrint("GetReagentLink(): reagentLink is nil ")
	end	
	return reagentLink
end

function ProfessionsBook:Search(arg)
	local k1,v1,k2,v2,k3,v3, k4, v4, k5, v5, s, e, vr, kr
	local playerName, tradeSkillName, headerID, recipeID

	if arg == nil then
		self:DebugPrint("Search(): arg is nil ")
	end		
	ProfessionsBook_SeachResult = {}
	-- Find recipes
	if ProfessionsBook_SearchType == 0 then
		if ProfessionsBook.db.account.recipes ~= nil then
			for k1,v1 in pairs(ProfessionsBook.db.account.recipes) do
				recipeID = k1
				if v1.recipeName ~= nil then
					s, e = string.find(string.lower(v1.recipeName), string.lower(arg))
					if  (s ~= nil) and (s ~="") then
						-- Browse chars
						if self.db.realm.chars ~= nil then
							for k2,v2 in pairs(self.db.realm.chars) do
								playerName = k2
								-- Browse trade skills
								if self.db.realm.chars[playerName].tradeSkills ~= nil then
									for k3,v3 in pairs(self.db.realm.chars[playerName].tradeSkills) do
										tradeSkillName = k3
										-- Browse headers
										if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers ~= nil then
											for k4,v4 in pairs(self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers) do
												headerID = k4
												-- Browse trade items
												if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[headerID].tradeItems ~= nil then
													for k5,v5 in pairs(self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[headerID].tradeItems) do
														if recipeID == tostring(v5.recipeID) then
															searchElement = {}
															searchElement.charName = playerName
															searchElement.tradeSkill = tradeSkillName
															searchElement.id = recipeID
															searchElement.tradeItemName = v1.recipeName
															table.insert(ProfessionsBook_SeachResult, searchElement)
														end
													end
												end
											end
										end
									end
								end
							end
						end
					end
				end
			end	
		end
	else
		if ProfessionsBook.db.account.recipes ~= nil then
			for k1,v1 in pairs(ProfessionsBook.db.account.recipes) do
				recipeID = k1
				if ProfessionsBook.db.account.recipes[tostring(k1)].reagents ~= nil then
					for kr, vr in pairs(ProfessionsBook.db.account.recipes[tostring(k1)].reagents) do
						if vr.reagentItemName ~= nil then
							s, e = string.find(string.lower(vr.reagentItemName), string.lower(arg))
							if  (s ~= nil) and (s ~="") then
								-- Browse chars
								if self.db.realm.chars ~= nil then
									for k2,v2 in pairs(self.db.realm.chars) do
										playerName = k2
										-- Browse trade skills
										if self.db.realm.chars[playerName].tradeSkills ~= nil then
											for k3,v3 in pairs(self.db.realm.chars[playerName].tradeSkills) do
												tradeSkillName = k3
												-- Browse headers
												if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers ~= nil then
													for k4,v4 in pairs(self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers) do
														headerID = k4
														-- Browse trade items
														if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[headerID].tradeItems ~= nil then
															for k5,v5 in pairs(self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[headerID].tradeItems) do
																if recipeID == tostring(v5.recipeID) then
																	searchElement = {}
																	searchElement.charName = playerName
																	searchElement.tradeSkill = tradeSkillName
																	searchElement.id = recipeID
																	searchElement.tradeItemName = v1.recipeName
																	table.insert(ProfessionsBook_SeachResult, searchElement)
																end
															end
														end
													end
												end
											end
										end
									end
								end
							end
						end
					end
				end
			end
		end
	end
	return table.getn(ProfessionsBook_SeachResult)
end



function ProfessionsBook:GetTradeItemCount(playerName, tradeSkillName) 
	local k1, v1, result

	if playerName == nil then
		self:DebugPrint("GetTradeItemCount(): playerName is nil ")
	end	
	if tradeSkillName == nil then
		self:DebugPrint("GetTradeItemCount(): tradeSkillName is nil ")
	end	
	result = 0
	if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers ~= nil then
		for k1, v1 in pairs(self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers) do
			result = result + 1
			if self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[k1].tradeItems ~= nil then
				for k2, v2 in pairs(self.db.realm.chars[playerName].tradeSkills[tradeSkillName].headers[k1].tradeItems) do
					result = result + 1
				end
			end
		end
	end
	return result
end

function ProfessionsBook:ClearDatabase()
	self:ResetDB("realm")
	HideUIPanel(ProfessionsBook_OptionsDialog)
	HideUIPanel(ProfessionsBook_Frame)
end

function ProfessionsBook:GetCharsKnowingRecipe(name, skillName)
	local id, realmName, faction
	local resultList = {}
	
	id = self:GetTradeItemID(name)
	realmName = GetRealmName()
	faction, _ = UnitFactionGroup("player")
	if self.db.account.recipes[tostring(id)].characters ~= nil then
		for k,v in pairs(self.db.account.recipes[tostring(id)].characters) do
			if (v.realm == realmName) and (v.faction == faction) then
				table.insert(resultList, k)
			end
		end
	end
	table.sort(resultList)
	return resultList
end

function ProfessionsBook:DeleteRecipeReference(playerName, tradeSkill, headerID, tradeItemID)
	self.db.realm.chars[playerName].tradeSkills[tradeSkill].headers[headerID].tradeItems[tradeItemID] = {}
end

function ProfessionsBook:DeleteRecipe(id)
	local key1, key2, key3, key4, value1, value2, value3, value4
	
	-- Delete all character references to recipe
	if self.db.realm.chars ~= nil then
		for key1, value1 in pairs(self.db.realm.chars) do
			if self.db.realm.chars[key1].tradeSkills ~= nil then
				for key2, value2 in pairs(self.db.realm.chars[key1].tradeSkills) do
					if self.db.realm.chars[key1].tradeSkills[key2].headers ~= nil then
						for key3, value3 in pairs(self.db.realm.chars[key1].tradeSkills[key2].headers) do
							if self.db.realm.chars[key1].tradeSkills[key2].headers[key3].tradeItems ~= nil then
								for key4, value4 in pairs(self.db.realm.chars[key1].tradeSkills[key2].headers[key3].tradeItems) do
									if id == value4.recipeID then
										self:DeleteRecipeReference(key1, key2, key3, key4)
									end
								end
							end
						end
					end
				end
			end
		end
	end
	self.db.account.recipes[tostring(id)] = {}
end

function ProfessionsBook:ValidateDB()
	local key, value, key2, value2
	local doDelete
	
	-- Validate recipes
	if self.db.account.recipes ~= nil then
		for key, value in pairs(self.db.account.recipes) do
			doDelete = false
			if key == "-1" then
				doDelete = true
			end
			if (value.recipeRecipeLink == "") or (value.recipeRecipeLink == nil) then
				doDelete = true
			end
			if (value.recipeName == "") or (value.recipeName == nil) then
				doDelete = true
			end		
			if (value.recipeLink == "") or (value.recipeLink == nil) then
				doDelete = true
			end			
			if (self.db.account.recipes[key] ~= nil) and (self.db.account.recipes[key].reagents ~= nil) then
				for key2, value2 in pairs(self.db.account.recipes[key].reagents) do
					if value2.reagentItemCount == nil then
						doDelete = true
					end
					if (value2.reagentItemName == "") or (value2.reagentItemName == nil) then
						doDelete = true
					end		
					if (value2.reagentItemLink == "") or (value2.reagentItemLink == nil) then
						doDelete = true
					end
				end
			end
			if doDelete == true then
				self:DeleteRecipe(tonumber(key))
			end
		end
	end
	-- Validate recipe references
	if self.db.realm.chars ~= nil then
		for key, value in pairs(self.db.realm.chars) do
			if self.db.realm.chars[key].tradeSkills ~= nil then
				for key2, value2 in pairs(self.db.realm.chars[key].tradeSkills) do
					if self.db.realm.chars[key].tradeSkills[key2].headers ~= nil then
						for key3, value3 in pairs(self.db.realm.chars[key].tradeSkills[key2].headers) do
							for key4, value4 in pairs(self.db.realm.chars[key].tradeSkills[key2].headers[key3].tradeItems) do
								doDelete = false
								if (value4.recipeID == -1) or  (value4.recipeID == nil)then
									doDelete = true
								end
								if (value4.tradeItemType == "") or  (value4.tradeItemType == nil)then
									doDelete = true
								end	
								if doDelete == true then
									self:DeleteRecipeReference(key, key2, key3, key4)
								end		
							end
						end
					end
				end
			end
		end
	end
	-- Validate tradeskills
	if self.db.realm.chars ~= nil then
		for key, value in pairs(self.db.realm.chars) do
			if self.db.realm.chars[key].tradeSkills ~=nil then
				for key2, value2 in pairs(self.db.realm.chars[key].tradeSkills) do
					if key2 == "UNKNOWN" then
						self.db.realm.chars[key].tradeSkills[key2] = {}
					end
				end
			end
		end
	end
end


