-- PriceEach version 2.2.0
-- update by Darkclaw of Hyjal
-- Released 1/12/07
-- Updated for 2.2  9/25/07

--[[
        I have come to find this to be an indispensable tool!
        and since it seems to have vanished from both of the main places I know of to look for the latest and greatest AddOn's 
        I had to figure out how to make it work again!

        Built from the apparently abandoned PriceEach version 0.02  
        Released 10/33/05
        by Hangar of Silvermoon
        "originally based off of code in ShowBid (which, unless updated for 1.8, probably doesn't work anymore)
        also, BIG thanks to the author of AuctionSort, for showing me how to make this work under 1.8 before the patch hit :)
        credit to other authors in the several functions"
--]]


PRICEEACH_VERSION="2.2.0";

-- Not sure why this needs to be 
local orig_AuctionFrameBrowse_Update;


-- When the AddOn loads...
function PriceEach_OnLoad(self)
    -- set locally scoped variables for info about this addon
	local name,title,notes,enabled,loadable,reason,security
	-- chop the version number off the title in the TOC file "## Title: PriceEach |cfffff19b x.x.x"
	-- set locally scoped variables for AddOn Info for Addon in the GetAddOnInfo() argument
	name,title,notes,enabled,loadable,reason,security = GetAddOnInfo("PriceEach");
	-- Register the game events neccesary for our functionality
	this:RegisterEvent("AUCTION_ITEM_LIST_UPDATE");
	this:RegisterEvent("VARIABLES_LOADED");
	-- save origianl AuctionFrameBrowse_Update() from original. Dependency: Blizzard_AuctionUI...
	orig_AuctionFrameBrowse_Update = AuctionFrameBrowse_Update;
	-- replace AuctionFrameBrowse_Update() with our PriceEach_AuctionFrameBrowse_Update() funtion, to patch into that tool. 
	-- this will then call on the original stored in orig_AuctionFrameBrowse_Update
	AuctionFrameBrowse_Update = PriceEach_AuctionFrameBrowse_Update;
	-- disply PriceEach is loaded in chat window
    local titleOnly = TextParse(title);
	DEFAULT_CHAT_FRAME:AddMessage(GREEN_FONT_COLOR_CODE..titleOnly[1].." |cfffff19b"..PRICEEACH_VERSION..GREEN_FONT_COLOR_CODE.." loaded"..FONT_COLOR_CODE_CLOSE);
	-- define PriceEach chat command  /pe.  Not sure how this works...
	SLASH_PRICEEACHSLASH1 = "/pe";
	SlashCmdList["PRICEEACHSLASH"] = PriceEach_Enable_ChatCommandHandler;
end


-- We need things to happen with chat , so define chat commands.
function PriceEach_Enable_ChatCommandHandler(text)
    -- take a string and return a table (array) with each word from the string in each entry
	local msg = TextParse(text); 
	-- set msg[1] string to all lowercase
	msg[1] = strlower(msg[1]);
	-- Check chat for PriceEach Chat commands
	if msg[1] == "warn" and msg[2] and tonumber(msg[2]) then
        -- read what number they entered
		warnThreshold = tonumber(msg[2]);
		DEFAULT_CHAT_FRAME:AddMessage(LIGHTYELLOW_FONT_COLOR_CODE.."PriceEach warning threshold is now set to: "..FONT_COLOR_CODE_CLOSE..HIGHLIGHT_FONT_COLOR_CODE..msg[2]..FONT_COLOR_CODE_CLOSE);
	elseif msg[1] == "warn" then
        -- in case they /pe warn before they've loaded the AH.
		SetPriceWarningThreshold();
		-- Display current setting 
		DEFAULT_CHAT_FRAME:AddMessage(LIGHTYELLOW_FONT_COLOR_CODE.."PriceEach warning threshold is currently set to: "..FONT_COLOR_CODE_CLOSE..HIGHLIGHT_FONT_COLOR_CODE..warnThreshold..FONT_COLOR_CODE_CLOSE);
	else
        -- Display error 
		DEFAULT_CHAT_FRAME:AddMessage(LIGHTYELLOW_FONT_COLOR_CODE.."PriceEach: Invalid option.  Please use: /pe warn [#], where # is the amount of gold you want to be warned if price each is greater than.  Omit the # for current threshold."..FONT_COLOR_CODE_CLOSE);
	end
end


function PriceEach_OnEvent(event, arg1, arg2, arg3)
    --******** I don't think this function is ever called...
    -- make sure a good value is coming from variables
	if (event == "VARIABLES_LOADED") then
		SetPriceWarningThreshold();
	end
end


function SetPriceWarningThreshold()
    -- if not set yet, then set the default warning threshold of 5
	if (warnThreshold == nil) then
		warnThreshold = 5;
		DEFAULT_CHAT_FRAME:AddMessage(LIGHTYELLOW_FONT_COLOR_CODE.."PriceEach warning threshold set to the default: "..FONT_COLOR_CODE_CLOSE..HIGHLIGHT_FONT_COLOR_CODE..warnThreshold..FONT_COLOR_CODE_CLOSE);
	end
end


function PriceEach_AuctionFrameBrowse_Update()
    -- set in case they haven't /pe warned yet or opened AH
	SetPriceWarningThreshold();
	-- FauxScrollFrame_GetOffset() Dependency: Blizzard_AuctionUI...
	local offset = FauxScrollFrame_GetOffset(BrowseScrollFrame);
	-- 
	local index;
	local button, buttonName;
	
	-- call the origianl orig_AuctionFrameBrowse_Update() Dependency: Blizzard_AuctionUI
	orig_AuctionFrameBrowse_Update();
	
	-- ok loop through the displayed Auction items (I believe this is only ever 8, so 1 thorough 8)
	for i=1, NUM_BROWSE_TO_DISPLAY do
	
		index = offset + i + (NUM_AUCTION_ITEMS_PER_PAGE * AuctionFrameBrowse.page);
		button = getglobal("BrowseButton"..i);
		buttonName = "BrowseButton"..i;
		
		-- asign local scope variables the values from GetAuctionItemInfo()
		local name, texture, count, quality, canUse, level, minBid, minIncrement, buyoutPrice, bidAmount, highBidder, owner =  GetAuctionItemInfo("list", offset + i);

		if (name ~= nil) then
			
			-- Retrieve a link string about one item in the current retrieved list of items from the Auction House. 
			local aiLink = GetAuctionItemLink("list", offset + i);
			
            -- TRACE aiLink --DEFAULT_CHAT_FRAME:AddMessage("TRACE: PriceEach variable aiLink "..aiLink);
            
            -- extract itemID from link string
	    	local aiItemID = findItemID(aiLink);
	    	
            -- TRACE aiItemID -- DEFAULT_CHAT_FRAME:AddMessage("TRACE: PriceEach aiItemID "..aiItemID);
            
	    	-- extract item info from Item ID
	    	local sName, sLink, iQuality, iLevel, iMinLevel, sType, sSubType, iStackCount, iEquipLoc, iTexture = GetItemInfo(aiItemID);
            
			if ( buyoutPrice > 0 and iStackCount > 1 )then
			
				itemName = getglobal(buttonName.."Name");
			
				local oldtext = itemName:GetText();
				local pereach = floor(buyoutPrice / count);
				local g,s,c = ConvertMoney(pereach);
				local gt,st,ct;
				local peText;
				
				-- sart PriceEach text with an opening <space><space>(
				peText = "  ("
				
				-- add the gold value to PriceEach text
				if (g > 0) then
					if (g >= warnThreshold) then -- 
						peText = peText..RED_FONT_COLOR_CODE..g.."g"..FONT_COLOR_CODE_CLOSE;
					else
						peText = peText..NORMAL_FONT_COLOR_CODE..g.."g"..FONT_COLOR_CODE_CLOSE;
					end
				end
				
				-- add the silver value to PriceEach text
				if (s > 0) then
                    -- insert space if gold in front.
					if (g > 0) then
						peText = peText.." ";
					end
					-- insert silver
					if (g >= warnThreshold) then
						peText = peText..GetHex(0.8,0.8,0.8)..s.."s"..FONT_COLOR_CODE_CLOSE;
					else
						peText = peText..GetHex(0.8,0.8,0.8)..s.."s"..FONT_COLOR_CODE_CLOSE;
					end
				end
				
				-- add the copper value to PriceEach text
				if (c > 0) then
                    -- insert space if silver or gold in front.
					if (g > 0) or (s > 0) then
						peText = peText.." ";
					end
					-- insert copper
					if (g >= warnThreshold) then
						peText = peText..GetHex(0.8,0.5,0.4)..c.."c"..FONT_COLOR_CODE_CLOSE;
					else
						peText = peText..GetHex(0.8,0.5,0.4)..c.."c"..FONT_COLOR_CODE_CLOSE;
					end
				end
				
				-- close PriceEach text with )
				peText = peText..")"
				
                -- append PriceEach text to old item name
				itemName:SetText(oldtext..peText);
				
			end -- if ( buyoutPrice > 0  and iStackCount > 1 ) then 

		end -- if (name ~= nil) then
		
	end -- for

end -- function


function findItemID(link)
	-- check if argument 'link' is a string
	if ( type(link) ~= 'string' ) then return end
	local i,j,itemID = string.find(link, "|Hitem:(%d+):");
	-- I'm not useing i or j but they are the first to values returned by string.find, they are the start and end char position... 
	-- ***  printable version of a link string
    -- printable = gsub(link, "\124", "\124\124"); -- 124 is pipe char |
    -- DEFAULT_CHAT_FRAME:AddMessage("Here's what it really looks like: \"" .. printable .. "\"");
    -- ***
	--[[   The numeric fields in the new 2.0 item link: 
        1: Item ID 
        2: Enchant ID (enchants, armor kits, etc) 
        3: Gem 
        4: Gem 
        5: Gem 
        6: Socket Bonus? 
        7: Random-suffix ID (of the boar, etc) 
        8: Server-resolved unique ID for this item 
    ]]
    -- posable full pattern  "|c%x+|Hitem:[-%d:]+|h%[.-%]|h|r" 
	
	return itemID; 
	
end


-- courtesy EnhTooltip:
function ConvertMoney(copper)

	if (copper == nil) then copper = 0; end
	
	local g = math.floor(copper / 10000);
	local s = math.floor((copper - (g*10000)) / 100);
	local c = math.floor(copper - (g*10000) - (s*100));
	
	return g,s,c;
	
end


-- courtesy watchdog:
function GetHex(r,g,b)

	local TehHaxx0r;

	if g then
		return string.format( "|cFF%02X%02X%02X", (255*r), (255*g), (255*b) );
	elseif r then
		return string.format( "|cFF%02X%02X%02X", (255*r.r), (255*r.g), (255*r.b) );
	else
		return "";
	end

end


-- Text Parsing. Yay!
function TextParse(InputString)
--[[ By FERNANDO!
	This function should take a string and return a table with each word from the string in
	each entry. IE, "Linoleum is teh awesome" returns {"Linoleum", "is", "teh", "awesome"}
	Some good should come of this, I've been avoiding writing a text parser for a while, and
	I need one I understand completely. ^_^

	If you want to gank this function and use it for whatever, feel free. Just give me props
	somewhere. This function, as far as I can tell, is fairly foolproof. It's hard to get it
	to screw up. It's also completely self-contained. Just cut and paste.]]
   local Text = InputString;
   local TextLength = 1;
   local OutputTable = {};
   local OTIndex = 1;
   local StartAt = 1;
   local StopAt = 1;
   local TextStart = 1;
   local TextStop = 1;
   local TextRemaining = 1;
   local NextSpace = 1;
   local Chunk = "";
   local Iterations = 1;
   local EarlyError = false;

   if ((Text ~= nil) and (Text ~= "")) then
   -- ... Yeah. I'm not even going to begin without checking to make sure Im not getting
   -- invalid data. The big ol crashes I got with my color functions taught me that. ^_^

      -- First, it's time to strip out any extra spaces, ie any more than ONE space at a time.
      while (string.find(Text, "  ") ~= nil) do
         Text = string.gsub(Text, "  ", " ");
      end

      -- Now, what if text consisted of only spaces, for some ungodly reason? Well...
      if (string.len(Text) <= 1) then
         EarlyError = true;
      end

      -- Now, if there is a leading or trailing space, we nix them.
      if EarlyError ~= true then
        TextStart = 1;
        TextStop = string.len(Text);

        if (string.sub(Text, TextStart, TextStart) == " ") then
           TextStart = TextStart+1;
        end

        if (string.sub(Text, TextStop, TextStop) == " ") then
           TextStop = TextStop-1;
        end

        Text = string.sub(Text, TextStart, TextStop);
      end

      -- Finally, on to breaking up the string.

      OTIndex = 1;
      TextRemaining = string.len(Text);

      while (StartAt <= TextRemaining) and (EarlyError ~= true) do

         -- NextSpace is the index of the next space in the string...
         NextSpace = string.find(Text, " ",StartAt);
         -- if there isn't another space, then StopAt is the length of the rest of the
         -- string, otherwise it's just before the next space...
         if (NextSpace ~= nil) then
            StopAt = (NextSpace - 1);
         else
            StopAt = string.len(Text);
            LetsEnd = true;
         end

         Chunk = string.sub(Text, StartAt, StopAt);
         OutputTable[OTIndex] = Chunk;
         OTIndex = OTIndex + 1;

         StartAt = StopAt + 2;

      end
   else
      OutputTable[1] = "Error: Bad value passed to TextParse!";
   end

   if (EarlyError ~= true) then
      return OutputTable;
   else
      return {"Error: Bad value passed to TextParse!"};
   end
   
end