function PD:UpdateValues()

	if self.db.char.damtype == "Arcane Damage" then
		dt = GetSpellBonusDamage(7);

	elseif self.db.char.damtype == "Attack Power" then
		local base, posBuff, negBuff = UnitAttackPower("player");
		dt = base + posBuff + negBuff;

	elseif self.db.char.damtype == "Fire Damage" then
		dt = GetSpellBonusDamage(3);

	elseif self.db.char.damtype == "Frost Damage" then
		dt = GetSpellBonusDamage(5);

	elseif self.db.char.damtype == "Healing Power" then
		dt = GetSpellBonusHealing();

	elseif self.db.char.damtype == "Holy Damage" then
		dt = GetSpellBonusDamage(2);

	elseif self.db.char.damtype == "Nature Damage" then
		dt = GetSpellBonusDamage(4);

	elseif self.db.char.damtype == "Physical Damage" then
		dt = GetSpellBonusDamage(1);

	elseif self.db.char.damtype == "Ranged AP" then
		local base, posBuff, negBuff = UnitRangedAttackPower("player");
		dt = base + posBuff + negBuff;

	elseif self.db.char.damtype == "Shadow Damage" then
		dt = GetSpellBonusDamage(6);

	elseif self.db.char.damtype == "Spell Damage" then
		local bonusDamage;
		local holySchool = 2;
		local minDamage = GetSpellBonusDamage(holySchool);
		this.bonusDamage = {};
		this.bonusDamage[holySchool] = minDamage;
		for i=(holySchool+1), 7 do
			bonusDamage = GetSpellBonusDamage(i);
			minDamage = min(minDamage, bonusDamage);
			this.bonusDamage[i] = bonusDamage;		
		end
		dt = minDamage;

	else
		dt = "Oops!";
		
	end
	
	damag:SetText( dt )
	
	if self.db.char.lines > 0 then 
		s1:SetText( self:UpdateStats(self.db.char.s1)..self:StatName(self.db.char.s1) )
	end
	
	if self.db.char.lines > 1 then
		s2:SetText( self:UpdateStats(self.db.char.s2)..self:StatName(self.db.char.s2) )
	end
	
	if self.db.char.lines > 2 then
		s3:SetText( self:UpdateStats(self.db.char.s3)..self:StatName(self.db.char.s3) )
	end
	
	if self.db.char.lines > 3 then
		s4:SetText( self:UpdateStats(self.db.char.s4)..self:StatName(self.db.char.s4) )
	end
	
	if self.db.char.lines > 4 then
		s5:SetText( self:UpdateStats(self.db.char.s5)..self:StatName(self.db.char.s5) )
	end
end

function PD:UpdateStats(line)
	if line == "Arcane Resistance" then
		_,var,_,_ = UnitResistance("player",6);

	elseif line == "Armor" then
		_,var,_,_ = UnitResistance("player",0);

	elseif line == "% Block" then
		var = format("%.2f", GetBlockChance());

	elseif line == "Dodge" then
		var = format("%.2f", GetDodgeChance());

	elseif line == "Ranged Attack Speed" then
		local rangedAttackSpeed, _, _, _, _, _ = UnitRangedDamage("player");
		var = format("%.2f", rangedAttackSpeed);

	elseif line == "Fire Resistance" then
		_,var,_,_ = UnitResistance("player",2);

	elseif line == "Frost Resistance" then
		_,var,_,_ = UnitResistance("player",4);

	elseif line == "Holy Resistance" then
		_,var,_,_ = UnitResistance("player",1);

	elseif line == "Mainhand Attack Speed" then
		local speed, _ = UnitAttackSpeed("player");
		if not speed then
			speed = 0;
		end
		var = format("%.2f", speed);

	elseif line == "Mana" then
		var = UnitMana("player");

	elseif line == "% Melee Crit Chance" then
		var = format("%.2f", GetCritChance());

	elseif line == "Melee Haste Rating" then
		var = GetCombatRating(18);

	elseif line == "% Melee Haste Rating" then
		var = floor(GetCombatRatingBonus(18));

	elseif line == "Melee Hit Rating" then
		var = GetCombatRating(6);

	elseif line == "% Melee Hit Rating" then
		var = format("%.2f", GetCombatRatingBonus(6));

	elseif line == "MP5" then
		local base, casting = GetManaRegen();
		var = math.floor(base*5).."/"..math.floor(casting*5);

	elseif line == "Nature Resistance" then
		_,var,_,_ = UnitResistance("player",3);

	elseif line == "Offhand Attack Speed" then
		local _, speed = UnitAttackSpeed("player");
		if not speed then
			speed = 0;
		end
		var = format("%.2f", speed);

	elseif line == "% Parry" then
		var = format("%.2f", GetParryChance());

	elseif line == "% Ranged Crit Chance" then
		var = format("%.2f", GetRangedCritChance());

	elseif line == "Ranged Haste Rating" then
		var = GetCombatRating(19);

	elseif line == "% Ranged Haste Rating" then
		var = floor(GetCombatRatingBonus(19));

	elseif line == "Ranged Hit Rating" then
		var = GetCombatRating(7);

	elseif line == "% Ranged Hit Rating" then
		var = format("%.2f", GetCombatRatingBonus(7));

	elseif line == "Resilience" then
		local melee = GetCombatRating(CR_CRIT_TAKEN_MELEE);
		local ranged = GetCombatRating(CR_CRIT_TAKEN_RANGED);
		local spell = GetCombatRating(CR_CRIT_TAKEN_SPELL);
		local minResilience = min(melee, ranged);
		var = min(minResilience, spell);

	elseif line == "Shadow Resistance" then
		_,var,_,_ = UnitResistance("player",5);

	elseif line == "% Spell Crit Chance" then
		local spellCrit;
		local holySchool = 2;
		local minCrit = GetSpellCritChance(holySchool);
		this.spellCrit = {};
		this.spellCrit[holySchool] = minCrit;
		for i=(holySchool+1), 7 do
			spellCrit = GetSpellCritChance(i);
			minCrit = min(minCrit, spellCrit);
			this.spellCrit[i] = spellCrit;		
		end
		var = format("%.2f", minCrit);

	elseif line == "Spell Haste Rating" then
		var = GetCombatRating(20);

	elseif line == "% Spell Haste Rating" then
		var = floor(GetCombatRatingBonus(20));

	elseif line == "Spell Hit Rating" then
		var = GetCombatRating(8);

	elseif line == "% Spell Hit Rating" then
		var = format("%.2f", GetCombatRatingBonus(8));

	elseif line == "Mainhand Weapon Skill" then
		local Base, Mod, _, _ = UnitAttackBothHands("player");
		var = Base+Mod;

	elseif line == "Offhand Weapon Skill" then
		local _, _, base, Mod = UnitAttackBothHands("player");
		var = Base+Mod;

	else
		var = "Please update your";

	end
	return var;
end

function PD:UpdateText()
	typed:SetText( self.db.char.damtype );
end

function PD:StatName(line)
	if line then
		if not self.db.char.dogtag or self.db.char.dogtag == false then
			var = line;
		else

			if line == "Arcane Resistance" then var = "ArcRes";
			elseif line == "Armor" then var = "Arm";
			elseif line == "Ranged Attack Speed" then var = "AP";
			elseif line == "Fire Resistance" then var = "FiRes";
			elseif line == "Frost Resistance" then var = "FrRes";
			elseif line == "Holy Resistance" then var = "HRes";
			elseif line == "Mainhand Attack Speed" then var = "AP";
			elseif line == "% Melee Crit Chance" then var = "% Crit";
			elseif line == "Melee Haste Rating" then var = "Haste";
			elseif line == "% Melee Haste Rating" then var = "% Haste";
			elseif line == "Melee Hit Rating" then var = "Hit";
			elseif line == "% Melee Hit Rating" then var = "% Hit";
			elseif line == "MP5" then var = "Regen";
			elseif line == "Nature Resistance" then var = "NRes";
			elseif line == "Offhand Attack Speed" then var = "AP";
			elseif line == "% Ranged Crit Chance" then var = "% Crit";
			elseif line == "Ranged Haste Rating" then var = "Haste";
			elseif line == "% Ranged Haste Rating" then var = "% Haste";
			elseif line == "Ranged Hit Rating" then var = "Hit";
			elseif line == "% Ranged Hit Rating" then var = "% Hit";
			elseif line == "Resilience" then var = "Resi";
			elseif line == "Shadow Resistance" then var = "SRes";
			elseif line == "% Spell Crit Chance" then var = "% Crit";
			elseif line == "Spell Haste Rating" then var = "Haste";
			elseif line == "% Spell Haste Rating" then var = "% Haste";
			elseif line == "Spell Hit Rating" then var = "Hit";
			elseif line == "% Spell Hit Rating" then var = "% Hit";
			elseif line == "Mainhand Weapon Skill" then var = "W.Skill";
			elseif line == "Offhand Weapon Skill" then var = "W.Skill";
			elseif line == "Mana" then
				if UnitPowerType("player") == 1 then var = "Rage";
				elseif UnitPowerType("player") == 3 then var = "Energy";
				else var = "Mana";
				end
			end

		end

	else
		var = "Please update your settings!";
	end
	
	if not var:find("^%%") then
		var = " "..var;
	end
	return var;
end
