function PD:LoadOptions()
	local SharedMedia = LibStub and LibStub:GetLibrary("LibSharedMedia-2.0", true);
	local Dewdrop = AceLibrary:HasInstance("Dewdrop-2.0") and AceLibrary("Dewdrop-2.0");
	local Waterfall = AceLibrary:HasInstance("Waterfall-1.0") and AceLibrary("Waterfall-1.0");

	self.options = {
		type = "group",
		args = {
			display = {
				name = PD.L["Display"], desc = PD.L["Miscellaneous display options"], type = "group", order = 1,
				args = {
					damtype = {
						name = PD.L["Type"], desc = PD.L["What do you want to watch"], type = "text", order = 1,
						validate = self:TypeList(),
						get = function() return PD.db.char.damtype end,
						set = function(v)
							PD.db.char.damtype = v;
							self:UpdateText();
						end
					},
					lines = {
						name = PD.L["Stat lines"], desc = PD.L["Amount of stats you want"], type = "range", order = 2,
						min = 0, max = 5, step = 1, bigStep = 1,
						get = function() return PD.db.char.lines end,
						set = function(v)
							PD.db.char.lines = v;
							s1:SetText(); s2:SetText(); s3:SetText(); s4:SetText(); s5:SetText();
							self:StatOptions();
						end
					},
					dogtag = {
						name = PD.L["Dogtag"], desc = PD.L["Check if you want dogtags to be used"], type = "toggle", order = 8,
						get = function() return PD.db.char.dogtag end,
						set = function(v)
							PD.db.char.dogtag = v;
							self:StatOptions();
						end
					},
					lock = {
						name = PD.L["Lock"], desc = PD.L["Toggle the lock of the frame"], type = "toggle", order = 9,
						get = function() return PD.db.char.locked end,
						set = function(v)
							PD.db.char.locked = v;
							self:Drag();
						end
					},
					resetwin = {
						name = PD.L["Reset position"], desc = PD.L["Reset the PowerDisplay frame"], type = "execute", order = 10,
						func = function(v)
							PD.db.char.pos = "CENTER";
							PD.db.char.rpos = "CENTER";
							PD.db.char.posX = 0;
							PD.db.char.posY = 0;
							self:UpdatePosition();
						end
					},
				}
			},
			layout = {
				name = PD.L["Layout"], desc = PD.L["Various layout options"], type = "group", order = 2,
				args = {
					damagcolor = {
						name = PD.L["Damage color"], desc = PD.L["Color for the damage amount"], type = "color", order = 1,
						get = function()
							return PD.db.char.colorDamag.r, PD.db.char.colorDamag.g, PD.db.char.colorDamag.b;
						end,
						set = function(r, g, b)
							PD.db.char.colorDamag.r, PD.db.char.colorDamag.g, PD.db.char.colorDamag.b = r, g, b;
							self:UpdateColors();
						end,
					},
					damagsize = {
						name = PD.L["Damage size"], desc = PD.L["Font size for the damage"], type = "range", order = 2,
						min = 8, max = 50, step = 1, bigStep = 4,
						get = function() return PD.db.char.fontSizeDamag end,
						set = function(v)
							PD.db.char.fontSizeDamag = v;
							self:UpdateFonts();
							self:UpdatePosition();
						end
					},
					typedcolor = {
						name = PD.L["Type"], desc = PD.L["Color for the damage type"], type = "color", order = 3,
						get = function()
							return PD.db.char.colorTyped.r, PD.db.char.colorTyped.g, PD.db.char.colorTyped.b;
						end,
						set = function(r, g, b)
							PD.db.char.colorTyped.r, PD.db.char.colorTyped.g, PD.db.char.colorTyped.b = r, g, b;
							self:UpdateColors();
						end,
					},
					typedsize = {
						name = PD.L["Type size"], desc = PD.L["Font size for the type"], type = "range", order = 4,
						min = 0, max = 32, step = 1, bigStep = 3,
						get = function() return PD.db.char.fontSizeTyped end,
						set = function(v)
							PD.db.char.fontSizeTyped = v;
							self:UpdateFonts();
							self:UpdatePosition();
						end
					},					
					statscolor = {
						name = PD.L["Stats"], desc = PD.L["Color for the stats"], type = "color", order = 5,
						get = function()
							return PD.db.char.colorStats.r, PD.db.char.colorStats.g, PD.db.char.colorStats.b;
						end,
						set = function(r, g, b)
							PD.db.char.colorStats.r, PD.db.char.colorStats.g, PD.db.char.colorStats.b = r, g, b;
							self:UpdateColors();
						end,
					},
					statssize = {
						name = PD.L["Stats size"], desc = PD.L["Font size for the stats"], type = "range", order = 6,
						min = 4, max = 28, step = 1, bigStep = 2,
						get = function() return PD.db.char.fontSizeStats end,
						set = function(v)
							PD.db.char.fontSizeStats = v;
							self:UpdateFonts();
							self:UpdatePosition();
						end
					},
					align = {
						name = PD.L["Horizontal alignment"], desc = PD.L["The horizontal alignment of the text."], type = "text", order = 7,
						validate = {
							["CENTER"] = PD.L["Center"],
							["LEFT"] = PD.L["Left"],
							["RIGHT"] = PD.L["Right"]
						},
						get = function() return PD.db.char.align end,
						set = function(v)
							PD.db.char.align = v;
							self:UpdatePosition();
						end
					},
					outline = {
						name = PD.L["Outline"], desc = PD.L["Show an outline around the text"], type = "text", order = 8,
						validate = {
							["NONE"] = PD.L["None"],
							["OUTLINE"] = PD.L["Thin"],
							["THICKOUTLINE"] = PD.L["Thick"]
						},
						get = function() return PD.db.char.fontOutline end,
						set = function(v)
							PD.db.char.fontOutline = v;
							self:UpdateFonts();
						end
					},
					shadow = {
						name = PD.L["Shadow"], desc = PD.L["Show a shadow on the text"], type = "toggle", order = 9,
						get = function() return PD.db.char.fontShadow end,
						set = function(v)
							PD.db.char.fontShadow = v;
							self:UpdateFonts();
						end
					},
					linespace = {
						name = PD.L["Line spacing"], desc = PD.L["Control the space between the lines"], type = "range", order = 10,
						min = -2, max = 2, step = 0.1, bigStep = 0.1,
						get = function() return PD.db.char.linespace end,
						set = function(v)
							PD.db.char.linespace = v;
							self:UpdateFonts();
							self:UpdatePosition();
						end
					},
				}
			},
		}
	}
	
	self:StatOptions();
	self:RegisterChatCommand("/powerd", self.options, "PD");

	if SharedMedia then
		self.options.args.layout.args.face = {
			name = PD.L["Typeface"], desc = PD.L["Typeface to use"], type = "text", order = 7,
			validate = SharedMedia:List("font"),
			get = function() return PD.db.char.fontFace end,
			set = function(v)
				PD.db.char.fontFace = v;
				self:UpdateFonts();
			end
		}
	end

	if Dewdrop then
		self.options.args.menu = {
			name = PD.L["Dropdown Menu"], desc = PD.L["Open a dropdown configuration menu"], type = "execute",
			guiHidden = true, wfHidden = true,
			func = function() Dewdrop:Open("PD", "children", function() Dewdrop:FeedAceOptionsTable(self.options) end) end
		}
	end

	if Waterfall then
		Waterfall:Register("PD", "aceOptions", self.options, "title", "PD", "treeLevels", 2, "colorR", 0.0, "colorG", 0.86, "colorB", 0.73)
		self.options.args.options = {
			name = PD.L["GUI Menu"], desc = PD.L["Open a GUI configuration window"], type = "execute",
			guiHidden = true, wfHidden = true,
			func = function() Waterfall:Open("PD") end
		}
	end
end

function PD:TypeList()
	local list = {
		["Arcane Damage"] = PD.L["Arcane Damage"],
		["Fire Damage"] = PD.L["Fire Damage"],
		["Frost Damage"] = PD.L["Frost Damage"],
		["Healing Power"] = PD.L["Healing Power"],
		["Holy Damage"] = PD.L["Holy Damage"],
		["Attack Power"] = PD.L["Melee Attack Power"],
		["Nature Damage"] = PD.L["Nature Damage"],
		["Physical Damage"] = PD.L["Physical Damage"],
		["Ranged AP"] = PD.L["Ranged Attack Power"],
		["Shadow Damage"] = PD.L["Shadow Damage"],
		["Spell Damage"] = PD.L["Spell Damage"],
	}
	return list;
end

function PD:StatList() 
	local list = {
		["Arcane Resistance"] = PD.L["Arcane Resistance"],
		["Armor"] = PD.L["Armor"],
		["% Block"] = PD.L["Block Chance"],
		["% Dodge"] = PD.L["Dodge Chance"],
		["Fire Resistance"] = PD.L["Fire Resistance"],
		["Frost Resistance"] = PD.L["Frost Resistance"],
		["Holy Resistance"] = PD.L["Holy Resistance"],
		["Mainhand Attack Speed"] = PD.L["Mainhand Attack Speed"],
		["Mainhand Weapon Skill"] = PD.L["Mainhand Weapon Skill"],
		["Mana"] = PD.L["Mana, Rage or Energy"],
		["MP5"] = PD.L["Mana Regeneration"],
		["% Melee Crit Chance"] = PD.L["Melee Crit Chance"],
		["Melee Haste"] = PD.L["Melee Haste Rating"],
		["% Melee Haste"] = PD.L["Melee Haste Rating (percentage)"],
		["Melee Hit Rating"] = PD.L["Melee Hit Rating"],
		["% Melee Hit Rating"] = PD.L["Melee Hit Rating (percentage)"],
		["Nature Resistance"] = PD.L["Nature Resistance"],
		["Offhand Attack Speed"] = PD.L["Offhand Attack Speed"],
		["Offhand Weapon Skill"] = PD.L["Offhand Weapon Skill"],
		["% Parry"] = PD.L["Parry Chance"],
		["Ranged Attack Speed"] = PD.L["Ranged Attack Speed"],
		["% Ranged Crit Chance"] = PD.L["Ranged Crit Chance"],
		["Ranged Haste Rating"] = PD.L["Ranged Haste Rating"],
		["% Ranged Haste Rating"] = PD.L["Ranged Haste Rating (percentage)"],
		["Ranged Hit Rating"] = PD.L["Ranged Hit Rating"],
		["% Ranged Hit Rating"] = PD.L["Ranged Hit Rating (percentage)"],
		["Resilience"] = PD.L["Resilience"],
		["Shadow Resistance"] = PD.L["Shadow Resistance"],
		["% Spell Crit Chance"] = PD.L["Spell Crit Chance"],
		["Spell Haste Rating"] = PD.L["Spell Haste Rating"],
		["% Spell Haste Rating"] = PD.L["Spell Haste Rating (percentage)"],
		["Spell Hit Rating"] = PD.L["Spell Hit Rating"],
		["% Spell Hit Rating"] = PD.L["Spell Hit Rating (percentage)"]
	}
	return list;
end

function PD:StatOptions()
	if self.db.char.lines > 0 then
		self.options.args.display.args.s1type = {
			name = PD.L["Stat 1"], desc = PD.L["Choose first stat"], type = "text", order = 3,
			validate = self:StatList(),
			get = function() return PD.db.char.s1 end,
			set = function(v)
				PD.db.char.s1 = v;
			end
		}
	else
		self.options.args.display.args.s1type = nil;
	end
	
	if self.db.char.lines > 1 then
		self.options.args.display.args.s2type = {
			name = PD.L["Stat 2"], desc = PD.L["Choose second stat"], type = "text", order = 4,
			validate = self:StatList(),
			get = function() return PD.db.char.s2 end,
			set = function(v)
				PD.db.char.s2 = v;
			end
		}
	else
		self.options.args.display.args.s2type = nil;
	end

	if self.db.char.lines > 2 then
		self.options.args.display.args.s3type = {
			name = PD.L["Stat 3"], desc = PD.L["Choose third stat"], type = "text", order = 5,
			validate = self:StatList(),
			get = function() return PD.db.char.s3 end,
			set = function(v)
				PD.db.char.s3 = v;
			end
		}
	else
		self.options.args.display.args.s3type = nil;
	end

	if self.db.char.lines > 3 then
		self.options.args.display.args.s4type = {
			name = PD.L["Stat 4"], desc = PD.L["Choose fourth stat"], type = "text", order = 6,
			validate = self:StatList(),
			get = function() return PD.db.char.s4 end,
			set = function(v)
				PD.db.char.s4 = v;
			end
		}
	else
		self.options.args.display.args.s4type = nil;
	end

	if self.db.char.lines > 4 then
	self.options.args.display.args.s5type = {
			name = PD.L["Stat 5"], desc = PD.L["Choose fifth stat"], type = "text", order = 7,
			validate = self:StatList(),
			get = function() return PD.db.char.s5 end,
			set = function(v)
				PD.db.char.s5 = v;
			end
		}
	else
		self.options.args.display.args.s5type = nil;
	end
end
