PD = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0");

if GetAddOnInfo("LibSharedMedia-2.0") then
	EnableAddOn("LibSharedMedia-2.0");
	LoadAddOn("LibSharedMedia-2.0");
end

local SharedMedia = LibStub and LibStub:GetLibrary("LibSharedMedia-2.0", true);
local L = setmetatable({}, { __index = function(self, key) rawset(self, key, key) return key end })
PD.L = L;

function PD:OnInitialize()
	self:RegisterDB("pddb", "pdcdb", "char");
	self:RegisterDefaults('profile', {
	})
	self:RegisterDefaults('char', {
		damtype = "Spell Damage",
		dogtag = false,
		lines = 2,
		align = "CENTER",
		linespace = 1,
		colorDamag = { r = 255/255, g = 255/255, b = 255/255, },
		colorTyped = { r = 255/255, g = 255/255, b = 255/255, },
		colorStats = { r = 255/255, g = 255/255, b = 255/255, },
		fontFace = "Friz Quadrata TT",
		fontSizeDamag = 32,
		fontSizeTyped = 16,
		fontSizeStats = 12,
		fontOutline = "NONE",
		pos = "CENTER",
		rpos = "CENTER",
		posX = 0,
		posY = 0,
		locked = false
	})
	self:LoadOptions();
end

function PD:UpdateColors()
	cd = self.db.char.colorDamag;
	damag:SetTextColor(cd.r, cd.g, cd.b);
	cd = self.db.char.colorTyped;
	typed:SetTextColor(cd.r, cd.g, cd.b);
	cd = self.db.char.colorStats;
	s1:SetTextColor(cd.r, cd.g, cd.b);
	s2:SetTextColor(cd.r, cd.g, cd.b);
	s3:SetTextColor(cd.r, cd.g, cd.b);
	s4:SetTextColor(cd.r, cd.g, cd.b);
	s5:SetTextColor(cd.r, cd.g, cd.b);
end

function PD:OnEnable()
	if not PD_Frame then
		pdframe = CreateFrame("frame", "PD_Frame", UIParent);
		pdframe:SetFrameStrata("BACKGROUND");
		pdframe:SetFrameLevel(0);
	
		damag = pdframe:CreateFontString("PD_Damag", "OVERLAY");
		typed = pdframe:CreateFontString("PD_Typed", "OVERLAY");
		s1 = pdframe:CreateFontString("PD_S1", "OVERLAY");
		s2 = pdframe:CreateFontString("PD_S2", "OVERLAY");
		s3 = pdframe:CreateFontString("PD_S3", "OVERLAY");
		s4 = pdframe:CreateFontString("PD_S4", "OVERLAY");
		s5 = pdframe:CreateFontString("PD_S5", "OVERLAY");
	
		self:UpdateFonts();
		self:UpdateColors();
		self:UpdatePosition();
		self:Drag();
	end
	pdframe:Show();
	self:ScheduleRepeatingEvent(self.UpdateValues, 0.2, self);
end

function PD:Drag()
	if not self.db.char.locked then
		pdframe:SetMovable(true);
		pdframe:EnableMouse(true);
		pdframe:RegisterForDrag("LeftButton");
		pdframe:SetScript("OnDragStart", function(this) if IsAltKeyDown() then this:StartMoving() end end);
		pdframe:SetScript("OnDragStop", function(this)
			this:StopMovingOrSizing();
			local a,b,c,d,e = this:GetPoint();
			self.db.char.pos, self.db.char.rpos, self.db.char.posX, self.db.char.posY = a, c, floor(d + 0.5), floor(e + 0.5);
		end)
	else
		pdframe:SetMovable(false);
		pdframe:EnableMouse(false);
	end
end

function PD:OnDisable()
	PD_Damag:SetText();
	PD_Typed:SetText();
	PD_S1:SetText();
	PD_S2:SetText();
	PD_S3:SetText();
	PD_S4:SetText();
	PD_S5:SetText();
	PD_Frame:Hide();
end
