function PD:UpdatePosition()
	a = self.db.char.pos;
	x = a:find("RIGHT") and -self.db.char.posX or self.db.char.posX;
	y = a:find("TOP") and -self.db.char.posY or self.db.char.posY;
	h = self.db.char.align or "CENTER";

	pdframe:ClearAllPoints();
	pdframe:SetPoint(a, UIParent, self.db.char.rpos, self.db.char.posX, self.db.char.posY);

	if h == "LEFT" then
		p1 = "TOPLEFT";
	elseif h == "RIGHT" then
		p1 = "TOPRIGHT";
	else
		p1 = "TOP";
	end
	
	damag:SetPoint(p1, pdframe, p1, 0, 0);
	damag:SetJustifyH(h);
	typed:SetPoint(p1, damag, p1, 0, -self.db.char.fontSizeDamag*self.db.char.linespace);
	typed:SetJustifyH(h);
	s1:SetPoint(p1, typed, p1, 0, -self.db.char.fontSizeTyped*self.db.char.linespace);
	s1:SetJustifyH(h);
	s2:SetPoint(p1, s1, p1, 0, 0-self.db.char.fontSizeStats*self.db.char.linespace);
	s2:SetJustifyH(h);
	s3:SetPoint(p1, s2, p1, 0, 0-self.db.char.fontSizeStats*self.db.char.linespace);
	s3:SetJustifyH(h);
	s4:SetPoint(p1, s3, p1, 0, 0-self.db.char.fontSizeStats*self.db.char.linespace);
	s4:SetJustifyH(h);
	s5:SetPoint(p1, s4, p1, 0, 0-self.db.char.fontSizeStats*self.db.char.linespace);
	s5:SetJustifyH(h);
end

function PD:UpdateFonts()
	local SharedMedia = LibStub and LibStub:GetLibrary("LibSharedMedia-2.0", true)
	t = SharedMedia and SharedMedia:Fetch("font", self.db.char.fontFace) or "Fonts\\FRIZQT__.ttf";
	damag:SetFont(t, self.db.char.fontSizeDamag, self.db.char.fontOutline);
	typed:SetFont(t, self.db.char.fontSizeTyped, self.db.char.fontOutline);
	s1:SetFont(t, self.db.char.fontSizeStats, self.db.char.fontOutline);
	s2:SetFont(t, self.db.char.fontSizeStats, self.db.char.fontOutline);
	s3:SetFont(t, self.db.char.fontSizeStats, self.db.char.fontOutline);
	s4:SetFont(t, self.db.char.fontSizeStats, self.db.char.fontOutline);
	s5:SetFont(t, self.db.char.fontSizeStats, self.db.char.fontOutline);

	if self.db.char.fontShadow then
		damag:SetShadowOffset(1, -1);
		typed:SetShadowOffset(1, -1);
		s1:SetShadowOffset(1, -1);
		s2:SetShadowOffset(1, -1);
		s3:SetShadowOffset(1, -1);
		s4:SetShadowOffset(1, -1);
		s5:SetShadowOffset(1, -1);
	else
		damag:SetShadowOffset(0, 0);
		typed:SetShadowOffset(0, 0);
		s1:SetShadowOffset(0, 0);
		s2:SetShadowOffset(0, 0);
		s3:SetShadowOffset(0, 0);
		s4:SetShadowOffset(0, 0);
		s5:SetShadowOffset(0, 0);
	end

	damag:SetText("1234");
	if self.db.char.fontSizeTyped > 0 then
		typed:SetText( self.db.char.damtype );
	else
		PD_S2:SetText();
	end
	s1:SetText("1337 Shadow resistance");
	pdframe:SetWidth(typed:GetWidth() > damag:GetWidth() and typed:GetWidth() or damag:GetWidth() or s1:GetWidth());
	pdframe:SetHeight((damag:GetHeight() + typed:GetHeight() + s1:GetHeight() + s2:GetHeight() + s3:GetHeight() + s4:GetHeight() + s5:GetHeight())*self.db.char.linespace);
end
