function PP_Calc()

  local sumBuyoutPrices = 0
  local sumBidPrices = 0
  local bid = 0
  local _,count = GetNumAuctionItems("owner");
  local rate = GetAuctionHouseDepositRate();
  if rate == 5 then rate = .95 else rate = .85 end
  if PP_SubtractAHCut == 0 then rate = 1 end
  
  for i = 1, count do 
  local _, _, _, _, _, _, minBid, _, buyoutPrice, bidAmount, _, _ = GetAuctionItemInfo("owner", i);
    sumBuyoutPrices = sumBuyoutPrices + floor((buyoutPrice*rate)+.5)
    if bidAmount == 0  then 
      bid = bid + floor((minBid*rate)+.5)
    else
      bid = bid + floor((bidAmount*rate)+.5)
    end
    sumBidPrices = sumBidPrices + bid
    bid = 0
  end
  if PP_ShowBO == 1 then
    if PP_ShowBid == 1 then
      PP_UMF( "PP_Buy_MoneyFrame", "/  Buyout:", sumBuyoutPrices)
    else
      PP_UMF( "PP_Buy_MoneyFrame", "Potential Profit - Buyout:", sumBuyoutPrices)
    end
  end
  
  if PP_ShowBid == 1 then
    PP_UMF( "PP_Bid_MoneyFrame", "Potential Profit - Bid:", sumBidPrices)
  end

end

function PP_CMF(frameName, nextTo)
	local frame = CreateFrame("Button",frameName,AuctionFrameAuctions)
	frame:SetPoint("RIGHT",nextTo,"LEFT",-5,0)
	frame:SetWidth(100)
	frame:SetHeight(18)

	local goldIcon = frame:CreateTexture(frameName.."GoldIcon", "ARTWORK")
	goldIcon:SetWidth(16)
	goldIcon:SetHeight(16)
	goldIcon:SetTexture("Interface\\MoneyFrame\\UI-MoneyIcons")
	goldIcon:SetTexCoord(0, 0.25, 0, 1)

	local silverIcon = frame:CreateTexture(frameName.."SilverIcon", "ARTWORK")
	silverIcon:SetWidth(16)
	silverIcon:SetHeight(16)
	silverIcon:SetTexture("Interface\\MoneyFrame\\UI-MoneyIcons")
	silverIcon:SetTexCoord(0.25, 0.5, 0, 1)

	local copperIcon = frame:CreateTexture(frameName.."CopperIcon", "ARTWORK")
	copperIcon:SetWidth(16)
	copperIcon:SetHeight(16)
	copperIcon:SetTexture("Interface\\MoneyFrame\\UI-MoneyIcons")
	copperIcon:SetTexCoord(0.5, 0.75, 0, 1)

	local goldText = frame:CreateFontString(frameName.."GoldText", "OVERLAY")
	goldText:SetJustifyH("RIGHT")
	goldText:SetPoint("RIGHT", goldIcon, "LEFT", 0, 0)
	goldText:SetFontObject(GameFontNormal)

	local silverText = frame:CreateFontString(frameName.."SilverText", "OVERLAY")
	silverText:SetJustifyH("RIGHT")
	silverText:SetPoint("RIGHT", silverIcon, "LEFT", 0, 0)
	silverText:SetFontObject(GameFontNormal)

	local copperText = frame:CreateFontString(frameName.."CopperText", "OVERLAY")
	copperText:SetJustifyH("RIGHT")
	copperText:SetPoint("RIGHT", copperIcon, "LEFT", 0, 0)
	copperText:SetFontObject(GameFontNormal)

	copperIcon:SetPoint("RIGHT", frame, "RIGHT")
	silverIcon:SetPoint("RIGHT", copperText, "LEFT")
	goldIcon:SetPoint("RIGHT", silverText, "LEFT")

	local TypeText = frame:CreateFontString(frameName.."TypeText", "OVERLAY")
	TypeText:SetJustifyH("RIGHT")
	TypeText:SetPoint("RIGHT", goldText, "LEFT", 0, 0)
	TypeText:SetFontObject(GameFontNormal)


	frame:Hide()
end


function PP_UMF( frameName, TextValue, value )

	local copper = value
	local gold = floor(copper / 10000)
	local silver = mod(floor(copper / 100), 100)
	copper = mod(copper, 100)
		
	local width = 0

	local TypeText = getglobal(frameName.."TypeText");
	TypeText:Show()
	TypeText:SetWidth(0)
	TypeText:SetText(TextValue)
	width = width + TypeText:GetWidth()
	
	local GoldIcon = getglobal(frameName.."GoldIcon");
	local GoldText = getglobal(frameName.."GoldText");
	GoldIcon:Show()
	GoldText:Show()
	GoldText:SetWidth(0)
	GoldText:SetText(gold)
	width = width + GoldIcon:GetWidth() + GoldText:GetWidth()

	local SilverIcon = getglobal(frameName.."SilverIcon");
	local SilverText = getglobal(frameName.."SilverText");
	SilverIcon:Show()
	SilverText:Show()
	SilverText:SetWidth(0)
	SilverText:SetText(silver)
	width = width + SilverIcon:GetWidth() + SilverText:GetWidth()

	local CopperIcon = getglobal(frameName.."CopperIcon");
	local CopperText = getglobal(frameName.."CopperText");
	CopperIcon:Show()
	CopperText:Show()
	CopperText:SetWidth(0)
	CopperText:SetText(copper)
	width = width + CopperIcon:GetWidth() + CopperText:GetWidth()
	
	local MoneyFrame = getglobal(frameName);
	MoneyFrame:SetWidth(width)
end

function PP_ShowHide_BO_Button(value)
  if value == 1 then
    if PP_ShowBid == 1 then
      PP_Bid_MoneyFrame:SetPoint("RIGHT",PP_Buy_MoneyFrame,"LEFT",-5,0)
    end
    PP_Buy_MoneyFrame:Show()
  else
   PP_Buy_MoneyFrame:Hide()
    if PP_ShowBid == 1 then
      PP_Bid_MoneyFrame:SetPoint("RIGHT",AuctionsCancelAuctionButton,"LEFT",-5,0)
    end
  end
end

function PP_ShowHide_Bid_Button(value)
  if value == 1 then
    if PP_ShowBO == 1 then
      PP_Bid_MoneyFrame:SetPoint("RIGHT",PP_Buy_MoneyFrame,"LEFT",-5,0)
    else
      PP_Bid_MoneyFrame:SetPoint("RIGHT",AuctionsCancelAuctionButton,"LEFT",-5,0)
    end
    PP_Bid_MoneyFrame:Show()
  else
    PP_Bid_MoneyFrame:Hide()
  end
end

function PP_CreateButtons()
  PP_CMF("PP_Buy_MoneyFrame","AuctionsCancelAuctionButton");
  PP_CMF("PP_Bid_MoneyFrame","PP_Buy_MoneyFrame");
  PP_ShowHide_BO_Button(PP_ShowBO)
  PP_ShowHide_Bid_Button(PP_ShowBid)
  PP_Calc();
end

function PP_SlashCmd(PPcmd)
  if (PPcmd=="") then
    DEFAULT_CHAT_FRAME:AddMessage("Useage:");
    DEFAULT_CHAT_FRAME:AddMessage("/pp Cut -Toggles AH Cut on or off");
    DEFAULT_CHAT_FRAME:AddMessage("/pp BO - Toggles BO Total on or off");
    DEFAULT_CHAT_FRAME:AddMessage("/pp Bid - Toggles Bid Total on or off");
  end

  if (string.lower(PPcmd)=="cut") then
    if PP_SubtractAHCut == 1 then
      PP_SubtractAHCut = 0
      DEFAULT_CHAT_FRAME:AddMessage("|cFFffd700Potential_Profit:|rAH Cut turned |cFFFF0000off|r")
    else
      PP_SubtractAHCut = 1
      DEFAULT_CHAT_FRAME:AddMessage("|cFFffd700Potential_Profit:|rAH Cut turned |cFF00FF00on|r")
    end
    PP_Calc();
  end
  
  if (string.lower(PPcmd)=="bo") then
    if PP_ShowBO == 1 then
      PP_ShowBO = 0
      DEFAULT_CHAT_FRAME:AddMessage("|cFFffd700Potential_Profit:|rBuyout Totals turned |cFFFF0000off|r")
    else
      PP_ShowBO = 1
      DEFAULT_CHAT_FRAME:AddMessage("|cFFffd700Potential_Profit:|rBuyout Totals turned |cFF00FF00on|r")
    end
    PP_ShowHide_BO_Button(PP_ShowBO)
    PP_Calc();
  end

  if (string.lower(PPcmd)=="bid") then
    if PP_ShowBid == 1 then
      PP_ShowBid = 0
      DEFAULT_CHAT_FRAME:AddMessage("|cFFffd700Potential_Profit:|rBid Totals turned |cFFFF0000off|r")
    else
      PP_ShowBid = 1
      DEFAULT_CHAT_FRAME:AddMessage("|cFFffd700Potential_Profit:|rBid Totals turned |cFF00FF00on|r")
    end
    PP_ShowHide_Bid_Button(PP_ShowBid)
    PP_Calc();
  end

end

function PP_OnEvent()
  if event == "AUCTION_HOUSE_SHOW" then
    if PP_ButtonsLoaded == 1 then
      PP_Calc();
    else
      PP_CreateButtons();
      PP_ButtonsLoaded = 1
    end
  elseif event == "AUCTION_OWNED_LIST_UPDATE" then
    PP_Calc();
  end
end

  PP_SubtractAHCut = 1
  PP_ShowBid = 1
  PP_ShowBO = 1
  PP_ButtonsLoaded = 0

	local frame = CreateFrame("Frame","Potential_ProfitFrame")
  frame:SetScript("OnEvent", PP_OnEvent);
  frame:RegisterEvent("AUCTION_HOUSE_SHOW");
  frame:RegisterEvent("AUCTION_OWNED_LIST_UPDATE");
 

  SLASH_Potential_Profit1 = "/Potential_Profit";
  SLASH_Potential_Profit2 = "/PP";
  SlashCmdList["Potential_Profit"] = function (msg) PP_SlashCmd(msg) end;

