PoisonMenu = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0")

local dewdrop = AceLibrary("Dewdrop-2.0")

local _G = getfenv(0)

PoisonMenu.EverSeen = {}
PoisonMenu.Current = {}

local itemIDs = {
	--crippling
	[3775] = true,
	[3776] = true,
	--deadly
	[2892] = true,
	[2893] = true,
	[8984] = true,
	[8985] = true,
	[20844] = true,
	[22053] = true,
	[22054] = true,
	--instant
	[6947] = true,
	[6949] = true,
	[6950] = true,
	[8926] = true,
	[8927] = true,
	[8928] = true,
	[21927] = true,
	--mind-numbing
	[5237] = true,
	[6951] = true,
	[9186] = true,
	--wound
	[10918] = true,
	[10920] = true,
	[10921] = true,
	[10922] = true,
	[22055] = true,
	--anesthetic
	[21835] = true,
	--Sharpening
	[2862] = true,
	[2863] = true,
	[2871] = true,
	[7964] = true,
	[12404] = true,
	[18262] = true,
	[23528] = true,
	[28420] = true,
	[23122] = true,
	[23529] = true,
	[28421] = true,
	--Weight
	[3239] = true,
	[3240] = true,
	[3241] = true,
	[7965] = true,
	[12643] = true,
	[28420] = true,
	[28421] = true,
	--Oil
	[3829] = true,
	[34538] = true,
	[34539] = true,
	[20744] = true,
	[20745] = true,
	[20746] = true,
	[20747] = true,
	[20748] = true,
	[20749] = true,
	[20750] = true,
	[22521] = true,
	[22522] = true,
	[23123] = true,
	--Lure
	[6529] = true,
	[6532] = true,
	[6533] = true,
	[6811] = true,
}

function PoisonMenu:OnInitialize()
	self.revision = tonumber(string.sub("$Rev: 79677 $", 7, -3))
	self.version = self.version .. " |cffff8888r"..self.revision.."|r"

	self:RegisterDB("PoisonMenuDB")
	self:RegisterDefaults('profile', { scale = 1, tooltip = false, Sort = "name" })

	self.options = {
		type = "group",
		args = {
			MiniMapPosition = {
				type = "range",
				name = "Minimap position",
				desc = "Set minimap position",
				get = function() return PoisonMenu.db.profile.minimapPosition or math.random(1, 360) end,
				set = function(value) PoisonMenu.db.profile.minimapPosition = value PoisonMenu:ReadjustLocation() end,
				step = 1,
				min = 1,
				max = 360,
			},
			Scale = {
				type = "range",
				name = "Scale",
				desc = "Set the scale",
				get = function() return PoisonMenu.db.profile.scale end,
				set = function(value) PoisonMenu.db.profile.scale = value PoisonMenu.ButtonFrame:SetScale(value) end,
				min = 0.1,
				max = 2,
				step = 0.1,
			},
			SimpleTooltip = {
				type = "toggle",
				name = "Simple Tooltip",
				desc = "Enable simple tooltip",
				get = function() return self.db.profile.tooltip end,
				set = function(v) self.db.profile.tooltip = v end,
			},
			Sort = {
				type = "text",
				name = "Sort",
				desc = "Sort by?",
				get = function() return self.db.profile.Sort end,
				set = function(v) self.db.profile.Sort = v end,
				validate = {name = "Name", count = "Count"},
			}
		}
	}
	self:RegisterChatCommand("/PoisonMenu", self.options)
end

function PoisonMenu:OnEnable()
	self.StateHeader = self:CreateSecureStateHeader()
	self.MiniMapButton = self:CreateMiniMapButton()
	self.ButtonFrame = self:CreateMainFrame()
	self.StateHeader:SetAttribute("state", "0")

	dewdrop:Register(self.MiniMapButton,
	    'children', function()
	        dewdrop:FeedAceOptionsTable(self.options)
	    end,
		'point', function(parent)
	        return "TOPRIGHT"
	    end,
	    'relativePoint', function(parent)
	        return "BOTTOMRIGHT"
	    end
	)
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
	if not InCombatLockdown() then
		self:PLAYER_REGEN_DISABLED()
	end
end

function PoisonMenu:OnDisable()
	PoisonMenu.MiniMapButton:Hide()
end

function PoisonMenu:PLAYER_REGEN_DISABLED()
	self.StateHeader.poisonCount = self:GetPoisons()
	if not InCombatLockdown() then
		self:CreateFrames()
		if #self.StateHeader.poisonCount == 0 then
			self.MiniMapButton:Hide()
		else
			self.MiniMapButton:Show()
		end
	end
end

function PoisonMenu:ButtonUpdate(button)
	if button.needUpdate then
		-- find the current poison count for this button
		local itemName = button.PoisonName
		
		local count
		if self.Current[itemName] then
				count = self.Current[itemName].quantity
		end
		
		local text = _G[button:GetName().."Count"]
		local icon = _G[this:GetName().."Icon"]
	        local normalTexture = _G[this:GetName().."NormalTexture"]
		if (count and count > 0) then
			text:SetText(""..count)
			icon:SetVertexColor(1.0, 1.0, 1.0)
			normalTexture:SetVertexColor(1.0, 1.0, 1.0)
		else
			text:SetText("0")
			icon:SetVertexColor(0.5, 0.5, 1.0)
			normalTexture:SetVertexColor(0.5, 0.5, 1.0)
		end
		button.needUpdate = false
	end
end

function PoisonMenu:ButtonPostClick(button)
	if not SpellIsTargeting() then
		local itemTable = self.Current[button.PoisonName]
		itemTable.quantity = itemTable.quantity - 1
	end
	button.needUpdate = true
end

function PoisonMenu:GetPoisons()
	for k in pairs(self.Current) do
		self.Current[k] = nil
	end
	local table = {}
	for i in pairs(itemIDs) do
		local count = GetItemCount(i)
		if count > 0 then
			local name, link, _, _, _, _, _, _, _, icon = GetItemInfo(i)
			self.Current[name] = { name=name, icon=icon, quantity=count, link = link}
			self.EverSeen[name] = { icon, link }
		end
	end
	
	for prevItemName, prevTable in pairs(PoisonMenu.EverSeen) do
		if not self.Current[prevItemName] then
			self.Current[prevItemName] = { name=prevItemName, icon=prevTable[1], quantity=0, itemLink = prevTable[2] }
		end
	end
	if self.db.profile.Sort == "count" then
		for k in pairs(self.Current) do
			tinsert(table, k)	
		end
		sort(table, function(a, b) return self.Current[a].quantity > self.Current[b].quantity end)
	elseif self.db.profile.Sort == "name" then
		for k in pairs(self.Current) do
			tinsert(table, k)	
		end
		sort(table)
	end
	return table
end

function PoisonMenu:CreateFrames()
	local x = 0
	for _, v in ipairs(self.StateHeader.poisonCount) do
		local t = self.Current[v]
		local name = t.name
		local button = _G["PoisonMenuButton"..name]
		if not InCombatLockdown() then
			if not button then
				self:CreateButton(name, t.icon, t.link)	
				button = _G["PoisonMenuButton"..name]
			end
			button:ClearAllPoints()
			button:SetPoint("TOPRIGHT", x, 0)
			x = x - 40
			button.needUpdate = true
		end
	end
end

function PoisonMenu:CreateSecureStateHeader()
	local frame = CreateFrame("Frame", nil, Minimap, "SecureStateHeaderTemplate")
	frame:SetAttribute("statemap-anchor-enter", "0:1")
	frame:SetAttribute("statemap-anchor-leave", "")
	frame:SetAttribute("delaystatemap-anchor-leave", "1:0")
	frame:SetAttribute("delaytimemap-anchor-leave", "1:1")
	frame:SetAttribute("delayhovermap-anchor-leave", "1:true")
	frame:SetPoint("CENTER")
	return frame
end

function PoisonMenu:CreateMiniMapButton()
	local frame = CreateFrame("Button", nil, self.StateHeader, "SecureAnchorEnterTemplate")
	frame:SetAttribute("anchorchild", self.StateHeader)
	frame:SetAttribute("childstate-OnEnter", "enter")
	frame:SetAttribute("childstate-OnLeave", "leave")
	frame:SetWidth(31)
	frame:SetHeight(31)
	frame:SetFrameLevel(4)
	frame:SetHighlightTexture("Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight")
	local icon = frame:CreateTexture(nil, "BACKGROUND")
	frame.icon = icon
	icon:SetTexture("Interface\\Icons\\INV_Misc_Herb_16")
	icon:SetTexCoord(0.05, 0.95, 0.05, 0.95)
	icon:SetWidth(20)
	icon:SetHeight(20)
	icon:SetPoint("TOPLEFT", frame, "TOPLEFT", 7, -5)
	local overlay = frame:CreateTexture(nil, "BORDER")
	frame.overlay = overlay
	overlay:SetTexture("Interface\\Minimap\\MiniMap-TrackingBorder")
	overlay:SetWidth(53)
	overlay:SetHeight(53)
	overlay:SetPoint("TOPLEFT",frame,"TOPLEFT")
	frame:EnableMouse(true)
	frame:RegisterForClicks("RightButtonUp")
	frame:SetScript("OnMouseDown", function()
	if arg1 ~= "RightButton" then return end
		frame.icon:SetTexCoord(0.14, 0.86, 0.14, 0.86)
	end)
	frame:SetScript("OnMouseUp", function()
	if arg1 ~= "RightButton" then return end
		frame.icon:SetTexCoord(0.05, 0.95, 0.05, 0.95)
	end)
	frame:SetScript("OnClick", function() 
		dewdrop:Open(self.MiniMapButton) 
	end)
	frame:RegisterForDrag("LeftButton")
	frame:SetScript("OnDragStart", function() self:OnDragStart() end)
	frame:SetScript("OnDragStop", function() self:OnDragStop() end)	
	frame:Show()
	self:ReadjustLocation(frame)
	
	return frame
end 


function PoisonMenu:CreateMainFrame()
	local frame = CreateFrame("Frame", nil, self.StateHeader, "SecureFrameTemplate")
	frame:Hide()
	self.StateHeader:SetAttribute("addchild", frame)
	frame:SetHeight(36)
	frame:SetWidth(240)
	frame:SetScale(PoisonMenu.db.profile.scale)
	frame:SetAttribute("showstates", "1")
	frame:SetAttribute("hidestates", "0")
	frame:SetAttribute("delaystate", "1:0")
	frame:SetAttribute("delaytime", "1:1")
	frame:SetAttribute("delayhover", "1:true")
	frame:SetPoint("TOPRIGHT", self.MiniMapButton, "LEFT")
	frame:SetScript("OnShow", function() PoisonMenu:PLAYER_REGEN_DISABLED() end)
	
	return frame
end	

function PoisonMenu:CreateButton(name, icon, link)
	local frame = CreateFrame("Button", "PoisonMenuButton"..name, self.ButtonFrame, "ActionButtonTemplate,SecureActionButtonTemplate")
	frame:SetFrameStrata("MEDIUM")
	frame:SetToplevel()
	frame:SetHeight(36)
	frame:SetWidth(36)
	frame:RegisterForClicks("AnyUp")
	frame:SetAttribute("type", "item")
	frame:SetAttribute("item", name)
	frame:SetAttribute("target-slot1", "16")
	frame:SetAttribute("target-slot2", "17")
	
	local texture = _G[frame:GetName().."Icon"]
	texture:SetTexture(icon)
	texture:SetAllPoints(frame)
	
	frame:SetScript("OnEnter", function() GameTooltip:SetOwner(this, 'ANCHOR_BOTTOMRIGHT') if not self.db.profile.tooltip then GameTooltip:SetHyperlink(link) else GameTooltip:SetText(name) end end )
	frame:SetScript("OnLeave", function() GameTooltip:Hide() end)
	frame:SetScript("OnUpdate", function(frame, elapsed) PoisonMenu:ButtonUpdate(frame, elapsed) end)
	frame:SetScript("PostClick", function() PoisonMenu:ButtonPostClick(frame) end)
	
	frame.PoisonName = name
end

function PoisonMenu:ReadjustLocation(frame)
	local frame = frame or PoisonMenu.MiniMapButton
	local position = self.db.profile.minimapPosition or math.random(1, 360)
	local angle = math.rad(position or 0)
	local x,y
	local minimapShape = GetMinimapShape and GetMinimapShape() or "ROUND"
	local cos = math.cos(angle)
	local sin = math.sin(angle)
	
	local round = true
	if minimapShape == "ROUND" then
		-- do nothing
	elseif minimapShape == "SQUARE" then
		round = false
	elseif minimapShape == "CORNER-TOPRIGHT" then
		if cos < 0 or sin < 0 then
			round = false
		end
	elseif minimapShape == "CORNER-TOPLEFT" then
		if cos > 0 or sin < 0 then
			round = false
		end
	elseif minimapShape == "CORNER-BOTTOMRIGHT" then
		if cos < 0 or sin > 0 then
			round = false
		end
	elseif minimapShape == "CORNER-BOTTOMLEFT" then
		if cos > 0 or sin > 0 then
			round = false
		end
	elseif minimapShape == "SIDE-LEFT" then
		if cos > 0 then
			round = false
		end
	elseif minimapShape == "SIDE-RIGHT" then
		if cos < 0 then
			round = false
		end
	elseif minimapShape == "SIDE-TOP" then
		if sin > 0 then
			round = false
		end
	elseif minimapShape == "SIDE-BOTTOM" then
		if sin < 0 then
			round = false
		end
	elseif minimapShape == "TRICORNER-TOPRIGHT" then
		if cos < 0 and sin > 0 then
			round = false
		end
	elseif minimapShape == "TRICORNER-TOPLEFT" then
		if cos > 0 and sin > 0 then
			round = false
		end
	elseif minimapShape == "TRICORNER-BOTTOMRIGHT" then
		if cos < 0 and sin < 0 then
			round = false
		end
	elseif minimapShape == "TRICORNER-BOTTOMLEFT" then
		if cos > 0 and sin < 0 then
			round = false
		end
	end
	
	if round then
		x = cos * 80
		y = sin * 80
	else
		x = 110 * cos
		y = 110 * sin
		x = math.max(-82, math.min(x, 84))
		y = math.max(-86, math.min(y, 82))
	end
	frame:SetPoint("CENTER", Minimap, "CENTER", x, y)
end

function PoisonMenu:OnUpdatePosition()
	local mx, my = Minimap:GetCenter()
	local px, py = GetCursorPosition()
	local scale = UIParent:GetEffectiveScale()
	px, py = px / scale, py / scale
	local position = math.deg(math.atan2(py - my, px - mx))
	if position <= 0 then
		position = position + 360
	elseif position > 360 then
		position = position - 360
	end
	self.db.profile.minimapPosition = position
	self:ReadjustLocation()
end

function PoisonMenu:OnDragStart()
	this:LockHighlight()
	this:SetScript("OnUpdate", function() self:OnUpdatePosition() end )
end

function PoisonMenu:OnDragStop()
	this:SetScript("OnUpdate", nil)
	this:UnlockHighlight()
end 