﻿if select(6, GetAddOnInfo("PitBull_" .. (debugstack():match("[i%.][t%.][B%.]ull\\Modules\\(.-)\\") or debugstack():match("[i%.][t%.][B%.]ull\\(.-)\\") or ""))) ~= "MISSING" then return end

local VERSION = tonumber(("$Revision: 66896 $"):match("%d+"))

local PitBull = PitBull
local PitBull_Prat = PitBull:NewModule("Prat", "LibRockEvent-1.0")
local self = PitBull_Prat
if PitBull.revision < VERSION then
	PitBull.version = "r" .. VERSION
	PitBull.revision = VERSION
	PitBull.date = ("$Date: 2008-03-29 07:40:41 -0400 (Sat, 29 Mar 2008) $"):match("%d%d%d%d%-%d%d%-%d%d")
end

local localization = (GetLocale() == "zhCN") and {
	["Prat"] = "聊天泡泡",
	["This is some chat from me..."] = "我说…",
	["Highlight unit frames when they chat."] = "聊天时高亮头像框",
	["Options for interfacing the unit frame and the chat."] = "头像框与聊天交互选项",
	["Highlight Frame On Chat"] = "聊天时高亮头像框",
	["Highlight this unit frame when the unit says something in chat."] = "当单位聊天时高亮这个头像框",
	["Display Chat At Frame"] = "显示聊天泡泡",
	["Display chat from this unit at the unit frame."] = "当单位聊天时显示聊天泡泡",
	["Font height"] = "字体高度",
	["Set the font height."] = "设置字体高度",
} or {}

local L = PitBull:L("PitBull-Prat", localization)

self.desc = L["Highlight unit frames when they chat."]

local new, del, newHash = PitBull.new, PitBull.del, PitBull.newHash
local newFrame, delFrame = PitBull.newFrame, PitBull.delFrame

local UnitIsUnit = UnitIsUnit

PitBull_Prat:RegisterPitBullChildFrames('prat')
PitBull_Prat:RegisterPitBullChildFrames('pratText')
PitBull_Prat:RegisterPitBullChildFrames('pratTextFrame')

function PitBull_Prat:OnInitialize()
	self.db = PitBull:GetDatabaseNamespace("prat")
	PitBull:SetDatabaseNamespaceDefaults("prat", "profile", {
		['**'] = {
			hidden = false,
			ShowChat = true,
			ShowChatText = true,
			fontheight = 13,
		},
		target = {
		    hidden = false,
			ShowChat = false,
			ShowChatText = false,
		},
		targettarget = {
		    hidden = false,
			ShowChat = false,
			ShowChatText = false,
		},
		targettargettarget = {
		    hidden = false,
			ShowChat = false,
			ShowChatText = false,
		},
	})
end

local chatHilight_path
do
	local path = "Interface\\AddOns\\" .. debugstack():match("[d%.][d%.][O%.]ns\\(.-)\\[A-Za-z]-%.lua")
	chatHilight_path = "Interface\\Cooldown\\Starburst"

end

local chattype_mask = {
    CHAT_MSG_WHISPER = true,
    CHAT_MSG_WHISPER_INFORM = true,
    CHAT_MSG_GUILD = true,
    CHAT_MSG_OFFICER = true,
    CHAT_MSG_PARTY = true,
    CHAT_MSG_RAID = true,
    CHAT_MSG_RAID_LEADER = true,
    CHAT_MSG_RAID_WARNING = true,
    CHAT_MSG_BATTLEGROUND = true,
    CHAT_MSG_BATTLEGROUND_LEADER = true,
    CHAT_MSG_SYSTEM = true,
    CHAT_MSG_SAY = true,
    CHAT_MSG_YELL = true,
    }
    


-- Stuff we are going to remove from the chat text is not commented out
local msg_mask = {
--    PRE = true,

	nN = true,
	CHANLINK = true,
	NN = true,

--    cC = true,
--        CHANNELNUM = true,
--        CC = true,
--        CHANNEL = true,
--        zZ = true,
--            ZONE = true,
--        Zz = true,
--    Cc = true,

    TYPEPREFIX = true,

    Nn = true,

-- AFK/DND is on the frame so mask it out
    fF = true,
        FLAG = true,
    Ff = true,

-- dont need the player info at all
    pP = true,
        lL = true,  -- link start
        PLAYERLINK= true,
        PLAYERLINKDATA = true,
        LL = true, --  link text start

        PREPLAYER = true,
        PLAYER = true,

        sS = true,
            SERVER = true,
        Ss = true,
        POSTPLAYER = true,

        Ll = true,  -- link text end
    Pp = true,

    TYPEPOSTFIX = true,

--    mM = true,
--        gG = true,
--        LANGUAGE = true,
--        Gg = true,
--        MESSAGE = true,
--    Mm = true,

--    POST = true,
}

local masked_chat_idx = {}

function PitBull_Prat:OnEnable(first)
    if Prat.Events then 
    	self:AddEventListener("AceEvent-2.0", Prat.Events.POST_ADDMESSAGE)
    	self:AddEventListener("AceEvent-2.0", Prat.Events.SECTIONS_UPDATED)
    end
end

function PitBull_Prat:Prat_ChatSectionsUpdated(ns, event, ...)
    -- Build a message mask 
    for k,v in pairs(masked_chat_idx) do masked_chat_idx[k] = nil end	
    for _,v in ipairs(Prat.SplitMessageIdx) do
        if not msg_mask[v] then
    	    table.insert(masked_chat_idx, v)
    	end
    end
end

local function getShowChat(group)
	return PitBull_Prat.db.profile[group].ShowChat
end
local function setShowChat(group, value)
	PitBull_Prat.db.profile[group].ShowChat = value
end
local function getShowChatText(group)
	return PitBull_Prat.db.profile[group].ShowChatText
end
local function setShowChatText(group, value)
	PitBull_Prat.db.profile[group].ShowChatText = value
end
local function getFontHeight(group)
	return PitBull_Prat.db.profile[group].fontheight
end
local function setFontHeight(group, value)
	PitBull_Prat.db.profile[group].fontheight = value
end

function PitBull_Prat:Prat_PostAddMessage(ns, ev, message, frame, event, text, r, g, b, id)
    if AceLibrary("AceEvent-2.0").currentEventUID and AceLibrary("AceEvent-2.0").currentEventUID == self.lastevent and self.lasteventtype == event then return end

    if not chattype_mask[event] then return end

	local msgtype = string.sub(event, 10)
	local plr, svr = strsplit("-", (message.PLAYERLINK or ""))
	
	local p,s
	for unit, frame in PitBull:IterateUnitFrames() do
	    p,s = UnitName(unit)
        
        if p == plr and s == svr then
            if frame.prat  and  getShowChat(frame.group) then 
            	frame.prat:SetVertexColor(r,g,b);
                frame.prat:ClearAllPoints()
                frame.prat:SetAllPoints(frame.portrait or frame)
            	frame.prat:Show()
                UIFrameFlash(frame.prat, 0.25, 0.25, 5, nil, 0.5, 0.5)
            end
            
            if frame.pratTextFrame and frame.pratText and getShowChatText(frame.group) then
                local text = Prat:BuildChatText(message, masked_chat_idx)
        		local font, fontsize = ChatFrame1:GetFont()
        		frame.pratText:SetFont( font, getFontHeight(frame.group), "OUTLINE" )
                frame.pratText:SetText(text)
        		frame.pratText:SetTextColor(r,g,b)
        		frame.pratText:Show()
        		frame.pratTextFrame:Show()

            	
            	frame.pratTextFrame:SetWidth(math.min(math.max(64, frame.pratText:GetStringWidth()), frame:GetWidth() + 20))
        		frame.pratTextFrame:SetBackdropBorderColor(r,g,b)
        		
        		
    		    frame.pratText:ClearAllPoints()
                frame.pratText:SetPoint("TOPLEFT", frame.pratTextFrame, "TOPLEFT", 5, 5)
                frame.pratText:SetPoint("BOTTOMRIGHT", frame.pratTextFrame, "BOTTOMRIGHT", -5, -5)
        		
        		--UIFrameFadeOut(frame.pratTextFrame, 10, 1, 0)
        		UIFrameFlash(frame.pratTextFrame, 1, 5, 5, nil, 1, 1)               
               
            end
        end
	end    
end    

local function getDisabled(group)
	return PitBull_Prat.db.profile[group].hidden
end

local function config(frame)
	if not frame.pratText then
		return
	end
	if PitBull.configMode then
		local font, fontsize = ChatFrame1:GetFont()
		frame.pratText:SetFont( font, getFontHeight(frame.group), "OUTLINE" )
		frame.pratText:SetText("This is some chat from me...")
		frame.pratText:SetTextColor(1, 1, 1)



		frame.pratText:Show()
		frame.pratTextFrame:Show()
    	frame.pratTextFrame:SetWidth(math.min(math.max(64, frame.pratText:GetStringWidth()), frame:GetWidth() + 20))
    	
        frame.pratText:ClearAllPoints()
        frame.pratText:SetPoint("TOPLEFT", frame.pratTextFrame, "TOPLEFT", 5, 5)
        frame.pratText:SetPoint("BOTTOMRIGHT", frame.pratTextFrame, "BOTTOMRIGHT", -5, -5)

	else
		frame.pratTextFrame:Hide()
		frame.pratText:Hide()
	end
end

function PitBull_Prat:OnChangeConfigMode(configMode)
	for unit, frame in PitBull:IterateUnitFrames() do
		if not getDisabled(frame.group) and getShowChatText(frame.group) then
			config(frame)
		end
	end
end

function PitBull_Prat:OnPopulateUnitFrame(unit, frame)
	if not getDisabled(frame.group) then
	
	    if not frame.prat then 
    		local prat = newFrame("Texture", frame.overlay, "OVERLAY")
    		frame.prat = prat
    		prat:SetTexture(chatHilight_path)
    		prat:SetBlendMode("ADD")
    		prat:SetAlpha(0.5)
    		prat:ClearAllPoints()
    		prat:SetAllPoints(frame.portrait or frame)
        end
        
        if not frame.pratTextFrame and not frame.pratText then		
    		local pratTextFrame = getglobal("ChatTextFrame" .. unit) or CreateFrame("ScrollingMessageFrame", "ChatTextFrame" .. unit, frame, "ChatPopupTemplate")
    		frame.pratTextFrame = pratTextFrame

    		pratTextFrame:SetPoint("TOPLEFT", frame, "TOPRIGHT", 5, 20)
    		pratTextFrame:SetHeight(math.max(64, frame:GetHeight()))
    
    
    		local pratText = getglobal(pratTextFrame:GetName().."_Text")
    		frame.pratText = pratText
    		
    		local font, fontsize = ChatFrame1:GetFont()
    		pratText:SetFont( font, getFontHeight(frame.group), "OUTLINE")
    		pratText:SetNonSpaceWrap(false)
    		pratText:SetAlpha(1)	
    	end

        frame.prat:Hide()
		frame.pratText:Show()
		frame.pratTextFrame:Hide()
				
	end
end

function PitBull_Prat:OnUpdateFont(font, fontsize)
	for _,frame in PitBull:IterateUnitFrames() do
		if frame.pratText then
		--	frame.pratText:SetFont( font, fontsize)
		end
	end
end


-- From Dreamchat

-- @desc Starts interpolating a frame width for the specified DreamChat frame.
-- @arg frame object The frame object.
-- @arg width number The desired frame width.
function PitBull_Prat:SetFrameWidth(frame, width)
	local oldwidth, steps = frame:GetWidth(), 15
	frame.widthc = 0
	self:ScheduleRepeatingEvent("PBP_FrameWidth"..frame:GetName(), self.SetFrameWidth_Handler, 0.5/steps, self, frame, oldwidth, width, steps)
end

-- @desc Worker function for setting the frame size. Called by AceEvent as a repeating scheduled event.
-- @arg frame object The frame object.
-- @arg oh number Old width.
-- @arg h number Desired width.
-- @arg steps Number of steps in the operation.
function PitBull_Prat:SetFrameWidth_Handler(frame, ow, w, steps)
	frame.widthc = frame.widthc + 1
	frame:SetWidth(CosineInterpolate(ow, w, ((1/steps) * frame.widthc)))
	if frame.widthc == steps then
		self:CancelScheduledEvent("PBP_FrameWidth"..frame:GetName())
		frame.widthc = nil
	end
end


function PitBull_Prat:OnClearUnitFrame(unit, frame)
		if frame.prat then frame.prat = delFrame(frame.prat) end
		frame.pratText:Show()
		frame.pratTextFrame:Hide()
end

function PitBull_Prat:OnUpdateLayout(unit, frame)
	if getShowChatText(frame.group) then
		config(frame)
	end
end
function PitBull_Prat:OnUnknownLayout(unit, frame, name)
    if frame.prat then 
        frame.prat:ClearAllPoints()
    	frame.prat:SetAllPoints(frame.portrait or frame)
    	frame.prat:Hide()
    end
    	
	if frame.pratText and frame.pratTextFrame then

		frame.pratTextFrame:SetPoint("TOPLEFT", frame, "TOPRIGHT", 5, 20)
		frame.pratTextFrame:SetWidth(64)
		frame.pratTextFrame:SetHeight(math.max(64, frame:GetHeight()))
				
		local font, fontsize = ChatFrame1:GetFont()
		frame.pratText:SetFont( font, getFontHeight(frame.group), "OUTLINE" )
		frame.pratText:SetNonSpaceWrap(false)
		
		frame.pratTextFrame:Hide()
	end
end


local function getEnabled(group)
	return not getDisabled(group)
end
local function setEnabled(group, value)
	value = not value
	PitBull_Prat.db.profile[group].hidden = value
	
	if value then
		for unit, frame in PitBull:IterateUnitFramesByGroup(group) do
			PitBull_Prat:OnClearUnitFrame(unit, frame)
			
			PitBull:UpdateLayout(frame)
		end
	else
		for unit, frame in PitBull:IterateUnitFramesByGroup(group) do
			PitBull_Prat:OnPopulateUnitFrame(unit, frame)
		
			PitBull:UpdateLayout(frame)
		end
	end
end


PitBull_Prat:RegisterPitBullOptionsMethod(function(group)
	return {
		name = L["Prat"],
		desc = L["Options for interfacing the unit frame and the chat."],
		type = "group",
		args = {
			showMessageHilight = {
				name = L["Highlight Frame On Chat"],
				desc = L["Highlight this unit frame when the unit says something in chat."],
				type = "toggle",
				get = getShowChat,
				set = setShowChat,
				passValue = group,
				disabled = getDisabled,
			},
			showMessageText = {
				name = L["Display Chat At Frame"],
				desc = L["Display chat from this unit at the unit frame."],
				type = "toggle",
				get = getShowChatText,
				set = setShowChatText,
				passValue = group,
				disabled = getDisabled,
			},
			fontheight = {
				type = 'number',
				name = L["Font height"],
				desc = L["Set the font height."],
				min = 6,
				max = 30,
				step = 1,
				get = getFontHeight,
				set = setFontHeight,
				passValue = group,
				disabled = getDisabled,
			},						
		}
	}
end)




function ChatTooltip_OnLoad() end
function ChatTooltip_OnHide() end
function ChatTooltip_SetDefaultAnchor(this, UIParent) end
