if select(6, GetAddOnInfo("PitBull_" .. (debugstack():match("[i%.][t%.][B%.]ull\\Modules\\(.-)\\") or debugstack():match("[i%.][t%.][B%.]ull\\(.-)\\") or ""))) ~= "MISSING" then return end

local VERSION = tonumber(("$Revision: 60349 $"):match("%d+"))

local PitBull = PitBull
local PitBull_FullBar = PitBull:NewModule("FullBar", "LibRockEvent-1.0")
local self = PitBull_FullBar
if PitBull.revision < VERSION then
	PitBull.version = "r" .. VERSION
	PitBull.revision = VERSION
	PitBull.date = ("$Date: 2008-02-04 22:19:21 -0500 (Mon, 04 Feb 2008) $"):match("%d%d%d%d%-%d%d%-%d%d")
end

local localization = (GetLocale() == "koKR") and {
	["Show a full bar on the unit frame."] = "?? ???? full ?? ?????.",
	["Full"] = "Full",
	["Full bar display options."] = "Full ? ?? ??",
	["Enable"] = "???",
	["Enables the full bar."] = "Full ?? ??????.",
	["Color by class"] = "??? ??",
	["Color the full bar by unit class."] = "Full ?? ?? ???? ?? ?????.",
	["Color by class for PvP enemies"] = "PvP ?? ?? ??? ??",
	["Color the full bar for PvP enemies by unit class."] = "PvP ?? ?? Full ?? ?? ???? ?? ?????.",
	["Color by hostility"] = "???? ?? ??",
	["Color the full bar by hostility. Note that this takes precedence after color by class."] = "Full ?? ???? ?? ?? ?????. ? ??? ??? ?? ??? ??? ??? ??? ?? ??????.",
	["Color NPCs by hostility"] = "???? ?? NPC ??",
	["Color the full bar by hostility for NPCs. Note that this takes precedence after color by class."] = "NPC? ?? full ?? ???? ?? ?? ?????. ? ??? ??? ?? ??? ??? ??? ??? ?? ??????.",
	["Custom color"] = "??? ??",
	["Set a custom color for the full bar. Note that this is the least priority after all the color options."] = "Full ?? ?? ??? ?? ??? ?????. ? ??? ?? ?? ??? ?? ???? ??? ??????.",
	["Enable using a custom color for the full bar."] = "Full ?? ?? ??? ?? ?? ?? ??? ??????.",
	["Color"] = "??",
	["Set the custom color for the full bar."] = "Full ?? ?? ??? ?? ??? ?????.",
	["Color by happiness"] = "???? ??",
	["Color full bar by pet happiness status."] = "Full ?? ???? ??? ??? ?? ?? ?????.",

} or {}

local L = PitBull:L("PitBull-FullBar", localization)

PitBull_FullBar.desc = L["Show a full bar on the unit frame."]

local newFrame, delFrame = PitBull.newFrame, PitBull.delFrame

local UnitClass = UnitClass

local SharedMedia = Rock("LibSharedMedia-3.0")

SharedMedia:Register("statusbar", "Transparent", [[Interface\AddOns\PitBull_FullBar\media\transparent.tga]])

PitBull_FullBar:RegisterPitBullChildFrames("fullBar")
PitBull_FullBar:RegisterPitBullBarLayoutHandler("fullBar", L["Full bar"], L["Full"])

local unitsShown = {}




function PitBull_FullBar:OnInitialize()
	self.db = PitBull:GetDatabaseNamespace("FullBar")
	PitBull:SetDatabaseNamespaceDefaults("FullBar", "profile", {
		["**"] = {
			hidden = true,
			classColor = true,
			classColorPvP = false,
			hostilityColor = false,
			hostilityColorNPCs = false,
			customColor = false,
			customColors = {1,1,1},
			customTexture = false,
			fullBarTexture = "Cilo",
		},
		focus = {
			hostilityColor = true,
		},
		target = {
			hostilityColor = true,
		},
		targettarget = {
			hostilityColor = true,
		},
		targettargettarget = {
			hostilityColor = true,
		},
		focustarget = {
			hostilityColor = true,
		},
		partytarget = {
			hostilityColor = true,
		},
		partypettarget = {
			hostilityColor = true,
		},
		pettarget = {
			hostilityColor = true,
		},
		raidtarget = {
			hostilityColor = true,
		},
		pet = {
			happinessColor = true,
		},
	})
end

function PitBull_FullBar:OnEnable(first)
	self:AddEventListener("UNIT_FACTION", "UNIT_FACTION", 0.05)
end


function PitBull_FullBar:UNIT_FACTION(ns, event, units)
	for unit in pairs(units) do
		for frame in PitBull:IterateUnitFramesForUnit(unit) do
			if unitsShown[frame] then
				self:UpdateFullBarColor(unit, frame)
			end
		end
	end
end

local alerted = false


local _,class = UnitClass("player")
function PitBull_FullBar:UpdateFullBarColor(unit, frame)
	if not frame.fullBar then
		return
	end
	local db = self.db.profile[frame.group]

	local r, g, b
	if not UnitIsConnected(unit) then
		r, g, b = unpack(PitBull.colorConstants.disconnected)
	elseif UnitIsDeadOrGhost(unit) then
		r, g, b = unpack(PitBull.colorConstants.dead)
	elseif UnitIsTapped(unit) and not UnitIsTappedByPlayer(unit) then
		r, g, b = unpack(PitBull.colorConstants.tapped)
	elseif UnitIsPlayer(unit) then
		if db.classColor and (db.classColorPvP or UnitIsFriend("player", unit)) then
			local _,class = UnitClass(unit)
			r, g, b = unpack(PitBull.colorConstants[class or "WARRIOR"])
		elseif db.hostilityColor or db.hostilityColorNPCs then
			if UnitCanAttack(unit, "player") then
				-- they can attack me
				if UnitCanAttack("player", unit) then
					-- and I can attack them
					r, g, b = unpack(PitBull.colorConstants.hostile)
				else
					-- but I can"t attack them
					r, g, b = unpack(PitBull.colorConstants.civilian)
				end
			elseif UnitCanAttack("player", unit) then
				-- they can"t attack me, but I can attack them
				r, g, b = unpack(PitBull.colorConstants.neutral)
			elseif UnitIsFriend("player", unit) and db.hostilityColor then
				-- on my team
				r, g, b = unpack(PitBull.colorConstants.friendly)
			elseif db.hostilityColor then
				-- either enemy or friend, no violence
				r, g, b = unpack(PitBull.colorConstants.civilian)
			end
		elseif db.customColor then
			r, g, b = unpack(db.customColors)
		end
	elseif UnitIsUnit(unit, "pet") and db.happinessColor then
		if class == "HUNTER" then
			local happy = GetPetHappiness()
			if happy == 3 then
				r, g, b = unpack(PitBull.colorConstants.petHappy)
			elseif happy == 2 then
				r, g, b = unpack(PitBull.colorConstants.petNeutral)
			elseif happy == 1 then
				r, g, b = unpack(PitBull.colorConstants.petAngry)
			end
		end
	elseif db.hostilityColor or db.hostilityColorNPCs then
		local reaction = UnitReaction(unit, "player")
		if reaction then
			if reaction >= 5 then
				r, g, b = unpack(PitBull.colorConstants.friendly)
			elseif reaction == 4 then
				r, g, b = unpack(PitBull.colorConstants.neutral)
			else
				r, g, b = unpack(PitBull.colorConstants.hostile)
			end
		else
			r, g, b = unpack(PitBull.colorConstants.unknown)
		end
	elseif db.customColor then
		r, g, b = unpack(db.customColors)
	end
	if not r then
		r, g, b = 1, 1, 1
	end


	frame.fullBar:SetVertexColor(r, g, b, 1)


end


function PitBull_FullBar:OnUpdateFrame(unit, frame)
	if frame.fullBar and unitsShown[frame] then
		self:UpdateFullBarColor(unit, frame)
	end
end

local function GetFullBarTexture(group)
	return SharedMedia:Fetch('statusbar', self.db.profile[group].fullBarTexture)
end

local function UpdateFullBarTexture(group)
	local texture = PitBull:GetStatusBarTexture()

	for _,frame in PitBull:IterateUnitFramesByGroup(group) do
		if self.db.profile[group].customTexture then
		    frame.fullBar:SetTexture(GetFullBarTexture(group))
		else
			frame.fullBar:SetTexture(texture)
		end
	end

end

function PitBull_FullBar:OnPopulateUnitFrame(unit, frame)
	if self.db.profile[frame.group].hidden then
		return
	end
	local texture = PitBull:GetStatusBarTexture()
	if self.db.profile[frame.group].customTexture then
	    texture = GetFullBarTexture(frame.group)
	end

	local fullBar = newFrame("Texture", frame, "BACKGROUND")
	frame.fullBar = fullBar
	fullBar:SetTexture(texture)
	fullBar:SetVertexColor(0, 1, 0, 1)

end

function PitBull_FullBar:OnClearUnitFrame(unit, frame)
	if frame.fullBar then
		frame.fullBar = delFrame(frame.fullBar)
	end
end

function PitBull_FullBar:OnUpdateStatusBarTexture(texture)
	for _,frame in PitBull:IterateUnitFrames() do
		if self.db.profile[frame.group].customTexture then
		    frame.fullBar:SetTexture(GetFullBarTexture(frame.group))
		else
			frame.fullBar:SetTexture(texture)
		end
	end
end

function PitBull_FullBar:OnUpdateLayout(unit, frame)
	local old = not unitsShown[frame]
	local now = not frame.fullBar or not frame.fullBar:IsShown()
	if old == now then
		return
	end
	unitsShown[frame] = not now
	if not now then
		self:OnUpdateFrame(unit, frame)
	end
end

local function getClassColor(group)
	return PitBull_FullBar.db.profile[group].classColor
end
local function setClassColor(group, value)
	PitBull_FullBar.db.profile[group].classColor = value

	for unit, frame in PitBull:IterateUnitFramesByGroup(group) do
		PitBull_FullBar:UpdateFullBarColor(unit, frame)
	end
end
local function getClassColorPvP(group)
	return PitBull_FullBar.db.profile[group].classColorPvP
end
local function setClassColorPvP(group, value)
	PitBull_FullBar.db.profile[group].classColorPvP = value

	for unit, frame in PitBull:IterateUnitFramesByGroup(group) do
		PitBull_FullBar:UpdateFullBarColor(unit, frame)
	end
end
local function getHostilityColor(group)
	return PitBull_FullBar.db.profile[group].hostilityColor
end
local function setHostilityColor(group, value)
	PitBull_FullBar.db.profile[group].hostilityColor = value

	for unit, frame in PitBull:IterateUnitFramesByGroup(group) do
		PitBull_FullBar:UpdateFullBarColor(unit, frame)
	end
end

local function getHostilityColorNPCs(group)
	return PitBull_FullBar.db.profile[group].hostilityColorNPCs
end
local function setHostilityColorNPCs(group, value)
	PitBull_FullBar.db.profile[group].hostilityColorNPCs = value

	for unit, frame in PitBull:IterateUnitFramesByGroup(group) do
		PitBull_FullBar:UpdateFullBarColor(unit, frame)
	end
end

local function GetPetHappiness(group)
	return PitBull_FullBar.db.profile.pet.happinessColor
end

local function SetPetHappiness(group, value)
	PitBull_FullBar.db.profile.pet.happinessColor = value

	for unit, frame in PitBull:IterateUnitFramesByGroup(group) do
		PitBull_FullBar:UpdateFullBarColor(unit, frame)
	end
end

local function GetCustomColorToggle(group)
	return PitBull_FullBar.db.profile[group].customColor
end

local function SetCustomColorToggle(group, value)
	PitBull_FullBar.db.profile[group].customColor = value

	for unit, frame in PitBull:IterateUnitFramesByGroup(group) do
		PitBull_FullBar:UpdateFullBarColor(unit, frame)
	end
end

local function GetCustomColor(group)
	return unpack(PitBull_FullBar.db.profile[group].customColors)
end

local function SetCustomColor(group, r, g, b)
	PitBull_FullBar.db.profile[group].customColors = {r, g, b}

	for unit, frame in PitBull:IterateUnitFramesByGroup(group) do
		PitBull_FullBar:UpdateFullBarColor(unit, frame)
	end
end

local function GetCustomTextureToggle(group)
    return PitBull_FullBar.db.profile[group].customTexture
end
local function SetCustomTextureToggle(group, value)
	PitBull_FullBar.db.profile[group].customTexture = value

	UpdateFullBarTexture(group)
end

local function GetCustomTexture(group)
	return PitBull_FullBar.db.profile[group].fullBarTexture
end
local function SetCustomTexture(group, value)
	PitBull_FullBar.db.profile[group].fullBarTexture = value

 	UpdateFullBarTexture(group)
end


local function getDisabled(group)
	return PitBull_FullBar.db.profile[group].hidden
end
local function getEnabled(group)
	return not PitBull_FullBar.db.profile[group].hidden
end
local function setEnabled(group, value)
	value = not value
	PitBull_FullBar.db.profile[group].hidden = value

	for unit, frame in PitBull:IterateUnitFramesByGroup(group) do
		if value then
			self:OnClearUnitFrame(unit, frame)
		else
			self:OnPopulateUnitFrame(unit, frame)
			self:OnUpdateFrame(unit, frame)
		end
		PitBull:UpdateLayout(frame)
	end
end

PitBull_FullBar:RegisterPitBullOptionsMethod(function(group)
	local hostility, petOptions = nil, nil
	if group == "focus" or group:find("target$") then
		hostility = true
	elseif group == "pet" then
		petOptions = true
	end
	return {
		name = L["Full"],
		desc = L["Full bar display options."],
		type = 'group',
		args = {
			enable = {
				type = 'boolean',
				name = L["Enable"],
				desc = L["Enables the full bar."],
				get = getEnabled,
				set = setEnabled,
				passValue = group,
				order = 1,
			},
			classColor = {
				type = 'boolean',
				name = L["Color by class"],
				desc = L["Color the full bar by unit class."],
				get = getClassColor,
				set = setClassColor,
				passValue = group,
				disabled = getDisabled,
			},
			classColorPvP = hostility and {
				type = 'boolean',
				name = L["Color by class for PvP enemies"],
				desc = L["Color the full bar for PvP enemies by unit class."],
				get = getClassColorPvP,
				set = setClassColorPvP,
				passValue = group,
				disabled = getDisabled,
			},
			hostilityColor = hostility and {
				type = 'boolean',
				name = L["Color by hostility"],
				desc = L["Color the full bar by hostility. Note that this takes precedence after color by class."],
				get = getHostilityColor,
				set = setHostilityColor,
				passValue = group,
				disabled = getDisabled,
			},
			hostilityColorNPCs = hostility and {
				type = 'boolean',
				name = L["Color NPCs by hostility"],
				desc = L["Color the full bar by hostility for NPCs. Note that this takes precedence after color by class."],
				get = getHostilityColorNPCs,
				set = setHostilityColorNPCs,
				passValue = group,
				disabled = getDisabled,
			},
			customColor = {
				type = 'group',
				name = L["Custom color"],
				desc = L["Set a custom color for the full bar. Note that this is the least priority after all the color options."],
				args = {
					Enable = {
						type = 'boolean',
						name = L["Enable"],
						desc = L["Enable using a custom color for the full bar."],
						get = GetCustomColorToggle,
						set = SetCustomColorToggle,
						passValue = group,
					},
					setColor = {
						type = 'color',
						name = L["Color"],
						desc = L["Set the custom color for the full bar."],
						get = GetCustomColor,
						set = SetCustomColor,
						disabled = function() return not GetCustomColorToggle(group) end,
						passValue = group,
					},
				},
				passValue = group,
				disabled = getDisabled,
			},
			customTexture = {
				type = 'group',
				name = L["Custom texture"],
				desc = L["Set a custom texture for the full bar."],
				args = {
					Enable = {
						type = 'boolean',
						name = L["Enable"],
						desc = L["Enable using a custom texture for the full bar."],
						get = GetCustomTextureToggle,
						set = SetCustomTextureToggle,
						passValue = group,
					},
					fullBarTexture = {
						name = L["Texture"],
						desc = L["Set the custom texture for the full bar."],
						type = 'choice',
						choices = SharedMedia:List('statusbar'),
						choiceTextures = SharedMedia:HashTable('statusbar'),
						get = GetCustomTexture,
						set = SetCustomTexture,
						disabled = function() return not GetCustomTextureToggle(group) end,
						passValue = group,
					},
				},
				passValue = group,
				disabled = getDisabled,
			},
			happinessColor = petOptions and {
				name = L["Color by happiness"],
				desc = L["Color full bar by pet happiness status."],
				type = 'boolean',
				get = GetPetHappiness,
				set = SetPetHappiness,
				passValue = group,
				disabled = getDisabled,
			},
		}
	}
end)

